/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.testbench.parallel.setup;

import com.vaadin.testbench.TestBench;
import com.vaadin.testbench.TestBenchDriverProxy;
import java.net.URL;
import java.time.Duration;
import java.util.HashMap;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.remote.CommandExecutor;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.remote.HttpCommandExecutor;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.remote.http.HttpClient;

public class RemoteDriver {
    private static final int BROWSER_INIT_ATTEMPTS = 5;

    public WebDriver createDriver(String hubURL, DesiredCapabilities capabilities) throws Exception {
        for (int i = 1; i <= 5; ++i) {
            try {
                HttpClientFactoryDefaultWrapper httpClientFactory = new HttpClientFactoryDefaultWrapper();
                HttpCommandExecutor executor = new HttpCommandExecutor(new HashMap(), new URL(hubURL), (HttpClient.Factory)httpClientFactory);
                TestBenchDriverProxy dr = TestBench.createDriver((WebDriver)new RemoteWebDriver((CommandExecutor)executor, (Capabilities)capabilities));
                return dr;
            }
            catch (Exception e) {
                System.err.println("Browser startup for " + capabilities + " failed on attempt " + i + ": " + e.getMessage());
                if (i != 5) continue;
                throw e;
            }
        }
        return null;
    }

    private static class HttpClientFactoryDefaultWrapper
    implements HttpClient.Factory {
        private final HttpClient.Factory delegate = HttpClient.Factory.createDefault();

        private HttpClientFactoryDefaultWrapper() {
        }

        public HttpClient.Builder builder() {
            return this.delegate.builder().connectionTimeout(Duration.ofSeconds(10L)).readTimeout(Duration.ofMinutes(3L));
        }

        public void cleanupIdleClients() {
            this.delegate.cleanupIdleClients();
        }
    }
}

