/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.testbench;

import com.vaadin.pro.licensechecker.LicenseChecker;
import com.vaadin.testbench.HasDriver;
import com.vaadin.testbench.HasElementQuery;
import com.vaadin.testbench.HasTestBenchCommandExecutor;
import com.vaadin.testbench.Parameters;
import com.vaadin.testbench.RetryRule;
import com.vaadin.testbench.TestBench;
import com.vaadin.testbench.TestBenchDriverProxy;
import com.vaadin.testbench.TestBenchElement;
import com.vaadin.testbench.commands.TestBenchCommandExecutor;
import com.vaadin.testbench.commands.TestBenchCommands;
import java.util.List;
import java.util.Properties;
import org.junit.Rule;
import org.openqa.selenium.BuildInfo;
import org.openqa.selenium.By;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.ExpectedCondition;
import org.openqa.selenium.support.ui.WebDriverWait;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TestBenchTestCase
implements HasDriver,
HasTestBenchCommandExecutor,
HasElementQuery {
    public static final String testbenchVersion;
    @Rule
    public RetryRule maxAttempts = new RetryRule(Parameters.getMaxAttempts());
    protected WebDriver driver;

    private static Logger getLogger() {
        return LoggerFactory.getLogger(TestBenchTestCase.class);
    }

    public TestBenchCommands testBench() {
        return ((TestBenchDriverProxy)this.getDriver()).getCommandExecutor();
    }

    protected String concatUrl(String baseUrl, String uri) {
        if (baseUrl.endsWith("/") && uri.startsWith("/")) {
            return baseUrl + uri.substring(1);
        }
        return baseUrl + uri;
    }

    @Override
    public WebDriver getDriver() {
        return this.driver;
    }

    public void setDriver(WebDriver driver) {
        if (driver != null && !(driver instanceof TestBenchDriverProxy)) {
            driver = TestBench.createDriver(driver);
        }
        this.driver = driver;
    }

    @Override
    public SearchContext getContext() {
        return this.getDriver();
    }

    @Override
    public TestBenchCommandExecutor getCommandExecutor() {
        return ((HasTestBenchCommandExecutor)this.getDriver()).getCommandExecutor();
    }

    public WebElement findElement(By by) {
        return this.getContext().findElement(by);
    }

    public List<WebElement> findElements(By by) {
        return this.getContext().findElements(by);
    }

    public <T extends TestBenchElement> T wrap(Class<T> elementType, WebElement element) {
        return ((TestBenchElement)element).wrap(elementType);
    }

    protected Object executeScript(String script, Object ... args) {
        return this.getCommandExecutor().executeScript(script, args);
    }

    protected <T> T waitUntil(ExpectedCondition<T> condition, long timeoutInSeconds) {
        return (T)new WebDriverWait(this.getDriver(), timeoutInSeconds).until(condition);
    }

    protected <T> T waitUntil(ExpectedCondition<T> condition) {
        return this.waitUntil(condition, 10L);
    }

    static {
        Properties properties = new Properties();
        try {
            properties.load(TestBenchTestCase.class.getResourceAsStream("testbench.properties"));
        }
        catch (Exception e) {
            TestBenchTestCase.getLogger().warn("Unable to read TestBench properties file", (Throwable)e);
            throw new ExceptionInInitializerError(e);
        }
        String seleniumVersion = new BuildInfo().getReleaseLabel();
        testbenchVersion = properties.getProperty("testbench.version");
        String expectedVersion = properties.getProperty("selenium.version");
        if (seleniumVersion == null || !seleniumVersion.equals(expectedVersion)) {
            TestBenchTestCase.getLogger().warn("This version of TestBench depends on Selenium version " + expectedVersion + " but version " + seleniumVersion + " was found. Make sure you do not have multiple versions of Selenium on the classpath.");
        }
        LicenseChecker.checkLicenseFromStaticBlock((String)"vaadin-testbench", (String)testbenchVersion);
    }
}

