/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.testbench.parallel;

import java.util.Arrays;
import java.util.Iterator;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SauceLabsIntegration {
    private static final String SAUCE_USERNAME_ENV = "SAUCE_USERNAME";
    private static final String SAUCE_USERNAME_PROP = "sauce.user";
    private static final String SAUCE_ACCESS_KEY_ENV = "SAUCE_ACCESS_KEY";
    private static final String SAUCE_ACCESS_KEY_PROP = "sauce.sauceAccessKey";

    private static Logger getLogger() {
        return LoggerFactory.getLogger(SauceLabsIntegration.class);
    }

    static void setDesiredCapabilities(DesiredCapabilities desiredCapabilities) {
        String sauceOptions = System.getProperty("sauce.options");
        if (sauceOptions == null || sauceOptions.isEmpty()) {
            SauceLabsIntegration.getLogger().debug("Null or empty sauce.options given. Ignoring.");
            return;
        }
        String tunnelId = SauceLabsIntegration.getTunnelIdentifier(sauceOptions, null);
        if (tunnelId != null) {
            desiredCapabilities.setCapability("tunnelIdentifier", tunnelId);
        }
    }

    static String getTunnelIdentifier(String options, String defaultValue) {
        if (options == null || options.isEmpty()) {
            return defaultValue;
        }
        Iterator<String> tokensIterator = Arrays.asList(options.split(" ")).iterator();
        while (tokensIterator.hasNext()) {
            String currentToken = tokensIterator.next();
            if (!tokensIterator.hasNext() || !currentToken.equals("-i") && !currentToken.equals("--tunnel-identifier")) continue;
            return tokensIterator.next();
        }
        return defaultValue;
    }

    static String getHubUrl() {
        String username = SauceLabsIntegration.getSauceUser();
        String accessKey = SauceLabsIntegration.getSauceAccessKey();
        if (username == null) {
            SauceLabsIntegration.getLogger().debug("You can give a Sauce Labs user name using -Dsauce.user=<username> or by SAUCE_USERNAME environment variable.");
        }
        if (accessKey == null) {
            SauceLabsIntegration.getLogger().debug("You can give a Sauce Labs access key using -Dsauce.sauceAccessKey=<accesskey> or by SAUCE_ACCESS_KEY environment variable.");
        }
        return "http://" + username + ":" + accessKey + "@localhost:4445/wd/hub";
    }

    static boolean isConfiguredForSauceLabs() {
        String user = SauceLabsIntegration.getSauceUser();
        String accessKey = SauceLabsIntegration.getSauceAccessKey();
        return user != null && !user.isEmpty() && accessKey != null && !accessKey.isEmpty();
    }

    static String getSauceUser() {
        return SauceLabsIntegration.getSystemPropertyOrEnv(SAUCE_USERNAME_PROP, SAUCE_USERNAME_ENV);
    }

    static String getSauceAccessKey() {
        return SauceLabsIntegration.getSystemPropertyOrEnv(SAUCE_ACCESS_KEY_PROP, SAUCE_ACCESS_KEY_ENV);
    }

    private static String getSystemPropertyOrEnv(String propertyKey, String envName) {
        String env = System.getenv(envName);
        String prop = System.getProperty(propertyKey);
        return prop != null ? prop : env;
    }

    public static interface CapabilityType {
        public static final String NAME = "name";
    }
}

