/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.testbench.parallel;

import com.vaadin.testbench.Parameters;
import com.vaadin.testbench.ScreenshotOnFailureRule;
import com.vaadin.testbench.TestBenchTestCase;
import com.vaadin.testbench.annotations.BrowserConfiguration;
import com.vaadin.testbench.annotations.RunLocally;
import com.vaadin.testbench.annotations.RunOnHub;
import com.vaadin.testbench.parallel.Browser;
import com.vaadin.testbench.parallel.BrowserUtil;
import com.vaadin.testbench.parallel.ParallelRunner;
import com.vaadin.testbench.parallel.SauceLabsIntegration;
import com.vaadin.testbench.parallel.setup.SetupDriver;
import java.util.Collections;
import java.util.List;
import org.junit.Before;
import org.junit.Rule;
import org.junit.runner.RunWith;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=ParallelRunner.class)
public class ParallelTest
extends TestBenchTestCase {
    @Rule
    public ScreenshotOnFailureRule screenshotOnFailure = new ScreenshotOnFailureRule(this, true);
    private SetupDriver driverConfiguration = new SetupDriver();

    private static Logger getLogger() {
        return LoggerFactory.getLogger(ParallelTest.class);
    }

    protected String getHubURL() {
        if (SauceLabsIntegration.isConfiguredForSauceLabs()) {
            return SauceLabsIntegration.getHubUrl();
        }
        return "http://" + this.getHubHostname() + ":4444/wd/hub";
    }

    protected String getHubHostname() {
        String hubSystemProperty = Parameters.getHubHostname();
        if (hubSystemProperty != null) {
            return hubSystemProperty;
        }
        RunLocally runLocally = this.getClass().getAnnotation(RunLocally.class);
        if (runLocally != null) {
            return "localhost";
        }
        RunOnHub runOnHub = this.getRunOnHub(this.getClass());
        return runOnHub.value();
    }

    @Before
    public void setup() throws Exception {
        if (this.getRunLocallyBrowser() != null) {
            WebDriver driver = this.driverConfiguration.setupLocalDriver(this.getRunLocallyBrowser(), this.getRunLocallyBrowserVersion());
            this.setDriver(driver);
        } else if (Parameters.isLocalWebDriverUsed()) {
            WebDriver driver = this.driverConfiguration.setupLocalDriver();
            this.setDriver(driver);
        } else if (SauceLabsIntegration.isConfiguredForSauceLabs()) {
            WebDriver driver = this.driverConfiguration.setupRemoteDriver(this.getHubURL());
            this.setDriver(driver);
        } else if (this.getRunOnHub(this.getClass()) != null || Parameters.getHubHostname() != null) {
            WebDriver driver = this.driverConfiguration.setupRemoteDriver(this.getHubURL());
            this.setDriver(driver);
        } else {
            ParallelTest.getLogger().info("Did not find a configuration to run locally, on Sauce Labs or on other test grid. Falling back to running locally on Chrome.");
            WebDriver driver = this.driverConfiguration.setupLocalDriver(Browser.CHROME);
            this.setDriver(driver);
        }
    }

    protected RunOnHub getRunOnHub(Class<?> klass) {
        if (klass == null) {
            return null;
        }
        return klass.getAnnotation(RunOnHub.class);
    }

    protected Browser getRunLocallyBrowser() {
        return ParallelRunner.getRunLocallyBrowserName(this.getClass());
    }

    protected String getRunLocallyBrowserVersion() {
        return ParallelRunner.getRunLocallyBrowserVersion(this.getClass());
    }

    public static List<DesiredCapabilities> getDefaultCapabilities() {
        return Collections.singletonList(BrowserUtil.chrome());
    }

    public void setDesiredCapabilities(DesiredCapabilities desiredCapabilities) {
        if (SauceLabsIntegration.isConfiguredForSauceLabs()) {
            SauceLabsIntegration.setDesiredCapabilities(desiredCapabilities);
        }
        this.driverConfiguration.setDesiredCapabilities(desiredCapabilities);
    }

    @BrowserConfiguration
    List<DesiredCapabilities> getBrowserConfigurationFromParameterOrDefault() {
        if (Parameters.getGridBrowsers().isEmpty()) {
            return ParallelTest.getDefaultCapabilities();
        }
        return Parameters.getGridBrowsers();
    }

    protected DesiredCapabilities getDesiredCapabilities() {
        return this.driverConfiguration.getDesiredCapabilities();
    }
}

