/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.testbench.parallel;

import com.vaadin.testbench.Parameters;
import com.vaadin.testbench.annotations.BrowserConfiguration;
import com.vaadin.testbench.annotations.BrowserFactory;
import com.vaadin.testbench.annotations.RunLocally;
import com.vaadin.testbench.parallel.Browser;
import com.vaadin.testbench.parallel.BrowserUtil;
import com.vaadin.testbench.parallel.DefaultBrowserFactory;
import com.vaadin.testbench.parallel.ParallelScheduler;
import com.vaadin.testbench.parallel.ParallelTest;
import com.vaadin.testbench.parallel.SauceLabsIntegration;
import com.vaadin.testbench.parallel.TestBenchBrowserFactory;
import com.vaadin.testbench.parallel.TestCategory;
import com.vaadin.testbench.parallel.TestNameSuffix;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParallelRunner
extends BlockJUnit4ClassRunner {
    private static final int MAX_CONCURRENT_TESTS = Parameters.getTestsInParallel();
    private static final ExecutorService service = Executors.newFixedThreadPool(MAX_CONCURRENT_TESTS);

    private static Logger getLogger() {
        return LoggerFactory.getLogger(ParallelRunner.class);
    }

    public ParallelRunner(Class<?> klass) throws InitializationError {
        super(klass);
        this.setScheduler(new ParallelScheduler(service));
    }

    protected List<FrameworkMethod> computeTestMethods() {
        LinkedList<FrameworkMethod> tests = new LinkedList<FrameworkMethod>();
        if (!ParallelTest.class.isAssignableFrom(this.getTestClass().getJavaClass())) {
            throw new RuntimeException(((Object)((Object)this)).getClass().getName() + " only supports " + ParallelTest.class.getName());
        }
        BrowserUtil.setBrowserFactory(this.getBrowserFactory());
        try {
            Collection<DesiredCapabilities> desiredCapabilities = this.getDesiredCapabilities();
            TestNameSuffix testNameSuffixProperty = this.findAnnotation(this.getTestClass().getJavaClass(), TestNameSuffix.class);
            for (FrameworkMethod m : this.getTestMethods()) {
                if (desiredCapabilities.size() <= 0 || this.categoryIsExcludedOrNotExcplicitlyIncluded()) {
                    tests.add(new IgnoredTestMethod(m.getMethod()));
                    continue;
                }
                for (DesiredCapabilities capabilities : desiredCapabilities) {
                    DesiredCapabilities methodCapabilities = new DesiredCapabilities((Capabilities)capabilities);
                    TBMethod method = new TBMethod(m.getMethod(), methodCapabilities);
                    if (testNameSuffixProperty != null) {
                        method.setTestNameSuffix("-" + System.getProperty(testNameSuffixProperty.property()));
                    }
                    if (SauceLabsIntegration.isConfiguredForSauceLabs()) {
                        SauceLabsIntegration.setSauceLabsOption(methodCapabilities, "name", method.getName());
                    }
                    tests.add(method);
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error retrieving browsers to run on", e);
        }
        return tests;
    }

    private boolean categoryIsExcludedOrNotExcplicitlyIncluded() {
        Class c = this.getTestClass().getJavaClass();
        if (ParallelRunner.categoryIsExcluded(c)) {
            return true;
        }
        if (ParallelRunner.explicitInclusionIsUsed()) {
            return !this.categoryIsIncluded(c);
        }
        return false;
    }

    private boolean categoryIsIncluded(Class<?> c) {
        String include = System.getProperty("categories.include");
        if (include != null && include.trim().length() > 0) {
            return ParallelRunner.hasCategoryFor(c, include.toLowerCase().trim());
        }
        return false;
    }

    private static boolean explicitInclusionIsUsed() {
        String include = System.getProperty("categories.include");
        return include != null && include.trim().length() > 0;
    }

    private static boolean categoryIsExcluded(Class<?> c) {
        String exclude = System.getProperty("categories.exclude");
        if (exclude != null && exclude.trim().length() > 0) {
            return ParallelRunner.hasCategoryFor(c, exclude.toLowerCase().trim());
        }
        return false;
    }

    private static boolean hasCategoryFor(Class<?> c, String searchString) {
        if (ParallelRunner.hasCategory(c)) {
            return searchString.contains(ParallelRunner.getCategory(c).toLowerCase());
        }
        return false;
    }

    private static boolean hasCategory(Class<?> c) {
        return c.getAnnotation(TestCategory.class) != null;
    }

    private static String getCategory(Class<?> c) {
        return c.getAnnotation(TestCategory.class).value();
    }

    private List<FrameworkMethod> getTestMethods() {
        return this.getTestClass().getAnnotatedMethods(Test.class);
    }

    private Collection<DesiredCapabilities> getDesiredCapabilities() {
        if (this.testRunsLocally()) {
            ArrayList<DesiredCapabilities> desiredCapabilities = new ArrayList<DesiredCapabilities>();
            Class javaTestClass = this.getTestClass().getJavaClass();
            desiredCapabilities.add(BrowserUtil.getBrowserFactory().create(ParallelRunner.getRunLocallyBrowserName(javaTestClass), ParallelRunner.getRunLocallyBrowserVersion(javaTestClass)));
            return desiredCapabilities;
        }
        return this.getFilteredCapabilities();
    }

    private boolean testRunsLocally() {
        if (Parameters.getRunLocallyBrowserName() != null) {
            return true;
        }
        RunLocally runLocally = this.getTestClass().getJavaClass().getAnnotation(RunLocally.class);
        return runLocally != null;
    }

    static Browser getRunLocallyBrowserName(Class<?> testClass) {
        String runLocallyBrowserName = Parameters.getRunLocallyBrowserName();
        if (runLocallyBrowserName != null) {
            return Browser.valueOf(runLocallyBrowserName.toUpperCase());
        }
        RunLocally runLocally = testClass.getAnnotation(RunLocally.class);
        if (runLocally == null) {
            return null;
        }
        return runLocally.value();
    }

    static String getRunLocallyBrowserVersion(Class<?> testClass) {
        String runLocallyBrowserVersion = Parameters.getRunLocallyBrowserVersion();
        if (runLocallyBrowserVersion != null) {
            return runLocallyBrowserVersion;
        }
        RunLocally runLocally = testClass.getAnnotation(RunLocally.class);
        if (runLocally == null) {
            return "";
        }
        return runLocally.version();
    }

    private TestBenchBrowserFactory getBrowserFactory() {
        BrowserFactory browserFactoryAnnotation = this.getTestClass().getJavaClass().getAnnotation(BrowserFactory.class);
        try {
            if (browserFactoryAnnotation != null && TestBenchBrowserFactory.class.isAssignableFrom(browserFactoryAnnotation.value())) {
                return (TestBenchBrowserFactory)browserFactoryAnnotation.value().newInstance();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new DefaultBrowserFactory();
    }

    private Collection<DesiredCapabilities> getFilteredCapabilities() {
        Collection<DesiredCapabilities> desiredCapabilites = this.getBrowsersConfiguration();
        ArrayList<DesiredCapabilities> filteredCapabilities = new ArrayList<DesiredCapabilities>();
        String include = System.getProperty("browsers.include");
        String exclude = System.getProperty("browsers.exclude");
        for (DesiredCapabilities d : desiredCapabilites) {
            String browserName = (d.getBrowserName() + d.getBrowserVersion()).toLowerCase();
            if (include != null && include.trim().length() > 0) {
                if (include.trim().toLowerCase().contains(browserName)) {
                    filteredCapabilities.add(d);
                }
            } else {
                filteredCapabilities.add(d);
            }
            if (exclude == null || exclude.trim().length() <= 0 || !exclude.trim().toLowerCase().contains(browserName)) continue;
            filteredCapabilities.remove(d);
        }
        return filteredCapabilities;
    }

    private Collection<DesiredCapabilities> getBrowsersConfiguration() {
        block2: for (Class klass = this.getTestClass().getJavaClass(); klass != null; klass = klass.getSuperclass()) {
            Method[] declaredMethods;
            for (Method method : declaredMethods = klass.getDeclaredMethods()) {
                if (!method.isAnnotationPresent(BrowserConfiguration.class)) continue;
                boolean methodSignatureIsValid = this.validateBrowserConfigurationAnnotatedSignature(method);
                if (!methodSignatureIsValid) continue block2;
                try {
                    return (Collection)method.invoke((Object)this.getTestClassInstance(), new Object[0]);
                }
                catch (Exception e) {
                    String errMsg = String.format("Error occurred while invoking BrowserConfiguration method %s.%s(). Method was ignored, searching BrowserConfiguration method in superclasses", method.getDeclaringClass().getName(), method.getName());
                    ParallelRunner.getLogger().info(errMsg, (Throwable)e);
                    continue block2;
                }
            }
        }
        return ParallelTest.getDefaultCapabilities();
    }

    private boolean validateBrowserConfigurationAnnotatedSignature(Method method) {
        String genericErrorMessage = "Error occurred while invoking BrowserConfigurationMethod %s.%s(). %s. Method was ignored, searching BrowserConfiguration method in superclasses";
        if (method.getParameterTypes().length != 0) {
            String errMsg = String.format(genericErrorMessage, method.getDeclaringClass().getName(), method.getName(), "BrowserConfiguration annotated method must not require any arguments");
            ParallelRunner.getLogger().info(errMsg);
            return false;
        }
        if (!Collection.class.isAssignableFrom(method.getReturnType())) {
            String errMsg = String.format(genericErrorMessage, method.getDeclaringClass().getName(), method.getName(), "BrowserConfiguration annotated method must return a Collection<DesiredCapabilities>");
            ParallelRunner.getLogger().info(errMsg);
            return false;
        }
        return true;
    }

    private ParallelTest getTestClassInstance() throws InstantiationException, IllegalAccessException, InvocationTargetException {
        ParallelTest testClassInstance = (ParallelTest)this.getTestClass().getOnlyConstructor().newInstance(new Object[0]);
        return testClassInstance;
    }

    private <T extends Annotation> T findAnnotation(Class<?> searchClass, Class<T> annotationClass) {
        if (searchClass == Object.class) {
            return null;
        }
        if (searchClass.getAnnotation(annotationClass) != null) {
            return searchClass.getAnnotation(annotationClass);
        }
        return this.findAnnotation(searchClass.getSuperclass(), annotationClass);
    }

    protected Statement withBefores(FrameworkMethod method, final Object target, Statement statement) {
        if (!(method instanceof TBMethod)) {
            throw new RuntimeException("Unexpected method type " + method.getClass().getName() + ", expected TBMethod");
        }
        final TBMethod tbmethod = (TBMethod)method;
        final Statement realBefores = super.withBefores(method, target, statement);
        return new Statement(){

            public void evaluate() throws Throwable {
                ((ParallelTest)target).setDesiredCapabilities(tbmethod.capabilities);
                realBefores.evaluate();
            }
        };
    }

    public static class TBMethod
    extends FrameworkMethod {
        private final DesiredCapabilities capabilities;
        private String testNameSuffix = "";

        public TBMethod(Method method, DesiredCapabilities capabilities) {
            super(method);
            this.capabilities = capabilities;
        }

        public DesiredCapabilities getCapabilities() {
            return this.capabilities;
        }

        public void setTestNameSuffix(String testNameSuffix) {
            this.testNameSuffix = testNameSuffix;
        }

        public Object invokeExplosively(Object target, Object ... params) throws Throwable {
            return super.invokeExplosively(target, new Object[0]);
        }

        public String getName() {
            return String.format("%s[%s]", this.getMethod().getName() + this.testNameSuffix, TBMethod.getUniqueIdentifier((Capabilities)this.capabilities));
        }

        public boolean equals(Object obj) {
            if (!TBMethod.class.isInstance(obj)) {
                return false;
            }
            return ((TBMethod)((Object)obj)).capabilities.equals((Object)this.capabilities) && super.equals(obj);
        }

        private static String getUniqueIdentifier(Capabilities capabilities) {
            String platform = BrowserUtil.getPlatform(capabilities);
            String browser = BrowserUtil.getBrowserIdentifier(capabilities);
            String version = capabilities == null ? "Unknown" : capabilities.getBrowserVersion();
            return platform + "_" + browser + "_" + version;
        }
    }

    private class IgnoredTestMethod
    extends FrameworkMethod {
        public IgnoredTestMethod(Method method) {
            super(method);
        }

        public Annotation[] getAnnotations() {
            return this.getIgnoredTestMethod().getAnnotations();
        }

        private Method getIgnoredTestMethod() {
            try {
                return IgnoreTestAnnotations.class.getMethod("ignoredTest", null);
            }
            catch (Exception e) {
                return null;
            }
        }

        public <T extends Annotation> T getAnnotation(Class<T> annotationType) {
            return this.getIgnoredTestMethod().getAnnotation(annotationType);
        }

        private class IgnoreTestAnnotations {
            private IgnoreTestAnnotations() {
            }

            @Ignore
            @Test
            public void ignoredTest() {
            }
        }
    }
}

