/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.testbench.parallel;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.junit.runners.model.RunnerScheduler;

public class ParallelScheduler
implements RunnerScheduler {
    private final List<Future<Object>> fResults = new ArrayList<Future<Object>>();
    private ExecutorService fService;

    public ParallelScheduler(ExecutorService service) {
        this.fService = service;
    }

    public void schedule(final Runnable childStatement) {
        this.fResults.add(this.fService.submit(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                childStatement.run();
                return null;
            }
        }));
    }

    public void finished() {
        for (Future<Object> each : this.fResults) {
            try {
                each.get();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

