/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.testbench;

import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.internal.AssumptionViolatedException;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetryRule
implements TestRule {
    private int maxAttempts;

    public RetryRule(int maxAttempts) {
        this.maxAttempts = maxAttempts;
    }

    public int getMaxAttempts() {
        return this.maxAttempts;
    }

    public Statement apply(Statement base, Description description) {
        if (this.maxAttempts > 1) {
            return this.statement(base, description);
        }
        return base;
    }

    private Statement statement(final Statement base, final Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                ArrayList<Throwable> caughtThrowables = new ArrayList<Throwable>();
                for (int i = 0; i < RetryRule.this.maxAttempts; ++i) {
                    try {
                        base.evaluate();
                        return;
                    }
                    catch (AssumptionViolatedException t2) {
                        throw t2;
                    }
                    catch (Throwable t3) {
                        caughtThrowables.add(t3);
                        continue;
                    }
                }
                String testDisplayName = description.getDisplayName();
                Logger logger = LoggerFactory.getLogger(RetryRule.class);
                if (logger.isDebugEnabled() && caughtThrowables.size() > 1) {
                    logger.debug("Caught {} exceptions for {} test", (Object)caughtThrowables.size(), (Object)testDisplayName);
                    AtomicInteger attempt = new AtomicInteger();
                    caughtThrowables.forEach(t -> logger.debug("\t{} [attempt {}]: {}", new Object[]{testDisplayName, attempt.incrementAndGet(), t.getMessage(), t}));
                }
                Throwable lastCaught = (Throwable)caughtThrowables.get(caughtThrowables.size() - 1);
                String errorMessage = String.format("%s: run failed %s times", testDisplayName, RetryRule.this.maxAttempts);
                throw new RuntimeException(errorMessage, lastCaught);
            }
        };
    }
}

