/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.testbench.parallel;

import com.vaadin.testbench.parallel.Browser;
import com.vaadin.testbench.parallel.TestBenchBrowserFactory;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.Platform;
import org.openqa.selenium.chrome.ChromeOptions;
import org.openqa.selenium.edge.EdgeOptions;
import org.openqa.selenium.firefox.FirefoxOptions;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.safari.SafariOptions;

public class DefaultBrowserFactory
implements TestBenchBrowserFactory {
    @Override
    public DesiredCapabilities create(Browser browser) {
        return this.create(browser, "", Platform.ANY);
    }

    @Override
    public DesiredCapabilities create(Browser browser, String version) {
        return this.create(browser, version, Platform.ANY);
    }

    @Override
    public DesiredCapabilities create(Browser browser, String version, Platform platform) {
        ChromeOptions desiredCapabilities = switch (browser) {
            case Browser.CHROME -> new ChromeOptions();
            case Browser.SAFARI -> new SafariOptions();
            case Browser.EDGE -> new EdgeOptions();
            default -> new FirefoxOptions();
        };
        if (version != null && !version.isEmpty()) {
            desiredCapabilities.setCapability("browserVersion", version);
        }
        if (platform != null) {
            desiredCapabilities.setCapability("platformName", platform);
        }
        return new DesiredCapabilities((Capabilities)desiredCapabilities);
    }
}

