/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.testbench.parallel;

import com.vaadin.testbench.parallel.Browser;
import com.vaadin.testbench.parallel.DefaultBrowserFactory;
import com.vaadin.testbench.parallel.TestBenchBrowserFactory;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.Platform;
import org.openqa.selenium.remote.DesiredCapabilities;

public class BrowserUtil {
    private static TestBenchBrowserFactory browserFactory = new DefaultBrowserFactory();

    public static DesiredCapabilities safari() {
        DesiredCapabilities c = browserFactory.create(Browser.SAFARI);
        return c;
    }

    public static DesiredCapabilities chrome() {
        DesiredCapabilities c = browserFactory.create(Browser.CHROME);
        return c;
    }

    public static DesiredCapabilities firefox() {
        DesiredCapabilities c = browserFactory.create(Browser.FIREFOX);
        return c;
    }

    public static DesiredCapabilities edge() {
        DesiredCapabilities c = browserFactory.create(Browser.EDGE);
        return c;
    }

    public static boolean isEdge(Capabilities capabilities) {
        if (capabilities == null) {
            return false;
        }
        return org.openqa.selenium.remote.Browser.EDGE.is(capabilities);
    }

    public static boolean isChrome(Capabilities capabilities) {
        if (capabilities == null) {
            return false;
        }
        return org.openqa.selenium.remote.Browser.CHROME.is(capabilities);
    }

    public static boolean isSafari(Capabilities capabilities) {
        if (capabilities == null) {
            return false;
        }
        return org.openqa.selenium.remote.Browser.SAFARI.is(capabilities);
    }

    public static boolean isFirefox(Capabilities capabilities) {
        if (capabilities == null) {
            return false;
        }
        return org.openqa.selenium.remote.Browser.FIREFOX.is(capabilities);
    }

    public static String getBrowserIdentifier(Capabilities capabilities) {
        if (BrowserUtil.isFirefox(capabilities)) {
            return "Firefox";
        }
        if (BrowserUtil.isChrome(capabilities)) {
            return "Chrome";
        }
        if (BrowserUtil.isSafari(capabilities)) {
            return "Safari";
        }
        if (BrowserUtil.isEdge(capabilities)) {
            return "Edge";
        }
        if (capabilities == null) {
            return "Unknown";
        }
        return capabilities.getBrowserName();
    }

    public static String getPlatform(Capabilities capabilities) {
        if (capabilities == null) {
            return "Unknown";
        }
        try {
            Platform family;
            Platform p = capabilities.getPlatformName();
            Platform platform = family = p != null ? p.family() : null;
            if (family == Platform.WINDOWS || p == Platform.WINDOWS) {
                return "Windows";
            }
            if (family == Platform.MAC || p == Platform.MAC) {
                return "Mac";
            }
        }
        catch (Exception p) {
            // empty catch block
        }
        Object rawPlatform = capabilities.getCapability("platformName");
        if (rawPlatform == null) {
            return "Unknown";
        }
        return rawPlatform.toString();
    }

    public static void setBrowserFactory(TestBenchBrowserFactory browserFactory) {
        BrowserUtil.browserFactory = browserFactory;
    }

    public static TestBenchBrowserFactory getBrowserFactory() {
        return browserFactory;
    }
}

