/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.checkbox;

import com.vaadin.flow.component.ClickEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.ComponentUtil;
import com.vaadin.flow.component.checkbox.Checkbox;
import com.vaadin.testbench.unit.ComponentTester;
import com.vaadin.testbench.unit.Tests;
import java.util.function.Consumer;

@Tests(value={Checkbox.class})
public class CheckboxTester<T extends Checkbox>
extends ComponentTester<T> {
    public CheckboxTester(T component) {
        super(component);
    }

    @Override
    public boolean isUsable() {
        return super.isUsable() && !((Checkbox)this.getComponent()).isReadOnly() && !((Checkbox)this.getComponent()).isDisabledBoolean();
    }

    @Override
    protected void notUsableReasons(Consumer<String> collector) {
        super.notUsableReasons(collector);
        if (((Checkbox)this.getComponent()).isReadOnly()) {
            collector.accept("read only");
        }
        if (((Checkbox)this.getComponent()).isDisabledBoolean()) {
            collector.accept("disabled");
        }
    }

    public void click() {
        this.ensureComponentIsUsable();
        Checkbox checkbox = (Checkbox)this.getComponent();
        ComponentUtil.fireEvent((Component)checkbox, (ComponentEvent)new ClickEvent((Component)checkbox, true, 0, 0, 0, 0, 0, 0, false, false, false, false));
        checkbox.setValue((Object)((Boolean)checkbox.getValue() == false ? 1 : 0));
    }
}

