/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.upload;

import com.vaadin.flow.component.upload.MultiFileReceiver;
import com.vaadin.flow.component.upload.Upload;
import com.vaadin.flow.server.StreamVariable;
import com.vaadin.flow.server.communication.streaming.StreamingEndEventImpl;
import com.vaadin.flow.server.communication.streaming.StreamingErrorEventImpl;
import com.vaadin.flow.server.communication.streaming.StreamingStartEventImpl;
import com.vaadin.testbench.unit.ComponentTester;
import com.vaadin.testbench.unit.Tests;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URLConnection;
import java.nio.file.Files;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.stream.Collectors;

@Tests(value={Upload.class})
public class UploadTester<T extends Upload>
extends ComponentTester<T> {
    public UploadTester(T component) {
        super(component);
    }

    public void upload(String fileName, String contentType, InputStream contents) {
        this.doUpload(List.of(new UploadItem(fileName, contentType, contents::readAllBytes)));
    }

    public void upload(String fileName, String contentType, byte[] contents) {
        this.doUpload(List.of(new UploadItem(fileName, contentType, () -> contents)));
    }

    public void upload(File file) {
        this.doUpload(List.of(new UploadItem(file.getName(), URLConnection.guessContentTypeFromName(file.getName()), () -> Files.readAllBytes(file.toPath()))));
    }

    public void uploadAll(File ... files) {
        this.uploadAll(List.of(files));
    }

    public void uploadAll(Collection<File> files) {
        if (!(((Upload)this.getComponent()).getReceiver() instanceof MultiFileReceiver)) {
            throw new IllegalStateException("Upload component is not configured with a MultiFileReceiver");
        }
        if (files.isEmpty()) {
            throw new IllegalArgumentException("At least one file must be provided");
        }
        this.doUpload(files.stream().map(f -> new UploadItem(f.getName(), URLConnection.guessContentTypeFromName(f.getName()), () -> Files.readAllBytes(f.toPath()))).collect(Collectors.toList()));
    }

    public void uploadAborted(String fileName, String contentType) {
        this.doFailUpload(fileName, contentType);
    }

    public void uploadAborted(File file) {
        this.doFailUpload(file.getName(), URLConnection.guessContentTypeFromName(file.getName()));
    }

    public void uploadFailed(File file) {
        this.doFailUpload(file.getName(), URLConnection.guessContentTypeFromName(file.getName()));
    }

    public void uploadFailed(String fileName, String contentType) {
        this.doFailUpload(fileName, contentType);
    }

    private void fireAllFinish() {
        try {
            this.getMethod("fireAllFinish", new Class[0]).invoke(this.getComponent(), new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doFailUpload(String fileName, String contentType) {
        this.ensureComponentIsUsable();
        StreamVariable streamVariable = this.getGetStreamVariable();
        try {
            streamVariable.streamingStarted((StreamVariable.StreamingStartEvent)new StreamingStartEventImpl(fileName, contentType, 0L));
            streamVariable.streamingFailed((StreamVariable.StreamingErrorEvent)new StreamingErrorEventImpl(fileName, contentType, 0L, 0L, null));
        }
        finally {
            this.fireAllFinish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doUpload(Collection<UploadItem> items) {
        this.ensureComponentIsUsable();
        try {
            StreamVariable streamVariable = this.getGetStreamVariable();
            AtomicReference errorCollector = new AtomicReference();
            List<StreamVariable.StreamingEvent> events = items.stream().map(item -> this.doUpload(streamVariable, (UploadItem)item, ex -> errorCollector.compareAndSet(null, ex))).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
            events.forEach(ev -> this.handleUploadResult(streamVariable, (StreamVariable.StreamingEvent)ev));
            Exception ex = (Exception)errorCollector.get();
            if (ex instanceof RuntimeException) {
                throw (RuntimeException)ex;
            }
            if (ex instanceof IOException) {
                throw new UncheckedIOException((IOException)ex);
            }
            if (ex != null) {
                throw new RuntimeException(ex);
            }
        }
        finally {
            this.fireAllFinish();
        }
    }

    private Optional<StreamVariable.StreamingEvent> doUpload(StreamVariable streamVariable, UploadItem item, Consumer<Exception> errorHandler) {
        byte[] contents;
        String fileName = item.fileName;
        String contentType = item.contentType;
        Callable<byte[]> contentsProducer = item.contentsProducer;
        try {
            contents = contentsProducer.call();
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
        catch (Exception ex) {
            throw new UncheckedIOException(new IOException(ex));
        }
        Objects.requireNonNull(contents, "file contents cannot be null");
        try {
            streamVariable.streamingStarted((StreamVariable.StreamingStartEvent)new StreamingStartEventImpl(fileName, contentType, (long)contents.length));
            streamVariable.getOutputStream().write(contents);
            return Optional.of(new StreamingEndEventImpl(fileName, contentType, (long)contents.length));
        }
        catch (IOException ex) {
            errorHandler.accept(ex);
        }
        catch (Exception ex) {
            errorHandler.accept(ex);
            return Optional.of(new StreamingErrorEventImpl(fileName, contentType, (long)contents.length, 0L, ex));
        }
        return Optional.empty();
    }

    private void handleUploadResult(StreamVariable streamVariable, StreamVariable.StreamingEvent event) {
        if (event instanceof StreamVariable.StreamingErrorEvent) {
            streamVariable.streamingFailed((StreamVariable.StreamingErrorEvent)event);
        } else if (event instanceof StreamVariable.StreamingEndEvent) {
            streamVariable.streamingFinished((StreamVariable.StreamingEndEvent)event);
        }
    }

    private StreamVariable getGetStreamVariable() {
        try {
            return (StreamVariable)this.getMethod("getStreamVariable", new Class[0]).invoke(this.getComponent(), new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private static class UploadItem {
        private final String fileName;
        private final String contentType;
        private final Callable<byte[]> contentsProducer;

        UploadItem(String fileName, String contentType, Callable<byte[]> contentsProducer) {
            this.fileName = Objects.requireNonNull(fileName, "fileName cannot be null");
            this.contentType = contentType;
            this.contentsProducer = Objects.requireNonNull(contentsProducer, "content producers cannot be null");
        }
    }
}

