/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.testbench.unit.internal;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentUtil;
import com.vaadin.flow.dom.ClassList;
import com.vaadin.flow.dom.DomEvent;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.dom.ElementUtil;
import com.vaadin.flow.internal.StateNode;
import com.vaadin.flow.internal.nodefeature.ElementListenerMap;
import com.vaadin.flow.internal.nodefeature.VirtualChildrenList;
import com.vaadin.testbench.unit.internal.ElementUtilsKt;
import com.vaadin.testbench.unit.internal.UtilsKt;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.TextNode;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000:\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0010\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e*\u00020\u0001\u001a\u0012\u0010\u0010\u001a\u00020\u0011*\u00020\u00012\u0006\u0010\u0012\u001a\u00020\u0013\u001a\u0012\u0010\u0014\u001a\u00020\u0011*\u00020\u00012\u0006\u0010\u0015\u001a\u00020\u0006\u001a\u0018\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00010\u000e*\u00020\u00012\u0006\u0010\u0015\u001a\u00020\u0006\u001a\u0010\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00010\u000e*\u00020\u0001\u001a\u001a\u0010\u0018\u001a\u00020\u0011*\u00020\u00012\u0006\u0010\u0019\u001a\u00020\u00012\u0006\u0010\u001a\u001a\u00020\u0001\u001a\u001c\u0010\u001b\u001a\u00020\u0011*\u00020\u00012\u0006\u0010\u001c\u001a\u00020\u00062\b\u0010\u001d\u001a\u0004\u0018\u00010\u0006\u001a\u0012\u0010\u001e\u001a\u00020\u0011*\u00020\u001f2\u0006\u0010 \u001a\u00020\u0006\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u0015\u0010\u0005\u001a\u00020\u0006*\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\"\u0015\u0010\n\u001a\u00020\u0006*\u00020\u00018F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006!"}, d2={"element", "Lcom/vaadin/flow/dom/Element;", "Lcom/vaadin/flow/internal/StateNode;", "getElement", "(Lcom/vaadin/flow/internal/StateNode;)Lcom/vaadin/flow/dom/Element;", "textRecursively", "", "Lorg/jsoup/nodes/Node;", "getTextRecursively", "(Lorg/jsoup/nodes/Node;)Ljava/lang/String;", "textRecursively2", "getTextRecursively2", "(Lcom/vaadin/flow/dom/Element;)Ljava/lang/String;", "_findComponents", "", "Lcom/vaadin/flow/component/Component;", "_fireDomEvent", "", "event", "Lcom/vaadin/flow/dom/DomEvent;", "clearSlot", "slotName", "getChildrenInSlot", "getVirtualChildren", "insertBefore", "newNode", "existingNode", "setOrRemoveAttribute", "attribute", "value", "toggle", "Lcom/vaadin/flow/dom/ClassList;", "className", "vaadin-testbench-unit-shared"})
@SourceDebugExtension(value={"SMAP\nElementUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ElementUtils.kt\ncom/vaadin/testbench/unit/internal/ElementUtilsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,127:1\n1#2:128\n1855#3,2:129\n*S KotlinDebug\n*F\n+ 1 ElementUtils.kt\ncom/vaadin/testbench/unit/internal/ElementUtilsKt\n*L\n105#1:129,2\n*E\n"})
public final class ElementUtilsKt {
    public static final void setOrRemoveAttribute(@NotNull Element $this$setOrRemoveAttribute, @NotNull String attribute, @Nullable String value) {
        Intrinsics.checkNotNullParameter((Object)$this$setOrRemoveAttribute, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)attribute, (String)"attribute");
        if (value == null) {
            $this$setOrRemoveAttribute.removeAttribute(attribute);
        } else {
            $this$setOrRemoveAttribute.setAttribute(attribute, value);
        }
    }

    public static final void toggle(@NotNull ClassList $this$toggle, @NotNull String className) {
        Intrinsics.checkNotNullParameter((Object)$this$toggle, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        if (!(!UtilsKt.containsWhitespace(className))) {
            boolean bl = false;
            String string = '\'' + className + "' cannot contain whitespace";
            throw new IllegalArgumentException(string.toString());
        }
        $this$toggle.set(className, !$this$toggle.contains((Object)className));
    }

    public static final void insertBefore(@NotNull Element $this$insertBefore, @NotNull Element newNode, @NotNull Element existingNode) {
        Intrinsics.checkNotNullParameter((Object)$this$insertBefore, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)newNode, (String)"newNode");
        Intrinsics.checkNotNullParameter((Object)existingNode, (String)"existingNode");
        Element element = existingNode.getParent();
        if (element == null) {
            boolean $i$a$-requireNotNull-ElementUtilsKt$insertBefore$parent$22 = false;
            String $i$a$-requireNotNull-ElementUtilsKt$insertBefore$parent$22 = existingNode + " has no parent element";
            throw new IllegalArgumentException($i$a$-requireNotNull-ElementUtilsKt$insertBefore$parent$22.toString());
        }
        Element parent = element;
        if (!Intrinsics.areEqual((Object)parent, (Object)$this$insertBefore)) {
            boolean bl = false;
            String string = existingNode + " is not nested in " + $this$insertBefore;
            throw new IllegalArgumentException(string.toString());
        }
        Element[] elementArray = new Element[]{newNode};
        $this$insertBefore.insertChild($this$insertBefore.indexOfChild(existingNode), elementArray);
    }

    @NotNull
    public static final String getTextRecursively2(@NotNull Element $this$textRecursively2) {
        Intrinsics.checkNotNullParameter((Object)$this$textRecursively2, (String)"<this>");
        Node node = ElementUtil.toJsoup((Document)new Document(""), (Element)$this$textRecursively2);
        Intrinsics.checkNotNull((Object)node);
        return ElementUtilsKt.getTextRecursively(node);
    }

    @NotNull
    public static final String getTextRecursively(@NotNull Node $this$textRecursively) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$textRecursively, (String)"<this>");
        if ($this$textRecursively instanceof TextNode) {
            String string2 = ((TextNode)$this$textRecursively).text();
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"text(...)");
        } else {
            List list = $this$textRecursively.childNodes();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"childNodes(...)");
            string = CollectionsKt.joinToString$default((Iterable)list, (CharSequence)"", null, null, (int)0, null, (Function1)textRecursively.1.INSTANCE, (int)30, null);
        }
        return string;
    }

    @NotNull
    public static final List<Element> getVirtualChildren(@NotNull Element $this$getVirtualChildren) {
        VirtualChildrenList virtualChildrenList;
        Intrinsics.checkNotNullParameter((Object)$this$getVirtualChildren, (String)"<this>");
        if ($this$getVirtualChildren.getNode().hasFeature(VirtualChildrenList.class) && (virtualChildrenList = (VirtualChildrenList)$this$getVirtualChildren.getNode().getFeatureIfInitialized(VirtualChildrenList.class).orElse(null)) != null) {
            Iterator iterator = virtualChildrenList.iterator();
            Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"iterator(...)");
            return SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.asSequence((Iterator)iterator), (Function1)getVirtualChildren.1.INSTANCE));
        }
        return CollectionsKt.emptyList();
    }

    @NotNull
    public static final Element getElement(@NotNull StateNode $this$element) {
        Intrinsics.checkNotNullParameter((Object)$this$element, (String)"<this>");
        Element element = Element.get((StateNode)$this$element);
        Intrinsics.checkNotNullExpressionValue((Object)element, (String)"get(...)");
        return element;
    }

    @NotNull
    public static final List<Element> getChildrenInSlot(@NotNull Element $this$getChildrenInSlot, @NotNull String slotName) {
        Intrinsics.checkNotNullParameter((Object)$this$getChildrenInSlot, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)slotName, (String)"slotName");
        List<Object> list = $this$getChildrenInSlot.getChildren().filter(arg_0 -> ElementUtilsKt.getChildrenInSlot$lambda$3((Function1)new Function1<Element, Boolean>(slotName){
            final /* synthetic */ String $slotName;
            {
                this.$slotName = $slotName;
                super(1);
            }

            @NotNull
            public final Boolean invoke(Element child) {
                return Intrinsics.areEqual((Object)child.getAttribute("slot"), (Object)this.$slotName);
            }
        }, arg_0)).toList();
        Intrinsics.checkNotNullExpressionValue(list, (String)"toList(...)");
        return list;
    }

    public static final void clearSlot(@NotNull Element $this$clearSlot, @NotNull String slotName) {
        Intrinsics.checkNotNullParameter((Object)$this$clearSlot, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)slotName, (String)"slotName");
        if (!(!StringsKt.isBlank((CharSequence)slotName))) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        Iterable $this$forEach$iv = ElementUtilsKt.getChildrenInSlot($this$clearSlot, slotName);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Element it = (Element)element$iv;
            boolean bl = false;
            it.removeFromParent();
        }
    }

    @NotNull
    public static final List<Component> _findComponents(@NotNull Element $this$_findComponents) {
        Intrinsics.checkNotNullParameter((Object)$this$_findComponents, (String)"<this>");
        List components = new ArrayList();
        ComponentUtil.findComponents((Element)$this$_findComponents, arg_0 -> ElementUtilsKt._findComponents$lambda$5(components, arg_0));
        return components;
    }

    public static final void _fireDomEvent(@NotNull Element $this$_fireDomEvent, @NotNull DomEvent event) {
        Intrinsics.checkNotNullParameter((Object)$this$_fireDomEvent, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        ((ElementListenerMap)$this$_fireDomEvent.getNode().getFeature(ElementListenerMap.class)).fireEvent(event);
    }

    private static final boolean getChildrenInSlot$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final void _findComponents$lambda$5(List $components, Component it) {
        Intrinsics.checkNotNullParameter((Object)$components, (String)"$components");
        Intrinsics.checkNotNull((Object)it);
        $components.add(it);
    }
}

