/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.textfield;

import com.vaadin.flow.component.textfield.AbstractNumberField;
import com.vaadin.testbench.unit.ComponentTester;
import com.vaadin.testbench.unit.Tests;
import java.util.Objects;
import java.util.function.Consumer;

@Tests(fqn={"com.vaadin.flow.component.textfield.IntegerField", "com.vaadin.flow.component.textfield.NumberField"})
public class NumberFieldTester<T extends AbstractNumberField<T, V>, V extends Number>
extends ComponentTester<T> {
    public NumberFieldTester(T component) {
        super(component);
    }

    public void setValue(V value) {
        this.ensureComponentIsUsable();
        if (!this.isValid(value)) {
            throw new IllegalArgumentException("Given value '" + value + "' is not valid");
        }
        ((AbstractNumberField)this.getComponent()).setValue(value);
    }

    private boolean isValid(V value) {
        boolean isRequiredButEmpty = ((AbstractNumberField)this.getComponent()).isRequired() && Objects.equals(((AbstractNumberField)this.getComponent()).getEmptyValue(), value);
        boolean isGreaterThanMax = value != null && ((Number)value).doubleValue() > ((AbstractNumberField)this.getComponent()).getMaxDouble();
        boolean isSmallerThanMin = value != null && ((Number)value).doubleValue() < ((AbstractNumberField)this.getComponent()).getMinDouble();
        return !isRequiredButEmpty && !isGreaterThanMax && !isSmallerThanMin;
    }

    @Override
    public boolean isUsable() {
        return super.isUsable() && !((AbstractNumberField)this.getComponent()).isReadOnly();
    }

    @Override
    protected void notUsableReasons(Consumer<String> collector) {
        super.notUsableReasons(collector);
        if (((AbstractNumberField)this.getComponent()).isReadOnly()) {
            collector.accept("read only");
        }
    }
}

