/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.html.testbench;

import com.vaadin.flow.component.HasElement;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.html.Anchor;
import com.vaadin.flow.component.html.testbench.HtmlContainerTester;
import com.vaadin.flow.router.QueryParameters;
import com.vaadin.flow.router.RouteConfiguration;
import com.vaadin.flow.server.StreamResource;
import com.vaadin.flow.server.StreamResourceRegistry;
import com.vaadin.flow.server.VaadinSession;
import com.vaadin.testbench.unit.Tests;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Optional;

@Tests(value={Anchor.class})
public class AnchorTester
extends HtmlContainerTester<Anchor> {
    public AnchorTester(Anchor component) {
        super(component);
    }

    public String getHref() {
        this.ensureComponentIsUsable();
        return ((Anchor)this.getComponent()).getHref();
    }

    public String getPath() {
        return URI.create(this.getHref()).getPath();
    }

    public QueryParameters getQueryParameters() {
        return QueryParameters.fromString((String)URI.create(this.getHref()).getQuery());
    }

    public HasElement click() {
        this.ensureComponentIsUsable();
        Field href = this.getField(Anchor.class, "href");
        try {
            if (href.get(this.getComponent()) instanceof String) {
                if (RouteConfiguration.forSessionScope().getRoute(this.getPath()).isPresent()) {
                    UI.getCurrent().navigate(this.getPath(), this.getQueryParameters());
                    return (HasElement)UI.getCurrent().getInternals().getActiveRouterTargetsChain().get(0);
                }
                throw new IllegalStateException("Anchor is not for an application route");
            }
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        throw new IllegalStateException("Anchor target seems to be a resource");
    }

    public void download(OutputStream outputStream) {
        Object t;
        this.ensureComponentIsUsable();
        Anchor anchor = (Anchor)this.getComponent();
        VaadinSession session = VaadinSession.getCurrent();
        StreamResourceRegistry registry = session.getResourceRegistry();
        Optional maybeResource = Optional.empty();
        try {
            maybeResource = registry.getResource(new URI(anchor.getHref()));
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        if (maybeResource.isEmpty() || !((t = maybeResource.get()) instanceof StreamResource)) {
            throw new IllegalStateException("Anchor target does not seem to be a resource");
        }
        StreamResource streamResource = (StreamResource)t;
        try {
            streamResource.getWriter().accept(outputStream, session);
        }
        catch (IOException e) {
            throw new RuntimeException("Download failed", e);
        }
    }
}

