/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.grid;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.grid.ColumnPathRenderer;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.grid.GridSortOrder;
import com.vaadin.flow.data.provider.SortDirection;
import com.vaadin.flow.data.provider.SortOrder;
import com.vaadin.flow.data.renderer.ComponentRenderer;
import com.vaadin.flow.function.ValueProvider;
import com.vaadin.testbench.unit.ComponentTester;
import com.vaadin.testbench.unit.MetaKeys;
import com.vaadin.testbench.unit.MouseButton;
import com.vaadin.testbench.unit.Tests;
import com.vaadin.testbench.unit.component.GridKt;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

@Tests(fqn={"com.vaadin.flow.component.grid.Grid"})
public class GridTester<T extends Grid<Y>, Y>
extends ComponentTester<T> {
    public GridTester(T component) {
        super(component);
    }

    public int size() {
        return GridKt._size((Grid)this.getComponent());
    }

    public Y getRow(int row) {
        return (Y)GridKt._get((Grid)this.getComponent(), row);
    }

    public void clickRow(int row) {
        this.clickRow(row, MouseButton.LEFT);
    }

    public void clickRow(int row, MouseButton button) {
        this.clickRow(row, button, new MetaKeys());
    }

    public void clickRow(int row, MetaKeys metaKeys) {
        this.clickRow(row, MouseButton.LEFT, metaKeys);
    }

    public void clickRow(int row, MouseButton button, MetaKeys metaKeys) {
        this.ensureComponentIsUsable();
        GridKt._clickItem((Grid)this.getComponent(), row, button.getButton(), metaKeys.isCtrl(), metaKeys.isShift(), metaKeys.isAlt(), metaKeys.isMeta());
    }

    public void doubleClickRow(int row) {
        this.doubleClickRow(row, MouseButton.LEFT);
    }

    public void doubleClickRow(int row, MouseButton button) {
        this.doubleClickRow(row, button, new MetaKeys());
    }

    public void doubleClickRow(int row, MetaKeys metaKeys) {
        this.doubleClickRow(row, MouseButton.LEFT, metaKeys);
    }

    public void doubleClickRow(int row, MouseButton button, MetaKeys metaKeys) {
        this.ensureComponentIsUsable();
        GridKt._doubleClickItem((Grid)this.getComponent(), row, button.getButton(), metaKeys.isCtrl(), metaKeys.isShift(), metaKeys.isAlt(), metaKeys.isMeta());
    }

    public void select(int row) {
        this.ensureComponentIsUsable();
        Y item = this.getRow(row);
        GridKt._select((Grid)this.getComponent(), item);
    }

    public void selectAll() {
        this.ensureComponentIsUsable();
        GridKt._selectAll((Grid)this.getComponent());
    }

    public String getCellText(int row, int column) {
        this.ensureVisible();
        Grid.Column<Y> targetColumn = this.getColumns().get(column);
        if (targetColumn.getRenderer() instanceof ComponentRenderer) {
            Component component = this.getCellComponent(row, column);
            if (component == null) {
                return null;
            }
            return component.getElement().getTextRecursively();
        }
        if (targetColumn.getRenderer() instanceof ColumnPathRenderer) {
            return this.getValueProviderString(row, targetColumn);
        }
        return null;
    }

    public Component getCellComponent(int row, int column) {
        this.ensureVisible();
        Grid.Column<Y> yColumn = this.getColumns().get(column);
        return this.getRendererItem(row, yColumn);
    }

    public Component getCellComponent(int row, String columnName) {
        this.ensureVisible();
        if (((Grid)this.getComponent()).getColumnByKey(columnName) == null) {
            throw new IllegalArgumentException("No column for property '" + columnName + "' exists");
        }
        Grid.Column yColumn = ((Grid)this.getComponent()).getColumnByKey(columnName);
        return this.getRendererItem(row, yColumn);
    }

    private Component getRendererItem(int row, Grid.Column<Y> yColumn) {
        if (yColumn.getRenderer() instanceof ComponentRenderer) {
            Y item = this.getRow(row);
            return ((ComponentRenderer)yColumn.getRenderer()).createComponent(item);
        }
        throw new IllegalArgumentException("Target column doesn't have a ComponentRenderer.");
    }

    public String getHeaderCell(int column) {
        this.ensureVisible();
        Grid.Column<Y> targetColumn = this.getColumns().get(column);
        return GridKt.getHeader2(targetColumn);
    }

    private List<Grid.Column<Y>> getColumns() {
        return ((Grid)this.getComponent()).getColumns().stream().filter(col -> col.isVisible()).collect(Collectors.toList());
    }

    public int getColumnPosition(String property) {
        Objects.requireNonNull(property, "property name must not be null");
        return this.getColumns().indexOf(this.getColumn(property));
    }

    public Grid.Column<Y> getColumn(String property) {
        Objects.requireNonNull(property, "property name must not be null");
        return ((Grid)this.getComponent()).getColumnByKey(property);
    }

    public ValueProvider<?, ?> getFooterCell(int column) {
        this.ensureVisible();
        Grid.Column<Y> targetColumn = this.getColumns().get(column);
        return (ValueProvider)targetColumn.getFooterRenderer().getValueProviders().get(this.getColumnInternalId(targetColumn));
    }

    public Collection<Y> getSelected() {
        this.ensureComponentIsUsable();
        return ((Grid)this.getComponent()).getSelectedItems();
    }

    public boolean isColumnSortable(int column) {
        return this.getColumns().get(column).isSortable();
    }

    public boolean isColumnSortable(String property) {
        Grid.Column<Y> column = this.getColumn(property);
        if (column == null) {
            throw new IllegalArgumentException("No column found for property " + property);
        }
        return column.isSortable();
    }

    public SortDirection getSortDirection(int column) {
        if (this.isColumnSortable(column)) {
            Grid.Column col = this.getColumns().get(column);
            return ((Grid)this.getComponent()).getSortOrder().stream().filter(order -> col.equals(order.getSorted())).map(SortOrder::getDirection).findFirst().orElse(null);
        }
        throw new IllegalArgumentException("Column at index " + column + " is not sortable");
    }

    public SortDirection getSortDirection(String property) {
        if (this.isColumnSortable(property)) {
            Grid.Column col = this.getColumn(property);
            return ((Grid)this.getComponent()).getSortOrder().stream().filter(order -> col.equals(order.getSorted())).map(SortOrder::getDirection).findFirst().orElse(null);
        }
        throw new IllegalArgumentException("Column for property " + property + " is not sortable");
    }

    public void sortByColumn(int column, SortDirection direction) {
        while (this.getSortDirection(column) != direction) {
            this.sortByColumn(column);
        }
    }

    public void sortByColumn(int column) {
        SortDirection currentDirection = this.getSortDirection(column);
        Grid.Column<Y> col = this.getColumns().get(column);
        this.doSort(currentDirection, col);
    }

    public void sortByColumn(String property) {
        SortDirection currentDirection = this.getSortDirection(property);
        Grid.Column<Y> col = this.getColumn(property);
        this.doSort(currentDirection, col);
    }

    public void sortByColumn(String property, SortDirection direction) {
        while (this.getSortDirection(property) != direction) {
            this.sortByColumn(property);
        }
    }

    private void doSort(SortDirection currentDirection, Grid.Column<Y> col) {
        ArrayList<GridSortOrder> sortOrders = new ArrayList<GridSortOrder>(((Grid)this.getComponent()).getSortOrder());
        if (((Grid)this.getComponent()).isMultiSort()) {
            sortOrders.removeIf(so -> so.getSorted() == col);
        } else {
            sortOrders.clear();
        }
        if (currentDirection == null) {
            sortOrders.add(0, (GridSortOrder)GridSortOrder.asc(col).build().get(0));
        } else if (currentDirection == SortDirection.ASCENDING) {
            sortOrders.add(0, (GridSortOrder)GridSortOrder.desc(col).build().get(0));
        }
        ((Grid)this.getComponent()).sort(sortOrders);
    }

    private String getValueProviderString(int row, Grid.Column targetColumn) throws IllegalArgumentException {
        String columnId = this.getColumnInternalId(targetColumn);
        ValueProvider columnValueProvider = (ValueProvider)targetColumn.getRenderer().getValueProviders().get(columnId);
        return columnValueProvider.apply(this.getRow(row)).toString();
    }

    private String getColumnInternalId(Grid.Column targetColumn) {
        try {
            Method getInternalId = this.getMethod(Grid.Column.class, "getInternalId", new Class[0]);
            String columnId = (String)getInternalId.invoke((Object)targetColumn, new Object[0]);
            return columnId;
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException("Failed to get internal id for column", e);
        }
    }
}

