/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.testbench.unit;

import com.vaadin.flow.function.VaadinApplicationInitializationBootstrap;
import com.vaadin.flow.server.VaadinContext;
import com.vaadin.flow.spring.SpringLookupInitializer;
import com.vaadin.testbench.unit.internal.UtilsKt;
import com.vaadin.testbench.unit.mocks.MockWebApplicationContext;
import com.vaadin.testbench.unit.mocks.SpringSecurityRequestCustomizer;
import java.util.Collection;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.test.context.TestContext;
import org.springframework.test.context.TestExecutionListener;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class UITestSpringLookupInitializer
extends SpringLookupInitializer
implements TestExecutionListener {
    private static final ThreadLocal<ApplicationContext> applicationContext = new ThreadLocal();

    public void beforeTestMethod(TestContext testContext) throws Exception {
        applicationContext.set(testContext.getApplicationContext());
        ApplicationContext appCtx = testContext.getApplicationContext();
        if (appCtx instanceof ConfigurableApplicationContext && !appCtx.containsBean(SpringSecurityRequestCustomizer.class.getName())) {
            ((ConfigurableApplicationContext)appCtx).getBeanFactory().registerSingleton(SpringSecurityRequestCustomizer.class.getName(), (Object)new SpringSecurityRequestCustomizer());
        }
    }

    public void afterTestMethod(TestContext testContext) throws Exception {
        applicationContext.remove();
    }

    public void initialize(VaadinContext context, Map<Class<?>, Collection<Class<?>>> services, VaadinApplicationInitializationBootstrap bootstrap) throws ServletException {
        ApplicationContext appCtx = applicationContext.get();
        ServletContext servletContext = UtilsKt.getContext(context);
        Object webAppCtx = WebApplicationContextUtils.getWebApplicationContext((ServletContext)servletContext);
        if (webAppCtx == null) {
            webAppCtx = appCtx instanceof WebApplicationContext ? (WebApplicationContext)appCtx : new MockWebApplicationContext(appCtx, servletContext);
            servletContext.setAttribute(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE, webAppCtx);
        }
        super.initialize(context, services, bootstrap);
    }
}

