/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.textfield;

import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.CompositionNotifier;
import com.vaadin.flow.component.HasHelper;
import com.vaadin.flow.component.HasLabel;
import com.vaadin.flow.component.HasSize;
import com.vaadin.flow.component.HasValidation;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.InputNotifier;
import com.vaadin.flow.component.KeyNotifier;
import com.vaadin.flow.component.Synchronize;
import com.vaadin.flow.component.shared.ClientValidationUtil;
import com.vaadin.flow.component.shared.HasClientValidation;
import com.vaadin.flow.component.shared.ValidationUtil;
import com.vaadin.flow.component.textfield.FieldValidationUtil;
import com.vaadin.flow.component.textfield.GeneratedVaadinNumberField;
import com.vaadin.flow.component.textfield.HasAutocapitalize;
import com.vaadin.flow.component.textfield.HasAutocomplete;
import com.vaadin.flow.component.textfield.HasAutocorrect;
import com.vaadin.flow.component.textfield.HasPrefixAndSuffix;
import com.vaadin.flow.component.textfield.TextFieldValidationSupport;
import com.vaadin.flow.data.binder.HasValidator;
import com.vaadin.flow.data.binder.ValidationResult;
import com.vaadin.flow.data.binder.ValidationStatusChangeEvent;
import com.vaadin.flow.data.binder.ValidationStatusChangeListener;
import com.vaadin.flow.data.binder.Validator;
import com.vaadin.flow.data.value.HasValueChangeMode;
import com.vaadin.flow.data.value.ValueChangeMode;
import com.vaadin.flow.dom.DomListenerRegistration;
import com.vaadin.flow.function.DeploymentConfiguration;
import com.vaadin.flow.function.SerializableFunction;
import com.vaadin.flow.server.VaadinSession;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Objects;

public abstract class AbstractNumberField<C extends AbstractNumberField<C, T>, T extends Number>
extends GeneratedVaadinNumberField<C, T>
implements HasSize,
HasValidation,
HasValueChangeMode,
HasPrefixAndSuffix,
InputNotifier,
KeyNotifier,
CompositionNotifier,
HasAutocomplete,
HasAutocapitalize,
HasAutocorrect,
HasHelper,
HasLabel,
HasValidator<T>,
HasClientValidation {
    private ValueChangeMode currentMode;
    private boolean isConnectorAttached;
    private int valueChangeTimeout = 400;
    private boolean required;
    private double min;
    private double max;
    private double step;
    private boolean stepSetByUser;
    private boolean minSetByUser;

    public AbstractNumberField(SerializableFunction<String, T> parser, SerializableFunction<T, String> formatter, double absoluteMin, double absoluteMax) {
        super(null, null, String.class, parser, formatter);
        this.setInvalid(false);
        this.min = absoluteMin;
        this.max = absoluteMax;
        this.step = 1.0;
        this.setValueChangeMode(ValueChangeMode.ON_CHANGE);
        this.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> this.validate());
        if (this.isEnforcedFieldValidationEnabled()) {
            this.addClientValidatedEventListener((ComponentEventListener & Serializable)e -> this.validate());
        }
    }

    public ValueChangeMode getValueChangeMode() {
        return this.currentMode;
    }

    public void setValueChangeMode(ValueChangeMode valueChangeMode) {
        this.currentMode = valueChangeMode;
        this.setSynchronizedEvent(ValueChangeMode.eventForMode((ValueChangeMode)valueChangeMode, (String)"value-changed"));
        this.applyChangeTimeout();
    }

    public void setValueChangeTimeout(int valueChangeTimeout) {
        this.valueChangeTimeout = valueChangeTimeout;
        this.applyChangeTimeout();
    }

    public int getValueChangeTimeout() {
        return this.valueChangeTimeout;
    }

    private void applyChangeTimeout() {
        ValueChangeMode.applyChangeTimeout((ValueChangeMode)this.getValueChangeMode(), (int)this.getValueChangeTimeout(), (DomListenerRegistration)this.getSynchronizationRegistration());
    }

    public String getErrorMessage() {
        return super.getErrorMessageString();
    }

    @Override
    public void setErrorMessage(String errorMessage) {
        super.setErrorMessage(errorMessage);
    }

    @Override
    public void setLabel(String label) {
        super.setLabel(label);
    }

    public String getLabel() {
        return this.getLabelString();
    }

    @Override
    public void setPlaceholder(String placeholder) {
        super.setPlaceholder(placeholder);
    }

    @Override
    public void setHasControls(boolean hasControls) {
        super.setHasControls(hasControls);
    }

    public boolean hasControls() {
        return super.hasControlsBoolean();
    }

    public String getPlaceholder() {
        return this.getPlaceholderString();
    }

    @Override
    public void setAutofocus(boolean autofocus) {
        super.setAutofocus(autofocus);
    }

    public boolean isAutofocus() {
        return this.isAutofocusBoolean();
    }

    public String getTitle() {
        return super.getTitleString();
    }

    @Override
    public void setTitle(String title) {
        super.setTitle(title);
    }

    public boolean isAutoselect() {
        return super.isAutoselectBoolean();
    }

    @Override
    public void setAutoselect(boolean autoselect) {
        super.setAutoselect(autoselect);
    }

    public boolean isClearButtonVisible() {
        return this.isClearButtonVisibleBoolean();
    }

    @Override
    public void setClearButtonVisible(boolean clearButtonVisible) {
        super.setClearButtonVisible(clearButtonVisible);
    }

    public T getEmptyValue() {
        return null;
    }

    public void setValue(T value) {
        Object oldValue = this.getValue();
        super.setValue(value);
        if (Objects.equals(oldValue, this.getEmptyValue()) && Objects.equals(value, this.getEmptyValue()) && this.isInputValuePresent()) {
            this.getElement().executeJs("if (!this.value) this._inputElementValue = ''", new Serializable[0]);
            this.getElement().setProperty("_hasInputValue", false);
            this.fireEvent((ComponentEvent)new HasClientValidation.ClientValidatedEvent((Component)this, false));
        }
    }

    public T getValue() {
        return (T)((Number)super.getValue());
    }

    @Override
    protected void setMin(double min) {
        super.setMin(min);
        this.min = min;
        this.minSetByUser = true;
    }

    @Override
    protected double getMinDouble() {
        return this.min;
    }

    @Override
    protected void setMax(double max) {
        super.setMax(max);
        this.max = max;
    }

    @Override
    protected double getMaxDouble() {
        return this.max;
    }

    @Override
    protected void setStep(double step) {
        super.setStep(step);
        this.step = step;
        this.stepSetByUser = true;
    }

    @Override
    protected double getStepDouble() {
        return this.step;
    }

    @Override
    public void setInvalid(boolean invalid) {
        super.setInvalid(invalid);
    }

    public boolean isInvalid() {
        return this.isInvalidBoolean();
    }

    @Synchronize(property="_hasInputValue", value={"has-input-value-changed"})
    private boolean isInputValuePresent() {
        return this.getElement().getProperty("_hasInputValue", false);
    }

    public Validator<T> getDefaultValidator() {
        if (this.isEnforcedFieldValidationEnabled()) {
            return (Validator & Serializable)(value, context) -> this.checkValidity(value);
        }
        return Validator.alwaysPass();
    }

    public Registration addValidationStatusChangeListener(ValidationStatusChangeListener<T> listener) {
        if (this.isEnforcedFieldValidationEnabled()) {
            return this.addClientValidatedEventListener((ComponentEventListener & Serializable)event -> listener.validationStatusChanged(new ValidationStatusChangeEvent((HasValue)this, !this.isInvalid())));
        }
        return null;
    }

    private ValidationResult checkValidity(T value) {
        boolean hasNonParsableValue;
        boolean bl = hasNonParsableValue = Objects.equals(value, this.getEmptyValue()) && this.isInputValuePresent();
        if (hasNonParsableValue) {
            return ValidationResult.error((String)"");
        }
        Double doubleValue = value != null ? Double.valueOf(((Number)value).doubleValue()) : null;
        ValidationResult greaterThanMax = ValidationUtil.checkGreaterThanMax((Comparable)doubleValue, (Comparable)Double.valueOf(this.max));
        if (greaterThanMax.isError()) {
            return greaterThanMax;
        }
        ValidationResult smallerThanMin = ValidationUtil.checkSmallerThanMin((Comparable)doubleValue, (Comparable)Double.valueOf(this.min));
        if (smallerThanMin.isError()) {
            return smallerThanMin;
        }
        if (!this.isValidByStep(value)) {
            return ValidationResult.error((String)"");
        }
        return ValidationResult.ok();
    }

    @Override
    protected void validate() {
        Object value = this.getValue();
        ValidationResult requiredValidation = TextFieldValidationSupport.checkRequired(this.required, value, this.getEmptyValue());
        this.setInvalid(requiredValidation.isError() || this.checkValidity(value).isError());
    }

    private boolean isValidByStep(T value) {
        if (!this.stepSetByUser || value == null || this.step == 0.0) {
            return true;
        }
        double stepBasis = this.minSetByUser ? this.getMinDouble() : 0.0;
        return new BigDecimal(String.valueOf(value)).subtract(BigDecimal.valueOf(stepBasis)).remainder(BigDecimal.valueOf(this.step)).compareTo(BigDecimal.ZERO) == 0;
    }

    public void setRequiredIndicatorVisible(boolean requiredIndicatorVisible) {
        super.setRequiredIndicatorVisible(requiredIndicatorVisible);
        this.required = requiredIndicatorVisible;
    }

    protected void onAttach(AttachEvent attachEvent) {
        super.onAttach(attachEvent);
        if (this.isEnforcedFieldValidationEnabled()) {
            ClientValidationUtil.preventWebComponentFromModifyingInvalidState((Component)this);
        } else {
            FieldValidationUtil.disableClientValidation((Component)this);
        }
    }

    protected boolean isEnforcedFieldValidationEnabled() {
        VaadinSession session = VaadinSession.getCurrent();
        if (session == null) {
            return false;
        }
        DeploymentConfiguration configuration = session.getConfiguration();
        if (configuration == null) {
            return false;
        }
        return configuration.isEnforcedFieldValidationEnabled();
    }
}

