/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.textfield;

import com.vaadin.flow.component.AbstractField;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.CompositionNotifier;
import com.vaadin.flow.component.HasSize;
import com.vaadin.flow.component.HasValidation;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.InputNotifier;
import com.vaadin.flow.component.KeyNotifier;
import com.vaadin.flow.component.textfield.FieldValidationUtil;
import com.vaadin.flow.component.textfield.GeneratedVaadinNumberField;
import com.vaadin.flow.component.textfield.HasAutocapitalize;
import com.vaadin.flow.component.textfield.HasAutocomplete;
import com.vaadin.flow.component.textfield.HasAutocorrect;
import com.vaadin.flow.component.textfield.HasPrefixAndSuffix;
import com.vaadin.flow.data.value.HasValueChangeMode;
import com.vaadin.flow.data.value.ValueChangeMode;
import com.vaadin.flow.dom.DomListenerRegistration;
import com.vaadin.flow.function.SerializableFunction;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParseException;
import java.util.Locale;
import java.util.Objects;

public class NumberField
extends GeneratedVaadinNumberField<NumberField, Double>
implements HasSize,
HasValidation,
HasValueChangeMode,
HasPrefixAndSuffix,
InputNotifier,
KeyNotifier,
CompositionNotifier,
HasAutocomplete,
HasAutocapitalize,
HasAutocorrect {
    private ValueChangeMode currentMode;
    private boolean isConnectorAttached;
    private int valueChangeTimeout = 400;
    private Double max;
    private Double min;
    private Double step;
    private boolean required;
    private boolean stepSetByUser;
    private boolean minSetByUser;

    public NumberField() {
        this(new Formatter());
    }

    public NumberField(String label) {
        this();
        this.setLabel(label);
    }

    public NumberField(String label, String placeholder) {
        this(label);
        this.setPlaceholder(placeholder);
    }

    public NumberField(HasValue.ValueChangeListener<? super AbstractField.ComponentValueChangeEvent<NumberField, Double>> listener) {
        this();
        this.addValueChangeListener(listener);
    }

    public NumberField(String label, HasValue.ValueChangeListener<? super AbstractField.ComponentValueChangeEvent<NumberField, Double>> listener) {
        this(label);
        this.addValueChangeListener(listener);
    }

    public NumberField(String label, Double initialValue, HasValue.ValueChangeListener<? super AbstractField.ComponentValueChangeEvent<NumberField, Double>> listener) {
        this(label);
        this.setValue(initialValue);
        this.addValueChangeListener(listener);
    }

    private NumberField(Formatter formatter) {
        super(null, null, String.class, (SerializableFunction & Serializable)x$0 -> formatter.parse(x$0), formatter);
        this.setInvalid(false);
        this.setValueChangeMode(ValueChangeMode.ON_CHANGE);
        this.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> this.validate());
        FieldValidationUtil.disableClientValidation((Component)this);
    }

    public ValueChangeMode getValueChangeMode() {
        return this.currentMode;
    }

    public void setValueChangeMode(ValueChangeMode valueChangeMode) {
        this.currentMode = valueChangeMode;
        this.setSynchronizedEvent(ValueChangeMode.eventForMode((ValueChangeMode)valueChangeMode, (String)"value-changed"));
        this.applyChangeTimeout();
    }

    public void setValueChangeTimeout(int valueChangeTimeout) {
        this.valueChangeTimeout = valueChangeTimeout;
        this.applyChangeTimeout();
    }

    public int getValueChangeTimeout() {
        return this.valueChangeTimeout;
    }

    private void applyChangeTimeout() {
        ValueChangeMode.applyChangeTimeout((ValueChangeMode)this.getValueChangeMode(), (int)this.getValueChangeTimeout(), (DomListenerRegistration)this.getSynchronizationRegistration());
    }

    public String getErrorMessage() {
        return super.getErrorMessageString();
    }

    @Override
    public void setErrorMessage(String errorMessage) {
        super.setErrorMessage(errorMessage);
    }

    public boolean isInvalid() {
        return this.isInvalidBoolean();
    }

    @Override
    protected void validate() {
        Double value = this.getValue();
        boolean isRequiredButEmpty = this.required && Objects.equals(this.getEmptyValue(), value);
        boolean isGreaterThanMax = value != null && this.max != null && value > this.max;
        boolean isSmallerThanMin = value != null && this.min != null && value < this.min;
        this.setInvalid(isRequiredButEmpty || isGreaterThanMax || isSmallerThanMin);
        this.setInvalid(isRequiredButEmpty || isGreaterThanMax || isSmallerThanMin || !this.isValidByStep(value));
    }

    private boolean isValidByStep(Double value) {
        if (!this.stepSetByUser || value == null || this.step == 0.0) {
            return true;
        }
        double stepBasis = this.minSetByUser ? this.getMinDouble() : 0.0;
        return new BigDecimal(String.valueOf(value)).subtract(BigDecimal.valueOf(stepBasis)).remainder(BigDecimal.valueOf(this.step)).compareTo(BigDecimal.ZERO) == 0;
    }

    @Override
    public void setInvalid(boolean invalid) {
        super.setInvalid(invalid);
    }

    @Override
    public void setLabel(String label) {
        super.setLabel(label);
    }

    public String getLabel() {
        return this.getLabelString();
    }

    @Override
    public void setMax(double max) {
        super.setMax(max);
        this.max = max;
    }

    public double getMax() {
        return super.getMaxDouble();
    }

    @Override
    public void setMin(double min) {
        super.setMin(min);
        this.min = min;
        this.minSetByUser = true;
    }

    public double getMin() {
        return super.getMinDouble();
    }

    @Override
    public void setStep(double step) {
        if (step <= 0.0) {
            throw new IllegalArgumentException("The step cannot be less or equal to zero.");
        }
        super.setStep(step);
        this.step = step;
        this.stepSetByUser = true;
    }

    public double getStep() {
        return super.getStepDouble();
    }

    @Override
    public void setPlaceholder(String placeholder) {
        super.setPlaceholder(placeholder);
    }

    @Override
    public void setHasControls(boolean hasControls) {
        super.setHasControls(hasControls);
    }

    public boolean hasControls() {
        return super.hasControlsBoolean();
    }

    public String getPlaceholder() {
        return this.getPlaceholderString();
    }

    @Override
    public void setAutofocus(boolean autofocus) {
        super.setAutofocus(autofocus);
    }

    public boolean isAutofocus() {
        return this.isAutofocusBoolean();
    }

    public void setMaxLength(int maxLength) {
        super.setMaxlength(maxLength);
    }

    public int getMaxLength() {
        return (int)this.getMaxlengthDouble();
    }

    public void setMinLength(int minLength) {
        super.setMinlength(minLength);
    }

    public int getMinLength() {
        return (int)this.getMinlengthDouble();
    }

    public boolean isPreventInvalidInput() {
        return this.isPreventInvalidInputBoolean();
    }

    @Override
    public void setPreventInvalidInput(boolean preventInvalidInput) {
        super.setPreventInvalidInput(preventInvalidInput);
    }

    @Override
    public void setPattern(String pattern) {
        super.setPattern(pattern);
    }

    public String getPattern() {
        return this.getPatternString();
    }

    public String getTitle() {
        return super.getTitleString();
    }

    @Override
    public void setTitle(String title) {
        super.setTitle(title);
    }

    public boolean isAutoselect() {
        return super.isAutoselectBoolean();
    }

    @Override
    public void setAutoselect(boolean autoselect) {
        super.setAutoselect(autoselect);
    }

    public boolean isClearButtonVisible() {
        return this.isClearButtonVisibleBoolean();
    }

    @Override
    public void setClearButtonVisible(boolean clearButtonVisible) {
        super.setClearButtonVisible(clearButtonVisible);
    }

    public Double getEmptyValue() {
        return null;
    }

    public void setValue(Double value) {
        super.setValue((Object)value);
    }

    public Double getValue() {
        return (Double)super.getValue();
    }

    public void setRequiredIndicatorVisible(boolean requiredIndicatorVisible) {
        super.setRequiredIndicatorVisible(requiredIndicatorVisible);
        this.required = requiredIndicatorVisible;
    }

    private static class Formatter
    implements SerializableFunction<Double, String> {
        private final DecimalFormat decimalFormat = new DecimalFormat("#.#", DecimalFormatSymbols.getInstance(Locale.ENGLISH));

        private Formatter() {
            this.decimalFormat.setMaximumFractionDigits(Integer.MAX_VALUE);
        }

        public String apply(Double valueFromModel) {
            return valueFromModel == null ? "" : this.decimalFormat.format(valueFromModel);
        }

        private Double parse(String valueFromClient) {
            try {
                return valueFromClient == null || valueFromClient.isEmpty() ? null : Double.valueOf(this.decimalFormat.parse(valueFromClient).doubleValue());
            }
            catch (ParseException e) {
                throw new NumberFormatException(valueFromClient);
            }
        }
    }
}

