/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.textfield;

import com.vaadin.flow.component.AbstractSinglePropertyField;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.DomEvent;
import com.vaadin.flow.component.Focusable;
import com.vaadin.flow.component.HasStyle;
import com.vaadin.flow.component.HasTheme;
import com.vaadin.flow.component.NotSupported;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.dependency.HtmlImport;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.dependency.NpmPackage;
import com.vaadin.flow.component.textfield.TextFieldVariant;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.dom.PropertyChangeListener;
import com.vaadin.flow.function.SerializableBiFunction;
import com.vaadin.flow.function.SerializableFunction;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.util.Collection;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@Tag(value="vaadin-text-field")
@HtmlImport(value="frontend://bower_components/vaadin-text-field/src/vaadin-text-field.html")
@NpmPackage(value="@vaadin/vaadin-text-field", version="2.8.2")
@JsModule(value="@vaadin/vaadin-text-field/src/vaadin-text-field.js")
public abstract class GeneratedVaadinTextField<R extends GeneratedVaadinTextField<R, T>, T>
extends AbstractSinglePropertyField<R, T>
implements HasStyle,
Focusable<R>,
HasTheme {
    public void addThemeVariants(TextFieldVariant ... variants) {
        this.getThemeNames().addAll((Collection)Stream.of(variants).map(TextFieldVariant::getVariantName).collect(Collectors.toList()));
    }

    public void removeThemeVariants(TextFieldVariant ... variants) {
        this.getThemeNames().removeAll((Collection)Stream.of(variants).map(TextFieldVariant::getVariantName).collect(Collectors.toList()));
    }

    protected boolean isAutofocusBoolean() {
        return this.getElement().getProperty("autofocus", false);
    }

    protected void setAutofocus(boolean autofocus) {
        this.getElement().setProperty("autofocus", autofocus);
    }

    protected boolean isDisabledBoolean() {
        return this.getElement().getProperty("disabled", false);
    }

    protected void setDisabled(boolean disabled) {
        this.getElement().setProperty("disabled", disabled);
    }

    protected String getAutocompleteString() {
        return this.getElement().getProperty("autocomplete");
    }

    protected void setAutocomplete(String autocomplete) {
        this.getElement().setProperty("autocomplete", autocomplete == null ? "" : autocomplete);
    }

    protected String getAutocorrectString() {
        return this.getElement().getProperty("autocorrect");
    }

    protected void setAutocorrect(String autocorrect) {
        this.getElement().setProperty("autocorrect", autocorrect == null ? "" : autocorrect);
    }

    protected String getAutocapitalizeString() {
        return this.getElement().getProperty("autocapitalize");
    }

    protected void setAutocapitalize(String autocapitalize) {
        this.getElement().setProperty("autocapitalize", autocapitalize == null ? "" : autocapitalize);
    }

    protected boolean isAutoselectBoolean() {
        return this.getElement().getProperty("autoselect", false);
    }

    protected void setAutoselect(boolean autoselect) {
        this.getElement().setProperty("autoselect", autoselect);
    }

    protected boolean isClearButtonVisibleBoolean() {
        return this.getElement().getProperty("clearButtonVisible", false);
    }

    protected void setClearButtonVisible(boolean clearButtonVisible) {
        this.getElement().setProperty("clearButtonVisible", clearButtonVisible);
    }

    protected String getErrorMessageString() {
        return this.getElement().getProperty("errorMessage");
    }

    protected void setErrorMessage(String errorMessage) {
        this.getElement().setProperty("errorMessage", errorMessage == null ? "" : errorMessage);
    }

    protected String getLabelString() {
        return this.getElement().getProperty("label");
    }

    protected void setLabel(String label) {
        this.getElement().setProperty("label", label == null ? "" : label);
    }

    protected double getMaxlengthDouble() {
        return this.getElement().getProperty("maxlength", 0.0);
    }

    protected void setMaxlength(double maxlength) {
        this.getElement().setProperty("maxlength", maxlength);
    }

    protected double getMinlengthDouble() {
        return this.getElement().getProperty("minlength", 0.0);
    }

    protected void setMinlength(double minlength) {
        this.getElement().setProperty("minlength", minlength);
    }

    protected String getNameString() {
        return this.getElement().getProperty("name");
    }

    protected void setName(String name) {
        this.getElement().setProperty("name", name == null ? "" : name);
    }

    protected String getPlaceholderString() {
        return this.getElement().getProperty("placeholder");
    }

    protected void setPlaceholder(String placeholder) {
        this.getElement().setProperty("placeholder", placeholder == null ? "" : placeholder);
    }

    protected boolean isReadonlyBoolean() {
        return this.getElement().getProperty("readonly", false);
    }

    protected void setReadonly(boolean readonly) {
        this.getElement().setProperty("readonly", readonly);
    }

    protected boolean isRequiredBoolean() {
        return this.getElement().getProperty("required", false);
    }

    protected void setRequired(boolean required) {
        this.getElement().setProperty("required", required);
    }

    protected boolean isInvalidBoolean() {
        return this.getElement().getProperty("invalid", false);
    }

    protected void setInvalid(boolean invalid) {
        this.getElement().setProperty("invalid", invalid);
    }

    protected boolean isPreventInvalidInputBoolean() {
        return this.getElement().getProperty("preventInvalidInput", false);
    }

    protected void setPreventInvalidInput(boolean preventInvalidInput) {
        this.getElement().setProperty("preventInvalidInput", preventInvalidInput);
    }

    protected String getListString() {
        return this.getElement().getProperty("list");
    }

    protected void setList(String list) {
        this.getElement().setProperty("list", list == null ? "" : list);
    }

    protected String getPatternString() {
        return this.getElement().getProperty("pattern");
    }

    protected void setPattern(String pattern) {
        this.getElement().setProperty("pattern", pattern == null ? "" : pattern);
    }

    protected String getTitleString() {
        return this.getElement().getProperty("title");
    }

    protected void setTitle(String title) {
        this.getElement().setProperty("title", title == null ? "" : title);
    }

    @NotSupported
    protected void checkValidity() {
    }

    @NotSupported
    protected void validate() {
    }

    protected Registration addChangeListener(ComponentEventListener<ChangeEvent<R>> listener) {
        return this.addListener(ChangeEvent.class, listener);
    }

    protected Registration addInvalidChangeListener(ComponentEventListener<InvalidChangeEvent<R>> listener) {
        return this.getElement().addPropertyChangeListener("invalid", (PropertyChangeListener & Serializable)event -> listener.onComponentEvent(new InvalidChangeEvent<GeneratedVaadinTextField>(this, event.isUserOriginated())));
    }

    protected void addToPrefix(Component ... components) {
        for (Component component : components) {
            component.getElement().setAttribute("slot", "prefix");
            this.getElement().appendChild(new Element[]{component.getElement()});
        }
    }

    protected void addToInput(Component ... components) {
        for (Component component : components) {
            component.getElement().setAttribute("slot", "input");
            this.getElement().appendChild(new Element[]{component.getElement()});
        }
    }

    protected void addToSuffix(Component ... components) {
        for (Component component : components) {
            component.getElement().setAttribute("slot", "suffix");
            this.getElement().appendChild(new Element[]{component.getElement()});
        }
    }

    protected void remove(Component ... components) {
        for (Component component : components) {
            if (!this.getElement().equals((Object)component.getElement().getParent())) {
                throw new IllegalArgumentException("The given component (" + component + ") is not a child of this component");
            }
            component.getElement().removeAttribute("slot");
            this.getElement().removeChild(new Element[]{component.getElement()});
        }
    }

    protected void removeAll() {
        this.getElement().getChildren().forEach(child -> child.removeAttribute("slot"));
        this.getElement().removeAllChildren();
    }

    public <P> GeneratedVaadinTextField(T initialValue, T defaultValue, Class<P> elementPropertyType, SerializableFunction<P, T> presentationToModel, SerializableFunction<T, P> modelToPresentation) {
        super("value", defaultValue, elementPropertyType, presentationToModel, modelToPresentation);
        if (initialValue != null) {
            this.setModelValue(initialValue, false);
            this.setPresentationValue(initialValue);
        }
    }

    public GeneratedVaadinTextField(T initialValue, T defaultValue, boolean acceptNullValues) {
        super("value", defaultValue, acceptNullValues);
        if (initialValue != null) {
            this.setModelValue(initialValue, false);
            this.setPresentationValue(initialValue);
        }
    }

    public <P> GeneratedVaadinTextField(T initialValue, T defaultValue, Class<P> elementPropertyType, SerializableBiFunction<R, P, T> presentationToModel, SerializableBiFunction<R, T, P> modelToPresentation) {
        super("value", defaultValue, elementPropertyType, presentationToModel, modelToPresentation);
        if (initialValue != null) {
            this.setModelValue(initialValue, false);
            this.setPresentationValue(initialValue);
        }
    }

    public GeneratedVaadinTextField() {
        this(null, null, null, (SerializableFunction)null, (SerializableFunction)null);
    }

    public static class InvalidChangeEvent<R extends GeneratedVaadinTextField<R, ?>>
    extends ComponentEvent<R> {
        private final boolean invalid;

        public InvalidChangeEvent(R source, boolean fromClient) {
            super(source, fromClient);
            this.invalid = ((GeneratedVaadinTextField)((Object)source)).isInvalidBoolean();
        }

        public boolean isInvalid() {
            return this.invalid;
        }
    }

    @DomEvent(value="change")
    public static class ChangeEvent<R extends GeneratedVaadinTextField<R, ?>>
    extends ComponentEvent<R> {
        public ChangeEvent(R source, boolean fromClient) {
            super(source, fromClient);
        }
    }
}

