/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.textfield;

import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.Synchronize;
import com.vaadin.flow.component.shared.ClientValidationUtil;
import com.vaadin.flow.component.shared.ValidationUtil;
import com.vaadin.flow.component.textfield.TextFieldBase;
import com.vaadin.flow.data.binder.ValidationResult;
import com.vaadin.flow.data.binder.ValidationStatusChangeEvent;
import com.vaadin.flow.data.binder.ValidationStatusChangeListener;
import com.vaadin.flow.data.binder.Validator;
import com.vaadin.flow.data.value.ValueChangeMode;
import com.vaadin.flow.dom.DomEventListener;
import com.vaadin.flow.dom.DomListenerRegistration;
import com.vaadin.flow.function.SerializableFunction;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;

public abstract class AbstractNumberField<C extends AbstractNumberField<C, T>, T extends Number>
extends TextFieldBase<C, T> {
    private boolean required;
    private double min;
    private double max;
    private double step;
    private boolean stepSetByUser;
    private boolean minSetByUser;
    private boolean manualValidationEnabled = false;
    private DomListenerRegistration inputListenerRegistration;
    private final CopyOnWriteArrayList<ValidationStatusChangeListener<T>> validationStatusChangeListeners = new CopyOnWriteArrayList();

    public AbstractNumberField(SerializableFunction<String, T> parser, SerializableFunction<T, String> formatter, double absoluteMin, double absoluteMax) {
        super(null, null, String.class, parser, formatter, true);
        this.setInvalid(false);
        this.min = absoluteMin;
        this.max = absoluteMax;
        this.step = 1.0;
        this.setValueChangeMode(ValueChangeMode.ON_CHANGE);
        this.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> this.validate());
        this.getElement().addEventListener("unparsable-change", (DomEventListener & Serializable)e -> {
            this.validate();
            this.fireValidationStatusChangeEvent();
        });
    }

    @Override
    public void setValueChangeMode(ValueChangeMode valueChangeMode) {
        if (this.inputListenerRegistration != null) {
            this.inputListenerRegistration.remove();
            this.inputListenerRegistration = null;
        }
        if (ValueChangeMode.EAGER.equals((Object)valueChangeMode) || ValueChangeMode.LAZY.equals((Object)valueChangeMode) || ValueChangeMode.TIMEOUT.equals((Object)valueChangeMode)) {
            this.inputListenerRegistration = this.getElement().addEventListener("input", (DomEventListener & Serializable)event -> {
                if (this.valueEquals(this.getValue(), this.getEmptyValue())) {
                    this.validate();
                    this.fireValidationStatusChangeEvent();
                }
            });
        }
        super.setValueChangeMode(valueChangeMode);
    }

    @Override
    void applyChangeTimeout() {
        super.applyChangeTimeout();
        ValueChangeMode.applyChangeTimeout((ValueChangeMode)this.getValueChangeMode(), (int)this.getValueChangeTimeout(), (DomListenerRegistration)this.inputListenerRegistration);
    }

    public void setStepButtonsVisible(boolean stepButtonsVisible) {
        this.getElement().setProperty("stepButtonsVisible", stepButtonsVisible);
    }

    public boolean isStepButtonsVisible() {
        return this.getElement().getProperty("stepButtonsVisible", false);
    }

    public T getEmptyValue() {
        return null;
    }

    public void setValue(T value) {
        Object oldValue = this.getValue();
        boolean isOldValueEmpty = this.valueEquals(oldValue, this.getEmptyValue());
        boolean isNewValueEmpty = this.valueEquals(value, this.getEmptyValue());
        boolean isValueRemainedEmpty = isOldValueEmpty && isNewValueEmpty;
        boolean isInputValuePresent = this.isInputValuePresent();
        if (isNewValueEmpty) {
            this.getElement().setProperty("_hasInputValue", false);
        }
        super.setValue(value);
        if (isValueRemainedEmpty && isInputValuePresent) {
            this.getElement().executeJs("if (!this.value) this._inputElementValue = ''", new Serializable[0]);
            this.validate();
            this.fireValidationStatusChangeEvent();
        }
    }

    protected void setModelValue(T newModelValue, boolean fromClient) {
        Object oldModelValue = this.getValue();
        super.setModelValue(newModelValue, fromClient);
        if (fromClient && this.valueEquals(oldModelValue, this.getEmptyValue()) && this.valueEquals(newModelValue, this.getEmptyValue())) {
            this.validate();
            this.fireValidationStatusChangeEvent();
        }
    }

    public T getValue() {
        return (T)((Number)super.getValue());
    }

    protected void setMin(double min) {
        this.getElement().setProperty("min", min);
        this.min = min;
        this.minSetByUser = true;
    }

    protected double getMinDouble() {
        return this.min;
    }

    protected void setMax(double max) {
        this.getElement().setProperty("max", max);
        this.max = max;
    }

    protected double getMaxDouble() {
        return this.max;
    }

    protected void setStep(double step) {
        this.getElement().setProperty("step", step);
        this.step = step;
        this.stepSetByUser = true;
    }

    protected double getStepDouble() {
        return this.step;
    }

    @Synchronize(property="_hasInputValue", value={"has-input-value-changed"})
    private boolean isInputValuePresent() {
        return this.getElement().getProperty("_hasInputValue", false);
    }

    public Validator<T> getDefaultValidator() {
        return (Validator & Serializable)(value, context) -> this.checkValidity(value);
    }

    public Registration addValidationStatusChangeListener(ValidationStatusChangeListener<T> listener) {
        return Registration.addAndRemove(this.validationStatusChangeListeners, listener);
    }

    private void fireValidationStatusChangeEvent() {
        ValidationStatusChangeEvent event = new ValidationStatusChangeEvent((HasValue)this, !this.isInvalid());
        this.validationStatusChangeListeners.forEach((Consumer<ValidationStatusChangeListener<T>>)((Consumer<ValidationStatusChangeListener>)listener -> listener.validationStatusChanged(event)));
    }

    private ValidationResult checkValidity(T value) {
        boolean hasNonParsableValue;
        boolean bl = hasNonParsableValue = this.valueEquals(value, this.getEmptyValue()) && this.isInputValuePresent();
        if (hasNonParsableValue) {
            return ValidationResult.error((String)"");
        }
        Double doubleValue = value != null ? Double.valueOf(((Number)value).doubleValue()) : null;
        ValidationResult greaterThanMax = ValidationUtil.checkGreaterThanMax((Comparable)doubleValue, (Comparable)Double.valueOf(this.max));
        if (greaterThanMax.isError()) {
            return greaterThanMax;
        }
        ValidationResult smallerThanMin = ValidationUtil.checkSmallerThanMin((Comparable)doubleValue, (Comparable)Double.valueOf(this.min));
        if (smallerThanMin.isError()) {
            return smallerThanMin;
        }
        if (!this.isValidByStep(value)) {
            return ValidationResult.error((String)"");
        }
        return ValidationResult.ok();
    }

    public void setManualValidation(boolean enabled) {
        this.manualValidationEnabled = enabled;
    }

    protected void validate() {
        if (!this.manualValidationEnabled) {
            Object value = this.getValue();
            ValidationResult requiredValidation = ValidationUtil.checkRequired((boolean)this.required, (Object)value, (Object)this.getEmptyValue());
            this.setInvalid(requiredValidation.isError() || this.checkValidity(value).isError());
        }
    }

    private boolean isValidByStep(T value) {
        if (!this.stepSetByUser || value == null || this.step == 0.0) {
            return true;
        }
        double stepBasis = this.minSetByUser ? this.getMinDouble() : 0.0;
        return new BigDecimal(String.valueOf(value)).subtract(BigDecimal.valueOf(stepBasis)).remainder(BigDecimal.valueOf(this.step)).compareTo(BigDecimal.ZERO) == 0;
    }

    public void setRequiredIndicatorVisible(boolean requiredIndicatorVisible) {
        super.setRequiredIndicatorVisible(requiredIndicatorVisible);
        this.required = requiredIndicatorVisible;
    }

    protected void onAttach(AttachEvent attachEvent) {
        super.onAttach(attachEvent);
        ClientValidationUtil.preventWebComponentFromModifyingInvalidState((Component)this);
    }
}

