/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.textfield;

import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.shared.ValidationUtil;
import com.vaadin.flow.data.binder.ValidationResult;
import java.io.Serializable;
import java.util.regex.Pattern;

final class TextFieldValidationSupport
implements Serializable {
    private final HasValue<?, String> field;
    private boolean required;
    private Integer minLength;
    private Integer maxLength;
    private Pattern pattern;

    TextFieldValidationSupport(HasValue<?, String> field) {
        this.field = field;
    }

    void setRequired(boolean required) {
        this.required = required;
    }

    void setMinLength(Integer minLength) {
        this.minLength = minLength;
    }

    void setMaxLength(Integer maxLength) {
        this.maxLength = maxLength;
    }

    void setPattern(String pattern) {
        this.pattern = pattern == null || pattern.isEmpty() ? null : Pattern.compile(pattern);
    }

    boolean isInvalid(String value) {
        ValidationResult requiredValidation = ValidationUtil.checkRequired((boolean)this.required, (Object)value, (Object)((String)this.field.getEmptyValue()));
        return requiredValidation.isError() || this.checkValidity(value).isError();
    }

    ValidationResult checkValidity(String value) {
        boolean valueViolatePattern;
        boolean isMinLengthNotReached;
        boolean isMaxLengthExceeded;
        boolean bl = isMaxLengthExceeded = value != null && this.maxLength != null && value.length() > this.maxLength;
        if (isMaxLengthExceeded) {
            return ValidationResult.error((String)"");
        }
        boolean bl2 = isMinLengthNotReached = value != null && !value.isEmpty() && this.minLength != null && value.length() < this.minLength;
        if (isMinLengthNotReached) {
            return ValidationResult.error((String)"");
        }
        boolean bl3 = valueViolatePattern = value != null && !value.isEmpty() && this.pattern != null && !this.pattern.matcher(value).matches();
        if (valueViolatePattern) {
            return ValidationResult.error((String)"");
        }
        return ValidationResult.ok();
    }
}

