/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.timepicker;

import com.vaadin.flow.component.AbstractField;
import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasEnabled;
import com.vaadin.flow.component.HasHelper;
import com.vaadin.flow.component.HasLabel;
import com.vaadin.flow.component.HasSize;
import com.vaadin.flow.component.HasValidation;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.Synchronize;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.dependency.JavaScript;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.shared.ClientValidationUtil;
import com.vaadin.flow.component.shared.HasClientValidation;
import com.vaadin.flow.component.timepicker.FieldValidationUtil;
import com.vaadin.flow.component.timepicker.GeneratedVaadinTimePicker;
import com.vaadin.flow.component.timepicker.StepsUtil;
import com.vaadin.flow.data.binder.HasValidator;
import com.vaadin.flow.data.binder.ValidationResult;
import com.vaadin.flow.data.binder.ValidationStatusChangeEvent;
import com.vaadin.flow.data.binder.ValidationStatusChangeListener;
import com.vaadin.flow.data.binder.Validator;
import com.vaadin.flow.function.DeploymentConfiguration;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.function.SerializableFunction;
import com.vaadin.flow.internal.StateTree;
import com.vaadin.flow.server.VaadinSession;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.time.Duration;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.Locale;
import java.util.Objects;
import java.util.stream.Stream;

@JavaScript(value="frontend://timepickerConnector.js")
@JsModule(value="./timepickerConnector.js")
public class TimePicker
extends GeneratedVaadinTimePicker<TimePicker, LocalTime>
implements HasSize,
HasValidation,
HasEnabled,
HasHelper,
HasLabel,
HasValidator<LocalTime>,
HasClientValidation {
    private static final SerializableFunction<String, LocalTime> PARSER = (SerializableFunction & Serializable)valueFromClient -> valueFromClient == null || valueFromClient.isEmpty() ? null : LocalTime.parse(valueFromClient);
    private static final SerializableFunction<LocalTime, String> FORMATTER = (SerializableFunction & Serializable)valueFromModel -> valueFromModel == null ? "" : valueFromModel.toString();
    private static final String PROP_AUTO_OPEN_DISABLED = "autoOpenDisabled";
    private Locale locale;
    private transient DateTimeFormatter dateTimeFormatter;
    private LocalTime max;
    private LocalTime min;
    private boolean required;
    private StateTree.ExecutionRegistration pendingLocaleUpdate;

    public TimePicker() {
        this((LocalTime)null);
    }

    public TimePicker(LocalTime time) {
        super(time, null, String.class, PARSER, FORMATTER);
        this.setInvalid(false);
        this.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> this.validate());
        if (this.isEnforcedFieldValidationEnabled()) {
            this.addClientValidatedEventListener((ComponentEventListener & Serializable)e -> this.validate());
        }
    }

    public TimePicker(String label) {
        this();
        this.setLabel(label);
    }

    public TimePicker(String label, LocalTime time) {
        this(time);
        this.setLabel(label);
    }

    public TimePicker(HasValue.ValueChangeListener<AbstractField.ComponentValueChangeEvent<TimePicker, LocalTime>> listener) {
        this();
        this.addValueChangeListener(listener);
    }

    @Override
    public void setLabel(String label) {
        super.setLabel(label);
    }

    public void setValue(LocalTime value) {
        if (value != null) {
            value = value.truncatedTo(ChronoUnit.MILLIS);
        }
        LocalTime oldValue = (LocalTime)this.getValue();
        super.setValue((Object)value);
        if (Objects.equals(oldValue, this.getEmptyValue()) && Objects.equals(value, this.getEmptyValue()) && this.isInputValuePresent()) {
            this.getElement().executeJs("if (!this.value) this.__inputElement.value = ''", new Serializable[0]);
            this.getElement().setProperty("_hasInputValue", false);
            this.fireEvent((ComponentEvent)new HasClientValidation.ClientValidatedEvent((Component)this, false));
        }
    }

    public String getLabel() {
        return this.getLabelString();
    }

    @Override
    public void setErrorMessage(String errorMessage) {
        super.setErrorMessage(errorMessage);
    }

    public String getErrorMessage() {
        return this.getErrorMessageString();
    }

    @Override
    public void setInvalid(boolean invalid) {
        super.setInvalid(invalid);
    }

    public boolean isInvalid() {
        return this.isInvalidBoolean();
    }

    public Validator<LocalTime> getDefaultValidator() {
        if (this.isEnforcedFieldValidationEnabled()) {
            return (Validator & Serializable)(value, context) -> this.checkValidity((LocalTime)value);
        }
        return Validator.alwaysPass();
    }

    public Registration addValidationStatusChangeListener(ValidationStatusChangeListener<LocalTime> listener) {
        if (this.isEnforcedFieldValidationEnabled()) {
            return this.addClientValidatedEventListener((ComponentEventListener & Serializable)event -> listener.validationStatusChanged(new ValidationStatusChangeEvent((HasValue)this, !this.isInvalid())));
        }
        return null;
    }

    private ValidationResult checkValidity(LocalTime value) {
        ValidationResult greaterThanMaxValidation;
        if (this.isEnforcedFieldValidationEnabled()) {
            boolean hasNonParsableValue;
            boolean bl = hasNonParsableValue = Objects.equals(value, this.getEmptyValue()) && this.isInputValuePresent();
            if (hasNonParsableValue) {
                return ValidationResult.error((String)"");
            }
        }
        if ((greaterThanMaxValidation = TimePicker.checkGreaterThanMax(value, this.max)).isError()) {
            return greaterThanMaxValidation;
        }
        ValidationResult smallThanMinValidation = TimePicker.checkSmallerThanMin(value, this.min);
        if (smallThanMinValidation.isError()) {
            return smallThanMinValidation;
        }
        return ValidationResult.ok();
    }

    public static <V extends Comparable<V>> ValidationResult checkGreaterThanMax(V value, V maxValue) {
        boolean isGreaterThanMax;
        boolean bl = isGreaterThanMax = value != null && maxValue != null && value.compareTo(maxValue) > 0;
        if (isGreaterThanMax) {
            return ValidationResult.error((String)"");
        }
        return ValidationResult.ok();
    }

    public static <V extends Comparable<V>> ValidationResult checkSmallerThanMin(V value, V minValue) {
        boolean isSmallerThanMin;
        boolean bl = isSmallerThanMin = value != null && minValue != null && value.compareTo(minValue) < 0;
        if (isSmallerThanMin) {
            return ValidationResult.error((String)"");
        }
        return ValidationResult.ok();
    }

    public static <V> ValidationResult checkRequired(boolean required, V value, V emptyValue) {
        boolean isRequiredButEmpty;
        boolean bl = isRequiredButEmpty = required && Objects.equals(emptyValue, value);
        if (isRequiredButEmpty) {
            return ValidationResult.error((String)"");
        }
        return ValidationResult.ok();
    }

    private boolean isInvalid(LocalTime value) {
        ValidationResult requiredValidation = TimePicker.checkRequired(this.required, value, this.getEmptyValue());
        return requiredValidation.isError() || this.checkValidity(value).isError();
    }

    @Synchronize(property="_hasInputValue", value={"has-input-value-changed"})
    protected boolean isInputValuePresent() {
        return this.getElement().getProperty("_hasInputValue", false);
    }

    @Override
    public void setPlaceholder(String placeholder) {
        super.setPlaceholder(placeholder);
    }

    public String getPlaceholder() {
        return this.getPlaceholderString();
    }

    @Override
    public void setRequired(boolean required) {
        super.setRequired(required);
        this.required = required;
    }

    public void setRequiredIndicatorVisible(boolean requiredIndicatorVisible) {
        super.setRequiredIndicatorVisible(requiredIndicatorVisible);
        this.required = requiredIndicatorVisible;
    }

    public boolean isRequired() {
        return this.isRequiredBoolean();
    }

    public void setStep(Duration step) {
        Objects.requireNonNull(step, "Step cannot be null");
        super.setStep(StepsUtil.convertDurationToStepsValue(step));
    }

    public Duration getStep() {
        if (!this.getElement().hasProperty("step")) {
            return StepsUtil.DEFAULT_WEB_COMPONENT_STEP;
        }
        return StepsUtil.convertStepsValueToDuration(this.getStepDouble());
    }

    @Override
    public Registration addInvalidChangeListener(ComponentEventListener<GeneratedVaadinTimePicker.InvalidChangeEvent<TimePicker>> listener) {
        return super.addInvalidChangeListener(listener);
    }

    @Override
    protected void validate() {
        this.setInvalid(this.isInvalid((LocalTime)this.getValue()));
    }

    protected void onAttach(AttachEvent attachEvent) {
        super.onAttach(attachEvent);
        this.initConnector();
        this.requestLocaleUpdate();
        if (this.isEnforcedFieldValidationEnabled()) {
            ClientValidationUtil.preventWebComponentFromModifyingInvalidState((Component)this);
        } else {
            FieldValidationUtil.disableClientValidation(this);
        }
    }

    private void initConnector() {
        this.runBeforeClientResponse((SerializableConsumer<UI>)(SerializableConsumer & Serializable)ui -> ui.getPage().executeJavaScript("window.Vaadin.Flow.timepickerConnector.initLazy($0)", new Serializable[]{this.getElement()}));
    }

    public void setLocale(Locale locale) {
        Objects.requireNonNull(locale, "Locale must not be null.");
        if (locale.getLanguage().isEmpty()) {
            throw new UnsupportedOperationException("Given Locale " + locale.getDisplayName() + " is not supported by time picker because it is missing the language information.");
        }
        this.locale = locale;
        this.requestLocaleUpdate();
    }

    public Locale getLocale() {
        if (this.locale != null) {
            return this.locale;
        }
        return super.getLocale();
    }

    private void requestLocaleUpdate() {
        this.getUI().ifPresent(ui -> {
            if (this.pendingLocaleUpdate != null) {
                this.pendingLocaleUpdate.remove();
            }
            this.pendingLocaleUpdate = ui.beforeClientResponse((Component)this, (SerializableConsumer & Serializable)context -> {
                this.pendingLocaleUpdate = null;
                this.executeLocaleUpdate();
            });
        });
    }

    private void executeLocaleUpdate() {
        Locale appliedLocale = this.getLocale();
        StringBuilder bcp47LanguageTag = new StringBuilder(appliedLocale.getLanguage());
        if (!appliedLocale.getCountry().isEmpty()) {
            bcp47LanguageTag.append("-").append(appliedLocale.getCountry());
        }
        this.runBeforeClientResponse((SerializableConsumer<UI>)(SerializableConsumer & Serializable)ui -> this.getElement().callJsFunction("$connector.setLocale", new Serializable[]{bcp47LanguageTag.toString()}));
    }

    @Override
    @Deprecated
    public void setMin(String min) {
        this.min = TimePicker.parse(min, this.initializeAndReturnFormatter());
        super.setMin(min);
    }

    public void setMinTime(LocalTime min) {
        this.min = min;
        super.setMin(TimePicker.format(min));
    }

    @Deprecated
    public String getMin() {
        return super.getMinString();
    }

    public LocalTime getMinTime() {
        return this.min;
    }

    @Override
    @Deprecated
    public void setMax(String max) {
        this.max = TimePicker.parse(max, this.initializeAndReturnFormatter());
        super.setMax(max);
    }

    public void setMaxTime(LocalTime max) {
        this.max = max;
        super.setMax(TimePicker.format(max));
    }

    @Deprecated
    public String getMax() {
        return super.getMaxString();
    }

    public LocalTime getMaxTime() {
        return this.max;
    }

    @Override
    public void setClearButtonVisible(boolean clearButtonVisible) {
        super.setClearButtonVisible(clearButtonVisible);
    }

    public boolean isClearButtonVisible() {
        return super.isClearButtonVisibleBoolean();
    }

    private void runBeforeClientResponse(SerializableConsumer<UI> command) {
        this.getElement().getNode().runWhenAttached((SerializableConsumer & Serializable)ui -> ui.beforeClientResponse((Component)this, (SerializableConsumer & Serializable)context -> command.accept(ui)));
    }

    public void setAutoOpen(boolean autoOpen) {
        this.getElement().setProperty(PROP_AUTO_OPEN_DISABLED, !autoOpen);
    }

    public boolean isAutoOpen() {
        return !this.getElement().getProperty(PROP_AUTO_OPEN_DISABLED, false);
    }

    public static Stream<Locale> getSupportedAvailableLocales() {
        return Stream.of(Locale.getAvailableLocales()).filter(locale -> !locale.getLanguage().isEmpty());
    }

    private DateTimeFormatter initializeAndReturnFormatter() {
        if (this.dateTimeFormatter == null) {
            this.dateTimeFormatter = this.locale == null ? DateTimeFormatter.ISO_LOCAL_TIME : DateTimeFormatter.ISO_LOCAL_TIME.withLocale(this.locale);
        }
        return this.dateTimeFormatter;
    }

    private static String format(LocalTime time) {
        return time != null ? time.toString() : null;
    }

    private static LocalTime parse(String time, DateTimeFormatter formatter) {
        return time != null ? LocalTime.parse(time, formatter) : null;
    }

    protected boolean isEnforcedFieldValidationEnabled() {
        VaadinSession session = VaadinSession.getCurrent();
        if (session == null) {
            return false;
        }
        DeploymentConfiguration configuration = session.getConfiguration();
        if (configuration == null) {
            return false;
        }
        return configuration.isEnforcedFieldValidationEnabled();
    }
}

