/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.timepicker;

import com.vaadin.flow.component.AbstractField;
import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasEnabled;
import com.vaadin.flow.component.HasSize;
import com.vaadin.flow.component.HasValidation;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.dependency.JavaScript;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.timepicker.FieldValidationUtil;
import com.vaadin.flow.component.timepicker.GeneratedVaadinTimePicker;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.function.SerializableFunction;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.time.Duration;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.Locale;
import java.util.Objects;
import java.util.stream.Stream;

@JavaScript(value="frontend://timepickerConnector.js")
@JsModule(value="./timepickerConnector.js")
public class TimePicker
extends GeneratedVaadinTimePicker<TimePicker, LocalTime>
implements HasSize,
HasValidation,
HasEnabled {
    private static final SerializableFunction<String, LocalTime> PARSER = (SerializableFunction & Serializable)valueFromClient -> valueFromClient == null || valueFromClient.isEmpty() ? null : LocalTime.parse(valueFromClient);
    private static final SerializableFunction<LocalTime, String> FORMATTER = (SerializableFunction & Serializable)valueFromModel -> valueFromModel == null ? "" : valueFromModel.toString();
    private static final long MILLISECONDS_IN_A_DAY = 86400000L;
    private static final long MILLISECONDS_IN_AN_HOUR = 3600000L;
    private Locale locale;
    private transient DateTimeFormatter dateTimeFormatter;
    private LocalTime max;
    private LocalTime min;
    private boolean required;

    public TimePicker() {
        this((LocalTime)null);
    }

    public TimePicker(LocalTime time) {
        super(time, null, String.class, PARSER, FORMATTER);
        this.setInvalid(false);
        this.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> this.validate());
        FieldValidationUtil.disableClientValidation((Component)this);
    }

    public TimePicker(String label) {
        this();
        this.setLabel(label);
    }

    public TimePicker(String label, LocalTime time) {
        this(time);
        this.setLabel(label);
    }

    public TimePicker(HasValue.ValueChangeListener<AbstractField.ComponentValueChangeEvent<TimePicker, LocalTime>> listener) {
        this();
        this.addValueChangeListener(listener);
    }

    @Override
    public void setLabel(String label) {
        super.setLabel(label);
    }

    public void setValue(LocalTime value) {
        if (value == null) {
            super.setValue(null);
        } else {
            LocalTime truncatedValue = value.truncatedTo(ChronoUnit.MILLIS);
            super.setValue((Object)truncatedValue);
        }
    }

    public String getLabel() {
        return this.getLabelString();
    }

    @Override
    public void setErrorMessage(String errorMessage) {
        super.setErrorMessage(errorMessage);
    }

    public String getErrorMessage() {
        return this.getErrorMessageString();
    }

    @Override
    public void setInvalid(boolean invalid) {
        super.setInvalid(invalid);
    }

    public boolean isInvalid() {
        return this.isInvalidBoolean();
    }

    private boolean isInvalid(LocalTime value) {
        boolean isRequiredButEmpty = this.required && Objects.equals(this.getEmptyValue(), value);
        boolean isGreaterThanMax = value != null && this.max != null && value.isAfter(this.max);
        boolean isSmallerThenMin = value != null && this.min != null && value.isBefore(this.min);
        return isRequiredButEmpty || isGreaterThanMax || isSmallerThenMin;
    }

    @Override
    public void setPlaceholder(String placeholder) {
        super.setPlaceholder(placeholder);
    }

    public String getPlaceholder() {
        return this.getPlaceholderString();
    }

    @Override
    public void setRequired(boolean required) {
        super.setRequired(required);
        this.required = required;
    }

    public void setRequiredIndicatorVisible(boolean requiredIndicatorVisible) {
        super.setRequiredIndicatorVisible(requiredIndicatorVisible);
        this.required = requiredIndicatorVisible;
    }

    public boolean isRequired() {
        return this.isRequiredBoolean();
    }

    public void setStep(Duration step) {
        Objects.requireNonNull(step, "Step cannot be null");
        long stepAsMilliseconds = step.getSeconds() * 1000L + (long)((double)step.getNano() / 1000000.0);
        if (step.isNegative() || stepAsMilliseconds == 0L) {
            throw new IllegalArgumentException("Step cannot be negative and must be larger than 0 milliseconds");
        }
        if (86400000L % stepAsMilliseconds != 0L && 3600000L % stepAsMilliseconds != 0L) {
            throw new IllegalArgumentException("Given step " + step.toString() + " does not divide evenly a day or an hour.");
        }
        super.setStep((double)step.getSeconds() + (double)step.getNano() / 1.0E9);
    }

    public Duration getStep() {
        if (!this.getElement().hasProperty("step")) {
            return Duration.ofHours(1L);
        }
        return Duration.ofNanos((long)(this.getStepDouble() * 1.0E9));
    }

    @Override
    public Registration addInvalidChangeListener(ComponentEventListener<GeneratedVaadinTimePicker.InvalidChangeEvent<TimePicker>> listener) {
        return super.addInvalidChangeListener(listener);
    }

    @Override
    protected void validate() {
        this.setInvalid(this.isInvalid((LocalTime)this.getValue()));
    }

    protected void onAttach(AttachEvent attachEvent) {
        super.onAttach(attachEvent);
        if (this.getLocale() == null) {
            this.setLocale(attachEvent.getUI().getLocale());
        }
        this.initConnector();
    }

    private void initConnector() {
        this.runBeforeClientResponse((SerializableConsumer<UI>)(SerializableConsumer & Serializable)ui -> ui.getPage().executeJavaScript("window.Vaadin.Flow.timepickerConnector.initLazy($0)", new Serializable[]{this.getElement()}));
    }

    public void setLocale(Locale locale) {
        Objects.requireNonNull(locale, "Locale must not be null.");
        if (locale.getLanguage().isEmpty()) {
            throw new UnsupportedOperationException("Given Locale " + locale.getDisplayName() + " is not supported by time picker because it is missing the language information.");
        }
        this.locale = locale;
        this.dateTimeFormatter = null;
        StringBuilder bcp47LanguageTag = new StringBuilder(locale.getLanguage());
        if (!locale.getCountry().isEmpty()) {
            bcp47LanguageTag.append("-").append(locale.getCountry());
        }
        this.runBeforeClientResponse((SerializableConsumer<UI>)(SerializableConsumer & Serializable)ui -> this.getElement().callFunction("$connector.setLocale", new Serializable[]{bcp47LanguageTag.toString()}));
    }

    public Locale getLocale() {
        return this.locale;
    }

    @Override
    public void setMin(String min) {
        this.min = LocalTime.parse(min, this.initializeAndReturnFormatter());
        super.setMin(min);
    }

    public String getMin() {
        return super.getMinString();
    }

    @Override
    public void setMax(String max) {
        this.max = LocalTime.parse(max, this.initializeAndReturnFormatter());
        super.setMax(max);
    }

    public String getMax() {
        return super.getMaxString();
    }

    @Override
    public void setClearButtonVisible(boolean clearButtonVisible) {
        super.setClearButtonVisible(clearButtonVisible);
    }

    public boolean isClearButtonVisible() {
        return super.isClearButtonVisibleBoolean();
    }

    private void runBeforeClientResponse(SerializableConsumer<UI> command) {
        this.getElement().getNode().runWhenAttached((SerializableConsumer & Serializable)ui -> ui.beforeClientResponse((Component)this, (SerializableConsumer & Serializable)context -> command.accept(ui)));
    }

    public static Stream<Locale> getSupportedAvailableLocales() {
        return Stream.of(Locale.getAvailableLocales()).filter(locale -> !locale.getLanguage().isEmpty());
    }

    private DateTimeFormatter initializeAndReturnFormatter() {
        if (this.dateTimeFormatter == null) {
            this.dateTimeFormatter = this.locale == null ? DateTimeFormatter.ISO_LOCAL_TIME : DateTimeFormatter.ISO_LOCAL_TIME.withLocale(this.locale);
        }
        return this.dateTimeFormatter;
    }
}

