/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.timepicker;

import com.vaadin.experimental.Feature;
import com.vaadin.experimental.FeatureFlags;
import com.vaadin.flow.component.AbstractField;
import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasEnabled;
import com.vaadin.flow.component.HasHelper;
import com.vaadin.flow.component.HasLabel;
import com.vaadin.flow.component.HasSize;
import com.vaadin.flow.component.HasTheme;
import com.vaadin.flow.component.HasValidation;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.Synchronize;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.shared.ClientValidationUtil;
import com.vaadin.flow.component.shared.HasAllowedCharPattern;
import com.vaadin.flow.component.shared.HasClearButton;
import com.vaadin.flow.component.shared.HasClientValidation;
import com.vaadin.flow.component.shared.HasTooltip;
import com.vaadin.flow.component.shared.ValidationUtil;
import com.vaadin.flow.component.timepicker.FieldValidationUtil;
import com.vaadin.flow.component.timepicker.GeneratedVaadinTimePicker;
import com.vaadin.flow.component.timepicker.StepsUtil;
import com.vaadin.flow.component.timepicker.TimePickerVariant;
import com.vaadin.flow.data.binder.HasValidator;
import com.vaadin.flow.data.binder.ValidationResult;
import com.vaadin.flow.data.binder.ValidationStatusChangeEvent;
import com.vaadin.flow.data.binder.ValidationStatusChangeListener;
import com.vaadin.flow.data.binder.Validator;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.function.SerializableFunction;
import com.vaadin.flow.internal.StateTree;
import com.vaadin.flow.server.VaadinContext;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.time.Duration;
import java.time.LocalTime;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import java.util.Locale;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@JsModule(value="./vaadin-time-picker/timepickerConnector.js")
public class TimePicker
extends GeneratedVaadinTimePicker<TimePicker, LocalTime>
implements HasSize,
HasValidation,
HasEnabled,
HasHelper,
HasLabel,
HasTheme,
HasClearButton,
HasAllowedCharPattern,
HasValidator<LocalTime>,
HasClientValidation,
HasTooltip {
    private static final SerializableFunction<String, LocalTime> PARSER = (SerializableFunction & Serializable)valueFromClient -> valueFromClient == null || valueFromClient.isEmpty() ? null : LocalTime.parse(valueFromClient);
    private static final SerializableFunction<LocalTime, String> FORMATTER = (SerializableFunction & Serializable)valueFromModel -> valueFromModel == null ? "" : valueFromModel.toString();
    private static final String PROP_AUTO_OPEN_DISABLED = "autoOpenDisabled";
    private Locale locale;
    private LocalTime max;
    private LocalTime min;
    private boolean required;
    private StateTree.ExecutionRegistration pendingLocaleUpdate;

    public TimePicker() {
        this((LocalTime)null, true);
    }

    public TimePicker(LocalTime time) {
        this(time, false);
    }

    private TimePicker(LocalTime time, boolean isInitialValueOptional) {
        super(time, null, String.class, PARSER, FORMATTER, isInitialValueOptional);
        this.setInvalid(false);
        this.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> this.validate());
        if (this.isFeatureFlagEnabled(FeatureFlags.ENFORCE_FIELD_VALIDATION)) {
            this.addClientValidatedEventListener((ComponentEventListener & Serializable)event -> this.validate());
        }
    }

    public TimePicker(String label) {
        this();
        this.setLabel(label);
    }

    public TimePicker(String label, LocalTime time) {
        this(time);
        this.setLabel(label);
    }

    public TimePicker(HasValue.ValueChangeListener<AbstractField.ComponentValueChangeEvent<TimePicker, LocalTime>> listener) {
        this();
        this.addValueChangeListener(listener);
    }

    public TimePicker(LocalTime time, HasValue.ValueChangeListener<AbstractField.ComponentValueChangeEvent<TimePicker, LocalTime>> listener) {
        this(time);
        this.addValueChangeListener(listener);
    }

    public TimePicker(String label, LocalTime time, HasValue.ValueChangeListener<AbstractField.ComponentValueChangeEvent<TimePicker, LocalTime>> listener) {
        this(time);
        this.setLabel(label);
        this.addValueChangeListener(listener);
    }

    @Override
    public void setLabel(String label) {
        super.setLabel(label);
    }

    public void setValue(LocalTime value) {
        if (value != null) {
            value = value.truncatedTo(ChronoUnit.MILLIS);
        }
        super.setValue((Object)value);
    }

    public String getLabel() {
        return this.getLabelString();
    }

    @Override
    public void setErrorMessage(String errorMessage) {
        super.setErrorMessage(errorMessage);
    }

    public String getErrorMessage() {
        return this.getErrorMessageString();
    }

    @Override
    public void setInvalid(boolean invalid) {
        super.setInvalid(invalid);
    }

    public boolean isInvalid() {
        return this.isInvalidBoolean();
    }

    public Validator<LocalTime> getDefaultValidator() {
        if (this.isFeatureFlagEnabled(FeatureFlags.ENFORCE_FIELD_VALIDATION)) {
            return (Validator & Serializable)(value, context) -> this.checkValidity((LocalTime)value);
        }
        return Validator.alwaysPass();
    }

    public Registration addValidationStatusChangeListener(ValidationStatusChangeListener<LocalTime> listener) {
        if (this.isFeatureFlagEnabled(FeatureFlags.ENFORCE_FIELD_VALIDATION)) {
            return this.addClientValidatedEventListener((ComponentEventListener & Serializable)event -> listener.validationStatusChanged(new ValidationStatusChangeEvent((HasValue)this, !this.isInvalid())));
        }
        return null;
    }

    private ValidationResult checkValidity(LocalTime value) {
        ValidationResult greaterThanMaxValidation;
        if (this.isFeatureFlagEnabled(FeatureFlags.ENFORCE_FIELD_VALIDATION)) {
            boolean hasNonParsableValue;
            boolean bl = hasNonParsableValue = value == this.getEmptyValue() && this.isInputValuePresent();
            if (hasNonParsableValue) {
                return ValidationResult.error((String)"");
            }
        }
        if ((greaterThanMaxValidation = ValidationUtil.checkGreaterThanMax((Comparable)value, (Comparable)this.max)).isError()) {
            return greaterThanMaxValidation;
        }
        ValidationResult smallThanMinValidation = ValidationUtil.checkSmallerThanMin((Comparable)value, (Comparable)this.min);
        if (smallThanMinValidation.isError()) {
            return smallThanMinValidation;
        }
        return ValidationResult.ok();
    }

    private boolean isInvalid(LocalTime value) {
        ValidationResult requiredValidation = ValidationUtil.checkRequired((boolean)this.required, (Object)value, (Object)((LocalTime)this.getEmptyValue()));
        return requiredValidation.isError() || this.checkValidity(value).isError();
    }

    @Synchronize(property="_hasInputValue", value={"has-input-value-changed"})
    private boolean isInputValuePresent() {
        return this.getElement().getProperty("_hasInputValue", false);
    }

    @Override
    public void setPlaceholder(String placeholder) {
        super.setPlaceholder(placeholder);
    }

    public String getPlaceholder() {
        return this.getPlaceholderString();
    }

    @Override
    public void setRequired(boolean required) {
        super.setRequired(required);
        this.required = required;
    }

    public void setRequiredIndicatorVisible(boolean requiredIndicatorVisible) {
        super.setRequiredIndicatorVisible(requiredIndicatorVisible);
        this.required = requiredIndicatorVisible;
    }

    public boolean isRequired() {
        return this.isRequiredBoolean();
    }

    public void setStep(Duration step) {
        Objects.requireNonNull(step, "Step cannot be null");
        super.setStep(StepsUtil.convertDurationToStepsValue(step));
    }

    public Duration getStep() {
        if (!this.getElement().hasProperty("step")) {
            return StepsUtil.DEFAULT_WEB_COMPONENT_STEP;
        }
        return StepsUtil.convertStepsValueToDuration(this.getStepDouble());
    }

    @Override
    public Registration addInvalidChangeListener(ComponentEventListener<InvalidChangeEvent<TimePicker>> listener) {
        return super.addInvalidChangeListener(listener);
    }

    public void addThemeVariants(TimePickerVariant ... variants) {
        this.getThemeNames().addAll((Collection)Stream.of(variants).map(TimePickerVariant::getVariantName).collect(Collectors.toList()));
    }

    public void removeThemeVariants(TimePickerVariant ... variants) {
        this.getThemeNames().removeAll((Collection)Stream.of(variants).map(TimePickerVariant::getVariantName).collect(Collectors.toList()));
    }

    @Override
    protected void validate() {
        this.setInvalid(this.isInvalid((LocalTime)this.getValue()));
    }

    protected void onAttach(AttachEvent attachEvent) {
        super.onAttach(attachEvent);
        this.initConnector();
        this.requestLocaleUpdate();
        if (this.isFeatureFlagEnabled(FeatureFlags.ENFORCE_FIELD_VALIDATION)) {
            ClientValidationUtil.preventWebComponentFromSettingItselfToValid((Component)this);
        } else {
            FieldValidationUtil.disableClientValidation(this);
        }
    }

    private void initConnector() {
        this.runBeforeClientResponse((SerializableConsumer<UI>)(SerializableConsumer & Serializable)ui -> ui.getPage().executeJs("window.Vaadin.Flow.timepickerConnector.initLazy($0)", new Serializable[]{this.getElement()}));
    }

    public void setLocale(Locale locale) {
        Objects.requireNonNull(locale, "Locale must not be null.");
        if (locale.getLanguage().isEmpty()) {
            throw new UnsupportedOperationException("Given Locale " + locale.getDisplayName() + " is not supported by time picker because it is missing the language information.");
        }
        this.locale = locale;
        this.requestLocaleUpdate();
    }

    public Locale getLocale() {
        if (this.locale != null) {
            return this.locale;
        }
        return super.getLocale();
    }

    private void requestLocaleUpdate() {
        this.getUI().ifPresent(ui -> {
            if (this.pendingLocaleUpdate != null) {
                this.pendingLocaleUpdate.remove();
            }
            this.pendingLocaleUpdate = ui.beforeClientResponse((Component)this, (SerializableConsumer & Serializable)context -> {
                this.pendingLocaleUpdate = null;
                this.executeLocaleUpdate();
            });
        });
    }

    private void executeLocaleUpdate() {
        Locale appliedLocale = this.getLocale();
        StringBuilder bcp47LanguageTag = new StringBuilder(appliedLocale.getLanguage());
        if (!appliedLocale.getCountry().isEmpty()) {
            bcp47LanguageTag.append("-").append(appliedLocale.getCountry());
        }
        this.runBeforeClientResponse((SerializableConsumer<UI>)(SerializableConsumer & Serializable)ui -> this.getElement().callJsFunction("$connector.setLocale", new Serializable[]{bcp47LanguageTag.toString()}));
    }

    public void setMin(LocalTime min) {
        this.min = min;
        super.setMin(TimePicker.format(min));
    }

    @Deprecated
    public void setMinTime(LocalTime min) {
        this.setMin(min);
    }

    public LocalTime getMin() {
        return this.min;
    }

    @Deprecated
    public LocalTime getMinTime() {
        return this.getMin();
    }

    public void setMax(LocalTime max) {
        this.max = max;
        super.setMax(TimePicker.format(max));
    }

    @Deprecated
    public void setMaxTime(LocalTime max) {
        this.setMax(max);
    }

    public LocalTime getMax() {
        return this.max;
    }

    @Deprecated
    public LocalTime getMaxTime() {
        return this.getMax();
    }

    private void runBeforeClientResponse(SerializableConsumer<UI> command) {
        this.getElement().getNode().runWhenAttached((SerializableConsumer & Serializable)ui -> ui.beforeClientResponse((Component)this, (SerializableConsumer & Serializable)context -> command.accept(ui)));
    }

    public void setAutoOpen(boolean autoOpen) {
        this.getElement().setProperty(PROP_AUTO_OPEN_DISABLED, !autoOpen);
    }

    public boolean isAutoOpen() {
        return !this.getElement().getProperty(PROP_AUTO_OPEN_DISABLED, false);
    }

    public static Stream<Locale> getSupportedAvailableLocales() {
        return Stream.of(Locale.getAvailableLocales()).filter(locale -> !locale.getLanguage().isEmpty());
    }

    private static String format(LocalTime time) {
        return time != null ? time.toString() : null;
    }

    protected boolean isFeatureFlagEnabled(Feature feature) {
        VaadinService service = VaadinService.getCurrent();
        if (service == null) {
            return false;
        }
        return FeatureFlags.get((VaadinContext)service.getContext()).isEnabled(feature);
    }

    public static class InvalidChangeEvent<T extends GeneratedVaadinTimePicker<T, ?>>
    extends GeneratedVaadinTimePicker.InvalidChangeEvent<T> {
        public InvalidChangeEvent(T source, boolean fromClient) {
            super(source, fromClient);
        }
    }
}

