/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.timepicker;

import com.vaadin.flow.component.AbstractField;
import com.vaadin.flow.component.AbstractSinglePropertyField;
import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.Focusable;
import com.vaadin.flow.component.HasHelper;
import com.vaadin.flow.component.HasLabel;
import com.vaadin.flow.component.HasSize;
import com.vaadin.flow.component.HasStyle;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.Synchronize;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.dependency.NpmPackage;
import com.vaadin.flow.component.shared.ClientValidationUtil;
import com.vaadin.flow.component.shared.HasAllowedCharPattern;
import com.vaadin.flow.component.shared.HasAutoOpen;
import com.vaadin.flow.component.shared.HasClearButton;
import com.vaadin.flow.component.shared.HasClientValidation;
import com.vaadin.flow.component.shared.HasOverlayClassName;
import com.vaadin.flow.component.shared.HasPrefix;
import com.vaadin.flow.component.shared.HasThemeVariant;
import com.vaadin.flow.component.shared.HasTooltip;
import com.vaadin.flow.component.shared.HasValidationProperties;
import com.vaadin.flow.component.shared.ValidationUtil;
import com.vaadin.flow.component.timepicker.StepsUtil;
import com.vaadin.flow.component.timepicker.TimePickerVariant;
import com.vaadin.flow.data.binder.HasValidator;
import com.vaadin.flow.data.binder.ValidationResult;
import com.vaadin.flow.data.binder.ValidationStatusChangeEvent;
import com.vaadin.flow.data.binder.ValidationStatusChangeListener;
import com.vaadin.flow.data.binder.Validator;
import com.vaadin.flow.dom.PropertyChangeListener;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.function.SerializableFunction;
import com.vaadin.flow.internal.StateTree;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.time.Duration;
import java.time.LocalTime;
import java.time.temporal.ChronoUnit;
import java.util.Locale;
import java.util.Objects;
import java.util.stream.Stream;

@Tag(value="vaadin-time-picker")
@NpmPackage.Container(value={@NpmPackage(value="@vaadin/polymer-legacy-adapter", version="24.0.9"), @NpmPackage(value="@vaadin/time-picker", version="24.0.9")})
@JsModule.Container(value={@JsModule(value="@vaadin/polymer-legacy-adapter/style-modules.js"), @JsModule(value="@vaadin/time-picker/src/vaadin-time-picker.js"), @JsModule(value="./vaadin-time-picker/timepickerConnector.js")})
public class TimePicker
extends AbstractSinglePropertyField<TimePicker, LocalTime>
implements Focusable<TimePicker>,
HasAllowedCharPattern,
HasAutoOpen,
HasClearButton,
HasClientValidation,
HasHelper,
HasLabel,
HasPrefix,
HasOverlayClassName,
HasSize,
HasStyle,
HasTooltip,
HasThemeVariant<TimePickerVariant>,
HasValidationProperties,
HasValidator<LocalTime> {
    private static final SerializableFunction<String, LocalTime> PARSER = (SerializableFunction & Serializable)valueFromClient -> valueFromClient == null || valueFromClient.isEmpty() ? null : LocalTime.parse(valueFromClient);
    private static final SerializableFunction<LocalTime, String> FORMATTER = (SerializableFunction & Serializable)valueFromModel -> valueFromModel == null ? "" : valueFromModel.toString();
    private Locale locale;
    private LocalTime max;
    private LocalTime min;
    private boolean required;
    private StateTree.ExecutionRegistration pendingLocaleUpdate;

    public TimePicker() {
        this((LocalTime)null, true);
    }

    public TimePicker(LocalTime time) {
        this(time, false);
    }

    private TimePicker(LocalTime time, boolean isInitialValueOptional) {
        super("value", (Object)time, String.class, PARSER, FORMATTER);
        if (this.getElement().getProperty("value") == null || !isInitialValueOptional) {
            this.setPresentationValue(time);
        }
        this.setInvalid(false);
        this.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> this.validate());
        this.addClientValidatedEventListener((ComponentEventListener & Serializable)event -> this.validate());
        this.getElement().addPropertyChangeListener("invalid", (PropertyChangeListener & Serializable)event -> this.fireEvent(new InvalidChangeEvent(this, event.isUserOriginated())));
    }

    public TimePicker(String label) {
        this();
        this.setLabel(label);
    }

    public TimePicker(String label, LocalTime time) {
        this(time);
        this.setLabel(label);
    }

    public TimePicker(HasValue.ValueChangeListener<AbstractField.ComponentValueChangeEvent<TimePicker, LocalTime>> listener) {
        this();
        this.addValueChangeListener(listener);
    }

    public TimePicker(LocalTime time, HasValue.ValueChangeListener<AbstractField.ComponentValueChangeEvent<TimePicker, LocalTime>> listener) {
        this(time);
        this.addValueChangeListener(listener);
    }

    public TimePicker(String label, LocalTime time, HasValue.ValueChangeListener<AbstractField.ComponentValueChangeEvent<TimePicker, LocalTime>> listener) {
        this(time);
        this.setLabel(label);
        this.addValueChangeListener(listener);
    }

    public void setLabel(String label) {
        this.getElement().setProperty("label", label == null ? "" : label);
    }

    public void setValue(LocalTime value) {
        if (value != null) {
            value = value.truncatedTo(ChronoUnit.MILLIS);
        }
        LocalTime oldValue = (LocalTime)this.getValue();
        super.setValue((Object)value);
        if (Objects.equals(oldValue, this.getEmptyValue()) && Objects.equals(value, this.getEmptyValue()) && this.isInputValuePresent()) {
            this.getElement().executeJs("if (!this.value) this._inputElementValue = ''", new Serializable[0]);
            this.getElement().setProperty("_hasInputValue", false);
            this.fireEvent((ComponentEvent)new HasClientValidation.ClientValidatedEvent((Component)this, false));
        }
    }

    public String getLabel() {
        return this.getElement().getProperty("label");
    }

    public Validator<LocalTime> getDefaultValidator() {
        return (Validator & Serializable)(value, context) -> this.checkValidity((LocalTime)value);
    }

    public Registration addValidationStatusChangeListener(ValidationStatusChangeListener<LocalTime> listener) {
        return this.addClientValidatedEventListener((ComponentEventListener & Serializable)event -> listener.validationStatusChanged(new ValidationStatusChangeEvent((HasValue)this, !this.isInvalid())));
    }

    private ValidationResult checkValidity(LocalTime value) {
        boolean hasNonParsableValue;
        boolean bl = hasNonParsableValue = Objects.equals(value, this.getEmptyValue()) && this.isInputValuePresent();
        if (hasNonParsableValue) {
            return ValidationResult.error((String)"");
        }
        ValidationResult greaterThanMaxValidation = ValidationUtil.checkGreaterThanMax((Comparable)value, (Comparable)this.max);
        if (greaterThanMaxValidation.isError()) {
            return greaterThanMaxValidation;
        }
        ValidationResult smallThanMinValidation = ValidationUtil.checkSmallerThanMin((Comparable)value, (Comparable)this.min);
        if (smallThanMinValidation.isError()) {
            return smallThanMinValidation;
        }
        return ValidationResult.ok();
    }

    private boolean isInvalid(LocalTime value) {
        ValidationResult requiredValidation = ValidationUtil.checkRequired((boolean)this.required, (Object)value, (Object)((LocalTime)this.getEmptyValue()));
        return requiredValidation.isError() || this.checkValidity(value).isError();
    }

    @Synchronize(property="_hasInputValue", value={"has-input-value-changed"})
    protected boolean isInputValuePresent() {
        return this.getElement().getProperty("_hasInputValue", false);
    }

    public void setPlaceholder(String placeholder) {
        this.getElement().setProperty("placeholder", placeholder == null ? "" : placeholder);
    }

    public String getPlaceholder() {
        return this.getElement().getProperty("placeholder");
    }

    public void setRequired(boolean required) {
        this.getElement().setProperty("required", required);
        this.required = required;
    }

    public void setRequiredIndicatorVisible(boolean requiredIndicatorVisible) {
        super.setRequiredIndicatorVisible(requiredIndicatorVisible);
        this.required = requiredIndicatorVisible;
    }

    public boolean isRequired() {
        return this.getElement().getProperty("required", false);
    }

    public void setStep(Duration step) {
        Objects.requireNonNull(step, "Step cannot be null");
        this.getElement().setProperty("step", StepsUtil.convertDurationToStepsValue(step));
    }

    public Duration getStep() {
        if (!this.getElement().hasProperty("step")) {
            return StepsUtil.DEFAULT_WEB_COMPONENT_STEP;
        }
        double step = this.getElement().getProperty("step", 0.0);
        return StepsUtil.convertStepsValueToDuration(step);
    }

    public Registration addInvalidChangeListener(ComponentEventListener<InvalidChangeEvent> listener) {
        return this.addListener(InvalidChangeEvent.class, listener);
    }

    protected void validate() {
        this.setInvalid(this.isInvalid((LocalTime)this.getValue()));
    }

    protected void onAttach(AttachEvent attachEvent) {
        super.onAttach(attachEvent);
        this.initConnector();
        this.requestLocaleUpdate();
        ClientValidationUtil.preventWebComponentFromModifyingInvalidState((Component)this);
    }

    private void initConnector() {
        this.runBeforeClientResponse((SerializableConsumer<UI>)(SerializableConsumer & Serializable)ui -> ui.getPage().executeJs("window.Vaadin.Flow.timepickerConnector.initLazy($0)", new Serializable[]{this.getElement()}));
    }

    public void setLocale(Locale locale) {
        Objects.requireNonNull(locale, "Locale must not be null.");
        if (locale.getLanguage().isEmpty()) {
            throw new UnsupportedOperationException("Given Locale " + locale.getDisplayName() + " is not supported by time picker because it is missing the language information.");
        }
        this.locale = locale;
        this.requestLocaleUpdate();
    }

    public Locale getLocale() {
        if (this.locale != null) {
            return this.locale;
        }
        return super.getLocale();
    }

    private void requestLocaleUpdate() {
        this.getUI().ifPresent(ui -> {
            if (this.pendingLocaleUpdate != null) {
                this.pendingLocaleUpdate.remove();
            }
            this.pendingLocaleUpdate = ui.beforeClientResponse((Component)this, (SerializableConsumer & Serializable)context -> {
                this.pendingLocaleUpdate = null;
                this.executeLocaleUpdate();
            });
        });
    }

    private void executeLocaleUpdate() {
        Locale appliedLocale = this.getLocale();
        StringBuilder bcp47LanguageTag = new StringBuilder(appliedLocale.getLanguage());
        if (!appliedLocale.getCountry().isEmpty()) {
            bcp47LanguageTag.append("-").append(appliedLocale.getCountry());
        }
        this.runBeforeClientResponse((SerializableConsumer<UI>)(SerializableConsumer & Serializable)ui -> this.getElement().callJsFunction("$connector.setLocale", new Serializable[]{bcp47LanguageTag.toString()}));
    }

    public void setMin(LocalTime min) {
        this.min = min;
        String minString = TimePicker.format(min);
        this.getElement().setProperty("min", minString == null ? "" : minString);
    }

    public LocalTime getMin() {
        return this.min;
    }

    public void setMax(LocalTime max) {
        this.max = max;
        String maxString = TimePicker.format(max);
        this.getElement().setProperty("max", maxString == null ? "" : maxString);
    }

    public LocalTime getMax() {
        return this.max;
    }

    private void runBeforeClientResponse(SerializableConsumer<UI> command) {
        this.getElement().getNode().runWhenAttached((SerializableConsumer & Serializable)ui -> ui.beforeClientResponse((Component)this, (SerializableConsumer & Serializable)context -> command.accept(ui)));
    }

    public static Stream<Locale> getSupportedAvailableLocales() {
        return Stream.of(Locale.getAvailableLocales()).filter(locale -> !locale.getLanguage().isEmpty());
    }

    private static String format(LocalTime time) {
        return time != null ? time.toString() : null;
    }

    public static class InvalidChangeEvent
    extends ComponentEvent<TimePicker> {
        private final boolean invalid;

        public InvalidChangeEvent(TimePicker source, boolean fromClient) {
            super((Component)source, fromClient);
            this.invalid = source.isInvalid();
        }

        public boolean isInvalid() {
            return this.invalid;
        }
    }
}

