/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.virtuallist;

import com.vaadin.flow.component.ClientCallable;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.Focusable;
import com.vaadin.flow.component.HasSize;
import com.vaadin.flow.component.HasStyle;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.dependency.NpmPackage;
import com.vaadin.flow.component.virtuallist.paging.PagelessDataCommunicator;
import com.vaadin.flow.data.binder.HasDataProvider;
import com.vaadin.flow.data.provider.ArrayUpdater;
import com.vaadin.flow.data.provider.CompositeDataGenerator;
import com.vaadin.flow.data.provider.DataCommunicator;
import com.vaadin.flow.data.provider.DataGenerator;
import com.vaadin.flow.data.provider.DataProvider;
import com.vaadin.flow.data.renderer.ComponentRenderer;
import com.vaadin.flow.data.renderer.Renderer;
import com.vaadin.flow.data.renderer.Rendering;
import com.vaadin.flow.data.renderer.TemplateRenderer;
import com.vaadin.flow.dom.DisabledUpdateMode;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.function.ValueProvider;
import com.vaadin.flow.internal.JsonSerializer;
import com.vaadin.flow.internal.JsonUtils;
import com.vaadin.flow.server.Command;
import com.vaadin.flow.shared.Registration;
import elemental.json.JsonArray;
import elemental.json.JsonValue;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@Tag(value="vaadin-virtual-list")
@NpmPackage.Container(value={@NpmPackage(value="@vaadin/vaadin-template-renderer", version="21.0.2"), @NpmPackage(value="@vaadin/vaadin-virtual-list", version="21.0.2")})
@JsModule.Container(value={@JsModule(value="@vaadin/vaadin-template-renderer/vaadin-template-renderer.js"), @JsModule(value="@vaadin/vaadin-virtual-list/vaadin-virtual-list.js"), @JsModule(value="./flow-component-renderer.js"), @JsModule(value="./virtualListConnector.js")})
public class VirtualList<T>
extends Component
implements HasDataProvider<T>,
HasStyle,
HasSize,
Focusable<VirtualList<T>> {
    private final ArrayUpdater arrayUpdater = new ArrayUpdater(){

        public ArrayUpdater.Update startUpdate(int sizeChange) {
            return new UpdateQueue(sizeChange);
        }

        public void initialize() {
            VirtualList.this.initConnector();
        }
    };
    private final Element template;
    private Renderer<T> renderer;
    private String originalTemplate;
    private boolean rendererChanged;
    private boolean templateUpdateRegistered;
    private final CompositeDataGenerator<T> dataGenerator = new CompositeDataGenerator();
    private Registration dataGeneratorRegistration;
    private transient T placeholderItem;
    private final DataCommunicator<T> dataCommunicator = new PagelessDataCommunicator<T>(this.dataGenerator, this.arrayUpdater, (SerializableConsumer<JsonArray>)(SerializableConsumer & Serializable)data -> this.getElement().callJsFunction("$connector.updateData", new Serializable[]{data}), this.getElement().getNode());

    public VirtualList() {
        this.getElement().setAttribute("suppress-template-warning", true);
        this.dataGenerator.addDataGenerator((DataGenerator & Serializable)(item, jsonObject) -> this.renderer.getValueProviders().forEach((property, provider) -> jsonObject.put(property, JsonSerializer.toJson((Object)provider.apply(item)))));
        this.template = new Element("template");
        this.getElement().appendChild(new Element[]{this.template});
        this.setRenderer(String::valueOf);
    }

    private void initConnector() {
        ((UI)this.getUI().orElseThrow(() -> new IllegalStateException("Connector can only be initialized for an attached VirtualList"))).getPage().executeJs("window.Vaadin.Flow.virtualListConnector.initLazy($0)", new Serializable[]{this.getElement()});
    }

    public void setDataProvider(DataProvider<T, ?> dataProvider) {
        Objects.requireNonNull(dataProvider, "The dataProvider cannot be null");
        this.getDataCommunicator().setDataProvider(dataProvider, null);
    }

    public DataProvider<T, ?> getDataProvider() {
        return this.getDataCommunicator().getDataProvider();
    }

    public DataCommunicator<T> getDataCommunicator() {
        return this.dataCommunicator;
    }

    public void setRenderer(ValueProvider<T, String> valueProvider) {
        Objects.requireNonNull(valueProvider, "The valueProvider must not be null");
        this.setRenderer((Renderer<T>)TemplateRenderer.of((String)"[[item.label]]").withProperty("label", valueProvider));
    }

    public void setRenderer(Renderer<T> renderer) {
        Rendering rendering;
        Objects.requireNonNull(renderer, "The renderer must not be null");
        if (this.dataGeneratorRegistration != null) {
            this.dataGeneratorRegistration.remove();
            this.dataGeneratorRegistration = null;
        }
        if ((rendering = renderer.render(this.getElement(), this.dataCommunicator.getKeyMapper(), this.template)).getDataGenerator().isPresent()) {
            this.dataGeneratorRegistration = this.dataGenerator.addDataGenerator((DataGenerator)rendering.getDataGenerator().get());
        }
        this.renderer = renderer;
        this.rendererChanged = true;
        this.registerTemplateUpdate();
        this.getDataCommunicator().reset();
    }

    public void setPlaceholderItem(T placeholderItem) {
        this.placeholderItem = placeholderItem;
        this.getElement().callJsFunction("$connector.setPlaceholderItem", new Serializable[]{JsonSerializer.toJson(placeholderItem)});
        this.registerTemplateUpdate();
    }

    public T getPlaceholderItem() {
        return this.placeholderItem;
    }

    private void registerTemplateUpdate() {
        if (this.templateUpdateRegistered) {
            return;
        }
        this.templateUpdateRegistered = true;
        this.runBeforeClientResponse((Command & Serializable)() -> this.runBeforeClientResponse((Command & Serializable)() -> this.updateTemplateInnerHtml()));
    }

    private void runBeforeClientResponse(Command command) {
        this.getElement().getNode().runWhenAttached((SerializableConsumer & Serializable)ui -> ui.getInternals().getStateTree().beforeClientResponse(this.getElement().getNode(), (SerializableConsumer & Serializable)context -> command.execute()));
    }

    private void updateTemplateInnerHtml() {
        String placeholderTemplate;
        this.templateUpdateRegistered = false;
        if (this.rendererChanged) {
            this.originalTemplate = this.template.getProperty("innerHTML");
            this.rendererChanged = false;
        }
        if (this.placeholderItem == null) {
            placeholderTemplate = "<div style='width:100px;height:18px'></div>";
        } else if (this.renderer instanceof ComponentRenderer) {
            ComponentRenderer componentRenderer = (ComponentRenderer)this.renderer;
            Component component = componentRenderer.createComponent(this.placeholderItem);
            component.getElement().setEnabled(this.isEnabled());
            placeholderTemplate = component.getElement().getOuterHTML();
        } else {
            placeholderTemplate = this.originalTemplate;
        }
        this.template.setProperty("innerHTML", String.format("<template is='dom-if' if='[[item.__placeholder]]'>%s</template><template is='dom-if' if='[[!item.__placeholder]]'>%s</template>", placeholderTemplate, this.originalTemplate));
    }

    public void onEnabledStateChanged(boolean enabled) {
        super.onEnabledStateChanged(enabled);
        this.setRenderer(this.renderer);
    }

    @ClientCallable(value=DisabledUpdateMode.ALWAYS)
    private void setRequestedRange(int start, int length) {
        this.getDataCommunicator().setRequestedRange(start, length);
    }

    private final class UpdateQueue
    implements ArrayUpdater.Update {
        private transient List<Runnable> queue = new ArrayList<Runnable>();

        private UpdateQueue(int size) {
            this.enqueue("$connector.updateSize", Integer.valueOf(size));
        }

        public void set(int start, List<JsonValue> items) {
            this.enqueue("$connector.set", Integer.valueOf(start), (Serializable)items.stream().collect(JsonUtils.asArray()));
        }

        public void clear(int start, int length) {
            this.enqueue("$connector.clear", Integer.valueOf(start), Integer.valueOf(length));
        }

        public void commit(int updateId) {
            VirtualList.this.getDataCommunicator().confirmUpdate(updateId);
            this.queue.forEach(Runnable::run);
            this.queue.clear();
        }

        private void enqueue(String name, Serializable ... arguments) {
            this.queue.add(() -> VirtualList.this.getElement().callJsFunction(name, arguments));
        }
    }
}

