/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.virtuallist;

import com.vaadin.flow.component.ClientCallable;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.Focusable;
import com.vaadin.flow.component.HasSize;
import com.vaadin.flow.component.HasStyle;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.dependency.NpmPackage;
import com.vaadin.flow.component.virtuallist.paging.PagelessDataCommunicator;
import com.vaadin.flow.data.binder.HasDataProvider;
import com.vaadin.flow.data.provider.ArrayUpdater;
import com.vaadin.flow.data.provider.CompositeDataGenerator;
import com.vaadin.flow.data.provider.DataCommunicator;
import com.vaadin.flow.data.provider.DataProvider;
import com.vaadin.flow.data.renderer.LitRenderer;
import com.vaadin.flow.data.renderer.Renderer;
import com.vaadin.flow.data.renderer.Rendering;
import com.vaadin.flow.dom.DisabledUpdateMode;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.function.ValueProvider;
import com.vaadin.flow.internal.JsonUtils;
import com.vaadin.flow.server.Command;
import com.vaadin.flow.shared.Registration;
import elemental.json.Json;
import elemental.json.JsonArray;
import elemental.json.JsonObject;
import elemental.json.JsonValue;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@Tag(value="vaadin-virtual-list")
@NpmPackage.Container(value={@NpmPackage(value="@vaadin/polymer-legacy-adapter", version="24.6.6"), @NpmPackage(value="@vaadin/virtual-list", version="24.6.6")})
@JsModule.Container(value={@JsModule(value="@vaadin/polymer-legacy-adapter/style-modules.js"), @JsModule(value="@vaadin/virtual-list/src/vaadin-virtual-list.js"), @JsModule(value="./flow-component-renderer.js"), @JsModule(value="./virtualListConnector.js")})
public class VirtualList<T>
extends Component
implements HasDataProvider<T>,
HasStyle,
HasSize,
Focusable<VirtualList<T>> {
    private final ArrayUpdater arrayUpdater = new ArrayUpdater(){

        public ArrayUpdater.Update startUpdate(int sizeChange) {
            return new UpdateQueue(sizeChange);
        }

        public void initialize() {
            VirtualList.this.initConnector();
        }
    };
    private Renderer<T> renderer;
    private final CompositeDataGenerator<T> dataGenerator = new CompositeDataGenerator();
    private final List<Registration> renderingRegistrations = new ArrayList<Registration>();
    private transient T placeholderItem;
    private final DataCommunicator<T> dataCommunicator = new PagelessDataCommunicator<T>(this.dataGenerator, this.arrayUpdater, (SerializableConsumer<JsonArray>)(SerializableConsumer & Serializable)data -> this.getElement().callJsFunction("$connector.updateData", new Serializable[]{data}), this.getElement().getNode());

    public VirtualList() {
        this.setRenderer(String::valueOf);
        this.addAttachListener((ComponentEventListener & Serializable)e -> this.setPlaceholderItem(this.placeholderItem));
    }

    private void initConnector() {
        ((UI)this.getUI().orElseThrow(() -> new IllegalStateException("Connector can only be initialized for an attached VirtualList"))).getPage().executeJs("window.Vaadin.Flow.virtualListConnector.initLazy($0)", new Serializable[]{this.getElement()});
    }

    public void setDataProvider(DataProvider<T, ?> dataProvider) {
        Objects.requireNonNull(dataProvider, "The dataProvider cannot be null");
        this.getDataCommunicator().setDataProvider(dataProvider, null);
    }

    public DataProvider<T, ?> getDataProvider() {
        return this.getDataCommunicator().getDataProvider();
    }

    public DataCommunicator<T> getDataCommunicator() {
        return this.dataCommunicator;
    }

    public void setRenderer(ValueProvider<T, String> valueProvider) {
        Objects.requireNonNull(valueProvider, "The valueProvider must not be null");
        this.setRenderer((Renderer<T>)LitRenderer.of((String)"${item.label}").withProperty("label", valueProvider));
    }

    public void setRenderer(Renderer<T> renderer) {
        Objects.requireNonNull(renderer, "The renderer must not be null");
        this.renderingRegistrations.forEach(Registration::remove);
        this.renderingRegistrations.clear();
        Rendering rendering = renderer.render(this.getElement(), this.dataCommunicator.getKeyMapper());
        rendering.getDataGenerator().ifPresent(renderingDataGenerator -> {
            Registration renderingDataGeneratorRegistration = this.dataGenerator.addDataGenerator(renderingDataGenerator);
            this.renderingRegistrations.add(renderingDataGeneratorRegistration);
        });
        this.renderingRegistrations.add(rendering.getRegistration());
        this.renderer = renderer;
        this.getDataCommunicator().reset();
        this.setPlaceholderItem(this.placeholderItem);
    }

    public void setPlaceholderItem(T placeholderItem) {
        this.placeholderItem = placeholderItem;
        this.runBeforeClientResponse((Command & Serializable)() -> {
            JsonObject json = Json.createObject();
            if (placeholderItem != null) {
                this.dataGenerator.generateData(placeholderItem, json);
            }
            String appId = UI.getCurrent() != null ? UI.getCurrent().getInternals().getAppId() : "";
            this.getElement().callJsFunction("$connector.setPlaceholderItem", new Serializable[]{json, appId});
        });
    }

    public T getPlaceholderItem() {
        return this.placeholderItem;
    }

    private void runBeforeClientResponse(Command command) {
        this.getElement().getNode().runWhenAttached((SerializableConsumer & Serializable)ui -> ui.getInternals().getStateTree().beforeClientResponse(this.getElement().getNode(), (SerializableConsumer & Serializable)context -> command.execute()));
    }

    public void onEnabledStateChanged(boolean enabled) {
        super.onEnabledStateChanged(enabled);
        this.setRenderer(this.renderer);
    }

    @ClientCallable(value=DisabledUpdateMode.ALWAYS)
    private void setRequestedRange(int start, int length) {
        this.getDataCommunicator().setRequestedRange(start, length);
    }

    public void scrollToIndex(int rowIndex) {
        this.getElement().getNode().runWhenAttached((SerializableConsumer & Serializable)ui -> ui.beforeClientResponse((Component)this, (SerializableConsumer & Serializable)ctx -> this.getElement().executeJs("this.scrollToIndex($0)", new Serializable[]{Integer.valueOf(rowIndex)})));
    }

    public void scrollToStart() {
        this.scrollToIndex(0);
    }

    public void scrollToEnd() {
        this.scrollToIndex(Integer.MAX_VALUE);
    }

    private final class UpdateQueue
    implements ArrayUpdater.Update {
        private transient List<Runnable> queue = new ArrayList<Runnable>();

        private UpdateQueue(int size) {
            this.enqueue("$connector.updateSize", Integer.valueOf(size));
        }

        public void set(int start, List<JsonValue> items) {
            this.enqueue("$connector.set", Integer.valueOf(start), (Serializable)items.stream().collect(JsonUtils.asArray()));
        }

        public void clear(int start, int length) {
            this.enqueue("$connector.clear", Integer.valueOf(start), Integer.valueOf(length));
        }

        public void commit(int updateId) {
            VirtualList.this.getDataCommunicator().confirmUpdate(updateId);
            this.queue.forEach(Runnable::run);
            this.queue.clear();
        }

        private void enqueue(String name, Serializable ... arguments) {
            this.queue.add(() -> VirtualList.this.getElement().callJsFunction(name, arguments));
        }
    }
}

