/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.webcomponentshelper.polyfill;

import com.vaadin.server.BootstrapFragmentResponse;
import com.vaadin.server.BootstrapListener;
import com.vaadin.server.BootstrapPageResponse;
import com.vaadin.server.ServiceInitEvent;
import com.vaadin.server.SessionInitListener;
import com.vaadin.server.VaadinService;
import com.vaadin.server.VaadinServiceInitListener;
import com.vaadin.webcomponentshelper.polyfill.WebComponentsPolyfillMode;
import java.io.Serializable;
import java.util.Collections;
import java.util.logging.Logger;
import org.jsoup.nodes.Element;
import org.jsoup.parser.Tag;

public class LoadPolyfill
implements VaadinServiceInitListener {
    static final String SERVLET_PARAMETER_LOAD_WEBCOMPONENTS_POLYFILL = "loadWebcomponentsPolyfill";
    static final String WARNING_LOAD_WEBCOMPONENTS_POLYFILL_NOT_RECOGNIZED = "\n===========================================================\nWARNING: loadWebcomponentsPolyfill has been set to an unrecognized value\nin web.xml. The permitted values are \"yes\", \"no\",\nand \"automatic\". The default of \"automatic\" will be used.\n===========================================================";

    public void serviceInit(ServiceInitEvent event) {
        final WebComponentsPolyfillMode polyfillMode = this.checkWebComponentsPolyfillMode(event.getSource());
        event.getSource().addSessionInitListener((SessionInitListener & Serializable)e -> e.getSession().addBootstrapListener(new BootstrapListener(){

            public void modifyBootstrapPage(BootstrapPageResponse response) {
                if (polyfillMode.shouldLoad(response.getRequest().getService().getClassLoader())) {
                    String webcomponentsJS = "frontend://webcomponentsjs/webcomponents-lite.js";
                    webcomponentsJS = response.getUriResolver().resolveVaadinUri(webcomponentsJS);
                    Element script = new Element(Tag.valueOf((String)"script"), "").attr("type", "text/javascript").attr("src", webcomponentsJS);
                    response.getDocument().head().insertChildren(0, Collections.singletonList(script));
                }
            }

            public void modifyBootstrapFragment(BootstrapFragmentResponse response) {
            }
        }));
    }

    private WebComponentsPolyfillMode checkWebComponentsPolyfillMode(VaadinService vaadinService) {
        String mode = vaadinService.getDeploymentConfiguration().getApplicationOrSystemProperty(SERVLET_PARAMETER_LOAD_WEBCOMPONENTS_POLYFILL, WebComponentsPolyfillMode.AUTOMATIC.toString());
        try {
            return Enum.valueOf(WebComponentsPolyfillMode.class, mode.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            LoadPolyfill.getLogger().warning(WARNING_LOAD_WEBCOMPONENTS_POLYFILL_NOT_RECOGNIZED);
            return WebComponentsPolyfillMode.AUTOMATIC;
        }
    }

    private static Logger getLogger() {
        return Logger.getLogger(LoadPolyfill.class.getName());
    }
}

