/*
 * Decompiled with CFR 0.152.
 */
package com.vackosar.gitflowincrementalbuild.boundary;

import com.vackosar.gitflowincrementalbuild.control.Property;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Configuration {
    public static final String PLUGIN_KEY = "com.vackosar.gitflowincrementalbuilder:gitflow-incremental-builder";
    public final MavenSession mavenSession;
    public final MavenProject currentProject;
    public final boolean help;
    public final boolean disable;
    public final Optional<Predicate<String>> disableIfBranchRegex;
    public final boolean disableBranchComparison;
    public final String referenceBranch;
    public final boolean fetchReferenceBranch;
    public final String baseBranch;
    public final boolean fetchBaseBranch;
    public final boolean useJschAgentProxy;
    public final boolean compareToMergeBase;
    public final boolean uncommitted;
    public final boolean untracked;
    public final Optional<Predicate<String>> skipIfPathMatches;
    public final Optional<Predicate<String>> excludePathRegex;
    public final Optional<Predicate<String>> includePathRegex;
    public final boolean buildAll;
    public final boolean buildAllIfNoChanges;
    public final boolean buildDownstream;
    public final BuildUpstreamMode buildUpstreamMode;
    public final boolean skipTestsForUpstreamModules;
    public final Map<String, String> argsForUpstreamModules;
    public final List<Pattern> forceBuildModules;
    public final List<String> excludeDownstreamModulesPackagedAs;
    public final boolean disableSelectedProjectsHandling;
    public final boolean failOnMissingGitDir;
    public final boolean failOnError;
    public final Optional<Path> logImpactedTo;
    private Logger logger = LoggerFactory.getLogger(Configuration.class);

    public Configuration(MavenSession session) {
        this.mavenSession = session;
        this.currentProject = Configuration.findCurrentProject(session);
        Properties[] properties = Configuration.getProperties(this.currentProject, this.logger);
        Properties projectProperties = properties[0];
        Properties pluginProperties = properties[1];
        this.help = Boolean.parseBoolean(Property.help.getValue(pluginProperties, projectProperties));
        this.disable = Boolean.parseBoolean(Property.disable.getValue(pluginProperties, projectProperties));
        if (this.disable) {
            this.disableIfBranchRegex = null;
            this.disableBranchComparison = false;
            this.referenceBranch = null;
            this.fetchReferenceBranch = false;
            this.baseBranch = null;
            this.fetchBaseBranch = false;
            this.useJschAgentProxy = false;
            this.compareToMergeBase = false;
            this.uncommitted = false;
            this.untracked = false;
            this.skipIfPathMatches = null;
            this.excludePathRegex = null;
            this.includePathRegex = null;
            this.buildAll = false;
            this.buildAllIfNoChanges = false;
            this.buildDownstream = false;
            this.buildUpstreamMode = null;
            this.skipTestsForUpstreamModules = false;
            this.argsForUpstreamModules = null;
            this.forceBuildModules = null;
            this.excludeDownstreamModulesPackagedAs = null;
            this.disableSelectedProjectsHandling = false;
            this.failOnMissingGitDir = false;
            this.failOnError = false;
            this.logImpactedTo = null;
            return;
        }
        Property.checkProperties(pluginProperties, projectProperties);
        this.disableIfBranchRegex = Configuration.compileOptionalPatternPredicate(Property.disableIfBranchRegex, pluginProperties, projectProperties);
        this.disableBranchComparison = Boolean.parseBoolean(Property.disableBranchComparison.getValue(pluginProperties, projectProperties));
        this.referenceBranch = Property.referenceBranch.getValue(pluginProperties, projectProperties);
        this.fetchReferenceBranch = Boolean.parseBoolean(Property.fetchReferenceBranch.getValue(pluginProperties, projectProperties));
        this.baseBranch = Property.baseBranch.getValue(pluginProperties, projectProperties);
        this.fetchBaseBranch = Boolean.parseBoolean(Property.fetchBaseBranch.getValue(pluginProperties, projectProperties));
        this.useJschAgentProxy = Boolean.parseBoolean(Property.useJschAgentProxy.getValue(pluginProperties, projectProperties));
        this.compareToMergeBase = Boolean.parseBoolean(Property.compareToMergeBase.getValue(pluginProperties, projectProperties));
        this.uncommitted = Boolean.parseBoolean(Property.uncommitted.getValue(pluginProperties, projectProperties));
        this.untracked = Boolean.parseBoolean(Property.untracked.getValue(pluginProperties, projectProperties));
        this.skipIfPathMatches = Configuration.compileOptionalPatternPredicate(Property.skipIfPathMatches, pluginProperties, projectProperties);
        this.excludePathRegex = Configuration.compileOptionalPatternPredicate(Property.excludePathRegex, pluginProperties, projectProperties);
        this.includePathRegex = Configuration.compileOptionalPatternPredicate(Property.includePathRegex, pluginProperties, projectProperties);
        this.buildAll = Boolean.parseBoolean(Property.buildAll.getValue(pluginProperties, projectProperties));
        this.buildAllIfNoChanges = Boolean.parseBoolean(Property.buildAllIfNoChanges.getValue(pluginProperties, projectProperties));
        this.buildDownstream = Configuration.isBuildStreamActive(Property.buildDownstream, pluginProperties, projectProperties, session, "make-downstream");
        this.buildUpstreamMode = Configuration.parseBuildUpstreamMode(session, pluginProperties, projectProperties);
        this.skipTestsForUpstreamModules = Boolean.parseBoolean(Property.skipTestsForUpstreamModules.getValue(pluginProperties, projectProperties));
        this.argsForUpstreamModules = Configuration.parseDelimited(Property.argsForUpstreamModules.getValue(pluginProperties, projectProperties), " ").map(Configuration::keyValueStringToEntry).collect(Collectors.collectingAndThen(Configuration.toLinkedMap(), Collections::unmodifiableMap));
        this.forceBuildModules = Configuration.parseDelimited(Property.forceBuildModules.getValue(pluginProperties, projectProperties), ",").map(str -> Configuration.compilePattern(str, Property.forceBuildModules)).collect(Collectors.collectingAndThen(Collectors.toList(), Collections::unmodifiableList));
        this.excludeDownstreamModulesPackagedAs = Configuration.parseDelimited(Property.excludeDownstreamModulesPackagedAs.getValue(pluginProperties, projectProperties), ",").collect(Collectors.collectingAndThen(Collectors.toList(), Collections::unmodifiableList));
        this.disableSelectedProjectsHandling = Boolean.parseBoolean(Property.disableSelectedProjectsHandling.getValue(pluginProperties, projectProperties));
        this.failOnMissingGitDir = Boolean.parseBoolean(Property.failOnMissingGitDir.getValue(pluginProperties, projectProperties));
        this.failOnError = Boolean.parseBoolean(Property.failOnError.getValue(pluginProperties, projectProperties));
        this.logImpactedTo = Property.logImpactedTo.getValueOpt(pluginProperties, projectProperties).map(x$0 -> Paths.get(x$0, new String[0]));
    }

    public static boolean isMakeBehaviourActive(String expectedMakeBehavior, MavenSession session) {
        String actualMakeBehavior = session.getRequest().getMakeBehavior();
        return expectedMakeBehavior.equals(actualMakeBehavior) || "make-both".equals(actualMakeBehavior);
    }

    private static MavenProject findCurrentProject(MavenSession session) {
        MavenProject currentProject = session.getCurrentProject();
        if (currentProject == null || !currentProject.isExecutionRoot()) {
            currentProject = session.getProjects().stream().filter(MavenProject::isExecutionRoot).findAny().orElse(currentProject);
        }
        return currentProject;
    }

    private static Properties[] getProperties(MavenProject currentProject, Logger logger) {
        if (currentProject != null) {
            return new Properties[]{currentProject.getProperties(), Configuration.getPluginProperties(currentProject)};
        }
        logger.warn("gitflow-incremental-builder could not parse configuration due to missing 'current' project in the MavenSession.");
        Properties fakeProjectProperties = new Properties();
        fakeProjectProperties.put(Property.disable.prefixedName(), Boolean.TRUE.toString());
        return new Properties[]{fakeProjectProperties, new Properties()};
    }

    private static Properties getPluginProperties(MavenProject mavenProject) {
        return Optional.ofNullable(mavenProject.getPlugin(PLUGIN_KEY)).map(plugin -> (Xpp3Dom)plugin.getConfiguration()).map(Xpp3Dom::getChildren).filter(children -> ((Xpp3Dom[])children).length > 0).map(children -> Arrays.stream(children).collect(Collectors.toMap(Xpp3Dom::getName, Xpp3Dom::getValue, (a, b) -> a, Properties::new))).orElseGet(Properties::new);
    }

    private static BuildUpstreamMode parseBuildUpstreamMode(MavenSession session, Properties pluginProperties, Properties projectProperties) {
        if (!Configuration.isBuildStreamActive(Property.buildUpstream, pluginProperties, projectProperties, session, "make-upstream")) {
            return BuildUpstreamMode.NONE;
        }
        Property.ValueWithOriginContext propertyValue = Property.buildUpstreamMode.getValueWithOriginContext(pluginProperties, projectProperties);
        try {
            return BuildUpstreamMode.valueOf(propertyValue.value.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("GIB property '" + propertyValue.originName + "' defines an invalid mode: " + propertyValue, e);
        }
    }

    private static boolean isBuildStreamActive(Property property, Properties pluginProperties, Properties projectProperties, MavenSession session, String expectedMakeBehavior) {
        Property.ValueWithOriginContext propertyValue = property.getValueWithOriginContext(pluginProperties, projectProperties);
        switch (propertyValue.value) {
            case "derived": {
                return Configuration.isMakeBehaviourActive(expectedMakeBehavior, session);
            }
            case "always": 
            case "true": {
                return true;
            }
            case "never": 
            case "false": {
                return false;
            }
        }
        throw new IllegalArgumentException("GIB property '" + propertyValue.originName + "' defines an invalid value: " + propertyValue);
    }

    private static Stream<String> parseDelimited(String value, String delimiter) {
        return value.isEmpty() ? Stream.empty() : Arrays.stream(value.split(delimiter)).map(String::trim).filter(s -> !s.isEmpty());
    }

    private static Map.Entry<String, String> keyValueStringToEntry(String pair) {
        int indexOfDelim = pair.indexOf(61);
        return indexOfDelim > 0 ? new AbstractMap.SimpleEntry<String, String>(pair.substring(0, indexOfDelim), pair.substring(indexOfDelim + 1)) : new AbstractMap.SimpleEntry<String, String>(pair, "");
    }

    private static Collector<Map.Entry<String, String>, ?, LinkedHashMap<String, String>> toLinkedMap() {
        return Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (a, b) -> a, LinkedHashMap::new);
    }

    private static Pattern compilePattern(String patternString, Property property) {
        try {
            return Pattern.compile(patternString);
        }
        catch (PatternSyntaxException e) {
            throw new IllegalArgumentException("GIB property '" + property.prefixedName() + "' defines an invalid pattern string", e);
        }
    }

    private static Optional<Predicate<String>> compileOptionalPatternPredicate(Property property, Properties pluginProperties, Properties projectProperties) {
        return property.getValueOpt(pluginProperties, projectProperties).map(patternString -> Configuration.compilePattern(patternString, property)).map(Pattern::asPredicate);
    }

    public static enum BuildUpstreamMode {
        NONE,
        CHANGED,
        IMPACTED;

    }
}

