/*
 * Decompiled with CFR 0.152.
 */
package com.vackosar.gitflowincrementalbuild.control.jgit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jgit.errors.UnsupportedCredentialItem;
import org.eclipse.jgit.transport.CredentialItem;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.jgit.util.FS;
import org.eclipse.jgit.util.TemporaryBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpDelegatingCredentialsProvider
extends CredentialsProvider {
    private Logger logger = LoggerFactory.getLogger(HttpDelegatingCredentialsProvider.class);
    private final Path projectDir;
    private final Map<String, String> additionalNativeGitEnvironment;
    private final Map<URIish, CredentialsPair> credentials = new HashMap<URIish, CredentialsPair>();

    public HttpDelegatingCredentialsProvider(Path projectDir, Map<String, String> additionalNativeGitEnvironment) {
        this.projectDir = projectDir;
        this.additionalNativeGitEnvironment = new HashMap<String, String>(additionalNativeGitEnvironment);
    }

    public boolean isInteractive() {
        return true;
    }

    public boolean supports(CredentialItem ... items) {
        return Arrays.stream(items).allMatch(item -> item instanceof CredentialItem.Username || item instanceof CredentialItem.Password);
    }

    public boolean get(URIish uri, CredentialItem ... items) throws UnsupportedCredentialItem {
        if (uri.getScheme() != null && !uri.getScheme().startsWith("http")) {
            return false;
        }
        CredentialsPair credentialsPair = this.credentials.computeIfAbsent(uri, u -> {
            try {
                return this.lookupCredentials(uri);
            }
            catch (IOException | InterruptedException | RuntimeException e) {
                this.logger.warn("Failed to look up credentials via 'git credential fill' for: " + uri, (Throwable)e);
                return null;
            }
        });
        if (credentialsPair == null) {
            return false;
        }
        for (CredentialItem item : items) {
            if (item instanceof CredentialItem.Username) {
                ((CredentialItem.Username)item).setValue(credentialsPair.username);
                continue;
            }
            if (item instanceof CredentialItem.Password) {
                ((CredentialItem.Password)item).setValue(credentialsPair.password);
                continue;
            }
            if (item instanceof CredentialItem.StringType && item.getPromptText().equals("Password: ")) {
                ((CredentialItem.StringType)item).setValue(new String(credentialsPair.password));
                continue;
            }
            throw new UnsupportedCredentialItem(uri, item.getClass().getName() + ":" + item.getPromptText());
        }
        return true;
    }

    public void reset(URIish uri) {
        Optional.ofNullable(this.credentials.remove(uri)).ifPresent(credPair -> {
            ((CredentialsPair)credPair).username = null;
            Arrays.fill(((CredentialsPair)credPair).password, '\u0000');
            CredentialsPair.access$102(credPair, null);
        });
    }

    public void resetAll() {
        new HashSet<URIish>(this.credentials.keySet()).forEach(this::reset);
    }

    private CredentialsPair lookupCredentials(URIish uri) throws IOException, InterruptedException {
        FS fs = FS.detect();
        ProcessBuilder procBuilder = fs.runInShell("git", new String[]{"credential", "fill"});
        procBuilder.environment().put("GIT_TERMINAL_PROMPT", "0");
        if (!this.additionalNativeGitEnvironment.isEmpty()) {
            procBuilder.environment().putAll(this.additionalNativeGitEnvironment);
        }
        procBuilder.directory(this.projectDir.toFile());
        FS.ExecutionResult result = fs.execute(procBuilder, (InputStream)new ByteArrayInputStream(this.buildGitCommandInput(uri).getBytes(Charset.defaultCharset())));
        if (result.getRc() != 0) {
            this.logger.info(this.bufferToString(result.getStdout()));
            this.logger.error(this.bufferToString(result.getStderr()));
            throw new IllegalStateException("Native Git invocation failed with return code " + result.getRc() + ". See previous log output for more details.");
        }
        return this.extractCredentials(this.bufferToString(result.getStdout()));
    }

    private String buildGitCommandInput(URIish uri) {
        StringBuilder builder = new StringBuilder();
        builder.append("protocol=").append(uri.getScheme()).append("\n");
        builder.append("host=").append(uri.getHost());
        if (uri.getPort() != -1) {
            builder.append(":").append(uri.getPort());
        }
        builder.append("\n");
        Optional.ofNullable(uri.getPath()).map(path -> path.startsWith("/") ? path.substring(1) : path).ifPresent(path -> builder.append("path=").append((String)path).append("\n"));
        Optional.ofNullable(uri.getUser()).ifPresent(user -> builder.append("username=").append((String)user).append("\n"));
        return builder.toString();
    }

    private String bufferToString(TemporaryBuffer buffer) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        buffer.writeTo((OutputStream)baos, null);
        return baos.toString(Charset.defaultCharset().name());
    }

    private CredentialsPair extractCredentials(String nativeGitOutput) {
        Matcher matcher = Pattern.compile("(?<=username=).+|(?<=password=).+").matcher(nativeGitOutput);
        if (!matcher.find()) {
            throw new IllegalStateException("Could not find username in native Git output");
        }
        String username = matcher.group();
        if (!matcher.find()) {
            throw new IllegalStateException("Could not find password in native Git output");
        }
        char[] password = matcher.group().toCharArray();
        CredentialsPair credPair = new CredentialsPair();
        credPair.username = username;
        CredentialsPair.access$102(credPair, password);
        return credPair;
    }

    private static class CredentialsPair {
        private String username;
        private char[] password;

        private CredentialsPair() {
        }

        static /* synthetic */ char[] access$102(CredentialsPair x0, char[] x1) {
            x0.password = x1;
            return x1;
        }
    }
}

