/*
 * Decompiled with CFR 0.152.
 */
package com.vackosar.gitflowincrementalbuild.boundary;

import com.vackosar.gitflowincrementalbuild.control.Property;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.execution.MavenSession;

public class Configuration {
    public final boolean disableBranchComparison;
    public final String referenceBranch;
    public final boolean fetchReferenceBranch;
    public final String baseBranch;
    public final boolean fetchBaseBranch;
    public final boolean compareToMergeBase;
    public final boolean uncommited;
    public final boolean untracked;
    public final Predicate<String> excludePathRegex;
    public final boolean buildAll;
    public final boolean buildDownstream;
    public final BuildUpstreamMode buildUpstreamMode;
    public final boolean skipTestsForUpstreamModules;
    public final Map<String, String> argsForUpstreamModules;
    public final List<Pattern> forceBuildModules;
    public final List<String> excludeTransitiveModulesPackagedAs;
    public final boolean failOnMissingGitDir;
    public final boolean failOnError;

    private Configuration(MavenSession session) {
        Properties projectProperties = session.getTopLevelProject().getProperties();
        Configuration.checkProperties(projectProperties);
        this.disableBranchComparison = Boolean.valueOf(Property.disableBranchComparison.getValue(projectProperties));
        this.referenceBranch = Property.referenceBranch.getValue(projectProperties);
        this.fetchReferenceBranch = Boolean.valueOf(Property.fetchReferenceBranch.getValue(projectProperties));
        this.baseBranch = Property.baseBranch.getValue(projectProperties);
        this.fetchBaseBranch = Boolean.valueOf(Property.fetchBaseBranch.getValue(projectProperties));
        this.compareToMergeBase = Boolean.valueOf(Property.compareToMergeBase.getValue(projectProperties));
        this.uncommited = Boolean.valueOf(Property.uncommited.getValue(projectProperties));
        this.untracked = Boolean.valueOf(Property.untracked.getValue(projectProperties));
        this.excludePathRegex = Configuration.compilePattern(Property.excludePathRegex, projectProperties).asPredicate();
        this.buildAll = Boolean.valueOf(Property.buildAll.getValue(projectProperties));
        this.buildDownstream = Configuration.isBuildStreamActive(Property.buildDownstream, projectProperties, session, "make-downstream");
        this.buildUpstreamMode = Configuration.parseBuildUpstreamMode(session, projectProperties);
        this.skipTestsForUpstreamModules = Boolean.valueOf(Property.skipTestsForUpstreamModules.getValue(projectProperties));
        this.argsForUpstreamModules = Configuration.parseDelimited(Property.argsForUpstreamModules.getValue(projectProperties), " ").map(Configuration::keyValueStringToEntry).collect(Collectors.collectingAndThen(Configuration.toLinkedMap(), Collections::unmodifiableMap));
        this.forceBuildModules = Configuration.parseDelimited(Property.forceBuildModules.getValue(projectProperties), ",").map(str -> Configuration.compilePattern(str, Property.forceBuildModules)).collect(Collectors.collectingAndThen(Collectors.toList(), Collections::unmodifiableList));
        this.excludeTransitiveModulesPackagedAs = Configuration.parseDelimited(Property.excludeTransitiveModulesPackagedAs.getValue(projectProperties), ",").collect(Collectors.collectingAndThen(Collectors.toList(), Collections::unmodifiableList));
        this.failOnMissingGitDir = Boolean.valueOf(Property.failOnMissingGitDir.getValue(projectProperties));
        this.failOnError = Boolean.valueOf(Property.failOnError.getValue(projectProperties));
    }

    public static boolean isEnabled(MavenSession session) {
        return Boolean.valueOf(Property.enabled.getValue(session.getTopLevelProject().getProperties()));
    }

    private static void checkProperties(Properties projectProperties) {
        Set availablePropertyNames = Arrays.stream(Property.values()).flatMap(p -> Stream.of(p.fullName(), p.deprecatedFullName())).filter(Objects::nonNull).collect(Collectors.toSet());
        String invalidPropertyNames = Stream.concat(System.getProperties().keySet().stream(), projectProperties.keySet().stream()).distinct().map(k -> (String)k).filter(k -> k.startsWith("gib.") && !availablePropertyNames.contains(k)).collect(Collectors.joining("\n\t"));
        if (!invalidPropertyNames.isEmpty()) {
            throw new IllegalArgumentException(String.format("Invalid GIB properties found:\n\t%s\nAllowed properties:\n%s", invalidPropertyNames, Property.exemplifyAll()));
        }
    }

    private static BuildUpstreamMode parseBuildUpstreamMode(MavenSession session, Properties projectProperties) {
        if (!Configuration.isBuildStreamActive(Property.buildUpstream, projectProperties, session, "make-upstream")) {
            return BuildUpstreamMode.NONE;
        }
        try {
            String propertyValue = Optional.ofNullable(Property.buildUpstreamMode.getValue(projectProperties)).orElse("");
            return BuildUpstreamMode.valueOf(propertyValue.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("GIB property " + Property.buildUpstreamMode.fullName() + " defines an invalid mode", e);
        }
    }

    private static boolean isBuildStreamActive(Property property, Properties projectProperties, MavenSession session, String expectedMakeBehavior) {
        switch (property.getValue(projectProperties)) {
            case "derived": {
                String actualMakeBehavior = session.getRequest().getMakeBehavior();
                return expectedMakeBehavior.equals(actualMakeBehavior) || "make-both".equals(actualMakeBehavior);
            }
            case "always": 
            case "true": {
                return true;
            }
            case "never": 
            case "false": {
                return false;
            }
        }
        throw new IllegalArgumentException("GIB property " + property.fullName() + " defines an invalid value: " + property.getValue(projectProperties));
    }

    private static Stream<String> parseDelimited(String value, String delimiter) {
        return value.isEmpty() ? Stream.empty() : Arrays.stream(value.split(delimiter)).map(String::trim).filter(s -> !s.isEmpty());
    }

    private static Map.Entry<String, String> keyValueStringToEntry(String pair) {
        int indexOfDelim = pair.indexOf(61);
        return indexOfDelim > 0 ? new AbstractMap.SimpleEntry<String, String>(pair.substring(0, indexOfDelim), pair.substring(indexOfDelim + 1)) : new AbstractMap.SimpleEntry<String, String>(pair, "");
    }

    private static Collector<Map.Entry<String, String>, ?, LinkedHashMap<String, String>> toLinkedMap() {
        return Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (a, b) -> a, LinkedHashMap::new);
    }

    private static Pattern compilePattern(String patternString, Property property) {
        try {
            return Pattern.compile(patternString);
        }
        catch (PatternSyntaxException e) {
            throw new IllegalArgumentException("GIB property " + property.fullName() + " defines an invalid pattern string", e);
        }
    }

    private static Pattern compilePattern(Property property, Properties projectProperties) {
        return Configuration.compilePattern(property.getValue(projectProperties), property);
    }

    @Singleton
    @Named(value="gib.configurationProvider")
    public static class Provider
    implements javax.inject.Provider<Configuration> {
        private final MavenSession mavenSession;
        private Configuration configuration;

        @Inject
        public Provider(MavenSession mavenSession) {
            this.mavenSession = mavenSession;
        }

        public Configuration get() {
            if (this.configuration == null) {
                this.configuration = new Configuration(this.mavenSession);
            }
            return this.configuration;
        }
    }

    public static enum BuildUpstreamMode {
        NONE,
        CHANGED,
        IMPACTED;

    }
}

