/*
 * Decompiled with CFR 0.152.
 */
package com.vackosar.gitflowincrementalbuild.boundary;

import com.vackosar.gitflowincrementalbuild.boundary.Configuration;
import com.vackosar.gitflowincrementalbuild.boundary.UnchangedProjectsRemover;
import com.vackosar.gitflowincrementalbuild.control.Property;
import com.vackosar.gitflowincrementalbuild.entity.SkipExecutionException;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.AbstractMavenLifecycleParticipant;
import org.apache.maven.MavenExecutionException;
import org.apache.maven.execution.MavenSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Named(value="gib")
public class MavenLifecycleParticipant
extends AbstractMavenLifecycleParticipant {
    private Logger logger = LoggerFactory.getLogger(MavenLifecycleParticipant.class);
    @Inject
    private UnchangedProjectsRemover unchangedProjectsRemover;
    @Inject
    private Configuration.Provider configProvider;

    public void afterProjectsRead(MavenSession session) throws MavenExecutionException {
        if (!Configuration.isEnabled(session)) {
            this.logger.info("gitflow-incremental-builder is disabled.");
            return;
        }
        if (session.getProjectDependencyGraph() == null) {
            this.logger.warn("Execution of gitflow-incremental-builder is not supported in this environment: Current MavenSession does not provide a ProjectDependencyGraph. Consider disabling gitflow-incremental-builder via property: " + Property.enabled.fullName());
            return;
        }
        this.logger.info("gitflow-incremental-builder " + ((Object)((Object)this)).getClass().getPackage().getImplementationVersion() + " starting...");
        try {
            this.unchangedProjectsRemover.act();
        }
        catch (Exception e) {
            boolean isSkipExecException = e instanceof SkipExecutionException;
            if (!this.configProvider.get().failOnError || isSkipExecException) {
                this.logger.info("gitflow-incremental-builder execution skipped: {}", (Object)(isSkipExecException ? e.getMessage() : e.toString()));
                this.logger.debug("Full exception:", (Throwable)e);
            }
            throw new MavenExecutionException("Exception during gitflow-incremental-builder execution occurred.", (Throwable)e);
        }
        this.logger.info("gitflow-incremental-builder exiting...");
    }
}

