/*
 * Decompiled with CFR 0.152.
 */
package com.vackosar.gitflowincrementalbuild.control;

import java.util.Optional;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum Property {
    enabled("true"),
    disableBranchComparison("false"),
    referenceBranch("refs/remotes/origin/develop"),
    fetchReferenceBranch("false"),
    baseBranch("HEAD"),
    fetchBaseBranch("false"),
    compareToMergeBase("true"),
    uncommited("true"),
    untracked("true"),
    excludePathRegex("(?!x)x"),
    buildAll("false"),
    buildDownstream("always"),
    buildUpstream("derived"),
    buildUpstreamMode("changed"),
    skipTestsForUpstreamModules("false", "skipTestsForNotImpactedModules"),
    argsForUpstreamModules("", "argsForNotImpactedModules"),
    forceBuildModules(""),
    excludeTransitiveModulesPackagedAs(""),
    failOnMissingGitDir("true"),
    failOnError("true");

    public static final String PREFIX = "gib.";
    private static final Logger LOGGER;
    private final String fullName = "gib." + this.name();
    private final String defaultValue;
    private final String deprecatedFullName;

    private Property(String defaultValue) {
        this(defaultValue, null);
    }

    private Property(String defaultValue, String deprecatedFullName) {
        this.defaultValue = defaultValue;
        this.deprecatedFullName = deprecatedFullName != null ? PREFIX + deprecatedFullName : null;
    }

    private String exemplify() {
        return "<" + this.fullName() + ">" + (this.defaultValue == null ? "" : this.defaultValue) + "</" + this.fullName() + ">";
    }

    public String fullName() {
        return this.fullName;
    }

    public String deprecatedFullName() {
        return this.deprecatedFullName;
    }

    public String getValue(Properties projectProperties) {
        String value = Property.getValue(this.fullName, projectProperties);
        if (value != null) {
            return value;
        }
        if (this.deprecatedFullName != null && (value = Property.getValue(this.deprecatedFullName, projectProperties)) != null) {
            LOGGER.warn("{} has been replaced with {} and will be removed in an upcoming release. Please adjust your configuration!", (Object)this.deprecatedFullName, (Object)this.fullName);
            return value;
        }
        return this.defaultValue;
    }

    private static String getValue(String fullName, Properties projectProperties) {
        return Optional.ofNullable(System.getProperty(fullName)).orElseGet(() -> projectProperties.getProperty(fullName));
    }

    public static String exemplifyAll() {
        StringBuilder builder = new StringBuilder();
        builder.append("<properties>\n");
        for (Property value : Property.values()) {
            builder.append("\t").append(value.exemplify()).append("\n");
        }
        builder.append("</properties>\n");
        return builder.toString();
    }

    static {
        LOGGER = LoggerFactory.getLogger(Property.class);
    }

    private static class Constants {
        private static final String NEVER_MATCH_REGEX = "(?!x)x";

        private Constants() {
        }
    }
}

