/*
 * Decompiled with CFR 0.152.
 */
package com.valentinilk.shimmer;

import androidx.compose.ui.geometry.Offset;
import androidx.compose.ui.geometry.Rect;
import androidx.compose.ui.geometry.Size;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u001c\u001a\u00020\u001dH\u0002J\b\u0010\u001e\u001a\u00020\u001dH\u0002J\u0013\u0010\u001f\u001a\u00020 2\b\u0010!\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\"\u001a\u00020#H\u0016J\u0010\u0010$\u001a\u00020\u001d2\b\u0010\u000f\u001a\u0004\u0018\u00010\u000eJ\f\u0010%\u001a\u00020\u0003*\u00020\u0003H\u0002J\f\u0010&\u001a\u00020\u0003*\u00020\u0003H\u0002R)\u0010\b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0007@BX\u0086\u000e\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\n\n\u0002\u0010\u000b\u001a\u0004\b\t\u0010\nR\u000e\u0010\f\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u000e@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0019\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\n\u0002\u0010\u000bR\u001e\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0003@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R$\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u000e@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u0011\"\u0004\b\u001a\u0010\u001bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u000f\n\u0002\b\u0019\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006'"}, d2={"Lcom/valentinilk/shimmer/ShimmerArea;", "", "widthOfShimmer", "", "rotationInDegree", "(FF)V", "<set-?>", "Landroidx/compose/ui/geometry/Offset;", "pivotPoint", "getPivotPoint-F1C5BW0", "()J", "J", "reducedRotation", "requestedShimmerBounds", "Landroidx/compose/ui/geometry/Rect;", "shimmerBounds", "getShimmerBounds", "()Landroidx/compose/ui/geometry/Rect;", "shimmerSize", "Landroidx/compose/ui/geometry/Size;", "translationDistance", "getTranslationDistance", "()F", "value", "viewBounds", "getViewBounds", "setViewBounds", "(Landroidx/compose/ui/geometry/Rect;)V", "computeShimmerBounds", "", "computeTranslationDistance", "equals", "", "other", "hashCode", "", "updateBounds", "reduceRotation", "toRadian", "shimmer_release"})
public final class ShimmerArea {
    private final float widthOfShimmer;
    private final float reducedRotation;
    @Nullable
    private Rect requestedShimmerBounds;
    private long shimmerSize;
    private float translationDistance;
    private long pivotPoint;
    @NotNull
    private Rect shimmerBounds;
    @NotNull
    private Rect viewBounds;

    public ShimmerArea(float widthOfShimmer, float rotationInDegree) {
        this.widthOfShimmer = widthOfShimmer;
        this.reducedRotation = this.toRadian(this.reduceRotation(rotationInDegree));
        this.shimmerSize = Size.Companion.getZero-NH-jbRc();
        this.pivotPoint = Offset.Companion.getUnspecified-F1C5BW0();
        this.shimmerBounds = Rect.Companion.getZero();
        this.viewBounds = Rect.Companion.getZero();
    }

    public final float getTranslationDistance() {
        return this.translationDistance;
    }

    public final long getPivotPoint-F1C5BW0() {
        return this.pivotPoint;
    }

    @NotNull
    public final Rect getShimmerBounds() {
        return this.shimmerBounds;
    }

    @NotNull
    public final Rect getViewBounds() {
        return this.viewBounds;
    }

    public final void setViewBounds(@NotNull Rect value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (Intrinsics.areEqual((Object)value, (Object)this.viewBounds)) {
            return;
        }
        this.viewBounds = value;
        this.computeShimmerBounds();
    }

    public final void updateBounds(@Nullable Rect shimmerBounds) {
        if (Intrinsics.areEqual((Object)this.requestedShimmerBounds, (Object)shimmerBounds)) {
            return;
        }
        this.requestedShimmerBounds = shimmerBounds;
        this.computeShimmerBounds();
    }

    private final void computeShimmerBounds() {
        if (this.viewBounds.isEmpty()) {
            return;
        }
        Rect rect = this.requestedShimmerBounds;
        if (rect == null) {
            rect = this.viewBounds;
        }
        this.shimmerBounds = rect;
        this.pivotPoint = Offset.plus-MK-Hz9U((long)Offset.unaryMinus-F1C5BW0((long)this.viewBounds.getTopLeft-F1C5BW0()), (long)this.shimmerBounds.getCenter-F1C5BW0());
        long newShimmerSize = this.shimmerBounds.getSize-NH-jbRc();
        if (!Size.equals-impl0((long)this.shimmerSize, (long)newShimmerSize)) {
            this.shimmerSize = newShimmerSize;
            this.computeTranslationDistance();
        }
    }

    private final void computeTranslationDistance() {
        float width = Size.getWidth-impl((long)this.shimmerSize) / (float)2;
        float height = Size.getHeight-impl((long)this.shimmerSize) / (float)2;
        float distanceCornerToCenter = (float)Math.sqrt((float)Math.pow(width, 2) + (float)Math.pow(height, 2));
        float beta = (float)Math.acos(width / distanceCornerToCenter);
        float alpha = beta - this.reducedRotation;
        float distanceCornerToRotatedCenterLine = (float)Math.cos(alpha) * distanceCornerToCenter;
        this.translationDistance = distanceCornerToRotatedCenterLine * (float)2 + this.widthOfShimmer;
    }

    private final float reduceRotation(float $this$reduceRotation) {
        if ($this$reduceRotation < 0.0f) {
            throw new IllegalArgumentException("The shimmer's rotation must be a positive number");
        }
        float rotation = $this$reduceRotation % (float)180;
        rotation -= (float)90;
        rotation = -Math.abs(rotation);
        return rotation + (float)90;
    }

    private final float toRadian(float $this$toRadian) {
        return $this$toRadian / (float)180 * (float)Math.PI;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type com.valentinilk.shimmer.ShimmerArea");
        ShimmerArea cfr_ignored_0 = (ShimmerArea)other;
        if (!(this.widthOfShimmer == ((ShimmerArea)other).widthOfShimmer)) {
            return false;
        }
        return this.reducedRotation == ((ShimmerArea)other).reducedRotation;
    }

    public int hashCode() {
        int result = Float.hashCode(this.widthOfShimmer);
        result = 31 * result + Float.hashCode(this.reducedRotation);
        return result;
    }
}

