/*
 * Decompiled with CFR 0.152.
 */
package com.canhub.cropper;

import android.app.Activity;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.net.Uri;
import android.os.Build;
import android.os.Parcelable;
import android.provider.MediaStore;
import androidx.activity.ComponentActivity;
import androidx.activity.result.ActivityResult;
import androidx.activity.result.ActivityResultLauncher;
import androidx.activity.result.contract.ActivityResultContract;
import androidx.activity.result.contract.ActivityResultContracts;
import com.canhub.cropper.R;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\b\u0000\u0018\u0000 #2\u00020\u0001:\u0002\"#B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\"\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\rJ\u001e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00100\u000b2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u001e\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00100\u000b2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\tH\u0002J\u0010\u0010\u001d\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\u001e\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0014\u0010\u001f\u001a\u00020\u00002\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\t0\u000bJ\u000e\u0010!\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\tR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/canhub/cropper/CropImageIntentChooser;", "", "activity", "Landroidx/activity/ComponentActivity;", "callback", "Lcom/canhub/cropper/CropImageIntentChooser$ResultCallback;", "<init>", "(Landroidx/activity/ComponentActivity;Lcom/canhub/cropper/CropImageIntentChooser$ResultCallback;)V", "title", "", "priorityIntentList", "", "cameraImgUri", "Landroid/net/Uri;", "intentChooser", "Landroidx/activity/result/ActivityResultLauncher;", "Landroid/content/Intent;", "showChooserIntent", "", "includeCamera", "", "includeGallery", "getCameraIntents", "context", "Landroid/content/Context;", "packageManager", "Landroid/content/pm/PackageManager;", "getGalleryIntents", "action", "isExplicitCameraPermissionRequired", "hasCameraPermissionInManifest", "setupPriorityAppsList", "appsList", "setIntentChooserTitle", "ResultCallback", "Companion", "cropper_release"})
@SourceDebugExtension(value={"SMAP\nCropImageIntentChooser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CropImageIntentChooser.kt\ncom/canhub/cropper/CropImageIntentChooser\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,242:1\n37#2,2:243\n295#3,2:245\n12511#4,2:247\n*S KotlinDebug\n*F\n+ 1 CropImageIntentChooser.kt\ncom/canhub/cropper/CropImageIntentChooser\n*L\n106#1:243,2\n174#1:245,2\n210#1:247,2\n*E\n"})
public final class CropImageIntentChooser {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ComponentActivity activity;
    @NotNull
    private final ResultCallback callback;
    @NotNull
    private String title;
    @NotNull
    private List<String> priorityIntentList;
    @Nullable
    private Uri cameraImgUri;
    @NotNull
    private final ActivityResultLauncher<Intent> intentChooser;
    @NotNull
    public static final String GOOGLE_PHOTOS = "com.google.android.apps.photos";
    @NotNull
    public static final String GOOGLE_PHOTOS_GO = "com.google.android.apps.photosgo";
    @NotNull
    public static final String SAMSUNG_GALLERY = "com.sec.android.gallery3d";
    @NotNull
    public static final String ONEPLUS_GALLERY = "com.oneplus.gallery";
    @NotNull
    public static final String MIUI_GALLERY = "com.miui.gallery";

    public CropImageIntentChooser(@NotNull ComponentActivity activity, @NotNull ResultCallback callback) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        this.activity = activity;
        this.callback = callback;
        String string2 = this.activity.getString(R.string.pick_image_chooser_title);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getString(...)");
        this.title = string2;
        Object[] objectArray = new String[]{GOOGLE_PHOTOS, GOOGLE_PHOTOS_GO, SAMSUNG_GALLERY, ONEPLUS_GALLERY, MIUI_GALLERY};
        this.priorityIntentList = CollectionsKt.listOf((Object[])objectArray);
        this.intentChooser = this.activity.registerForActivityResult((ActivityResultContract)new ActivityResultContracts.StartActivityForResult(), arg_0 -> CropImageIntentChooser.intentChooser$lambda$1(this, arg_0));
    }

    public final void showChooserIntent(boolean includeCamera, boolean includeGallery, @Nullable Uri cameraImgUri) {
        Intent intent;
        this.cameraImgUri = cameraImgUri;
        List allIntents = new ArrayList();
        PackageManager packageManager = this.activity.getPackageManager();
        if (!this.isExplicitCameraPermissionRequired((Context)this.activity) && includeCamera) {
            Context context = (Context)this.activity;
            Intrinsics.checkNotNull((Object)packageManager);
            allIntents.addAll((Collection)this.getCameraIntents(context, packageManager));
        }
        if (includeGallery) {
            Intrinsics.checkNotNull((Object)packageManager);
            List<Intent> galleryIntents = this.getGalleryIntents(packageManager, "android.intent.action.GET_CONTENT");
            if (galleryIntents.isEmpty()) {
                galleryIntents = this.getGalleryIntents(packageManager, "android.intent.action.PICK");
            }
            allIntents.addAll((Collection)galleryIntents);
        }
        if (allIntents.isEmpty()) {
            intent = new Intent();
        } else {
            Intent intent2;
            Intent $this$showChooserIntent_u24lambda_u242 = intent2 = new Intent("android.intent.action.CHOOSER", MediaStore.Images.Media.EXTERNAL_CONTENT_URI);
            boolean bl = false;
            if (includeGallery) {
                $this$showChooserIntent_u24lambda_u242.setAction("android.intent.action.PICK");
                $this$showChooserIntent_u24lambda_u242.setType("image/*");
            }
            intent = intent2;
        }
        Intent target = intent;
        Intent chooserIntent = Intent.createChooser((Intent)target, (CharSequence)this.title);
        Collection $this$toTypedArray$iv = allIntents;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        chooserIntent.putExtra("android.intent.extra.INITIAL_INTENTS", thisCollection$iv.toArray(new Parcelable[0]));
        Intrinsics.checkNotNull((Object)chooserIntent);
        this.intentChooser.launch((Object)chooserIntent);
    }

    public static /* synthetic */ void showChooserIntent$default(CropImageIntentChooser cropImageIntentChooser, boolean bl, boolean bl2, Uri uri, int n, Object object) {
        if ((n & 4) != 0) {
            uri = null;
        }
        cropImageIntentChooser.showChooserIntent(bl, bl2, uri);
    }

    private final List<Intent> getCameraIntents(Context context, PackageManager packageManager) {
        List allIntents = new ArrayList();
        Intent captureIntent = new Intent("android.media.action.IMAGE_CAPTURE");
        int flags = 0;
        List list = Build.VERSION.SDK_INT >= 33 ? packageManager.queryIntentActivities(captureIntent, PackageManager.ResolveInfoFlags.of((long)flags)) : packageManager.queryIntentActivities(captureIntent, flags);
        Intrinsics.checkNotNull((Object)list);
        List listCam = list;
        for (ResolveInfo resolveInfo : listCam) {
            Intent intent = new Intent(captureIntent);
            intent.setComponent(new ComponentName(resolveInfo.activityInfo.packageName, resolveInfo.activityInfo.name));
            intent.setPackage(resolveInfo.activityInfo.packageName);
            if (context instanceof Activity) {
                ((Activity)context).grantUriPermission(resolveInfo.activityInfo.packageName, this.cameraImgUri, 3);
            }
            intent.putExtra("output", (Parcelable)this.cameraImgUri);
            allIntents.add(intent);
        }
        return allIntents;
    }

    private final List<Intent> getGalleryIntents(PackageManager packageManager, String action) {
        List intents = new ArrayList();
        Intent galleryIntent = Intrinsics.areEqual((Object)action, (Object)"android.intent.action.GET_CONTENT") ? new Intent(action) : new Intent(action, MediaStore.Images.Media.EXTERNAL_CONTENT_URI);
        galleryIntent.setType("image/*");
        int flags = 0;
        List list = Build.VERSION.SDK_INT >= 33 ? packageManager.queryIntentActivities(galleryIntent, PackageManager.ResolveInfoFlags.of((long)flags)) : packageManager.queryIntentActivities(galleryIntent, flags);
        Intrinsics.checkNotNull((Object)list);
        List listGallery = list;
        for (ResolveInfo res : listGallery) {
            Intent intent = new Intent(galleryIntent);
            intent.setComponent(new ComponentName(res.activityInfo.packageName, res.activityInfo.name));
            intent.setPackage(res.activityInfo.packageName);
            intents.add(intent);
        }
        List priorityIntents = new ArrayList();
        for (String pkgName : this.priorityIntentList) {
            Intent it;
            Object v0;
            block3: {
                Iterable $this$firstOrNull$iv = intents;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    Intent it2 = (Intent)element$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it2.getPackage(), (Object)pkgName)) continue;
                    v0 = element$iv;
                    break block3;
                }
                v0 = null;
            }
            if ((Intent)v0 == null) continue;
            boolean bl = false;
            intents.remove(it);
            priorityIntents.add(it);
        }
        intents.addAll(0, priorityIntents);
        return intents;
    }

    private final boolean isExplicitCameraPermissionRequired(Context context) {
        return Build.VERSION.SDK_INT >= 23 && this.hasCameraPermissionInManifest(context) && context.checkSelfPermission("android.permission.CAMERA") != 0;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean hasCameraPermissionInManifest(Context context) {
        String packageName = context.getPackageName();
        try {
            boolean bl;
            int flags = 4096;
            PackageInfo packageInfo = Build.VERSION.SDK_INT >= 33 ? context.getPackageManager().getPackageInfo(packageName, PackageManager.PackageInfoFlags.of((long)flags)) : context.getPackageManager().getPackageInfo(packageName, flags);
            String[] declaredPermissions = packageInfo.requestedPermissions;
            if (declaredPermissions != null) {
                boolean bl2;
                block5: {
                    void $this$any$iv;
                    String[] stringArray = declaredPermissions;
                    boolean $i$f$any = false;
                    int n = ((void)$this$any$iv).length;
                    for (int i = 0; i < n; ++i) {
                        void element$iv;
                        void it = element$iv = $this$any$iv[i];
                        boolean bl3 = false;
                        void v0 = it;
                        boolean bl4 = v0 != null ? StringsKt.equals((String)v0, (String)"android.permission.CAMERA", (boolean)true) : false;
                        if (!bl4) continue;
                        bl2 = true;
                        break block5;
                    }
                    bl2 = false;
                }
                bl = bl2;
            } else {
                bl = false;
            }
            return bl;
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            return false;
        }
    }

    @NotNull
    public final CropImageIntentChooser setupPriorityAppsList(@NotNull List<String> appsList) {
        CropImageIntentChooser cropImageIntentChooser;
        Intrinsics.checkNotNullParameter(appsList, (String)"appsList");
        CropImageIntentChooser $this$setupPriorityAppsList_u24lambda_u246 = cropImageIntentChooser = this;
        boolean bl = false;
        $this$setupPriorityAppsList_u24lambda_u246.priorityIntentList = appsList;
        return cropImageIntentChooser;
    }

    @NotNull
    public final CropImageIntentChooser setIntentChooserTitle(@NotNull String title) {
        CropImageIntentChooser cropImageIntentChooser;
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        CropImageIntentChooser $this$setIntentChooserTitle_u24lambda_u247 = cropImageIntentChooser = this;
        boolean bl = false;
        $this$setIntentChooserTitle_u24lambda_u247.title = title;
        return cropImageIntentChooser;
    }

    private static final void intentChooser$lambda$1(CropImageIntentChooser this$0, ActivityResult activityRes) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)activityRes, (String)"activityRes");
        if (activityRes.getResultCode() == -1) {
            Intent intent = activityRes.getData();
            if (intent == null || (intent = intent.getData()) == null) {
                intent = this$0.cameraImgUri;
            }
            Intent uri = intent;
            boolean bl = false;
            this$0.callback.onSuccess((Uri)uri);
        } else {
            this$0.callback.onCancelled();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0080\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/canhub/cropper/CropImageIntentChooser$Companion;", "", "<init>", "()V", "GOOGLE_PHOTOS", "", "GOOGLE_PHOTOS_GO", "SAMSUNG_GALLERY", "ONEPLUS_GALLERY", "MIUI_GALLERY", "cropper_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b`\u0018\u00002\u00020\u0001J\u0012\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005H&J\b\u0010\u0006\u001a\u00020\u0003H&\u00a8\u0006\u0007"}, d2={"Lcom/canhub/cropper/CropImageIntentChooser$ResultCallback;", "", "onSuccess", "", "uri", "Landroid/net/Uri;", "onCancelled", "cropper_release"})
    public static interface ResultCallback {
        public void onSuccess(@Nullable Uri var1);

        public void onCancelled();
    }
}

