/*
 * Decompiled with CFR 0.152.
 */
package com.vanniktech.maven.publish.portal;

import com.vanniktech.maven.publish.portal.SonatypeCentralPortalOkHttpInterceptor;
import com.vanniktech.maven.publish.portal.SonatypeCentralPortalService;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.RequestBody;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;
import retrofit2.Converter;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.converter.scalars.ScalarsConverterFactory;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u001cB5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010\nJ\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0003J\u000e\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0003J\u001e\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R#\u0010\u000b\u001a\n \r*\u0004\u0018\u00010\f0\f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/vanniktech/maven/publish/portal/SonatypeCentralPortal;", "", "baseUrl", "", "usertoken", "userAgentName", "userAgentVersion", "okhttpTimeoutSeconds", "", "closeTimeoutSeconds", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;JJ)V", "service", "Lcom/vanniktech/maven/publish/portal/SonatypeCentralPortalService;", "kotlin.jvm.PlatformType", "getService", "()Lcom/vanniktech/maven/publish/portal/SonatypeCentralPortalService;", "service$delegate", "Lkotlin/Lazy;", "deleteDeployment", "", "deploymentId", "publishDeployment", "upload", "name", "publishingType", "Lcom/vanniktech/maven/publish/portal/SonatypeCentralPortal$PublishingType;", "file", "Ljava/io/File;", "PublishingType", "central-portal"})
public final class SonatypeCentralPortal {
    @NotNull
    private final String baseUrl;
    @NotNull
    private final String usertoken;
    private final long closeTimeoutSeconds;
    @NotNull
    private final Lazy service$delegate;

    public SonatypeCentralPortal(@NotNull String baseUrl, @NotNull String usertoken, @NotNull String userAgentName, @NotNull String userAgentVersion, long okhttpTimeoutSeconds, long closeTimeoutSeconds) {
        Intrinsics.checkNotNullParameter((Object)baseUrl, (String)"baseUrl");
        Intrinsics.checkNotNullParameter((Object)usertoken, (String)"usertoken");
        Intrinsics.checkNotNullParameter((Object)userAgentName, (String)"userAgentName");
        Intrinsics.checkNotNullParameter((Object)userAgentVersion, (String)"userAgentVersion");
        this.baseUrl = baseUrl;
        this.usertoken = usertoken;
        this.closeTimeoutSeconds = closeTimeoutSeconds;
        this.service$delegate = LazyKt.lazy((Function0)((Function0)new Function0<SonatypeCentralPortalService>(this, userAgentName, userAgentVersion, okhttpTimeoutSeconds){
            final /* synthetic */ SonatypeCentralPortal this$0;
            final /* synthetic */ String $userAgentName;
            final /* synthetic */ String $userAgentVersion;
            final /* synthetic */ long $okhttpTimeoutSeconds;
            {
                this.this$0 = $receiver;
                this.$userAgentName = $userAgentName;
                this.$userAgentVersion = $userAgentVersion;
                this.$okhttpTimeoutSeconds = $okhttpTimeoutSeconds;
                super(0);
            }

            public final SonatypeCentralPortalService invoke() {
                OkHttpClient okHttpClient = new OkHttpClient.Builder().addInterceptor((Interceptor)new SonatypeCentralPortalOkHttpInterceptor(SonatypeCentralPortal.access$getUsertoken$p(this.this$0), this.$userAgentName, this.$userAgentVersion)).connectTimeout(this.$okhttpTimeoutSeconds, TimeUnit.SECONDS).readTimeout(this.$okhttpTimeoutSeconds, TimeUnit.SECONDS).writeTimeout(this.$okhttpTimeoutSeconds, TimeUnit.SECONDS).build();
                Retrofit retrofit = new Retrofit.Builder().client(okHttpClient).baseUrl(SonatypeCentralPortal.access$getBaseUrl$p(this.this$0)).addConverterFactory((Converter.Factory)ScalarsConverterFactory.create()).build();
                return (SonatypeCentralPortalService)retrofit.create(SonatypeCentralPortalService.class);
            }
        }));
    }

    private final SonatypeCentralPortalService getService() {
        Lazy lazy = this.service$delegate;
        return (SonatypeCentralPortalService)lazy.getValue();
    }

    public final void deleteDeployment(@NotNull String deploymentId) {
        Intrinsics.checkNotNullParameter((Object)deploymentId, (String)"deploymentId");
        Response deleteDeploymentResponse = this.getService().deleteDeployment(deploymentId).execute();
        if (!deleteDeploymentResponse.isSuccessful()) {
            ResponseBody responseBody = deleteDeploymentResponse.errorBody();
            throw new IOException("Failed to delete deploymentId " + deploymentId + " code: " + deleteDeploymentResponse.code() + " msg: " + (responseBody != null ? responseBody.string() : null));
        }
    }

    public final void publishDeployment(@NotNull String deploymentId) {
        Intrinsics.checkNotNullParameter((Object)deploymentId, (String)"deploymentId");
        Response publishDeploymentResponse = this.getService().publishDeployment(deploymentId).execute();
        if (!publishDeploymentResponse.isSuccessful()) {
            ResponseBody responseBody = publishDeploymentResponse.errorBody();
            throw new IOException("Failed to delete deploymentId " + deploymentId + " code: " + publishDeploymentResponse.code() + " msg: " + (responseBody != null ? responseBody.string() : null));
        }
    }

    @NotNull
    public final String upload(@NotNull String name, @NotNull PublishingType publishingType, @NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)((Object)publishingType), (String)"publishingType");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        RequestBody uploadFile = RequestBody.Companion.create(file, MediaType.Companion.get("application/octet-stream"));
        MultipartBody.Part multipart = MultipartBody.Part.Companion.createFormData("bundle", file.getName(), uploadFile);
        Response uploadResponse = this.getService().uploadBundle(name, publishingType, multipart).execute();
        if (uploadResponse.isSuccessful()) {
            Object object = uploadResponse.body();
            if (object == null) {
                String string = "Required value was null.";
                throw new IllegalArgumentException(string.toString());
            }
            return (String)object;
        }
        ResponseBody responseBody = uploadResponse.errorBody();
        throw new IOException("Upload failed: " + (responseBody != null ? responseBody.string() : null));
    }

    public static final /* synthetic */ String access$getUsertoken$p(SonatypeCentralPortal $this) {
        return $this.usertoken;
    }

    public static final /* synthetic */ String access$getBaseUrl$p(SonatypeCentralPortal $this) {
        return $this.baseUrl;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lcom/vanniktech/maven/publish/portal/SonatypeCentralPortal$PublishingType;", "", "(Ljava/lang/String;I)V", "AUTOMATIC", "USER_MANAGED", "central-portal"})
    public static final class PublishingType
    extends Enum<PublishingType> {
        public static final /* enum */ PublishingType AUTOMATIC = new PublishingType();
        public static final /* enum */ PublishingType USER_MANAGED = new PublishingType();
        private static final /* synthetic */ PublishingType[] $VALUES;

        public static PublishingType[] values() {
            return (PublishingType[])$VALUES.clone();
        }

        public static PublishingType valueOf(String value) {
            return Enum.valueOf(PublishingType.class, value);
        }

        static {
            $VALUES = publishingTypeArray = new PublishingType[]{PublishingType.AUTOMATIC, PublishingType.USER_MANAGED};
        }
    }
}

