/*
 * Decompiled with CFR 0.152.
 */
package com.vanniktech.emoji;

import android.content.Context;
import android.graphics.Paint;
import android.text.Spannable;
import android.util.AttributeSet;
import android.widget.TextView;
import androidx.annotation.CallSuper;
import androidx.annotation.DimenRes;
import androidx.annotation.Px;
import androidx.appcompat.widget.AppCompatAutoCompleteTextView;
import com.vanniktech.emoji.EmojiDisplayable;
import com.vanniktech.emoji.EmojiManager;
import com.vanniktech.emoji.EmojiManagers;
import com.vanniktech.emoji.EmojiTextViews;
import com.vanniktech.emoji.R;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u00012\u00020\u0002B\u001d\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ*\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0010H\u0015J\b\u0010\u0013\u001a\u00020\nH\u0016J\u0012\u0010\u0014\u001a\u00020\f2\b\b\u0001\u0010\u0015\u001a\u00020\u0010H\u0016J\u001a\u0010\u0014\u001a\u00020\f2\b\b\u0001\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0012\u0010\u0018\u001a\u00020\f2\b\b\u0001\u0010\u0019\u001a\u00020\u0010H\u0016J\u001a\u0010\u0018\u001a\u00020\f2\b\b\u0001\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u0017H\u0016R\u0012\u0010\t\u001a\u00020\n8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/vanniktech/emoji/EmojiAutoCompleteTextView;", "Landroidx/appcompat/widget/AppCompatAutoCompleteTextView;", "Lcom/vanniktech/emoji/EmojiDisplayable;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "<init>", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "emojiSize", "", "onTextChanged", "", "text", "", "start", "", "lengthBefore", "lengthAfter", "getEmojiSize", "setEmojiSize", "pixels", "shouldInvalidate", "", "setEmojiSizeRes", "res", "emoji_release"})
public class EmojiAutoCompleteTextView
extends AppCompatAutoCompleteTextView
implements EmojiDisplayable {
    @Px
    private float emojiSize;

    @JvmOverloads
    public EmojiAutoCompleteTextView(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs);
        TextView textView = (TextView)this;
        Intrinsics.checkNotNullExpressionValue((Object)R.styleable.EmojiAutoCompleteTextView, (String)"EmojiAutoCompleteTextView");
        this.emojiSize = EmojiTextViews.init(textView, attrs, R.styleable.EmojiAutoCompleteTextView, R.styleable.EmojiAutoCompleteTextView_emojiSize);
    }

    public /* synthetic */ EmojiAutoCompleteTextView(Context context, AttributeSet attributeSet, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            attributeSet = null;
        }
        this(context, attributeSet);
    }

    @CallSuper
    protected void onTextChanged(@Nullable CharSequence text, int start, int lengthBefore, int lengthAfter) {
        if (this.isInEditMode()) {
            return;
        }
        Paint.FontMetrics fontMetrics = this.getPaint().getFontMetrics();
        float defaultEmojiSize = fontMetrics.descent - fontMetrics.ascent;
        Context context = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getContext(...)");
        EmojiManagers.replaceWithImages(EmojiManager.INSTANCE, context, (Spannable)this.getText(), !(this.emojiSize == 0.0f) ? this.emojiSize : defaultEmojiSize);
    }

    @Override
    public float getEmojiSize() {
        return this.emojiSize;
    }

    @Override
    public void setEmojiSize(@Px int pixels) {
        this.setEmojiSize(pixels, true);
    }

    @Override
    public void setEmojiSize(@Px int pixels, boolean shouldInvalidate) {
        this.emojiSize = pixels;
        if (shouldInvalidate) {
            this.setText((CharSequence)this.getText());
        }
    }

    @Override
    public void setEmojiSizeRes(@DimenRes int res) {
        this.setEmojiSizeRes(res, true);
    }

    @Override
    public void setEmojiSizeRes(@DimenRes int res, boolean shouldInvalidate) {
        this.setEmojiSize(this.getResources().getDimensionPixelSize(res), shouldInvalidate);
    }

    @JvmOverloads
    public EmojiAutoCompleteTextView(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, 2, null);
    }
}

