/*
 * Copyright (C) 2016 - Niklas Baudy, Ruben Gees, Mario Đanić and contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.vanniktech.emoji.facebook.category

import com.vanniktech.emoji.facebook.FacebookEmoji

internal object SmileysAndPeopleCategoryChunk2 {
  internal val EMOJIS: List<FacebookEmoji> = listOf(
    FacebookEmoji(
      String(intArrayOf(0x1F9D1, 0x200D, 0x1F9B3), 0, 3), listOf("white_haired_person"), 49, 32, false,
      variants = listOf(
        FacebookEmoji(String(intArrayOf(0x1F9D1, 0x1F3FB, 0x200D, 0x1F9B3), 0, 4), emptyList<String>(), 49, 33, false),
        FacebookEmoji(String(intArrayOf(0x1F9D1, 0x1F3FC, 0x200D, 0x1F9B3), 0, 4), emptyList<String>(), 49, 34, false),
        FacebookEmoji(String(intArrayOf(0x1F9D1, 0x1F3FD, 0x200D, 0x1F9B3), 0, 4), emptyList<String>(), 49, 35, false),
        FacebookEmoji(String(intArrayOf(0x1F9D1, 0x1F3FE, 0x200D, 0x1F9B3), 0, 4), emptyList<String>(), 49, 36, false),
        FacebookEmoji(String(intArrayOf(0x1F9D1, 0x1F3FF, 0x200D, 0x1F9B3), 0, 4), emptyList<String>(), 49, 37, false),
      ),
    ),
    FacebookEmoji(
      String(intArrayOf(0x1F469, 0x200D, 0x1F9B2), 0, 3), listOf("bald_woman"), 19, 10, false,
      variants = listOf(
        FacebookEmoji(String(intArrayOf(0x1F469, 0x1F3FB, 0x200D, 0x1F9B2), 0, 4), emptyList<String>(), 19, 11, false),
        FacebookEmoji(String(intArrayOf(0x1F469, 0x1F3FC, 0x200D, 0x1F9B2), 0, 4), emptyList<String>(), 19, 12, false),
        FacebookEmoji(String(intArrayOf(0x1F469, 0x1F3FD, 0x200D, 0x1F9B2), 0, 4), emptyList<String>(), 19, 13, false),
        FacebookEmoji(String(intArrayOf(0x1F469, 0x1F3FE, 0x200D, 0x1F9B2), 0, 4), emptyList<String>(), 19, 14, false),
        FacebookEmoji(String(intArrayOf(0x1F469, 0x1F3FF, 0x200D, 0x1F9B2), 0, 4), emptyList<String>(), 19, 15, false),
      ),
    ),
    FacebookEmoji(
      String(intArrayOf(0x1F9D1, 0x200D, 0x1F9B2), 0, 3), listOf("bald_person"), 49, 26, false,
      variants = listOf(
        FacebookEmoji(String(intArrayOf(0x1F9D1, 0x1F3FB, 0x200D, 0x1F9B2), 0, 4), emptyList<String>(), 49, 27, false),
        FacebookEmoji(String(intArrayOf(0x1F9D1, 0x1F3FC, 0x200D, 0x1F9B2), 0, 4), emptyList<String>(), 49, 28, false),
        FacebookEmoji(String(intArrayOf(0x1F9D1, 0x1F3FD, 0x200D, 0x1F9B2), 0, 4), emptyList<String>(), 49, 29, false),
        FacebookEmoji(String(intArrayOf(0x1F9D1, 0x1F3FE, 0x200D, 0x1F9B2), 0, 4), emptyList<String>(), 49, 30, false),
        FacebookEmoji(String(intArrayOf(0x1F9D1, 0x1F3FF, 0x200D, 0x1F9B2), 0, 4), emptyList<String>(), 49, 31, false),
      ),
    ),
    FacebookEmoji(
      String(intArrayOf(0x1F471, 0x200D, 0x2640, 0xFE0F), 0, 4), listOf("blond-haired-woman"), 23, 36, false,
      variants = listOf(
        FacebookEmoji(String(intArrayOf(0x1F471, 0x1F3FB, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 23, 37, false),
        FacebookEmoji(String(intArrayOf(0x1F471, 0x1F3FC, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 23, 38, false),
        FacebookEmoji(String(intArrayOf(0x1F471, 0x1F3FD, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 23, 39, false),
        FacebookEmoji(String(intArrayOf(0x1F471, 0x1F3FE, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 23, 40, false),
        FacebookEmoji(String(intArrayOf(0x1F471, 0x1F3FF, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 23, 41, false),
      ),
    ),
    FacebookEmoji(
      String(intArrayOf(0x1F471, 0x200D, 0x2642, 0xFE0F), 0, 4), listOf("blond-haired-man"), 23, 42, false,
      variants = listOf(
        FacebookEmoji(String(intArrayOf(0x1F471, 0x1F3FB, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 23, 43, false),
        FacebookEmoji(String(intArrayOf(0x1F471, 0x1F3FC, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 23, 44, false),
        FacebookEmoji(String(intArrayOf(0x1F471, 0x1F3FD, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 23, 45, false),
        FacebookEmoji(String(intArrayOf(0x1F471, 0x1F3FE, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 23, 46, false),
        FacebookEmoji(String(intArrayOf(0x1F471, 0x1F3FF, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 23, 47, false),
      ),
    ),
    FacebookEmoji(
      String(intArrayOf(0x1F9D3), 0, 1), listOf("older_adult"), 50, 19, false,
      variants = listOf(
        FacebookEmoji(String(intArrayOf(0x1F9D3, 0x1F3FB), 0, 2), emptyList<String>(), 50, 20, false),
        FacebookEmoji(String(intArrayOf(0x1F9D3, 0x1F3FC), 0, 2), emptyList<String>(), 50, 21, false),
        FacebookEmoji(String(intArrayOf(0x1F9D3, 0x1F3FD), 0, 2), emptyList<String>(), 50, 22, false),
        FacebookEmoji(String(intArrayOf(0x1F9D3, 0x1F3FE), 0, 2), emptyList<String>(), 50, 23, false),
        FacebookEmoji(String(intArrayOf(0x1F9D3, 0x1F3FF), 0, 2), emptyList<String>(), 50, 24, false),
      ),
    ),
    FacebookEmoji(
      String(intArrayOf(0x1F474), 0, 1), listOf("older_man"), 24, 17, false,
      variants = listOf(
        FacebookEmoji(String(intArrayOf(0x1F474, 0x1F3FB), 0, 2), emptyList<String>(), 24, 18, false),
        FacebookEmoji(String(intArrayOf(0x1F474, 0x1F3FC), 0, 2), emptyList<String>(), 24, 19, false),
        FacebookEmoji(String(intArrayOf(0x1F474, 0x1F3FD), 0, 2), emptyList<String>(), 24, 20, false),
        FacebookEmoji(String(intArrayOf(0x1F474, 0x1F3FE), 0, 2), emptyList<String>(), 24, 21, false),
        FacebookEmoji(String(intArrayOf(0x1F474, 0x1F3FF), 0, 2), emptyList<String>(), 24, 22, false),
      ),
    ),
    FacebookEmoji(
      String(intArrayOf(0x1F475), 0, 1), listOf("older_woman"), 24, 23, false,
      variants = listOf(
        FacebookEmoji(String(intArrayOf(0x1F475, 0x1F3FB), 0, 2), emptyList<String>(), 24, 24, false),
        FacebookEmoji(String(intArrayOf(0x1F475, 0x1F3FC), 0, 2), emptyList<String>(), 24, 25, false),
        FacebookEmoji(String(intArrayOf(0x1F475, 0x1F3FD), 0, 2), emptyList<String>(), 24, 26, false),
        FacebookEmoji(String(intArrayOf(0x1F475, 0x1F3FE), 0, 2), emptyList<String>(), 24, 27, false),
        FacebookEmoji(String(intArrayOf(0x1F475, 0x1F3FF), 0, 2), emptyList<String>(), 24, 28, false),
      ),
    ),
    FacebookEmoji(
      String(intArrayOf(0x1F64D), 0, 1), listOf("person_frowning"), 35, 3, true,
      variants = listOf(
        FacebookEmoji(String(intArrayOf(0x1F64D, 0x1F3FB), 0, 2), emptyList<String>(), 35, 4, false),
        FacebookEmoji(String(intArrayOf(0x1F64D, 0x1F3FC), 0, 2), emptyList<String>(), 35, 5, false),
        FacebookEmoji(String(intArrayOf(0x1F64D, 0x1F3FD), 0, 2), emptyList<String>(), 35, 6, false),
        FacebookEmoji(String(intArrayOf(0x1F64D, 0x1F3FE), 0, 2), emptyList<String>(), 35, 7, false),
        FacebookEmoji(String(intArrayOf(0x1F64D, 0x1F3FF), 0, 2), emptyList<String>(), 35, 8, false),
      ),
    ),
    FacebookEmoji(
      String(intArrayOf(0x1F64D, 0x200D, 0x2642, 0xFE0F), 0, 4), listOf("man-frowning"), 34, 58, false,
      variants = listOf(
        FacebookEmoji(String(intArrayOf(0x1F64D, 0x1F3FB, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 34, 59, false),
        FacebookEmoji(String(intArrayOf(0x1F64D, 0x1F3FC, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 34, 60, false),
        FacebookEmoji(String(intArrayOf(0x1F64D, 0x1F3FD, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 35, 0, false),
        FacebookEmoji(String(intArrayOf(0x1F64D, 0x1F3FE, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 35, 1, false),
        FacebookEmoji(String(intArrayOf(0x1F64D, 0x1F3FF, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 35, 2, false),
      ),
    ),
    FacebookEmoji(
      String(intArrayOf(0x1F64D, 0x200D, 0x2640, 0xFE0F), 0, 4), listOf("woman-frowning"), 34, 52, false,
      variants = listOf(
        FacebookEmoji(String(intArrayOf(0x1F64D, 0x1F3FB, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 34, 53, false),
        FacebookEmoji(String(intArrayOf(0x1F64D, 0x1F3FC, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 34, 54, false),
        FacebookEmoji(String(intArrayOf(0x1F64D, 0x1F3FD, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 34, 55, false),
        FacebookEmoji(String(intArrayOf(0x1F64D, 0x1F3FE, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 34, 56, false),
        FacebookEmoji(String(intArrayOf(0x1F64D, 0x1F3FF, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 34, 57, false),
      ),
    ),
    FacebookEmoji(
      String(intArrayOf(0x1F64E), 0, 1), listOf("person_with_pouting_face"), 35, 21, true,
      variants = listOf(
        FacebookEmoji(String(intArrayOf(0x1F64E, 0x1F3FB), 0, 2), emptyList<String>(), 35, 22, false),
        FacebookEmoji(String(intArrayOf(0x1F64E, 0x1F3FC), 0, 2), emptyList<String>(), 35, 23, false),
        FacebookEmoji(String(intArrayOf(0x1F64E, 0x1F3FD), 0, 2), emptyList<String>(), 35, 24, false),
        FacebookEmoji(String(intArrayOf(0x1F64E, 0x1F3FE), 0, 2), emptyList<String>(), 35, 25, false),
        FacebookEmoji(String(intArrayOf(0x1F64E, 0x1F3FF), 0, 2), emptyList<String>(), 35, 26, false),
      ),
    ),
    FacebookEmoji(
      String(intArrayOf(0x1F64E, 0x200D, 0x2642, 0xFE0F), 0, 4), listOf("man-pouting"), 35, 15, false,
      variants = listOf(
        FacebookEmoji(String(intArrayOf(0x1F64E, 0x1F3FB, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 35, 16, false),
        FacebookEmoji(String(intArrayOf(0x1F64E, 0x1F3FC, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 35, 17, false),
        FacebookEmoji(String(intArrayOf(0x1F64E, 0x1F3FD, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 35, 18, false),
        FacebookEmoji(String(intArrayOf(0x1F64E, 0x1F3FE, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 35, 19, false),
        FacebookEmoji(String(intArrayOf(0x1F64E, 0x1F3FF, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 35, 20, false),
      ),
    ),
    FacebookEmoji(
      String(intArrayOf(0x1F64E, 0x200D, 0x2640, 0xFE0F), 0, 4), listOf("woman-pouting"), 35, 9, false,
      variants = listOf(
        FacebookEmoji(String(intArrayOf(0x1F64E, 0x1F3FB, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 35, 10, false),
        FacebookEmoji(String(intArrayOf(0x1F64E, 0x1F3FC, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 35, 11, false),
        FacebookEmoji(String(intArrayOf(0x1F64E, 0x1F3FD, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 35, 12, false),
        FacebookEmoji(String(intArrayOf(0x1F64E, 0x1F3FE, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 35, 13, false),
        FacebookEmoji(String(intArrayOf(0x1F64E, 0x1F3FF, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 35, 14, false),
      ),
    ),
    FacebookEmoji(
      String(intArrayOf(0x1F645), 0, 1), listOf("no_good"), 33, 44, true,
      variants = listOf(
        FacebookEmoji(String(intArrayOf(0x1F645, 0x1F3FB), 0, 2), emptyList<String>(), 33, 45, false),
        FacebookEmoji(String(intArrayOf(0x1F645, 0x1F3FC), 0, 2), emptyList<String>(), 33, 46, false),
        FacebookEmoji(String(intArrayOf(0x1F645, 0x1F3FD), 0, 2), emptyList<String>(), 33, 47, false),
        FacebookEmoji(String(intArrayOf(0x1F645, 0x1F3FE), 0, 2), emptyList<String>(), 33, 48, false),
        FacebookEmoji(String(intArrayOf(0x1F645, 0x1F3FF), 0, 2), emptyList<String>(), 33, 49, false),
      ),
    ),
    FacebookEmoji(
      String(intArrayOf(0x1F645, 0x200D, 0x2642, 0xFE0F), 0, 4), listOf("man-gesturing-no"), 33, 38, false,
      variants = listOf(
        FacebookEmoji(String(intArrayOf(0x1F645, 0x1F3FB, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 33, 39, false),
        FacebookEmoji(String(intArrayOf(0x1F645, 0x1F3FC, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 33, 40, false),
        FacebookEmoji(String(intArrayOf(0x1F645, 0x1F3FD, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 33, 41, false),
        FacebookEmoji(String(intArrayOf(0x1F645, 0x1F3FE, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 33, 42, false),
        FacebookEmoji(String(intArrayOf(0x1F645, 0x1F3FF, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 33, 43, false),
      ),
    ),
    FacebookEmoji(
      String(intArrayOf(0x1F645, 0x200D, 0x2640, 0xFE0F), 0, 4), listOf("woman-gesturing-no"), 33, 32, false,
      variants = listOf(
        FacebookEmoji(String(intArrayOf(0x1F645, 0x1F3FB, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 33, 33, false),
        FacebookEmoji(String(intArrayOf(0x1F645, 0x1F3FC, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 33, 34, false),
        FacebookEmoji(String(intArrayOf(0x1F645, 0x1F3FD, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 33, 35, false),
        FacebookEmoji(String(intArrayOf(0x1F645, 0x1F3FE, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 33, 36, false),
        FacebookEmoji(String(intArrayOf(0x1F645, 0x1F3FF, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 33, 37, false),
      ),
    ),
    FacebookEmoji(
      String(intArrayOf(0x1F646), 0, 1), listOf("ok_woman"), 34, 1, true,
      variants = listOf(
        FacebookEmoji(String(intArrayOf(0x1F646, 0x1F3FB), 0, 2), emptyList<String>(), 34, 2, false),
        FacebookEmoji(String(intArrayOf(0x1F646, 0x1F3FC), 0, 2), emptyList<String>(), 34, 3, false),
        FacebookEmoji(String(intArrayOf(0x1F646, 0x1F3FD), 0, 2), emptyList<String>(), 34, 4, false),
        FacebookEmoji(String(intArrayOf(0x1F646, 0x1F3FE), 0, 2), emptyList<String>(), 34, 5, false),
        FacebookEmoji(String(intArrayOf(0x1F646, 0x1F3FF), 0, 2), emptyList<String>(), 34, 6, false),
      ),
    ),
    FacebookEmoji(
      String(intArrayOf(0x1F646, 0x200D, 0x2642, 0xFE0F), 0, 4), listOf("man-gesturing-ok"), 33, 56, false,
      variants = listOf(
        FacebookEmoji(String(intArrayOf(0x1F646, 0x1F3FB, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 33, 57, false),
        FacebookEmoji(String(intArrayOf(0x1F646, 0x1F3FC, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 33, 58, false),
        FacebookEmoji(String(intArrayOf(0x1F646, 0x1F3FD, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 33, 59, false),
        FacebookEmoji(String(intArrayOf(0x1F646, 0x1F3FE, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 33, 60, false),
        FacebookEmoji(String(intArrayOf(0x1F646, 0x1F3FF, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 34, 0, false),
      ),
    ),
    FacebookEmoji(
      String(intArrayOf(0x1F646, 0x200D, 0x2640, 0xFE0F), 0, 4), listOf("woman-gesturing-ok"), 33, 50, false,
      variants = listOf(
        FacebookEmoji(String(intArrayOf(0x1F646, 0x1F3FB, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 33, 51, false),
        FacebookEmoji(String(intArrayOf(0x1F646, 0x1F3FC, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 33, 52, false),
        FacebookEmoji(String(intArrayOf(0x1F646, 0x1F3FD, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 33, 53, false),
        FacebookEmoji(String(intArrayOf(0x1F646, 0x1F3FE, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 33, 54, false),
        FacebookEmoji(String(intArrayOf(0x1F646, 0x1F3FF, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 33, 55, false),
      ),
    ),
    FacebookEmoji(
      String(intArrayOf(0x1F481), 0, 1), listOf("information_desk_person"), 25, 23, true,
      variants = listOf(
        FacebookEmoji(String(intArrayOf(0x1F481, 0x1F3FB), 0, 2), emptyList<String>(), 25, 24, false),
        FacebookEmoji(String(intArrayOf(0x1F481, 0x1F3FC), 0, 2), emptyList<String>(), 25, 25, false),
        FacebookEmoji(String(intArrayOf(0x1F481, 0x1F3FD), 0, 2), emptyList<String>(), 25, 26, false),
        FacebookEmoji(String(intArrayOf(0x1F481, 0x1F3FE), 0, 2), emptyList<String>(), 25, 27, false),
        FacebookEmoji(String(intArrayOf(0x1F481, 0x1F3FF), 0, 2), emptyList<String>(), 25, 28, false),
      ),
    ),
    FacebookEmoji(
      String(intArrayOf(0x1F481, 0x200D, 0x2642, 0xFE0F), 0, 4), listOf("man-tipping-hand"), 25, 17, false,
      variants = listOf(
        FacebookEmoji(String(intArrayOf(0x1F481, 0x1F3FB, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 25, 18, false),
        FacebookEmoji(String(intArrayOf(0x1F481, 0x1F3FC, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 25, 19, false),
        FacebookEmoji(String(intArrayOf(0x1F481, 0x1F3FD, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 25, 20, false),
        FacebookEmoji(String(intArrayOf(0x1F481, 0x1F3FE, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 25, 21, false),
        FacebookEmoji(String(intArrayOf(0x1F481, 0x1F3FF, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 25, 22, false),
      ),
    ),
    FacebookEmoji(
      String(intArrayOf(0x1F481, 0x200D, 0x2640, 0xFE0F), 0, 4), listOf("woman-tipping-hand"), 25, 11, false,
      variants = listOf(
        FacebookEmoji(String(intArrayOf(0x1F481, 0x1F3FB, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 25, 12, false),
        FacebookEmoji(String(intArrayOf(0x1F481, 0x1F3FC, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 25, 13, false),
        FacebookEmoji(String(intArrayOf(0x1F481, 0x1F3FD, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 25, 14, false),
        FacebookEmoji(String(intArrayOf(0x1F481, 0x1F3FE, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 25, 15, false),
        FacebookEmoji(String(intArrayOf(0x1F481, 0x1F3FF, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 25, 16, false),
      ),
    ),
    FacebookEmoji(
      String(intArrayOf(0x1F64B), 0, 1), listOf("raising_hand"), 34, 40, true,
      variants = listOf(
        FacebookEmoji(String(intArrayOf(0x1F64B, 0x1F3FB), 0, 2), emptyList<String>(), 34, 41, false),
        FacebookEmoji(String(intArrayOf(0x1F64B, 0x1F3FC), 0, 2), emptyList<String>(), 34, 42, false),
        FacebookEmoji(String(intArrayOf(0x1F64B, 0x1F3FD), 0, 2), emptyList<String>(), 34, 43, false),
        FacebookEmoji(String(intArrayOf(0x1F64B, 0x1F3FE), 0, 2), emptyList<String>(), 34, 44, false),
        FacebookEmoji(String(intArrayOf(0x1F64B, 0x1F3FF), 0, 2), emptyList<String>(), 34, 45, false),
      ),
    ),
    FacebookEmoji(
      String(intArrayOf(0x1F64B, 0x200D, 0x2642, 0xFE0F), 0, 4), listOf("man-raising-hand"), 34, 34, false,
      variants = listOf(
        FacebookEmoji(String(intArrayOf(0x1F64B, 0x1F3FB, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 34, 35, false),
        FacebookEmoji(String(intArrayOf(0x1F64B, 0x1F3FC, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 34, 36, false),
        FacebookEmoji(String(intArrayOf(0x1F64B, 0x1F3FD, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 34, 37, false),
        FacebookEmoji(String(intArrayOf(0x1F64B, 0x1F3FE, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 34, 38, false),
        FacebookEmoji(String(intArrayOf(0x1F64B, 0x1F3FF, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 34, 39, false),
      ),
    ),
    FacebookEmoji(
      String(intArrayOf(0x1F64B, 0x200D, 0x2640, 0xFE0F), 0, 4), listOf("woman-raising-hand"), 34, 28, false,
      variants = listOf(
        FacebookEmoji(String(intArrayOf(0x1F64B, 0x1F3FB, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 34, 29, false),
        FacebookEmoji(String(intArrayOf(0x1F64B, 0x1F3FC, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 34, 30, false),
        FacebookEmoji(String(intArrayOf(0x1F64B, 0x1F3FD, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 34, 31, false),
        FacebookEmoji(String(intArrayOf(0x1F64B, 0x1F3FE, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 34, 32, false),
        FacebookEmoji(String(intArrayOf(0x1F64B, 0x1F3FF, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 34, 33, false),
      ),
    ),
    FacebookEmoji(
      String(intArrayOf(0x1F9CF), 0, 1), listOf("deaf_person"), 47, 7, false,
      variants = listOf(
        FacebookEmoji(String(intArrayOf(0x1F9CF, 0x1F3FB), 0, 2), emptyList<String>(), 47, 8, false),
        FacebookEmoji(String(intArrayOf(0x1F9CF, 0x1F3FC), 0, 2), emptyList<String>(), 47, 9, false),
        FacebookEmoji(String(intArrayOf(0x1F9CF, 0x1F3FD), 0, 2), emptyList<String>(), 47, 10, false),
        FacebookEmoji(String(intArrayOf(0x1F9CF, 0x1F3FE), 0, 2), emptyList<String>(), 47, 11, false),
        FacebookEmoji(String(intArrayOf(0x1F9CF, 0x1F3FF), 0, 2), emptyList<String>(), 47, 12, false),
      ),
    ),
    FacebookEmoji(
      String(intArrayOf(0x1F9CF, 0x200D, 0x2642, 0xFE0F), 0, 4), listOf("deaf_man"), 47, 1, false,
      variants = listOf(
        FacebookEmoji(String(intArrayOf(0x1F9CF, 0x1F3FB, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 47, 2, false),
        FacebookEmoji(String(intArrayOf(0x1F9CF, 0x1F3FC, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 47, 3, false),
        FacebookEmoji(String(intArrayOf(0x1F9CF, 0x1F3FD, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 47, 4, false),
        FacebookEmoji(String(intArrayOf(0x1F9CF, 0x1F3FE, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 47, 5, false),
        FacebookEmoji(String(intArrayOf(0x1F9CF, 0x1F3FF, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 47, 6, false),
      ),
    ),
    FacebookEmoji(
      String(intArrayOf(0x1F9CF, 0x200D, 0x2640, 0xFE0F), 0, 4), listOf("deaf_woman"), 46, 56, false,
      variants = listOf(
        FacebookEmoji(String(intArrayOf(0x1F9CF, 0x1F3FB, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 46, 57, false),
        FacebookEmoji(String(intArrayOf(0x1F9CF, 0x1F3FC, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 46, 58, false),
        FacebookEmoji(String(intArrayOf(0x1F9CF, 0x1F3FD, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 46, 59, false),
        FacebookEmoji(String(intArrayOf(0x1F9CF, 0x1F3FE, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 46, 60, false),
        FacebookEmoji(String(intArrayOf(0x1F9CF, 0x1F3FF, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 47, 0, false),
      ),
    ),
    FacebookEmoji(
      String(intArrayOf(0x1F647), 0, 1), listOf("bow"), 34, 19, false,
      variants = listOf(
        FacebookEmoji(String(intArrayOf(0x1F647, 0x1F3FB), 0, 2), emptyList<String>(), 34, 20, false),
        FacebookEmoji(String(intArrayOf(0x1F647, 0x1F3FC), 0, 2), emptyList<String>(), 34, 21, false),
        FacebookEmoji(String(intArrayOf(0x1F647, 0x1F3FD), 0, 2), emptyList<String>(), 34, 22, false),
        FacebookEmoji(String(intArrayOf(0x1F647, 0x1F3FE), 0, 2), emptyList<String>(), 34, 23, false),
        FacebookEmoji(String(intArrayOf(0x1F647, 0x1F3FF), 0, 2), emptyList<String>(), 34, 24, false),
      ),
    ),
    FacebookEmoji(
      String(intArrayOf(0x1F647, 0x200D, 0x2642, 0xFE0F), 0, 4), listOf("man-bowing"), 34, 13, false,
      variants = listOf(
        FacebookEmoji(String(intArrayOf(0x1F647, 0x1F3FB, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 34, 14, false),
        FacebookEmoji(String(intArrayOf(0x1F647, 0x1F3FC, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 34, 15, false),
        FacebookEmoji(String(intArrayOf(0x1F647, 0x1F3FD, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 34, 16, false),
        FacebookEmoji(String(intArrayOf(0x1F647, 0x1F3FE, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 34, 17, false),
        FacebookEmoji(String(intArrayOf(0x1F647, 0x1F3FF, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 34, 18, false),
      ),
    ),
    FacebookEmoji(
      String(intArrayOf(0x1F647, 0x200D, 0x2640, 0xFE0F), 0, 4), listOf("woman-bowing"), 34, 7, false,
      variants = listOf(
        FacebookEmoji(String(intArrayOf(0x1F647, 0x1F3FB, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 34, 8, false),
        FacebookEmoji(String(intArrayOf(0x1F647, 0x1F3FC, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 34, 9, false),
        FacebookEmoji(String(intArrayOf(0x1F647, 0x1F3FD, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 34, 10, false),
        FacebookEmoji(String(intArrayOf(0x1F647, 0x1F3FE, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 34, 11, false),
        FacebookEmoji(String(intArrayOf(0x1F647, 0x1F3FF, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 34, 12, false),
      ),
    ),
    FacebookEmoji(
      String(intArrayOf(0x1F926), 0, 1), listOf("face_palm"), 40, 32, true,
      variants = listOf(
        FacebookEmoji(String(intArrayOf(0x1F926, 0x1F3FB), 0, 2), emptyList<String>(), 40, 33, false),
        FacebookEmoji(String(intArrayOf(0x1F926, 0x1F3FC), 0, 2), emptyList<String>(), 40, 34, false),
        FacebookEmoji(String(intArrayOf(0x1F926, 0x1F3FD), 0, 2), emptyList<String>(), 40, 35, false),
        FacebookEmoji(String(intArrayOf(0x1F926, 0x1F3FE), 0, 2), emptyList<String>(), 40, 36, false),
        FacebookEmoji(String(intArrayOf(0x1F926, 0x1F3FF), 0, 2), emptyList<String>(), 40, 37, false),
      ),
    ),
    FacebookEmoji(
      String(intArrayOf(0x1F926, 0x200D, 0x2642, 0xFE0F), 0, 4), listOf("man-facepalming"), 40, 26, false,
      variants = listOf(
        FacebookEmoji(String(intArrayOf(0x1F926, 0x1F3FB, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 40, 27, false),
        FacebookEmoji(String(intArrayOf(0x1F926, 0x1F3FC, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 40, 28, false),
        FacebookEmoji(String(intArrayOf(0x1F926, 0x1F3FD, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 40, 29, false),
        FacebookEmoji(String(intArrayOf(0x1F926, 0x1F3FE, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 40, 30, false),
        FacebookEmoji(String(intArrayOf(0x1F926, 0x1F3FF, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 40, 31, false),
      ),
    ),
    FacebookEmoji(
      String(intArrayOf(0x1F926, 0x200D, 0x2640, 0xFE0F), 0, 4), listOf("woman-facepalming"), 40, 20, false,
      variants = listOf(
        FacebookEmoji(String(intArrayOf(0x1F926, 0x1F3FB, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 40, 21, false),
        FacebookEmoji(String(intArrayOf(0x1F926, 0x1F3FC, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 40, 22, false),
        FacebookEmoji(String(intArrayOf(0x1F926, 0x1F3FD, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 40, 23, false),
        FacebookEmoji(String(intArrayOf(0x1F926, 0x1F3FE, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 40, 24, false),
        FacebookEmoji(String(intArrayOf(0x1F926, 0x1F3FF, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 40, 25, false),
      ),
    ),
    FacebookEmoji(
      String(intArrayOf(0x1F937), 0, 1), listOf("shrug"), 41, 52, true,
      variants = listOf(
        FacebookEmoji(String(intArrayOf(0x1F937, 0x1F3FB), 0, 2), emptyList<String>(), 41, 53, false),
        FacebookEmoji(String(intArrayOf(0x1F937, 0x1F3FC), 0, 2), emptyList<String>(), 41, 54, false),
        FacebookEmoji(String(intArrayOf(0x1F937, 0x1F3FD), 0, 2), emptyList<String>(), 41, 55, false),
        FacebookEmoji(String(intArrayOf(0x1F937, 0x1F3FE), 0, 2), emptyList<String>(), 41, 56, false),
        FacebookEmoji(String(intArrayOf(0x1F937, 0x1F3FF), 0, 2), emptyList<String>(), 41, 57, false),
      ),
    ),
    FacebookEmoji(
      String(intArrayOf(0x1F937, 0x200D, 0x2642, 0xFE0F), 0, 4), listOf("man-shrugging"), 41, 46, false,
      variants = listOf(
        FacebookEmoji(String(intArrayOf(0x1F937, 0x1F3FB, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 41, 47, false),
        FacebookEmoji(String(intArrayOf(0x1F937, 0x1F3FC, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 41, 48, false),
        FacebookEmoji(String(intArrayOf(0x1F937, 0x1F3FD, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 41, 49, false),
        FacebookEmoji(String(intArrayOf(0x1F937, 0x1F3FE, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 41, 50, false),
        FacebookEmoji(String(intArrayOf(0x1F937, 0x1F3FF, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 41, 51, false),
      ),
    ),
    FacebookEmoji(
      String(intArrayOf(0x1F937, 0x200D, 0x2640, 0xFE0F), 0, 4), listOf("woman-shrugging"), 41, 40, false,
      variants = listOf(
        FacebookEmoji(String(intArrayOf(0x1F937, 0x1F3FB, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 41, 41, false),
        FacebookEmoji(String(intArrayOf(0x1F937, 0x1F3FC, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 41, 42, false),
        FacebookEmoji(String(intArrayOf(0x1F937, 0x1F3FD, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 41, 43, false),
        FacebookEmoji(String(intArrayOf(0x1F937, 0x1F3FE, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 41, 44, false),
        FacebookEmoji(String(intArrayOf(0x1F937, 0x1F3FF, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 41, 45, false),
      ),
    ),
    FacebookEmoji(
      String(intArrayOf(0x1F9D1, 0x200D, 0x2695, 0xFE0F), 0, 4), listOf("health_worker"), 49, 50, false,
      variants = listOf(
        FacebookEmoji(String(intArrayOf(0x1F9D1, 0x1F3FB, 0x200D, 0x2695, 0xFE0F), 0, 5), emptyList<String>(), 49, 51, false),
        FacebookEmoji(String(intArrayOf(0x1F9D1, 0x1F3FC, 0x200D, 0x2695, 0xFE0F), 0, 5), emptyList<String>(), 49, 52, false),
        FacebookEmoji(String(intArrayOf(0x1F9D1, 0x1F3FD, 0x200D, 0x2695, 0xFE0F), 0, 5), emptyList<String>(), 49, 53, false),
        FacebookEmoji(String(intArrayOf(0x1F9D1, 0x1F3FE, 0x200D, 0x2695, 0xFE0F), 0, 5), emptyList<String>(), 49, 54, false),
        FacebookEmoji(String(intArrayOf(0x1F9D1, 0x1F3FF, 0x200D, 0x2695, 0xFE0F), 0, 5), emptyList<String>(), 49, 55, false),
      ),
    ),
    FacebookEmoji(
      String(intArrayOf(0x1F468, 0x200D, 0x2695, 0xFE0F), 0, 4), listOf("male-doctor"), 16, 5, false,
      variants = listOf(
        FacebookEmoji(String(intArrayOf(0x1F468, 0x1F3FB, 0x200D, 0x2695, 0xFE0F), 0, 5), emptyList<String>(), 16, 6, false),
        FacebookEmoji(String(intArrayOf(0x1F468, 0x1F3FC, 0x200D, 0x2695, 0xFE0F), 0, 5), emptyList<String>(), 16, 7, false),
        FacebookEmoji(String(intArrayOf(0x1F468, 0x1F3FD, 0x200D, 0x2695, 0xFE0F), 0, 5), emptyList<String>(), 16, 8, false),
        FacebookEmoji(String(intArrayOf(0x1F468, 0x1F3FE, 0x200D, 0x2695, 0xFE0F), 0, 5), emptyList<String>(), 16, 9, false),
        FacebookEmoji(String(intArrayOf(0x1F468, 0x1F3FF, 0x200D, 0x2695, 0xFE0F), 0, 5), emptyList<String>(), 16, 10, false),
      ),
    ),
    FacebookEmoji(
      String(intArrayOf(0x1F469, 0x200D, 0x2695, 0xFE0F), 0, 4), listOf("female-doctor"), 19, 34, false,
      variants = listOf(
        FacebookEmoji(String(intArrayOf(0x1F469, 0x1F3FB, 0x200D, 0x2695, 0xFE0F), 0, 5), emptyList<String>(), 19, 35, false),
        FacebookEmoji(String(intArrayOf(0x1F469, 0x1F3FC, 0x200D, 0x2695, 0xFE0F), 0, 5), emptyList<String>(), 19, 36, false),
        FacebookEmoji(String(intArrayOf(0x1F469, 0x1F3FD, 0x200D, 0x2695, 0xFE0F), 0, 5), emptyList<String>(), 19, 37, false),
        FacebookEmoji(String(intArrayOf(0x1F469, 0x1F3FE, 0x200D, 0x2695, 0xFE0F), 0, 5), emptyList<String>(), 19, 38, false),
        FacebookEmoji(String(intArrayOf(0x1F469, 0x1F3FF, 0x200D, 0x2695, 0xFE0F), 0, 5), emptyList<String>(), 19, 39, false),
      ),
    ),
    FacebookEmoji(
      String(intArrayOf(0x1F9D1, 0x200D, 0x1F393), 0, 3), listOf("student"), 47, 38, false,
      variants = listOf(
        FacebookEmoji(String(intArrayOf(0x1F9D1, 0x1F3FB, 0x200D, 0x1F393), 0, 4), emptyList<String>(), 47, 39, false),
        FacebookEmoji(String(intArrayOf(0x1F9D1, 0x1F3FC, 0x200D, 0x1F393), 0, 4), emptyList<String>(), 47, 40, false),
        FacebookEmoji(String(intArrayOf(0x1F9D1, 0x1F3FD, 0x200D, 0x1F393), 0, 4), emptyList<String>(), 47, 41, false),
        FacebookEmoji(String(intArrayOf(0x1F9D1, 0x1F3FE, 0x200D, 0x1F393), 0, 4), emptyList<String>(), 47, 42, false),
        FacebookEmoji(String(intArrayOf(0x1F9D1, 0x1F3FF, 0x200D, 0x1F393), 0, 4), emptyList<String>(), 47, 43, false),
      ),
    ),
    FacebookEmoji(
      String(intArrayOf(0x1F468, 0x200D, 0x1F393), 0, 3), listOf("male-student"), 14, 4, false,
      variants = listOf(
        FacebookEmoji(String(intArrayOf(0x1F468, 0x1F3FB, 0x200D, 0x1F393), 0, 4), emptyList<String>(), 14, 5, false),
        FacebookEmoji(String(intArrayOf(0x1F468, 0x1F3FC, 0x200D, 0x1F393), 0, 4), emptyList<String>(), 14, 6, false),
        FacebookEmoji(String(intArrayOf(0x1F468, 0x1F3FD, 0x200D, 0x1F393), 0, 4), emptyList<String>(), 14, 7, false),
        FacebookEmoji(String(intArrayOf(0x1F468, 0x1F3FE, 0x200D, 0x1F393), 0, 4), emptyList<String>(), 14, 8, false),
        FacebookEmoji(String(intArrayOf(0x1F468, 0x1F3FF, 0x200D, 0x1F393), 0, 4), emptyList<String>(), 14, 9, false),
      ),
    ),
    FacebookEmoji(
      String(intArrayOf(0x1F469, 0x200D, 0x1F393), 0, 3), listOf("female-student"), 17, 38, false,
      variants = listOf(
        FacebookEmoji(String(intArrayOf(0x1F469, 0x1F3FB, 0x200D, 0x1F393), 0, 4), emptyList<String>(), 17, 39, false),
        FacebookEmoji(String(intArrayOf(0x1F469, 0x1F3FC, 0x200D, 0x1F393), 0, 4), emptyList<String>(), 17, 40, false),
        FacebookEmoji(String(intArrayOf(0x1F469, 0x1F3FD, 0x200D, 0x1F393), 0, 4), emptyList<String>(), 17, 41, false),
        FacebookEmoji(String(intArrayOf(0x1F469, 0x1F3FE, 0x200D, 0x1F393), 0, 4), emptyList<String>(), 17, 42, false),
        FacebookEmoji(String(intArrayOf(0x1F469, 0x1F3FF, 0x200D, 0x1F393), 0, 4), emptyList<String>(), 17, 43, false),
      ),
    ),
    FacebookEmoji(
      String(intArrayOf(0x1F9D1, 0x200D, 0x1F3EB), 0, 3), listOf("teacher"), 47, 56, false,
      variants = listOf(
        FacebookEmoji(String(intArrayOf(0x1F9D1, 0x1F3FB, 0x200D, 0x1F3EB), 0, 4), emptyList<String>(), 47, 57, false),
        FacebookEmoji(String(intArrayOf(0x1F9D1, 0x1F3FC, 0x200D, 0x1F3EB), 0, 4), emptyList<String>(), 47, 58, false),
        FacebookEmoji(String(intArrayOf(0x1F9D1, 0x1F3FD, 0x200D, 0x1F3EB), 0, 4), emptyList<String>(), 47, 59, false),
        FacebookEmoji(String(intArrayOf(0x1F9D1, 0x1F3FE, 0x200D, 0x1F3EB), 0, 4), emptyList<String>(), 47, 60, false),
        FacebookEmoji(String(intArrayOf(0x1F9D1, 0x1F3FF, 0x200D, 0x1F3EB), 0, 4), emptyList<String>(), 48, 0, false),
      ),
    ),
    FacebookEmoji(
      String(intArrayOf(0x1F468, 0x200D, 0x1F3EB), 0, 3), listOf("male-teacher"), 14, 22, false,
      variants = listOf(
        FacebookEmoji(String(intArrayOf(0x1F468, 0x1F3FB, 0x200D, 0x1F3EB), 0, 4), emptyList<String>(), 14, 23, false),
        FacebookEmoji(String(intArrayOf(0x1F468, 0x1F3FC, 0x200D, 0x1F3EB), 0, 4), emptyList<String>(), 14, 24, false),
        FacebookEmoji(String(intArrayOf(0x1F468, 0x1F3FD, 0x200D, 0x1F3EB), 0, 4), emptyList<String>(), 14, 25, false),
        FacebookEmoji(String(intArrayOf(0x1F468, 0x1F3FE, 0x200D, 0x1F3EB), 0, 4), emptyList<String>(), 14, 26, false),
        FacebookEmoji(String(intArrayOf(0x1F468, 0x1F3FF, 0x200D, 0x1F3EB), 0, 4), emptyList<String>(), 14, 27, false),
      ),
    ),
    FacebookEmoji(
      String(intArrayOf(0x1F469, 0x200D, 0x1F3EB), 0, 3), listOf("female-teacher"), 17, 56, false,
      variants = listOf(
        FacebookEmoji(String(intArrayOf(0x1F469, 0x1F3FB, 0x200D, 0x1F3EB), 0, 4), emptyList<String>(), 17, 57, false),
        FacebookEmoji(String(intArrayOf(0x1F469, 0x1F3FC, 0x200D, 0x1F3EB), 0, 4), emptyList<String>(), 17, 58, false),
        FacebookEmoji(String(intArrayOf(0x1F469, 0x1F3FD, 0x200D, 0x1F3EB), 0, 4), emptyList<String>(), 17, 59, false),
        FacebookEmoji(String(intArrayOf(0x1F469, 0x1F3FE, 0x200D, 0x1F3EB), 0, 4), emptyList<String>(), 17, 60, false),
        FacebookEmoji(String(intArrayOf(0x1F469, 0x1F3FF, 0x200D, 0x1F3EB), 0, 4), emptyList<String>(), 18, 0, false),
      ),
    ),
    FacebookEmoji(
      String(intArrayOf(0x1F9D1, 0x200D, 0x2696, 0xFE0F), 0, 4), listOf("judge"), 49, 56, false,
      variants = listOf(
        FacebookEmoji(String(intArrayOf(0x1F9D1, 0x1F3FB, 0x200D, 0x2696, 0xFE0F), 0, 5), emptyList<String>(), 49, 57, false),
        FacebookEmoji(String(intArrayOf(0x1F9D1, 0x1F3FC, 0x200D, 0x2696, 0xFE0F), 0, 5), emptyList<String>(), 49, 58, false),
        FacebookEmoji(String(intArrayOf(0x1F9D1, 0x1F3FD, 0x200D, 0x2696, 0xFE0F), 0, 5), emptyList<String>(), 49, 59, false),
        FacebookEmoji(String(intArrayOf(0x1F9D1, 0x1F3FE, 0x200D, 0x2696, 0xFE0F), 0, 5), emptyList<String>(), 49, 60, false),
        FacebookEmoji(String(intArrayOf(0x1F9D1, 0x1F3FF, 0x200D, 0x2696, 0xFE0F), 0, 5), emptyList<String>(), 50, 0, false),
      ),
    ),
    FacebookEmoji(
      String(intArrayOf(0x1F468, 0x200D, 0x2696, 0xFE0F), 0, 4), listOf("male-judge"), 16, 11, false,
      variants = listOf(
        FacebookEmoji(String(intArrayOf(0x1F468, 0x1F3FB, 0x200D, 0x2696, 0xFE0F), 0, 5), emptyList<String>(), 16, 12, false),
        FacebookEmoji(String(intArrayOf(0x1F468, 0x1F3FC, 0x200D, 0x2696, 0xFE0F), 0, 5), emptyList<String>(), 16, 13, false),
        FacebookEmoji(String(intArrayOf(0x1F468, 0x1F3FD, 0x200D, 0x2696, 0xFE0F), 0, 5), emptyList<String>(), 16, 14, false),
        FacebookEmoji(String(intArrayOf(0x1F468, 0x1F3FE, 0x200D, 0x2696, 0xFE0F), 0, 5), emptyList<String>(), 16, 15, false),
        FacebookEmoji(String(intArrayOf(0x1F468, 0x1F3FF, 0x200D, 0x2696, 0xFE0F), 0, 5), emptyList<String>(), 16, 16, false),
      ),
    ),
    FacebookEmoji(
      String(intArrayOf(0x1F469, 0x200D, 0x2696, 0xFE0F), 0, 4), listOf("female-judge"), 19, 40, false,
      variants = listOf(
        FacebookEmoji(String(intArrayOf(0x1F469, 0x1F3FB, 0x200D, 0x2696, 0xFE0F), 0, 5), emptyList<String>(), 19, 41, false),
        FacebookEmoji(String(intArrayOf(0x1F469, 0x1F3FC, 0x200D, 0x2696, 0xFE0F), 0, 5), emptyList<String>(), 19, 42, false),
        FacebookEmoji(String(intArrayOf(0x1F469, 0x1F3FD, 0x200D, 0x2696, 0xFE0F), 0, 5), emptyList<String>(), 19, 43, false),
        FacebookEmoji(String(intArrayOf(0x1F469, 0x1F3FE, 0x200D, 0x2696, 0xFE0F), 0, 5), emptyList<String>(), 19, 44, false),
        FacebookEmoji(String(intArrayOf(0x1F469, 0x1F3FF, 0x200D, 0x2696, 0xFE0F), 0, 5), emptyList<String>(), 19, 45, false),
      ),
    ),
    FacebookEmoji(
      String(intArrayOf(0x1F9D1, 0x200D, 0x1F33E), 0, 3), listOf("farmer"), 47, 14, false,
      variants = listOf(
        FacebookEmoji(String(intArrayOf(0x1F9D1, 0x1F3FB, 0x200D, 0x1F33E), 0, 4), emptyList<String>(), 47, 15, false),
        FacebookEmoji(String(intArrayOf(0x1F9D1, 0x1F3FC, 0x200D, 0x1F33E), 0, 4), emptyList<String>(), 47, 16, false),
        FacebookEmoji(String(intArrayOf(0x1F9D1, 0x1F3FD, 0x200D, 0x1F33E), 0, 4), emptyList<String>(), 47, 17, false),
        FacebookEmoji(String(intArrayOf(0x1F9D1, 0x1F3FE, 0x200D, 0x1F33E), 0, 4), emptyList<String>(), 47, 18, false),
        FacebookEmoji(String(intArrayOf(0x1F9D1, 0x1F3FF, 0x200D, 0x1F33E), 0, 4), emptyList<String>(), 47, 19, false),
      ),
    ),
    FacebookEmoji(
      String(intArrayOf(0x1F468, 0x200D, 0x1F33E), 0, 3), listOf("male-farmer"), 13, 47, false,
      variants = listOf(
        FacebookEmoji(String(intArrayOf(0x1F468, 0x1F3FB, 0x200D, 0x1F33E), 0, 4), emptyList<String>(), 13, 48, false),
        FacebookEmoji(String(intArrayOf(0x1F468, 0x1F3FC, 0x200D, 0x1F33E), 0, 4), emptyList<String>(), 13, 49, false),
        FacebookEmoji(String(intArrayOf(0x1F468, 0x1F3FD, 0x200D, 0x1F33E), 0, 4), emptyList<String>(), 13, 50, false),
        FacebookEmoji(String(intArrayOf(0x1F468, 0x1F3FE, 0x200D, 0x1F33E), 0, 4), emptyList<String>(), 13, 51, false),
        FacebookEmoji(String(intArrayOf(0x1F468, 0x1F3FF, 0x200D, 0x1F33E), 0, 4), emptyList<String>(), 13, 52, false),
      ),
    ),
    FacebookEmoji(
      String(intArrayOf(0x1F469, 0x200D, 0x1F33E), 0, 3), listOf("female-farmer"), 17, 20, false,
      variants = listOf(
        FacebookEmoji(String(intArrayOf(0x1F469, 0x1F3FB, 0x200D, 0x1F33E), 0, 4), emptyList<String>(), 17, 21, false),
        FacebookEmoji(String(intArrayOf(0x1F469, 0x1F3FC, 0x200D, 0x1F33E), 0, 4), emptyList<String>(), 17, 22, false),
        FacebookEmoji(String(intArrayOf(0x1F469, 0x1F3FD, 0x200D, 0x1F33E), 0, 4), emptyList<String>(), 17, 23, false),
        FacebookEmoji(String(intArrayOf(0x1F469, 0x1F3FE, 0x200D, 0x1F33E), 0, 4), emptyList<String>(), 17, 24, false),
        FacebookEmoji(String(intArrayOf(0x1F469, 0x1F3FF, 0x200D, 0x1F33E), 0, 4), emptyList<String>(), 17, 25, false),
      ),
    ),
    FacebookEmoji(
      String(intArrayOf(0x1F9D1, 0x200D, 0x1F373), 0, 3), listOf("cook"), 47, 20, false,
      variants = listOf(
        FacebookEmoji(String(intArrayOf(0x1F9D1, 0x1F3FB, 0x200D, 0x1F373), 0, 4), emptyList<String>(), 47, 21, false),
        FacebookEmoji(String(intArrayOf(0x1F9D1, 0x1F3FC, 0x200D, 0x1F373), 0, 4), emptyList<String>(), 47, 22, false),
        FacebookEmoji(String(intArrayOf(0x1F9D1, 0x1F3FD, 0x200D, 0x1F373), 0, 4), emptyList<String>(), 47, 23, false),
        FacebookEmoji(String(intArrayOf(0x1F9D1, 0x1F3FE, 0x200D, 0x1F373), 0, 4), emptyList<String>(), 47, 24, false),
        FacebookEmoji(String(intArrayOf(0x1F9D1, 0x1F3FF, 0x200D, 0x1F373), 0, 4), emptyList<String>(), 47, 25, false),
      ),
    ),
    FacebookEmoji(
      String(intArrayOf(0x1F468, 0x200D, 0x1F373), 0, 3), listOf("male-cook"), 13, 53, false,
      variants = listOf(
        FacebookEmoji(String(intArrayOf(0x1F468, 0x1F3FB, 0x200D, 0x1F373), 0, 4), emptyList<String>(), 13, 54, false),
        FacebookEmoji(String(intArrayOf(0x1F468, 0x1F3FC, 0x200D, 0x1F373), 0, 4), emptyList<String>(), 13, 55, false),
        FacebookEmoji(String(intArrayOf(0x1F468, 0x1F3FD, 0x200D, 0x1F373), 0, 4), emptyList<String>(), 13, 56, false),
        FacebookEmoji(String(intArrayOf(0x1F468, 0x1F3FE, 0x200D, 0x1F373), 0, 4), emptyList<String>(), 13, 57, false),
        FacebookEmoji(String(intArrayOf(0x1F468, 0x1F3FF, 0x200D, 0x1F373), 0, 4), emptyList<String>(), 13, 58, false),
      ),
    ),
    FacebookEmoji(
      String(intArrayOf(0x1F469, 0x200D, 0x1F373), 0, 3), listOf("female-cook"), 17, 26, false,
      variants = listOf(
        FacebookEmoji(String(intArrayOf(0x1F469, 0x1F3FB, 0x200D, 0x1F373), 0, 4), emptyList<String>(), 17, 27, false),
        FacebookEmoji(String(intArrayOf(0x1F469, 0x1F3FC, 0x200D, 0x1F373), 0, 4), emptyList<String>(), 17, 28, false),
        FacebookEmoji(String(intArrayOf(0x1F469, 0x1F3FD, 0x200D, 0x1F373), 0, 4), emptyList<String>(), 17, 29, false),
        FacebookEmoji(String(intArrayOf(0x1F469, 0x1F3FE, 0x200D, 0x1F373), 0, 4), emptyList<String>(), 17, 30, false),
        FacebookEmoji(String(intArrayOf(0x1F469, 0x1F3FF, 0x200D, 0x1F373), 0, 4), emptyList<String>(), 17, 31, false),
      ),
    ),
    FacebookEmoji(
      String(intArrayOf(0x1F9D1, 0x200D, 0x1F527), 0, 3), listOf("mechanic"), 48, 19, false,
      variants = listOf(
        FacebookEmoji(String(intArrayOf(0x1F9D1, 0x1F3FB, 0x200D, 0x1F527), 0, 4), emptyList<String>(), 48, 20, false),
        FacebookEmoji(String(intArrayOf(0x1F9D1, 0x1F3FC, 0x200D, 0x1F527), 0, 4), emptyList<String>(), 48, 21, false),
        FacebookEmoji(String(intArrayOf(0x1F9D1, 0x1F3FD, 0x200D, 0x1F527), 0, 4), emptyList<String>(), 48, 22, false),
        FacebookEmoji(String(intArrayOf(0x1F9D1, 0x1F3FE, 0x200D, 0x1F527), 0, 4), emptyList<String>(), 48, 23, false),
        FacebookEmoji(String(intArrayOf(0x1F9D1, 0x1F3FF, 0x200D, 0x1F527), 0, 4), emptyList<String>(), 48, 24, false),
      ),
    ),
    FacebookEmoji(
      String(intArrayOf(0x1F468, 0x200D, 0x1F527), 0, 3), listOf("male-mechanic"), 15, 0, false,
      variants = listOf(
        FacebookEmoji(String(intArrayOf(0x1F468, 0x1F3FB, 0x200D, 0x1F527), 0, 4), emptyList<String>(), 15, 1, false),
        FacebookEmoji(String(intArrayOf(0x1F468, 0x1F3FC, 0x200D, 0x1F527), 0, 4), emptyList<String>(), 15, 2, false),
        FacebookEmoji(String(intArrayOf(0x1F468, 0x1F3FD, 0x200D, 0x1F527), 0, 4), emptyList<String>(), 15, 3, false),
        FacebookEmoji(String(intArrayOf(0x1F468, 0x1F3FE, 0x200D, 0x1F527), 0, 4), emptyList<String>(), 15, 4, false),
        FacebookEmoji(String(intArrayOf(0x1F468, 0x1F3FF, 0x200D, 0x1F527), 0, 4), emptyList<String>(), 15, 5, false),
      ),
    ),
    FacebookEmoji(
      String(intArrayOf(0x1F469, 0x200D, 0x1F527), 0, 3), listOf("female-mechanic"), 18, 29, false,
      variants = listOf(
        FacebookEmoji(String(intArrayOf(0x1F469, 0x1F3FB, 0x200D, 0x1F527), 0, 4), emptyList<String>(), 18, 30, false),
        FacebookEmoji(String(intArrayOf(0x1F469, 0x1F3FC, 0x200D, 0x1F527), 0, 4), emptyList<String>(), 18, 31, false),
        FacebookEmoji(String(intArrayOf(0x1F469, 0x1F3FD, 0x200D, 0x1F527), 0, 4), emptyList<String>(), 18, 32, false),
        FacebookEmoji(String(intArrayOf(0x1F469, 0x1F3FE, 0x200D, 0x1F527), 0, 4), emptyList<String>(), 18, 33, false),
        FacebookEmoji(String(intArrayOf(0x1F469, 0x1F3FF, 0x200D, 0x1F527), 0, 4), emptyList<String>(), 18, 34, false),
      ),
    ),
    FacebookEmoji(
      String(intArrayOf(0x1F9D1, 0x200D, 0x1F3ED), 0, 3), listOf("factory_worker"), 48, 1, false,
      variants = listOf(
        FacebookEmoji(String(intArrayOf(0x1F9D1, 0x1F3FB, 0x200D, 0x1F3ED), 0, 4), emptyList<String>(), 48, 2, false),
        FacebookEmoji(String(intArrayOf(0x1F9D1, 0x1F3FC, 0x200D, 0x1F3ED), 0, 4), emptyList<String>(), 48, 3, false),
        FacebookEmoji(String(intArrayOf(0x1F9D1, 0x1F3FD, 0x200D, 0x1F3ED), 0, 4), emptyList<String>(), 48, 4, false),
        FacebookEmoji(String(intArrayOf(0x1F9D1, 0x1F3FE, 0x200D, 0x1F3ED), 0, 4), emptyList<String>(), 48, 5, false),
        FacebookEmoji(String(intArrayOf(0x1F9D1, 0x1F3FF, 0x200D, 0x1F3ED), 0, 4), emptyList<String>(), 48, 6, false),
      ),
    ),
    FacebookEmoji(
      String(intArrayOf(0x1F468, 0x200D, 0x1F3ED), 0, 3), listOf("male-factory-worker"), 14, 28, false,
      variants = listOf(
        FacebookEmoji(String(intArrayOf(0x1F468, 0x1F3FB, 0x200D, 0x1F3ED), 0, 4), emptyList<String>(), 14, 29, false),
        FacebookEmoji(String(intArrayOf(0x1F468, 0x1F3FC, 0x200D, 0x1F3ED), 0, 4), emptyList<String>(), 14, 30, false),
        FacebookEmoji(String(intArrayOf(0x1F468, 0x1F3FD, 0x200D, 0x1F3ED), 0, 4), emptyList<String>(), 14, 31, false),
        FacebookEmoji(String(intArrayOf(0x1F468, 0x1F3FE, 0x200D, 0x1F3ED), 0, 4), emptyList<String>(), 14, 32, false),
        FacebookEmoji(String(intArrayOf(0x1F468, 0x1F3FF, 0x200D, 0x1F3ED), 0, 4), emptyList<String>(), 14, 33, false),
      ),
    ),
    FacebookEmoji(
      String(intArrayOf(0x1F469, 0x200D, 0x1F3ED), 0, 3), listOf("female-factory-worker"), 18, 1, false,
      variants = listOf(
        FacebookEmoji(String(intArrayOf(0x1F469, 0x1F3FB, 0x200D, 0x1F3ED), 0, 4), emptyList<String>(), 18, 2, false),
        FacebookEmoji(String(intArrayOf(0x1F469, 0x1F3FC, 0x200D, 0x1F3ED), 0, 4), emptyList<String>(), 18, 3, false),
        FacebookEmoji(String(intArrayOf(0x1F469, 0x1F3FD, 0x200D, 0x1F3ED), 0, 4), emptyList<String>(), 18, 4, false),
        FacebookEmoji(String(intArrayOf(0x1F469, 0x1F3FE, 0x200D, 0x1F3ED), 0, 4), emptyList<String>(), 18, 5, false),
        FacebookEmoji(String(intArrayOf(0x1F469, 0x1F3FF, 0x200D, 0x1F3ED), 0, 4), emptyList<String>(), 18, 6, false),
      ),
    ),
    FacebookEmoji(
      String(intArrayOf(0x1F9D1, 0x200D, 0x1F4BC), 0, 3), listOf("office_worker"), 48, 13, false,
      variants = listOf(
        FacebookEmoji(String(intArrayOf(0x1F9D1, 0x1F3FB, 0x200D, 0x1F4BC), 0, 4), emptyList<String>(), 48, 14, false),
        FacebookEmoji(String(intArrayOf(0x1F9D1, 0x1F3FC, 0x200D, 0x1F4BC), 0, 4), emptyList<String>(), 48, 15, false),
        FacebookEmoji(String(intArrayOf(0x1F9D1, 0x1F3FD, 0x200D, 0x1F4BC), 0, 4), emptyList<String>(), 48, 16, false),
        FacebookEmoji(String(intArrayOf(0x1F9D1, 0x1F3FE, 0x200D, 0x1F4BC), 0, 4), emptyList<String>(), 48, 17, false),
        FacebookEmoji(String(intArrayOf(0x1F9D1, 0x1F3FF, 0x200D, 0x1F4BC), 0, 4), emptyList<String>(), 48, 18, false),
      ),
    ),
    FacebookEmoji(
      String(intArrayOf(0x1F468, 0x200D, 0x1F4BC), 0, 3), listOf("male-office-worker"), 14, 55, false,
      variants = listOf(
        FacebookEmoji(String(intArrayOf(0x1F468, 0x1F3FB, 0x200D, 0x1F4BC), 0, 4), emptyList<String>(), 14, 56, false),
        FacebookEmoji(String(intArrayOf(0x1F468, 0x1F3FC, 0x200D, 0x1F4BC), 0, 4), emptyList<String>(), 14, 57, false),
        FacebookEmoji(String(intArrayOf(0x1F468, 0x1F3FD, 0x200D, 0x1F4BC), 0, 4), emptyList<String>(), 14, 58, false),
        FacebookEmoji(String(intArrayOf(0x1F468, 0x1F3FE, 0x200D, 0x1F4BC), 0, 4), emptyList<String>(), 14, 59, false),
        FacebookEmoji(String(intArrayOf(0x1F468, 0x1F3FF, 0x200D, 0x1F4BC), 0, 4), emptyList<String>(), 14, 60, false),
      ),
    ),
    FacebookEmoji(
      String(intArrayOf(0x1F469, 0x200D, 0x1F4BC), 0, 3), listOf("female-office-worker"), 18, 23, false,
      variants = listOf(
        FacebookEmoji(String(intArrayOf(0x1F469, 0x1F3FB, 0x200D, 0x1F4BC), 0, 4), emptyList<String>(), 18, 24, false),
        FacebookEmoji(String(intArrayOf(0x1F469, 0x1F3FC, 0x200D, 0x1F4BC), 0, 4), emptyList<String>(), 18, 25, false),
        FacebookEmoji(String(intArrayOf(0x1F469, 0x1F3FD, 0x200D, 0x1F4BC), 0, 4), emptyList<String>(), 18, 26, false),
        FacebookEmoji(String(intArrayOf(0x1F469, 0x1F3FE, 0x200D, 0x1F4BC), 0, 4), emptyList<String>(), 18, 27, false),
        FacebookEmoji(String(intArrayOf(0x1F469, 0x1F3FF, 0x200D, 0x1F4BC), 0, 4), emptyList<String>(), 18, 28, false),
      ),
    ),
    FacebookEmoji(
      String(intArrayOf(0x1F9D1, 0x200D, 0x1F52C), 0, 3), listOf("scientist"), 48, 25, false,
      variants = listOf(
        FacebookEmoji(String(intArrayOf(0x1F9D1, 0x1F3FB, 0x200D, 0x1F52C), 0, 4), emptyList<String>(), 48, 26, false),
        FacebookEmoji(String(intArrayOf(0x1F9D1, 0x1F3FC, 0x200D, 0x1F52C), 0, 4), emptyList<String>(), 48, 27, false),
        FacebookEmoji(String(intArrayOf(0x1F9D1, 0x1F3FD, 0x200D, 0x1F52C), 0, 4), emptyList<String>(), 48, 28, false),
        FacebookEmoji(String(intArrayOf(0x1F9D1, 0x1F3FE, 0x200D, 0x1F52C), 0, 4), emptyList<String>(), 48, 29, false),
        FacebookEmoji(String(intArrayOf(0x1F9D1, 0x1F3FF, 0x200D, 0x1F52C), 0, 4), emptyList<String>(), 48, 30, false),
      ),
    ),
    FacebookEmoji(
      String(intArrayOf(0x1F468, 0x200D, 0x1F52C), 0, 3), listOf("male-scientist"), 15, 6, false,
      variants = listOf(
        FacebookEmoji(String(intArrayOf(0x1F468, 0x1F3FB, 0x200D, 0x1F52C), 0, 4), emptyList<String>(), 15, 7, false),
        FacebookEmoji(String(intArrayOf(0x1F468, 0x1F3FC, 0x200D, 0x1F52C), 0, 4), emptyList<String>(), 15, 8, false),
        FacebookEmoji(String(intArrayOf(0x1F468, 0x1F3FD, 0x200D, 0x1F52C), 0, 4), emptyList<String>(), 15, 9, false),
        FacebookEmoji(String(intArrayOf(0x1F468, 0x1F3FE, 0x200D, 0x1F52C), 0, 4), emptyList<String>(), 15, 10, false),
        FacebookEmoji(String(intArrayOf(0x1F468, 0x1F3FF, 0x200D, 0x1F52C), 0, 4), emptyList<String>(), 15, 11, false),
      ),
    ),
    FacebookEmoji(
      String(intArrayOf(0x1F469, 0x200D, 0x1F52C), 0, 3), listOf("female-scientist"), 18, 35, false,
      variants = listOf(
        FacebookEmoji(String(intArrayOf(0x1F469, 0x1F3FB, 0x200D, 0x1F52C), 0, 4), emptyList<String>(), 18, 36, false),
        FacebookEmoji(String(intArrayOf(0x1F469, 0x1F3FC, 0x200D, 0x1F52C), 0, 4), emptyList<String>(), 18, 37, false),
        FacebookEmoji(String(intArrayOf(0x1F469, 0x1F3FD, 0x200D, 0x1F52C), 0, 4), emptyList<String>(), 18, 38, false),
        FacebookEmoji(String(intArrayOf(0x1F469, 0x1F3FE, 0x200D, 0x1F52C), 0, 4), emptyList<String>(), 18, 39, false),
        FacebookEmoji(String(intArrayOf(0x1F469, 0x1F3FF, 0x200D, 0x1F52C), 0, 4), emptyList<String>(), 18, 40, false),
      ),
    ),
    FacebookEmoji(
      String(intArrayOf(0x1F9D1, 0x200D, 0x1F4BB), 0, 3), listOf("technologist"), 48, 7, false,
      variants = listOf(
        FacebookEmoji(String(intArrayOf(0x1F9D1, 0x1F3FB, 0x200D, 0x1F4BB), 0, 4), emptyList<String>(), 48, 8, false),
        FacebookEmoji(String(intArrayOf(0x1F9D1, 0x1F3FC, 0x200D, 0x1F4BB), 0, 4), emptyList<String>(), 48, 9, false),
        FacebookEmoji(String(intArrayOf(0x1F9D1, 0x1F3FD, 0x200D, 0x1F4BB), 0, 4), emptyList<String>(), 48, 10, false),
        FacebookEmoji(String(intArrayOf(0x1F9D1, 0x1F3FE, 0x200D, 0x1F4BB), 0, 4), emptyList<String>(), 48, 11, false),
        FacebookEmoji(String(intArrayOf(0x1F9D1, 0x1F3FF, 0x200D, 0x1F4BB), 0, 4), emptyList<String>(), 48, 12, false),
      ),
    ),
    FacebookEmoji(
      String(intArrayOf(0x1F468, 0x200D, 0x1F4BB), 0, 3), listOf("male-technologist"), 14, 49, false,
      variants = listOf(
        FacebookEmoji(String(intArrayOf(0x1F468, 0x1F3FB, 0x200D, 0x1F4BB), 0, 4), emptyList<String>(), 14, 50, false),
        FacebookEmoji(String(intArrayOf(0x1F468, 0x1F3FC, 0x200D, 0x1F4BB), 0, 4), emptyList<String>(), 14, 51, false),
        FacebookEmoji(String(intArrayOf(0x1F468, 0x1F3FD, 0x200D, 0x1F4BB), 0, 4), emptyList<String>(), 14, 52, false),
        FacebookEmoji(String(intArrayOf(0x1F468, 0x1F3FE, 0x200D, 0x1F4BB), 0, 4), emptyList<String>(), 14, 53, false),
        FacebookEmoji(String(intArrayOf(0x1F468, 0x1F3FF, 0x200D, 0x1F4BB), 0, 4), emptyList<String>(), 14, 54, false),
      ),
    ),
    FacebookEmoji(
      String(intArrayOf(0x1F469, 0x200D, 0x1F4BB), 0, 3), listOf("female-technologist"), 18, 17, false,
      variants = listOf(
        FacebookEmoji(String(intArrayOf(0x1F469, 0x1F3FB, 0x200D, 0x1F4BB), 0, 4), emptyList<String>(), 18, 18, false),
        FacebookEmoji(String(intArrayOf(0x1F469, 0x1F3FC, 0x200D, 0x1F4BB), 0, 4), emptyList<String>(), 18, 19, false),
        FacebookEmoji(String(intArrayOf(0x1F469, 0x1F3FD, 0x200D, 0x1F4BB), 0, 4), emptyList<String>(), 18, 20, false),
        FacebookEmoji(String(intArrayOf(0x1F469, 0x1F3FE, 0x200D, 0x1F4BB), 0, 4), emptyList<String>(), 18, 21, false),
        FacebookEmoji(String(intArrayOf(0x1F469, 0x1F3FF, 0x200D, 0x1F4BB), 0, 4), emptyList<String>(), 18, 22, false),
      ),
    ),
    FacebookEmoji(
      String(intArrayOf(0x1F9D1, 0x200D, 0x1F3A4), 0, 3), listOf("singer"), 47, 44, false,
      variants = listOf(
        FacebookEmoji(String(intArrayOf(0x1F9D1, 0x1F3FB, 0x200D, 0x1F3A4), 0, 4), emptyList<String>(), 47, 45, false),
        FacebookEmoji(String(intArrayOf(0x1F9D1, 0x1F3FC, 0x200D, 0x1F3A4), 0, 4), emptyList<String>(), 47, 46, false),
        FacebookEmoji(String(intArrayOf(0x1F9D1, 0x1F3FD, 0x200D, 0x1F3A4), 0, 4), emptyList<String>(), 47, 47, false),
        FacebookEmoji(String(intArrayOf(0x1F9D1, 0x1F3FE, 0x200D, 0x1F3A4), 0, 4), emptyList<String>(), 47, 48, false),
        FacebookEmoji(String(intArrayOf(0x1F9D1, 0x1F3FF, 0x200D, 0x1F3A4), 0, 4), emptyList<String>(), 47, 49, false),
      ),
    ),
    FacebookEmoji(
      String(intArrayOf(0x1F468, 0x200D, 0x1F3A4), 0, 3), listOf("male-singer"), 14, 10, false,
      variants = listOf(
        FacebookEmoji(String(intArrayOf(0x1F468, 0x1F3FB, 0x200D, 0x1F3A4), 0, 4), emptyList<String>(), 14, 11, false),
        FacebookEmoji(String(intArrayOf(0x1F468, 0x1F3FC, 0x200D, 0x1F3A4), 0, 4), emptyList<String>(), 14, 12, false),
        FacebookEmoji(String(intArrayOf(0x1F468, 0x1F3FD, 0x200D, 0x1F3A4), 0, 4), emptyList<String>(), 14, 13, false),
        FacebookEmoji(String(intArrayOf(0x1F468, 0x1F3FE, 0x200D, 0x1F3A4), 0, 4), emptyList<String>(), 14, 14, false),
        FacebookEmoji(String(intArrayOf(0x1F468, 0x1F3FF, 0x200D, 0x1F3A4), 0, 4), emptyList<String>(), 14, 15, false),
      ),
    ),
    FacebookEmoji(
      String(intArrayOf(0x1F469, 0x200D, 0x1F3A4), 0, 3), listOf("female-singer"), 17, 44, false,
      variants = listOf(
        FacebookEmoji(String(intArrayOf(0x1F469, 0x1F3FB, 0x200D, 0x1F3A4), 0, 4), emptyList<String>(), 17, 45, false),
        FacebookEmoji(String(intArrayOf(0x1F469, 0x1F3FC, 0x200D, 0x1F3A4), 0, 4), emptyList<String>(), 17, 46, false),
        FacebookEmoji(String(intArrayOf(0x1F469, 0x1F3FD, 0x200D, 0x1F3A4), 0, 4), emptyList<String>(), 17, 47, false),
        FacebookEmoji(String(intArrayOf(0x1F469, 0x1F3FE, 0x200D, 0x1F3A4), 0, 4), emptyList<String>(), 17, 48, false),
        FacebookEmoji(String(intArrayOf(0x1F469, 0x1F3FF, 0x200D, 0x1F3A4), 0, 4), emptyList<String>(), 17, 49, false),
      ),
    ),
    FacebookEmoji(
      String(intArrayOf(0x1F9D1, 0x200D, 0x1F3A8), 0, 3), listOf("artist"), 47, 50, false,
      variants = listOf(
        FacebookEmoji(String(intArrayOf(0x1F9D1, 0x1F3FB, 0x200D, 0x1F3A8), 0, 4), emptyList<String>(), 47, 51, false),
        FacebookEmoji(String(intArrayOf(0x1F9D1, 0x1F3FC, 0x200D, 0x1F3A8), 0, 4), emptyList<String>(), 47, 52, false),
        FacebookEmoji(String(intArrayOf(0x1F9D1, 0x1F3FD, 0x200D, 0x1F3A8), 0, 4), emptyList<String>(), 47, 53, false),
        FacebookEmoji(String(intArrayOf(0x1F9D1, 0x1F3FE, 0x200D, 0x1F3A8), 0, 4), emptyList<String>(), 47, 54, false),
        FacebookEmoji(String(intArrayOf(0x1F9D1, 0x1F3FF, 0x200D, 0x1F3A8), 0, 4), emptyList<String>(), 47, 55, false),
      ),
    ),
    FacebookEmoji(
      String(intArrayOf(0x1F468, 0x200D, 0x1F3A8), 0, 3), listOf("male-artist"), 14, 16, false,
      variants = listOf(
        FacebookEmoji(String(intArrayOf(0x1F468, 0x1F3FB, 0x200D, 0x1F3A8), 0, 4), emptyList<String>(), 14, 17, false),
        FacebookEmoji(String(intArrayOf(0x1F468, 0x1F3FC, 0x200D, 0x1F3A8), 0, 4), emptyList<String>(), 14, 18, false),
        FacebookEmoji(String(intArrayOf(0x1F468, 0x1F3FD, 0x200D, 0x1F3A8), 0, 4), emptyList<String>(), 14, 19, false),
        FacebookEmoji(String(intArrayOf(0x1F468, 0x1F3FE, 0x200D, 0x1F3A8), 0, 4), emptyList<String>(), 14, 20, false),
        FacebookEmoji(String(intArrayOf(0x1F468, 0x1F3FF, 0x200D, 0x1F3A8), 0, 4), emptyList<String>(), 14, 21, false),
      ),
    ),
    FacebookEmoji(
      String(intArrayOf(0x1F469, 0x200D, 0x1F3A8), 0, 3), listOf("female-artist"), 17, 50, false,
      variants = listOf(
        FacebookEmoji(String(intArrayOf(0x1F469, 0x1F3FB, 0x200D, 0x1F3A8), 0, 4), emptyList<String>(), 17, 51, false),
        FacebookEmoji(String(intArrayOf(0x1F469, 0x1F3FC, 0x200D, 0x1F3A8), 0, 4), emptyList<String>(), 17, 52, false),
        FacebookEmoji(String(intArrayOf(0x1F469, 0x1F3FD, 0x200D, 0x1F3A8), 0, 4), emptyList<String>(), 17, 53, false),
        FacebookEmoji(String(intArrayOf(0x1F469, 0x1F3FE, 0x200D, 0x1F3A8), 0, 4), emptyList<String>(), 17, 54, false),
        FacebookEmoji(String(intArrayOf(0x1F469, 0x1F3FF, 0x200D, 0x1F3A8), 0, 4), emptyList<String>(), 17, 55, false),
      ),
    ),
    FacebookEmoji(
      String(intArrayOf(0x1F9D1, 0x200D, 0x2708, 0xFE0F), 0, 4), listOf("pilot"), 50, 1, false,
      variants = listOf(
        FacebookEmoji(String(intArrayOf(0x1F9D1, 0x1F3FB, 0x200D, 0x2708, 0xFE0F), 0, 5), emptyList<String>(), 50, 2, false),
        FacebookEmoji(String(intArrayOf(0x1F9D1, 0x1F3FC, 0x200D, 0x2708, 0xFE0F), 0, 5), emptyList<String>(), 50, 3, false),
        FacebookEmoji(String(intArrayOf(0x1F9D1, 0x1F3FD, 0x200D, 0x2708, 0xFE0F), 0, 5), emptyList<String>(), 50, 4, false),
        FacebookEmoji(String(intArrayOf(0x1F9D1, 0x1F3FE, 0x200D, 0x2708, 0xFE0F), 0, 5), emptyList<String>(), 50, 5, false),
        FacebookEmoji(String(intArrayOf(0x1F9D1, 0x1F3FF, 0x200D, 0x2708, 0xFE0F), 0, 5), emptyList<String>(), 50, 6, false),
      ),
    ),
    FacebookEmoji(
      String(intArrayOf(0x1F468, 0x200D, 0x2708, 0xFE0F), 0, 4), listOf("male-pilot"), 16, 17, false,
      variants = listOf(
        FacebookEmoji(String(intArrayOf(0x1F468, 0x1F3FB, 0x200D, 0x2708, 0xFE0F), 0, 5), emptyList<String>(), 16, 18, false),
        FacebookEmoji(String(intArrayOf(0x1F468, 0x1F3FC, 0x200D, 0x2708, 0xFE0F), 0, 5), emptyList<String>(), 16, 19, false),
        FacebookEmoji(String(intArrayOf(0x1F468, 0x1F3FD, 0x200D, 0x2708, 0xFE0F), 0, 5), emptyList<String>(), 16, 20, false),
        FacebookEmoji(String(intArrayOf(0x1F468, 0x1F3FE, 0x200D, 0x2708, 0xFE0F), 0, 5), emptyList<String>(), 16, 21, false),
        FacebookEmoji(String(intArrayOf(0x1F468, 0x1F3FF, 0x200D, 0x2708, 0xFE0F), 0, 5), emptyList<String>(), 16, 22, false),
      ),
    ),
    FacebookEmoji(
      String(intArrayOf(0x1F469, 0x200D, 0x2708, 0xFE0F), 0, 4), listOf("female-pilot"), 19, 46, false,
      variants = listOf(
        FacebookEmoji(String(intArrayOf(0x1F469, 0x1F3FB, 0x200D, 0x2708, 0xFE0F), 0, 5), emptyList<String>(), 19, 47, false),
        FacebookEmoji(String(intArrayOf(0x1F469, 0x1F3FC, 0x200D, 0x2708, 0xFE0F), 0, 5), emptyList<String>(), 19, 48, false),
        FacebookEmoji(String(intArrayOf(0x1F469, 0x1F3FD, 0x200D, 0x2708, 0xFE0F), 0, 5), emptyList<String>(), 19, 49, false),
        FacebookEmoji(String(intArrayOf(0x1F469, 0x1F3FE, 0x200D, 0x2708, 0xFE0F), 0, 5), emptyList<String>(), 19, 50, false),
        FacebookEmoji(String(intArrayOf(0x1F469, 0x1F3FF, 0x200D, 0x2708, 0xFE0F), 0, 5), emptyList<String>(), 19, 51, false),
      ),
    ),
    FacebookEmoji(
      String(intArrayOf(0x1F9D1, 0x200D, 0x1F680), 0, 3), listOf("astronaut"), 48, 31, false,
      variants = listOf(
        FacebookEmoji(String(intArrayOf(0x1F9D1, 0x1F3FB, 0x200D, 0x1F680), 0, 4), emptyList<String>(), 48, 32, false),
        FacebookEmoji(String(intArrayOf(0x1F9D1, 0x1F3FC, 0x200D, 0x1F680), 0, 4), emptyList<String>(), 48, 33, false),
        FacebookEmoji(String(intArrayOf(0x1F9D1, 0x1F3FD, 0x200D, 0x1F680), 0, 4), emptyList<String>(), 48, 34, false),
        FacebookEmoji(String(intArrayOf(0x1F9D1, 0x1F3FE, 0x200D, 0x1F680), 0, 4), emptyList<String>(), 48, 35, false),
        FacebookEmoji(String(intArrayOf(0x1F9D1, 0x1F3FF, 0x200D, 0x1F680), 0, 4), emptyList<String>(), 48, 36, false),
      ),
    ),
    FacebookEmoji(
      String(intArrayOf(0x1F468, 0x200D, 0x1F680), 0, 3), listOf("male-astronaut"), 15, 12, false,
      variants = listOf(
        FacebookEmoji(String(intArrayOf(0x1F468, 0x1F3FB, 0x200D, 0x1F680), 0, 4), emptyList<String>(), 15, 13, false),
        FacebookEmoji(String(intArrayOf(0x1F468, 0x1F3FC, 0x200D, 0x1F680), 0, 4), emptyList<String>(), 15, 14, false),
        FacebookEmoji(String(intArrayOf(0x1F468, 0x1F3FD, 0x200D, 0x1F680), 0, 4), emptyList<String>(), 15, 15, false),
        FacebookEmoji(String(intArrayOf(0x1F468, 0x1F3FE, 0x200D, 0x1F680), 0, 4), emptyList<String>(), 15, 16, false),
        FacebookEmoji(String(intArrayOf(0x1F468, 0x1F3FF, 0x200D, 0x1F680), 0, 4), emptyList<String>(), 15, 17, false),
      ),
    ),
    FacebookEmoji(
      String(intArrayOf(0x1F469, 0x200D, 0x1F680), 0, 3), listOf("female-astronaut"), 18, 41, false,
      variants = listOf(
        FacebookEmoji(String(intArrayOf(0x1F469, 0x1F3FB, 0x200D, 0x1F680), 0, 4), emptyList<String>(), 18, 42, false),
        FacebookEmoji(String(intArrayOf(0x1F469, 0x1F3FC, 0x200D, 0x1F680), 0, 4), emptyList<String>(), 18, 43, false),
        FacebookEmoji(String(intArrayOf(0x1F469, 0x1F3FD, 0x200D, 0x1F680), 0, 4), emptyList<String>(), 18, 44, false),
        FacebookEmoji(String(intArrayOf(0x1F469, 0x1F3FE, 0x200D, 0x1F680), 0, 4), emptyList<String>(), 18, 45, false),
        FacebookEmoji(String(intArrayOf(0x1F469, 0x1F3FF, 0x200D, 0x1F680), 0, 4), emptyList<String>(), 18, 46, false),
      ),
    ),
    FacebookEmoji(
      String(intArrayOf(0x1F9D1, 0x200D, 0x1F692), 0, 3), listOf("firefighter"), 48, 37, false,
      variants = listOf(
        FacebookEmoji(String(intArrayOf(0x1F9D1, 0x1F3FB, 0x200D, 0x1F692), 0, 4), emptyList<String>(), 48, 38, false),
        FacebookEmoji(String(intArrayOf(0x1F9D1, 0x1F3FC, 0x200D, 0x1F692), 0, 4), emptyList<String>(), 48, 39, false),
        FacebookEmoji(String(intArrayOf(0x1F9D1, 0x1F3FD, 0x200D, 0x1F692), 0, 4), emptyList<String>(), 48, 40, false),
        FacebookEmoji(String(intArrayOf(0x1F9D1, 0x1F3FE, 0x200D, 0x1F692), 0, 4), emptyList<String>(), 48, 41, false),
        FacebookEmoji(String(intArrayOf(0x1F9D1, 0x1F3FF, 0x200D, 0x1F692), 0, 4), emptyList<String>(), 48, 42, false),
      ),
    ),
    FacebookEmoji(
      String(intArrayOf(0x1F468, 0x200D, 0x1F692), 0, 3), listOf("male-firefighter"), 15, 18, false,
      variants = listOf(
        FacebookEmoji(String(intArrayOf(0x1F468, 0x1F3FB, 0x200D, 0x1F692), 0, 4), emptyList<String>(), 15, 19, false),
        FacebookEmoji(String(intArrayOf(0x1F468, 0x1F3FC, 0x200D, 0x1F692), 0, 4), emptyList<String>(), 15, 20, false),
        FacebookEmoji(String(intArrayOf(0x1F468, 0x1F3FD, 0x200D, 0x1F692), 0, 4), emptyList<String>(), 15, 21, false),
        FacebookEmoji(String(intArrayOf(0x1F468, 0x1F3FE, 0x200D, 0x1F692), 0, 4), emptyList<String>(), 15, 22, false),
        FacebookEmoji(String(intArrayOf(0x1F468, 0x1F3FF, 0x200D, 0x1F692), 0, 4), emptyList<String>(), 15, 23, false),
      ),
    ),
    FacebookEmoji(
      String(intArrayOf(0x1F469, 0x200D, 0x1F692), 0, 3), listOf("female-firefighter"), 18, 47, false,
      variants = listOf(
        FacebookEmoji(String(intArrayOf(0x1F469, 0x1F3FB, 0x200D, 0x1F692), 0, 4), emptyList<String>(), 18, 48, false),
        FacebookEmoji(String(intArrayOf(0x1F469, 0x1F3FC, 0x200D, 0x1F692), 0, 4), emptyList<String>(), 18, 49, false),
        FacebookEmoji(String(intArrayOf(0x1F469, 0x1F3FD, 0x200D, 0x1F692), 0, 4), emptyList<String>(), 18, 50, false),
        FacebookEmoji(String(intArrayOf(0x1F469, 0x1F3FE, 0x200D, 0x1F692), 0, 4), emptyList<String>(), 18, 51, false),
        FacebookEmoji(String(intArrayOf(0x1F469, 0x1F3FF, 0x200D, 0x1F692), 0, 4), emptyList<String>(), 18, 52, false),
      ),
    ),
    FacebookEmoji(
      String(intArrayOf(0x1F46E), 0, 1), listOf("cop"), 23, 9, true,
      variants = listOf(
        FacebookEmoji(String(intArrayOf(0x1F46E, 0x1F3FB), 0, 2), emptyList<String>(), 23, 10, false),
        FacebookEmoji(String(intArrayOf(0x1F46E, 0x1F3FC), 0, 2), emptyList<String>(), 23, 11, false),
        FacebookEmoji(String(intArrayOf(0x1F46E, 0x1F3FD), 0, 2), emptyList<String>(), 23, 12, false),
        FacebookEmoji(String(intArrayOf(0x1F46E, 0x1F3FE), 0, 2), emptyList<String>(), 23, 13, false),
        FacebookEmoji(String(intArrayOf(0x1F46E, 0x1F3FF), 0, 2), emptyList<String>(), 23, 14, false),
      ),
    ),
    FacebookEmoji(
      String(intArrayOf(0x1F46E, 0x200D, 0x2642, 0xFE0F), 0, 4), listOf("male-police-officer"), 23, 3, false,
      variants = listOf(
        FacebookEmoji(String(intArrayOf(0x1F46E, 0x1F3FB, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 23, 4, false),
        FacebookEmoji(String(intArrayOf(0x1F46E, 0x1F3FC, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 23, 5, false),
        FacebookEmoji(String(intArrayOf(0x1F46E, 0x1F3FD, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 23, 6, false),
        FacebookEmoji(String(intArrayOf(0x1F46E, 0x1F3FE, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 23, 7, false),
        FacebookEmoji(String(intArrayOf(0x1F46E, 0x1F3FF, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 23, 8, false),
      ),
    ),
    FacebookEmoji(
      String(intArrayOf(0x1F46E, 0x200D, 0x2640, 0xFE0F), 0, 4), listOf("female-police-officer"), 22, 58, false,
      variants = listOf(
        FacebookEmoji(String(intArrayOf(0x1F46E, 0x1F3FB, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 22, 59, false),
        FacebookEmoji(String(intArrayOf(0x1F46E, 0x1F3FC, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 22, 60, false),
        FacebookEmoji(String(intArrayOf(0x1F46E, 0x1F3FD, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 23, 0, false),
        FacebookEmoji(String(intArrayOf(0x1F46E, 0x1F3FE, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 23, 1, false),
        FacebookEmoji(String(intArrayOf(0x1F46E, 0x1F3FF, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 23, 2, false),
      ),
    ),
    FacebookEmoji(
      String(intArrayOf(0x1F575, 0xFE0F), 0, 2), listOf("sleuth_or_spy"), 31, 17, true,
      variants = listOf(
        FacebookEmoji(String(intArrayOf(0x1F575, 0x1F3FB), 0, 2), emptyList<String>(), 31, 18, false),
        FacebookEmoji(String(intArrayOf(0x1F575, 0x1F3FC), 0, 2), emptyList<String>(), 31, 19, false),
        FacebookEmoji(String(intArrayOf(0x1F575, 0x1F3FD), 0, 2), emptyList<String>(), 31, 20, false),
        FacebookEmoji(String(intArrayOf(0x1F575, 0x1F3FE), 0, 2), emptyList<String>(), 31, 21, false),
        FacebookEmoji(String(intArrayOf(0x1F575, 0x1F3FF), 0, 2), emptyList<String>(), 31, 22, false),
      ),
    ),
    FacebookEmoji(
      String(intArrayOf(0x1F482), 0, 1), listOf("guardsman"), 25, 41, true,
      variants = listOf(
        FacebookEmoji(String(intArrayOf(0x1F482, 0x1F3FB), 0, 2), emptyList<String>(), 25, 42, false),
        FacebookEmoji(String(intArrayOf(0x1F482, 0x1F3FC), 0, 2), emptyList<String>(), 25, 43, false),
        FacebookEmoji(String(intArrayOf(0x1F482, 0x1F3FD), 0, 2), emptyList<String>(), 25, 44, false),
        FacebookEmoji(String(intArrayOf(0x1F482, 0x1F3FE), 0, 2), emptyList<String>(), 25, 45, false),
        FacebookEmoji(String(intArrayOf(0x1F482, 0x1F3FF), 0, 2), emptyList<String>(), 25, 46, false),
      ),
    ),
    FacebookEmoji(
      String(intArrayOf(0x1F482, 0x200D, 0x2642, 0xFE0F), 0, 4), listOf("male-guard"), 25, 35, false,
      variants = listOf(
        FacebookEmoji(String(intArrayOf(0x1F482, 0x1F3FB, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 25, 36, false),
        FacebookEmoji(String(intArrayOf(0x1F482, 0x1F3FC, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 25, 37, false),
        FacebookEmoji(String(intArrayOf(0x1F482, 0x1F3FD, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 25, 38, false),
        FacebookEmoji(String(intArrayOf(0x1F482, 0x1F3FE, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 25, 39, false),
        FacebookEmoji(String(intArrayOf(0x1F482, 0x1F3FF, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 25, 40, false),
      ),
    ),
    FacebookEmoji(
      String(intArrayOf(0x1F482, 0x200D, 0x2640, 0xFE0F), 0, 4), listOf("female-guard"), 25, 29, false,
      variants = listOf(
        FacebookEmoji(String(intArrayOf(0x1F482, 0x1F3FB, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 25, 30, false),
        FacebookEmoji(String(intArrayOf(0x1F482, 0x1F3FC, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 25, 31, false),
        FacebookEmoji(String(intArrayOf(0x1F482, 0x1F3FD, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 25, 32, false),
        FacebookEmoji(String(intArrayOf(0x1F482, 0x1F3FE, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 25, 33, false),
        FacebookEmoji(String(intArrayOf(0x1F482, 0x1F3FF, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 25, 34, false),
      ),
    ),
    FacebookEmoji(
      String(intArrayOf(0x1F977), 0, 1), listOf("ninja"), 44, 6, false,
      variants = listOf(
        FacebookEmoji(String(intArrayOf(0x1F977, 0x1F3FB), 0, 2), emptyList<String>(), 44, 7, false),
        FacebookEmoji(String(intArrayOf(0x1F977, 0x1F3FC), 0, 2), emptyList<String>(), 44, 8, false),
        FacebookEmoji(String(intArrayOf(0x1F977, 0x1F3FD), 0, 2), emptyList<String>(), 44, 9, false),
        FacebookEmoji(String(intArrayOf(0x1F977, 0x1F3FE), 0, 2), emptyList<String>(), 44, 10, false),
        FacebookEmoji(String(intArrayOf(0x1F977, 0x1F3FF), 0, 2), emptyList<String>(), 44, 11, false),
      ),
    ),
    FacebookEmoji(
      String(intArrayOf(0x1F477), 0, 1), listOf("construction_worker"), 24, 47, true,
      variants = listOf(
        FacebookEmoji(String(intArrayOf(0x1F477, 0x1F3FB), 0, 2), emptyList<String>(), 24, 48, false),
        FacebookEmoji(String(intArrayOf(0x1F477, 0x1F3FC), 0, 2), emptyList<String>(), 24, 49, false),
        FacebookEmoji(String(intArrayOf(0x1F477, 0x1F3FD), 0, 2), emptyList<String>(), 24, 50, false),
        FacebookEmoji(String(intArrayOf(0x1F477, 0x1F3FE), 0, 2), emptyList<String>(), 24, 51, false),
        FacebookEmoji(String(intArrayOf(0x1F477, 0x1F3FF), 0, 2), emptyList<String>(), 24, 52, false),
      ),
    ),
    FacebookEmoji(
      String(intArrayOf(0x1F477, 0x200D, 0x2642, 0xFE0F), 0, 4), listOf("male-construction-worker"), 24, 41, false,
      variants = listOf(
        FacebookEmoji(String(intArrayOf(0x1F477, 0x1F3FB, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 24, 42, false),
        FacebookEmoji(String(intArrayOf(0x1F477, 0x1F3FC, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 24, 43, false),
        FacebookEmoji(String(intArrayOf(0x1F477, 0x1F3FD, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 24, 44, false),
        FacebookEmoji(String(intArrayOf(0x1F477, 0x1F3FE, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 24, 45, false),
        FacebookEmoji(String(intArrayOf(0x1F477, 0x1F3FF, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 24, 46, false),
      ),
    ),
    FacebookEmoji(
      String(intArrayOf(0x1F477, 0x200D, 0x2640, 0xFE0F), 0, 4), listOf("female-construction-worker"), 24, 35, false,
      variants = listOf(
        FacebookEmoji(String(intArrayOf(0x1F477, 0x1F3FB, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 24, 36, false),
        FacebookEmoji(String(intArrayOf(0x1F477, 0x1F3FC, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 24, 37, false),
        FacebookEmoji(String(intArrayOf(0x1F477, 0x1F3FD, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 24, 38, false),
        FacebookEmoji(String(intArrayOf(0x1F477, 0x1F3FE, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 24, 39, false),
        FacebookEmoji(String(intArrayOf(0x1F477, 0x1F3FF, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 24, 40, false),
      ),
    ),
    FacebookEmoji(
      String(intArrayOf(0x1FAC5), 0, 1), listOf("person_with_crown"), 55, 10, false,
      variants = listOf(
        FacebookEmoji(String(intArrayOf(0x1FAC5, 0x1F3FB), 0, 2), emptyList<String>(), 55, 11, false),
        FacebookEmoji(String(intArrayOf(0x1FAC5, 0x1F3FC), 0, 2), emptyList<String>(), 55, 12, false),
        FacebookEmoji(String(intArrayOf(0x1FAC5, 0x1F3FD), 0, 2), emptyList<String>(), 55, 13, false),
        FacebookEmoji(String(intArrayOf(0x1FAC5, 0x1F3FE), 0, 2), emptyList<String>(), 55, 14, false),
        FacebookEmoji(String(intArrayOf(0x1FAC5, 0x1F3FF), 0, 2), emptyList<String>(), 55, 15, false),
      ),
    ),
    FacebookEmoji(
      String(intArrayOf(0x1F934), 0, 1), listOf("prince"), 41, 10, false,
      variants = listOf(
        FacebookEmoji(String(intArrayOf(0x1F934, 0x1F3FB), 0, 2), emptyList<String>(), 41, 11, false),
        FacebookEmoji(String(intArrayOf(0x1F934, 0x1F3FC), 0, 2), emptyList<String>(), 41, 12, false),
        FacebookEmoji(String(intArrayOf(0x1F934, 0x1F3FD), 0, 2), emptyList<String>(), 41, 13, false),
        FacebookEmoji(String(intArrayOf(0x1F934, 0x1F3FE), 0, 2), emptyList<String>(), 41, 14, false),
        FacebookEmoji(String(intArrayOf(0x1F934, 0x1F3FF), 0, 2), emptyList<String>(), 41, 15, false),
      ),
    ),
    FacebookEmoji(
      String(intArrayOf(0x1F478), 0, 1), listOf("princess"), 24, 53, false,
      variants = listOf(
        FacebookEmoji(String(intArrayOf(0x1F478, 0x1F3FB), 0, 2), emptyList<String>(), 24, 54, false),
        FacebookEmoji(String(intArrayOf(0x1F478, 0x1F3FC), 0, 2), emptyList<String>(), 24, 55, false),
        FacebookEmoji(String(intArrayOf(0x1F478, 0x1F3FD), 0, 2), emptyList<String>(), 24, 56, false),
        FacebookEmoji(String(intArrayOf(0x1F478, 0x1F3FE), 0, 2), emptyList<String>(), 24, 57, false),
        FacebookEmoji(String(intArrayOf(0x1F478, 0x1F3FF), 0, 2), emptyList<String>(), 24, 58, false),
      ),
    ),
    FacebookEmoji(
      String(intArrayOf(0x1F473), 0, 1), listOf("man_with_turban"), 24, 11, true,
      variants = listOf(
        FacebookEmoji(String(intArrayOf(0x1F473, 0x1F3FB), 0, 2), emptyList<String>(), 24, 12, false),
        FacebookEmoji(String(intArrayOf(0x1F473, 0x1F3FC), 0, 2), emptyList<String>(), 24, 13, false),
        FacebookEmoji(String(intArrayOf(0x1F473, 0x1F3FD), 0, 2), emptyList<String>(), 24, 14, false),
        FacebookEmoji(String(intArrayOf(0x1F473, 0x1F3FE), 0, 2), emptyList<String>(), 24, 15, false),
        FacebookEmoji(String(intArrayOf(0x1F473, 0x1F3FF), 0, 2), emptyList<String>(), 24, 16, false),
      ),
    ),
    FacebookEmoji(
      String(intArrayOf(0x1F473, 0x200D, 0x2642, 0xFE0F), 0, 4), listOf("man-wearing-turban"), 24, 5, false,
      variants = listOf(
        FacebookEmoji(String(intArrayOf(0x1F473, 0x1F3FB, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 24, 6, false),
        FacebookEmoji(String(intArrayOf(0x1F473, 0x1F3FC, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 24, 7, false),
        FacebookEmoji(String(intArrayOf(0x1F473, 0x1F3FD, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 24, 8, false),
        FacebookEmoji(String(intArrayOf(0x1F473, 0x1F3FE, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 24, 9, false),
        FacebookEmoji(String(intArrayOf(0x1F473, 0x1F3FF, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 24, 10, false),
      ),
    ),
    FacebookEmoji(
      String(intArrayOf(0x1F473, 0x200D, 0x2640, 0xFE0F), 0, 4), listOf("woman-wearing-turban"), 23, 60, false,
      variants = listOf(
        FacebookEmoji(String(intArrayOf(0x1F473, 0x1F3FB, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 24, 0, false),
        FacebookEmoji(String(intArrayOf(0x1F473, 0x1F3FC, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 24, 1, false),
        FacebookEmoji(String(intArrayOf(0x1F473, 0x1F3FD, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 24, 2, false),
        FacebookEmoji(String(intArrayOf(0x1F473, 0x1F3FE, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 24, 3, false),
        FacebookEmoji(String(intArrayOf(0x1F473, 0x1F3FF, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 24, 4, false),
      ),
    ),
    FacebookEmoji(
      String(intArrayOf(0x1F472), 0, 1), listOf("man_with_gua_pi_mao"), 23, 54, false,
      variants = listOf(
        FacebookEmoji(String(intArrayOf(0x1F472, 0x1F3FB), 0, 2), emptyList<String>(), 23, 55, false),
        FacebookEmoji(String(intArrayOf(0x1F472, 0x1F3FC), 0, 2), emptyList<String>(), 23, 56, false),
        FacebookEmoji(String(intArrayOf(0x1F472, 0x1F3FD), 0, 2), emptyList<String>(), 23, 57, false),
        FacebookEmoji(String(intArrayOf(0x1F472, 0x1F3FE), 0, 2), emptyList<String>(), 23, 58, false),
        FacebookEmoji(String(intArrayOf(0x1F472, 0x1F3FF), 0, 2), emptyList<String>(), 23, 59, false),
      ),
    ),
    FacebookEmoji(
      String(intArrayOf(0x1F9D5), 0, 1), listOf("person_with_headscarf"), 50, 43, false,
      variants = listOf(
        FacebookEmoji(String(intArrayOf(0x1F9D5, 0x1F3FB), 0, 2), emptyList<String>(), 50, 44, false),
        FacebookEmoji(String(intArrayOf(0x1F9D5, 0x1F3FC), 0, 2), emptyList<String>(), 50, 45, false),
        FacebookEmoji(String(intArrayOf(0x1F9D5, 0x1F3FD), 0, 2), emptyList<String>(), 50, 46, false),
        FacebookEmoji(String(intArrayOf(0x1F9D5, 0x1F3FE), 0, 2), emptyList<String>(), 50, 47, false),
        FacebookEmoji(String(intArrayOf(0x1F9D5, 0x1F3FF), 0, 2), emptyList<String>(), 50, 48, false),
      ),
    ),
    FacebookEmoji(
      String(intArrayOf(0x1F935), 0, 1), listOf("person_in_tuxedo"), 41, 28, false,
      variants = listOf(
        FacebookEmoji(String(intArrayOf(0x1F935, 0x1F3FB), 0, 2), emptyList<String>(), 41, 29, false),
        FacebookEmoji(String(intArrayOf(0x1F935, 0x1F3FC), 0, 2), emptyList<String>(), 41, 30, false),
        FacebookEmoji(String(intArrayOf(0x1F935, 0x1F3FD), 0, 2), emptyList<String>(), 41, 31, false),
        FacebookEmoji(String(intArrayOf(0x1F935, 0x1F3FE), 0, 2), emptyList<String>(), 41, 32, false),
        FacebookEmoji(String(intArrayOf(0x1F935, 0x1F3FF), 0, 2), emptyList<String>(), 41, 33, false),
      ),
    ),
    FacebookEmoji(
      String(intArrayOf(0x1F935, 0x200D, 0x2642, 0xFE0F), 0, 4), listOf("man_in_tuxedo"), 41, 22, false,
      variants = listOf(
        FacebookEmoji(String(intArrayOf(0x1F935, 0x1F3FB, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 41, 23, false),
        FacebookEmoji(String(intArrayOf(0x1F935, 0x1F3FC, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 41, 24, false),
        FacebookEmoji(String(intArrayOf(0x1F935, 0x1F3FD, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 41, 25, false),
        FacebookEmoji(String(intArrayOf(0x1F935, 0x1F3FE, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 41, 26, false),
        FacebookEmoji(String(intArrayOf(0x1F935, 0x1F3FF, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 41, 27, false),
      ),
    ),
    FacebookEmoji(
      String(intArrayOf(0x1F935, 0x200D, 0x2640, 0xFE0F), 0, 4), listOf("woman_in_tuxedo"), 41, 16, false,
      variants = listOf(
        FacebookEmoji(String(intArrayOf(0x1F935, 0x1F3FB, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 41, 17, false),
        FacebookEmoji(String(intArrayOf(0x1F935, 0x1F3FC, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 41, 18, false),
        FacebookEmoji(String(intArrayOf(0x1F935, 0x1F3FD, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 41, 19, false),
        FacebookEmoji(String(intArrayOf(0x1F935, 0x1F3FE, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 41, 20, false),
        FacebookEmoji(String(intArrayOf(0x1F935, 0x1F3FF, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 41, 21, false),
      ),
    ),
    FacebookEmoji(
      String(intArrayOf(0x1F470), 0, 1), listOf("bride_with_veil"), 23, 30, false,
      variants = listOf(
        FacebookEmoji(String(intArrayOf(0x1F470, 0x1F3FB), 0, 2), emptyList<String>(), 23, 31, false),
        FacebookEmoji(String(intArrayOf(0x1F470, 0x1F3FC), 0, 2), emptyList<String>(), 23, 32, false),
        FacebookEmoji(String(intArrayOf(0x1F470, 0x1F3FD), 0, 2), emptyList<String>(), 23, 33, false),
        FacebookEmoji(String(intArrayOf(0x1F470, 0x1F3FE), 0, 2), emptyList<String>(), 23, 34, false),
        FacebookEmoji(String(intArrayOf(0x1F470, 0x1F3FF), 0, 2), emptyList<String>(), 23, 35, false),
      ),
    ),
    FacebookEmoji(
      String(intArrayOf(0x1F470, 0x200D, 0x2642, 0xFE0F), 0, 4), listOf("man_with_veil"), 23, 24, false,
      variants = listOf(
        FacebookEmoji(String(intArrayOf(0x1F470, 0x1F3FB, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 23, 25, false),
        FacebookEmoji(String(intArrayOf(0x1F470, 0x1F3FC, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 23, 26, false),
        FacebookEmoji(String(intArrayOf(0x1F470, 0x1F3FD, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 23, 27, false),
        FacebookEmoji(String(intArrayOf(0x1F470, 0x1F3FE, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 23, 28, false),
        FacebookEmoji(String(intArrayOf(0x1F470, 0x1F3FF, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 23, 29, false),
      ),
    ),
    FacebookEmoji(
      String(intArrayOf(0x1F470, 0x200D, 0x2640, 0xFE0F), 0, 4), listOf("woman_with_veil"), 23, 18, false,
      variants = listOf(
        FacebookEmoji(String(intArrayOf(0x1F470, 0x1F3FB, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 23, 19, false),
        FacebookEmoji(String(intArrayOf(0x1F470, 0x1F3FC, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 23, 20, false),
        FacebookEmoji(String(intArrayOf(0x1F470, 0x1F3FD, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 23, 21, false),
        FacebookEmoji(String(intArrayOf(0x1F470, 0x1F3FE, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 23, 22, false),
        FacebookEmoji(String(intArrayOf(0x1F470, 0x1F3FF, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 23, 23, false),
      ),
    ),
    FacebookEmoji(
      String(intArrayOf(0x1F930), 0, 1), listOf("pregnant_woman"), 40, 47, false,
      variants = listOf(
        FacebookEmoji(String(intArrayOf(0x1F930, 0x1F3FB), 0, 2), emptyList<String>(), 40, 48, false),
        FacebookEmoji(String(intArrayOf(0x1F930, 0x1F3FC), 0, 2), emptyList<String>(), 40, 49, false),
        FacebookEmoji(String(intArrayOf(0x1F930, 0x1F3FD), 0, 2), emptyList<String>(), 40, 50, false),
        FacebookEmoji(String(intArrayOf(0x1F930, 0x1F3FE), 0, 2), emptyList<String>(), 40, 51, false),
        FacebookEmoji(String(intArrayOf(0x1F930, 0x1F3FF), 0, 2), emptyList<String>(), 40, 52, false),
      ),
    ),
    FacebookEmoji(
      String(intArrayOf(0x1FAC3), 0, 1), listOf("pregnant_man"), 54, 59, false,
      variants = listOf(
        FacebookEmoji(String(intArrayOf(0x1FAC3, 0x1F3FB), 0, 2), emptyList<String>(), 54, 60, false),
        FacebookEmoji(String(intArrayOf(0x1FAC3, 0x1F3FC), 0, 2), emptyList<String>(), 55, 0, false),
        FacebookEmoji(String(intArrayOf(0x1FAC3, 0x1F3FD), 0, 2), emptyList<String>(), 55, 1, false),
        FacebookEmoji(String(intArrayOf(0x1FAC3, 0x1F3FE), 0, 2), emptyList<String>(), 55, 2, false),
        FacebookEmoji(String(intArrayOf(0x1FAC3, 0x1F3FF), 0, 2), emptyList<String>(), 55, 3, false),
      ),
    ),
    FacebookEmoji(
      String(intArrayOf(0x1FAC4), 0, 1), listOf("pregnant_person"), 55, 4, false,
      variants = listOf(
        FacebookEmoji(String(intArrayOf(0x1FAC4, 0x1F3FB), 0, 2), emptyList<String>(), 55, 5, false),
        FacebookEmoji(String(intArrayOf(0x1FAC4, 0x1F3FC), 0, 2), emptyList<String>(), 55, 6, false),
        FacebookEmoji(String(intArrayOf(0x1FAC4, 0x1F3FD), 0, 2), emptyList<String>(), 55, 7, false),
        FacebookEmoji(String(intArrayOf(0x1FAC4, 0x1F3FE), 0, 2), emptyList<String>(), 55, 8, false),
        FacebookEmoji(String(intArrayOf(0x1FAC4, 0x1F3FF), 0, 2), emptyList<String>(), 55, 9, false),
      ),
    ),
    FacebookEmoji(
      String(intArrayOf(0x1F931), 0, 1), listOf("breast-feeding"), 40, 53, false,
      variants = listOf(
        FacebookEmoji(String(intArrayOf(0x1F931, 0x1F3FB), 0, 2), emptyList<String>(), 40, 54, false),
        FacebookEmoji(String(intArrayOf(0x1F931, 0x1F3FC), 0, 2), emptyList<String>(), 40, 55, false),
        FacebookEmoji(String(intArrayOf(0x1F931, 0x1F3FD), 0, 2), emptyList<String>(), 40, 56, false),
        FacebookEmoji(String(intArrayOf(0x1F931, 0x1F3FE), 0, 2), emptyList<String>(), 40, 57, false),
        FacebookEmoji(String(intArrayOf(0x1F931, 0x1F3FF), 0, 2), emptyList<String>(), 40, 58, false),
      ),
    ),
    FacebookEmoji(
      String(intArrayOf(0x1F469, 0x200D, 0x1F37C), 0, 3), listOf("woman_feeding_baby"), 17, 32, false,
      variants = listOf(
        FacebookEmoji(String(intArrayOf(0x1F469, 0x1F3FB, 0x200D, 0x1F37C), 0, 4), emptyList<String>(), 17, 33, false),
        FacebookEmoji(String(intArrayOf(0x1F469, 0x1F3FC, 0x200D, 0x1F37C), 0, 4), emptyList<String>(), 17, 34, false),
        FacebookEmoji(String(intArrayOf(0x1F469, 0x1F3FD, 0x200D, 0x1F37C), 0, 4), emptyList<String>(), 17, 35, false),
        FacebookEmoji(String(intArrayOf(0x1F469, 0x1F3FE, 0x200D, 0x1F37C), 0, 4), emptyList<String>(), 17, 36, false),
        FacebookEmoji(String(intArrayOf(0x1F469, 0x1F3FF, 0x200D, 0x1F37C), 0, 4), emptyList<String>(), 17, 37, false),
      ),
    ),
    FacebookEmoji(
      String(intArrayOf(0x1F468, 0x200D, 0x1F37C), 0, 3), listOf("man_feeding_baby"), 13, 59, false,
      variants = listOf(
        FacebookEmoji(String(intArrayOf(0x1F468, 0x1F3FB, 0x200D, 0x1F37C), 0, 4), emptyList<String>(), 13, 60, false),
        FacebookEmoji(String(intArrayOf(0x1F468, 0x1F3FC, 0x200D, 0x1F37C), 0, 4), emptyList<String>(), 14, 0, false),
        FacebookEmoji(String(intArrayOf(0x1F468, 0x1F3FD, 0x200D, 0x1F37C), 0, 4), emptyList<String>(), 14, 1, false),
        FacebookEmoji(String(intArrayOf(0x1F468, 0x1F3FE, 0x200D, 0x1F37C), 0, 4), emptyList<String>(), 14, 2, false),
        FacebookEmoji(String(intArrayOf(0x1F468, 0x1F3FF, 0x200D, 0x1F37C), 0, 4), emptyList<String>(), 14, 3, false),
      ),
    ),
    FacebookEmoji(
      String(intArrayOf(0x1F9D1, 0x200D, 0x1F37C), 0, 3), listOf("person_feeding_baby"), 47, 26, false,
      variants = listOf(
        FacebookEmoji(String(intArrayOf(0x1F9D1, 0x1F3FB, 0x200D, 0x1F37C), 0, 4), emptyList<String>(), 47, 27, false),
        FacebookEmoji(String(intArrayOf(0x1F9D1, 0x1F3FC, 0x200D, 0x1F37C), 0, 4), emptyList<String>(), 47, 28, false),
        FacebookEmoji(String(intArrayOf(0x1F9D1, 0x1F3FD, 0x200D, 0x1F37C), 0, 4), emptyList<String>(), 47, 29, false),
        FacebookEmoji(String(intArrayOf(0x1F9D1, 0x1F3FE, 0x200D, 0x1F37C), 0, 4), emptyList<String>(), 47, 30, false),
        FacebookEmoji(String(intArrayOf(0x1F9D1, 0x1F3FF, 0x200D, 0x1F37C), 0, 4), emptyList<String>(), 47, 31, false),
      ),
    ),
    FacebookEmoji(
      String(intArrayOf(0x1F47C), 0, 1), listOf("angel"), 25, 1, false,
      variants = listOf(
        FacebookEmoji(String(intArrayOf(0x1F47C, 0x1F3FB), 0, 2), emptyList<String>(), 25, 2, false),
        FacebookEmoji(String(intArrayOf(0x1F47C, 0x1F3FC), 0, 2), emptyList<String>(), 25, 3, false),
        FacebookEmoji(String(intArrayOf(0x1F47C, 0x1F3FD), 0, 2), emptyList<String>(), 25, 4, false),
        FacebookEmoji(String(intArrayOf(0x1F47C, 0x1F3FE), 0, 2), emptyList<String>(), 25, 5, false),
        FacebookEmoji(String(intArrayOf(0x1F47C, 0x1F3FF), 0, 2), emptyList<String>(), 25, 6, false),
      ),
    ),
    FacebookEmoji(
      String(intArrayOf(0x1F385), 0, 1), listOf("santa"), 7, 8, false,
      variants = listOf(
        FacebookEmoji(String(intArrayOf(0x1F385, 0x1F3FB), 0, 2), emptyList<String>(), 7, 9, false),
        FacebookEmoji(String(intArrayOf(0x1F385, 0x1F3FC), 0, 2), emptyList<String>(), 7, 10, false),
        FacebookEmoji(String(intArrayOf(0x1F385, 0x1F3FD), 0, 2), emptyList<String>(), 7, 11, false),
        FacebookEmoji(String(intArrayOf(0x1F385, 0x1F3FE), 0, 2), emptyList<String>(), 7, 12, false),
        FacebookEmoji(String(intArrayOf(0x1F385, 0x1F3FF), 0, 2), emptyList<String>(), 7, 13, false),
      ),
    ),
  )
}
