/*
 * Copyright (C) 2016 - Niklas Baudy, Ruben Gees, Mario Đanić and contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.vanniktech.emoji.google.category

import com.vanniktech.emoji.google.GoogleEmoji

internal object SmileysAndPeopleCategoryChunk3 {
  internal val EMOJIS: List<GoogleEmoji> = listOf(
    GoogleEmoji(
      String(intArrayOf(0x1F930), 0, 1), listOf("pregnant_woman"), 40, 47, false,
      variants = listOf(
        GoogleEmoji(String(intArrayOf(0x1F930, 0x1F3FB), 0, 2), emptyList<String>(), 40, 48, false),
        GoogleEmoji(String(intArrayOf(0x1F930, 0x1F3FC), 0, 2), emptyList<String>(), 40, 49, false),
        GoogleEmoji(String(intArrayOf(0x1F930, 0x1F3FD), 0, 2), emptyList<String>(), 40, 50, false),
        GoogleEmoji(String(intArrayOf(0x1F930, 0x1F3FE), 0, 2), emptyList<String>(), 40, 51, false),
        GoogleEmoji(String(intArrayOf(0x1F930, 0x1F3FF), 0, 2), emptyList<String>(), 40, 52, false),
      ),
    ),
    GoogleEmoji(
      String(intArrayOf(0x1FAC3), 0, 1), listOf("pregnant_man"), 54, 59, false,
      variants = listOf(
        GoogleEmoji(String(intArrayOf(0x1FAC3, 0x1F3FB), 0, 2), emptyList<String>(), 54, 60, false),
        GoogleEmoji(String(intArrayOf(0x1FAC3, 0x1F3FC), 0, 2), emptyList<String>(), 55, 0, false),
        GoogleEmoji(String(intArrayOf(0x1FAC3, 0x1F3FD), 0, 2), emptyList<String>(), 55, 1, false),
        GoogleEmoji(String(intArrayOf(0x1FAC3, 0x1F3FE), 0, 2), emptyList<String>(), 55, 2, false),
        GoogleEmoji(String(intArrayOf(0x1FAC3, 0x1F3FF), 0, 2), emptyList<String>(), 55, 3, false),
      ),
    ),
    GoogleEmoji(
      String(intArrayOf(0x1FAC4), 0, 1), listOf("pregnant_person"), 55, 4, false,
      variants = listOf(
        GoogleEmoji(String(intArrayOf(0x1FAC4, 0x1F3FB), 0, 2), emptyList<String>(), 55, 5, false),
        GoogleEmoji(String(intArrayOf(0x1FAC4, 0x1F3FC), 0, 2), emptyList<String>(), 55, 6, false),
        GoogleEmoji(String(intArrayOf(0x1FAC4, 0x1F3FD), 0, 2), emptyList<String>(), 55, 7, false),
        GoogleEmoji(String(intArrayOf(0x1FAC4, 0x1F3FE), 0, 2), emptyList<String>(), 55, 8, false),
        GoogleEmoji(String(intArrayOf(0x1FAC4, 0x1F3FF), 0, 2), emptyList<String>(), 55, 9, false),
      ),
    ),
    GoogleEmoji(
      String(intArrayOf(0x1F931), 0, 1), listOf("breast-feeding"), 40, 53, false,
      variants = listOf(
        GoogleEmoji(String(intArrayOf(0x1F931, 0x1F3FB), 0, 2), emptyList<String>(), 40, 54, false),
        GoogleEmoji(String(intArrayOf(0x1F931, 0x1F3FC), 0, 2), emptyList<String>(), 40, 55, false),
        GoogleEmoji(String(intArrayOf(0x1F931, 0x1F3FD), 0, 2), emptyList<String>(), 40, 56, false),
        GoogleEmoji(String(intArrayOf(0x1F931, 0x1F3FE), 0, 2), emptyList<String>(), 40, 57, false),
        GoogleEmoji(String(intArrayOf(0x1F931, 0x1F3FF), 0, 2), emptyList<String>(), 40, 58, false),
      ),
    ),
    GoogleEmoji(
      String(intArrayOf(0x1F469, 0x200D, 0x1F37C), 0, 3), listOf("woman_feeding_baby"), 17, 32, false,
      variants = listOf(
        GoogleEmoji(String(intArrayOf(0x1F469, 0x1F3FB, 0x200D, 0x1F37C), 0, 4), emptyList<String>(), 17, 33, false),
        GoogleEmoji(String(intArrayOf(0x1F469, 0x1F3FC, 0x200D, 0x1F37C), 0, 4), emptyList<String>(), 17, 34, false),
        GoogleEmoji(String(intArrayOf(0x1F469, 0x1F3FD, 0x200D, 0x1F37C), 0, 4), emptyList<String>(), 17, 35, false),
        GoogleEmoji(String(intArrayOf(0x1F469, 0x1F3FE, 0x200D, 0x1F37C), 0, 4), emptyList<String>(), 17, 36, false),
        GoogleEmoji(String(intArrayOf(0x1F469, 0x1F3FF, 0x200D, 0x1F37C), 0, 4), emptyList<String>(), 17, 37, false),
      ),
    ),
    GoogleEmoji(
      String(intArrayOf(0x1F468, 0x200D, 0x1F37C), 0, 3), listOf("man_feeding_baby"), 13, 59, false,
      variants = listOf(
        GoogleEmoji(String(intArrayOf(0x1F468, 0x1F3FB, 0x200D, 0x1F37C), 0, 4), emptyList<String>(), 13, 60, false),
        GoogleEmoji(String(intArrayOf(0x1F468, 0x1F3FC, 0x200D, 0x1F37C), 0, 4), emptyList<String>(), 14, 0, false),
        GoogleEmoji(String(intArrayOf(0x1F468, 0x1F3FD, 0x200D, 0x1F37C), 0, 4), emptyList<String>(), 14, 1, false),
        GoogleEmoji(String(intArrayOf(0x1F468, 0x1F3FE, 0x200D, 0x1F37C), 0, 4), emptyList<String>(), 14, 2, false),
        GoogleEmoji(String(intArrayOf(0x1F468, 0x1F3FF, 0x200D, 0x1F37C), 0, 4), emptyList<String>(), 14, 3, false),
      ),
    ),
    GoogleEmoji(
      String(intArrayOf(0x1F9D1, 0x200D, 0x1F37C), 0, 3), listOf("person_feeding_baby"), 47, 26, false,
      variants = listOf(
        GoogleEmoji(String(intArrayOf(0x1F9D1, 0x1F3FB, 0x200D, 0x1F37C), 0, 4), emptyList<String>(), 47, 27, false),
        GoogleEmoji(String(intArrayOf(0x1F9D1, 0x1F3FC, 0x200D, 0x1F37C), 0, 4), emptyList<String>(), 47, 28, false),
        GoogleEmoji(String(intArrayOf(0x1F9D1, 0x1F3FD, 0x200D, 0x1F37C), 0, 4), emptyList<String>(), 47, 29, false),
        GoogleEmoji(String(intArrayOf(0x1F9D1, 0x1F3FE, 0x200D, 0x1F37C), 0, 4), emptyList<String>(), 47, 30, false),
        GoogleEmoji(String(intArrayOf(0x1F9D1, 0x1F3FF, 0x200D, 0x1F37C), 0, 4), emptyList<String>(), 47, 31, false),
      ),
    ),
    GoogleEmoji(
      String(intArrayOf(0x1F47C), 0, 1), listOf("angel"), 25, 1, false,
      variants = listOf(
        GoogleEmoji(String(intArrayOf(0x1F47C, 0x1F3FB), 0, 2), emptyList<String>(), 25, 2, false),
        GoogleEmoji(String(intArrayOf(0x1F47C, 0x1F3FC), 0, 2), emptyList<String>(), 25, 3, false),
        GoogleEmoji(String(intArrayOf(0x1F47C, 0x1F3FD), 0, 2), emptyList<String>(), 25, 4, false),
        GoogleEmoji(String(intArrayOf(0x1F47C, 0x1F3FE), 0, 2), emptyList<String>(), 25, 5, false),
        GoogleEmoji(String(intArrayOf(0x1F47C, 0x1F3FF), 0, 2), emptyList<String>(), 25, 6, false),
      ),
    ),
    GoogleEmoji(
      String(intArrayOf(0x1F385), 0, 1), listOf("santa"), 7, 8, false,
      variants = listOf(
        GoogleEmoji(String(intArrayOf(0x1F385, 0x1F3FB), 0, 2), emptyList<String>(), 7, 9, false),
        GoogleEmoji(String(intArrayOf(0x1F385, 0x1F3FC), 0, 2), emptyList<String>(), 7, 10, false),
        GoogleEmoji(String(intArrayOf(0x1F385, 0x1F3FD), 0, 2), emptyList<String>(), 7, 11, false),
        GoogleEmoji(String(intArrayOf(0x1F385, 0x1F3FE), 0, 2), emptyList<String>(), 7, 12, false),
        GoogleEmoji(String(intArrayOf(0x1F385, 0x1F3FF), 0, 2), emptyList<String>(), 7, 13, false),
      ),
    ),
    GoogleEmoji(
      String(intArrayOf(0x1F936), 0, 1), listOf("mrs_claus", "mother_christmas"), 41, 34, false,
      variants = listOf(
        GoogleEmoji(String(intArrayOf(0x1F936, 0x1F3FB), 0, 2), emptyList<String>(), 41, 35, false),
        GoogleEmoji(String(intArrayOf(0x1F936, 0x1F3FC), 0, 2), emptyList<String>(), 41, 36, false),
        GoogleEmoji(String(intArrayOf(0x1F936, 0x1F3FD), 0, 2), emptyList<String>(), 41, 37, false),
        GoogleEmoji(String(intArrayOf(0x1F936, 0x1F3FE), 0, 2), emptyList<String>(), 41, 38, false),
        GoogleEmoji(String(intArrayOf(0x1F936, 0x1F3FF), 0, 2), emptyList<String>(), 41, 39, false),
      ),
    ),
    GoogleEmoji(
      String(intArrayOf(0x1F9D1, 0x200D, 0x1F384), 0, 3), listOf("mx_claus"), 47, 32, false,
      variants = listOf(
        GoogleEmoji(String(intArrayOf(0x1F9D1, 0x1F3FB, 0x200D, 0x1F384), 0, 4), emptyList<String>(), 47, 33, false),
        GoogleEmoji(String(intArrayOf(0x1F9D1, 0x1F3FC, 0x200D, 0x1F384), 0, 4), emptyList<String>(), 47, 34, false),
        GoogleEmoji(String(intArrayOf(0x1F9D1, 0x1F3FD, 0x200D, 0x1F384), 0, 4), emptyList<String>(), 47, 35, false),
        GoogleEmoji(String(intArrayOf(0x1F9D1, 0x1F3FE, 0x200D, 0x1F384), 0, 4), emptyList<String>(), 47, 36, false),
        GoogleEmoji(String(intArrayOf(0x1F9D1, 0x1F3FF, 0x200D, 0x1F384), 0, 4), emptyList<String>(), 47, 37, false),
      ),
    ),
    GoogleEmoji(
      String(intArrayOf(0x1F9B8), 0, 1), listOf("superhero"), 45, 33, false,
      variants = listOf(
        GoogleEmoji(String(intArrayOf(0x1F9B8, 0x1F3FB), 0, 2), emptyList<String>(), 45, 34, false),
        GoogleEmoji(String(intArrayOf(0x1F9B8, 0x1F3FC), 0, 2), emptyList<String>(), 45, 35, false),
        GoogleEmoji(String(intArrayOf(0x1F9B8, 0x1F3FD), 0, 2), emptyList<String>(), 45, 36, false),
        GoogleEmoji(String(intArrayOf(0x1F9B8, 0x1F3FE), 0, 2), emptyList<String>(), 45, 37, false),
        GoogleEmoji(String(intArrayOf(0x1F9B8, 0x1F3FF), 0, 2), emptyList<String>(), 45, 38, false),
      ),
    ),
    GoogleEmoji(
      String(intArrayOf(0x1F9B8, 0x200D, 0x2642, 0xFE0F), 0, 4), listOf("male_superhero"), 45, 27, false,
      variants = listOf(
        GoogleEmoji(String(intArrayOf(0x1F9B8, 0x1F3FB, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 45, 28, false),
        GoogleEmoji(String(intArrayOf(0x1F9B8, 0x1F3FC, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 45, 29, false),
        GoogleEmoji(String(intArrayOf(0x1F9B8, 0x1F3FD, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 45, 30, false),
        GoogleEmoji(String(intArrayOf(0x1F9B8, 0x1F3FE, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 45, 31, false),
        GoogleEmoji(String(intArrayOf(0x1F9B8, 0x1F3FF, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 45, 32, false),
      ),
    ),
    GoogleEmoji(
      String(intArrayOf(0x1F9B8, 0x200D, 0x2640, 0xFE0F), 0, 4), listOf("female_superhero"), 45, 21, false,
      variants = listOf(
        GoogleEmoji(String(intArrayOf(0x1F9B8, 0x1F3FB, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 45, 22, false),
        GoogleEmoji(String(intArrayOf(0x1F9B8, 0x1F3FC, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 45, 23, false),
        GoogleEmoji(String(intArrayOf(0x1F9B8, 0x1F3FD, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 45, 24, false),
        GoogleEmoji(String(intArrayOf(0x1F9B8, 0x1F3FE, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 45, 25, false),
        GoogleEmoji(String(intArrayOf(0x1F9B8, 0x1F3FF, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 45, 26, false),
      ),
    ),
    GoogleEmoji(
      String(intArrayOf(0x1F9B9), 0, 1), listOf("supervillain"), 45, 51, false,
      variants = listOf(
        GoogleEmoji(String(intArrayOf(0x1F9B9, 0x1F3FB), 0, 2), emptyList<String>(), 45, 52, false),
        GoogleEmoji(String(intArrayOf(0x1F9B9, 0x1F3FC), 0, 2), emptyList<String>(), 45, 53, false),
        GoogleEmoji(String(intArrayOf(0x1F9B9, 0x1F3FD), 0, 2), emptyList<String>(), 45, 54, false),
        GoogleEmoji(String(intArrayOf(0x1F9B9, 0x1F3FE), 0, 2), emptyList<String>(), 45, 55, false),
        GoogleEmoji(String(intArrayOf(0x1F9B9, 0x1F3FF), 0, 2), emptyList<String>(), 45, 56, false),
      ),
    ),
    GoogleEmoji(
      String(intArrayOf(0x1F9B9, 0x200D, 0x2642, 0xFE0F), 0, 4), listOf("male_supervillain"), 45, 45, false,
      variants = listOf(
        GoogleEmoji(String(intArrayOf(0x1F9B9, 0x1F3FB, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 45, 46, false),
        GoogleEmoji(String(intArrayOf(0x1F9B9, 0x1F3FC, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 45, 47, false),
        GoogleEmoji(String(intArrayOf(0x1F9B9, 0x1F3FD, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 45, 48, false),
        GoogleEmoji(String(intArrayOf(0x1F9B9, 0x1F3FE, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 45, 49, false),
        GoogleEmoji(String(intArrayOf(0x1F9B9, 0x1F3FF, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 45, 50, false),
      ),
    ),
    GoogleEmoji(
      String(intArrayOf(0x1F9B9, 0x200D, 0x2640, 0xFE0F), 0, 4), listOf("female_supervillain"), 45, 39, false,
      variants = listOf(
        GoogleEmoji(String(intArrayOf(0x1F9B9, 0x1F3FB, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 45, 40, false),
        GoogleEmoji(String(intArrayOf(0x1F9B9, 0x1F3FC, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 45, 41, false),
        GoogleEmoji(String(intArrayOf(0x1F9B9, 0x1F3FD, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 45, 42, false),
        GoogleEmoji(String(intArrayOf(0x1F9B9, 0x1F3FE, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 45, 43, false),
        GoogleEmoji(String(intArrayOf(0x1F9B9, 0x1F3FF, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 45, 44, false),
      ),
    ),
    GoogleEmoji(
      String(intArrayOf(0x1F9D9), 0, 1), listOf("mage"), 51, 54, true,
      variants = listOf(
        GoogleEmoji(String(intArrayOf(0x1F9D9, 0x1F3FB), 0, 2), emptyList<String>(), 51, 55, true),
        GoogleEmoji(String(intArrayOf(0x1F9D9, 0x1F3FC), 0, 2), emptyList<String>(), 51, 56, true),
        GoogleEmoji(String(intArrayOf(0x1F9D9, 0x1F3FD), 0, 2), emptyList<String>(), 51, 57, true),
        GoogleEmoji(String(intArrayOf(0x1F9D9, 0x1F3FE), 0, 2), emptyList<String>(), 51, 58, true),
        GoogleEmoji(String(intArrayOf(0x1F9D9, 0x1F3FF), 0, 2), emptyList<String>(), 51, 59, true),
      ),
    ),
    GoogleEmoji(
      String(intArrayOf(0x1F9D9, 0x200D, 0x2642, 0xFE0F), 0, 4), listOf("male_mage"), 51, 48, false,
      variants = listOf(
        GoogleEmoji(String(intArrayOf(0x1F9D9, 0x1F3FB, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 51, 49, false),
        GoogleEmoji(String(intArrayOf(0x1F9D9, 0x1F3FC, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 51, 50, false),
        GoogleEmoji(String(intArrayOf(0x1F9D9, 0x1F3FD, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 51, 51, false),
        GoogleEmoji(String(intArrayOf(0x1F9D9, 0x1F3FE, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 51, 52, false),
        GoogleEmoji(String(intArrayOf(0x1F9D9, 0x1F3FF, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 51, 53, false),
      ),
    ),
    GoogleEmoji(
      String(intArrayOf(0x1F9D9, 0x200D, 0x2640, 0xFE0F), 0, 4), listOf("female_mage"), 51, 42, false,
      variants = listOf(
        GoogleEmoji(String(intArrayOf(0x1F9D9, 0x1F3FB, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 51, 43, false),
        GoogleEmoji(String(intArrayOf(0x1F9D9, 0x1F3FC, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 51, 44, false),
        GoogleEmoji(String(intArrayOf(0x1F9D9, 0x1F3FD, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 51, 45, false),
        GoogleEmoji(String(intArrayOf(0x1F9D9, 0x1F3FE, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 51, 46, false),
        GoogleEmoji(String(intArrayOf(0x1F9D9, 0x1F3FF, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 51, 47, false),
      ),
    ),
    GoogleEmoji(
      String(intArrayOf(0x1F9DA), 0, 1), listOf("fairy"), 52, 11, true,
      variants = listOf(
        GoogleEmoji(String(intArrayOf(0x1F9DA, 0x1F3FB), 0, 2), emptyList<String>(), 52, 12, true),
        GoogleEmoji(String(intArrayOf(0x1F9DA, 0x1F3FC), 0, 2), emptyList<String>(), 52, 13, true),
        GoogleEmoji(String(intArrayOf(0x1F9DA, 0x1F3FD), 0, 2), emptyList<String>(), 52, 14, true),
        GoogleEmoji(String(intArrayOf(0x1F9DA, 0x1F3FE), 0, 2), emptyList<String>(), 52, 15, true),
        GoogleEmoji(String(intArrayOf(0x1F9DA, 0x1F3FF), 0, 2), emptyList<String>(), 52, 16, true),
      ),
    ),
    GoogleEmoji(
      String(intArrayOf(0x1F9DA, 0x200D, 0x2642, 0xFE0F), 0, 4), listOf("male_fairy"), 52, 5, false,
      variants = listOf(
        GoogleEmoji(String(intArrayOf(0x1F9DA, 0x1F3FB, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 52, 6, false),
        GoogleEmoji(String(intArrayOf(0x1F9DA, 0x1F3FC, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 52, 7, false),
        GoogleEmoji(String(intArrayOf(0x1F9DA, 0x1F3FD, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 52, 8, false),
        GoogleEmoji(String(intArrayOf(0x1F9DA, 0x1F3FE, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 52, 9, false),
        GoogleEmoji(String(intArrayOf(0x1F9DA, 0x1F3FF, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 52, 10, false),
      ),
    ),
    GoogleEmoji(
      String(intArrayOf(0x1F9DA, 0x200D, 0x2640, 0xFE0F), 0, 4), listOf("female_fairy"), 51, 60, false,
      variants = listOf(
        GoogleEmoji(String(intArrayOf(0x1F9DA, 0x1F3FB, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 52, 0, false),
        GoogleEmoji(String(intArrayOf(0x1F9DA, 0x1F3FC, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 52, 1, false),
        GoogleEmoji(String(intArrayOf(0x1F9DA, 0x1F3FD, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 52, 2, false),
        GoogleEmoji(String(intArrayOf(0x1F9DA, 0x1F3FE, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 52, 3, false),
        GoogleEmoji(String(intArrayOf(0x1F9DA, 0x1F3FF, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 52, 4, false),
      ),
    ),
    GoogleEmoji(
      String(intArrayOf(0x1F9DB), 0, 1), listOf("vampire"), 52, 29, true,
      variants = listOf(
        GoogleEmoji(String(intArrayOf(0x1F9DB, 0x1F3FB), 0, 2), emptyList<String>(), 52, 30, true),
        GoogleEmoji(String(intArrayOf(0x1F9DB, 0x1F3FC), 0, 2), emptyList<String>(), 52, 31, true),
        GoogleEmoji(String(intArrayOf(0x1F9DB, 0x1F3FD), 0, 2), emptyList<String>(), 52, 32, true),
        GoogleEmoji(String(intArrayOf(0x1F9DB, 0x1F3FE), 0, 2), emptyList<String>(), 52, 33, true),
        GoogleEmoji(String(intArrayOf(0x1F9DB, 0x1F3FF), 0, 2), emptyList<String>(), 52, 34, true),
      ),
    ),
    GoogleEmoji(
      String(intArrayOf(0x1F9DB, 0x200D, 0x2642, 0xFE0F), 0, 4), listOf("male_vampire"), 52, 23, false,
      variants = listOf(
        GoogleEmoji(String(intArrayOf(0x1F9DB, 0x1F3FB, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 52, 24, false),
        GoogleEmoji(String(intArrayOf(0x1F9DB, 0x1F3FC, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 52, 25, false),
        GoogleEmoji(String(intArrayOf(0x1F9DB, 0x1F3FD, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 52, 26, false),
        GoogleEmoji(String(intArrayOf(0x1F9DB, 0x1F3FE, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 52, 27, false),
        GoogleEmoji(String(intArrayOf(0x1F9DB, 0x1F3FF, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 52, 28, false),
      ),
    ),
    GoogleEmoji(
      String(intArrayOf(0x1F9DB, 0x200D, 0x2640, 0xFE0F), 0, 4), listOf("female_vampire"), 52, 17, false,
      variants = listOf(
        GoogleEmoji(String(intArrayOf(0x1F9DB, 0x1F3FB, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 52, 18, false),
        GoogleEmoji(String(intArrayOf(0x1F9DB, 0x1F3FC, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 52, 19, false),
        GoogleEmoji(String(intArrayOf(0x1F9DB, 0x1F3FD, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 52, 20, false),
        GoogleEmoji(String(intArrayOf(0x1F9DB, 0x1F3FE, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 52, 21, false),
        GoogleEmoji(String(intArrayOf(0x1F9DB, 0x1F3FF, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 52, 22, false),
      ),
    ),
    GoogleEmoji(
      String(intArrayOf(0x1F9DC), 0, 1), listOf("merperson"), 52, 47, true,
      variants = listOf(
        GoogleEmoji(String(intArrayOf(0x1F9DC, 0x1F3FB), 0, 2), emptyList<String>(), 52, 48, true),
        GoogleEmoji(String(intArrayOf(0x1F9DC, 0x1F3FC), 0, 2), emptyList<String>(), 52, 49, true),
        GoogleEmoji(String(intArrayOf(0x1F9DC, 0x1F3FD), 0, 2), emptyList<String>(), 52, 50, true),
        GoogleEmoji(String(intArrayOf(0x1F9DC, 0x1F3FE), 0, 2), emptyList<String>(), 52, 51, true),
        GoogleEmoji(String(intArrayOf(0x1F9DC, 0x1F3FF), 0, 2), emptyList<String>(), 52, 52, true),
      ),
    ),
    GoogleEmoji(
      String(intArrayOf(0x1F9DC, 0x200D, 0x2642, 0xFE0F), 0, 4), listOf("merman"), 52, 41, false,
      variants = listOf(
        GoogleEmoji(String(intArrayOf(0x1F9DC, 0x1F3FB, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 52, 42, false),
        GoogleEmoji(String(intArrayOf(0x1F9DC, 0x1F3FC, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 52, 43, false),
        GoogleEmoji(String(intArrayOf(0x1F9DC, 0x1F3FD, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 52, 44, false),
        GoogleEmoji(String(intArrayOf(0x1F9DC, 0x1F3FE, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 52, 45, false),
        GoogleEmoji(String(intArrayOf(0x1F9DC, 0x1F3FF, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 52, 46, false),
      ),
    ),
    GoogleEmoji(
      String(intArrayOf(0x1F9DC, 0x200D, 0x2640, 0xFE0F), 0, 4), listOf("mermaid"), 52, 35, false,
      variants = listOf(
        GoogleEmoji(String(intArrayOf(0x1F9DC, 0x1F3FB, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 52, 36, false),
        GoogleEmoji(String(intArrayOf(0x1F9DC, 0x1F3FC, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 52, 37, false),
        GoogleEmoji(String(intArrayOf(0x1F9DC, 0x1F3FD, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 52, 38, false),
        GoogleEmoji(String(intArrayOf(0x1F9DC, 0x1F3FE, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 52, 39, false),
        GoogleEmoji(String(intArrayOf(0x1F9DC, 0x1F3FF, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 52, 40, false),
      ),
    ),
    GoogleEmoji(
      String(intArrayOf(0x1F9DD), 0, 1), listOf("elf"), 53, 4, true,
      variants = listOf(
        GoogleEmoji(String(intArrayOf(0x1F9DD, 0x1F3FB), 0, 2), emptyList<String>(), 53, 5, true),
        GoogleEmoji(String(intArrayOf(0x1F9DD, 0x1F3FC), 0, 2), emptyList<String>(), 53, 6, true),
        GoogleEmoji(String(intArrayOf(0x1F9DD, 0x1F3FD), 0, 2), emptyList<String>(), 53, 7, true),
        GoogleEmoji(String(intArrayOf(0x1F9DD, 0x1F3FE), 0, 2), emptyList<String>(), 53, 8, true),
        GoogleEmoji(String(intArrayOf(0x1F9DD, 0x1F3FF), 0, 2), emptyList<String>(), 53, 9, true),
      ),
    ),
    GoogleEmoji(
      String(intArrayOf(0x1F9DD, 0x200D, 0x2642, 0xFE0F), 0, 4), listOf("male_elf"), 52, 59, false,
      variants = listOf(
        GoogleEmoji(String(intArrayOf(0x1F9DD, 0x1F3FB, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 52, 60, false),
        GoogleEmoji(String(intArrayOf(0x1F9DD, 0x1F3FC, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 53, 0, false),
        GoogleEmoji(String(intArrayOf(0x1F9DD, 0x1F3FD, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 53, 1, false),
        GoogleEmoji(String(intArrayOf(0x1F9DD, 0x1F3FE, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 53, 2, false),
        GoogleEmoji(String(intArrayOf(0x1F9DD, 0x1F3FF, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 53, 3, false),
      ),
    ),
    GoogleEmoji(
      String(intArrayOf(0x1F9DD, 0x200D, 0x2640, 0xFE0F), 0, 4), listOf("female_elf"), 52, 53, false,
      variants = listOf(
        GoogleEmoji(String(intArrayOf(0x1F9DD, 0x1F3FB, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 52, 54, false),
        GoogleEmoji(String(intArrayOf(0x1F9DD, 0x1F3FC, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 52, 55, false),
        GoogleEmoji(String(intArrayOf(0x1F9DD, 0x1F3FD, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 52, 56, false),
        GoogleEmoji(String(intArrayOf(0x1F9DD, 0x1F3FE, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 52, 57, false),
        GoogleEmoji(String(intArrayOf(0x1F9DD, 0x1F3FF, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 52, 58, false),
      ),
    ),
    GoogleEmoji(String(intArrayOf(0x1F9DE), 0, 1), listOf("genie"), 53, 12, true),
    GoogleEmoji(String(intArrayOf(0x1F9DE, 0x200D, 0x2642, 0xFE0F), 0, 4), listOf("male_genie"), 53, 11, false),
    GoogleEmoji(String(intArrayOf(0x1F9DE, 0x200D, 0x2640, 0xFE0F), 0, 4), listOf("female_genie"), 53, 10, false),
    GoogleEmoji(String(intArrayOf(0x1F9DF), 0, 1), listOf("zombie"), 53, 15, true),
    GoogleEmoji(String(intArrayOf(0x1F9DF, 0x200D, 0x2642, 0xFE0F), 0, 4), listOf("male_zombie"), 53, 14, false),
    GoogleEmoji(String(intArrayOf(0x1F9DF, 0x200D, 0x2640, 0xFE0F), 0, 4), listOf("female_zombie"), 53, 13, false),
    GoogleEmoji(String(intArrayOf(0x1F9CC), 0, 1), listOf("troll"), 46, 19, false),
    GoogleEmoji(
      String(intArrayOf(0x1F486), 0, 1), listOf("massage"), 26, 11, true,
      variants = listOf(
        GoogleEmoji(String(intArrayOf(0x1F486, 0x1F3FB), 0, 2), emptyList<String>(), 26, 12, false),
        GoogleEmoji(String(intArrayOf(0x1F486, 0x1F3FC), 0, 2), emptyList<String>(), 26, 13, false),
        GoogleEmoji(String(intArrayOf(0x1F486, 0x1F3FD), 0, 2), emptyList<String>(), 26, 14, false),
        GoogleEmoji(String(intArrayOf(0x1F486, 0x1F3FE), 0, 2), emptyList<String>(), 26, 15, false),
        GoogleEmoji(String(intArrayOf(0x1F486, 0x1F3FF), 0, 2), emptyList<String>(), 26, 16, false),
      ),
    ),
    GoogleEmoji(
      String(intArrayOf(0x1F486, 0x200D, 0x2642, 0xFE0F), 0, 4), listOf("man-getting-massage"), 26, 5, false,
      variants = listOf(
        GoogleEmoji(String(intArrayOf(0x1F486, 0x1F3FB, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 26, 6, false),
        GoogleEmoji(String(intArrayOf(0x1F486, 0x1F3FC, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 26, 7, false),
        GoogleEmoji(String(intArrayOf(0x1F486, 0x1F3FD, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 26, 8, false),
        GoogleEmoji(String(intArrayOf(0x1F486, 0x1F3FE, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 26, 9, false),
        GoogleEmoji(String(intArrayOf(0x1F486, 0x1F3FF, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 26, 10, false),
      ),
    ),
    GoogleEmoji(
      String(intArrayOf(0x1F486, 0x200D, 0x2640, 0xFE0F), 0, 4), listOf("woman-getting-massage"), 25, 60, false,
      variants = listOf(
        GoogleEmoji(String(intArrayOf(0x1F486, 0x1F3FB, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 26, 0, false),
        GoogleEmoji(String(intArrayOf(0x1F486, 0x1F3FC, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 26, 1, false),
        GoogleEmoji(String(intArrayOf(0x1F486, 0x1F3FD, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 26, 2, false),
        GoogleEmoji(String(intArrayOf(0x1F486, 0x1F3FE, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 26, 3, false),
        GoogleEmoji(String(intArrayOf(0x1F486, 0x1F3FF, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 26, 4, false),
      ),
    ),
    GoogleEmoji(
      String(intArrayOf(0x1F487), 0, 1), listOf("haircut"), 26, 29, true,
      variants = listOf(
        GoogleEmoji(String(intArrayOf(0x1F487, 0x1F3FB), 0, 2), emptyList<String>(), 26, 30, false),
        GoogleEmoji(String(intArrayOf(0x1F487, 0x1F3FC), 0, 2), emptyList<String>(), 26, 31, false),
        GoogleEmoji(String(intArrayOf(0x1F487, 0x1F3FD), 0, 2), emptyList<String>(), 26, 32, false),
        GoogleEmoji(String(intArrayOf(0x1F487, 0x1F3FE), 0, 2), emptyList<String>(), 26, 33, false),
        GoogleEmoji(String(intArrayOf(0x1F487, 0x1F3FF), 0, 2), emptyList<String>(), 26, 34, false),
      ),
    ),
    GoogleEmoji(
      String(intArrayOf(0x1F487, 0x200D, 0x2642, 0xFE0F), 0, 4), listOf("man-getting-haircut"), 26, 23, false,
      variants = listOf(
        GoogleEmoji(String(intArrayOf(0x1F487, 0x1F3FB, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 26, 24, false),
        GoogleEmoji(String(intArrayOf(0x1F487, 0x1F3FC, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 26, 25, false),
        GoogleEmoji(String(intArrayOf(0x1F487, 0x1F3FD, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 26, 26, false),
        GoogleEmoji(String(intArrayOf(0x1F487, 0x1F3FE, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 26, 27, false),
        GoogleEmoji(String(intArrayOf(0x1F487, 0x1F3FF, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 26, 28, false),
      ),
    ),
    GoogleEmoji(
      String(intArrayOf(0x1F487, 0x200D, 0x2640, 0xFE0F), 0, 4), listOf("woman-getting-haircut"), 26, 17, false,
      variants = listOf(
        GoogleEmoji(String(intArrayOf(0x1F487, 0x1F3FB, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 26, 18, false),
        GoogleEmoji(String(intArrayOf(0x1F487, 0x1F3FC, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 26, 19, false),
        GoogleEmoji(String(intArrayOf(0x1F487, 0x1F3FD, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 26, 20, false),
        GoogleEmoji(String(intArrayOf(0x1F487, 0x1F3FE, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 26, 21, false),
        GoogleEmoji(String(intArrayOf(0x1F487, 0x1F3FF, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 26, 22, false),
      ),
    ),
    GoogleEmoji(
      String(intArrayOf(0x1F6B6), 0, 1), listOf("walking"), 37, 28, true,
      variants = listOf(
        GoogleEmoji(String(intArrayOf(0x1F6B6, 0x1F3FB), 0, 2), emptyList<String>(), 37, 29, false),
        GoogleEmoji(String(intArrayOf(0x1F6B6, 0x1F3FC), 0, 2), emptyList<String>(), 37, 30, false),
        GoogleEmoji(String(intArrayOf(0x1F6B6, 0x1F3FD), 0, 2), emptyList<String>(), 37, 31, false),
        GoogleEmoji(String(intArrayOf(0x1F6B6, 0x1F3FE), 0, 2), emptyList<String>(), 37, 32, false),
        GoogleEmoji(String(intArrayOf(0x1F6B6, 0x1F3FF), 0, 2), emptyList<String>(), 37, 33, false),
      ),
    ),
    GoogleEmoji(
      String(intArrayOf(0x1F6B6, 0x200D, 0x2642, 0xFE0F), 0, 4), listOf("man-walking"), 37, 22, false,
      variants = listOf(
        GoogleEmoji(String(intArrayOf(0x1F6B6, 0x1F3FB, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 37, 23, false),
        GoogleEmoji(String(intArrayOf(0x1F6B6, 0x1F3FC, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 37, 24, false),
        GoogleEmoji(String(intArrayOf(0x1F6B6, 0x1F3FD, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 37, 25, false),
        GoogleEmoji(String(intArrayOf(0x1F6B6, 0x1F3FE, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 37, 26, false),
        GoogleEmoji(String(intArrayOf(0x1F6B6, 0x1F3FF, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 37, 27, false),
      ),
    ),
    GoogleEmoji(
      String(intArrayOf(0x1F6B6, 0x200D, 0x2640, 0xFE0F), 0, 4), listOf("woman-walking"), 37, 16, false,
      variants = listOf(
        GoogleEmoji(String(intArrayOf(0x1F6B6, 0x1F3FB, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 37, 17, false),
        GoogleEmoji(String(intArrayOf(0x1F6B6, 0x1F3FC, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 37, 18, false),
        GoogleEmoji(String(intArrayOf(0x1F6B6, 0x1F3FD, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 37, 19, false),
        GoogleEmoji(String(intArrayOf(0x1F6B6, 0x1F3FE, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 37, 20, false),
        GoogleEmoji(String(intArrayOf(0x1F6B6, 0x1F3FF, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 37, 21, false),
      ),
    ),
    GoogleEmoji(
      String(intArrayOf(0x1F9CD), 0, 1), listOf("standing_person"), 46, 32, false,
      variants = listOf(
        GoogleEmoji(String(intArrayOf(0x1F9CD, 0x1F3FB), 0, 2), emptyList<String>(), 46, 33, false),
        GoogleEmoji(String(intArrayOf(0x1F9CD, 0x1F3FC), 0, 2), emptyList<String>(), 46, 34, false),
        GoogleEmoji(String(intArrayOf(0x1F9CD, 0x1F3FD), 0, 2), emptyList<String>(), 46, 35, false),
        GoogleEmoji(String(intArrayOf(0x1F9CD, 0x1F3FE), 0, 2), emptyList<String>(), 46, 36, false),
        GoogleEmoji(String(intArrayOf(0x1F9CD, 0x1F3FF), 0, 2), emptyList<String>(), 46, 37, false),
      ),
    ),
    GoogleEmoji(
      String(intArrayOf(0x1F9CD, 0x200D, 0x2642, 0xFE0F), 0, 4), listOf("man_standing"), 46, 26, false,
      variants = listOf(
        GoogleEmoji(String(intArrayOf(0x1F9CD, 0x1F3FB, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 46, 27, false),
        GoogleEmoji(String(intArrayOf(0x1F9CD, 0x1F3FC, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 46, 28, false),
        GoogleEmoji(String(intArrayOf(0x1F9CD, 0x1F3FD, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 46, 29, false),
        GoogleEmoji(String(intArrayOf(0x1F9CD, 0x1F3FE, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 46, 30, false),
        GoogleEmoji(String(intArrayOf(0x1F9CD, 0x1F3FF, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 46, 31, false),
      ),
    ),
    GoogleEmoji(
      String(intArrayOf(0x1F9CD, 0x200D, 0x2640, 0xFE0F), 0, 4), listOf("woman_standing"), 46, 20, false,
      variants = listOf(
        GoogleEmoji(String(intArrayOf(0x1F9CD, 0x1F3FB, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 46, 21, false),
        GoogleEmoji(String(intArrayOf(0x1F9CD, 0x1F3FC, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 46, 22, false),
        GoogleEmoji(String(intArrayOf(0x1F9CD, 0x1F3FD, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 46, 23, false),
        GoogleEmoji(String(intArrayOf(0x1F9CD, 0x1F3FE, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 46, 24, false),
        GoogleEmoji(String(intArrayOf(0x1F9CD, 0x1F3FF, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 46, 25, false),
      ),
    ),
    GoogleEmoji(
      String(intArrayOf(0x1F9CE), 0, 1), listOf("kneeling_person"), 46, 50, false,
      variants = listOf(
        GoogleEmoji(String(intArrayOf(0x1F9CE, 0x1F3FB), 0, 2), emptyList<String>(), 46, 51, false),
        GoogleEmoji(String(intArrayOf(0x1F9CE, 0x1F3FC), 0, 2), emptyList<String>(), 46, 52, false),
        GoogleEmoji(String(intArrayOf(0x1F9CE, 0x1F3FD), 0, 2), emptyList<String>(), 46, 53, false),
        GoogleEmoji(String(intArrayOf(0x1F9CE, 0x1F3FE), 0, 2), emptyList<String>(), 46, 54, false),
        GoogleEmoji(String(intArrayOf(0x1F9CE, 0x1F3FF), 0, 2), emptyList<String>(), 46, 55, false),
      ),
    ),
    GoogleEmoji(
      String(intArrayOf(0x1F9CE, 0x200D, 0x2642, 0xFE0F), 0, 4), listOf("man_kneeling"), 46, 44, false,
      variants = listOf(
        GoogleEmoji(String(intArrayOf(0x1F9CE, 0x1F3FB, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 46, 45, false),
        GoogleEmoji(String(intArrayOf(0x1F9CE, 0x1F3FC, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 46, 46, false),
        GoogleEmoji(String(intArrayOf(0x1F9CE, 0x1F3FD, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 46, 47, false),
        GoogleEmoji(String(intArrayOf(0x1F9CE, 0x1F3FE, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 46, 48, false),
        GoogleEmoji(String(intArrayOf(0x1F9CE, 0x1F3FF, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 46, 49, false),
      ),
    ),
    GoogleEmoji(
      String(intArrayOf(0x1F9CE, 0x200D, 0x2640, 0xFE0F), 0, 4), listOf("woman_kneeling"), 46, 38, false,
      variants = listOf(
        GoogleEmoji(String(intArrayOf(0x1F9CE, 0x1F3FB, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 46, 39, false),
        GoogleEmoji(String(intArrayOf(0x1F9CE, 0x1F3FC, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 46, 40, false),
        GoogleEmoji(String(intArrayOf(0x1F9CE, 0x1F3FD, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 46, 41, false),
        GoogleEmoji(String(intArrayOf(0x1F9CE, 0x1F3FE, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 46, 42, false),
        GoogleEmoji(String(intArrayOf(0x1F9CE, 0x1F3FF, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 46, 43, false),
      ),
    ),
    GoogleEmoji(
      String(intArrayOf(0x1F9D1, 0x200D, 0x1F9AF), 0, 3), listOf("person_with_probing_cane"), 49, 8, false,
      variants = listOf(
        GoogleEmoji(String(intArrayOf(0x1F9D1, 0x1F3FB, 0x200D, 0x1F9AF), 0, 4), emptyList<String>(), 49, 9, false),
        GoogleEmoji(String(intArrayOf(0x1F9D1, 0x1F3FC, 0x200D, 0x1F9AF), 0, 4), emptyList<String>(), 49, 10, false),
        GoogleEmoji(String(intArrayOf(0x1F9D1, 0x1F3FD, 0x200D, 0x1F9AF), 0, 4), emptyList<String>(), 49, 11, false),
        GoogleEmoji(String(intArrayOf(0x1F9D1, 0x1F3FE, 0x200D, 0x1F9AF), 0, 4), emptyList<String>(), 49, 12, false),
        GoogleEmoji(String(intArrayOf(0x1F9D1, 0x1F3FF, 0x200D, 0x1F9AF), 0, 4), emptyList<String>(), 49, 13, false),
      ),
    ),
    GoogleEmoji(
      String(intArrayOf(0x1F468, 0x200D, 0x1F9AF), 0, 3), listOf("man_with_probing_cane"), 15, 24, false,
      variants = listOf(
        GoogleEmoji(String(intArrayOf(0x1F468, 0x1F3FB, 0x200D, 0x1F9AF), 0, 4), emptyList<String>(), 15, 25, false),
        GoogleEmoji(String(intArrayOf(0x1F468, 0x1F3FC, 0x200D, 0x1F9AF), 0, 4), emptyList<String>(), 15, 26, false),
        GoogleEmoji(String(intArrayOf(0x1F468, 0x1F3FD, 0x200D, 0x1F9AF), 0, 4), emptyList<String>(), 15, 27, false),
        GoogleEmoji(String(intArrayOf(0x1F468, 0x1F3FE, 0x200D, 0x1F9AF), 0, 4), emptyList<String>(), 15, 28, false),
        GoogleEmoji(String(intArrayOf(0x1F468, 0x1F3FF, 0x200D, 0x1F9AF), 0, 4), emptyList<String>(), 15, 29, false),
      ),
    ),
    GoogleEmoji(
      String(intArrayOf(0x1F469, 0x200D, 0x1F9AF), 0, 3), listOf("woman_with_probing_cane"), 18, 53, false,
      variants = listOf(
        GoogleEmoji(String(intArrayOf(0x1F469, 0x1F3FB, 0x200D, 0x1F9AF), 0, 4), emptyList<String>(), 18, 54, false),
        GoogleEmoji(String(intArrayOf(0x1F469, 0x1F3FC, 0x200D, 0x1F9AF), 0, 4), emptyList<String>(), 18, 55, false),
        GoogleEmoji(String(intArrayOf(0x1F469, 0x1F3FD, 0x200D, 0x1F9AF), 0, 4), emptyList<String>(), 18, 56, false),
        GoogleEmoji(String(intArrayOf(0x1F469, 0x1F3FE, 0x200D, 0x1F9AF), 0, 4), emptyList<String>(), 18, 57, false),
        GoogleEmoji(String(intArrayOf(0x1F469, 0x1F3FF, 0x200D, 0x1F9AF), 0, 4), emptyList<String>(), 18, 58, false),
      ),
    ),
    GoogleEmoji(
      String(intArrayOf(0x1F9D1, 0x200D, 0x1F9BC), 0, 3), listOf("person_in_motorized_wheelchair"), 49, 38, false,
      variants = listOf(
        GoogleEmoji(String(intArrayOf(0x1F9D1, 0x1F3FB, 0x200D, 0x1F9BC), 0, 4), emptyList<String>(), 49, 39, false),
        GoogleEmoji(String(intArrayOf(0x1F9D1, 0x1F3FC, 0x200D, 0x1F9BC), 0, 4), emptyList<String>(), 49, 40, false),
        GoogleEmoji(String(intArrayOf(0x1F9D1, 0x1F3FD, 0x200D, 0x1F9BC), 0, 4), emptyList<String>(), 49, 41, false),
        GoogleEmoji(String(intArrayOf(0x1F9D1, 0x1F3FE, 0x200D, 0x1F9BC), 0, 4), emptyList<String>(), 49, 42, false),
        GoogleEmoji(String(intArrayOf(0x1F9D1, 0x1F3FF, 0x200D, 0x1F9BC), 0, 4), emptyList<String>(), 49, 43, false),
      ),
    ),
    GoogleEmoji(
      String(intArrayOf(0x1F468, 0x200D, 0x1F9BC), 0, 3), listOf("man_in_motorized_wheelchair"), 15, 54, false,
      variants = listOf(
        GoogleEmoji(String(intArrayOf(0x1F468, 0x1F3FB, 0x200D, 0x1F9BC), 0, 4), emptyList<String>(), 15, 55, false),
        GoogleEmoji(String(intArrayOf(0x1F468, 0x1F3FC, 0x200D, 0x1F9BC), 0, 4), emptyList<String>(), 15, 56, false),
        GoogleEmoji(String(intArrayOf(0x1F468, 0x1F3FD, 0x200D, 0x1F9BC), 0, 4), emptyList<String>(), 15, 57, false),
        GoogleEmoji(String(intArrayOf(0x1F468, 0x1F3FE, 0x200D, 0x1F9BC), 0, 4), emptyList<String>(), 15, 58, false),
        GoogleEmoji(String(intArrayOf(0x1F468, 0x1F3FF, 0x200D, 0x1F9BC), 0, 4), emptyList<String>(), 15, 59, false),
      ),
    ),
    GoogleEmoji(
      String(intArrayOf(0x1F469, 0x200D, 0x1F9BC), 0, 3), listOf("woman_in_motorized_wheelchair"), 19, 22, false,
      variants = listOf(
        GoogleEmoji(String(intArrayOf(0x1F469, 0x1F3FB, 0x200D, 0x1F9BC), 0, 4), emptyList<String>(), 19, 23, false),
        GoogleEmoji(String(intArrayOf(0x1F469, 0x1F3FC, 0x200D, 0x1F9BC), 0, 4), emptyList<String>(), 19, 24, false),
        GoogleEmoji(String(intArrayOf(0x1F469, 0x1F3FD, 0x200D, 0x1F9BC), 0, 4), emptyList<String>(), 19, 25, false),
        GoogleEmoji(String(intArrayOf(0x1F469, 0x1F3FE, 0x200D, 0x1F9BC), 0, 4), emptyList<String>(), 19, 26, false),
        GoogleEmoji(String(intArrayOf(0x1F469, 0x1F3FF, 0x200D, 0x1F9BC), 0, 4), emptyList<String>(), 19, 27, false),
      ),
    ),
    GoogleEmoji(
      String(intArrayOf(0x1F9D1, 0x200D, 0x1F9BD), 0, 3), listOf("person_in_manual_wheelchair"), 49, 44, false,
      variants = listOf(
        GoogleEmoji(String(intArrayOf(0x1F9D1, 0x1F3FB, 0x200D, 0x1F9BD), 0, 4), emptyList<String>(), 49, 45, false),
        GoogleEmoji(String(intArrayOf(0x1F9D1, 0x1F3FC, 0x200D, 0x1F9BD), 0, 4), emptyList<String>(), 49, 46, false),
        GoogleEmoji(String(intArrayOf(0x1F9D1, 0x1F3FD, 0x200D, 0x1F9BD), 0, 4), emptyList<String>(), 49, 47, false),
        GoogleEmoji(String(intArrayOf(0x1F9D1, 0x1F3FE, 0x200D, 0x1F9BD), 0, 4), emptyList<String>(), 49, 48, false),
        GoogleEmoji(String(intArrayOf(0x1F9D1, 0x1F3FF, 0x200D, 0x1F9BD), 0, 4), emptyList<String>(), 49, 49, false),
      ),
    ),
    GoogleEmoji(
      String(intArrayOf(0x1F468, 0x200D, 0x1F9BD), 0, 3), listOf("man_in_manual_wheelchair"), 15, 60, false,
      variants = listOf(
        GoogleEmoji(String(intArrayOf(0x1F468, 0x1F3FB, 0x200D, 0x1F9BD), 0, 4), emptyList<String>(), 16, 0, false),
        GoogleEmoji(String(intArrayOf(0x1F468, 0x1F3FC, 0x200D, 0x1F9BD), 0, 4), emptyList<String>(), 16, 1, false),
        GoogleEmoji(String(intArrayOf(0x1F468, 0x1F3FD, 0x200D, 0x1F9BD), 0, 4), emptyList<String>(), 16, 2, false),
        GoogleEmoji(String(intArrayOf(0x1F468, 0x1F3FE, 0x200D, 0x1F9BD), 0, 4), emptyList<String>(), 16, 3, false),
        GoogleEmoji(String(intArrayOf(0x1F468, 0x1F3FF, 0x200D, 0x1F9BD), 0, 4), emptyList<String>(), 16, 4, false),
      ),
    ),
    GoogleEmoji(
      String(intArrayOf(0x1F469, 0x200D, 0x1F9BD), 0, 3), listOf("woman_in_manual_wheelchair"), 19, 28, false,
      variants = listOf(
        GoogleEmoji(String(intArrayOf(0x1F469, 0x1F3FB, 0x200D, 0x1F9BD), 0, 4), emptyList<String>(), 19, 29, false),
        GoogleEmoji(String(intArrayOf(0x1F469, 0x1F3FC, 0x200D, 0x1F9BD), 0, 4), emptyList<String>(), 19, 30, false),
        GoogleEmoji(String(intArrayOf(0x1F469, 0x1F3FD, 0x200D, 0x1F9BD), 0, 4), emptyList<String>(), 19, 31, false),
        GoogleEmoji(String(intArrayOf(0x1F469, 0x1F3FE, 0x200D, 0x1F9BD), 0, 4), emptyList<String>(), 19, 32, false),
        GoogleEmoji(String(intArrayOf(0x1F469, 0x1F3FF, 0x200D, 0x1F9BD), 0, 4), emptyList<String>(), 19, 33, false),
      ),
    ),
    GoogleEmoji(
      String(intArrayOf(0x1F3C3), 0, 1), listOf("runner", "running"), 8, 26, true,
      variants = listOf(
        GoogleEmoji(String(intArrayOf(0x1F3C3, 0x1F3FB), 0, 2), emptyList<String>(), 8, 27, false),
        GoogleEmoji(String(intArrayOf(0x1F3C3, 0x1F3FC), 0, 2), emptyList<String>(), 8, 28, false),
        GoogleEmoji(String(intArrayOf(0x1F3C3, 0x1F3FD), 0, 2), emptyList<String>(), 8, 29, false),
        GoogleEmoji(String(intArrayOf(0x1F3C3, 0x1F3FE), 0, 2), emptyList<String>(), 8, 30, false),
        GoogleEmoji(String(intArrayOf(0x1F3C3, 0x1F3FF), 0, 2), emptyList<String>(), 8, 31, false),
      ),
    ),
    GoogleEmoji(
      String(intArrayOf(0x1F3C3, 0x200D, 0x2642, 0xFE0F), 0, 4), listOf("man-running"), 8, 20, false,
      variants = listOf(
        GoogleEmoji(String(intArrayOf(0x1F3C3, 0x1F3FB, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 8, 21, false),
        GoogleEmoji(String(intArrayOf(0x1F3C3, 0x1F3FC, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 8, 22, false),
        GoogleEmoji(String(intArrayOf(0x1F3C3, 0x1F3FD, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 8, 23, false),
        GoogleEmoji(String(intArrayOf(0x1F3C3, 0x1F3FE, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 8, 24, false),
        GoogleEmoji(String(intArrayOf(0x1F3C3, 0x1F3FF, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 8, 25, false),
      ),
    ),
    GoogleEmoji(
      String(intArrayOf(0x1F3C3, 0x200D, 0x2640, 0xFE0F), 0, 4), listOf("woman-running"), 8, 14, false,
      variants = listOf(
        GoogleEmoji(String(intArrayOf(0x1F3C3, 0x1F3FB, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 8, 15, false),
        GoogleEmoji(String(intArrayOf(0x1F3C3, 0x1F3FC, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 8, 16, false),
        GoogleEmoji(String(intArrayOf(0x1F3C3, 0x1F3FD, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 8, 17, false),
        GoogleEmoji(String(intArrayOf(0x1F3C3, 0x1F3FE, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 8, 18, false),
        GoogleEmoji(String(intArrayOf(0x1F3C3, 0x1F3FF, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 8, 19, false),
      ),
    ),
    GoogleEmoji(
      String(intArrayOf(0x1F483), 0, 1), listOf("dancer"), 25, 47, false,
      variants = listOf(
        GoogleEmoji(String(intArrayOf(0x1F483, 0x1F3FB), 0, 2), emptyList<String>(), 25, 48, false),
        GoogleEmoji(String(intArrayOf(0x1F483, 0x1F3FC), 0, 2), emptyList<String>(), 25, 49, false),
        GoogleEmoji(String(intArrayOf(0x1F483, 0x1F3FD), 0, 2), emptyList<String>(), 25, 50, false),
        GoogleEmoji(String(intArrayOf(0x1F483, 0x1F3FE), 0, 2), emptyList<String>(), 25, 51, false),
        GoogleEmoji(String(intArrayOf(0x1F483, 0x1F3FF), 0, 2), emptyList<String>(), 25, 52, false),
      ),
    ),
    GoogleEmoji(
      String(intArrayOf(0x1F57A), 0, 1), listOf("man_dancing"), 31, 27, false,
      variants = listOf(
        GoogleEmoji(String(intArrayOf(0x1F57A, 0x1F3FB), 0, 2), emptyList<String>(), 31, 28, false),
        GoogleEmoji(String(intArrayOf(0x1F57A, 0x1F3FC), 0, 2), emptyList<String>(), 31, 29, false),
        GoogleEmoji(String(intArrayOf(0x1F57A, 0x1F3FD), 0, 2), emptyList<String>(), 31, 30, false),
        GoogleEmoji(String(intArrayOf(0x1F57A, 0x1F3FE), 0, 2), emptyList<String>(), 31, 31, false),
        GoogleEmoji(String(intArrayOf(0x1F57A, 0x1F3FF), 0, 2), emptyList<String>(), 31, 32, false),
      ),
    ),
    GoogleEmoji(
      String(intArrayOf(0x1F574, 0xFE0F), 0, 2), listOf("man_in_business_suit_levitating"), 30, 60, false,
      variants = listOf(
        GoogleEmoji(String(intArrayOf(0x1F574, 0x1F3FB), 0, 2), emptyList<String>(), 31, 0, false),
        GoogleEmoji(String(intArrayOf(0x1F574, 0x1F3FC), 0, 2), emptyList<String>(), 31, 1, false),
        GoogleEmoji(String(intArrayOf(0x1F574, 0x1F3FD), 0, 2), emptyList<String>(), 31, 2, false),
        GoogleEmoji(String(intArrayOf(0x1F574, 0x1F3FE), 0, 2), emptyList<String>(), 31, 3, false),
        GoogleEmoji(String(intArrayOf(0x1F574, 0x1F3FF), 0, 2), emptyList<String>(), 31, 4, false),
      ),
    ),
    GoogleEmoji(String(intArrayOf(0x1F46F), 0, 1), listOf("dancers"), 23, 17, true),
    GoogleEmoji(String(intArrayOf(0x1F46F, 0x200D, 0x2642, 0xFE0F), 0, 4), listOf("men-with-bunny-ears-partying", "man-with-bunny-ears-partying"), 23, 16, false),
    GoogleEmoji(String(intArrayOf(0x1F46F, 0x200D, 0x2640, 0xFE0F), 0, 4), listOf("women-with-bunny-ears-partying", "woman-with-bunny-ears-partying"), 23, 15, false),
    GoogleEmoji(
      String(intArrayOf(0x1F9D6), 0, 1), listOf("person_in_steamy_room"), 51, 0, true,
      variants = listOf(
        GoogleEmoji(String(intArrayOf(0x1F9D6, 0x1F3FB), 0, 2), emptyList<String>(), 51, 1, true),
        GoogleEmoji(String(intArrayOf(0x1F9D6, 0x1F3FC), 0, 2), emptyList<String>(), 51, 2, true),
        GoogleEmoji(String(intArrayOf(0x1F9D6, 0x1F3FD), 0, 2), emptyList<String>(), 51, 3, true),
        GoogleEmoji(String(intArrayOf(0x1F9D6, 0x1F3FE), 0, 2), emptyList<String>(), 51, 4, true),
        GoogleEmoji(String(intArrayOf(0x1F9D6, 0x1F3FF), 0, 2), emptyList<String>(), 51, 5, true),
      ),
    ),
    GoogleEmoji(
      String(intArrayOf(0x1F9D6, 0x200D, 0x2642, 0xFE0F), 0, 4), listOf("man_in_steamy_room"), 50, 55, false,
      variants = listOf(
        GoogleEmoji(String(intArrayOf(0x1F9D6, 0x1F3FB, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 50, 56, false),
        GoogleEmoji(String(intArrayOf(0x1F9D6, 0x1F3FC, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 50, 57, false),
        GoogleEmoji(String(intArrayOf(0x1F9D6, 0x1F3FD, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 50, 58, false),
        GoogleEmoji(String(intArrayOf(0x1F9D6, 0x1F3FE, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 50, 59, false),
        GoogleEmoji(String(intArrayOf(0x1F9D6, 0x1F3FF, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 50, 60, false),
      ),
    ),
    GoogleEmoji(
      String(intArrayOf(0x1F9D6, 0x200D, 0x2640, 0xFE0F), 0, 4), listOf("woman_in_steamy_room"), 50, 49, false,
      variants = listOf(
        GoogleEmoji(String(intArrayOf(0x1F9D6, 0x1F3FB, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 50, 50, false),
        GoogleEmoji(String(intArrayOf(0x1F9D6, 0x1F3FC, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 50, 51, false),
        GoogleEmoji(String(intArrayOf(0x1F9D6, 0x1F3FD, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 50, 52, false),
        GoogleEmoji(String(intArrayOf(0x1F9D6, 0x1F3FE, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 50, 53, false),
        GoogleEmoji(String(intArrayOf(0x1F9D6, 0x1F3FF, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 50, 54, false),
      ),
    ),
    GoogleEmoji(
      String(intArrayOf(0x1F9D7), 0, 1), listOf("person_climbing"), 51, 18, true,
      variants = listOf(
        GoogleEmoji(String(intArrayOf(0x1F9D7, 0x1F3FB), 0, 2), emptyList<String>(), 51, 19, true),
        GoogleEmoji(String(intArrayOf(0x1F9D7, 0x1F3FC), 0, 2), emptyList<String>(), 51, 20, true),
        GoogleEmoji(String(intArrayOf(0x1F9D7, 0x1F3FD), 0, 2), emptyList<String>(), 51, 21, true),
        GoogleEmoji(String(intArrayOf(0x1F9D7, 0x1F3FE), 0, 2), emptyList<String>(), 51, 22, true),
        GoogleEmoji(String(intArrayOf(0x1F9D7, 0x1F3FF), 0, 2), emptyList<String>(), 51, 23, true),
      ),
    ),
    GoogleEmoji(
      String(intArrayOf(0x1F9D7, 0x200D, 0x2642, 0xFE0F), 0, 4), listOf("man_climbing"), 51, 12, false,
      variants = listOf(
        GoogleEmoji(String(intArrayOf(0x1F9D7, 0x1F3FB, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 51, 13, false),
        GoogleEmoji(String(intArrayOf(0x1F9D7, 0x1F3FC, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 51, 14, false),
        GoogleEmoji(String(intArrayOf(0x1F9D7, 0x1F3FD, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 51, 15, false),
        GoogleEmoji(String(intArrayOf(0x1F9D7, 0x1F3FE, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 51, 16, false),
        GoogleEmoji(String(intArrayOf(0x1F9D7, 0x1F3FF, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 51, 17, false),
      ),
    ),
    GoogleEmoji(
      String(intArrayOf(0x1F9D7, 0x200D, 0x2640, 0xFE0F), 0, 4), listOf("woman_climbing"), 51, 6, false,
      variants = listOf(
        GoogleEmoji(String(intArrayOf(0x1F9D7, 0x1F3FB, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 51, 7, false),
        GoogleEmoji(String(intArrayOf(0x1F9D7, 0x1F3FC, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 51, 8, false),
        GoogleEmoji(String(intArrayOf(0x1F9D7, 0x1F3FD, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 51, 9, false),
        GoogleEmoji(String(intArrayOf(0x1F9D7, 0x1F3FE, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 51, 10, false),
        GoogleEmoji(String(intArrayOf(0x1F9D7, 0x1F3FF, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 51, 11, false),
      ),
    ),
    GoogleEmoji(String(intArrayOf(0x1F93A), 0, 1), listOf("fencer"), 42, 33, false),
    GoogleEmoji(
      String(intArrayOf(0x1F3C7), 0, 1), listOf("horse_racing"), 8, 52, false,
      variants = listOf(
        GoogleEmoji(String(intArrayOf(0x1F3C7, 0x1F3FB), 0, 2), emptyList<String>(), 8, 53, false),
        GoogleEmoji(String(intArrayOf(0x1F3C7, 0x1F3FC), 0, 2), emptyList<String>(), 8, 54, false),
        GoogleEmoji(String(intArrayOf(0x1F3C7, 0x1F3FD), 0, 2), emptyList<String>(), 8, 55, false),
        GoogleEmoji(String(intArrayOf(0x1F3C7, 0x1F3FE), 0, 2), emptyList<String>(), 8, 56, false),
        GoogleEmoji(String(intArrayOf(0x1F3C7, 0x1F3FF), 0, 2), emptyList<String>(), 8, 57, false),
      ),
    ),
    GoogleEmoji(String(intArrayOf(0x26F7, 0xFE0F), 0, 2), listOf("skier"), 58, 32, false),
    GoogleEmoji(
      String(intArrayOf(0x1F3C2), 0, 1), listOf("snowboarder"), 8, 8, false,
      variants = listOf(
        GoogleEmoji(String(intArrayOf(0x1F3C2, 0x1F3FB), 0, 2), emptyList<String>(), 8, 9, false),
        GoogleEmoji(String(intArrayOf(0x1F3C2, 0x1F3FC), 0, 2), emptyList<String>(), 8, 10, false),
        GoogleEmoji(String(intArrayOf(0x1F3C2, 0x1F3FD), 0, 2), emptyList<String>(), 8, 11, false),
        GoogleEmoji(String(intArrayOf(0x1F3C2, 0x1F3FE), 0, 2), emptyList<String>(), 8, 12, false),
        GoogleEmoji(String(intArrayOf(0x1F3C2, 0x1F3FF), 0, 2), emptyList<String>(), 8, 13, false),
      ),
    ),
    GoogleEmoji(
      String(intArrayOf(0x1F3CC, 0xFE0F), 0, 2), listOf("golfer"), 9, 47, true,
      variants = listOf(
        GoogleEmoji(String(intArrayOf(0x1F3CC, 0x1F3FB), 0, 2), emptyList<String>(), 9, 48, false),
        GoogleEmoji(String(intArrayOf(0x1F3CC, 0x1F3FC), 0, 2), emptyList<String>(), 9, 49, false),
        GoogleEmoji(String(intArrayOf(0x1F3CC, 0x1F3FD), 0, 2), emptyList<String>(), 9, 50, false),
        GoogleEmoji(String(intArrayOf(0x1F3CC, 0x1F3FE), 0, 2), emptyList<String>(), 9, 51, false),
        GoogleEmoji(String(intArrayOf(0x1F3CC, 0x1F3FF), 0, 2), emptyList<String>(), 9, 52, false),
      ),
    ),
    GoogleEmoji(
      String(intArrayOf(0x1F3CC, 0xFE0F, 0x200D, 0x2642, 0xFE0F), 0, 5), listOf("man-golfing"), 9, 41, false,
      variants = listOf(
        GoogleEmoji(String(intArrayOf(0x1F3CC, 0x1F3FB, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 9, 42, false),
        GoogleEmoji(String(intArrayOf(0x1F3CC, 0x1F3FC, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 9, 43, false),
        GoogleEmoji(String(intArrayOf(0x1F3CC, 0x1F3FD, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 9, 44, false),
        GoogleEmoji(String(intArrayOf(0x1F3CC, 0x1F3FE, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 9, 45, false),
        GoogleEmoji(String(intArrayOf(0x1F3CC, 0x1F3FF, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 9, 46, false),
      ),
    ),
    GoogleEmoji(
      String(intArrayOf(0x1F3CC, 0xFE0F, 0x200D, 0x2640, 0xFE0F), 0, 5), listOf("woman-golfing"), 9, 35, false,
      variants = listOf(
        GoogleEmoji(String(intArrayOf(0x1F3CC, 0x1F3FB, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 9, 36, false),
        GoogleEmoji(String(intArrayOf(0x1F3CC, 0x1F3FC, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 9, 37, false),
        GoogleEmoji(String(intArrayOf(0x1F3CC, 0x1F3FD, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 9, 38, false),
        GoogleEmoji(String(intArrayOf(0x1F3CC, 0x1F3FE, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 9, 39, false),
        GoogleEmoji(String(intArrayOf(0x1F3CC, 0x1F3FF, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 9, 40, false),
      ),
    ),
    GoogleEmoji(
      String(intArrayOf(0x1F3C4), 0, 1), listOf("surfer"), 8, 44, true,
      variants = listOf(
        GoogleEmoji(String(intArrayOf(0x1F3C4, 0x1F3FB), 0, 2), emptyList<String>(), 8, 45, false),
        GoogleEmoji(String(intArrayOf(0x1F3C4, 0x1F3FC), 0, 2), emptyList<String>(), 8, 46, false),
        GoogleEmoji(String(intArrayOf(0x1F3C4, 0x1F3FD), 0, 2), emptyList<String>(), 8, 47, false),
        GoogleEmoji(String(intArrayOf(0x1F3C4, 0x1F3FE), 0, 2), emptyList<String>(), 8, 48, false),
        GoogleEmoji(String(intArrayOf(0x1F3C4, 0x1F3FF), 0, 2), emptyList<String>(), 8, 49, false),
      ),
    ),
    GoogleEmoji(
      String(intArrayOf(0x1F3C4, 0x200D, 0x2642, 0xFE0F), 0, 4), listOf("man-surfing"), 8, 38, false,
      variants = listOf(
        GoogleEmoji(String(intArrayOf(0x1F3C4, 0x1F3FB, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 8, 39, false),
        GoogleEmoji(String(intArrayOf(0x1F3C4, 0x1F3FC, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 8, 40, false),
        GoogleEmoji(String(intArrayOf(0x1F3C4, 0x1F3FD, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 8, 41, false),
        GoogleEmoji(String(intArrayOf(0x1F3C4, 0x1F3FE, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 8, 42, false),
        GoogleEmoji(String(intArrayOf(0x1F3C4, 0x1F3FF, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 8, 43, false),
      ),
    ),
    GoogleEmoji(
      String(intArrayOf(0x1F3C4, 0x200D, 0x2640, 0xFE0F), 0, 4), listOf("woman-surfing"), 8, 32, false,
      variants = listOf(
        GoogleEmoji(String(intArrayOf(0x1F3C4, 0x1F3FB, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 8, 33, false),
        GoogleEmoji(String(intArrayOf(0x1F3C4, 0x1F3FC, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 8, 34, false),
        GoogleEmoji(String(intArrayOf(0x1F3C4, 0x1F3FD, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 8, 35, false),
        GoogleEmoji(String(intArrayOf(0x1F3C4, 0x1F3FE, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 8, 36, false),
        GoogleEmoji(String(intArrayOf(0x1F3C4, 0x1F3FF, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 8, 37, false),
      ),
    ),
    GoogleEmoji(
      String(intArrayOf(0x1F6A3), 0, 1), listOf("rowboat"), 36, 19, true,
      variants = listOf(
        GoogleEmoji(String(intArrayOf(0x1F6A3, 0x1F3FB), 0, 2), emptyList<String>(), 36, 20, false),
        GoogleEmoji(String(intArrayOf(0x1F6A3, 0x1F3FC), 0, 2), emptyList<String>(), 36, 21, false),
        GoogleEmoji(String(intArrayOf(0x1F6A3, 0x1F3FD), 0, 2), emptyList<String>(), 36, 22, false),
        GoogleEmoji(String(intArrayOf(0x1F6A3, 0x1F3FE), 0, 2), emptyList<String>(), 36, 23, false),
        GoogleEmoji(String(intArrayOf(0x1F6A3, 0x1F3FF), 0, 2), emptyList<String>(), 36, 24, false),
      ),
    ),
    GoogleEmoji(
      String(intArrayOf(0x1F6A3, 0x200D, 0x2642, 0xFE0F), 0, 4), listOf("man-rowing-boat"), 36, 13, false,
      variants = listOf(
        GoogleEmoji(String(intArrayOf(0x1F6A3, 0x1F3FB, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 36, 14, false),
        GoogleEmoji(String(intArrayOf(0x1F6A3, 0x1F3FC, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 36, 15, false),
        GoogleEmoji(String(intArrayOf(0x1F6A3, 0x1F3FD, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 36, 16, false),
        GoogleEmoji(String(intArrayOf(0x1F6A3, 0x1F3FE, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 36, 17, false),
        GoogleEmoji(String(intArrayOf(0x1F6A3, 0x1F3FF, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 36, 18, false),
      ),
    ),
    GoogleEmoji(
      String(intArrayOf(0x1F6A3, 0x200D, 0x2640, 0xFE0F), 0, 4), listOf("woman-rowing-boat"), 36, 7, false,
      variants = listOf(
        GoogleEmoji(String(intArrayOf(0x1F6A3, 0x1F3FB, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 36, 8, false),
        GoogleEmoji(String(intArrayOf(0x1F6A3, 0x1F3FC, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 36, 9, false),
        GoogleEmoji(String(intArrayOf(0x1F6A3, 0x1F3FD, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 36, 10, false),
        GoogleEmoji(String(intArrayOf(0x1F6A3, 0x1F3FE, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 36, 11, false),
        GoogleEmoji(String(intArrayOf(0x1F6A3, 0x1F3FF, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 36, 12, false),
      ),
    ),
    GoogleEmoji(
      String(intArrayOf(0x1F3CA), 0, 1), listOf("swimmer"), 9, 11, true,
      variants = listOf(
        GoogleEmoji(String(intArrayOf(0x1F3CA, 0x1F3FB), 0, 2), emptyList<String>(), 9, 12, false),
        GoogleEmoji(String(intArrayOf(0x1F3CA, 0x1F3FC), 0, 2), emptyList<String>(), 9, 13, false),
        GoogleEmoji(String(intArrayOf(0x1F3CA, 0x1F3FD), 0, 2), emptyList<String>(), 9, 14, false),
        GoogleEmoji(String(intArrayOf(0x1F3CA, 0x1F3FE), 0, 2), emptyList<String>(), 9, 15, false),
        GoogleEmoji(String(intArrayOf(0x1F3CA, 0x1F3FF), 0, 2), emptyList<String>(), 9, 16, false),
      ),
    ),
    GoogleEmoji(
      String(intArrayOf(0x1F3CA, 0x200D, 0x2642, 0xFE0F), 0, 4), listOf("man-swimming"), 9, 5, false,
      variants = listOf(
        GoogleEmoji(String(intArrayOf(0x1F3CA, 0x1F3FB, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 9, 6, false),
        GoogleEmoji(String(intArrayOf(0x1F3CA, 0x1F3FC, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 9, 7, false),
        GoogleEmoji(String(intArrayOf(0x1F3CA, 0x1F3FD, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 9, 8, false),
        GoogleEmoji(String(intArrayOf(0x1F3CA, 0x1F3FE, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 9, 9, false),
        GoogleEmoji(String(intArrayOf(0x1F3CA, 0x1F3FF, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 9, 10, false),
      ),
    ),
    GoogleEmoji(
      String(intArrayOf(0x1F3CA, 0x200D, 0x2640, 0xFE0F), 0, 4), listOf("woman-swimming"), 8, 60, false,
      variants = listOf(
        GoogleEmoji(String(intArrayOf(0x1F3CA, 0x1F3FB, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 9, 0, false),
        GoogleEmoji(String(intArrayOf(0x1F3CA, 0x1F3FC, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 9, 1, false),
        GoogleEmoji(String(intArrayOf(0x1F3CA, 0x1F3FD, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 9, 2, false),
        GoogleEmoji(String(intArrayOf(0x1F3CA, 0x1F3FE, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 9, 3, false),
        GoogleEmoji(String(intArrayOf(0x1F3CA, 0x1F3FF, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 9, 4, false),
      ),
    ),
    GoogleEmoji(
      String(intArrayOf(0x26F9, 0xFE0F), 0, 2), listOf("person_with_ball"), 58, 46, true,
      variants = listOf(
        GoogleEmoji(String(intArrayOf(0x26F9, 0x1F3FB), 0, 2), emptyList<String>(), 58, 47, false),
        GoogleEmoji(String(intArrayOf(0x26F9, 0x1F3FC), 0, 2), emptyList<String>(), 58, 48, false),
        GoogleEmoji(String(intArrayOf(0x26F9, 0x1F3FD), 0, 2), emptyList<String>(), 58, 49, false),
        GoogleEmoji(String(intArrayOf(0x26F9, 0x1F3FE), 0, 2), emptyList<String>(), 58, 50, false),
        GoogleEmoji(String(intArrayOf(0x26F9, 0x1F3FF), 0, 2), emptyList<String>(), 58, 51, false),
      ),
    ),
    GoogleEmoji(
      String(intArrayOf(0x26F9, 0xFE0F, 0x200D, 0x2642, 0xFE0F), 0, 5), listOf("man-bouncing-ball"), 58, 40, false,
      variants = listOf(
        GoogleEmoji(String(intArrayOf(0x26F9, 0x1F3FB, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 58, 41, false),
        GoogleEmoji(String(intArrayOf(0x26F9, 0x1F3FC, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 58, 42, false),
        GoogleEmoji(String(intArrayOf(0x26F9, 0x1F3FD, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 58, 43, false),
        GoogleEmoji(String(intArrayOf(0x26F9, 0x1F3FE, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 58, 44, false),
        GoogleEmoji(String(intArrayOf(0x26F9, 0x1F3FF, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 58, 45, false),
      ),
    ),
    GoogleEmoji(
      String(intArrayOf(0x26F9, 0xFE0F, 0x200D, 0x2640, 0xFE0F), 0, 5), listOf("woman-bouncing-ball"), 58, 34, false,
      variants = listOf(
        GoogleEmoji(String(intArrayOf(0x26F9, 0x1F3FB, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 58, 35, false),
        GoogleEmoji(String(intArrayOf(0x26F9, 0x1F3FC, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 58, 36, false),
        GoogleEmoji(String(intArrayOf(0x26F9, 0x1F3FD, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 58, 37, false),
        GoogleEmoji(String(intArrayOf(0x26F9, 0x1F3FE, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 58, 38, false),
        GoogleEmoji(String(intArrayOf(0x26F9, 0x1F3FF, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 58, 39, false),
      ),
    ),
    GoogleEmoji(
      String(intArrayOf(0x1F3CB, 0xFE0F), 0, 2), listOf("weight_lifter"), 9, 29, true,
      variants = listOf(
        GoogleEmoji(String(intArrayOf(0x1F3CB, 0x1F3FB), 0, 2), emptyList<String>(), 9, 30, false),
        GoogleEmoji(String(intArrayOf(0x1F3CB, 0x1F3FC), 0, 2), emptyList<String>(), 9, 31, false),
        GoogleEmoji(String(intArrayOf(0x1F3CB, 0x1F3FD), 0, 2), emptyList<String>(), 9, 32, false),
        GoogleEmoji(String(intArrayOf(0x1F3CB, 0x1F3FE), 0, 2), emptyList<String>(), 9, 33, false),
        GoogleEmoji(String(intArrayOf(0x1F3CB, 0x1F3FF), 0, 2), emptyList<String>(), 9, 34, false),
      ),
    ),
    GoogleEmoji(
      String(intArrayOf(0x1F3CB, 0xFE0F, 0x200D, 0x2642, 0xFE0F), 0, 5), listOf("man-lifting-weights"), 9, 23, false,
      variants = listOf(
        GoogleEmoji(String(intArrayOf(0x1F3CB, 0x1F3FB, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 9, 24, false),
        GoogleEmoji(String(intArrayOf(0x1F3CB, 0x1F3FC, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 9, 25, false),
        GoogleEmoji(String(intArrayOf(0x1F3CB, 0x1F3FD, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 9, 26, false),
        GoogleEmoji(String(intArrayOf(0x1F3CB, 0x1F3FE, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 9, 27, false),
        GoogleEmoji(String(intArrayOf(0x1F3CB, 0x1F3FF, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 9, 28, false),
      ),
    ),
    GoogleEmoji(
      String(intArrayOf(0x1F3CB, 0xFE0F, 0x200D, 0x2640, 0xFE0F), 0, 5), listOf("woman-lifting-weights"), 9, 17, false,
      variants = listOf(
        GoogleEmoji(String(intArrayOf(0x1F3CB, 0x1F3FB, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 9, 18, false),
        GoogleEmoji(String(intArrayOf(0x1F3CB, 0x1F3FC, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 9, 19, false),
        GoogleEmoji(String(intArrayOf(0x1F3CB, 0x1F3FD, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 9, 20, false),
        GoogleEmoji(String(intArrayOf(0x1F3CB, 0x1F3FE, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 9, 21, false),
        GoogleEmoji(String(intArrayOf(0x1F3CB, 0x1F3FF, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 9, 22, false),
      ),
    ),
    GoogleEmoji(
      String(intArrayOf(0x1F6B4), 0, 1), listOf("bicyclist"), 36, 53, true,
      variants = listOf(
        GoogleEmoji(String(intArrayOf(0x1F6B4, 0x1F3FB), 0, 2), emptyList<String>(), 36, 54, false),
        GoogleEmoji(String(intArrayOf(0x1F6B4, 0x1F3FC), 0, 2), emptyList<String>(), 36, 55, false),
        GoogleEmoji(String(intArrayOf(0x1F6B4, 0x1F3FD), 0, 2), emptyList<String>(), 36, 56, false),
        GoogleEmoji(String(intArrayOf(0x1F6B4, 0x1F3FE), 0, 2), emptyList<String>(), 36, 57, false),
        GoogleEmoji(String(intArrayOf(0x1F6B4, 0x1F3FF), 0, 2), emptyList<String>(), 36, 58, false),
      ),
    ),
    GoogleEmoji(
      String(intArrayOf(0x1F6B4, 0x200D, 0x2642, 0xFE0F), 0, 4), listOf("man-biking"), 36, 47, false,
      variants = listOf(
        GoogleEmoji(String(intArrayOf(0x1F6B4, 0x1F3FB, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 36, 48, false),
        GoogleEmoji(String(intArrayOf(0x1F6B4, 0x1F3FC, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 36, 49, false),
        GoogleEmoji(String(intArrayOf(0x1F6B4, 0x1F3FD, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 36, 50, false),
        GoogleEmoji(String(intArrayOf(0x1F6B4, 0x1F3FE, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 36, 51, false),
        GoogleEmoji(String(intArrayOf(0x1F6B4, 0x1F3FF, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 36, 52, false),
      ),
    ),
    GoogleEmoji(
      String(intArrayOf(0x1F6B4, 0x200D, 0x2640, 0xFE0F), 0, 4), listOf("woman-biking"), 36, 41, false,
      variants = listOf(
        GoogleEmoji(String(intArrayOf(0x1F6B4, 0x1F3FB, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 36, 42, false),
        GoogleEmoji(String(intArrayOf(0x1F6B4, 0x1F3FC, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 36, 43, false),
        GoogleEmoji(String(intArrayOf(0x1F6B4, 0x1F3FD, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 36, 44, false),
        GoogleEmoji(String(intArrayOf(0x1F6B4, 0x1F3FE, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 36, 45, false),
        GoogleEmoji(String(intArrayOf(0x1F6B4, 0x1F3FF, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 36, 46, false),
      ),
    ),
    GoogleEmoji(
      String(intArrayOf(0x1F6B5), 0, 1), listOf("mountain_bicyclist"), 37, 10, true,
      variants = listOf(
        GoogleEmoji(String(intArrayOf(0x1F6B5, 0x1F3FB), 0, 2), emptyList<String>(), 37, 11, false),
        GoogleEmoji(String(intArrayOf(0x1F6B5, 0x1F3FC), 0, 2), emptyList<String>(), 37, 12, false),
        GoogleEmoji(String(intArrayOf(0x1F6B5, 0x1F3FD), 0, 2), emptyList<String>(), 37, 13, false),
        GoogleEmoji(String(intArrayOf(0x1F6B5, 0x1F3FE), 0, 2), emptyList<String>(), 37, 14, false),
        GoogleEmoji(String(intArrayOf(0x1F6B5, 0x1F3FF), 0, 2), emptyList<String>(), 37, 15, false),
      ),
    ),
    GoogleEmoji(
      String(intArrayOf(0x1F6B5, 0x200D, 0x2642, 0xFE0F), 0, 4), listOf("man-mountain-biking"), 37, 4, false,
      variants = listOf(
        GoogleEmoji(String(intArrayOf(0x1F6B5, 0x1F3FB, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 37, 5, false),
        GoogleEmoji(String(intArrayOf(0x1F6B5, 0x1F3FC, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 37, 6, false),
        GoogleEmoji(String(intArrayOf(0x1F6B5, 0x1F3FD, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 37, 7, false),
        GoogleEmoji(String(intArrayOf(0x1F6B5, 0x1F3FE, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 37, 8, false),
        GoogleEmoji(String(intArrayOf(0x1F6B5, 0x1F3FF, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 37, 9, false),
      ),
    ),
    GoogleEmoji(
      String(intArrayOf(0x1F6B5, 0x200D, 0x2640, 0xFE0F), 0, 4), listOf("woman-mountain-biking"), 36, 59, false,
      variants = listOf(
        GoogleEmoji(String(intArrayOf(0x1F6B5, 0x1F3FB, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 36, 60, false),
        GoogleEmoji(String(intArrayOf(0x1F6B5, 0x1F3FC, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 37, 0, false),
        GoogleEmoji(String(intArrayOf(0x1F6B5, 0x1F3FD, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 37, 1, false),
        GoogleEmoji(String(intArrayOf(0x1F6B5, 0x1F3FE, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 37, 2, false),
        GoogleEmoji(String(intArrayOf(0x1F6B5, 0x1F3FF, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 37, 3, false),
      ),
    ),
    GoogleEmoji(
      String(intArrayOf(0x1F938), 0, 1), listOf("person_doing_cartwheel"), 42, 9, true,
      variants = listOf(
        GoogleEmoji(String(intArrayOf(0x1F938, 0x1F3FB), 0, 2), emptyList<String>(), 42, 10, false),
        GoogleEmoji(String(intArrayOf(0x1F938, 0x1F3FC), 0, 2), emptyList<String>(), 42, 11, false),
        GoogleEmoji(String(intArrayOf(0x1F938, 0x1F3FD), 0, 2), emptyList<String>(), 42, 12, false),
        GoogleEmoji(String(intArrayOf(0x1F938, 0x1F3FE), 0, 2), emptyList<String>(), 42, 13, false),
        GoogleEmoji(String(intArrayOf(0x1F938, 0x1F3FF), 0, 2), emptyList<String>(), 42, 14, false),
      ),
    ),
    GoogleEmoji(
      String(intArrayOf(0x1F938, 0x200D, 0x2642, 0xFE0F), 0, 4), listOf("man-cartwheeling"), 42, 3, false,
      variants = listOf(
        GoogleEmoji(String(intArrayOf(0x1F938, 0x1F3FB, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 42, 4, false),
        GoogleEmoji(String(intArrayOf(0x1F938, 0x1F3FC, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 42, 5, false),
        GoogleEmoji(String(intArrayOf(0x1F938, 0x1F3FD, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 42, 6, false),
        GoogleEmoji(String(intArrayOf(0x1F938, 0x1F3FE, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 42, 7, false),
        GoogleEmoji(String(intArrayOf(0x1F938, 0x1F3FF, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 42, 8, false),
      ),
    ),
    GoogleEmoji(
      String(intArrayOf(0x1F938, 0x200D, 0x2640, 0xFE0F), 0, 4), listOf("woman-cartwheeling"), 41, 58, false,
      variants = listOf(
        GoogleEmoji(String(intArrayOf(0x1F938, 0x1F3FB, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 41, 59, false),
        GoogleEmoji(String(intArrayOf(0x1F938, 0x1F3FC, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 41, 60, false),
        GoogleEmoji(String(intArrayOf(0x1F938, 0x1F3FD, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 42, 0, false),
        GoogleEmoji(String(intArrayOf(0x1F938, 0x1F3FE, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 42, 1, false),
        GoogleEmoji(String(intArrayOf(0x1F938, 0x1F3FF, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 42, 2, false),
      ),
    ),
    GoogleEmoji(String(intArrayOf(0x1F93C), 0, 1), listOf("wrestlers"), 42, 36, true),
    GoogleEmoji(String(intArrayOf(0x1F93C, 0x200D, 0x2642, 0xFE0F), 0, 4), listOf("man-wrestling"), 42, 35, false),
    GoogleEmoji(String(intArrayOf(0x1F93C, 0x200D, 0x2640, 0xFE0F), 0, 4), listOf("woman-wrestling"), 42, 34, false),
    GoogleEmoji(
      String(intArrayOf(0x1F93D), 0, 1), listOf("water_polo"), 42, 49, true,
      variants = listOf(
        GoogleEmoji(String(intArrayOf(0x1F93D, 0x1F3FB), 0, 2), emptyList<String>(), 42, 50, false),
        GoogleEmoji(String(intArrayOf(0x1F93D, 0x1F3FC), 0, 2), emptyList<String>(), 42, 51, false),
        GoogleEmoji(String(intArrayOf(0x1F93D, 0x1F3FD), 0, 2), emptyList<String>(), 42, 52, false),
        GoogleEmoji(String(intArrayOf(0x1F93D, 0x1F3FE), 0, 2), emptyList<String>(), 42, 53, false),
        GoogleEmoji(String(intArrayOf(0x1F93D, 0x1F3FF), 0, 2), emptyList<String>(), 42, 54, false),
      ),
    ),
    GoogleEmoji(
      String(intArrayOf(0x1F93D, 0x200D, 0x2642, 0xFE0F), 0, 4), listOf("man-playing-water-polo"), 42, 43, false,
      variants = listOf(
        GoogleEmoji(String(intArrayOf(0x1F93D, 0x1F3FB, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 42, 44, false),
        GoogleEmoji(String(intArrayOf(0x1F93D, 0x1F3FC, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 42, 45, false),
        GoogleEmoji(String(intArrayOf(0x1F93D, 0x1F3FD, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 42, 46, false),
        GoogleEmoji(String(intArrayOf(0x1F93D, 0x1F3FE, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 42, 47, false),
        GoogleEmoji(String(intArrayOf(0x1F93D, 0x1F3FF, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 42, 48, false),
      ),
    ),
    GoogleEmoji(
      String(intArrayOf(0x1F93D, 0x200D, 0x2640, 0xFE0F), 0, 4), listOf("woman-playing-water-polo"), 42, 37, false,
      variants = listOf(
        GoogleEmoji(String(intArrayOf(0x1F93D, 0x1F3FB, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 42, 38, false),
        GoogleEmoji(String(intArrayOf(0x1F93D, 0x1F3FC, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 42, 39, false),
        GoogleEmoji(String(intArrayOf(0x1F93D, 0x1F3FD, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 42, 40, false),
        GoogleEmoji(String(intArrayOf(0x1F93D, 0x1F3FE, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 42, 41, false),
        GoogleEmoji(String(intArrayOf(0x1F93D, 0x1F3FF, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 42, 42, false),
      ),
    ),
    GoogleEmoji(
      String(intArrayOf(0x1F93E), 0, 1), listOf("handball"), 43, 6, true,
      variants = listOf(
        GoogleEmoji(String(intArrayOf(0x1F93E, 0x1F3FB), 0, 2), emptyList<String>(), 43, 7, false),
        GoogleEmoji(String(intArrayOf(0x1F93E, 0x1F3FC), 0, 2), emptyList<String>(), 43, 8, false),
        GoogleEmoji(String(intArrayOf(0x1F93E, 0x1F3FD), 0, 2), emptyList<String>(), 43, 9, false),
        GoogleEmoji(String(intArrayOf(0x1F93E, 0x1F3FE), 0, 2), emptyList<String>(), 43, 10, false),
        GoogleEmoji(String(intArrayOf(0x1F93E, 0x1F3FF), 0, 2), emptyList<String>(), 43, 11, false),
      ),
    ),
    GoogleEmoji(
      String(intArrayOf(0x1F93E, 0x200D, 0x2642, 0xFE0F), 0, 4), listOf("man-playing-handball"), 43, 0, false,
      variants = listOf(
        GoogleEmoji(String(intArrayOf(0x1F93E, 0x1F3FB, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 43, 1, false),
        GoogleEmoji(String(intArrayOf(0x1F93E, 0x1F3FC, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 43, 2, false),
        GoogleEmoji(String(intArrayOf(0x1F93E, 0x1F3FD, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 43, 3, false),
        GoogleEmoji(String(intArrayOf(0x1F93E, 0x1F3FE, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 43, 4, false),
        GoogleEmoji(String(intArrayOf(0x1F93E, 0x1F3FF, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 43, 5, false),
      ),
    ),
    GoogleEmoji(
      String(intArrayOf(0x1F93E, 0x200D, 0x2640, 0xFE0F), 0, 4), listOf("woman-playing-handball"), 42, 55, false,
      variants = listOf(
        GoogleEmoji(String(intArrayOf(0x1F93E, 0x1F3FB, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 42, 56, false),
        GoogleEmoji(String(intArrayOf(0x1F93E, 0x1F3FC, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 42, 57, false),
        GoogleEmoji(String(intArrayOf(0x1F93E, 0x1F3FD, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 42, 58, false),
        GoogleEmoji(String(intArrayOf(0x1F93E, 0x1F3FE, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 42, 59, false),
        GoogleEmoji(String(intArrayOf(0x1F93E, 0x1F3FF, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 42, 60, false),
      ),
    ),
    GoogleEmoji(
      String(intArrayOf(0x1F939), 0, 1), listOf("juggling"), 42, 27, true,
      variants = listOf(
        GoogleEmoji(String(intArrayOf(0x1F939, 0x1F3FB), 0, 2), emptyList<String>(), 42, 28, false),
        GoogleEmoji(String(intArrayOf(0x1F939, 0x1F3FC), 0, 2), emptyList<String>(), 42, 29, false),
        GoogleEmoji(String(intArrayOf(0x1F939, 0x1F3FD), 0, 2), emptyList<String>(), 42, 30, false),
        GoogleEmoji(String(intArrayOf(0x1F939, 0x1F3FE), 0, 2), emptyList<String>(), 42, 31, false),
        GoogleEmoji(String(intArrayOf(0x1F939, 0x1F3FF), 0, 2), emptyList<String>(), 42, 32, false),
      ),
    ),
    GoogleEmoji(
      String(intArrayOf(0x1F939, 0x200D, 0x2642, 0xFE0F), 0, 4), listOf("man-juggling"), 42, 21, false,
      variants = listOf(
        GoogleEmoji(String(intArrayOf(0x1F939, 0x1F3FB, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 42, 22, false),
        GoogleEmoji(String(intArrayOf(0x1F939, 0x1F3FC, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 42, 23, false),
        GoogleEmoji(String(intArrayOf(0x1F939, 0x1F3FD, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 42, 24, false),
        GoogleEmoji(String(intArrayOf(0x1F939, 0x1F3FE, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 42, 25, false),
        GoogleEmoji(String(intArrayOf(0x1F939, 0x1F3FF, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 42, 26, false),
      ),
    ),
  )
}
