/*
 * Copyright (C) 2016 - Niklas Baudy, Ruben Gees, Mario Đanić and contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.vanniktech.emoji.google.category

import com.vanniktech.emoji.google.GoogleEmoji

internal object SmileysAndPeopleCategoryChunk4 {
  internal val EMOJIS: List<GoogleEmoji> = listOf(
    GoogleEmoji(
      String(intArrayOf(0x1F939, 0x200D, 0x2640, 0xFE0F), 0, 4), listOf("woman-juggling"), 42, 15, false,
      variants = listOf(
        GoogleEmoji(String(intArrayOf(0x1F939, 0x1F3FB, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 42, 16, false),
        GoogleEmoji(String(intArrayOf(0x1F939, 0x1F3FC, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 42, 17, false),
        GoogleEmoji(String(intArrayOf(0x1F939, 0x1F3FD, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 42, 18, false),
        GoogleEmoji(String(intArrayOf(0x1F939, 0x1F3FE, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 42, 19, false),
        GoogleEmoji(String(intArrayOf(0x1F939, 0x1F3FF, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 42, 20, false),
      ),
    ),
    GoogleEmoji(
      String(intArrayOf(0x1F9D8), 0, 1), listOf("person_in_lotus_position"), 51, 36, true,
      variants = listOf(
        GoogleEmoji(String(intArrayOf(0x1F9D8, 0x1F3FB), 0, 2), emptyList<String>(), 51, 37, true),
        GoogleEmoji(String(intArrayOf(0x1F9D8, 0x1F3FC), 0, 2), emptyList<String>(), 51, 38, true),
        GoogleEmoji(String(intArrayOf(0x1F9D8, 0x1F3FD), 0, 2), emptyList<String>(), 51, 39, true),
        GoogleEmoji(String(intArrayOf(0x1F9D8, 0x1F3FE), 0, 2), emptyList<String>(), 51, 40, true),
        GoogleEmoji(String(intArrayOf(0x1F9D8, 0x1F3FF), 0, 2), emptyList<String>(), 51, 41, true),
      ),
    ),
    GoogleEmoji(
      String(intArrayOf(0x1F9D8, 0x200D, 0x2642, 0xFE0F), 0, 4), listOf("man_in_lotus_position"), 51, 30, false,
      variants = listOf(
        GoogleEmoji(String(intArrayOf(0x1F9D8, 0x1F3FB, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 51, 31, false),
        GoogleEmoji(String(intArrayOf(0x1F9D8, 0x1F3FC, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 51, 32, false),
        GoogleEmoji(String(intArrayOf(0x1F9D8, 0x1F3FD, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 51, 33, false),
        GoogleEmoji(String(intArrayOf(0x1F9D8, 0x1F3FE, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 51, 34, false),
        GoogleEmoji(String(intArrayOf(0x1F9D8, 0x1F3FF, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 51, 35, false),
      ),
    ),
    GoogleEmoji(
      String(intArrayOf(0x1F9D8, 0x200D, 0x2640, 0xFE0F), 0, 4), listOf("woman_in_lotus_position"), 51, 24, false,
      variants = listOf(
        GoogleEmoji(String(intArrayOf(0x1F9D8, 0x1F3FB, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 51, 25, false),
        GoogleEmoji(String(intArrayOf(0x1F9D8, 0x1F3FC, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 51, 26, false),
        GoogleEmoji(String(intArrayOf(0x1F9D8, 0x1F3FD, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 51, 27, false),
        GoogleEmoji(String(intArrayOf(0x1F9D8, 0x1F3FE, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 51, 28, false),
        GoogleEmoji(String(intArrayOf(0x1F9D8, 0x1F3FF, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 51, 29, false),
      ),
    ),
    GoogleEmoji(
      String(intArrayOf(0x1F6C0), 0, 1), listOf("bath"), 37, 43, false,
      variants = listOf(
        GoogleEmoji(String(intArrayOf(0x1F6C0, 0x1F3FB), 0, 2), emptyList<String>(), 37, 44, false),
        GoogleEmoji(String(intArrayOf(0x1F6C0, 0x1F3FC), 0, 2), emptyList<String>(), 37, 45, false),
        GoogleEmoji(String(intArrayOf(0x1F6C0, 0x1F3FD), 0, 2), emptyList<String>(), 37, 46, false),
        GoogleEmoji(String(intArrayOf(0x1F6C0, 0x1F3FE), 0, 2), emptyList<String>(), 37, 47, false),
        GoogleEmoji(String(intArrayOf(0x1F6C0, 0x1F3FF), 0, 2), emptyList<String>(), 37, 48, false),
      ),
    ),
    GoogleEmoji(
      String(intArrayOf(0x1F6CC), 0, 1), listOf("sleeping_accommodation"), 37, 55, false,
      variants = listOf(
        GoogleEmoji(String(intArrayOf(0x1F6CC, 0x1F3FB), 0, 2), emptyList<String>(), 37, 56, false),
        GoogleEmoji(String(intArrayOf(0x1F6CC, 0x1F3FC), 0, 2), emptyList<String>(), 37, 57, false),
        GoogleEmoji(String(intArrayOf(0x1F6CC, 0x1F3FD), 0, 2), emptyList<String>(), 37, 58, false),
        GoogleEmoji(String(intArrayOf(0x1F6CC, 0x1F3FE), 0, 2), emptyList<String>(), 37, 59, false),
        GoogleEmoji(String(intArrayOf(0x1F6CC, 0x1F3FF), 0, 2), emptyList<String>(), 37, 60, false),
      ),
    ),
    GoogleEmoji(
      String(intArrayOf(0x1F9D1, 0x200D, 0x1F91D, 0x200D, 0x1F9D1), 0, 5), listOf("people_holding_hands"), 48, 43, false,
      variants = listOf(
        GoogleEmoji(String(intArrayOf(0x1F9D1, 0x1F3FB, 0x200D, 0x1F91D, 0x200D, 0x1F9D1, 0x1F3FB), 0, 7), emptyList<String>(), 48, 44, false),
        GoogleEmoji(String(intArrayOf(0x1F9D1, 0x1F3FB, 0x200D, 0x1F91D, 0x200D, 0x1F9D1, 0x1F3FC), 0, 7), emptyList<String>(), 48, 45, false),
        GoogleEmoji(String(intArrayOf(0x1F9D1, 0x1F3FB, 0x200D, 0x1F91D, 0x200D, 0x1F9D1, 0x1F3FD), 0, 7), emptyList<String>(), 48, 46, false),
        GoogleEmoji(String(intArrayOf(0x1F9D1, 0x1F3FB, 0x200D, 0x1F91D, 0x200D, 0x1F9D1, 0x1F3FE), 0, 7), emptyList<String>(), 48, 47, false),
        GoogleEmoji(String(intArrayOf(0x1F9D1, 0x1F3FB, 0x200D, 0x1F91D, 0x200D, 0x1F9D1, 0x1F3FF), 0, 7), emptyList<String>(), 48, 48, false),
        GoogleEmoji(String(intArrayOf(0x1F9D1, 0x1F3FC, 0x200D, 0x1F91D, 0x200D, 0x1F9D1, 0x1F3FB), 0, 7), emptyList<String>(), 48, 49, false),
        GoogleEmoji(String(intArrayOf(0x1F9D1, 0x1F3FC, 0x200D, 0x1F91D, 0x200D, 0x1F9D1, 0x1F3FC), 0, 7), emptyList<String>(), 48, 50, false),
        GoogleEmoji(String(intArrayOf(0x1F9D1, 0x1F3FC, 0x200D, 0x1F91D, 0x200D, 0x1F9D1, 0x1F3FD), 0, 7), emptyList<String>(), 48, 51, false),
        GoogleEmoji(String(intArrayOf(0x1F9D1, 0x1F3FC, 0x200D, 0x1F91D, 0x200D, 0x1F9D1, 0x1F3FE), 0, 7), emptyList<String>(), 48, 52, false),
        GoogleEmoji(String(intArrayOf(0x1F9D1, 0x1F3FC, 0x200D, 0x1F91D, 0x200D, 0x1F9D1, 0x1F3FF), 0, 7), emptyList<String>(), 48, 53, false),
        GoogleEmoji(String(intArrayOf(0x1F9D1, 0x1F3FD, 0x200D, 0x1F91D, 0x200D, 0x1F9D1, 0x1F3FB), 0, 7), emptyList<String>(), 48, 54, false),
        GoogleEmoji(String(intArrayOf(0x1F9D1, 0x1F3FD, 0x200D, 0x1F91D, 0x200D, 0x1F9D1, 0x1F3FC), 0, 7), emptyList<String>(), 48, 55, false),
        GoogleEmoji(String(intArrayOf(0x1F9D1, 0x1F3FD, 0x200D, 0x1F91D, 0x200D, 0x1F9D1, 0x1F3FD), 0, 7), emptyList<String>(), 48, 56, false),
        GoogleEmoji(String(intArrayOf(0x1F9D1, 0x1F3FD, 0x200D, 0x1F91D, 0x200D, 0x1F9D1, 0x1F3FE), 0, 7), emptyList<String>(), 48, 57, false),
        GoogleEmoji(String(intArrayOf(0x1F9D1, 0x1F3FD, 0x200D, 0x1F91D, 0x200D, 0x1F9D1, 0x1F3FF), 0, 7), emptyList<String>(), 48, 58, false),
        GoogleEmoji(String(intArrayOf(0x1F9D1, 0x1F3FE, 0x200D, 0x1F91D, 0x200D, 0x1F9D1, 0x1F3FB), 0, 7), emptyList<String>(), 48, 59, false),
        GoogleEmoji(String(intArrayOf(0x1F9D1, 0x1F3FE, 0x200D, 0x1F91D, 0x200D, 0x1F9D1, 0x1F3FC), 0, 7), emptyList<String>(), 48, 60, false),
        GoogleEmoji(String(intArrayOf(0x1F9D1, 0x1F3FE, 0x200D, 0x1F91D, 0x200D, 0x1F9D1, 0x1F3FD), 0, 7), emptyList<String>(), 49, 0, false),
        GoogleEmoji(String(intArrayOf(0x1F9D1, 0x1F3FE, 0x200D, 0x1F91D, 0x200D, 0x1F9D1, 0x1F3FE), 0, 7), emptyList<String>(), 49, 1, false),
        GoogleEmoji(String(intArrayOf(0x1F9D1, 0x1F3FE, 0x200D, 0x1F91D, 0x200D, 0x1F9D1, 0x1F3FF), 0, 7), emptyList<String>(), 49, 2, false),
        GoogleEmoji(String(intArrayOf(0x1F9D1, 0x1F3FF, 0x200D, 0x1F91D, 0x200D, 0x1F9D1, 0x1F3FB), 0, 7), emptyList<String>(), 49, 3, false),
        GoogleEmoji(String(intArrayOf(0x1F9D1, 0x1F3FF, 0x200D, 0x1F91D, 0x200D, 0x1F9D1, 0x1F3FC), 0, 7), emptyList<String>(), 49, 4, false),
        GoogleEmoji(String(intArrayOf(0x1F9D1, 0x1F3FF, 0x200D, 0x1F91D, 0x200D, 0x1F9D1, 0x1F3FD), 0, 7), emptyList<String>(), 49, 5, false),
        GoogleEmoji(String(intArrayOf(0x1F9D1, 0x1F3FF, 0x200D, 0x1F91D, 0x200D, 0x1F9D1, 0x1F3FE), 0, 7), emptyList<String>(), 49, 6, false),
        GoogleEmoji(String(intArrayOf(0x1F9D1, 0x1F3FF, 0x200D, 0x1F91D, 0x200D, 0x1F9D1, 0x1F3FF), 0, 7), emptyList<String>(), 49, 7, false),
      ),
    ),
    GoogleEmoji(
      String(intArrayOf(0x1F46D), 0, 1), listOf("two_women_holding_hands", "women_holding_hands"), 22, 32, false,
      variants = listOf(
        GoogleEmoji(String(intArrayOf(0x1F46D, 0x1F3FB), 0, 2), emptyList<String>(), 22, 33, false),
        GoogleEmoji(String(intArrayOf(0x1F46D, 0x1F3FC), 0, 2), emptyList<String>(), 22, 34, false),
        GoogleEmoji(String(intArrayOf(0x1F46D, 0x1F3FD), 0, 2), emptyList<String>(), 22, 35, false),
        GoogleEmoji(String(intArrayOf(0x1F46D, 0x1F3FE), 0, 2), emptyList<String>(), 22, 36, false),
        GoogleEmoji(String(intArrayOf(0x1F46D, 0x1F3FF), 0, 2), emptyList<String>(), 22, 37, false),
        GoogleEmoji(String(intArrayOf(0x1F469, 0x1F3FB, 0x200D, 0x1F91D, 0x200D, 0x1F469, 0x1F3FC), 0, 7), emptyList<String>(), 22, 38, false),
        GoogleEmoji(String(intArrayOf(0x1F469, 0x1F3FB, 0x200D, 0x1F91D, 0x200D, 0x1F469, 0x1F3FD), 0, 7), emptyList<String>(), 22, 39, false),
        GoogleEmoji(String(intArrayOf(0x1F469, 0x1F3FB, 0x200D, 0x1F91D, 0x200D, 0x1F469, 0x1F3FE), 0, 7), emptyList<String>(), 22, 40, false),
        GoogleEmoji(String(intArrayOf(0x1F469, 0x1F3FB, 0x200D, 0x1F91D, 0x200D, 0x1F469, 0x1F3FF), 0, 7), emptyList<String>(), 22, 41, false),
        GoogleEmoji(String(intArrayOf(0x1F469, 0x1F3FC, 0x200D, 0x1F91D, 0x200D, 0x1F469, 0x1F3FB), 0, 7), emptyList<String>(), 22, 42, false),
        GoogleEmoji(String(intArrayOf(0x1F469, 0x1F3FC, 0x200D, 0x1F91D, 0x200D, 0x1F469, 0x1F3FD), 0, 7), emptyList<String>(), 22, 43, false),
        GoogleEmoji(String(intArrayOf(0x1F469, 0x1F3FC, 0x200D, 0x1F91D, 0x200D, 0x1F469, 0x1F3FE), 0, 7), emptyList<String>(), 22, 44, false),
        GoogleEmoji(String(intArrayOf(0x1F469, 0x1F3FC, 0x200D, 0x1F91D, 0x200D, 0x1F469, 0x1F3FF), 0, 7), emptyList<String>(), 22, 45, false),
        GoogleEmoji(String(intArrayOf(0x1F469, 0x1F3FD, 0x200D, 0x1F91D, 0x200D, 0x1F469, 0x1F3FB), 0, 7), emptyList<String>(), 22, 46, false),
        GoogleEmoji(String(intArrayOf(0x1F469, 0x1F3FD, 0x200D, 0x1F91D, 0x200D, 0x1F469, 0x1F3FC), 0, 7), emptyList<String>(), 22, 47, false),
        GoogleEmoji(String(intArrayOf(0x1F469, 0x1F3FD, 0x200D, 0x1F91D, 0x200D, 0x1F469, 0x1F3FE), 0, 7), emptyList<String>(), 22, 48, false),
        GoogleEmoji(String(intArrayOf(0x1F469, 0x1F3FD, 0x200D, 0x1F91D, 0x200D, 0x1F469, 0x1F3FF), 0, 7), emptyList<String>(), 22, 49, false),
        GoogleEmoji(String(intArrayOf(0x1F469, 0x1F3FE, 0x200D, 0x1F91D, 0x200D, 0x1F469, 0x1F3FB), 0, 7), emptyList<String>(), 22, 50, false),
        GoogleEmoji(String(intArrayOf(0x1F469, 0x1F3FE, 0x200D, 0x1F91D, 0x200D, 0x1F469, 0x1F3FC), 0, 7), emptyList<String>(), 22, 51, false),
        GoogleEmoji(String(intArrayOf(0x1F469, 0x1F3FE, 0x200D, 0x1F91D, 0x200D, 0x1F469, 0x1F3FD), 0, 7), emptyList<String>(), 22, 52, false),
        GoogleEmoji(String(intArrayOf(0x1F469, 0x1F3FE, 0x200D, 0x1F91D, 0x200D, 0x1F469, 0x1F3FF), 0, 7), emptyList<String>(), 22, 53, false),
        GoogleEmoji(String(intArrayOf(0x1F469, 0x1F3FF, 0x200D, 0x1F91D, 0x200D, 0x1F469, 0x1F3FB), 0, 7), emptyList<String>(), 22, 54, false),
        GoogleEmoji(String(intArrayOf(0x1F469, 0x1F3FF, 0x200D, 0x1F91D, 0x200D, 0x1F469, 0x1F3FC), 0, 7), emptyList<String>(), 22, 55, false),
        GoogleEmoji(String(intArrayOf(0x1F469, 0x1F3FF, 0x200D, 0x1F91D, 0x200D, 0x1F469, 0x1F3FD), 0, 7), emptyList<String>(), 22, 56, false),
        GoogleEmoji(String(intArrayOf(0x1F469, 0x1F3FF, 0x200D, 0x1F91D, 0x200D, 0x1F469, 0x1F3FE), 0, 7), emptyList<String>(), 22, 57, false),
      ),
    ),
    GoogleEmoji(
      String(intArrayOf(0x1F46B), 0, 1), listOf("man_and_woman_holding_hands", "woman_and_man_holding_hands", "couple"), 21, 41, false,
      variants = listOf(
        GoogleEmoji(String(intArrayOf(0x1F46B, 0x1F3FB), 0, 2), emptyList<String>(), 21, 42, false),
        GoogleEmoji(String(intArrayOf(0x1F46B, 0x1F3FC), 0, 2), emptyList<String>(), 21, 43, false),
        GoogleEmoji(String(intArrayOf(0x1F46B, 0x1F3FD), 0, 2), emptyList<String>(), 21, 44, false),
        GoogleEmoji(String(intArrayOf(0x1F46B, 0x1F3FE), 0, 2), emptyList<String>(), 21, 45, false),
        GoogleEmoji(String(intArrayOf(0x1F46B, 0x1F3FF), 0, 2), emptyList<String>(), 21, 46, false),
        GoogleEmoji(String(intArrayOf(0x1F469, 0x1F3FB, 0x200D, 0x1F91D, 0x200D, 0x1F468, 0x1F3FC), 0, 7), emptyList<String>(), 21, 47, false),
        GoogleEmoji(String(intArrayOf(0x1F469, 0x1F3FB, 0x200D, 0x1F91D, 0x200D, 0x1F468, 0x1F3FD), 0, 7), emptyList<String>(), 21, 48, false),
        GoogleEmoji(String(intArrayOf(0x1F469, 0x1F3FB, 0x200D, 0x1F91D, 0x200D, 0x1F468, 0x1F3FE), 0, 7), emptyList<String>(), 21, 49, false),
        GoogleEmoji(String(intArrayOf(0x1F469, 0x1F3FB, 0x200D, 0x1F91D, 0x200D, 0x1F468, 0x1F3FF), 0, 7), emptyList<String>(), 21, 50, false),
        GoogleEmoji(String(intArrayOf(0x1F469, 0x1F3FC, 0x200D, 0x1F91D, 0x200D, 0x1F468, 0x1F3FB), 0, 7), emptyList<String>(), 21, 51, false),
        GoogleEmoji(String(intArrayOf(0x1F469, 0x1F3FC, 0x200D, 0x1F91D, 0x200D, 0x1F468, 0x1F3FD), 0, 7), emptyList<String>(), 21, 52, false),
        GoogleEmoji(String(intArrayOf(0x1F469, 0x1F3FC, 0x200D, 0x1F91D, 0x200D, 0x1F468, 0x1F3FE), 0, 7), emptyList<String>(), 21, 53, false),
        GoogleEmoji(String(intArrayOf(0x1F469, 0x1F3FC, 0x200D, 0x1F91D, 0x200D, 0x1F468, 0x1F3FF), 0, 7), emptyList<String>(), 21, 54, false),
        GoogleEmoji(String(intArrayOf(0x1F469, 0x1F3FD, 0x200D, 0x1F91D, 0x200D, 0x1F468, 0x1F3FB), 0, 7), emptyList<String>(), 21, 55, false),
        GoogleEmoji(String(intArrayOf(0x1F469, 0x1F3FD, 0x200D, 0x1F91D, 0x200D, 0x1F468, 0x1F3FC), 0, 7), emptyList<String>(), 21, 56, false),
        GoogleEmoji(String(intArrayOf(0x1F469, 0x1F3FD, 0x200D, 0x1F91D, 0x200D, 0x1F468, 0x1F3FE), 0, 7), emptyList<String>(), 21, 57, false),
        GoogleEmoji(String(intArrayOf(0x1F469, 0x1F3FD, 0x200D, 0x1F91D, 0x200D, 0x1F468, 0x1F3FF), 0, 7), emptyList<String>(), 21, 58, false),
        GoogleEmoji(String(intArrayOf(0x1F469, 0x1F3FE, 0x200D, 0x1F91D, 0x200D, 0x1F468, 0x1F3FB), 0, 7), emptyList<String>(), 21, 59, false),
        GoogleEmoji(String(intArrayOf(0x1F469, 0x1F3FE, 0x200D, 0x1F91D, 0x200D, 0x1F468, 0x1F3FC), 0, 7), emptyList<String>(), 21, 60, false),
        GoogleEmoji(String(intArrayOf(0x1F469, 0x1F3FE, 0x200D, 0x1F91D, 0x200D, 0x1F468, 0x1F3FD), 0, 7), emptyList<String>(), 22, 0, false),
        GoogleEmoji(String(intArrayOf(0x1F469, 0x1F3FE, 0x200D, 0x1F91D, 0x200D, 0x1F468, 0x1F3FF), 0, 7), emptyList<String>(), 22, 1, false),
        GoogleEmoji(String(intArrayOf(0x1F469, 0x1F3FF, 0x200D, 0x1F91D, 0x200D, 0x1F468, 0x1F3FB), 0, 7), emptyList<String>(), 22, 2, false),
        GoogleEmoji(String(intArrayOf(0x1F469, 0x1F3FF, 0x200D, 0x1F91D, 0x200D, 0x1F468, 0x1F3FC), 0, 7), emptyList<String>(), 22, 3, false),
        GoogleEmoji(String(intArrayOf(0x1F469, 0x1F3FF, 0x200D, 0x1F91D, 0x200D, 0x1F468, 0x1F3FD), 0, 7), emptyList<String>(), 22, 4, false),
        GoogleEmoji(String(intArrayOf(0x1F469, 0x1F3FF, 0x200D, 0x1F91D, 0x200D, 0x1F468, 0x1F3FE), 0, 7), emptyList<String>(), 22, 5, false),
      ),
    ),
    GoogleEmoji(
      String(intArrayOf(0x1F46C), 0, 1), listOf("two_men_holding_hands", "men_holding_hands"), 22, 6, false,
      variants = listOf(
        GoogleEmoji(String(intArrayOf(0x1F46C, 0x1F3FB), 0, 2), emptyList<String>(), 22, 7, false),
        GoogleEmoji(String(intArrayOf(0x1F46C, 0x1F3FC), 0, 2), emptyList<String>(), 22, 8, false),
        GoogleEmoji(String(intArrayOf(0x1F46C, 0x1F3FD), 0, 2), emptyList<String>(), 22, 9, false),
        GoogleEmoji(String(intArrayOf(0x1F46C, 0x1F3FE), 0, 2), emptyList<String>(), 22, 10, false),
        GoogleEmoji(String(intArrayOf(0x1F46C, 0x1F3FF), 0, 2), emptyList<String>(), 22, 11, false),
        GoogleEmoji(String(intArrayOf(0x1F468, 0x1F3FB, 0x200D, 0x1F91D, 0x200D, 0x1F468, 0x1F3FC), 0, 7), emptyList<String>(), 22, 12, false),
        GoogleEmoji(String(intArrayOf(0x1F468, 0x1F3FB, 0x200D, 0x1F91D, 0x200D, 0x1F468, 0x1F3FD), 0, 7), emptyList<String>(), 22, 13, false),
        GoogleEmoji(String(intArrayOf(0x1F468, 0x1F3FB, 0x200D, 0x1F91D, 0x200D, 0x1F468, 0x1F3FE), 0, 7), emptyList<String>(), 22, 14, false),
        GoogleEmoji(String(intArrayOf(0x1F468, 0x1F3FB, 0x200D, 0x1F91D, 0x200D, 0x1F468, 0x1F3FF), 0, 7), emptyList<String>(), 22, 15, false),
        GoogleEmoji(String(intArrayOf(0x1F468, 0x1F3FC, 0x200D, 0x1F91D, 0x200D, 0x1F468, 0x1F3FB), 0, 7), emptyList<String>(), 22, 16, false),
        GoogleEmoji(String(intArrayOf(0x1F468, 0x1F3FC, 0x200D, 0x1F91D, 0x200D, 0x1F468, 0x1F3FD), 0, 7), emptyList<String>(), 22, 17, false),
        GoogleEmoji(String(intArrayOf(0x1F468, 0x1F3FC, 0x200D, 0x1F91D, 0x200D, 0x1F468, 0x1F3FE), 0, 7), emptyList<String>(), 22, 18, false),
        GoogleEmoji(String(intArrayOf(0x1F468, 0x1F3FC, 0x200D, 0x1F91D, 0x200D, 0x1F468, 0x1F3FF), 0, 7), emptyList<String>(), 22, 19, false),
        GoogleEmoji(String(intArrayOf(0x1F468, 0x1F3FD, 0x200D, 0x1F91D, 0x200D, 0x1F468, 0x1F3FB), 0, 7), emptyList<String>(), 22, 20, false),
        GoogleEmoji(String(intArrayOf(0x1F468, 0x1F3FD, 0x200D, 0x1F91D, 0x200D, 0x1F468, 0x1F3FC), 0, 7), emptyList<String>(), 22, 21, false),
        GoogleEmoji(String(intArrayOf(0x1F468, 0x1F3FD, 0x200D, 0x1F91D, 0x200D, 0x1F468, 0x1F3FE), 0, 7), emptyList<String>(), 22, 22, false),
        GoogleEmoji(String(intArrayOf(0x1F468, 0x1F3FD, 0x200D, 0x1F91D, 0x200D, 0x1F468, 0x1F3FF), 0, 7), emptyList<String>(), 22, 23, false),
        GoogleEmoji(String(intArrayOf(0x1F468, 0x1F3FE, 0x200D, 0x1F91D, 0x200D, 0x1F468, 0x1F3FB), 0, 7), emptyList<String>(), 22, 24, false),
        GoogleEmoji(String(intArrayOf(0x1F468, 0x1F3FE, 0x200D, 0x1F91D, 0x200D, 0x1F468, 0x1F3FC), 0, 7), emptyList<String>(), 22, 25, false),
        GoogleEmoji(String(intArrayOf(0x1F468, 0x1F3FE, 0x200D, 0x1F91D, 0x200D, 0x1F468, 0x1F3FD), 0, 7), emptyList<String>(), 22, 26, false),
        GoogleEmoji(String(intArrayOf(0x1F468, 0x1F3FE, 0x200D, 0x1F91D, 0x200D, 0x1F468, 0x1F3FF), 0, 7), emptyList<String>(), 22, 27, false),
        GoogleEmoji(String(intArrayOf(0x1F468, 0x1F3FF, 0x200D, 0x1F91D, 0x200D, 0x1F468, 0x1F3FB), 0, 7), emptyList<String>(), 22, 28, false),
        GoogleEmoji(String(intArrayOf(0x1F468, 0x1F3FF, 0x200D, 0x1F91D, 0x200D, 0x1F468, 0x1F3FC), 0, 7), emptyList<String>(), 22, 29, false),
        GoogleEmoji(String(intArrayOf(0x1F468, 0x1F3FF, 0x200D, 0x1F91D, 0x200D, 0x1F468, 0x1F3FD), 0, 7), emptyList<String>(), 22, 30, false),
        GoogleEmoji(String(intArrayOf(0x1F468, 0x1F3FF, 0x200D, 0x1F91D, 0x200D, 0x1F468, 0x1F3FE), 0, 7), emptyList<String>(), 22, 31, false),
      ),
    ),
    GoogleEmoji(
      String(intArrayOf(0x1F48F), 0, 1), listOf("couplekiss"), 26, 42, false,
      variants = listOf(
        GoogleEmoji(String(intArrayOf(0x1F48F, 0x1F3FB), 0, 2), emptyList<String>(), 26, 43, false),
        GoogleEmoji(String(intArrayOf(0x1F48F, 0x1F3FC), 0, 2), emptyList<String>(), 26, 44, false),
        GoogleEmoji(String(intArrayOf(0x1F48F, 0x1F3FD), 0, 2), emptyList<String>(), 26, 45, false),
        GoogleEmoji(String(intArrayOf(0x1F48F, 0x1F3FE), 0, 2), emptyList<String>(), 26, 46, false),
        GoogleEmoji(String(intArrayOf(0x1F48F, 0x1F3FF), 0, 2), emptyList<String>(), 26, 47, false),
        GoogleEmoji(String(intArrayOf(0x1F9D1, 0x1F3FB, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F9D1, 0x1F3FC), 0, 10), emptyList<String>(), 26, 48, false),
        GoogleEmoji(String(intArrayOf(0x1F9D1, 0x1F3FB, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F9D1, 0x1F3FD), 0, 10), emptyList<String>(), 26, 49, false),
        GoogleEmoji(String(intArrayOf(0x1F9D1, 0x1F3FB, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F9D1, 0x1F3FE), 0, 10), emptyList<String>(), 26, 50, false),
        GoogleEmoji(String(intArrayOf(0x1F9D1, 0x1F3FB, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F9D1, 0x1F3FF), 0, 10), emptyList<String>(), 26, 51, false),
        GoogleEmoji(String(intArrayOf(0x1F9D1, 0x1F3FC, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F9D1, 0x1F3FB), 0, 10), emptyList<String>(), 26, 52, false),
        GoogleEmoji(String(intArrayOf(0x1F9D1, 0x1F3FC, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F9D1, 0x1F3FD), 0, 10), emptyList<String>(), 26, 53, false),
        GoogleEmoji(String(intArrayOf(0x1F9D1, 0x1F3FC, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F9D1, 0x1F3FE), 0, 10), emptyList<String>(), 26, 54, false),
        GoogleEmoji(String(intArrayOf(0x1F9D1, 0x1F3FC, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F9D1, 0x1F3FF), 0, 10), emptyList<String>(), 26, 55, false),
        GoogleEmoji(String(intArrayOf(0x1F9D1, 0x1F3FD, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F9D1, 0x1F3FB), 0, 10), emptyList<String>(), 26, 56, false),
        GoogleEmoji(String(intArrayOf(0x1F9D1, 0x1F3FD, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F9D1, 0x1F3FC), 0, 10), emptyList<String>(), 26, 57, false),
        GoogleEmoji(String(intArrayOf(0x1F9D1, 0x1F3FD, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F9D1, 0x1F3FE), 0, 10), emptyList<String>(), 26, 58, false),
        GoogleEmoji(String(intArrayOf(0x1F9D1, 0x1F3FD, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F9D1, 0x1F3FF), 0, 10), emptyList<String>(), 26, 59, false),
        GoogleEmoji(String(intArrayOf(0x1F9D1, 0x1F3FE, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F9D1, 0x1F3FB), 0, 10), emptyList<String>(), 26, 60, false),
        GoogleEmoji(String(intArrayOf(0x1F9D1, 0x1F3FE, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F9D1, 0x1F3FC), 0, 10), emptyList<String>(), 27, 0, false),
        GoogleEmoji(String(intArrayOf(0x1F9D1, 0x1F3FE, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F9D1, 0x1F3FD), 0, 10), emptyList<String>(), 27, 1, false),
        GoogleEmoji(String(intArrayOf(0x1F9D1, 0x1F3FE, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F9D1, 0x1F3FF), 0, 10), emptyList<String>(), 27, 2, false),
        GoogleEmoji(String(intArrayOf(0x1F9D1, 0x1F3FF, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F9D1, 0x1F3FB), 0, 10), emptyList<String>(), 27, 3, false),
        GoogleEmoji(String(intArrayOf(0x1F9D1, 0x1F3FF, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F9D1, 0x1F3FC), 0, 10), emptyList<String>(), 27, 4, false),
        GoogleEmoji(String(intArrayOf(0x1F9D1, 0x1F3FF, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F9D1, 0x1F3FD), 0, 10), emptyList<String>(), 27, 5, false),
        GoogleEmoji(String(intArrayOf(0x1F9D1, 0x1F3FF, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F9D1, 0x1F3FE), 0, 10), emptyList<String>(), 27, 6, false),
      ),
    ),
    GoogleEmoji(
      String(intArrayOf(0x1F469, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F468), 0, 8), listOf("woman-kiss-man"), 20, 43, false,
      variants = listOf(
        GoogleEmoji(String(intArrayOf(0x1F469, 0x1F3FB, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F468, 0x1F3FB), 0, 10), emptyList<String>(), 20, 44, false),
        GoogleEmoji(String(intArrayOf(0x1F469, 0x1F3FB, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F468, 0x1F3FC), 0, 10), emptyList<String>(), 20, 45, false),
        GoogleEmoji(String(intArrayOf(0x1F469, 0x1F3FB, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F468, 0x1F3FD), 0, 10), emptyList<String>(), 20, 46, false),
        GoogleEmoji(String(intArrayOf(0x1F469, 0x1F3FB, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F468, 0x1F3FE), 0, 10), emptyList<String>(), 20, 47, false),
        GoogleEmoji(String(intArrayOf(0x1F469, 0x1F3FB, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F468, 0x1F3FF), 0, 10), emptyList<String>(), 20, 48, false),
        GoogleEmoji(String(intArrayOf(0x1F469, 0x1F3FC, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F468, 0x1F3FB), 0, 10), emptyList<String>(), 20, 49, false),
        GoogleEmoji(String(intArrayOf(0x1F469, 0x1F3FC, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F468, 0x1F3FC), 0, 10), emptyList<String>(), 20, 50, false),
        GoogleEmoji(String(intArrayOf(0x1F469, 0x1F3FC, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F468, 0x1F3FD), 0, 10), emptyList<String>(), 20, 51, false),
        GoogleEmoji(String(intArrayOf(0x1F469, 0x1F3FC, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F468, 0x1F3FE), 0, 10), emptyList<String>(), 20, 52, false),
        GoogleEmoji(String(intArrayOf(0x1F469, 0x1F3FC, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F468, 0x1F3FF), 0, 10), emptyList<String>(), 20, 53, false),
        GoogleEmoji(String(intArrayOf(0x1F469, 0x1F3FD, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F468, 0x1F3FB), 0, 10), emptyList<String>(), 20, 54, false),
        GoogleEmoji(String(intArrayOf(0x1F469, 0x1F3FD, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F468, 0x1F3FC), 0, 10), emptyList<String>(), 20, 55, false),
        GoogleEmoji(String(intArrayOf(0x1F469, 0x1F3FD, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F468, 0x1F3FD), 0, 10), emptyList<String>(), 20, 56, false),
        GoogleEmoji(String(intArrayOf(0x1F469, 0x1F3FD, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F468, 0x1F3FE), 0, 10), emptyList<String>(), 20, 57, false),
        GoogleEmoji(String(intArrayOf(0x1F469, 0x1F3FD, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F468, 0x1F3FF), 0, 10), emptyList<String>(), 20, 58, false),
        GoogleEmoji(String(intArrayOf(0x1F469, 0x1F3FE, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F468, 0x1F3FB), 0, 10), emptyList<String>(), 20, 59, false),
        GoogleEmoji(String(intArrayOf(0x1F469, 0x1F3FE, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F468, 0x1F3FC), 0, 10), emptyList<String>(), 20, 60, false),
        GoogleEmoji(String(intArrayOf(0x1F469, 0x1F3FE, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F468, 0x1F3FD), 0, 10), emptyList<String>(), 21, 0, false),
        GoogleEmoji(String(intArrayOf(0x1F469, 0x1F3FE, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F468, 0x1F3FE), 0, 10), emptyList<String>(), 21, 1, false),
        GoogleEmoji(String(intArrayOf(0x1F469, 0x1F3FE, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F468, 0x1F3FF), 0, 10), emptyList<String>(), 21, 2, false),
        GoogleEmoji(String(intArrayOf(0x1F469, 0x1F3FF, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F468, 0x1F3FB), 0, 10), emptyList<String>(), 21, 3, false),
        GoogleEmoji(String(intArrayOf(0x1F469, 0x1F3FF, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F468, 0x1F3FC), 0, 10), emptyList<String>(), 21, 4, false),
        GoogleEmoji(String(intArrayOf(0x1F469, 0x1F3FF, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F468, 0x1F3FD), 0, 10), emptyList<String>(), 21, 5, false),
        GoogleEmoji(String(intArrayOf(0x1F469, 0x1F3FF, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F468, 0x1F3FE), 0, 10), emptyList<String>(), 21, 6, false),
        GoogleEmoji(String(intArrayOf(0x1F469, 0x1F3FF, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F468, 0x1F3FF), 0, 10), emptyList<String>(), 21, 7, false),
      ),
    ),
    GoogleEmoji(
      String(intArrayOf(0x1F468, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F468), 0, 8), listOf("man-kiss-man"), 16, 49, false,
      variants = listOf(
        GoogleEmoji(String(intArrayOf(0x1F468, 0x1F3FB, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F468, 0x1F3FB), 0, 10), emptyList<String>(), 16, 50, false),
        GoogleEmoji(String(intArrayOf(0x1F468, 0x1F3FB, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F468, 0x1F3FC), 0, 10), emptyList<String>(), 16, 51, false),
        GoogleEmoji(String(intArrayOf(0x1F468, 0x1F3FB, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F468, 0x1F3FD), 0, 10), emptyList<String>(), 16, 52, false),
        GoogleEmoji(String(intArrayOf(0x1F468, 0x1F3FB, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F468, 0x1F3FE), 0, 10), emptyList<String>(), 16, 53, false),
        GoogleEmoji(String(intArrayOf(0x1F468, 0x1F3FB, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F468, 0x1F3FF), 0, 10), emptyList<String>(), 16, 54, false),
        GoogleEmoji(String(intArrayOf(0x1F468, 0x1F3FC, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F468, 0x1F3FB), 0, 10), emptyList<String>(), 16, 55, false),
        GoogleEmoji(String(intArrayOf(0x1F468, 0x1F3FC, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F468, 0x1F3FC), 0, 10), emptyList<String>(), 16, 56, false),
        GoogleEmoji(String(intArrayOf(0x1F468, 0x1F3FC, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F468, 0x1F3FD), 0, 10), emptyList<String>(), 16, 57, false),
        GoogleEmoji(String(intArrayOf(0x1F468, 0x1F3FC, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F468, 0x1F3FE), 0, 10), emptyList<String>(), 16, 58, false),
        GoogleEmoji(String(intArrayOf(0x1F468, 0x1F3FC, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F468, 0x1F3FF), 0, 10), emptyList<String>(), 16, 59, false),
        GoogleEmoji(String(intArrayOf(0x1F468, 0x1F3FD, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F468, 0x1F3FB), 0, 10), emptyList<String>(), 16, 60, false),
        GoogleEmoji(String(intArrayOf(0x1F468, 0x1F3FD, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F468, 0x1F3FC), 0, 10), emptyList<String>(), 17, 0, false),
        GoogleEmoji(String(intArrayOf(0x1F468, 0x1F3FD, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F468, 0x1F3FD), 0, 10), emptyList<String>(), 17, 1, false),
        GoogleEmoji(String(intArrayOf(0x1F468, 0x1F3FD, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F468, 0x1F3FE), 0, 10), emptyList<String>(), 17, 2, false),
        GoogleEmoji(String(intArrayOf(0x1F468, 0x1F3FD, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F468, 0x1F3FF), 0, 10), emptyList<String>(), 17, 3, false),
        GoogleEmoji(String(intArrayOf(0x1F468, 0x1F3FE, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F468, 0x1F3FB), 0, 10), emptyList<String>(), 17, 4, false),
        GoogleEmoji(String(intArrayOf(0x1F468, 0x1F3FE, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F468, 0x1F3FC), 0, 10), emptyList<String>(), 17, 5, false),
        GoogleEmoji(String(intArrayOf(0x1F468, 0x1F3FE, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F468, 0x1F3FD), 0, 10), emptyList<String>(), 17, 6, false),
        GoogleEmoji(String(intArrayOf(0x1F468, 0x1F3FE, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F468, 0x1F3FE), 0, 10), emptyList<String>(), 17, 7, false),
        GoogleEmoji(String(intArrayOf(0x1F468, 0x1F3FE, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F468, 0x1F3FF), 0, 10), emptyList<String>(), 17, 8, false),
        GoogleEmoji(String(intArrayOf(0x1F468, 0x1F3FF, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F468, 0x1F3FB), 0, 10), emptyList<String>(), 17, 9, false),
        GoogleEmoji(String(intArrayOf(0x1F468, 0x1F3FF, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F468, 0x1F3FC), 0, 10), emptyList<String>(), 17, 10, false),
        GoogleEmoji(String(intArrayOf(0x1F468, 0x1F3FF, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F468, 0x1F3FD), 0, 10), emptyList<String>(), 17, 11, false),
        GoogleEmoji(String(intArrayOf(0x1F468, 0x1F3FF, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F468, 0x1F3FE), 0, 10), emptyList<String>(), 17, 12, false),
        GoogleEmoji(String(intArrayOf(0x1F468, 0x1F3FF, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F468, 0x1F3FF), 0, 10), emptyList<String>(), 17, 13, false),
      ),
    ),
    GoogleEmoji(
      String(intArrayOf(0x1F469, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F469), 0, 8), listOf("woman-kiss-woman"), 21, 8, false,
      variants = listOf(
        GoogleEmoji(String(intArrayOf(0x1F469, 0x1F3FB, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F469, 0x1F3FB), 0, 10), emptyList<String>(), 21, 9, false),
        GoogleEmoji(String(intArrayOf(0x1F469, 0x1F3FB, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F469, 0x1F3FC), 0, 10), emptyList<String>(), 21, 10, false),
        GoogleEmoji(String(intArrayOf(0x1F469, 0x1F3FB, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F469, 0x1F3FD), 0, 10), emptyList<String>(), 21, 11, false),
        GoogleEmoji(String(intArrayOf(0x1F469, 0x1F3FB, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F469, 0x1F3FE), 0, 10), emptyList<String>(), 21, 12, false),
        GoogleEmoji(String(intArrayOf(0x1F469, 0x1F3FB, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F469, 0x1F3FF), 0, 10), emptyList<String>(), 21, 13, false),
        GoogleEmoji(String(intArrayOf(0x1F469, 0x1F3FC, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F469, 0x1F3FB), 0, 10), emptyList<String>(), 21, 14, false),
        GoogleEmoji(String(intArrayOf(0x1F469, 0x1F3FC, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F469, 0x1F3FC), 0, 10), emptyList<String>(), 21, 15, false),
        GoogleEmoji(String(intArrayOf(0x1F469, 0x1F3FC, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F469, 0x1F3FD), 0, 10), emptyList<String>(), 21, 16, false),
        GoogleEmoji(String(intArrayOf(0x1F469, 0x1F3FC, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F469, 0x1F3FE), 0, 10), emptyList<String>(), 21, 17, false),
        GoogleEmoji(String(intArrayOf(0x1F469, 0x1F3FC, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F469, 0x1F3FF), 0, 10), emptyList<String>(), 21, 18, false),
        GoogleEmoji(String(intArrayOf(0x1F469, 0x1F3FD, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F469, 0x1F3FB), 0, 10), emptyList<String>(), 21, 19, false),
        GoogleEmoji(String(intArrayOf(0x1F469, 0x1F3FD, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F469, 0x1F3FC), 0, 10), emptyList<String>(), 21, 20, false),
        GoogleEmoji(String(intArrayOf(0x1F469, 0x1F3FD, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F469, 0x1F3FD), 0, 10), emptyList<String>(), 21, 21, false),
        GoogleEmoji(String(intArrayOf(0x1F469, 0x1F3FD, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F469, 0x1F3FE), 0, 10), emptyList<String>(), 21, 22, false),
        GoogleEmoji(String(intArrayOf(0x1F469, 0x1F3FD, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F469, 0x1F3FF), 0, 10), emptyList<String>(), 21, 23, false),
        GoogleEmoji(String(intArrayOf(0x1F469, 0x1F3FE, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F469, 0x1F3FB), 0, 10), emptyList<String>(), 21, 24, false),
        GoogleEmoji(String(intArrayOf(0x1F469, 0x1F3FE, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F469, 0x1F3FC), 0, 10), emptyList<String>(), 21, 25, false),
        GoogleEmoji(String(intArrayOf(0x1F469, 0x1F3FE, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F469, 0x1F3FD), 0, 10), emptyList<String>(), 21, 26, false),
        GoogleEmoji(String(intArrayOf(0x1F469, 0x1F3FE, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F469, 0x1F3FE), 0, 10), emptyList<String>(), 21, 27, false),
        GoogleEmoji(String(intArrayOf(0x1F469, 0x1F3FE, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F469, 0x1F3FF), 0, 10), emptyList<String>(), 21, 28, false),
        GoogleEmoji(String(intArrayOf(0x1F469, 0x1F3FF, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F469, 0x1F3FB), 0, 10), emptyList<String>(), 21, 29, false),
        GoogleEmoji(String(intArrayOf(0x1F469, 0x1F3FF, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F469, 0x1F3FC), 0, 10), emptyList<String>(), 21, 30, false),
        GoogleEmoji(String(intArrayOf(0x1F469, 0x1F3FF, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F469, 0x1F3FD), 0, 10), emptyList<String>(), 21, 31, false),
        GoogleEmoji(String(intArrayOf(0x1F469, 0x1F3FF, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F469, 0x1F3FE), 0, 10), emptyList<String>(), 21, 32, false),
        GoogleEmoji(String(intArrayOf(0x1F469, 0x1F3FF, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F469, 0x1F3FF), 0, 10), emptyList<String>(), 21, 33, false),
      ),
    ),
    GoogleEmoji(
      String(intArrayOf(0x1F491), 0, 1), listOf("couple_with_heart"), 27, 8, false,
      variants = listOf(
        GoogleEmoji(String(intArrayOf(0x1F491, 0x1F3FB), 0, 2), emptyList<String>(), 27, 9, false),
        GoogleEmoji(String(intArrayOf(0x1F491, 0x1F3FC), 0, 2), emptyList<String>(), 27, 10, false),
        GoogleEmoji(String(intArrayOf(0x1F491, 0x1F3FD), 0, 2), emptyList<String>(), 27, 11, false),
        GoogleEmoji(String(intArrayOf(0x1F491, 0x1F3FE), 0, 2), emptyList<String>(), 27, 12, false),
        GoogleEmoji(String(intArrayOf(0x1F491, 0x1F3FF), 0, 2), emptyList<String>(), 27, 13, false),
        GoogleEmoji(String(intArrayOf(0x1F9D1, 0x1F3FB, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F9D1, 0x1F3FC), 0, 8), emptyList<String>(), 27, 14, false),
        GoogleEmoji(String(intArrayOf(0x1F9D1, 0x1F3FB, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F9D1, 0x1F3FD), 0, 8), emptyList<String>(), 27, 15, false),
        GoogleEmoji(String(intArrayOf(0x1F9D1, 0x1F3FB, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F9D1, 0x1F3FE), 0, 8), emptyList<String>(), 27, 16, false),
        GoogleEmoji(String(intArrayOf(0x1F9D1, 0x1F3FB, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F9D1, 0x1F3FF), 0, 8), emptyList<String>(), 27, 17, false),
        GoogleEmoji(String(intArrayOf(0x1F9D1, 0x1F3FC, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F9D1, 0x1F3FB), 0, 8), emptyList<String>(), 27, 18, false),
        GoogleEmoji(String(intArrayOf(0x1F9D1, 0x1F3FC, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F9D1, 0x1F3FD), 0, 8), emptyList<String>(), 27, 19, false),
        GoogleEmoji(String(intArrayOf(0x1F9D1, 0x1F3FC, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F9D1, 0x1F3FE), 0, 8), emptyList<String>(), 27, 20, false),
        GoogleEmoji(String(intArrayOf(0x1F9D1, 0x1F3FC, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F9D1, 0x1F3FF), 0, 8), emptyList<String>(), 27, 21, false),
        GoogleEmoji(String(intArrayOf(0x1F9D1, 0x1F3FD, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F9D1, 0x1F3FB), 0, 8), emptyList<String>(), 27, 22, false),
        GoogleEmoji(String(intArrayOf(0x1F9D1, 0x1F3FD, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F9D1, 0x1F3FC), 0, 8), emptyList<String>(), 27, 23, false),
        GoogleEmoji(String(intArrayOf(0x1F9D1, 0x1F3FD, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F9D1, 0x1F3FE), 0, 8), emptyList<String>(), 27, 24, false),
        GoogleEmoji(String(intArrayOf(0x1F9D1, 0x1F3FD, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F9D1, 0x1F3FF), 0, 8), emptyList<String>(), 27, 25, false),
        GoogleEmoji(String(intArrayOf(0x1F9D1, 0x1F3FE, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F9D1, 0x1F3FB), 0, 8), emptyList<String>(), 27, 26, false),
        GoogleEmoji(String(intArrayOf(0x1F9D1, 0x1F3FE, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F9D1, 0x1F3FC), 0, 8), emptyList<String>(), 27, 27, false),
        GoogleEmoji(String(intArrayOf(0x1F9D1, 0x1F3FE, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F9D1, 0x1F3FD), 0, 8), emptyList<String>(), 27, 28, false),
        GoogleEmoji(String(intArrayOf(0x1F9D1, 0x1F3FE, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F9D1, 0x1F3FF), 0, 8), emptyList<String>(), 27, 29, false),
        GoogleEmoji(String(intArrayOf(0x1F9D1, 0x1F3FF, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F9D1, 0x1F3FB), 0, 8), emptyList<String>(), 27, 30, false),
        GoogleEmoji(String(intArrayOf(0x1F9D1, 0x1F3FF, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F9D1, 0x1F3FC), 0, 8), emptyList<String>(), 27, 31, false),
        GoogleEmoji(String(intArrayOf(0x1F9D1, 0x1F3FF, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F9D1, 0x1F3FD), 0, 8), emptyList<String>(), 27, 32, false),
        GoogleEmoji(String(intArrayOf(0x1F9D1, 0x1F3FF, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F9D1, 0x1F3FE), 0, 8), emptyList<String>(), 27, 33, false),
      ),
    ),
    GoogleEmoji(
      String(intArrayOf(0x1F469, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F468), 0, 6), listOf("woman-heart-man"), 19, 52, false,
      variants = listOf(
        GoogleEmoji(String(intArrayOf(0x1F469, 0x1F3FB, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F468, 0x1F3FB), 0, 8), emptyList<String>(), 19, 53, false),
        GoogleEmoji(String(intArrayOf(0x1F469, 0x1F3FB, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F468, 0x1F3FC), 0, 8), emptyList<String>(), 19, 54, false),
        GoogleEmoji(String(intArrayOf(0x1F469, 0x1F3FB, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F468, 0x1F3FD), 0, 8), emptyList<String>(), 19, 55, false),
        GoogleEmoji(String(intArrayOf(0x1F469, 0x1F3FB, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F468, 0x1F3FE), 0, 8), emptyList<String>(), 19, 56, false),
        GoogleEmoji(String(intArrayOf(0x1F469, 0x1F3FB, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F468, 0x1F3FF), 0, 8), emptyList<String>(), 19, 57, false),
        GoogleEmoji(String(intArrayOf(0x1F469, 0x1F3FC, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F468, 0x1F3FB), 0, 8), emptyList<String>(), 19, 58, false),
        GoogleEmoji(String(intArrayOf(0x1F469, 0x1F3FC, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F468, 0x1F3FC), 0, 8), emptyList<String>(), 19, 59, false),
        GoogleEmoji(String(intArrayOf(0x1F469, 0x1F3FC, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F468, 0x1F3FD), 0, 8), emptyList<String>(), 19, 60, false),
        GoogleEmoji(String(intArrayOf(0x1F469, 0x1F3FC, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F468, 0x1F3FE), 0, 8), emptyList<String>(), 20, 0, false),
        GoogleEmoji(String(intArrayOf(0x1F469, 0x1F3FC, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F468, 0x1F3FF), 0, 8), emptyList<String>(), 20, 1, false),
        GoogleEmoji(String(intArrayOf(0x1F469, 0x1F3FD, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F468, 0x1F3FB), 0, 8), emptyList<String>(), 20, 2, false),
        GoogleEmoji(String(intArrayOf(0x1F469, 0x1F3FD, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F468, 0x1F3FC), 0, 8), emptyList<String>(), 20, 3, false),
        GoogleEmoji(String(intArrayOf(0x1F469, 0x1F3FD, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F468, 0x1F3FD), 0, 8), emptyList<String>(), 20, 4, false),
        GoogleEmoji(String(intArrayOf(0x1F469, 0x1F3FD, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F468, 0x1F3FE), 0, 8), emptyList<String>(), 20, 5, false),
        GoogleEmoji(String(intArrayOf(0x1F469, 0x1F3FD, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F468, 0x1F3FF), 0, 8), emptyList<String>(), 20, 6, false),
        GoogleEmoji(String(intArrayOf(0x1F469, 0x1F3FE, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F468, 0x1F3FB), 0, 8), emptyList<String>(), 20, 7, false),
        GoogleEmoji(String(intArrayOf(0x1F469, 0x1F3FE, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F468, 0x1F3FC), 0, 8), emptyList<String>(), 20, 8, false),
        GoogleEmoji(String(intArrayOf(0x1F469, 0x1F3FE, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F468, 0x1F3FD), 0, 8), emptyList<String>(), 20, 9, false),
        GoogleEmoji(String(intArrayOf(0x1F469, 0x1F3FE, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F468, 0x1F3FE), 0, 8), emptyList<String>(), 20, 10, false),
        GoogleEmoji(String(intArrayOf(0x1F469, 0x1F3FE, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F468, 0x1F3FF), 0, 8), emptyList<String>(), 20, 11, false),
        GoogleEmoji(String(intArrayOf(0x1F469, 0x1F3FF, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F468, 0x1F3FB), 0, 8), emptyList<String>(), 20, 12, false),
        GoogleEmoji(String(intArrayOf(0x1F469, 0x1F3FF, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F468, 0x1F3FC), 0, 8), emptyList<String>(), 20, 13, false),
        GoogleEmoji(String(intArrayOf(0x1F469, 0x1F3FF, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F468, 0x1F3FD), 0, 8), emptyList<String>(), 20, 14, false),
        GoogleEmoji(String(intArrayOf(0x1F469, 0x1F3FF, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F468, 0x1F3FE), 0, 8), emptyList<String>(), 20, 15, false),
        GoogleEmoji(String(intArrayOf(0x1F469, 0x1F3FF, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F468, 0x1F3FF), 0, 8), emptyList<String>(), 20, 16, false),
      ),
    ),
    GoogleEmoji(
      String(intArrayOf(0x1F468, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F468), 0, 6), listOf("man-heart-man"), 16, 23, false,
      variants = listOf(
        GoogleEmoji(String(intArrayOf(0x1F468, 0x1F3FB, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F468, 0x1F3FB), 0, 8), emptyList<String>(), 16, 24, false),
        GoogleEmoji(String(intArrayOf(0x1F468, 0x1F3FB, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F468, 0x1F3FC), 0, 8), emptyList<String>(), 16, 25, false),
        GoogleEmoji(String(intArrayOf(0x1F468, 0x1F3FB, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F468, 0x1F3FD), 0, 8), emptyList<String>(), 16, 26, false),
        GoogleEmoji(String(intArrayOf(0x1F468, 0x1F3FB, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F468, 0x1F3FE), 0, 8), emptyList<String>(), 16, 27, false),
        GoogleEmoji(String(intArrayOf(0x1F468, 0x1F3FB, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F468, 0x1F3FF), 0, 8), emptyList<String>(), 16, 28, false),
        GoogleEmoji(String(intArrayOf(0x1F468, 0x1F3FC, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F468, 0x1F3FB), 0, 8), emptyList<String>(), 16, 29, false),
        GoogleEmoji(String(intArrayOf(0x1F468, 0x1F3FC, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F468, 0x1F3FC), 0, 8), emptyList<String>(), 16, 30, false),
        GoogleEmoji(String(intArrayOf(0x1F468, 0x1F3FC, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F468, 0x1F3FD), 0, 8), emptyList<String>(), 16, 31, false),
        GoogleEmoji(String(intArrayOf(0x1F468, 0x1F3FC, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F468, 0x1F3FE), 0, 8), emptyList<String>(), 16, 32, false),
        GoogleEmoji(String(intArrayOf(0x1F468, 0x1F3FC, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F468, 0x1F3FF), 0, 8), emptyList<String>(), 16, 33, false),
        GoogleEmoji(String(intArrayOf(0x1F468, 0x1F3FD, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F468, 0x1F3FB), 0, 8), emptyList<String>(), 16, 34, false),
        GoogleEmoji(String(intArrayOf(0x1F468, 0x1F3FD, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F468, 0x1F3FC), 0, 8), emptyList<String>(), 16, 35, false),
        GoogleEmoji(String(intArrayOf(0x1F468, 0x1F3FD, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F468, 0x1F3FD), 0, 8), emptyList<String>(), 16, 36, false),
        GoogleEmoji(String(intArrayOf(0x1F468, 0x1F3FD, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F468, 0x1F3FE), 0, 8), emptyList<String>(), 16, 37, false),
        GoogleEmoji(String(intArrayOf(0x1F468, 0x1F3FD, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F468, 0x1F3FF), 0, 8), emptyList<String>(), 16, 38, false),
        GoogleEmoji(String(intArrayOf(0x1F468, 0x1F3FE, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F468, 0x1F3FB), 0, 8), emptyList<String>(), 16, 39, false),
        GoogleEmoji(String(intArrayOf(0x1F468, 0x1F3FE, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F468, 0x1F3FC), 0, 8), emptyList<String>(), 16, 40, false),
        GoogleEmoji(String(intArrayOf(0x1F468, 0x1F3FE, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F468, 0x1F3FD), 0, 8), emptyList<String>(), 16, 41, false),
        GoogleEmoji(String(intArrayOf(0x1F468, 0x1F3FE, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F468, 0x1F3FE), 0, 8), emptyList<String>(), 16, 42, false),
        GoogleEmoji(String(intArrayOf(0x1F468, 0x1F3FE, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F468, 0x1F3FF), 0, 8), emptyList<String>(), 16, 43, false),
        GoogleEmoji(String(intArrayOf(0x1F468, 0x1F3FF, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F468, 0x1F3FB), 0, 8), emptyList<String>(), 16, 44, false),
        GoogleEmoji(String(intArrayOf(0x1F468, 0x1F3FF, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F468, 0x1F3FC), 0, 8), emptyList<String>(), 16, 45, false),
        GoogleEmoji(String(intArrayOf(0x1F468, 0x1F3FF, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F468, 0x1F3FD), 0, 8), emptyList<String>(), 16, 46, false),
        GoogleEmoji(String(intArrayOf(0x1F468, 0x1F3FF, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F468, 0x1F3FE), 0, 8), emptyList<String>(), 16, 47, false),
        GoogleEmoji(String(intArrayOf(0x1F468, 0x1F3FF, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F468, 0x1F3FF), 0, 8), emptyList<String>(), 16, 48, false),
      ),
    ),
    GoogleEmoji(
      String(intArrayOf(0x1F469, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F469), 0, 6), listOf("woman-heart-woman"), 20, 17, false,
      variants = listOf(
        GoogleEmoji(String(intArrayOf(0x1F469, 0x1F3FB, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F469, 0x1F3FB), 0, 8), emptyList<String>(), 20, 18, false),
        GoogleEmoji(String(intArrayOf(0x1F469, 0x1F3FB, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F469, 0x1F3FC), 0, 8), emptyList<String>(), 20, 19, false),
        GoogleEmoji(String(intArrayOf(0x1F469, 0x1F3FB, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F469, 0x1F3FD), 0, 8), emptyList<String>(), 20, 20, false),
        GoogleEmoji(String(intArrayOf(0x1F469, 0x1F3FB, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F469, 0x1F3FE), 0, 8), emptyList<String>(), 20, 21, false),
        GoogleEmoji(String(intArrayOf(0x1F469, 0x1F3FB, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F469, 0x1F3FF), 0, 8), emptyList<String>(), 20, 22, false),
        GoogleEmoji(String(intArrayOf(0x1F469, 0x1F3FC, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F469, 0x1F3FB), 0, 8), emptyList<String>(), 20, 23, false),
        GoogleEmoji(String(intArrayOf(0x1F469, 0x1F3FC, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F469, 0x1F3FC), 0, 8), emptyList<String>(), 20, 24, false),
        GoogleEmoji(String(intArrayOf(0x1F469, 0x1F3FC, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F469, 0x1F3FD), 0, 8), emptyList<String>(), 20, 25, false),
        GoogleEmoji(String(intArrayOf(0x1F469, 0x1F3FC, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F469, 0x1F3FE), 0, 8), emptyList<String>(), 20, 26, false),
        GoogleEmoji(String(intArrayOf(0x1F469, 0x1F3FC, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F469, 0x1F3FF), 0, 8), emptyList<String>(), 20, 27, false),
        GoogleEmoji(String(intArrayOf(0x1F469, 0x1F3FD, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F469, 0x1F3FB), 0, 8), emptyList<String>(), 20, 28, false),
        GoogleEmoji(String(intArrayOf(0x1F469, 0x1F3FD, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F469, 0x1F3FC), 0, 8), emptyList<String>(), 20, 29, false),
        GoogleEmoji(String(intArrayOf(0x1F469, 0x1F3FD, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F469, 0x1F3FD), 0, 8), emptyList<String>(), 20, 30, false),
        GoogleEmoji(String(intArrayOf(0x1F469, 0x1F3FD, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F469, 0x1F3FE), 0, 8), emptyList<String>(), 20, 31, false),
        GoogleEmoji(String(intArrayOf(0x1F469, 0x1F3FD, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F469, 0x1F3FF), 0, 8), emptyList<String>(), 20, 32, false),
        GoogleEmoji(String(intArrayOf(0x1F469, 0x1F3FE, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F469, 0x1F3FB), 0, 8), emptyList<String>(), 20, 33, false),
        GoogleEmoji(String(intArrayOf(0x1F469, 0x1F3FE, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F469, 0x1F3FC), 0, 8), emptyList<String>(), 20, 34, false),
        GoogleEmoji(String(intArrayOf(0x1F469, 0x1F3FE, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F469, 0x1F3FD), 0, 8), emptyList<String>(), 20, 35, false),
        GoogleEmoji(String(intArrayOf(0x1F469, 0x1F3FE, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F469, 0x1F3FE), 0, 8), emptyList<String>(), 20, 36, false),
        GoogleEmoji(String(intArrayOf(0x1F469, 0x1F3FE, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F469, 0x1F3FF), 0, 8), emptyList<String>(), 20, 37, false),
        GoogleEmoji(String(intArrayOf(0x1F469, 0x1F3FF, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F469, 0x1F3FB), 0, 8), emptyList<String>(), 20, 38, false),
        GoogleEmoji(String(intArrayOf(0x1F469, 0x1F3FF, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F469, 0x1F3FC), 0, 8), emptyList<String>(), 20, 39, false),
        GoogleEmoji(String(intArrayOf(0x1F469, 0x1F3FF, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F469, 0x1F3FD), 0, 8), emptyList<String>(), 20, 40, false),
        GoogleEmoji(String(intArrayOf(0x1F469, 0x1F3FF, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F469, 0x1F3FE), 0, 8), emptyList<String>(), 20, 41, false),
        GoogleEmoji(String(intArrayOf(0x1F469, 0x1F3FF, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F469, 0x1F3FF), 0, 8), emptyList<String>(), 20, 42, false),
      ),
    ),
    GoogleEmoji(String(intArrayOf(0x1F46A), 0, 1), listOf("family"), 21, 40, true),
    GoogleEmoji(String(intArrayOf(0x1F468, 0x200D, 0x1F469, 0x200D, 0x1F466), 0, 5), listOf("man-woman-boy"), 14, 44, false),
    GoogleEmoji(String(intArrayOf(0x1F468, 0x200D, 0x1F469, 0x200D, 0x1F467), 0, 5), listOf("man-woman-girl"), 14, 46, false),
    GoogleEmoji(String(intArrayOf(0x1F468, 0x200D, 0x1F469, 0x200D, 0x1F467, 0x200D, 0x1F466), 0, 7), listOf("man-woman-girl-boy"), 14, 47, false),
    GoogleEmoji(String(intArrayOf(0x1F468, 0x200D, 0x1F469, 0x200D, 0x1F466, 0x200D, 0x1F466), 0, 7), listOf("man-woman-boy-boy"), 14, 45, false),
    GoogleEmoji(String(intArrayOf(0x1F468, 0x200D, 0x1F469, 0x200D, 0x1F467, 0x200D, 0x1F467), 0, 7), listOf("man-woman-girl-girl"), 14, 48, false),
    GoogleEmoji(String(intArrayOf(0x1F468, 0x200D, 0x1F468, 0x200D, 0x1F466), 0, 5), listOf("man-man-boy"), 14, 39, false),
    GoogleEmoji(String(intArrayOf(0x1F468, 0x200D, 0x1F468, 0x200D, 0x1F467), 0, 5), listOf("man-man-girl"), 14, 41, false),
    GoogleEmoji(String(intArrayOf(0x1F468, 0x200D, 0x1F468, 0x200D, 0x1F467, 0x200D, 0x1F466), 0, 7), listOf("man-man-girl-boy"), 14, 42, false),
    GoogleEmoji(String(intArrayOf(0x1F468, 0x200D, 0x1F468, 0x200D, 0x1F466, 0x200D, 0x1F466), 0, 7), listOf("man-man-boy-boy"), 14, 40, false),
    GoogleEmoji(String(intArrayOf(0x1F468, 0x200D, 0x1F468, 0x200D, 0x1F467, 0x200D, 0x1F467), 0, 7), listOf("man-man-girl-girl"), 14, 43, false),
    GoogleEmoji(String(intArrayOf(0x1F469, 0x200D, 0x1F469, 0x200D, 0x1F466), 0, 5), listOf("woman-woman-boy"), 18, 12, false),
    GoogleEmoji(String(intArrayOf(0x1F469, 0x200D, 0x1F469, 0x200D, 0x1F467), 0, 5), listOf("woman-woman-girl"), 18, 14, false),
    GoogleEmoji(String(intArrayOf(0x1F469, 0x200D, 0x1F469, 0x200D, 0x1F467, 0x200D, 0x1F466), 0, 7), listOf("woman-woman-girl-boy"), 18, 15, false),
    GoogleEmoji(String(intArrayOf(0x1F469, 0x200D, 0x1F469, 0x200D, 0x1F466, 0x200D, 0x1F466), 0, 7), listOf("woman-woman-boy-boy"), 18, 13, false),
    GoogleEmoji(String(intArrayOf(0x1F469, 0x200D, 0x1F469, 0x200D, 0x1F467, 0x200D, 0x1F467), 0, 7), listOf("woman-woman-girl-girl"), 18, 16, false),
    GoogleEmoji(String(intArrayOf(0x1F468, 0x200D, 0x1F466), 0, 3), listOf("man-boy"), 14, 35, false),
    GoogleEmoji(String(intArrayOf(0x1F468, 0x200D, 0x1F466, 0x200D, 0x1F466), 0, 5), listOf("man-boy-boy"), 14, 34, false),
    GoogleEmoji(String(intArrayOf(0x1F468, 0x200D, 0x1F467), 0, 3), listOf("man-girl"), 14, 38, false),
    GoogleEmoji(String(intArrayOf(0x1F468, 0x200D, 0x1F467, 0x200D, 0x1F466), 0, 5), listOf("man-girl-boy"), 14, 36, false),
    GoogleEmoji(String(intArrayOf(0x1F468, 0x200D, 0x1F467, 0x200D, 0x1F467), 0, 5), listOf("man-girl-girl"), 14, 37, false),
    GoogleEmoji(String(intArrayOf(0x1F469, 0x200D, 0x1F466), 0, 3), listOf("woman-boy"), 18, 8, false),
    GoogleEmoji(String(intArrayOf(0x1F469, 0x200D, 0x1F466, 0x200D, 0x1F466), 0, 5), listOf("woman-boy-boy"), 18, 7, false),
    GoogleEmoji(String(intArrayOf(0x1F469, 0x200D, 0x1F467), 0, 3), listOf("woman-girl"), 18, 11, false),
    GoogleEmoji(String(intArrayOf(0x1F469, 0x200D, 0x1F467, 0x200D, 0x1F466), 0, 5), listOf("woman-girl-boy"), 18, 9, false),
    GoogleEmoji(String(intArrayOf(0x1F469, 0x200D, 0x1F467, 0x200D, 0x1F467), 0, 5), listOf("woman-girl-girl"), 18, 10, false),
    GoogleEmoji(String(intArrayOf(0x1F5E3, 0xFE0F), 0, 2), listOf("speaking_head_in_silhouette"), 32, 11, false),
    GoogleEmoji(String(intArrayOf(0x1F464), 0, 1), listOf("bust_in_silhouette"), 13, 33, false),
    GoogleEmoji(String(intArrayOf(0x1F465), 0, 1), listOf("busts_in_silhouette"), 13, 34, false),
    GoogleEmoji(String(intArrayOf(0x1FAC2), 0, 1), listOf("people_hugging"), 54, 58, false),
    GoogleEmoji(String(intArrayOf(0x1F463), 0, 1), listOf("footprints"), 13, 32, false),
  )
}
