/*
 * Copyright (C) 2016 - Niklas Baudy, Ruben Gees, Mario Đanić and contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */

package com.vanniktech.emoji.google.category;

import com.vanniktech.emoji.google.GoogleEmoji;

final class FlagsCategoryChunk1 {
  @SuppressWarnings("PMD.ExcessiveMethodLength") static GoogleEmoji[] get() {
    return new GoogleEmoji[] {
      new GoogleEmoji(new int[] { 0x1F1FB, 0x1F1E6 }, new String[]{"flag-va"}, 4, 46, false),
      new GoogleEmoji(new int[] { 0x1F1FB, 0x1F1E8 }, new String[]{"flag-vc"}, 4, 47, false),
      new GoogleEmoji(new int[] { 0x1F1FB, 0x1F1EA }, new String[]{"flag-ve"}, 4, 48, false),
      new GoogleEmoji(new int[] { 0x1F1FB, 0x1F1EC }, new String[]{"flag-vg"}, 4, 49, false),
      new GoogleEmoji(new int[] { 0x1F1FB, 0x1F1EE }, new String[]{"flag-vi"}, 4, 50, false),
      new GoogleEmoji(new int[] { 0x1F1FB, 0x1F1F3 }, new String[]{"flag-vn"}, 4, 51, false),
      new GoogleEmoji(new int[] { 0x1F1FB, 0x1F1FA }, new String[]{"flag-vu"}, 4, 52, false),
      new GoogleEmoji(new int[] { 0x1F1FC, 0x1F1EB }, new String[]{"flag-wf"}, 4, 53, false),
      new GoogleEmoji(new int[] { 0x1F1FC, 0x1F1F8 }, new String[]{"flag-ws"}, 4, 54, false),
      new GoogleEmoji(new int[] { 0x1F1FD, 0x1F1F0 }, new String[]{"flag-xk"}, 4, 55, false),
      new GoogleEmoji(new int[] { 0x1F1FE, 0x1F1EA }, new String[]{"flag-ye"}, 4, 56, false),
      new GoogleEmoji(new int[] { 0x1F1FE, 0x1F1F9 }, new String[]{"flag-yt"}, 5, 0, false),
      new GoogleEmoji(new int[] { 0x1F1FF, 0x1F1E6 }, new String[]{"flag-za"}, 5, 1, false),
      new GoogleEmoji(new int[] { 0x1F1FF, 0x1F1F2 }, new String[]{"flag-zm"}, 5, 2, false),
      new GoogleEmoji(new int[] { 0x1F1FF, 0x1F1FC }, new String[]{"flag-zw"}, 5, 3, false),
      new GoogleEmoji(new int[] { 0x1F3F4, 0xE0067, 0xE0062, 0xE0065, 0xE006E, 0xE0067, 0xE007F }, new String[]{"flag-england"}, 11, 14, false),
      new GoogleEmoji(new int[] { 0x1F3F4, 0xE0067, 0xE0062, 0xE0073, 0xE0063, 0xE0074, 0xE007F }, new String[]{"flag-scotland"}, 11, 15, false),
      new GoogleEmoji(new int[] { 0x1F3F4, 0xE0067, 0xE0062, 0xE0077, 0xE006C, 0xE0073, 0xE007F }, new String[]{"flag-wales"}, 11, 16, false)
    };
  }

  private FlagsCategoryChunk1() {
    // No instances.
  }
}
