/*
 * Copyright (C) 2016 - Niklas Baudy, Ruben Gees, Mario Đanić and contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */

package com.vanniktech.emoji.google.category;

import com.vanniktech.emoji.google.GoogleEmoji;

final class SymbolsCategoryChunk0 {
  @SuppressWarnings("PMD.ExcessiveMethodLength") static GoogleEmoji[] get() {
    return new GoogleEmoji[] {
      new GoogleEmoji(0x1F3E7, new String[]{"atm"}, 11, 1, false),
      new GoogleEmoji(0x1F6AE, new String[]{"put_litter_in_its_place"}, 35, 5, false),
      new GoogleEmoji(0x1F6B0, new String[]{"potable_water"}, 35, 7, false),
      new GoogleEmoji(0x267F, new String[]{"wheelchair"}, 53, 40, false),
      new GoogleEmoji(0x1F6B9, new String[]{"mens"}, 36, 10, false),
      new GoogleEmoji(0x1F6BA, new String[]{"womens"}, 36, 11, false),
      new GoogleEmoji(0x1F6BB, new String[]{"restroom"}, 36, 12, false),
      new GoogleEmoji(0x1F6BC, new String[]{"baby_symbol"}, 36, 13, false),
      new GoogleEmoji(0x1F6BE, new String[]{"wc"}, 36, 15, false),
      new GoogleEmoji(0x1F6C2, new String[]{"passport_control"}, 36, 24, false),
      new GoogleEmoji(0x1F6C3, new String[]{"customs"}, 36, 25, false),
      new GoogleEmoji(0x1F6C4, new String[]{"baggage_claim"}, 36, 26, false),
      new GoogleEmoji(0x1F6C5, new String[]{"left_luggage"}, 36, 27, false),
      new GoogleEmoji(new int[] { 0x26A0, 0xFE0F }, new String[]{"warning"}, 53, 50, false),
      new GoogleEmoji(0x1F6B8, new String[]{"children_crossing"}, 36, 9, false),
      new GoogleEmoji(0x26D4, new String[]{"no_entry"}, 54, 8, false),
      new GoogleEmoji(0x1F6AB, new String[]{"no_entry_sign"}, 35, 2, false),
      new GoogleEmoji(0x1F6B3, new String[]{"no_bicycles"}, 35, 10, false),
      new GoogleEmoji(0x1F6AD, new String[]{"no_smoking"}, 35, 4, false),
      new GoogleEmoji(0x1F6AF, new String[]{"do_not_litter"}, 35, 6, false),
      new GoogleEmoji(0x1F6B1, new String[]{"non-potable_water"}, 35, 8, false),
      new GoogleEmoji(0x1F6B7, new String[]{"no_pedestrians"}, 36, 8, false),
      new GoogleEmoji(0x1F4F5, new String[]{"no_mobile_phones"}, 27, 18, false),
      new GoogleEmoji(0x1F51E, new String[]{"underage"}, 28, 1, false),
      new GoogleEmoji(new int[] { 0x2622, 0xFE0F }, new String[]{"radioactive_sign"}, 53, 9, false),
      new GoogleEmoji(new int[] { 0x2623, 0xFE0F }, new String[]{"biohazard_sign"}, 53, 10, false),
      new GoogleEmoji(new int[] { 0x2B06, 0xFE0F }, new String[]{"arrow_up"}, 55, 38, false),
      new GoogleEmoji(new int[] { 0x2197, 0xFE0F }, new String[]{"arrow_upper_right"}, 52, 17, false),
      new GoogleEmoji(new int[] { 0x27A1, 0xFE0F }, new String[]{"arrow_right"}, 55, 32, false),
      new GoogleEmoji(new int[] { 0x2198, 0xFE0F }, new String[]{"arrow_lower_right"}, 52, 18, false),
      new GoogleEmoji(new int[] { 0x2B07, 0xFE0F }, new String[]{"arrow_down"}, 55, 39, false),
      new GoogleEmoji(new int[] { 0x2199, 0xFE0F }, new String[]{"arrow_lower_left"}, 52, 19, false),
      new GoogleEmoji(new int[] { 0x2B05, 0xFE0F }, new String[]{"arrow_left"}, 55, 37, false),
      new GoogleEmoji(new int[] { 0x2196, 0xFE0F }, new String[]{"arrow_upper_left"}, 52, 16, false),
      new GoogleEmoji(new int[] { 0x2195, 0xFE0F }, new String[]{"arrow_up_down"}, 52, 15, false),
      new GoogleEmoji(new int[] { 0x2194, 0xFE0F }, new String[]{"left_right_arrow"}, 52, 14, false),
      new GoogleEmoji(new int[] { 0x21A9, 0xFE0F }, new String[]{"leftwards_arrow_with_hook"}, 52, 20, false),
      new GoogleEmoji(new int[] { 0x21AA, 0xFE0F }, new String[]{"arrow_right_hook"}, 52, 21, false),
      new GoogleEmoji(new int[] { 0x2934, 0xFE0F }, new String[]{"arrow_heading_up"}, 55, 35, false),
      new GoogleEmoji(new int[] { 0x2935, 0xFE0F }, new String[]{"arrow_heading_down"}, 55, 36, false),
      new GoogleEmoji(0x1F503, new String[]{"arrows_clockwise"}, 27, 31, false),
      new GoogleEmoji(0x1F504, new String[]{"arrows_counterclockwise"}, 27, 32, false),
      new GoogleEmoji(0x1F519, new String[]{"back"}, 27, 53, false),
      new GoogleEmoji(0x1F51A, new String[]{"end"}, 27, 54, false),
      new GoogleEmoji(0x1F51B, new String[]{"on"}, 27, 55, false),
      new GoogleEmoji(0x1F51C, new String[]{"soon"}, 27, 56, false),
      new GoogleEmoji(0x1F51D, new String[]{"top"}, 28, 0, false),
      new GoogleEmoji(0x1F6D0, new String[]{"place_of_worship"}, 36, 38, false),
      new GoogleEmoji(new int[] { 0x269B, 0xFE0F }, new String[]{"atom_symbol"}, 53, 48, false),
      new GoogleEmoji(new int[] { 0x1F549, 0xFE0F }, new String[]{"om_symbol"}, 28, 33, false),
      new GoogleEmoji(new int[] { 0x2721, 0xFE0F }, new String[]{"star_of_david"}, 55, 15, false),
      new GoogleEmoji(new int[] { 0x2638, 0xFE0F }, new String[]{"wheel_of_dharma"}, 53, 15, false),
      new GoogleEmoji(new int[] { 0x262F, 0xFE0F }, new String[]{"yin_yang"}, 53, 14, false),
      new GoogleEmoji(new int[] { 0x271D, 0xFE0F }, new String[]{"latin_cross"}, 55, 14, false),
      new GoogleEmoji(new int[] { 0x2626, 0xFE0F }, new String[]{"orthodox_cross"}, 53, 11, false),
      new GoogleEmoji(new int[] { 0x262A, 0xFE0F }, new String[]{"star_and_crescent"}, 53, 12, false),
      new GoogleEmoji(new int[] { 0x262E, 0xFE0F }, new String[]{"peace_symbol"}, 53, 13, false),
      new GoogleEmoji(0x1F54E, new String[]{"menorah_with_nine_branches"}, 28, 38, false),
      new GoogleEmoji(0x1F52F, new String[]{"six_pointed_star"}, 28, 18, false),
      new GoogleEmoji(0x2648, new String[]{"aries"}, 53, 20, false),
      new GoogleEmoji(0x2649, new String[]{"taurus"}, 53, 21, false),
      new GoogleEmoji(0x264A, new String[]{"gemini"}, 53, 22, false),
      new GoogleEmoji(0x264B, new String[]{"cancer"}, 53, 23, false),
      new GoogleEmoji(0x264C, new String[]{"leo"}, 53, 24, false),
      new GoogleEmoji(0x264D, new String[]{"virgo"}, 53, 25, false),
      new GoogleEmoji(0x264E, new String[]{"libra"}, 53, 26, false),
      new GoogleEmoji(0x264F, new String[]{"scorpius"}, 53, 27, false),
      new GoogleEmoji(0x2650, new String[]{"sagittarius"}, 53, 28, false),
      new GoogleEmoji(0x2651, new String[]{"capricorn"}, 53, 29, false),
      new GoogleEmoji(0x2652, new String[]{"aquarius"}, 53, 30, false),
      new GoogleEmoji(0x2653, new String[]{"pisces"}, 53, 31, false),
      new GoogleEmoji(0x26CE, new String[]{"ophiuchus"}, 54, 4, false),
      new GoogleEmoji(0x1F500, new String[]{"twisted_rightwards_arrows"}, 27, 28, false),
      new GoogleEmoji(0x1F501, new String[]{"repeat"}, 27, 29, false),
      new GoogleEmoji(0x1F502, new String[]{"repeat_one"}, 27, 30, false),
      new GoogleEmoji(new int[] { 0x25B6, 0xFE0F }, new String[]{"arrow_forward"}, 52, 43, false),
      new GoogleEmoji(0x23E9, new String[]{"fast_forward"}, 52, 26, false),
      new GoogleEmoji(new int[] { 0x23ED, 0xFE0F }, new String[]{"black_right_pointing_double_triangle_with_vertical_bar"}, 52, 30, false),
      new GoogleEmoji(new int[] { 0x23EF, 0xFE0F }, new String[]{"black_right_pointing_triangle_with_double_vertical_bar"}, 52, 32, false),
      new GoogleEmoji(new int[] { 0x25C0, 0xFE0F }, new String[]{"arrow_backward"}, 52, 44, false),
      new GoogleEmoji(0x23EA, new String[]{"rewind"}, 52, 27, false),
      new GoogleEmoji(new int[] { 0x23EE, 0xFE0F }, new String[]{"black_left_pointing_double_triangle_with_vertical_bar"}, 52, 31, false),
      new GoogleEmoji(0x1F53C, new String[]{"arrow_up_small"}, 28, 31, false),
      new GoogleEmoji(0x23EB, new String[]{"arrow_double_up"}, 52, 28, false),
      new GoogleEmoji(0x1F53D, new String[]{"arrow_down_small"}, 28, 32, false),
      new GoogleEmoji(0x23EC, new String[]{"arrow_double_down"}, 52, 29, false),
      new GoogleEmoji(new int[] { 0x23F8, 0xFE0F }, new String[]{"double_vertical_bar"}, 52, 37, false),
      new GoogleEmoji(new int[] { 0x23F9, 0xFE0F }, new String[]{"black_square_for_stop"}, 52, 38, false),
      new GoogleEmoji(new int[] { 0x23FA, 0xFE0F }, new String[]{"black_circle_for_record"}, 52, 39, false),
      new GoogleEmoji(new int[] { 0x23CF, 0xFE0F }, new String[]{"eject"}, 52, 25, false),
      new GoogleEmoji(0x1F3A6, new String[]{"cinema"}, 8, 12, false),
      new GoogleEmoji(0x1F505, new String[]{"low_brightness"}, 27, 33, false),
      new GoogleEmoji(0x1F506, new String[]{"high_brightness"}, 27, 34, false),
      new GoogleEmoji(0x1F4F6, new String[]{"signal_strength"}, 27, 19, false),
      new GoogleEmoji(0x1F4F3, new String[]{"vibration_mode"}, 27, 16, false),
      new GoogleEmoji(0x1F4F4, new String[]{"mobile_phone_off"}, 27, 17, false),
      new GoogleEmoji(new int[] { 0x2640, 0xFE0F }, new String[]{"female_sign"}, 53, 18, false),
      new GoogleEmoji(new int[] { 0x2642, 0xFE0F }, new String[]{"male_sign"}, 53, 19, false),
      new GoogleEmoji(new int[] { 0x2695, 0xFE0F }, new String[]{"medical_symbol", "staff_of_aesculapius"}, 53, 44, false),
      new GoogleEmoji(new int[] { 0x267E, 0xFE0F }, new String[]{"infinity"}, 53, 39, false),
      new GoogleEmoji(new int[] { 0x267B, 0xFE0F }, new String[]{"recycle"}, 53, 38, false),
      new GoogleEmoji(new int[] { 0x269C, 0xFE0F }, new String[]{"fleur_de_lis"}, 53, 49, false),
      new GoogleEmoji(0x1F531, new String[]{"trident"}, 28, 20, false),
      new GoogleEmoji(0x1F4DB, new String[]{"name_badge"}, 26, 49, false),
      new GoogleEmoji(0x1F530, new String[]{"beginner"}, 28, 19, false),
      new GoogleEmoji(0x2B55, new String[]{"o"}, 55, 43, false),
      new GoogleEmoji(0x2705, new String[]{"white_check_mark"}, 54, 40, false),
      new GoogleEmoji(new int[] { 0x2611, 0xFE0F }, new String[]{"ballot_box_with_check"}, 52, 55, false),
      new GoogleEmoji(new int[] { 0x2714, 0xFE0F }, new String[]{"heavy_check_mark"}, 55, 12, false),
      new GoogleEmoji(new int[] { 0x2716, 0xFE0F }, new String[]{"heavy_multiplication_x"}, 55, 13, false),
      new GoogleEmoji(0x274C, new String[]{"x"}, 55, 21, false),
      new GoogleEmoji(0x274E, new String[]{"negative_squared_cross_mark"}, 55, 22, false),
      new GoogleEmoji(0x2795, new String[]{"heavy_plus_sign"}, 55, 29, false),
      new GoogleEmoji(0x2796, new String[]{"heavy_minus_sign"}, 55, 30, false),
      new GoogleEmoji(0x2797, new String[]{"heavy_division_sign"}, 55, 31, false),
      new GoogleEmoji(0x27B0, new String[]{"curly_loop"}, 55, 33, false),
      new GoogleEmoji(0x27BF, new String[]{"loop"}, 55, 34, false),
      new GoogleEmoji(new int[] { 0x303D, 0xFE0F }, new String[]{"part_alternation_mark"}, 55, 45, false),
      new GoogleEmoji(new int[] { 0x2733, 0xFE0F }, new String[]{"eight_spoked_asterisk"}, 55, 17, false),
      new GoogleEmoji(new int[] { 0x2734, 0xFE0F }, new String[]{"eight_pointed_black_star"}, 55, 18, false),
      new GoogleEmoji(new int[] { 0x2747, 0xFE0F }, new String[]{"sparkle"}, 55, 20, false),
      new GoogleEmoji(new int[] { 0x203C, 0xFE0F }, new String[]{"bangbang"}, 52, 10, false),
      new GoogleEmoji(new int[] { 0x2049, 0xFE0F }, new String[]{"interrobang"}, 52, 11, false),
      new GoogleEmoji(0x2753, new String[]{"question"}, 55, 23, false),
      new GoogleEmoji(0x2754, new String[]{"grey_question"}, 55, 24, false),
      new GoogleEmoji(0x2755, new String[]{"grey_exclamation"}, 55, 25, false),
      new GoogleEmoji(0x2757, new String[]{"exclamation", "heavy_exclamation_mark"}, 55, 26, false),
      new GoogleEmoji(new int[] { 0x3030, 0xFE0F }, new String[]{"wavy_dash"}, 55, 44, false),
      new GoogleEmoji(new int[] { 0x00A9, 0xFE0F }, new String[]{"copyright"}, 0, 12, false),
      new GoogleEmoji(new int[] { 0x00AE, 0xFE0F }, new String[]{"registered"}, 0, 13, false),
      new GoogleEmoji(new int[] { 0x2122, 0xFE0F }, new String[]{"tm"}, 52, 12, false),
      new GoogleEmoji(new int[] { 0x0023, 0xFE0F, 0x20E3 }, new String[]{"hash"}, 0, 0, false),
      new GoogleEmoji(new int[] { 0x002A, 0xFE0F, 0x20E3 }, new String[]{"keycap_star"}, 0, 1, false),
      new GoogleEmoji(new int[] { 0x0030, 0xFE0F, 0x20E3 }, new String[]{"zero"}, 0, 2, false),
      new GoogleEmoji(new int[] { 0x0031, 0xFE0F, 0x20E3 }, new String[]{"one"}, 0, 3, false),
      new GoogleEmoji(new int[] { 0x0032, 0xFE0F, 0x20E3 }, new String[]{"two"}, 0, 4, false),
      new GoogleEmoji(new int[] { 0x0033, 0xFE0F, 0x20E3 }, new String[]{"three"}, 0, 5, false),
      new GoogleEmoji(new int[] { 0x0034, 0xFE0F, 0x20E3 }, new String[]{"four"}, 0, 6, false),
      new GoogleEmoji(new int[] { 0x0035, 0xFE0F, 0x20E3 }, new String[]{"five"}, 0, 7, false),
      new GoogleEmoji(new int[] { 0x0036, 0xFE0F, 0x20E3 }, new String[]{"six"}, 0, 8, false),
      new GoogleEmoji(new int[] { 0x0037, 0xFE0F, 0x20E3 }, new String[]{"seven"}, 0, 9, false),
      new GoogleEmoji(new int[] { 0x0038, 0xFE0F, 0x20E3 }, new String[]{"eight"}, 0, 10, false),
      new GoogleEmoji(new int[] { 0x0039, 0xFE0F, 0x20E3 }, new String[]{"nine"}, 0, 11, false),
      new GoogleEmoji(0x1F51F, new String[]{"keycap_ten"}, 28, 2, false),
      new GoogleEmoji(0x1F520, new String[]{"capital_abcd"}, 28, 3, false),
      new GoogleEmoji(0x1F521, new String[]{"abcd"}, 28, 4, false),
      new GoogleEmoji(0x1F522, new String[]{"1234"}, 28, 5, false),
      new GoogleEmoji(0x1F523, new String[]{"symbols"}, 28, 6, false),
      new GoogleEmoji(0x1F524, new String[]{"abc"}, 28, 7, false),
      new GoogleEmoji(new int[] { 0x1F170, 0xFE0F }, new String[]{"a"}, 0, 16, false),
      new GoogleEmoji(0x1F18E, new String[]{"ab"}, 0, 20, false),
      new GoogleEmoji(new int[] { 0x1F171, 0xFE0F }, new String[]{"b"}, 0, 17, false),
      new GoogleEmoji(0x1F191, new String[]{"cl"}, 0, 21, false),
      new GoogleEmoji(0x1F192, new String[]{"cool"}, 0, 22, false),
      new GoogleEmoji(0x1F193, new String[]{"free"}, 0, 23, false),
      new GoogleEmoji(new int[] { 0x2139, 0xFE0F }, new String[]{"information_source"}, 52, 13, false),
      new GoogleEmoji(0x1F194, new String[]{"id"}, 0, 24, false),
      new GoogleEmoji(new int[] { 0x24C2, 0xFE0F }, new String[]{"m"}, 52, 40, false),
      new GoogleEmoji(0x1F195, new String[]{"new"}, 0, 25, false),
      new GoogleEmoji(0x1F196, new String[]{"ng"}, 0, 26, false),
      new GoogleEmoji(new int[] { 0x1F17E, 0xFE0F }, new String[]{"o2"}, 0, 18, false),
      new GoogleEmoji(0x1F197, new String[]{"ok"}, 0, 27, false),
      new GoogleEmoji(new int[] { 0x1F17F, 0xFE0F }, new String[]{"parking"}, 0, 19, false),
      new GoogleEmoji(0x1F198, new String[]{"sos"}, 0, 28, false),
      new GoogleEmoji(0x1F199, new String[]{"up"}, 0, 29, false),
      new GoogleEmoji(0x1F19A, new String[]{"vs"}, 0, 30, false),
      new GoogleEmoji(0x1F201, new String[]{"koko"}, 5, 4, false),
      new GoogleEmoji(new int[] { 0x1F202, 0xFE0F }, new String[]{"sa"}, 5, 5, false),
      new GoogleEmoji(new int[] { 0x1F237, 0xFE0F }, new String[]{"u6708"}, 5, 13, false),
      new GoogleEmoji(0x1F236, new String[]{"u6709"}, 5, 12, false),
      new GoogleEmoji(0x1F22F, new String[]{"u6307"}, 5, 7, false),
      new GoogleEmoji(0x1F250, new String[]{"ideograph_advantage"}, 5, 17, false),
      new GoogleEmoji(0x1F239, new String[]{"u5272"}, 5, 15, false),
      new GoogleEmoji(0x1F21A, new String[]{"u7121"}, 5, 6, false),
      new GoogleEmoji(0x1F232, new String[]{"u7981"}, 5, 8, false),
      new GoogleEmoji(0x1F251, new String[]{"accept"}, 5, 18, false),
      new GoogleEmoji(0x1F238, new String[]{"u7533"}, 5, 14, false),
      new GoogleEmoji(0x1F234, new String[]{"u5408"}, 5, 10, false),
      new GoogleEmoji(0x1F233, new String[]{"u7a7a"}, 5, 9, false),
      new GoogleEmoji(new int[] { 0x3297, 0xFE0F }, new String[]{"congratulations"}, 55, 46, false),
      new GoogleEmoji(new int[] { 0x3299, 0xFE0F }, new String[]{"secret"}, 55, 47, false),
      new GoogleEmoji(0x1F23A, new String[]{"u55b6"}, 5, 16, false),
      new GoogleEmoji(0x1F235, new String[]{"u6e80"}, 5, 11, false),
      new GoogleEmoji(0x1F534, new String[]{"red_circle"}, 28, 23, false),
      new GoogleEmoji(0x1F7E0, new String[]{"large_orange_circle"}, 37, 3, false),
      new GoogleEmoji(0x1F7E1, new String[]{"large_yellow_circle"}, 37, 4, false),
      new GoogleEmoji(0x1F7E2, new String[]{"large_green_circle"}, 37, 5, false),
      new GoogleEmoji(0x1F535, new String[]{"large_blue_circle"}, 28, 24, false),
      new GoogleEmoji(0x1F7E3, new String[]{"large_purple_circle"}, 37, 6, false),
      new GoogleEmoji(0x1F7E4, new String[]{"large_brown_circle"}, 37, 7, false),
      new GoogleEmoji(0x26AB, new String[]{"black_circle"}, 53, 53, false),
      new GoogleEmoji(0x26AA, new String[]{"white_circle"}, 53, 52, false),
      new GoogleEmoji(0x1F7E5, new String[]{"large_red_square"}, 37, 8, false),
      new GoogleEmoji(0x1F7E7, new String[]{"large_orange_square"}, 37, 10, false),
      new GoogleEmoji(0x1F7E8, new String[]{"large_yellow_square"}, 37, 11, false),
      new GoogleEmoji(0x1F7E9, new String[]{"large_green_square"}, 37, 12, false),
      new GoogleEmoji(0x1F7E6, new String[]{"large_blue_square"}, 37, 9, false),
      new GoogleEmoji(0x1F7EA, new String[]{"large_purple_square"}, 37, 13, false),
      new GoogleEmoji(0x1F7EB, new String[]{"large_brown_square"}, 37, 14, false),
      new GoogleEmoji(0x2B1B, new String[]{"black_large_square"}, 55, 40, false),
      new GoogleEmoji(0x2B1C, new String[]{"white_large_square"}, 55, 41, false),
      new GoogleEmoji(new int[] { 0x25FC, 0xFE0F }, new String[]{"black_medium_square"}, 52, 46, false),
      new GoogleEmoji(new int[] { 0x25FB, 0xFE0F }, new String[]{"white_medium_square"}, 52, 45, false),
      new GoogleEmoji(0x25FE, new String[]{"black_medium_small_square"}, 52, 48, false),
      new GoogleEmoji(0x25FD, new String[]{"white_medium_small_square"}, 52, 47, false),
      new GoogleEmoji(new int[] { 0x25AA, 0xFE0F }, new String[]{"black_small_square"}, 52, 41, false),
      new GoogleEmoji(new int[] { 0x25AB, 0xFE0F }, new String[]{"white_small_square"}, 52, 42, false),
      new GoogleEmoji(0x1F536, new String[]{"large_orange_diamond"}, 28, 25, false),
      new GoogleEmoji(0x1F537, new String[]{"large_blue_diamond"}, 28, 26, false),
      new GoogleEmoji(0x1F538, new String[]{"small_orange_diamond"}, 28, 27, false),
      new GoogleEmoji(0x1F539, new String[]{"small_blue_diamond"}, 28, 28, false),
      new GoogleEmoji(0x1F53A, new String[]{"small_red_triangle"}, 28, 29, false),
      new GoogleEmoji(0x1F53B, new String[]{"small_red_triangle_down"}, 28, 30, false),
      new GoogleEmoji(0x1F4A0, new String[]{"diamond_shape_with_a_dot_inside"}, 25, 42, false),
      new GoogleEmoji(0x1F518, new String[]{"radio_button"}, 27, 52, false),
      new GoogleEmoji(0x1F533, new String[]{"white_square_button"}, 28, 22, false),
      new GoogleEmoji(0x1F532, new String[]{"black_square_button"}, 28, 21, false)
    };
  }

  private SymbolsCategoryChunk0() {
    // No instances.
  }
}
