/*
 * Copyright (C) 2016 - Niklas Baudy, Ruben Gees, Mario Đanić and contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */

package com.vanniktech.emoji.google.category;

import com.vanniktech.emoji.google.GoogleEmoji;

final class TravelAndPlacesCategoryChunk0 {
  @SuppressWarnings("PMD.ExcessiveMethodLength") static GoogleEmoji[] get() {
    return new GoogleEmoji[] {
      new GoogleEmoji(0x1F30D, new String[]{"earth_africa"}, 5, 32, false),
      new GoogleEmoji(0x1F30E, new String[]{"earth_americas"}, 5, 33, false),
      new GoogleEmoji(0x1F30F, new String[]{"earth_asia"}, 5, 34, false),
      new GoogleEmoji(0x1F310, new String[]{"globe_with_meridians"}, 5, 35, false),
      new GoogleEmoji(new int[] { 0x1F5FA, 0xFE0F }, new String[]{"world_map"}, 30, 29, false),
      new GoogleEmoji(0x1F5FE, new String[]{"japan"}, 30, 33, false),
      new GoogleEmoji(0x1F9ED, new String[]{"compass"}, 51, 32, false),
      new GoogleEmoji(new int[] { 0x1F3D4, 0xFE0F }, new String[]{"snow_capped_mountain"}, 10, 39, false),
      new GoogleEmoji(new int[] { 0x26F0, 0xFE0F }, new String[]{"mountain"}, 54, 11, false),
      new GoogleEmoji(0x1F30B, new String[]{"volcano"}, 5, 30, false),
      new GoogleEmoji(0x1F5FB, new String[]{"mount_fuji"}, 30, 30, false),
      new GoogleEmoji(new int[] { 0x1F3D5, 0xFE0F }, new String[]{"camping"}, 10, 40, false),
      new GoogleEmoji(new int[] { 0x1F3D6, 0xFE0F }, new String[]{"beach_with_umbrella"}, 10, 41, false),
      new GoogleEmoji(new int[] { 0x1F3DC, 0xFE0F }, new String[]{"desert"}, 10, 47, false),
      new GoogleEmoji(new int[] { 0x1F3DD, 0xFE0F }, new String[]{"desert_island"}, 10, 48, false),
      new GoogleEmoji(new int[] { 0x1F3DE, 0xFE0F }, new String[]{"national_park"}, 10, 49, false),
      new GoogleEmoji(new int[] { 0x1F3DF, 0xFE0F }, new String[]{"stadium"}, 10, 50, false),
      new GoogleEmoji(new int[] { 0x1F3DB, 0xFE0F }, new String[]{"classical_building"}, 10, 46, false),
      new GoogleEmoji(new int[] { 0x1F3D7, 0xFE0F }, new String[]{"building_construction"}, 10, 42, false),
      new GoogleEmoji(0x1F9F1, new String[]{"bricks"}, 51, 36, false),
      new GoogleEmoji(new int[] { 0x1F3D8, 0xFE0F }, new String[]{"house_buildings"}, 10, 43, false),
      new GoogleEmoji(new int[] { 0x1F3DA, 0xFE0F }, new String[]{"derelict_house_building"}, 10, 45, false),
      new GoogleEmoji(0x1F3E0, new String[]{"house"}, 10, 51, false),
      new GoogleEmoji(0x1F3E1, new String[]{"house_with_garden"}, 10, 52, false),
      new GoogleEmoji(0x1F3E2, new String[]{"office"}, 10, 53, false),
      new GoogleEmoji(0x1F3E3, new String[]{"post_office"}, 10, 54, false),
      new GoogleEmoji(0x1F3E4, new String[]{"european_post_office"}, 10, 55, false),
      new GoogleEmoji(0x1F3E5, new String[]{"hospital"}, 10, 56, false),
      new GoogleEmoji(0x1F3E6, new String[]{"bank"}, 11, 0, false),
      new GoogleEmoji(0x1F3E8, new String[]{"hotel"}, 11, 2, false),
      new GoogleEmoji(0x1F3E9, new String[]{"love_hotel"}, 11, 3, false),
      new GoogleEmoji(0x1F3EA, new String[]{"convenience_store"}, 11, 4, false),
      new GoogleEmoji(0x1F3EB, new String[]{"school"}, 11, 5, false),
      new GoogleEmoji(0x1F3EC, new String[]{"department_store"}, 11, 6, false),
      new GoogleEmoji(0x1F3ED, new String[]{"factory"}, 11, 7, false),
      new GoogleEmoji(0x1F3EF, new String[]{"japanese_castle"}, 11, 9, false),
      new GoogleEmoji(0x1F3F0, new String[]{"european_castle"}, 11, 10, false),
      new GoogleEmoji(0x1F492, new String[]{"wedding"}, 25, 28, false),
      new GoogleEmoji(0x1F5FC, new String[]{"tokyo_tower"}, 30, 31, false),
      new GoogleEmoji(0x1F5FD, new String[]{"statue_of_liberty"}, 30, 32, false),
      new GoogleEmoji(0x26EA, new String[]{"church"}, 54, 10, false),
      new GoogleEmoji(0x1F54C, new String[]{"mosque"}, 28, 36, false),
      new GoogleEmoji(0x1F6D5, new String[]{"hindu_temple"}, 36, 41, false),
      new GoogleEmoji(0x1F54D, new String[]{"synagogue"}, 28, 37, false),
      new GoogleEmoji(new int[] { 0x26E9, 0xFE0F }, new String[]{"shinto_shrine"}, 54, 9, false),
      new GoogleEmoji(0x1F54B, new String[]{"kaaba"}, 28, 35, false),
      new GoogleEmoji(0x26F2, new String[]{"fountain"}, 54, 13, false),
      new GoogleEmoji(0x26FA, new String[]{"tent"}, 54, 37, false),
      new GoogleEmoji(0x1F301, new String[]{"foggy"}, 5, 20, false),
      new GoogleEmoji(0x1F303, new String[]{"night_with_stars"}, 5, 22, false),
      new GoogleEmoji(new int[] { 0x1F3D9, 0xFE0F }, new String[]{"cityscape"}, 10, 44, false),
      new GoogleEmoji(0x1F304, new String[]{"sunrise_over_mountains"}, 5, 23, false),
      new GoogleEmoji(0x1F305, new String[]{"sunrise"}, 5, 24, false),
      new GoogleEmoji(0x1F306, new String[]{"city_sunset"}, 5, 25, false),
      new GoogleEmoji(0x1F307, new String[]{"city_sunrise"}, 5, 26, false),
      new GoogleEmoji(0x1F309, new String[]{"bridge_at_night"}, 5, 28, false),
      new GoogleEmoji(new int[] { 0x2668, 0xFE0F }, new String[]{"hotsprings"}, 53, 37, false),
      new GoogleEmoji(0x1F3A0, new String[]{"carousel_horse"}, 8, 6, false),
      new GoogleEmoji(0x1F3A1, new String[]{"ferris_wheel"}, 8, 7, false),
      new GoogleEmoji(0x1F3A2, new String[]{"roller_coaster"}, 8, 8, false),
      new GoogleEmoji(0x1F488, new String[]{"barber"}, 25, 18, false),
      new GoogleEmoji(0x1F3AA, new String[]{"circus_tent"}, 8, 16, false),
      new GoogleEmoji(0x1F682, new String[]{"steam_locomotive"}, 34, 1, false),
      new GoogleEmoji(0x1F683, new String[]{"railway_car"}, 34, 2, false),
      new GoogleEmoji(0x1F684, new String[]{"bullettrain_side"}, 34, 3, false),
      new GoogleEmoji(0x1F685, new String[]{"bullettrain_front"}, 34, 4, false),
      new GoogleEmoji(0x1F686, new String[]{"train2"}, 34, 5, false),
      new GoogleEmoji(0x1F687, new String[]{"metro"}, 34, 6, false),
      new GoogleEmoji(0x1F688, new String[]{"light_rail"}, 34, 7, false),
      new GoogleEmoji(0x1F689, new String[]{"station"}, 34, 8, false),
      new GoogleEmoji(0x1F68A, new String[]{"tram"}, 34, 9, false),
      new GoogleEmoji(0x1F69D, new String[]{"monorail"}, 34, 28, false),
      new GoogleEmoji(0x1F69E, new String[]{"mountain_railway"}, 34, 29, false),
      new GoogleEmoji(0x1F68B, new String[]{"train"}, 34, 10, false),
      new GoogleEmoji(0x1F68C, new String[]{"bus"}, 34, 11, false),
      new GoogleEmoji(0x1F68D, new String[]{"oncoming_bus"}, 34, 12, false),
      new GoogleEmoji(0x1F68E, new String[]{"trolleybus"}, 34, 13, false),
      new GoogleEmoji(0x1F690, new String[]{"minibus"}, 34, 15, false),
      new GoogleEmoji(0x1F691, new String[]{"ambulance"}, 34, 16, false),
      new GoogleEmoji(0x1F692, new String[]{"fire_engine"}, 34, 17, false),
      new GoogleEmoji(0x1F693, new String[]{"police_car"}, 34, 18, false),
      new GoogleEmoji(0x1F694, new String[]{"oncoming_police_car"}, 34, 19, false),
      new GoogleEmoji(0x1F695, new String[]{"taxi"}, 34, 20, false),
      new GoogleEmoji(0x1F696, new String[]{"oncoming_taxi"}, 34, 21, false),
      new GoogleEmoji(0x1F697, new String[]{"car", "red_car"}, 34, 22, false),
      new GoogleEmoji(0x1F698, new String[]{"oncoming_automobile"}, 34, 23, false),
      new GoogleEmoji(0x1F699, new String[]{"blue_car"}, 34, 24, false),
      new GoogleEmoji(0x1F69A, new String[]{"truck"}, 34, 25, false),
      new GoogleEmoji(0x1F69B, new String[]{"articulated_lorry"}, 34, 26, false),
      new GoogleEmoji(0x1F69C, new String[]{"tractor"}, 34, 27, false),
      new GoogleEmoji(new int[] { 0x1F3CE, 0xFE0F }, new String[]{"racing_car"}, 10, 33, false),
      new GoogleEmoji(new int[] { 0x1F3CD, 0xFE0F }, new String[]{"racing_motorcycle"}, 10, 32, false),
      new GoogleEmoji(0x1F6F5, new String[]{"motor_scooter"}, 36, 54, false),
      new GoogleEmoji(0x1F9BD, new String[]{"manual_wheelchair"}, 44, 5, false),
      new GoogleEmoji(0x1F9BC, new String[]{"motorized_wheelchair"}, 44, 4, false),
      new GoogleEmoji(0x1F6FA, new String[]{"auto_rickshaw"}, 37, 2, false),
      new GoogleEmoji(0x1F6B2, new String[]{"bike"}, 35, 9, false),
      new GoogleEmoji(0x1F6F4, new String[]{"scooter"}, 36, 53, false),
      new GoogleEmoji(0x1F6F9, new String[]{"skateboard"}, 37, 1, false),
      new GoogleEmoji(0x1F68F, new String[]{"busstop"}, 34, 14, false),
      new GoogleEmoji(new int[] { 0x1F6E3, 0xFE0F }, new String[]{"motorway"}, 36, 45, false),
      new GoogleEmoji(new int[] { 0x1F6E4, 0xFE0F }, new String[]{"railway_track"}, 36, 46, false),
      new GoogleEmoji(new int[] { 0x1F6E2, 0xFE0F }, new String[]{"oil_drum"}, 36, 44, false),
      new GoogleEmoji(0x26FD, new String[]{"fuelpump"}, 54, 38, false),
      new GoogleEmoji(0x1F6A8, new String[]{"rotating_light"}, 34, 56, false),
      new GoogleEmoji(0x1F6A5, new String[]{"traffic_light"}, 34, 53, false),
      new GoogleEmoji(0x1F6A6, new String[]{"vertical_traffic_light"}, 34, 54, false),
      new GoogleEmoji(0x1F6D1, new String[]{"octagonal_sign"}, 36, 39, false),
      new GoogleEmoji(0x1F6A7, new String[]{"construction"}, 34, 55, false),
      new GoogleEmoji(0x2693, new String[]{"anchor"}, 53, 42, false),
      new GoogleEmoji(0x26F5, new String[]{"boat", "sailboat"}, 54, 16, false),
      new GoogleEmoji(0x1F6F6, new String[]{"canoe"}, 36, 55, false),
      new GoogleEmoji(0x1F6A4, new String[]{"speedboat"}, 34, 52, false),
      new GoogleEmoji(new int[] { 0x1F6F3, 0xFE0F }, new String[]{"passenger_ship"}, 36, 52, false),
      new GoogleEmoji(new int[] { 0x26F4, 0xFE0F }, new String[]{"ferry"}, 54, 15, false),
      new GoogleEmoji(new int[] { 0x1F6E5, 0xFE0F }, new String[]{"motor_boat"}, 36, 47, false),
      new GoogleEmoji(0x1F6A2, new String[]{"ship"}, 34, 33, false),
      new GoogleEmoji(new int[] { 0x2708, 0xFE0F }, new String[]{"airplane"}, 54, 41, false),
      new GoogleEmoji(new int[] { 0x1F6E9, 0xFE0F }, new String[]{"small_airplane"}, 36, 48, false),
      new GoogleEmoji(0x1F6EB, new String[]{"airplane_departure"}, 36, 49, false),
      new GoogleEmoji(0x1F6EC, new String[]{"airplane_arriving"}, 36, 50, false),
      new GoogleEmoji(0x1FA82, new String[]{"parachute"}, 52, 3, false),
      new GoogleEmoji(0x1F4BA, new String[]{"seat"}, 26, 16, false),
      new GoogleEmoji(0x1F681, new String[]{"helicopter"}, 34, 0, false),
      new GoogleEmoji(0x1F69F, new String[]{"suspension_railway"}, 34, 30, false),
      new GoogleEmoji(0x1F6A0, new String[]{"mountain_cableway"}, 34, 31, false),
      new GoogleEmoji(0x1F6A1, new String[]{"aerial_tramway"}, 34, 32, false),
      new GoogleEmoji(new int[] { 0x1F6F0, 0xFE0F }, new String[]{"satellite"}, 36, 51, false),
      new GoogleEmoji(0x1F680, new String[]{"rocket"}, 33, 56, false),
      new GoogleEmoji(0x1F6F8, new String[]{"flying_saucer"}, 37, 0, false),
      new GoogleEmoji(new int[] { 0x1F6CE, 0xFE0F }, new String[]{"bellhop_bell"}, 36, 36, false),
      new GoogleEmoji(0x1F9F3, new String[]{"luggage"}, 51, 38, false),
      new GoogleEmoji(0x231B, new String[]{"hourglass"}, 52, 23, false),
      new GoogleEmoji(0x23F3, new String[]{"hourglass_flowing_sand"}, 52, 36, false),
      new GoogleEmoji(0x231A, new String[]{"watch"}, 52, 22, false),
      new GoogleEmoji(0x23F0, new String[]{"alarm_clock"}, 52, 33, false),
      new GoogleEmoji(new int[] { 0x23F1, 0xFE0F }, new String[]{"stopwatch"}, 52, 34, false),
      new GoogleEmoji(new int[] { 0x23F2, 0xFE0F }, new String[]{"timer_clock"}, 52, 35, false),
      new GoogleEmoji(new int[] { 0x1F570, 0xFE0F }, new String[]{"mantelpiece_clock"}, 29, 7, false),
      new GoogleEmoji(0x1F55B, new String[]{"clock12"}, 28, 50, false),
      new GoogleEmoji(0x1F567, new String[]{"clock1230"}, 29, 5, false),
      new GoogleEmoji(0x1F550, new String[]{"clock1"}, 28, 39, false),
      new GoogleEmoji(0x1F55C, new String[]{"clock130"}, 28, 51, false),
      new GoogleEmoji(0x1F551, new String[]{"clock2"}, 28, 40, false),
      new GoogleEmoji(0x1F55D, new String[]{"clock230"}, 28, 52, false),
      new GoogleEmoji(0x1F552, new String[]{"clock3"}, 28, 41, false),
      new GoogleEmoji(0x1F55E, new String[]{"clock330"}, 28, 53, false),
      new GoogleEmoji(0x1F553, new String[]{"clock4"}, 28, 42, false),
      new GoogleEmoji(0x1F55F, new String[]{"clock430"}, 28, 54, false),
      new GoogleEmoji(0x1F554, new String[]{"clock5"}, 28, 43, false),
      new GoogleEmoji(0x1F560, new String[]{"clock530"}, 28, 55, false),
      new GoogleEmoji(0x1F555, new String[]{"clock6"}, 28, 44, false),
      new GoogleEmoji(0x1F561, new String[]{"clock630"}, 28, 56, false),
      new GoogleEmoji(0x1F556, new String[]{"clock7"}, 28, 45, false),
      new GoogleEmoji(0x1F562, new String[]{"clock730"}, 29, 0, false),
      new GoogleEmoji(0x1F557, new String[]{"clock8"}, 28, 46, false),
      new GoogleEmoji(0x1F563, new String[]{"clock830"}, 29, 1, false),
      new GoogleEmoji(0x1F558, new String[]{"clock9"}, 28, 47, false),
      new GoogleEmoji(0x1F564, new String[]{"clock930"}, 29, 2, false),
      new GoogleEmoji(0x1F559, new String[]{"clock10"}, 28, 48, false),
      new GoogleEmoji(0x1F565, new String[]{"clock1030"}, 29, 3, false),
      new GoogleEmoji(0x1F55A, new String[]{"clock11"}, 28, 49, false),
      new GoogleEmoji(0x1F566, new String[]{"clock1130"}, 29, 4, false),
      new GoogleEmoji(0x1F311, new String[]{"new_moon"}, 5, 36, false),
      new GoogleEmoji(0x1F312, new String[]{"waxing_crescent_moon"}, 5, 37, false),
      new GoogleEmoji(0x1F313, new String[]{"first_quarter_moon"}, 5, 38, false),
      new GoogleEmoji(0x1F314, new String[]{"moon", "waxing_gibbous_moon"}, 5, 39, false),
      new GoogleEmoji(0x1F315, new String[]{"full_moon"}, 5, 40, false),
      new GoogleEmoji(0x1F316, new String[]{"waning_gibbous_moon"}, 5, 41, false),
      new GoogleEmoji(0x1F317, new String[]{"last_quarter_moon"}, 5, 42, false),
      new GoogleEmoji(0x1F318, new String[]{"waning_crescent_moon"}, 5, 43, false),
      new GoogleEmoji(0x1F319, new String[]{"crescent_moon"}, 5, 44, false),
      new GoogleEmoji(0x1F31A, new String[]{"new_moon_with_face"}, 5, 45, false),
      new GoogleEmoji(0x1F31B, new String[]{"first_quarter_moon_with_face"}, 5, 46, false),
      new GoogleEmoji(0x1F31C, new String[]{"last_quarter_moon_with_face"}, 5, 47, false),
      new GoogleEmoji(new int[] { 0x1F321, 0xFE0F }, new String[]{"thermometer"}, 5, 52, false),
      new GoogleEmoji(new int[] { 0x2600, 0xFE0F }, new String[]{"sunny"}, 52, 49, false),
      new GoogleEmoji(0x1F31D, new String[]{"full_moon_with_face"}, 5, 48, false),
      new GoogleEmoji(0x1F31E, new String[]{"sun_with_face"}, 5, 49, false),
      new GoogleEmoji(0x1FA90, new String[]{"ringed_planet"}, 52, 4, false),
      new GoogleEmoji(0x2B50, new String[]{"star"}, 55, 42, true,
        new GoogleEmoji(new int[] { 0x2B50, 0xFE0F }, new String[0], 55, 42, true)
      ),
      new GoogleEmoji(0x1F31F, new String[]{"star2"}, 5, 50, false),
      new GoogleEmoji(0x1F320, new String[]{"stars"}, 5, 51, false),
      new GoogleEmoji(0x1F30C, new String[]{"milky_way"}, 5, 31, false),
      new GoogleEmoji(new int[] { 0x2601, 0xFE0F }, new String[]{"cloud"}, 52, 50, false),
      new GoogleEmoji(0x26C5, new String[]{"partly_sunny"}, 54, 2, false),
      new GoogleEmoji(new int[] { 0x26C8, 0xFE0F }, new String[]{"thunder_cloud_and_rain"}, 54, 3, false),
      new GoogleEmoji(new int[] { 0x1F324, 0xFE0F }, new String[]{"mostly_sunny", "sun_small_cloud"}, 5, 53, false),
      new GoogleEmoji(new int[] { 0x1F325, 0xFE0F }, new String[]{"barely_sunny", "sun_behind_cloud"}, 5, 54, false),
      new GoogleEmoji(new int[] { 0x1F326, 0xFE0F }, new String[]{"partly_sunny_rain", "sun_behind_rain_cloud"}, 5, 55, false),
      new GoogleEmoji(new int[] { 0x1F327, 0xFE0F }, new String[]{"rain_cloud"}, 5, 56, false),
      new GoogleEmoji(new int[] { 0x1F328, 0xFE0F }, new String[]{"snow_cloud"}, 6, 0, false),
      new GoogleEmoji(new int[] { 0x1F329, 0xFE0F }, new String[]{"lightning", "lightning_cloud"}, 6, 1, false),
      new GoogleEmoji(new int[] { 0x1F32A, 0xFE0F }, new String[]{"tornado", "tornado_cloud"}, 6, 2, false),
      new GoogleEmoji(new int[] { 0x1F32B, 0xFE0F }, new String[]{"fog"}, 6, 3, false),
      new GoogleEmoji(new int[] { 0x1F32C, 0xFE0F }, new String[]{"wind_blowing_face"}, 6, 4, false),
      new GoogleEmoji(0x1F300, new String[]{"cyclone"}, 5, 19, false),
      new GoogleEmoji(0x1F308, new String[]{"rainbow"}, 5, 27, false),
      new GoogleEmoji(0x1F302, new String[]{"closed_umbrella"}, 5, 21, false),
      new GoogleEmoji(new int[] { 0x2602, 0xFE0F }, new String[]{"umbrella"}, 52, 51, false),
      new GoogleEmoji(0x2614, new String[]{"umbrella_with_rain_drops"}, 52, 56, false),
      new GoogleEmoji(new int[] { 0x26F1, 0xFE0F }, new String[]{"umbrella_on_ground"}, 54, 12, false),
      new GoogleEmoji(0x26A1, new String[]{"zap"}, 53, 51, false),
      new GoogleEmoji(new int[] { 0x2744, 0xFE0F }, new String[]{"snowflake"}, 55, 19, false),
      new GoogleEmoji(new int[] { 0x2603, 0xFE0F }, new String[]{"snowman"}, 52, 52, false),
      new GoogleEmoji(0x26C4, new String[]{"snowman_without_snow"}, 54, 1, false),
      new GoogleEmoji(new int[] { 0x2604, 0xFE0F }, new String[]{"comet"}, 52, 53, false),
      new GoogleEmoji(0x1F525, new String[]{"fire"}, 28, 8, false),
      new GoogleEmoji(0x1F4A7, new String[]{"droplet"}, 25, 49, false),
      new GoogleEmoji(0x1F30A, new String[]{"ocean"}, 5, 29, false)
    };
  }

  private TravelAndPlacesCategoryChunk0() {
    // No instances.
  }
}
