/*
 * Decompiled with CFR 0.152.
 */
package com.vanniktech.emoji.google;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.util.LruCache;
import androidx.annotation.NonNull;
import com.vanniktech.emoji.emoji.CacheKey;
import com.vanniktech.emoji.emoji.Emoji;
import java.lang.ref.SoftReference;

public class GoogleEmoji
extends Emoji {
    private static final int CACHE_SIZE = 100;
    private static final int SPRITE_SIZE = 64;
    private static final int SPRITE_SIZE_INC_BORDER = 66;
    private static final int NUM_STRIPS = 56;
    private static final Object LOCK = new Object();
    private static final SoftReference[] STRIP_REFS = new SoftReference[56];
    private static final LruCache<CacheKey, Bitmap> BITMAP_CACHE = new LruCache(100);
    private final int x;
    private final int y;

    public GoogleEmoji(@NonNull int[] codePoints, @NonNull String[] shortcodes, int x, int y, boolean isDuplicate) {
        super(codePoints, shortcodes, -1, isDuplicate);
        this.x = x;
        this.y = y;
    }

    public GoogleEmoji(int codePoint, @NonNull String[] shortcodes, int x, int y, boolean isDuplicate) {
        super(codePoint, shortcodes, -1, isDuplicate);
        this.x = x;
        this.y = y;
    }

    public GoogleEmoji(int codePoint, @NonNull String[] shortcodes, int x, int y, boolean isDuplicate, Emoji ... variants) {
        super(codePoint, shortcodes, -1, isDuplicate, variants);
        this.x = x;
        this.y = y;
    }

    public GoogleEmoji(@NonNull int[] codePoints, @NonNull String[] shortcodes, int x, int y, boolean isDuplicate, Emoji ... variants) {
        super(codePoints, shortcodes, -1, isDuplicate, variants);
        this.x = x;
        this.y = y;
    }

    @NonNull
    public Drawable getDrawable(Context context) {
        CacheKey key = new CacheKey(this.x, this.y);
        Bitmap bitmap = (Bitmap)BITMAP_CACHE.get((Object)key);
        if (bitmap != null) {
            return new BitmapDrawable(context.getResources(), bitmap);
        }
        Bitmap strip = this.loadStrip(context);
        Bitmap cut = Bitmap.createBitmap((Bitmap)strip, (int)1, (int)(this.y * 66 + 1), (int)64, (int)64);
        BITMAP_CACHE.put((Object)key, (Object)cut);
        return new BitmapDrawable(context.getResources(), cut);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Bitmap loadStrip(Context context) {
        Bitmap strip = (Bitmap)STRIP_REFS[this.x].get();
        if (strip == null) {
            Object object = LOCK;
            synchronized (object) {
                strip = (Bitmap)STRIP_REFS[this.x].get();
                if (strip == null) {
                    Resources resources = context.getResources();
                    int resId = resources.getIdentifier("emoji_google_sheet_" + this.x, "drawable", context.getPackageName());
                    strip = BitmapFactory.decodeResource((Resources)resources, (int)resId);
                    GoogleEmoji.STRIP_REFS[this.x] = new SoftReference<Bitmap>(strip);
                }
            }
        }
        return strip;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        Object object = LOCK;
        synchronized (object) {
            BITMAP_CACHE.evictAll();
            for (int i = 0; i < 56; ++i) {
                Bitmap strip = (Bitmap)STRIP_REFS[i].get();
                if (strip == null) continue;
                strip.recycle();
                STRIP_REFS[i].clear();
            }
        }
    }

    static {
        for (int i = 0; i < 56; ++i) {
            GoogleEmoji.STRIP_REFS[i] = new SoftReference<Object>(null);
        }
    }
}

