/*
 * Decompiled with CFR 0.152.
 */
package com.vanniktech.emoji.ios;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Point;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.util.LruCache;
import com.vanniktech.emoji.Emoji;
import com.vanniktech.emoji.EmojiAndroidProvider;
import com.vanniktech.emoji.EmojiCategory;
import com.vanniktech.emoji.EmojiProvider;
import com.vanniktech.emoji.ios.IosEmoji;
import com.vanniktech.emoji.ios.R;
import com.vanniktech.emoji.ios.category.ActivitiesCategory;
import com.vanniktech.emoji.ios.category.AnimalsAndNatureCategory;
import com.vanniktech.emoji.ios.category.FlagsCategory;
import com.vanniktech.emoji.ios.category.FoodAndDrinkCategory;
import com.vanniktech.emoji.ios.category.ObjectsCategory;
import com.vanniktech.emoji.ios.category.SmileysAndPeopleCategory;
import com.vanniktech.emoji.ios.category.SymbolsCategory;
import com.vanniktech.emoji.ios.category.TravelAndPlacesCategory;
import java.lang.ref.SoftReference;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000 \u00182\u00020\u00012\u00020\u0002:\u0001\u0018B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0007H\u0016J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u001c\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u000b2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0002J\b\u0010\u0016\u001a\u00020\u0017H\u0016R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0019"}, d2={"Lcom/vanniktech/emoji/ios/IosEmojiProvider;", "Lcom/vanniktech/emoji/EmojiProvider;", "Lcom/vanniktech/emoji/EmojiAndroidProvider;", "<init>", "()V", "categories", "", "Lcom/vanniktech/emoji/EmojiCategory;", "getCategories", "()[Lcom/vanniktech/emoji/EmojiCategory;", "getIcon", "", "emojiCategory", "getDrawable", "Landroid/graphics/drawable/Drawable;", "emoji", "Lcom/vanniktech/emoji/Emoji;", "context", "Landroid/content/Context;", "loadStrip", "Landroid/graphics/Bitmap;", "x", "release", "", "Companion", "emoji-ios_release"})
@SourceDebugExtension(value={"SMAP\nIosEmojiProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IosEmojiProvider.kt\ncom/vanniktech/emoji/ios/IosEmojiProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,189:1\n1#2:190\n*E\n"})
public final class IosEmojiProvider
implements EmojiProvider,
EmojiAndroidProvider {
    @NotNull
    private static final Companion Companion = new Companion(null);
    private static final int CACHE_SIZE = 100;
    private static final int SPRITE_SIZE = 64;
    private static final int SPRITE_SIZE_INC_BORDER = 66;
    private static final int NUM_STRIPS = 61;
    @NotNull
    private static final List<Integer> SHEETS;
    @NotNull
    private static final Object LOCK;
    @NotNull
    private static final SoftReference<?>[] STRIP_REFS;
    @NotNull
    private static final LruCache<Point, Bitmap> BITMAP_CACHE;

    @NotNull
    public EmojiCategory[] getCategories() {
        EmojiCategory[] emojiCategoryArray = new EmojiCategory[]{new SmileysAndPeopleCategory(), new AnimalsAndNatureCategory(), new FoodAndDrinkCategory(), new ActivitiesCategory(), new TravelAndPlacesCategory(), new ObjectsCategory(), new SymbolsCategory(), new FlagsCategory()};
        return emojiCategoryArray;
    }

    public int getIcon(@NotNull EmojiCategory emojiCategory) {
        int n;
        Intrinsics.checkNotNullParameter((Object)emojiCategory, (String)"emojiCategory");
        EmojiCategory emojiCategory2 = emojiCategory;
        if (emojiCategory2 instanceof SmileysAndPeopleCategory) {
            n = R.drawable.emoji_ios_category_smileysandpeople;
        } else if (emojiCategory2 instanceof AnimalsAndNatureCategory) {
            n = R.drawable.emoji_ios_category_animalsandnature;
        } else if (emojiCategory2 instanceof FoodAndDrinkCategory) {
            n = R.drawable.emoji_ios_category_foodanddrink;
        } else if (emojiCategory2 instanceof ActivitiesCategory) {
            n = R.drawable.emoji_ios_category_activities;
        } else if (emojiCategory2 instanceof TravelAndPlacesCategory) {
            n = R.drawable.emoji_ios_category_travelandplaces;
        } else if (emojiCategory2 instanceof ObjectsCategory) {
            n = R.drawable.emoji_ios_category_objects;
        } else if (emojiCategory2 instanceof SymbolsCategory) {
            n = R.drawable.emoji_ios_category_symbols;
        } else if (emojiCategory2 instanceof FlagsCategory) {
            n = R.drawable.emoji_ios_category_flags;
        } else {
            throw new IllegalStateException(("Unknown " + emojiCategory).toString());
        }
        return n;
    }

    @NotNull
    public Drawable getDrawable(@NotNull Emoji emoji, @NotNull Context context) {
        Bitmap strip;
        int y;
        Intrinsics.checkNotNullParameter((Object)emoji, (String)"emoji");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (!(emoji instanceof IosEmoji)) {
            boolean $i$a$-require-IosEmojiProvider$getDrawable$22 = false;
            String $i$a$-require-IosEmojiProvider$getDrawable$22 = "emoji needs to be of type IosEmoji";
            throw new IllegalArgumentException($i$a$-require-IosEmojiProvider$getDrawable$22.toString());
        }
        int x = ((IosEmoji)emoji).getX$emoji_ios_release();
        Point key = new Point(x, y = ((IosEmoji)emoji).getY$emoji_ios_release());
        Bitmap bitmap = (Bitmap)BITMAP_CACHE.get((Object)key);
        if (bitmap != null) {
            return (Drawable)new BitmapDrawable(context.getResources(), bitmap);
        }
        Bitmap bitmap2 = strip = this.loadStrip(x, context);
        Intrinsics.checkNotNull((Object)bitmap2);
        Bitmap bitmap3 = Bitmap.createBitmap((Bitmap)bitmap2, (int)1, (int)(y * 66 + 1), (int)64, (int)64);
        Intrinsics.checkNotNullExpressionValue((Object)bitmap3, (String)"createBitmap(...)");
        Bitmap cut = bitmap3;
        BITMAP_CACHE.put((Object)key, (Object)cut);
        return (Drawable)new BitmapDrawable(context.getResources(), cut);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Bitmap loadStrip(int x, Context context) {
        Bitmap strip = null;
        SoftReference<?> softReference = STRIP_REFS[x];
        strip = (Bitmap)(softReference != null ? softReference.get() : null);
        if (strip == null) {
            Object object = LOCK;
            synchronized (object) {
                boolean bl = false;
                SoftReference<?> softReference2 = STRIP_REFS[x];
                strip = (Bitmap)(softReference2 != null ? softReference2.get() : null);
                if (strip == null) {
                    Context context2 = context;
                    Intrinsics.checkNotNull((Object)context2);
                    Resources resources = context2.getResources();
                    strip = BitmapFactory.decodeResource((Resources)resources, (int)((Number)SHEETS.get(x)).intValue());
                    IosEmojiProvider.STRIP_REFS[x] = new SoftReference<Bitmap>(strip);
                }
                Unit unit = Unit.INSTANCE;
            }
        }
        return strip;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        Object object = LOCK;
        synchronized (object) {
            boolean bl = false;
            BITMAP_CACHE.evictAll();
            for (int i = 0; i < 61; ++i) {
                SoftReference<?> softReference;
                SoftReference<?> softReference2 = softReference = STRIP_REFS[i];
                Bitmap bitmap = (Bitmap)(softReference2 != null ? softReference2.get() : null);
                if (bitmap != null) {
                    bitmap.recycle();
                }
                SoftReference<?> softReference3 = softReference;
                if (softReference3 == null) continue;
                softReference3.clear();
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    static {
        Object[] objectArray = new Integer[]{R.drawable.emoji_ios_sheet_0, R.drawable.emoji_ios_sheet_1, R.drawable.emoji_ios_sheet_2, R.drawable.emoji_ios_sheet_3, R.drawable.emoji_ios_sheet_4, R.drawable.emoji_ios_sheet_5, R.drawable.emoji_ios_sheet_6, R.drawable.emoji_ios_sheet_7, R.drawable.emoji_ios_sheet_8, R.drawable.emoji_ios_sheet_9, R.drawable.emoji_ios_sheet_10, R.drawable.emoji_ios_sheet_11, R.drawable.emoji_ios_sheet_12, R.drawable.emoji_ios_sheet_13, R.drawable.emoji_ios_sheet_14, R.drawable.emoji_ios_sheet_15, R.drawable.emoji_ios_sheet_16, R.drawable.emoji_ios_sheet_17, R.drawable.emoji_ios_sheet_18, R.drawable.emoji_ios_sheet_19, R.drawable.emoji_ios_sheet_20, R.drawable.emoji_ios_sheet_21, R.drawable.emoji_ios_sheet_22, R.drawable.emoji_ios_sheet_23, R.drawable.emoji_ios_sheet_24, R.drawable.emoji_ios_sheet_25, R.drawable.emoji_ios_sheet_26, R.drawable.emoji_ios_sheet_27, R.drawable.emoji_ios_sheet_28, R.drawable.emoji_ios_sheet_29, R.drawable.emoji_ios_sheet_30, R.drawable.emoji_ios_sheet_31, R.drawable.emoji_ios_sheet_32, R.drawable.emoji_ios_sheet_33, R.drawable.emoji_ios_sheet_34, R.drawable.emoji_ios_sheet_35, R.drawable.emoji_ios_sheet_36, R.drawable.emoji_ios_sheet_37, R.drawable.emoji_ios_sheet_38, R.drawable.emoji_ios_sheet_39, R.drawable.emoji_ios_sheet_40, R.drawable.emoji_ios_sheet_41, R.drawable.emoji_ios_sheet_42, R.drawable.emoji_ios_sheet_43, R.drawable.emoji_ios_sheet_44, R.drawable.emoji_ios_sheet_45, R.drawable.emoji_ios_sheet_46, R.drawable.emoji_ios_sheet_47, R.drawable.emoji_ios_sheet_48, R.drawable.emoji_ios_sheet_49, R.drawable.emoji_ios_sheet_50, R.drawable.emoji_ios_sheet_51, R.drawable.emoji_ios_sheet_52, R.drawable.emoji_ios_sheet_53, R.drawable.emoji_ios_sheet_54, R.drawable.emoji_ios_sheet_55, R.drawable.emoji_ios_sheet_56, R.drawable.emoji_ios_sheet_57, R.drawable.emoji_ios_sheet_58, R.drawable.emoji_ios_sheet_59, R.drawable.emoji_ios_sheet_60};
        SHEETS = CollectionsKt.listOf((Object[])objectArray);
        LOCK = new Object();
        STRIP_REFS = new SoftReference[61];
        BITMAP_CACHE = new LruCache(100);
        for (int i = 0; i < 61; ++i) {
            IosEmojiProvider.STRIP_REFS[i] = new SoftReference<Object>(null);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\f\u001a\u000e\u0012\n\u0012\b\u0012\u0002\b\u0003\u0018\u00010\u000e0\rX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000fR\u001a\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/vanniktech/emoji/ios/IosEmojiProvider$Companion;", "", "<init>", "()V", "CACHE_SIZE", "", "SPRITE_SIZE", "SPRITE_SIZE_INC_BORDER", "NUM_STRIPS", "SHEETS", "", "LOCK", "STRIP_REFS", "", "Ljava/lang/ref/SoftReference;", "[Ljava/lang/ref/SoftReference;", "BITMAP_CACHE", "Landroid/util/LruCache;", "Landroid/graphics/Point;", "Landroid/graphics/Bitmap;", "emoji-ios_release"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

