/*
 * Copyright (C) 2016 - Niklas Baudy, Ruben Gees, Mario Đanić and contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.vanniktech.emoji.twitter.category

import com.vanniktech.emoji.twitter.TwitterEmoji

internal object SmileysAndPeopleCategoryChunk1 {
  internal val EMOJIS: List<TwitterEmoji> = listOf(
    TwitterEmoji(String(intArrayOf(0x1F4A2), 0, 1), listOf("anger"), 27, 49, false),
    TwitterEmoji(String(intArrayOf(0x1F4A5), 0, 1), listOf("boom", "collision"), 27, 52, false),
    TwitterEmoji(String(intArrayOf(0x1F4AB), 0, 1), listOf("dizzy"), 28, 2, false),
    TwitterEmoji(String(intArrayOf(0x1F4A6), 0, 1), listOf("sweat_drops"), 27, 53, false),
    TwitterEmoji(String(intArrayOf(0x1F4A8), 0, 1), listOf("dash"), 27, 55, false),
    TwitterEmoji(String(intArrayOf(0x1F573, 0xFE0F), 0, 2), listOf("hole"), 30, 58, false),
    TwitterEmoji(String(intArrayOf(0x1F4A3), 0, 1), listOf("bomb"), 27, 50, false),
    TwitterEmoji(String(intArrayOf(0x1F4AC), 0, 1), listOf("speech_balloon"), 28, 3, false),
    TwitterEmoji(String(intArrayOf(0x1F441, 0xFE0F, 0x200D, 0x1F5E8, 0xFE0F), 0, 5), listOf("eye-in-speech-bubble"), 11, 53, false),
    TwitterEmoji(String(intArrayOf(0x1F5E8, 0xFE0F), 0, 2), listOf("left_speech_bubble"), 32, 11, false),
    TwitterEmoji(String(intArrayOf(0x1F5EF, 0xFE0F), 0, 2), listOf("right_anger_bubble"), 32, 12, false),
    TwitterEmoji(String(intArrayOf(0x1F4AD), 0, 1), listOf("thought_balloon"), 28, 4, false),
    TwitterEmoji(String(intArrayOf(0x1F4A4), 0, 1), listOf("zzz"), 27, 51, false),
    TwitterEmoji(
      String(intArrayOf(0x1F44B), 0, 1), listOf("wave"), 12, 38, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F44B, 0x1F3FB), 0, 2), emptyList<String>(), 12, 39, false),
        TwitterEmoji(String(intArrayOf(0x1F44B, 0x1F3FC), 0, 2), emptyList<String>(), 12, 40, false),
        TwitterEmoji(String(intArrayOf(0x1F44B, 0x1F3FD), 0, 2), emptyList<String>(), 12, 41, false),
        TwitterEmoji(String(intArrayOf(0x1F44B, 0x1F3FE), 0, 2), emptyList<String>(), 12, 42, false),
        TwitterEmoji(String(intArrayOf(0x1F44B, 0x1F3FF), 0, 2), emptyList<String>(), 12, 43, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F91A), 0, 1), listOf("raised_back_of_hand"), 39, 17, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F91A, 0x1F3FB), 0, 2), emptyList<String>(), 39, 18, false),
        TwitterEmoji(String(intArrayOf(0x1F91A, 0x1F3FC), 0, 2), emptyList<String>(), 39, 19, false),
        TwitterEmoji(String(intArrayOf(0x1F91A, 0x1F3FD), 0, 2), emptyList<String>(), 39, 20, false),
        TwitterEmoji(String(intArrayOf(0x1F91A, 0x1F3FE), 0, 2), emptyList<String>(), 39, 21, false),
        TwitterEmoji(String(intArrayOf(0x1F91A, 0x1F3FF), 0, 2), emptyList<String>(), 39, 22, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F590, 0xFE0F), 0, 2), listOf("raised_hand_with_fingers_splayed"), 31, 37, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F590, 0x1F3FB), 0, 2), emptyList<String>(), 31, 38, false),
        TwitterEmoji(String(intArrayOf(0x1F590, 0x1F3FC), 0, 2), emptyList<String>(), 31, 39, false),
        TwitterEmoji(String(intArrayOf(0x1F590, 0x1F3FD), 0, 2), emptyList<String>(), 31, 40, false),
        TwitterEmoji(String(intArrayOf(0x1F590, 0x1F3FE), 0, 2), emptyList<String>(), 31, 41, false),
        TwitterEmoji(String(intArrayOf(0x1F590, 0x1F3FF), 0, 2), emptyList<String>(), 31, 42, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x270B), 0, 1), listOf("hand", "raised_hand"), 58, 33, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x270B, 0x1F3FB), 0, 2), emptyList<String>(), 58, 34, false),
        TwitterEmoji(String(intArrayOf(0x270B, 0x1F3FC), 0, 2), emptyList<String>(), 58, 35, false),
        TwitterEmoji(String(intArrayOf(0x270B, 0x1F3FD), 0, 2), emptyList<String>(), 58, 36, false),
        TwitterEmoji(String(intArrayOf(0x270B, 0x1F3FE), 0, 2), emptyList<String>(), 58, 37, false),
        TwitterEmoji(String(intArrayOf(0x270B, 0x1F3FF), 0, 2), emptyList<String>(), 58, 38, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F596), 0, 1), listOf("spock-hand"), 31, 49, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F596, 0x1F3FB), 0, 2), emptyList<String>(), 31, 50, false),
        TwitterEmoji(String(intArrayOf(0x1F596, 0x1F3FC), 0, 2), emptyList<String>(), 31, 51, false),
        TwitterEmoji(String(intArrayOf(0x1F596, 0x1F3FD), 0, 2), emptyList<String>(), 31, 52, false),
        TwitterEmoji(String(intArrayOf(0x1F596, 0x1F3FE), 0, 2), emptyList<String>(), 31, 53, false),
        TwitterEmoji(String(intArrayOf(0x1F596, 0x1F3FF), 0, 2), emptyList<String>(), 31, 54, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1FAF1), 0, 1), listOf("rightwards_hand"), 55, 26, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1FAF1, 0x1F3FB), 0, 2), emptyList<String>(), 55, 27, false),
        TwitterEmoji(String(intArrayOf(0x1FAF1, 0x1F3FC), 0, 2), emptyList<String>(), 55, 28, false),
        TwitterEmoji(String(intArrayOf(0x1FAF1, 0x1F3FD), 0, 2), emptyList<String>(), 55, 29, false),
        TwitterEmoji(String(intArrayOf(0x1FAF1, 0x1F3FE), 0, 2), emptyList<String>(), 55, 30, false),
        TwitterEmoji(String(intArrayOf(0x1FAF1, 0x1F3FF), 0, 2), emptyList<String>(), 55, 31, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1FAF2), 0, 1), listOf("leftwards_hand"), 55, 32, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1FAF2, 0x1F3FB), 0, 2), emptyList<String>(), 55, 33, false),
        TwitterEmoji(String(intArrayOf(0x1FAF2, 0x1F3FC), 0, 2), emptyList<String>(), 55, 34, false),
        TwitterEmoji(String(intArrayOf(0x1FAF2, 0x1F3FD), 0, 2), emptyList<String>(), 55, 35, false),
        TwitterEmoji(String(intArrayOf(0x1FAF2, 0x1F3FE), 0, 2), emptyList<String>(), 55, 36, false),
        TwitterEmoji(String(intArrayOf(0x1FAF2, 0x1F3FF), 0, 2), emptyList<String>(), 55, 37, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1FAF3), 0, 1), listOf("palm_down_hand"), 55, 38, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1FAF3, 0x1F3FB), 0, 2), emptyList<String>(), 55, 39, false),
        TwitterEmoji(String(intArrayOf(0x1FAF3, 0x1F3FC), 0, 2), emptyList<String>(), 55, 40, false),
        TwitterEmoji(String(intArrayOf(0x1FAF3, 0x1F3FD), 0, 2), emptyList<String>(), 55, 41, false),
        TwitterEmoji(String(intArrayOf(0x1FAF3, 0x1F3FE), 0, 2), emptyList<String>(), 55, 42, false),
        TwitterEmoji(String(intArrayOf(0x1FAF3, 0x1F3FF), 0, 2), emptyList<String>(), 55, 43, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1FAF4), 0, 1), listOf("palm_up_hand"), 55, 44, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1FAF4, 0x1F3FB), 0, 2), emptyList<String>(), 55, 45, false),
        TwitterEmoji(String(intArrayOf(0x1FAF4, 0x1F3FC), 0, 2), emptyList<String>(), 55, 46, false),
        TwitterEmoji(String(intArrayOf(0x1FAF4, 0x1F3FD), 0, 2), emptyList<String>(), 55, 47, false),
        TwitterEmoji(String(intArrayOf(0x1FAF4, 0x1F3FE), 0, 2), emptyList<String>(), 55, 48, false),
        TwitterEmoji(String(intArrayOf(0x1FAF4, 0x1F3FF), 0, 2), emptyList<String>(), 55, 49, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F44C), 0, 1), listOf("ok_hand"), 12, 44, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F44C, 0x1F3FB), 0, 2), emptyList<String>(), 12, 45, false),
        TwitterEmoji(String(intArrayOf(0x1F44C, 0x1F3FC), 0, 2), emptyList<String>(), 12, 46, false),
        TwitterEmoji(String(intArrayOf(0x1F44C, 0x1F3FD), 0, 2), emptyList<String>(), 12, 47, false),
        TwitterEmoji(String(intArrayOf(0x1F44C, 0x1F3FE), 0, 2), emptyList<String>(), 12, 48, false),
        TwitterEmoji(String(intArrayOf(0x1F44C, 0x1F3FF), 0, 2), emptyList<String>(), 12, 49, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F90C), 0, 1), listOf("pinched_fingers"), 38, 44, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F90C, 0x1F3FB), 0, 2), emptyList<String>(), 38, 45, false),
        TwitterEmoji(String(intArrayOf(0x1F90C, 0x1F3FC), 0, 2), emptyList<String>(), 38, 46, false),
        TwitterEmoji(String(intArrayOf(0x1F90C, 0x1F3FD), 0, 2), emptyList<String>(), 38, 47, false),
        TwitterEmoji(String(intArrayOf(0x1F90C, 0x1F3FE), 0, 2), emptyList<String>(), 38, 48, false),
        TwitterEmoji(String(intArrayOf(0x1F90C, 0x1F3FF), 0, 2), emptyList<String>(), 38, 49, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F90F), 0, 1), listOf("pinching_hand"), 38, 52, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F90F, 0x1F3FB), 0, 2), emptyList<String>(), 38, 53, false),
        TwitterEmoji(String(intArrayOf(0x1F90F, 0x1F3FC), 0, 2), emptyList<String>(), 38, 54, false),
        TwitterEmoji(String(intArrayOf(0x1F90F, 0x1F3FD), 0, 2), emptyList<String>(), 38, 55, false),
        TwitterEmoji(String(intArrayOf(0x1F90F, 0x1F3FE), 0, 2), emptyList<String>(), 38, 56, false),
        TwitterEmoji(String(intArrayOf(0x1F90F, 0x1F3FF), 0, 2), emptyList<String>(), 38, 57, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x270C, 0xFE0F), 0, 2), listOf("v"), 58, 39, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x270C, 0x1F3FB), 0, 2), emptyList<String>(), 58, 40, false),
        TwitterEmoji(String(intArrayOf(0x270C, 0x1F3FC), 0, 2), emptyList<String>(), 58, 41, false),
        TwitterEmoji(String(intArrayOf(0x270C, 0x1F3FD), 0, 2), emptyList<String>(), 58, 42, false),
        TwitterEmoji(String(intArrayOf(0x270C, 0x1F3FE), 0, 2), emptyList<String>(), 58, 43, false),
        TwitterEmoji(String(intArrayOf(0x270C, 0x1F3FF), 0, 2), emptyList<String>(), 58, 44, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F91E), 0, 1), listOf("crossed_fingers", "hand_with_index_and_middle_fingers_crossed"), 40, 0, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F91E, 0x1F3FB), 0, 2), emptyList<String>(), 40, 1, false),
        TwitterEmoji(String(intArrayOf(0x1F91E, 0x1F3FC), 0, 2), emptyList<String>(), 40, 2, false),
        TwitterEmoji(String(intArrayOf(0x1F91E, 0x1F3FD), 0, 2), emptyList<String>(), 40, 3, false),
        TwitterEmoji(String(intArrayOf(0x1F91E, 0x1F3FE), 0, 2), emptyList<String>(), 40, 4, false),
        TwitterEmoji(String(intArrayOf(0x1F91E, 0x1F3FF), 0, 2), emptyList<String>(), 40, 5, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1FAF0), 0, 1), listOf("hand_with_index_finger_and_thumb_crossed"), 55, 20, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1FAF0, 0x1F3FB), 0, 2), emptyList<String>(), 55, 21, false),
        TwitterEmoji(String(intArrayOf(0x1FAF0, 0x1F3FC), 0, 2), emptyList<String>(), 55, 22, false),
        TwitterEmoji(String(intArrayOf(0x1FAF0, 0x1F3FD), 0, 2), emptyList<String>(), 55, 23, false),
        TwitterEmoji(String(intArrayOf(0x1FAF0, 0x1F3FE), 0, 2), emptyList<String>(), 55, 24, false),
        TwitterEmoji(String(intArrayOf(0x1FAF0, 0x1F3FF), 0, 2), emptyList<String>(), 55, 25, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F91F), 0, 1), listOf("i_love_you_hand_sign"), 40, 6, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F91F, 0x1F3FB), 0, 2), emptyList<String>(), 40, 7, false),
        TwitterEmoji(String(intArrayOf(0x1F91F, 0x1F3FC), 0, 2), emptyList<String>(), 40, 8, false),
        TwitterEmoji(String(intArrayOf(0x1F91F, 0x1F3FD), 0, 2), emptyList<String>(), 40, 9, false),
        TwitterEmoji(String(intArrayOf(0x1F91F, 0x1F3FE), 0, 2), emptyList<String>(), 40, 10, false),
        TwitterEmoji(String(intArrayOf(0x1F91F, 0x1F3FF), 0, 2), emptyList<String>(), 40, 11, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F918), 0, 1), listOf("the_horns", "sign_of_the_horns"), 39, 5, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F918, 0x1F3FB), 0, 2), emptyList<String>(), 39, 6, false),
        TwitterEmoji(String(intArrayOf(0x1F918, 0x1F3FC), 0, 2), emptyList<String>(), 39, 7, false),
        TwitterEmoji(String(intArrayOf(0x1F918, 0x1F3FD), 0, 2), emptyList<String>(), 39, 8, false),
        TwitterEmoji(String(intArrayOf(0x1F918, 0x1F3FE), 0, 2), emptyList<String>(), 39, 9, false),
        TwitterEmoji(String(intArrayOf(0x1F918, 0x1F3FF), 0, 2), emptyList<String>(), 39, 10, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F919), 0, 1), listOf("call_me_hand"), 39, 11, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F919, 0x1F3FB), 0, 2), emptyList<String>(), 39, 12, false),
        TwitterEmoji(String(intArrayOf(0x1F919, 0x1F3FC), 0, 2), emptyList<String>(), 39, 13, false),
        TwitterEmoji(String(intArrayOf(0x1F919, 0x1F3FD), 0, 2), emptyList<String>(), 39, 14, false),
        TwitterEmoji(String(intArrayOf(0x1F919, 0x1F3FE), 0, 2), emptyList<String>(), 39, 15, false),
        TwitterEmoji(String(intArrayOf(0x1F919, 0x1F3FF), 0, 2), emptyList<String>(), 39, 16, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F448), 0, 1), listOf("point_left"), 12, 20, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F448, 0x1F3FB), 0, 2), emptyList<String>(), 12, 21, false),
        TwitterEmoji(String(intArrayOf(0x1F448, 0x1F3FC), 0, 2), emptyList<String>(), 12, 22, false),
        TwitterEmoji(String(intArrayOf(0x1F448, 0x1F3FD), 0, 2), emptyList<String>(), 12, 23, false),
        TwitterEmoji(String(intArrayOf(0x1F448, 0x1F3FE), 0, 2), emptyList<String>(), 12, 24, false),
        TwitterEmoji(String(intArrayOf(0x1F448, 0x1F3FF), 0, 2), emptyList<String>(), 12, 25, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F449), 0, 1), listOf("point_right"), 12, 26, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F449, 0x1F3FB), 0, 2), emptyList<String>(), 12, 27, false),
        TwitterEmoji(String(intArrayOf(0x1F449, 0x1F3FC), 0, 2), emptyList<String>(), 12, 28, false),
        TwitterEmoji(String(intArrayOf(0x1F449, 0x1F3FD), 0, 2), emptyList<String>(), 12, 29, false),
        TwitterEmoji(String(intArrayOf(0x1F449, 0x1F3FE), 0, 2), emptyList<String>(), 12, 30, false),
        TwitterEmoji(String(intArrayOf(0x1F449, 0x1F3FF), 0, 2), emptyList<String>(), 12, 31, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F446), 0, 1), listOf("point_up_2"), 12, 8, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F446, 0x1F3FB), 0, 2), emptyList<String>(), 12, 9, false),
        TwitterEmoji(String(intArrayOf(0x1F446, 0x1F3FC), 0, 2), emptyList<String>(), 12, 10, false),
        TwitterEmoji(String(intArrayOf(0x1F446, 0x1F3FD), 0, 2), emptyList<String>(), 12, 11, false),
        TwitterEmoji(String(intArrayOf(0x1F446, 0x1F3FE), 0, 2), emptyList<String>(), 12, 12, false),
        TwitterEmoji(String(intArrayOf(0x1F446, 0x1F3FF), 0, 2), emptyList<String>(), 12, 13, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F595), 0, 1), listOf("middle_finger", "reversed_hand_with_middle_finger_extended"), 31, 43, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F595, 0x1F3FB), 0, 2), emptyList<String>(), 31, 44, false),
        TwitterEmoji(String(intArrayOf(0x1F595, 0x1F3FC), 0, 2), emptyList<String>(), 31, 45, false),
        TwitterEmoji(String(intArrayOf(0x1F595, 0x1F3FD), 0, 2), emptyList<String>(), 31, 46, false),
        TwitterEmoji(String(intArrayOf(0x1F595, 0x1F3FE), 0, 2), emptyList<String>(), 31, 47, false),
        TwitterEmoji(String(intArrayOf(0x1F595, 0x1F3FF), 0, 2), emptyList<String>(), 31, 48, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F447), 0, 1), listOf("point_down"), 12, 14, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F447, 0x1F3FB), 0, 2), emptyList<String>(), 12, 15, false),
        TwitterEmoji(String(intArrayOf(0x1F447, 0x1F3FC), 0, 2), emptyList<String>(), 12, 16, false),
        TwitterEmoji(String(intArrayOf(0x1F447, 0x1F3FD), 0, 2), emptyList<String>(), 12, 17, false),
        TwitterEmoji(String(intArrayOf(0x1F447, 0x1F3FE), 0, 2), emptyList<String>(), 12, 18, false),
        TwitterEmoji(String(intArrayOf(0x1F447, 0x1F3FF), 0, 2), emptyList<String>(), 12, 19, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x261D, 0xFE0F), 0, 2), listOf("point_up"), 56, 50, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x261D, 0x1F3FB), 0, 2), emptyList<String>(), 56, 51, false),
        TwitterEmoji(String(intArrayOf(0x261D, 0x1F3FC), 0, 2), emptyList<String>(), 56, 52, false),
        TwitterEmoji(String(intArrayOf(0x261D, 0x1F3FD), 0, 2), emptyList<String>(), 56, 53, false),
        TwitterEmoji(String(intArrayOf(0x261D, 0x1F3FE), 0, 2), emptyList<String>(), 56, 54, false),
        TwitterEmoji(String(intArrayOf(0x261D, 0x1F3FF), 0, 2), emptyList<String>(), 56, 55, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1FAF5), 0, 1), listOf("index_pointing_at_the_viewer"), 55, 50, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1FAF5, 0x1F3FB), 0, 2), emptyList<String>(), 55, 51, false),
        TwitterEmoji(String(intArrayOf(0x1FAF5, 0x1F3FC), 0, 2), emptyList<String>(), 55, 52, false),
        TwitterEmoji(String(intArrayOf(0x1FAF5, 0x1F3FD), 0, 2), emptyList<String>(), 55, 53, false),
        TwitterEmoji(String(intArrayOf(0x1FAF5, 0x1F3FE), 0, 2), emptyList<String>(), 55, 54, false),
        TwitterEmoji(String(intArrayOf(0x1FAF5, 0x1F3FF), 0, 2), emptyList<String>(), 55, 55, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F44D), 0, 1), listOf("+1", "thumbsup"), 12, 50, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F44D, 0x1F3FB), 0, 2), emptyList<String>(), 12, 51, false),
        TwitterEmoji(String(intArrayOf(0x1F44D, 0x1F3FC), 0, 2), emptyList<String>(), 12, 52, false),
        TwitterEmoji(String(intArrayOf(0x1F44D, 0x1F3FD), 0, 2), emptyList<String>(), 12, 53, false),
        TwitterEmoji(String(intArrayOf(0x1F44D, 0x1F3FE), 0, 2), emptyList<String>(), 12, 54, false),
        TwitterEmoji(String(intArrayOf(0x1F44D, 0x1F3FF), 0, 2), emptyList<String>(), 12, 55, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F44E), 0, 1), listOf("-1", "thumbsdown"), 12, 56, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F44E, 0x1F3FB), 0, 2), emptyList<String>(), 12, 57, false),
        TwitterEmoji(String(intArrayOf(0x1F44E, 0x1F3FC), 0, 2), emptyList<String>(), 12, 58, false),
        TwitterEmoji(String(intArrayOf(0x1F44E, 0x1F3FD), 0, 2), emptyList<String>(), 12, 59, false),
        TwitterEmoji(String(intArrayOf(0x1F44E, 0x1F3FE), 0, 2), emptyList<String>(), 12, 60, false),
        TwitterEmoji(String(intArrayOf(0x1F44E, 0x1F3FF), 0, 2), emptyList<String>(), 13, 0, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x270A), 0, 1), listOf("fist"), 58, 27, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x270A, 0x1F3FB), 0, 2), emptyList<String>(), 58, 28, false),
        TwitterEmoji(String(intArrayOf(0x270A, 0x1F3FC), 0, 2), emptyList<String>(), 58, 29, false),
        TwitterEmoji(String(intArrayOf(0x270A, 0x1F3FD), 0, 2), emptyList<String>(), 58, 30, false),
        TwitterEmoji(String(intArrayOf(0x270A, 0x1F3FE), 0, 2), emptyList<String>(), 58, 31, false),
        TwitterEmoji(String(intArrayOf(0x270A, 0x1F3FF), 0, 2), emptyList<String>(), 58, 32, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F44A), 0, 1), listOf("facepunch", "punch"), 12, 32, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F44A, 0x1F3FB), 0, 2), emptyList<String>(), 12, 33, false),
        TwitterEmoji(String(intArrayOf(0x1F44A, 0x1F3FC), 0, 2), emptyList<String>(), 12, 34, false),
        TwitterEmoji(String(intArrayOf(0x1F44A, 0x1F3FD), 0, 2), emptyList<String>(), 12, 35, false),
        TwitterEmoji(String(intArrayOf(0x1F44A, 0x1F3FE), 0, 2), emptyList<String>(), 12, 36, false),
        TwitterEmoji(String(intArrayOf(0x1F44A, 0x1F3FF), 0, 2), emptyList<String>(), 12, 37, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F91B), 0, 1), listOf("left-facing_fist"), 39, 23, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F91B, 0x1F3FB), 0, 2), emptyList<String>(), 39, 24, false),
        TwitterEmoji(String(intArrayOf(0x1F91B, 0x1F3FC), 0, 2), emptyList<String>(), 39, 25, false),
        TwitterEmoji(String(intArrayOf(0x1F91B, 0x1F3FD), 0, 2), emptyList<String>(), 39, 26, false),
        TwitterEmoji(String(intArrayOf(0x1F91B, 0x1F3FE), 0, 2), emptyList<String>(), 39, 27, false),
        TwitterEmoji(String(intArrayOf(0x1F91B, 0x1F3FF), 0, 2), emptyList<String>(), 39, 28, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F91C), 0, 1), listOf("right-facing_fist"), 39, 29, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F91C, 0x1F3FB), 0, 2), emptyList<String>(), 39, 30, false),
        TwitterEmoji(String(intArrayOf(0x1F91C, 0x1F3FC), 0, 2), emptyList<String>(), 39, 31, false),
        TwitterEmoji(String(intArrayOf(0x1F91C, 0x1F3FD), 0, 2), emptyList<String>(), 39, 32, false),
        TwitterEmoji(String(intArrayOf(0x1F91C, 0x1F3FE), 0, 2), emptyList<String>(), 39, 33, false),
        TwitterEmoji(String(intArrayOf(0x1F91C, 0x1F3FF), 0, 2), emptyList<String>(), 39, 34, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F44F), 0, 1), listOf("clap"), 13, 1, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F44F, 0x1F3FB), 0, 2), emptyList<String>(), 13, 2, false),
        TwitterEmoji(String(intArrayOf(0x1F44F, 0x1F3FC), 0, 2), emptyList<String>(), 13, 3, false),
        TwitterEmoji(String(intArrayOf(0x1F44F, 0x1F3FD), 0, 2), emptyList<String>(), 13, 4, false),
        TwitterEmoji(String(intArrayOf(0x1F44F, 0x1F3FE), 0, 2), emptyList<String>(), 13, 5, false),
        TwitterEmoji(String(intArrayOf(0x1F44F, 0x1F3FF), 0, 2), emptyList<String>(), 13, 6, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F64C), 0, 1), listOf("raised_hands"), 34, 45, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F64C, 0x1F3FB), 0, 2), emptyList<String>(), 34, 46, false),
        TwitterEmoji(String(intArrayOf(0x1F64C, 0x1F3FC), 0, 2), emptyList<String>(), 34, 47, false),
        TwitterEmoji(String(intArrayOf(0x1F64C, 0x1F3FD), 0, 2), emptyList<String>(), 34, 48, false),
        TwitterEmoji(String(intArrayOf(0x1F64C, 0x1F3FE), 0, 2), emptyList<String>(), 34, 49, false),
        TwitterEmoji(String(intArrayOf(0x1F64C, 0x1F3FF), 0, 2), emptyList<String>(), 34, 50, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1FAF6), 0, 1), listOf("heart_hands"), 55, 56, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1FAF6, 0x1F3FB), 0, 2), emptyList<String>(), 55, 57, false),
        TwitterEmoji(String(intArrayOf(0x1FAF6, 0x1F3FC), 0, 2), emptyList<String>(), 55, 58, false),
        TwitterEmoji(String(intArrayOf(0x1FAF6, 0x1F3FD), 0, 2), emptyList<String>(), 55, 59, false),
        TwitterEmoji(String(intArrayOf(0x1FAF6, 0x1F3FE), 0, 2), emptyList<String>(), 55, 60, false),
        TwitterEmoji(String(intArrayOf(0x1FAF6, 0x1F3FF), 0, 2), emptyList<String>(), 56, 0, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F450), 0, 1), listOf("open_hands"), 13, 7, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F450, 0x1F3FB), 0, 2), emptyList<String>(), 13, 8, false),
        TwitterEmoji(String(intArrayOf(0x1F450, 0x1F3FC), 0, 2), emptyList<String>(), 13, 9, false),
        TwitterEmoji(String(intArrayOf(0x1F450, 0x1F3FD), 0, 2), emptyList<String>(), 13, 10, false),
        TwitterEmoji(String(intArrayOf(0x1F450, 0x1F3FE), 0, 2), emptyList<String>(), 13, 11, false),
        TwitterEmoji(String(intArrayOf(0x1F450, 0x1F3FF), 0, 2), emptyList<String>(), 13, 12, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F932), 0, 1), listOf("palms_up_together"), 40, 57, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F932, 0x1F3FB), 0, 2), emptyList<String>(), 40, 58, false),
        TwitterEmoji(String(intArrayOf(0x1F932, 0x1F3FC), 0, 2), emptyList<String>(), 40, 59, false),
        TwitterEmoji(String(intArrayOf(0x1F932, 0x1F3FD), 0, 2), emptyList<String>(), 40, 60, false),
        TwitterEmoji(String(intArrayOf(0x1F932, 0x1F3FE), 0, 2), emptyList<String>(), 41, 0, false),
        TwitterEmoji(String(intArrayOf(0x1F932, 0x1F3FF), 0, 2), emptyList<String>(), 41, 1, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F91D), 0, 1), listOf("handshake"), 39, 35, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F91D, 0x1F3FB), 0, 2), emptyList<String>(), 39, 36, false),
        TwitterEmoji(String(intArrayOf(0x1F91D, 0x1F3FC), 0, 2), emptyList<String>(), 39, 37, false),
        TwitterEmoji(String(intArrayOf(0x1F91D, 0x1F3FD), 0, 2), emptyList<String>(), 39, 38, false),
        TwitterEmoji(String(intArrayOf(0x1F91D, 0x1F3FE), 0, 2), emptyList<String>(), 39, 39, false),
        TwitterEmoji(String(intArrayOf(0x1F91D, 0x1F3FF), 0, 2), emptyList<String>(), 39, 40, false),
        TwitterEmoji(String(intArrayOf(0x1FAF1, 0x1F3FB, 0x200D, 0x1FAF2, 0x1F3FC), 0, 5), emptyList<String>(), 39, 41, false),
        TwitterEmoji(String(intArrayOf(0x1FAF1, 0x1F3FB, 0x200D, 0x1FAF2, 0x1F3FD), 0, 5), emptyList<String>(), 39, 42, false),
        TwitterEmoji(String(intArrayOf(0x1FAF1, 0x1F3FB, 0x200D, 0x1FAF2, 0x1F3FE), 0, 5), emptyList<String>(), 39, 43, false),
        TwitterEmoji(String(intArrayOf(0x1FAF1, 0x1F3FB, 0x200D, 0x1FAF2, 0x1F3FF), 0, 5), emptyList<String>(), 39, 44, false),
        TwitterEmoji(String(intArrayOf(0x1FAF1, 0x1F3FC, 0x200D, 0x1FAF2, 0x1F3FB), 0, 5), emptyList<String>(), 39, 45, false),
        TwitterEmoji(String(intArrayOf(0x1FAF1, 0x1F3FC, 0x200D, 0x1FAF2, 0x1F3FD), 0, 5), emptyList<String>(), 39, 46, false),
        TwitterEmoji(String(intArrayOf(0x1FAF1, 0x1F3FC, 0x200D, 0x1FAF2, 0x1F3FE), 0, 5), emptyList<String>(), 39, 47, false),
        TwitterEmoji(String(intArrayOf(0x1FAF1, 0x1F3FC, 0x200D, 0x1FAF2, 0x1F3FF), 0, 5), emptyList<String>(), 39, 48, false),
        TwitterEmoji(String(intArrayOf(0x1FAF1, 0x1F3FD, 0x200D, 0x1FAF2, 0x1F3FB), 0, 5), emptyList<String>(), 39, 49, false),
        TwitterEmoji(String(intArrayOf(0x1FAF1, 0x1F3FD, 0x200D, 0x1FAF2, 0x1F3FC), 0, 5), emptyList<String>(), 39, 50, false),
        TwitterEmoji(String(intArrayOf(0x1FAF1, 0x1F3FD, 0x200D, 0x1FAF2, 0x1F3FE), 0, 5), emptyList<String>(), 39, 51, false),
        TwitterEmoji(String(intArrayOf(0x1FAF1, 0x1F3FD, 0x200D, 0x1FAF2, 0x1F3FF), 0, 5), emptyList<String>(), 39, 52, false),
        TwitterEmoji(String(intArrayOf(0x1FAF1, 0x1F3FE, 0x200D, 0x1FAF2, 0x1F3FB), 0, 5), emptyList<String>(), 39, 53, false),
        TwitterEmoji(String(intArrayOf(0x1FAF1, 0x1F3FE, 0x200D, 0x1FAF2, 0x1F3FC), 0, 5), emptyList<String>(), 39, 54, false),
        TwitterEmoji(String(intArrayOf(0x1FAF1, 0x1F3FE, 0x200D, 0x1FAF2, 0x1F3FD), 0, 5), emptyList<String>(), 39, 55, false),
        TwitterEmoji(String(intArrayOf(0x1FAF1, 0x1F3FE, 0x200D, 0x1FAF2, 0x1F3FF), 0, 5), emptyList<String>(), 39, 56, false),
        TwitterEmoji(String(intArrayOf(0x1FAF1, 0x1F3FF, 0x200D, 0x1FAF2, 0x1F3FB), 0, 5), emptyList<String>(), 39, 57, false),
        TwitterEmoji(String(intArrayOf(0x1FAF1, 0x1F3FF, 0x200D, 0x1FAF2, 0x1F3FC), 0, 5), emptyList<String>(), 39, 58, false),
        TwitterEmoji(String(intArrayOf(0x1FAF1, 0x1F3FF, 0x200D, 0x1FAF2, 0x1F3FD), 0, 5), emptyList<String>(), 39, 59, false),
        TwitterEmoji(String(intArrayOf(0x1FAF1, 0x1F3FF, 0x200D, 0x1FAF2, 0x1F3FE), 0, 5), emptyList<String>(), 39, 60, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F64F), 0, 1), listOf("pray"), 35, 26, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F64F, 0x1F3FB), 0, 2), emptyList<String>(), 35, 27, false),
        TwitterEmoji(String(intArrayOf(0x1F64F, 0x1F3FC), 0, 2), emptyList<String>(), 35, 28, false),
        TwitterEmoji(String(intArrayOf(0x1F64F, 0x1F3FD), 0, 2), emptyList<String>(), 35, 29, false),
        TwitterEmoji(String(intArrayOf(0x1F64F, 0x1F3FE), 0, 2), emptyList<String>(), 35, 30, false),
        TwitterEmoji(String(intArrayOf(0x1F64F, 0x1F3FF), 0, 2), emptyList<String>(), 35, 31, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x270D, 0xFE0F), 0, 2), listOf("writing_hand"), 58, 45, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x270D, 0x1F3FB), 0, 2), emptyList<String>(), 58, 46, false),
        TwitterEmoji(String(intArrayOf(0x270D, 0x1F3FC), 0, 2), emptyList<String>(), 58, 47, false),
        TwitterEmoji(String(intArrayOf(0x270D, 0x1F3FD), 0, 2), emptyList<String>(), 58, 48, false),
        TwitterEmoji(String(intArrayOf(0x270D, 0x1F3FE), 0, 2), emptyList<String>(), 58, 49, false),
        TwitterEmoji(String(intArrayOf(0x270D, 0x1F3FF), 0, 2), emptyList<String>(), 58, 50, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F485), 0, 1), listOf("nail_care"), 25, 53, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F485, 0x1F3FB), 0, 2), emptyList<String>(), 25, 54, false),
        TwitterEmoji(String(intArrayOf(0x1F485, 0x1F3FC), 0, 2), emptyList<String>(), 25, 55, false),
        TwitterEmoji(String(intArrayOf(0x1F485, 0x1F3FD), 0, 2), emptyList<String>(), 25, 56, false),
        TwitterEmoji(String(intArrayOf(0x1F485, 0x1F3FE), 0, 2), emptyList<String>(), 25, 57, false),
        TwitterEmoji(String(intArrayOf(0x1F485, 0x1F3FF), 0, 2), emptyList<String>(), 25, 58, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F933), 0, 1), listOf("selfie"), 41, 2, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F933, 0x1F3FB), 0, 2), emptyList<String>(), 41, 3, false),
        TwitterEmoji(String(intArrayOf(0x1F933, 0x1F3FC), 0, 2), emptyList<String>(), 41, 4, false),
        TwitterEmoji(String(intArrayOf(0x1F933, 0x1F3FD), 0, 2), emptyList<String>(), 41, 5, false),
        TwitterEmoji(String(intArrayOf(0x1F933, 0x1F3FE), 0, 2), emptyList<String>(), 41, 6, false),
        TwitterEmoji(String(intArrayOf(0x1F933, 0x1F3FF), 0, 2), emptyList<String>(), 41, 7, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F4AA), 0, 1), listOf("muscle"), 27, 57, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F4AA, 0x1F3FB), 0, 2), emptyList<String>(), 27, 58, false),
        TwitterEmoji(String(intArrayOf(0x1F4AA, 0x1F3FC), 0, 2), emptyList<String>(), 27, 59, false),
        TwitterEmoji(String(intArrayOf(0x1F4AA, 0x1F3FD), 0, 2), emptyList<String>(), 27, 60, false),
        TwitterEmoji(String(intArrayOf(0x1F4AA, 0x1F3FE), 0, 2), emptyList<String>(), 28, 0, false),
        TwitterEmoji(String(intArrayOf(0x1F4AA, 0x1F3FF), 0, 2), emptyList<String>(), 28, 1, false),
      )
    ),
    TwitterEmoji(String(intArrayOf(0x1F9BE), 0, 1), listOf("mechanical_arm"), 46, 3, false),
    TwitterEmoji(String(intArrayOf(0x1F9BF), 0, 1), listOf("mechanical_leg"), 46, 4, false),
    TwitterEmoji(
      String(intArrayOf(0x1F9B5), 0, 1), listOf("leg"), 45, 6, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F9B5, 0x1F3FB), 0, 2), emptyList<String>(), 45, 7, false),
        TwitterEmoji(String(intArrayOf(0x1F9B5, 0x1F3FC), 0, 2), emptyList<String>(), 45, 8, false),
        TwitterEmoji(String(intArrayOf(0x1F9B5, 0x1F3FD), 0, 2), emptyList<String>(), 45, 9, false),
        TwitterEmoji(String(intArrayOf(0x1F9B5, 0x1F3FE), 0, 2), emptyList<String>(), 45, 10, false),
        TwitterEmoji(String(intArrayOf(0x1F9B5, 0x1F3FF), 0, 2), emptyList<String>(), 45, 11, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F9B6), 0, 1), listOf("foot"), 45, 12, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F9B6, 0x1F3FB), 0, 2), emptyList<String>(), 45, 13, false),
        TwitterEmoji(String(intArrayOf(0x1F9B6, 0x1F3FC), 0, 2), emptyList<String>(), 45, 14, false),
        TwitterEmoji(String(intArrayOf(0x1F9B6, 0x1F3FD), 0, 2), emptyList<String>(), 45, 15, false),
        TwitterEmoji(String(intArrayOf(0x1F9B6, 0x1F3FE), 0, 2), emptyList<String>(), 45, 16, false),
        TwitterEmoji(String(intArrayOf(0x1F9B6, 0x1F3FF), 0, 2), emptyList<String>(), 45, 17, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F442), 0, 1), listOf("ear"), 11, 55, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F442, 0x1F3FB), 0, 2), emptyList<String>(), 11, 56, false),
        TwitterEmoji(String(intArrayOf(0x1F442, 0x1F3FC), 0, 2), emptyList<String>(), 11, 57, false),
        TwitterEmoji(String(intArrayOf(0x1F442, 0x1F3FD), 0, 2), emptyList<String>(), 11, 58, false),
        TwitterEmoji(String(intArrayOf(0x1F442, 0x1F3FE), 0, 2), emptyList<String>(), 11, 59, false),
        TwitterEmoji(String(intArrayOf(0x1F442, 0x1F3FF), 0, 2), emptyList<String>(), 11, 60, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F9BB), 0, 1), listOf("ear_with_hearing_aid"), 45, 56, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F9BB, 0x1F3FB), 0, 2), emptyList<String>(), 45, 57, false),
        TwitterEmoji(String(intArrayOf(0x1F9BB, 0x1F3FC), 0, 2), emptyList<String>(), 45, 58, false),
        TwitterEmoji(String(intArrayOf(0x1F9BB, 0x1F3FD), 0, 2), emptyList<String>(), 45, 59, false),
        TwitterEmoji(String(intArrayOf(0x1F9BB, 0x1F3FE), 0, 2), emptyList<String>(), 45, 60, false),
        TwitterEmoji(String(intArrayOf(0x1F9BB, 0x1F3FF), 0, 2), emptyList<String>(), 46, 0, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F443), 0, 1), listOf("nose"), 12, 0, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F443, 0x1F3FB), 0, 2), emptyList<String>(), 12, 1, false),
        TwitterEmoji(String(intArrayOf(0x1F443, 0x1F3FC), 0, 2), emptyList<String>(), 12, 2, false),
        TwitterEmoji(String(intArrayOf(0x1F443, 0x1F3FD), 0, 2), emptyList<String>(), 12, 3, false),
        TwitterEmoji(String(intArrayOf(0x1F443, 0x1F3FE), 0, 2), emptyList<String>(), 12, 4, false),
        TwitterEmoji(String(intArrayOf(0x1F443, 0x1F3FF), 0, 2), emptyList<String>(), 12, 5, false),
      )
    ),
    TwitterEmoji(String(intArrayOf(0x1F9E0), 0, 1), listOf("brain"), 53, 14, false),
    TwitterEmoji(String(intArrayOf(0x1FAC0), 0, 1), listOf("anatomical_heart"), 54, 42, false),
    TwitterEmoji(String(intArrayOf(0x1FAC1), 0, 1), listOf("lungs"), 54, 43, false),
    TwitterEmoji(String(intArrayOf(0x1F9B7), 0, 1), listOf("tooth"), 45, 18, false),
    TwitterEmoji(String(intArrayOf(0x1F9B4), 0, 1), listOf("bone"), 45, 5, false),
    TwitterEmoji(String(intArrayOf(0x1F440), 0, 1), listOf("eyes"), 11, 52, false),
    TwitterEmoji(String(intArrayOf(0x1F441, 0xFE0F), 0, 2), listOf("eye"), 11, 54, false),
    TwitterEmoji(String(intArrayOf(0x1F445), 0, 1), listOf("tongue"), 12, 7, false),
    TwitterEmoji(String(intArrayOf(0x1F444), 0, 1), listOf("lips"), 12, 6, false),
    TwitterEmoji(String(intArrayOf(0x1FAE6), 0, 1), listOf("biting_lip"), 55, 18, false),
    TwitterEmoji(
      String(intArrayOf(0x1F476), 0, 1), listOf("baby"), 24, 28, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F476, 0x1F3FB), 0, 2), emptyList<String>(), 24, 29, false),
        TwitterEmoji(String(intArrayOf(0x1F476, 0x1F3FC), 0, 2), emptyList<String>(), 24, 30, false),
        TwitterEmoji(String(intArrayOf(0x1F476, 0x1F3FD), 0, 2), emptyList<String>(), 24, 31, false),
        TwitterEmoji(String(intArrayOf(0x1F476, 0x1F3FE), 0, 2), emptyList<String>(), 24, 32, false),
        TwitterEmoji(String(intArrayOf(0x1F476, 0x1F3FF), 0, 2), emptyList<String>(), 24, 33, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F9D2), 0, 1), listOf("child"), 50, 11, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F9D2, 0x1F3FB), 0, 2), emptyList<String>(), 50, 12, false),
        TwitterEmoji(String(intArrayOf(0x1F9D2, 0x1F3FC), 0, 2), emptyList<String>(), 50, 13, false),
        TwitterEmoji(String(intArrayOf(0x1F9D2, 0x1F3FD), 0, 2), emptyList<String>(), 50, 14, false),
        TwitterEmoji(String(intArrayOf(0x1F9D2, 0x1F3FE), 0, 2), emptyList<String>(), 50, 15, false),
        TwitterEmoji(String(intArrayOf(0x1F9D2, 0x1F3FF), 0, 2), emptyList<String>(), 50, 16, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F466), 0, 1), listOf("boy"), 13, 34, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F466, 0x1F3FB), 0, 2), emptyList<String>(), 13, 35, false),
        TwitterEmoji(String(intArrayOf(0x1F466, 0x1F3FC), 0, 2), emptyList<String>(), 13, 36, false),
        TwitterEmoji(String(intArrayOf(0x1F466, 0x1F3FD), 0, 2), emptyList<String>(), 13, 37, false),
        TwitterEmoji(String(intArrayOf(0x1F466, 0x1F3FE), 0, 2), emptyList<String>(), 13, 38, false),
        TwitterEmoji(String(intArrayOf(0x1F466, 0x1F3FF), 0, 2), emptyList<String>(), 13, 39, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F467), 0, 1), listOf("girl"), 13, 40, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F467, 0x1F3FB), 0, 2), emptyList<String>(), 13, 41, false),
        TwitterEmoji(String(intArrayOf(0x1F467, 0x1F3FC), 0, 2), emptyList<String>(), 13, 42, false),
        TwitterEmoji(String(intArrayOf(0x1F467, 0x1F3FD), 0, 2), emptyList<String>(), 13, 43, false),
        TwitterEmoji(String(intArrayOf(0x1F467, 0x1F3FE), 0, 2), emptyList<String>(), 13, 44, false),
        TwitterEmoji(String(intArrayOf(0x1F467, 0x1F3FF), 0, 2), emptyList<String>(), 13, 45, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F9D1), 0, 1), listOf("adult"), 50, 5, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F9D1, 0x1F3FB), 0, 2), emptyList<String>(), 50, 6, false),
        TwitterEmoji(String(intArrayOf(0x1F9D1, 0x1F3FC), 0, 2), emptyList<String>(), 50, 7, false),
        TwitterEmoji(String(intArrayOf(0x1F9D1, 0x1F3FD), 0, 2), emptyList<String>(), 50, 8, false),
        TwitterEmoji(String(intArrayOf(0x1F9D1, 0x1F3FE), 0, 2), emptyList<String>(), 50, 9, false),
        TwitterEmoji(String(intArrayOf(0x1F9D1, 0x1F3FF), 0, 2), emptyList<String>(), 50, 10, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F471), 0, 1), listOf("person_with_blond_hair"), 23, 47, true,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F471, 0x1F3FB), 0, 2), emptyList<String>(), 23, 48, false),
        TwitterEmoji(String(intArrayOf(0x1F471, 0x1F3FC), 0, 2), emptyList<String>(), 23, 49, false),
        TwitterEmoji(String(intArrayOf(0x1F471, 0x1F3FD), 0, 2), emptyList<String>(), 23, 50, false),
        TwitterEmoji(String(intArrayOf(0x1F471, 0x1F3FE), 0, 2), emptyList<String>(), 23, 51, false),
        TwitterEmoji(String(intArrayOf(0x1F471, 0x1F3FF), 0, 2), emptyList<String>(), 23, 52, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F468), 0, 1), listOf("man"), 17, 13, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F468, 0x1F3FB), 0, 2), emptyList<String>(), 17, 14, false),
        TwitterEmoji(String(intArrayOf(0x1F468, 0x1F3FC), 0, 2), emptyList<String>(), 17, 15, false),
        TwitterEmoji(String(intArrayOf(0x1F468, 0x1F3FD), 0, 2), emptyList<String>(), 17, 16, false),
        TwitterEmoji(String(intArrayOf(0x1F468, 0x1F3FE), 0, 2), emptyList<String>(), 17, 17, false),
        TwitterEmoji(String(intArrayOf(0x1F468, 0x1F3FF), 0, 2), emptyList<String>(), 17, 18, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F9D4), 0, 1), listOf("bearded_person"), 50, 35, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F9D4, 0x1F3FB), 0, 2), emptyList<String>(), 50, 36, false),
        TwitterEmoji(String(intArrayOf(0x1F9D4, 0x1F3FC), 0, 2), emptyList<String>(), 50, 37, false),
        TwitterEmoji(String(intArrayOf(0x1F9D4, 0x1F3FD), 0, 2), emptyList<String>(), 50, 38, false),
        TwitterEmoji(String(intArrayOf(0x1F9D4, 0x1F3FE), 0, 2), emptyList<String>(), 50, 39, false),
        TwitterEmoji(String(intArrayOf(0x1F9D4, 0x1F3FF), 0, 2), emptyList<String>(), 50, 40, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F9D4, 0x200D, 0x2642, 0xFE0F), 0, 4), listOf("man_with_beard"), 50, 29, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F9D4, 0x1F3FB, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 50, 30, false),
        TwitterEmoji(String(intArrayOf(0x1F9D4, 0x1F3FC, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 50, 31, false),
        TwitterEmoji(String(intArrayOf(0x1F9D4, 0x1F3FD, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 50, 32, false),
        TwitterEmoji(String(intArrayOf(0x1F9D4, 0x1F3FE, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 50, 33, false),
        TwitterEmoji(String(intArrayOf(0x1F9D4, 0x1F3FF, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 50, 34, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F9D4, 0x200D, 0x2640, 0xFE0F), 0, 4), listOf("woman_with_beard"), 50, 23, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F9D4, 0x1F3FB, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 50, 24, false),
        TwitterEmoji(String(intArrayOf(0x1F9D4, 0x1F3FC, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 50, 25, false),
        TwitterEmoji(String(intArrayOf(0x1F9D4, 0x1F3FD, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 50, 26, false),
        TwitterEmoji(String(intArrayOf(0x1F9D4, 0x1F3FE, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 50, 27, false),
        TwitterEmoji(String(intArrayOf(0x1F9D4, 0x1F3FF, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 50, 28, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F468, 0x200D, 0x1F9B0), 0, 3), listOf("red_haired_man"), 15, 29, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F468, 0x1F3FB, 0x200D, 0x1F9B0), 0, 4), emptyList<String>(), 15, 30, false),
        TwitterEmoji(String(intArrayOf(0x1F468, 0x1F3FC, 0x200D, 0x1F9B0), 0, 4), emptyList<String>(), 15, 31, false),
        TwitterEmoji(String(intArrayOf(0x1F468, 0x1F3FD, 0x200D, 0x1F9B0), 0, 4), emptyList<String>(), 15, 32, false),
        TwitterEmoji(String(intArrayOf(0x1F468, 0x1F3FE, 0x200D, 0x1F9B0), 0, 4), emptyList<String>(), 15, 33, false),
        TwitterEmoji(String(intArrayOf(0x1F468, 0x1F3FF, 0x200D, 0x1F9B0), 0, 4), emptyList<String>(), 15, 34, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F468, 0x200D, 0x1F9B1), 0, 3), listOf("curly_haired_man"), 15, 35, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F468, 0x1F3FB, 0x200D, 0x1F9B1), 0, 4), emptyList<String>(), 15, 36, false),
        TwitterEmoji(String(intArrayOf(0x1F468, 0x1F3FC, 0x200D, 0x1F9B1), 0, 4), emptyList<String>(), 15, 37, false),
        TwitterEmoji(String(intArrayOf(0x1F468, 0x1F3FD, 0x200D, 0x1F9B1), 0, 4), emptyList<String>(), 15, 38, false),
        TwitterEmoji(String(intArrayOf(0x1F468, 0x1F3FE, 0x200D, 0x1F9B1), 0, 4), emptyList<String>(), 15, 39, false),
        TwitterEmoji(String(intArrayOf(0x1F468, 0x1F3FF, 0x200D, 0x1F9B1), 0, 4), emptyList<String>(), 15, 40, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F468, 0x200D, 0x1F9B3), 0, 3), listOf("white_haired_man"), 15, 47, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F468, 0x1F3FB, 0x200D, 0x1F9B3), 0, 4), emptyList<String>(), 15, 48, false),
        TwitterEmoji(String(intArrayOf(0x1F468, 0x1F3FC, 0x200D, 0x1F9B3), 0, 4), emptyList<String>(), 15, 49, false),
        TwitterEmoji(String(intArrayOf(0x1F468, 0x1F3FD, 0x200D, 0x1F9B3), 0, 4), emptyList<String>(), 15, 50, false),
        TwitterEmoji(String(intArrayOf(0x1F468, 0x1F3FE, 0x200D, 0x1F9B3), 0, 4), emptyList<String>(), 15, 51, false),
        TwitterEmoji(String(intArrayOf(0x1F468, 0x1F3FF, 0x200D, 0x1F9B3), 0, 4), emptyList<String>(), 15, 52, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F468, 0x200D, 0x1F9B2), 0, 3), listOf("bald_man"), 15, 41, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F468, 0x1F3FB, 0x200D, 0x1F9B2), 0, 4), emptyList<String>(), 15, 42, false),
        TwitterEmoji(String(intArrayOf(0x1F468, 0x1F3FC, 0x200D, 0x1F9B2), 0, 4), emptyList<String>(), 15, 43, false),
        TwitterEmoji(String(intArrayOf(0x1F468, 0x1F3FD, 0x200D, 0x1F9B2), 0, 4), emptyList<String>(), 15, 44, false),
        TwitterEmoji(String(intArrayOf(0x1F468, 0x1F3FE, 0x200D, 0x1F9B2), 0, 4), emptyList<String>(), 15, 45, false),
        TwitterEmoji(String(intArrayOf(0x1F468, 0x1F3FF, 0x200D, 0x1F9B2), 0, 4), emptyList<String>(), 15, 46, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F469), 0, 1), listOf("woman"), 21, 33, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FB), 0, 2), emptyList<String>(), 21, 34, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FC), 0, 2), emptyList<String>(), 21, 35, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FD), 0, 2), emptyList<String>(), 21, 36, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FE), 0, 2), emptyList<String>(), 21, 37, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FF), 0, 2), emptyList<String>(), 21, 38, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F469, 0x200D, 0x1F9B0), 0, 3), listOf("red_haired_woman"), 18, 58, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FB, 0x200D, 0x1F9B0), 0, 4), emptyList<String>(), 18, 59, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FC, 0x200D, 0x1F9B0), 0, 4), emptyList<String>(), 18, 60, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FD, 0x200D, 0x1F9B0), 0, 4), emptyList<String>(), 19, 0, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FE, 0x200D, 0x1F9B0), 0, 4), emptyList<String>(), 19, 1, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FF, 0x200D, 0x1F9B0), 0, 4), emptyList<String>(), 19, 2, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F9D1, 0x200D, 0x1F9B0), 0, 3), listOf("red_haired_person"), 49, 12, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F9D1, 0x1F3FB, 0x200D, 0x1F9B0), 0, 4), emptyList<String>(), 49, 13, false),
        TwitterEmoji(String(intArrayOf(0x1F9D1, 0x1F3FC, 0x200D, 0x1F9B0), 0, 4), emptyList<String>(), 49, 14, false),
        TwitterEmoji(String(intArrayOf(0x1F9D1, 0x1F3FD, 0x200D, 0x1F9B0), 0, 4), emptyList<String>(), 49, 15, false),
        TwitterEmoji(String(intArrayOf(0x1F9D1, 0x1F3FE, 0x200D, 0x1F9B0), 0, 4), emptyList<String>(), 49, 16, false),
        TwitterEmoji(String(intArrayOf(0x1F9D1, 0x1F3FF, 0x200D, 0x1F9B0), 0, 4), emptyList<String>(), 49, 17, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F469, 0x200D, 0x1F9B1), 0, 3), listOf("curly_haired_woman"), 19, 3, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FB, 0x200D, 0x1F9B1), 0, 4), emptyList<String>(), 19, 4, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FC, 0x200D, 0x1F9B1), 0, 4), emptyList<String>(), 19, 5, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FD, 0x200D, 0x1F9B1), 0, 4), emptyList<String>(), 19, 6, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FE, 0x200D, 0x1F9B1), 0, 4), emptyList<String>(), 19, 7, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FF, 0x200D, 0x1F9B1), 0, 4), emptyList<String>(), 19, 8, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F9D1, 0x200D, 0x1F9B1), 0, 3), listOf("curly_haired_person"), 49, 18, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F9D1, 0x1F3FB, 0x200D, 0x1F9B1), 0, 4), emptyList<String>(), 49, 19, false),
        TwitterEmoji(String(intArrayOf(0x1F9D1, 0x1F3FC, 0x200D, 0x1F9B1), 0, 4), emptyList<String>(), 49, 20, false),
        TwitterEmoji(String(intArrayOf(0x1F9D1, 0x1F3FD, 0x200D, 0x1F9B1), 0, 4), emptyList<String>(), 49, 21, false),
        TwitterEmoji(String(intArrayOf(0x1F9D1, 0x1F3FE, 0x200D, 0x1F9B1), 0, 4), emptyList<String>(), 49, 22, false),
        TwitterEmoji(String(intArrayOf(0x1F9D1, 0x1F3FF, 0x200D, 0x1F9B1), 0, 4), emptyList<String>(), 49, 23, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F469, 0x200D, 0x1F9B3), 0, 3), listOf("white_haired_woman"), 19, 15, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FB, 0x200D, 0x1F9B3), 0, 4), emptyList<String>(), 19, 16, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FC, 0x200D, 0x1F9B3), 0, 4), emptyList<String>(), 19, 17, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FD, 0x200D, 0x1F9B3), 0, 4), emptyList<String>(), 19, 18, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FE, 0x200D, 0x1F9B3), 0, 4), emptyList<String>(), 19, 19, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FF, 0x200D, 0x1F9B3), 0, 4), emptyList<String>(), 19, 20, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F9D1, 0x200D, 0x1F9B3), 0, 3), listOf("white_haired_person"), 49, 30, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F9D1, 0x1F3FB, 0x200D, 0x1F9B3), 0, 4), emptyList<String>(), 49, 31, false),
        TwitterEmoji(String(intArrayOf(0x1F9D1, 0x1F3FC, 0x200D, 0x1F9B3), 0, 4), emptyList<String>(), 49, 32, false),
        TwitterEmoji(String(intArrayOf(0x1F9D1, 0x1F3FD, 0x200D, 0x1F9B3), 0, 4), emptyList<String>(), 49, 33, false),
        TwitterEmoji(String(intArrayOf(0x1F9D1, 0x1F3FE, 0x200D, 0x1F9B3), 0, 4), emptyList<String>(), 49, 34, false),
        TwitterEmoji(String(intArrayOf(0x1F9D1, 0x1F3FF, 0x200D, 0x1F9B3), 0, 4), emptyList<String>(), 49, 35, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F469, 0x200D, 0x1F9B2), 0, 3), listOf("bald_woman"), 19, 9, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FB, 0x200D, 0x1F9B2), 0, 4), emptyList<String>(), 19, 10, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FC, 0x200D, 0x1F9B2), 0, 4), emptyList<String>(), 19, 11, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FD, 0x200D, 0x1F9B2), 0, 4), emptyList<String>(), 19, 12, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FE, 0x200D, 0x1F9B2), 0, 4), emptyList<String>(), 19, 13, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FF, 0x200D, 0x1F9B2), 0, 4), emptyList<String>(), 19, 14, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F9D1, 0x200D, 0x1F9B2), 0, 3), listOf("bald_person"), 49, 24, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F9D1, 0x1F3FB, 0x200D, 0x1F9B2), 0, 4), emptyList<String>(), 49, 25, false),
        TwitterEmoji(String(intArrayOf(0x1F9D1, 0x1F3FC, 0x200D, 0x1F9B2), 0, 4), emptyList<String>(), 49, 26, false),
        TwitterEmoji(String(intArrayOf(0x1F9D1, 0x1F3FD, 0x200D, 0x1F9B2), 0, 4), emptyList<String>(), 49, 27, false),
        TwitterEmoji(String(intArrayOf(0x1F9D1, 0x1F3FE, 0x200D, 0x1F9B2), 0, 4), emptyList<String>(), 49, 28, false),
        TwitterEmoji(String(intArrayOf(0x1F9D1, 0x1F3FF, 0x200D, 0x1F9B2), 0, 4), emptyList<String>(), 49, 29, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F471, 0x200D, 0x2640, 0xFE0F), 0, 4), listOf("blond-haired-woman"), 23, 35, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F471, 0x1F3FB, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 23, 36, false),
        TwitterEmoji(String(intArrayOf(0x1F471, 0x1F3FC, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 23, 37, false),
        TwitterEmoji(String(intArrayOf(0x1F471, 0x1F3FD, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 23, 38, false),
        TwitterEmoji(String(intArrayOf(0x1F471, 0x1F3FE, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 23, 39, false),
        TwitterEmoji(String(intArrayOf(0x1F471, 0x1F3FF, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 23, 40, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F471, 0x200D, 0x2642, 0xFE0F), 0, 4), listOf("blond-haired-man"), 23, 41, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F471, 0x1F3FB, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 23, 42, false),
        TwitterEmoji(String(intArrayOf(0x1F471, 0x1F3FC, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 23, 43, false),
        TwitterEmoji(String(intArrayOf(0x1F471, 0x1F3FD, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 23, 44, false),
        TwitterEmoji(String(intArrayOf(0x1F471, 0x1F3FE, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 23, 45, false),
        TwitterEmoji(String(intArrayOf(0x1F471, 0x1F3FF, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 23, 46, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F9D3), 0, 1), listOf("older_adult"), 50, 17, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F9D3, 0x1F3FB), 0, 2), emptyList<String>(), 50, 18, false),
        TwitterEmoji(String(intArrayOf(0x1F9D3, 0x1F3FC), 0, 2), emptyList<String>(), 50, 19, false),
        TwitterEmoji(String(intArrayOf(0x1F9D3, 0x1F3FD), 0, 2), emptyList<String>(), 50, 20, false),
        TwitterEmoji(String(intArrayOf(0x1F9D3, 0x1F3FE), 0, 2), emptyList<String>(), 50, 21, false),
        TwitterEmoji(String(intArrayOf(0x1F9D3, 0x1F3FF), 0, 2), emptyList<String>(), 50, 22, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F474), 0, 1), listOf("older_man"), 24, 16, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F474, 0x1F3FB), 0, 2), emptyList<String>(), 24, 17, false),
        TwitterEmoji(String(intArrayOf(0x1F474, 0x1F3FC), 0, 2), emptyList<String>(), 24, 18, false),
        TwitterEmoji(String(intArrayOf(0x1F474, 0x1F3FD), 0, 2), emptyList<String>(), 24, 19, false),
        TwitterEmoji(String(intArrayOf(0x1F474, 0x1F3FE), 0, 2), emptyList<String>(), 24, 20, false),
        TwitterEmoji(String(intArrayOf(0x1F474, 0x1F3FF), 0, 2), emptyList<String>(), 24, 21, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F475), 0, 1), listOf("older_woman"), 24, 22, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F475, 0x1F3FB), 0, 2), emptyList<String>(), 24, 23, false),
        TwitterEmoji(String(intArrayOf(0x1F475, 0x1F3FC), 0, 2), emptyList<String>(), 24, 24, false),
        TwitterEmoji(String(intArrayOf(0x1F475, 0x1F3FD), 0, 2), emptyList<String>(), 24, 25, false),
        TwitterEmoji(String(intArrayOf(0x1F475, 0x1F3FE), 0, 2), emptyList<String>(), 24, 26, false),
        TwitterEmoji(String(intArrayOf(0x1F475, 0x1F3FF), 0, 2), emptyList<String>(), 24, 27, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F64D), 0, 1), listOf("person_frowning"), 35, 2, true,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F64D, 0x1F3FB), 0, 2), emptyList<String>(), 35, 3, false),
        TwitterEmoji(String(intArrayOf(0x1F64D, 0x1F3FC), 0, 2), emptyList<String>(), 35, 4, false),
        TwitterEmoji(String(intArrayOf(0x1F64D, 0x1F3FD), 0, 2), emptyList<String>(), 35, 5, false),
        TwitterEmoji(String(intArrayOf(0x1F64D, 0x1F3FE), 0, 2), emptyList<String>(), 35, 6, false),
        TwitterEmoji(String(intArrayOf(0x1F64D, 0x1F3FF), 0, 2), emptyList<String>(), 35, 7, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F64D, 0x200D, 0x2642, 0xFE0F), 0, 4), listOf("man-frowning"), 34, 57, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F64D, 0x1F3FB, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 34, 58, false),
        TwitterEmoji(String(intArrayOf(0x1F64D, 0x1F3FC, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 34, 59, false),
        TwitterEmoji(String(intArrayOf(0x1F64D, 0x1F3FD, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 34, 60, false),
        TwitterEmoji(String(intArrayOf(0x1F64D, 0x1F3FE, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 35, 0, false),
        TwitterEmoji(String(intArrayOf(0x1F64D, 0x1F3FF, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 35, 1, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F64D, 0x200D, 0x2640, 0xFE0F), 0, 4), listOf("woman-frowning"), 34, 51, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F64D, 0x1F3FB, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 34, 52, false),
        TwitterEmoji(String(intArrayOf(0x1F64D, 0x1F3FC, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 34, 53, false),
        TwitterEmoji(String(intArrayOf(0x1F64D, 0x1F3FD, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 34, 54, false),
        TwitterEmoji(String(intArrayOf(0x1F64D, 0x1F3FE, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 34, 55, false),
        TwitterEmoji(String(intArrayOf(0x1F64D, 0x1F3FF, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 34, 56, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F64E), 0, 1), listOf("person_with_pouting_face"), 35, 20, true,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F64E, 0x1F3FB), 0, 2), emptyList<String>(), 35, 21, false),
        TwitterEmoji(String(intArrayOf(0x1F64E, 0x1F3FC), 0, 2), emptyList<String>(), 35, 22, false),
        TwitterEmoji(String(intArrayOf(0x1F64E, 0x1F3FD), 0, 2), emptyList<String>(), 35, 23, false),
        TwitterEmoji(String(intArrayOf(0x1F64E, 0x1F3FE), 0, 2), emptyList<String>(), 35, 24, false),
        TwitterEmoji(String(intArrayOf(0x1F64E, 0x1F3FF), 0, 2), emptyList<String>(), 35, 25, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F64E, 0x200D, 0x2642, 0xFE0F), 0, 4), listOf("man-pouting"), 35, 14, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F64E, 0x1F3FB, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 35, 15, false),
        TwitterEmoji(String(intArrayOf(0x1F64E, 0x1F3FC, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 35, 16, false),
        TwitterEmoji(String(intArrayOf(0x1F64E, 0x1F3FD, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 35, 17, false),
        TwitterEmoji(String(intArrayOf(0x1F64E, 0x1F3FE, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 35, 18, false),
        TwitterEmoji(String(intArrayOf(0x1F64E, 0x1F3FF, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 35, 19, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F64E, 0x200D, 0x2640, 0xFE0F), 0, 4), listOf("woman-pouting"), 35, 8, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F64E, 0x1F3FB, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 35, 9, false),
        TwitterEmoji(String(intArrayOf(0x1F64E, 0x1F3FC, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 35, 10, false),
        TwitterEmoji(String(intArrayOf(0x1F64E, 0x1F3FD, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 35, 11, false),
        TwitterEmoji(String(intArrayOf(0x1F64E, 0x1F3FE, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 35, 12, false),
        TwitterEmoji(String(intArrayOf(0x1F64E, 0x1F3FF, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 35, 13, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F645), 0, 1), listOf("no_good"), 33, 43, true,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F645, 0x1F3FB), 0, 2), emptyList<String>(), 33, 44, false),
        TwitterEmoji(String(intArrayOf(0x1F645, 0x1F3FC), 0, 2), emptyList<String>(), 33, 45, false),
        TwitterEmoji(String(intArrayOf(0x1F645, 0x1F3FD), 0, 2), emptyList<String>(), 33, 46, false),
        TwitterEmoji(String(intArrayOf(0x1F645, 0x1F3FE), 0, 2), emptyList<String>(), 33, 47, false),
        TwitterEmoji(String(intArrayOf(0x1F645, 0x1F3FF), 0, 2), emptyList<String>(), 33, 48, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F645, 0x200D, 0x2642, 0xFE0F), 0, 4), listOf("man-gesturing-no"), 33, 37, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F645, 0x1F3FB, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 33, 38, false),
        TwitterEmoji(String(intArrayOf(0x1F645, 0x1F3FC, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 33, 39, false),
        TwitterEmoji(String(intArrayOf(0x1F645, 0x1F3FD, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 33, 40, false),
        TwitterEmoji(String(intArrayOf(0x1F645, 0x1F3FE, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 33, 41, false),
        TwitterEmoji(String(intArrayOf(0x1F645, 0x1F3FF, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 33, 42, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F645, 0x200D, 0x2640, 0xFE0F), 0, 4), listOf("woman-gesturing-no"), 33, 31, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F645, 0x1F3FB, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 33, 32, false),
        TwitterEmoji(String(intArrayOf(0x1F645, 0x1F3FC, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 33, 33, false),
        TwitterEmoji(String(intArrayOf(0x1F645, 0x1F3FD, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 33, 34, false),
        TwitterEmoji(String(intArrayOf(0x1F645, 0x1F3FE, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 33, 35, false),
        TwitterEmoji(String(intArrayOf(0x1F645, 0x1F3FF, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 33, 36, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F646), 0, 1), listOf("ok_woman"), 34, 0, true,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F646, 0x1F3FB), 0, 2), emptyList<String>(), 34, 1, false),
        TwitterEmoji(String(intArrayOf(0x1F646, 0x1F3FC), 0, 2), emptyList<String>(), 34, 2, false),
        TwitterEmoji(String(intArrayOf(0x1F646, 0x1F3FD), 0, 2), emptyList<String>(), 34, 3, false),
        TwitterEmoji(String(intArrayOf(0x1F646, 0x1F3FE), 0, 2), emptyList<String>(), 34, 4, false),
        TwitterEmoji(String(intArrayOf(0x1F646, 0x1F3FF), 0, 2), emptyList<String>(), 34, 5, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F646, 0x200D, 0x2642, 0xFE0F), 0, 4), listOf("man-gesturing-ok"), 33, 55, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F646, 0x1F3FB, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 33, 56, false),
        TwitterEmoji(String(intArrayOf(0x1F646, 0x1F3FC, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 33, 57, false),
        TwitterEmoji(String(intArrayOf(0x1F646, 0x1F3FD, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 33, 58, false),
        TwitterEmoji(String(intArrayOf(0x1F646, 0x1F3FE, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 33, 59, false),
        TwitterEmoji(String(intArrayOf(0x1F646, 0x1F3FF, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 33, 60, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F646, 0x200D, 0x2640, 0xFE0F), 0, 4), listOf("woman-gesturing-ok"), 33, 49, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F646, 0x1F3FB, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 33, 50, false),
        TwitterEmoji(String(intArrayOf(0x1F646, 0x1F3FC, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 33, 51, false),
        TwitterEmoji(String(intArrayOf(0x1F646, 0x1F3FD, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 33, 52, false),
        TwitterEmoji(String(intArrayOf(0x1F646, 0x1F3FE, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 33, 53, false),
        TwitterEmoji(String(intArrayOf(0x1F646, 0x1F3FF, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 33, 54, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F481), 0, 1), listOf("information_desk_person"), 25, 22, true,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F481, 0x1F3FB), 0, 2), emptyList<String>(), 25, 23, false),
        TwitterEmoji(String(intArrayOf(0x1F481, 0x1F3FC), 0, 2), emptyList<String>(), 25, 24, false),
        TwitterEmoji(String(intArrayOf(0x1F481, 0x1F3FD), 0, 2), emptyList<String>(), 25, 25, false),
        TwitterEmoji(String(intArrayOf(0x1F481, 0x1F3FE), 0, 2), emptyList<String>(), 25, 26, false),
        TwitterEmoji(String(intArrayOf(0x1F481, 0x1F3FF), 0, 2), emptyList<String>(), 25, 27, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F481, 0x200D, 0x2642, 0xFE0F), 0, 4), listOf("man-tipping-hand"), 25, 16, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F481, 0x1F3FB, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 25, 17, false),
        TwitterEmoji(String(intArrayOf(0x1F481, 0x1F3FC, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 25, 18, false),
        TwitterEmoji(String(intArrayOf(0x1F481, 0x1F3FD, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 25, 19, false),
        TwitterEmoji(String(intArrayOf(0x1F481, 0x1F3FE, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 25, 20, false),
        TwitterEmoji(String(intArrayOf(0x1F481, 0x1F3FF, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 25, 21, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F481, 0x200D, 0x2640, 0xFE0F), 0, 4), listOf("woman-tipping-hand"), 25, 10, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F481, 0x1F3FB, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 25, 11, false),
        TwitterEmoji(String(intArrayOf(0x1F481, 0x1F3FC, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 25, 12, false),
        TwitterEmoji(String(intArrayOf(0x1F481, 0x1F3FD, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 25, 13, false),
        TwitterEmoji(String(intArrayOf(0x1F481, 0x1F3FE, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 25, 14, false),
        TwitterEmoji(String(intArrayOf(0x1F481, 0x1F3FF, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 25, 15, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F64B), 0, 1), listOf("raising_hand"), 34, 39, true,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F64B, 0x1F3FB), 0, 2), emptyList<String>(), 34, 40, false),
        TwitterEmoji(String(intArrayOf(0x1F64B, 0x1F3FC), 0, 2), emptyList<String>(), 34, 41, false),
        TwitterEmoji(String(intArrayOf(0x1F64B, 0x1F3FD), 0, 2), emptyList<String>(), 34, 42, false),
        TwitterEmoji(String(intArrayOf(0x1F64B, 0x1F3FE), 0, 2), emptyList<String>(), 34, 43, false),
        TwitterEmoji(String(intArrayOf(0x1F64B, 0x1F3FF), 0, 2), emptyList<String>(), 34, 44, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F64B, 0x200D, 0x2642, 0xFE0F), 0, 4), listOf("man-raising-hand"), 34, 33, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F64B, 0x1F3FB, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 34, 34, false),
        TwitterEmoji(String(intArrayOf(0x1F64B, 0x1F3FC, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 34, 35, false),
        TwitterEmoji(String(intArrayOf(0x1F64B, 0x1F3FD, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 34, 36, false),
        TwitterEmoji(String(intArrayOf(0x1F64B, 0x1F3FE, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 34, 37, false),
        TwitterEmoji(String(intArrayOf(0x1F64B, 0x1F3FF, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 34, 38, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F64B, 0x200D, 0x2640, 0xFE0F), 0, 4), listOf("woman-raising-hand"), 34, 27, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F64B, 0x1F3FB, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 34, 28, false),
        TwitterEmoji(String(intArrayOf(0x1F64B, 0x1F3FC, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 34, 29, false),
        TwitterEmoji(String(intArrayOf(0x1F64B, 0x1F3FD, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 34, 30, false),
        TwitterEmoji(String(intArrayOf(0x1F64B, 0x1F3FE, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 34, 31, false),
        TwitterEmoji(String(intArrayOf(0x1F64B, 0x1F3FF, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 34, 32, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F9CF), 0, 1), listOf("deaf_person"), 47, 5, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F9CF, 0x1F3FB), 0, 2), emptyList<String>(), 47, 6, false),
        TwitterEmoji(String(intArrayOf(0x1F9CF, 0x1F3FC), 0, 2), emptyList<String>(), 47, 7, false),
        TwitterEmoji(String(intArrayOf(0x1F9CF, 0x1F3FD), 0, 2), emptyList<String>(), 47, 8, false),
        TwitterEmoji(String(intArrayOf(0x1F9CF, 0x1F3FE), 0, 2), emptyList<String>(), 47, 9, false),
        TwitterEmoji(String(intArrayOf(0x1F9CF, 0x1F3FF), 0, 2), emptyList<String>(), 47, 10, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F9CF, 0x200D, 0x2642, 0xFE0F), 0, 4), listOf("deaf_man"), 46, 60, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F9CF, 0x1F3FB, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 47, 0, false),
        TwitterEmoji(String(intArrayOf(0x1F9CF, 0x1F3FC, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 47, 1, false),
        TwitterEmoji(String(intArrayOf(0x1F9CF, 0x1F3FD, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 47, 2, false),
        TwitterEmoji(String(intArrayOf(0x1F9CF, 0x1F3FE, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 47, 3, false),
        TwitterEmoji(String(intArrayOf(0x1F9CF, 0x1F3FF, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 47, 4, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F9CF, 0x200D, 0x2640, 0xFE0F), 0, 4), listOf("deaf_woman"), 46, 54, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F9CF, 0x1F3FB, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 46, 55, false),
        TwitterEmoji(String(intArrayOf(0x1F9CF, 0x1F3FC, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 46, 56, false),
        TwitterEmoji(String(intArrayOf(0x1F9CF, 0x1F3FD, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 46, 57, false),
        TwitterEmoji(String(intArrayOf(0x1F9CF, 0x1F3FE, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 46, 58, false),
        TwitterEmoji(String(intArrayOf(0x1F9CF, 0x1F3FF, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 46, 59, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F647), 0, 1), listOf("bow"), 34, 18, true,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F647, 0x1F3FB), 0, 2), emptyList<String>(), 34, 19, false),
        TwitterEmoji(String(intArrayOf(0x1F647, 0x1F3FC), 0, 2), emptyList<String>(), 34, 20, false),
        TwitterEmoji(String(intArrayOf(0x1F647, 0x1F3FD), 0, 2), emptyList<String>(), 34, 21, false),
        TwitterEmoji(String(intArrayOf(0x1F647, 0x1F3FE), 0, 2), emptyList<String>(), 34, 22, false),
        TwitterEmoji(String(intArrayOf(0x1F647, 0x1F3FF), 0, 2), emptyList<String>(), 34, 23, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F647, 0x200D, 0x2642, 0xFE0F), 0, 4), listOf("man-bowing"), 34, 12, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F647, 0x1F3FB, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 34, 13, false),
        TwitterEmoji(String(intArrayOf(0x1F647, 0x1F3FC, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 34, 14, false),
        TwitterEmoji(String(intArrayOf(0x1F647, 0x1F3FD, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 34, 15, false),
        TwitterEmoji(String(intArrayOf(0x1F647, 0x1F3FE, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 34, 16, false),
        TwitterEmoji(String(intArrayOf(0x1F647, 0x1F3FF, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 34, 17, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F647, 0x200D, 0x2640, 0xFE0F), 0, 4), listOf("woman-bowing"), 34, 6, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F647, 0x1F3FB, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 34, 7, false),
        TwitterEmoji(String(intArrayOf(0x1F647, 0x1F3FC, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 34, 8, false),
        TwitterEmoji(String(intArrayOf(0x1F647, 0x1F3FD, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 34, 9, false),
        TwitterEmoji(String(intArrayOf(0x1F647, 0x1F3FE, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 34, 10, false),
        TwitterEmoji(String(intArrayOf(0x1F647, 0x1F3FF, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 34, 11, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F926), 0, 1), listOf("face_palm"), 40, 30, true,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F926, 0x1F3FB), 0, 2), emptyList<String>(), 40, 31, false),
        TwitterEmoji(String(intArrayOf(0x1F926, 0x1F3FC), 0, 2), emptyList<String>(), 40, 32, false),
        TwitterEmoji(String(intArrayOf(0x1F926, 0x1F3FD), 0, 2), emptyList<String>(), 40, 33, false),
        TwitterEmoji(String(intArrayOf(0x1F926, 0x1F3FE), 0, 2), emptyList<String>(), 40, 34, false),
        TwitterEmoji(String(intArrayOf(0x1F926, 0x1F3FF), 0, 2), emptyList<String>(), 40, 35, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F926, 0x200D, 0x2642, 0xFE0F), 0, 4), listOf("man-facepalming"), 40, 24, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F926, 0x1F3FB, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 40, 25, false),
        TwitterEmoji(String(intArrayOf(0x1F926, 0x1F3FC, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 40, 26, false),
        TwitterEmoji(String(intArrayOf(0x1F926, 0x1F3FD, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 40, 27, false),
        TwitterEmoji(String(intArrayOf(0x1F926, 0x1F3FE, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 40, 28, false),
        TwitterEmoji(String(intArrayOf(0x1F926, 0x1F3FF, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 40, 29, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F926, 0x200D, 0x2640, 0xFE0F), 0, 4), listOf("woman-facepalming"), 40, 18, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F926, 0x1F3FB, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 40, 19, false),
        TwitterEmoji(String(intArrayOf(0x1F926, 0x1F3FC, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 40, 20, false),
        TwitterEmoji(String(intArrayOf(0x1F926, 0x1F3FD, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 40, 21, false),
        TwitterEmoji(String(intArrayOf(0x1F926, 0x1F3FE, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 40, 22, false),
        TwitterEmoji(String(intArrayOf(0x1F926, 0x1F3FF, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 40, 23, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F937), 0, 1), listOf("shrug"), 41, 50, true,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F937, 0x1F3FB), 0, 2), emptyList<String>(), 41, 51, false),
        TwitterEmoji(String(intArrayOf(0x1F937, 0x1F3FC), 0, 2), emptyList<String>(), 41, 52, false),
        TwitterEmoji(String(intArrayOf(0x1F937, 0x1F3FD), 0, 2), emptyList<String>(), 41, 53, false),
        TwitterEmoji(String(intArrayOf(0x1F937, 0x1F3FE), 0, 2), emptyList<String>(), 41, 54, false),
        TwitterEmoji(String(intArrayOf(0x1F937, 0x1F3FF), 0, 2), emptyList<String>(), 41, 55, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F937, 0x200D, 0x2642, 0xFE0F), 0, 4), listOf("man-shrugging"), 41, 44, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F937, 0x1F3FB, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 41, 45, false),
        TwitterEmoji(String(intArrayOf(0x1F937, 0x1F3FC, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 41, 46, false),
        TwitterEmoji(String(intArrayOf(0x1F937, 0x1F3FD, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 41, 47, false),
        TwitterEmoji(String(intArrayOf(0x1F937, 0x1F3FE, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 41, 48, false),
        TwitterEmoji(String(intArrayOf(0x1F937, 0x1F3FF, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 41, 49, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F937, 0x200D, 0x2640, 0xFE0F), 0, 4), listOf("woman-shrugging"), 41, 38, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F937, 0x1F3FB, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 41, 39, false),
        TwitterEmoji(String(intArrayOf(0x1F937, 0x1F3FC, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 41, 40, false),
        TwitterEmoji(String(intArrayOf(0x1F937, 0x1F3FD, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 41, 41, false),
        TwitterEmoji(String(intArrayOf(0x1F937, 0x1F3FE, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 41, 42, false),
        TwitterEmoji(String(intArrayOf(0x1F937, 0x1F3FF, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 41, 43, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F9D1, 0x200D, 0x2695, 0xFE0F), 0, 4), listOf("health_worker"), 49, 48, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F9D1, 0x1F3FB, 0x200D, 0x2695, 0xFE0F), 0, 5), emptyList<String>(), 49, 49, false),
        TwitterEmoji(String(intArrayOf(0x1F9D1, 0x1F3FC, 0x200D, 0x2695, 0xFE0F), 0, 5), emptyList<String>(), 49, 50, false),
        TwitterEmoji(String(intArrayOf(0x1F9D1, 0x1F3FD, 0x200D, 0x2695, 0xFE0F), 0, 5), emptyList<String>(), 49, 51, false),
        TwitterEmoji(String(intArrayOf(0x1F9D1, 0x1F3FE, 0x200D, 0x2695, 0xFE0F), 0, 5), emptyList<String>(), 49, 52, false),
        TwitterEmoji(String(intArrayOf(0x1F9D1, 0x1F3FF, 0x200D, 0x2695, 0xFE0F), 0, 5), emptyList<String>(), 49, 53, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F468, 0x200D, 0x2695, 0xFE0F), 0, 4), listOf("male-doctor"), 16, 4, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F468, 0x1F3FB, 0x200D, 0x2695, 0xFE0F), 0, 5), emptyList<String>(), 16, 5, false),
        TwitterEmoji(String(intArrayOf(0x1F468, 0x1F3FC, 0x200D, 0x2695, 0xFE0F), 0, 5), emptyList<String>(), 16, 6, false),
        TwitterEmoji(String(intArrayOf(0x1F468, 0x1F3FD, 0x200D, 0x2695, 0xFE0F), 0, 5), emptyList<String>(), 16, 7, false),
        TwitterEmoji(String(intArrayOf(0x1F468, 0x1F3FE, 0x200D, 0x2695, 0xFE0F), 0, 5), emptyList<String>(), 16, 8, false),
        TwitterEmoji(String(intArrayOf(0x1F468, 0x1F3FF, 0x200D, 0x2695, 0xFE0F), 0, 5), emptyList<String>(), 16, 9, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F469, 0x200D, 0x2695, 0xFE0F), 0, 4), listOf("female-doctor"), 19, 33, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FB, 0x200D, 0x2695, 0xFE0F), 0, 5), emptyList<String>(), 19, 34, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FC, 0x200D, 0x2695, 0xFE0F), 0, 5), emptyList<String>(), 19, 35, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FD, 0x200D, 0x2695, 0xFE0F), 0, 5), emptyList<String>(), 19, 36, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FE, 0x200D, 0x2695, 0xFE0F), 0, 5), emptyList<String>(), 19, 37, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FF, 0x200D, 0x2695, 0xFE0F), 0, 5), emptyList<String>(), 19, 38, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F9D1, 0x200D, 0x1F393), 0, 3), listOf("student"), 47, 36, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F9D1, 0x1F3FB, 0x200D, 0x1F393), 0, 4), emptyList<String>(), 47, 37, false),
        TwitterEmoji(String(intArrayOf(0x1F9D1, 0x1F3FC, 0x200D, 0x1F393), 0, 4), emptyList<String>(), 47, 38, false),
        TwitterEmoji(String(intArrayOf(0x1F9D1, 0x1F3FD, 0x200D, 0x1F393), 0, 4), emptyList<String>(), 47, 39, false),
        TwitterEmoji(String(intArrayOf(0x1F9D1, 0x1F3FE, 0x200D, 0x1F393), 0, 4), emptyList<String>(), 47, 40, false),
        TwitterEmoji(String(intArrayOf(0x1F9D1, 0x1F3FF, 0x200D, 0x1F393), 0, 4), emptyList<String>(), 47, 41, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F468, 0x200D, 0x1F393), 0, 3), listOf("male-student"), 14, 3, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F468, 0x1F3FB, 0x200D, 0x1F393), 0, 4), emptyList<String>(), 14, 4, false),
        TwitterEmoji(String(intArrayOf(0x1F468, 0x1F3FC, 0x200D, 0x1F393), 0, 4), emptyList<String>(), 14, 5, false),
        TwitterEmoji(String(intArrayOf(0x1F468, 0x1F3FD, 0x200D, 0x1F393), 0, 4), emptyList<String>(), 14, 6, false),
        TwitterEmoji(String(intArrayOf(0x1F468, 0x1F3FE, 0x200D, 0x1F393), 0, 4), emptyList<String>(), 14, 7, false),
        TwitterEmoji(String(intArrayOf(0x1F468, 0x1F3FF, 0x200D, 0x1F393), 0, 4), emptyList<String>(), 14, 8, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F469, 0x200D, 0x1F393), 0, 3), listOf("female-student"), 17, 37, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FB, 0x200D, 0x1F393), 0, 4), emptyList<String>(), 17, 38, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FC, 0x200D, 0x1F393), 0, 4), emptyList<String>(), 17, 39, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FD, 0x200D, 0x1F393), 0, 4), emptyList<String>(), 17, 40, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FE, 0x200D, 0x1F393), 0, 4), emptyList<String>(), 17, 41, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FF, 0x200D, 0x1F393), 0, 4), emptyList<String>(), 17, 42, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F9D1, 0x200D, 0x1F3EB), 0, 3), listOf("teacher"), 47, 54, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F9D1, 0x1F3FB, 0x200D, 0x1F3EB), 0, 4), emptyList<String>(), 47, 55, false),
        TwitterEmoji(String(intArrayOf(0x1F9D1, 0x1F3FC, 0x200D, 0x1F3EB), 0, 4), emptyList<String>(), 47, 56, false),
        TwitterEmoji(String(intArrayOf(0x1F9D1, 0x1F3FD, 0x200D, 0x1F3EB), 0, 4), emptyList<String>(), 47, 57, false),
        TwitterEmoji(String(intArrayOf(0x1F9D1, 0x1F3FE, 0x200D, 0x1F3EB), 0, 4), emptyList<String>(), 47, 58, false),
        TwitterEmoji(String(intArrayOf(0x1F9D1, 0x1F3FF, 0x200D, 0x1F3EB), 0, 4), emptyList<String>(), 47, 59, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F468, 0x200D, 0x1F3EB), 0, 3), listOf("male-teacher"), 14, 21, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F468, 0x1F3FB, 0x200D, 0x1F3EB), 0, 4), emptyList<String>(), 14, 22, false),
        TwitterEmoji(String(intArrayOf(0x1F468, 0x1F3FC, 0x200D, 0x1F3EB), 0, 4), emptyList<String>(), 14, 23, false),
        TwitterEmoji(String(intArrayOf(0x1F468, 0x1F3FD, 0x200D, 0x1F3EB), 0, 4), emptyList<String>(), 14, 24, false),
        TwitterEmoji(String(intArrayOf(0x1F468, 0x1F3FE, 0x200D, 0x1F3EB), 0, 4), emptyList<String>(), 14, 25, false),
        TwitterEmoji(String(intArrayOf(0x1F468, 0x1F3FF, 0x200D, 0x1F3EB), 0, 4), emptyList<String>(), 14, 26, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F469, 0x200D, 0x1F3EB), 0, 3), listOf("female-teacher"), 17, 55, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FB, 0x200D, 0x1F3EB), 0, 4), emptyList<String>(), 17, 56, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FC, 0x200D, 0x1F3EB), 0, 4), emptyList<String>(), 17, 57, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FD, 0x200D, 0x1F3EB), 0, 4), emptyList<String>(), 17, 58, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FE, 0x200D, 0x1F3EB), 0, 4), emptyList<String>(), 17, 59, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FF, 0x200D, 0x1F3EB), 0, 4), emptyList<String>(), 17, 60, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F9D1, 0x200D, 0x2696, 0xFE0F), 0, 4), listOf("judge"), 49, 54, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F9D1, 0x1F3FB, 0x200D, 0x2696, 0xFE0F), 0, 5), emptyList<String>(), 49, 55, false),
        TwitterEmoji(String(intArrayOf(0x1F9D1, 0x1F3FC, 0x200D, 0x2696, 0xFE0F), 0, 5), emptyList<String>(), 49, 56, false),
        TwitterEmoji(String(intArrayOf(0x1F9D1, 0x1F3FD, 0x200D, 0x2696, 0xFE0F), 0, 5), emptyList<String>(), 49, 57, false),
        TwitterEmoji(String(intArrayOf(0x1F9D1, 0x1F3FE, 0x200D, 0x2696, 0xFE0F), 0, 5), emptyList<String>(), 49, 58, false),
        TwitterEmoji(String(intArrayOf(0x1F9D1, 0x1F3FF, 0x200D, 0x2696, 0xFE0F), 0, 5), emptyList<String>(), 49, 59, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F468, 0x200D, 0x2696, 0xFE0F), 0, 4), listOf("male-judge"), 16, 10, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F468, 0x1F3FB, 0x200D, 0x2696, 0xFE0F), 0, 5), emptyList<String>(), 16, 11, false),
        TwitterEmoji(String(intArrayOf(0x1F468, 0x1F3FC, 0x200D, 0x2696, 0xFE0F), 0, 5), emptyList<String>(), 16, 12, false),
        TwitterEmoji(String(intArrayOf(0x1F468, 0x1F3FD, 0x200D, 0x2696, 0xFE0F), 0, 5), emptyList<String>(), 16, 13, false),
        TwitterEmoji(String(intArrayOf(0x1F468, 0x1F3FE, 0x200D, 0x2696, 0xFE0F), 0, 5), emptyList<String>(), 16, 14, false),
        TwitterEmoji(String(intArrayOf(0x1F468, 0x1F3FF, 0x200D, 0x2696, 0xFE0F), 0, 5), emptyList<String>(), 16, 15, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F469, 0x200D, 0x2696, 0xFE0F), 0, 4), listOf("female-judge"), 19, 39, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FB, 0x200D, 0x2696, 0xFE0F), 0, 5), emptyList<String>(), 19, 40, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FC, 0x200D, 0x2696, 0xFE0F), 0, 5), emptyList<String>(), 19, 41, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FD, 0x200D, 0x2696, 0xFE0F), 0, 5), emptyList<String>(), 19, 42, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FE, 0x200D, 0x2696, 0xFE0F), 0, 5), emptyList<String>(), 19, 43, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FF, 0x200D, 0x2696, 0xFE0F), 0, 5), emptyList<String>(), 19, 44, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F9D1, 0x200D, 0x1F33E), 0, 3), listOf("farmer"), 47, 12, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F9D1, 0x1F3FB, 0x200D, 0x1F33E), 0, 4), emptyList<String>(), 47, 13, false),
        TwitterEmoji(String(intArrayOf(0x1F9D1, 0x1F3FC, 0x200D, 0x1F33E), 0, 4), emptyList<String>(), 47, 14, false),
        TwitterEmoji(String(intArrayOf(0x1F9D1, 0x1F3FD, 0x200D, 0x1F33E), 0, 4), emptyList<String>(), 47, 15, false),
        TwitterEmoji(String(intArrayOf(0x1F9D1, 0x1F3FE, 0x200D, 0x1F33E), 0, 4), emptyList<String>(), 47, 16, false),
        TwitterEmoji(String(intArrayOf(0x1F9D1, 0x1F3FF, 0x200D, 0x1F33E), 0, 4), emptyList<String>(), 47, 17, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F468, 0x200D, 0x1F33E), 0, 3), listOf("male-farmer"), 13, 46, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F468, 0x1F3FB, 0x200D, 0x1F33E), 0, 4), emptyList<String>(), 13, 47, false),
        TwitterEmoji(String(intArrayOf(0x1F468, 0x1F3FC, 0x200D, 0x1F33E), 0, 4), emptyList<String>(), 13, 48, false),
        TwitterEmoji(String(intArrayOf(0x1F468, 0x1F3FD, 0x200D, 0x1F33E), 0, 4), emptyList<String>(), 13, 49, false),
        TwitterEmoji(String(intArrayOf(0x1F468, 0x1F3FE, 0x200D, 0x1F33E), 0, 4), emptyList<String>(), 13, 50, false),
        TwitterEmoji(String(intArrayOf(0x1F468, 0x1F3FF, 0x200D, 0x1F33E), 0, 4), emptyList<String>(), 13, 51, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F469, 0x200D, 0x1F33E), 0, 3), listOf("female-farmer"), 17, 19, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FB, 0x200D, 0x1F33E), 0, 4), emptyList<String>(), 17, 20, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FC, 0x200D, 0x1F33E), 0, 4), emptyList<String>(), 17, 21, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FD, 0x200D, 0x1F33E), 0, 4), emptyList<String>(), 17, 22, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FE, 0x200D, 0x1F33E), 0, 4), emptyList<String>(), 17, 23, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FF, 0x200D, 0x1F33E), 0, 4), emptyList<String>(), 17, 24, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F9D1, 0x200D, 0x1F373), 0, 3), listOf("cook"), 47, 18, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F9D1, 0x1F3FB, 0x200D, 0x1F373), 0, 4), emptyList<String>(), 47, 19, false),
        TwitterEmoji(String(intArrayOf(0x1F9D1, 0x1F3FC, 0x200D, 0x1F373), 0, 4), emptyList<String>(), 47, 20, false),
        TwitterEmoji(String(intArrayOf(0x1F9D1, 0x1F3FD, 0x200D, 0x1F373), 0, 4), emptyList<String>(), 47, 21, false),
        TwitterEmoji(String(intArrayOf(0x1F9D1, 0x1F3FE, 0x200D, 0x1F373), 0, 4), emptyList<String>(), 47, 22, false),
        TwitterEmoji(String(intArrayOf(0x1F9D1, 0x1F3FF, 0x200D, 0x1F373), 0, 4), emptyList<String>(), 47, 23, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F468, 0x200D, 0x1F373), 0, 3), listOf("male-cook"), 13, 52, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F468, 0x1F3FB, 0x200D, 0x1F373), 0, 4), emptyList<String>(), 13, 53, false),
        TwitterEmoji(String(intArrayOf(0x1F468, 0x1F3FC, 0x200D, 0x1F373), 0, 4), emptyList<String>(), 13, 54, false),
        TwitterEmoji(String(intArrayOf(0x1F468, 0x1F3FD, 0x200D, 0x1F373), 0, 4), emptyList<String>(), 13, 55, false),
        TwitterEmoji(String(intArrayOf(0x1F468, 0x1F3FE, 0x200D, 0x1F373), 0, 4), emptyList<String>(), 13, 56, false),
        TwitterEmoji(String(intArrayOf(0x1F468, 0x1F3FF, 0x200D, 0x1F373), 0, 4), emptyList<String>(), 13, 57, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F469, 0x200D, 0x1F373), 0, 3), listOf("female-cook"), 17, 25, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FB, 0x200D, 0x1F373), 0, 4), emptyList<String>(), 17, 26, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FC, 0x200D, 0x1F373), 0, 4), emptyList<String>(), 17, 27, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FD, 0x200D, 0x1F373), 0, 4), emptyList<String>(), 17, 28, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FE, 0x200D, 0x1F373), 0, 4), emptyList<String>(), 17, 29, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FF, 0x200D, 0x1F373), 0, 4), emptyList<String>(), 17, 30, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F9D1, 0x200D, 0x1F527), 0, 3), listOf("mechanic"), 48, 17, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F9D1, 0x1F3FB, 0x200D, 0x1F527), 0, 4), emptyList<String>(), 48, 18, false),
        TwitterEmoji(String(intArrayOf(0x1F9D1, 0x1F3FC, 0x200D, 0x1F527), 0, 4), emptyList<String>(), 48, 19, false),
        TwitterEmoji(String(intArrayOf(0x1F9D1, 0x1F3FD, 0x200D, 0x1F527), 0, 4), emptyList<String>(), 48, 20, false),
        TwitterEmoji(String(intArrayOf(0x1F9D1, 0x1F3FE, 0x200D, 0x1F527), 0, 4), emptyList<String>(), 48, 21, false),
        TwitterEmoji(String(intArrayOf(0x1F9D1, 0x1F3FF, 0x200D, 0x1F527), 0, 4), emptyList<String>(), 48, 22, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F468, 0x200D, 0x1F527), 0, 3), listOf("male-mechanic"), 14, 60, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F468, 0x1F3FB, 0x200D, 0x1F527), 0, 4), emptyList<String>(), 15, 0, false),
        TwitterEmoji(String(intArrayOf(0x1F468, 0x1F3FC, 0x200D, 0x1F527), 0, 4), emptyList<String>(), 15, 1, false),
        TwitterEmoji(String(intArrayOf(0x1F468, 0x1F3FD, 0x200D, 0x1F527), 0, 4), emptyList<String>(), 15, 2, false),
        TwitterEmoji(String(intArrayOf(0x1F468, 0x1F3FE, 0x200D, 0x1F527), 0, 4), emptyList<String>(), 15, 3, false),
        TwitterEmoji(String(intArrayOf(0x1F468, 0x1F3FF, 0x200D, 0x1F527), 0, 4), emptyList<String>(), 15, 4, false),
      )
    ),
  )
}
