/*
 * Copyright (C) 2016 - Niklas Baudy, Ruben Gees, Mario Đanić and contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.vanniktech.emoji.twitter.category

import com.vanniktech.emoji.twitter.TwitterEmoji

internal object SmileysAndPeopleCategoryChunk2 {
  internal val EMOJIS: List<TwitterEmoji> = listOf(
    TwitterEmoji(
      String(intArrayOf(0x1F469, 0x200D, 0x1F527), 0, 3), listOf("female-mechanic"), 18, 28, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FB, 0x200D, 0x1F527), 0, 4), emptyList<String>(), 18, 29, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FC, 0x200D, 0x1F527), 0, 4), emptyList<String>(), 18, 30, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FD, 0x200D, 0x1F527), 0, 4), emptyList<String>(), 18, 31, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FE, 0x200D, 0x1F527), 0, 4), emptyList<String>(), 18, 32, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FF, 0x200D, 0x1F527), 0, 4), emptyList<String>(), 18, 33, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F9D1, 0x200D, 0x1F3ED), 0, 3), listOf("factory_worker"), 47, 60, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F9D1, 0x1F3FB, 0x200D, 0x1F3ED), 0, 4), emptyList<String>(), 48, 0, false),
        TwitterEmoji(String(intArrayOf(0x1F9D1, 0x1F3FC, 0x200D, 0x1F3ED), 0, 4), emptyList<String>(), 48, 1, false),
        TwitterEmoji(String(intArrayOf(0x1F9D1, 0x1F3FD, 0x200D, 0x1F3ED), 0, 4), emptyList<String>(), 48, 2, false),
        TwitterEmoji(String(intArrayOf(0x1F9D1, 0x1F3FE, 0x200D, 0x1F3ED), 0, 4), emptyList<String>(), 48, 3, false),
        TwitterEmoji(String(intArrayOf(0x1F9D1, 0x1F3FF, 0x200D, 0x1F3ED), 0, 4), emptyList<String>(), 48, 4, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F468, 0x200D, 0x1F3ED), 0, 3), listOf("male-factory-worker"), 14, 27, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F468, 0x1F3FB, 0x200D, 0x1F3ED), 0, 4), emptyList<String>(), 14, 28, false),
        TwitterEmoji(String(intArrayOf(0x1F468, 0x1F3FC, 0x200D, 0x1F3ED), 0, 4), emptyList<String>(), 14, 29, false),
        TwitterEmoji(String(intArrayOf(0x1F468, 0x1F3FD, 0x200D, 0x1F3ED), 0, 4), emptyList<String>(), 14, 30, false),
        TwitterEmoji(String(intArrayOf(0x1F468, 0x1F3FE, 0x200D, 0x1F3ED), 0, 4), emptyList<String>(), 14, 31, false),
        TwitterEmoji(String(intArrayOf(0x1F468, 0x1F3FF, 0x200D, 0x1F3ED), 0, 4), emptyList<String>(), 14, 32, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F469, 0x200D, 0x1F3ED), 0, 3), listOf("female-factory-worker"), 18, 0, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FB, 0x200D, 0x1F3ED), 0, 4), emptyList<String>(), 18, 1, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FC, 0x200D, 0x1F3ED), 0, 4), emptyList<String>(), 18, 2, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FD, 0x200D, 0x1F3ED), 0, 4), emptyList<String>(), 18, 3, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FE, 0x200D, 0x1F3ED), 0, 4), emptyList<String>(), 18, 4, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FF, 0x200D, 0x1F3ED), 0, 4), emptyList<String>(), 18, 5, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F9D1, 0x200D, 0x1F4BC), 0, 3), listOf("office_worker"), 48, 11, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F9D1, 0x1F3FB, 0x200D, 0x1F4BC), 0, 4), emptyList<String>(), 48, 12, false),
        TwitterEmoji(String(intArrayOf(0x1F9D1, 0x1F3FC, 0x200D, 0x1F4BC), 0, 4), emptyList<String>(), 48, 13, false),
        TwitterEmoji(String(intArrayOf(0x1F9D1, 0x1F3FD, 0x200D, 0x1F4BC), 0, 4), emptyList<String>(), 48, 14, false),
        TwitterEmoji(String(intArrayOf(0x1F9D1, 0x1F3FE, 0x200D, 0x1F4BC), 0, 4), emptyList<String>(), 48, 15, false),
        TwitterEmoji(String(intArrayOf(0x1F9D1, 0x1F3FF, 0x200D, 0x1F4BC), 0, 4), emptyList<String>(), 48, 16, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F468, 0x200D, 0x1F4BC), 0, 3), listOf("male-office-worker"), 14, 54, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F468, 0x1F3FB, 0x200D, 0x1F4BC), 0, 4), emptyList<String>(), 14, 55, false),
        TwitterEmoji(String(intArrayOf(0x1F468, 0x1F3FC, 0x200D, 0x1F4BC), 0, 4), emptyList<String>(), 14, 56, false),
        TwitterEmoji(String(intArrayOf(0x1F468, 0x1F3FD, 0x200D, 0x1F4BC), 0, 4), emptyList<String>(), 14, 57, false),
        TwitterEmoji(String(intArrayOf(0x1F468, 0x1F3FE, 0x200D, 0x1F4BC), 0, 4), emptyList<String>(), 14, 58, false),
        TwitterEmoji(String(intArrayOf(0x1F468, 0x1F3FF, 0x200D, 0x1F4BC), 0, 4), emptyList<String>(), 14, 59, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F469, 0x200D, 0x1F4BC), 0, 3), listOf("female-office-worker"), 18, 22, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FB, 0x200D, 0x1F4BC), 0, 4), emptyList<String>(), 18, 23, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FC, 0x200D, 0x1F4BC), 0, 4), emptyList<String>(), 18, 24, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FD, 0x200D, 0x1F4BC), 0, 4), emptyList<String>(), 18, 25, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FE, 0x200D, 0x1F4BC), 0, 4), emptyList<String>(), 18, 26, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FF, 0x200D, 0x1F4BC), 0, 4), emptyList<String>(), 18, 27, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F9D1, 0x200D, 0x1F52C), 0, 3), listOf("scientist"), 48, 23, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F9D1, 0x1F3FB, 0x200D, 0x1F52C), 0, 4), emptyList<String>(), 48, 24, false),
        TwitterEmoji(String(intArrayOf(0x1F9D1, 0x1F3FC, 0x200D, 0x1F52C), 0, 4), emptyList<String>(), 48, 25, false),
        TwitterEmoji(String(intArrayOf(0x1F9D1, 0x1F3FD, 0x200D, 0x1F52C), 0, 4), emptyList<String>(), 48, 26, false),
        TwitterEmoji(String(intArrayOf(0x1F9D1, 0x1F3FE, 0x200D, 0x1F52C), 0, 4), emptyList<String>(), 48, 27, false),
        TwitterEmoji(String(intArrayOf(0x1F9D1, 0x1F3FF, 0x200D, 0x1F52C), 0, 4), emptyList<String>(), 48, 28, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F468, 0x200D, 0x1F52C), 0, 3), listOf("male-scientist"), 15, 5, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F468, 0x1F3FB, 0x200D, 0x1F52C), 0, 4), emptyList<String>(), 15, 6, false),
        TwitterEmoji(String(intArrayOf(0x1F468, 0x1F3FC, 0x200D, 0x1F52C), 0, 4), emptyList<String>(), 15, 7, false),
        TwitterEmoji(String(intArrayOf(0x1F468, 0x1F3FD, 0x200D, 0x1F52C), 0, 4), emptyList<String>(), 15, 8, false),
        TwitterEmoji(String(intArrayOf(0x1F468, 0x1F3FE, 0x200D, 0x1F52C), 0, 4), emptyList<String>(), 15, 9, false),
        TwitterEmoji(String(intArrayOf(0x1F468, 0x1F3FF, 0x200D, 0x1F52C), 0, 4), emptyList<String>(), 15, 10, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F469, 0x200D, 0x1F52C), 0, 3), listOf("female-scientist"), 18, 34, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FB, 0x200D, 0x1F52C), 0, 4), emptyList<String>(), 18, 35, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FC, 0x200D, 0x1F52C), 0, 4), emptyList<String>(), 18, 36, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FD, 0x200D, 0x1F52C), 0, 4), emptyList<String>(), 18, 37, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FE, 0x200D, 0x1F52C), 0, 4), emptyList<String>(), 18, 38, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FF, 0x200D, 0x1F52C), 0, 4), emptyList<String>(), 18, 39, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F9D1, 0x200D, 0x1F4BB), 0, 3), listOf("technologist"), 48, 5, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F9D1, 0x1F3FB, 0x200D, 0x1F4BB), 0, 4), emptyList<String>(), 48, 6, false),
        TwitterEmoji(String(intArrayOf(0x1F9D1, 0x1F3FC, 0x200D, 0x1F4BB), 0, 4), emptyList<String>(), 48, 7, false),
        TwitterEmoji(String(intArrayOf(0x1F9D1, 0x1F3FD, 0x200D, 0x1F4BB), 0, 4), emptyList<String>(), 48, 8, false),
        TwitterEmoji(String(intArrayOf(0x1F9D1, 0x1F3FE, 0x200D, 0x1F4BB), 0, 4), emptyList<String>(), 48, 9, false),
        TwitterEmoji(String(intArrayOf(0x1F9D1, 0x1F3FF, 0x200D, 0x1F4BB), 0, 4), emptyList<String>(), 48, 10, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F468, 0x200D, 0x1F4BB), 0, 3), listOf("male-technologist"), 14, 48, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F468, 0x1F3FB, 0x200D, 0x1F4BB), 0, 4), emptyList<String>(), 14, 49, false),
        TwitterEmoji(String(intArrayOf(0x1F468, 0x1F3FC, 0x200D, 0x1F4BB), 0, 4), emptyList<String>(), 14, 50, false),
        TwitterEmoji(String(intArrayOf(0x1F468, 0x1F3FD, 0x200D, 0x1F4BB), 0, 4), emptyList<String>(), 14, 51, false),
        TwitterEmoji(String(intArrayOf(0x1F468, 0x1F3FE, 0x200D, 0x1F4BB), 0, 4), emptyList<String>(), 14, 52, false),
        TwitterEmoji(String(intArrayOf(0x1F468, 0x1F3FF, 0x200D, 0x1F4BB), 0, 4), emptyList<String>(), 14, 53, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F469, 0x200D, 0x1F4BB), 0, 3), listOf("female-technologist"), 18, 16, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FB, 0x200D, 0x1F4BB), 0, 4), emptyList<String>(), 18, 17, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FC, 0x200D, 0x1F4BB), 0, 4), emptyList<String>(), 18, 18, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FD, 0x200D, 0x1F4BB), 0, 4), emptyList<String>(), 18, 19, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FE, 0x200D, 0x1F4BB), 0, 4), emptyList<String>(), 18, 20, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FF, 0x200D, 0x1F4BB), 0, 4), emptyList<String>(), 18, 21, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F9D1, 0x200D, 0x1F3A4), 0, 3), listOf("singer"), 47, 42, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F9D1, 0x1F3FB, 0x200D, 0x1F3A4), 0, 4), emptyList<String>(), 47, 43, false),
        TwitterEmoji(String(intArrayOf(0x1F9D1, 0x1F3FC, 0x200D, 0x1F3A4), 0, 4), emptyList<String>(), 47, 44, false),
        TwitterEmoji(String(intArrayOf(0x1F9D1, 0x1F3FD, 0x200D, 0x1F3A4), 0, 4), emptyList<String>(), 47, 45, false),
        TwitterEmoji(String(intArrayOf(0x1F9D1, 0x1F3FE, 0x200D, 0x1F3A4), 0, 4), emptyList<String>(), 47, 46, false),
        TwitterEmoji(String(intArrayOf(0x1F9D1, 0x1F3FF, 0x200D, 0x1F3A4), 0, 4), emptyList<String>(), 47, 47, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F468, 0x200D, 0x1F3A4), 0, 3), listOf("male-singer"), 14, 9, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F468, 0x1F3FB, 0x200D, 0x1F3A4), 0, 4), emptyList<String>(), 14, 10, false),
        TwitterEmoji(String(intArrayOf(0x1F468, 0x1F3FC, 0x200D, 0x1F3A4), 0, 4), emptyList<String>(), 14, 11, false),
        TwitterEmoji(String(intArrayOf(0x1F468, 0x1F3FD, 0x200D, 0x1F3A4), 0, 4), emptyList<String>(), 14, 12, false),
        TwitterEmoji(String(intArrayOf(0x1F468, 0x1F3FE, 0x200D, 0x1F3A4), 0, 4), emptyList<String>(), 14, 13, false),
        TwitterEmoji(String(intArrayOf(0x1F468, 0x1F3FF, 0x200D, 0x1F3A4), 0, 4), emptyList<String>(), 14, 14, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F469, 0x200D, 0x1F3A4), 0, 3), listOf("female-singer"), 17, 43, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FB, 0x200D, 0x1F3A4), 0, 4), emptyList<String>(), 17, 44, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FC, 0x200D, 0x1F3A4), 0, 4), emptyList<String>(), 17, 45, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FD, 0x200D, 0x1F3A4), 0, 4), emptyList<String>(), 17, 46, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FE, 0x200D, 0x1F3A4), 0, 4), emptyList<String>(), 17, 47, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FF, 0x200D, 0x1F3A4), 0, 4), emptyList<String>(), 17, 48, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F9D1, 0x200D, 0x1F3A8), 0, 3), listOf("artist"), 47, 48, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F9D1, 0x1F3FB, 0x200D, 0x1F3A8), 0, 4), emptyList<String>(), 47, 49, false),
        TwitterEmoji(String(intArrayOf(0x1F9D1, 0x1F3FC, 0x200D, 0x1F3A8), 0, 4), emptyList<String>(), 47, 50, false),
        TwitterEmoji(String(intArrayOf(0x1F9D1, 0x1F3FD, 0x200D, 0x1F3A8), 0, 4), emptyList<String>(), 47, 51, false),
        TwitterEmoji(String(intArrayOf(0x1F9D1, 0x1F3FE, 0x200D, 0x1F3A8), 0, 4), emptyList<String>(), 47, 52, false),
        TwitterEmoji(String(intArrayOf(0x1F9D1, 0x1F3FF, 0x200D, 0x1F3A8), 0, 4), emptyList<String>(), 47, 53, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F468, 0x200D, 0x1F3A8), 0, 3), listOf("male-artist"), 14, 15, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F468, 0x1F3FB, 0x200D, 0x1F3A8), 0, 4), emptyList<String>(), 14, 16, false),
        TwitterEmoji(String(intArrayOf(0x1F468, 0x1F3FC, 0x200D, 0x1F3A8), 0, 4), emptyList<String>(), 14, 17, false),
        TwitterEmoji(String(intArrayOf(0x1F468, 0x1F3FD, 0x200D, 0x1F3A8), 0, 4), emptyList<String>(), 14, 18, false),
        TwitterEmoji(String(intArrayOf(0x1F468, 0x1F3FE, 0x200D, 0x1F3A8), 0, 4), emptyList<String>(), 14, 19, false),
        TwitterEmoji(String(intArrayOf(0x1F468, 0x1F3FF, 0x200D, 0x1F3A8), 0, 4), emptyList<String>(), 14, 20, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F469, 0x200D, 0x1F3A8), 0, 3), listOf("female-artist"), 17, 49, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FB, 0x200D, 0x1F3A8), 0, 4), emptyList<String>(), 17, 50, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FC, 0x200D, 0x1F3A8), 0, 4), emptyList<String>(), 17, 51, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FD, 0x200D, 0x1F3A8), 0, 4), emptyList<String>(), 17, 52, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FE, 0x200D, 0x1F3A8), 0, 4), emptyList<String>(), 17, 53, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FF, 0x200D, 0x1F3A8), 0, 4), emptyList<String>(), 17, 54, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F9D1, 0x200D, 0x2708, 0xFE0F), 0, 4), listOf("pilot"), 49, 60, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F9D1, 0x1F3FB, 0x200D, 0x2708, 0xFE0F), 0, 5), emptyList<String>(), 50, 0, false),
        TwitterEmoji(String(intArrayOf(0x1F9D1, 0x1F3FC, 0x200D, 0x2708, 0xFE0F), 0, 5), emptyList<String>(), 50, 1, false),
        TwitterEmoji(String(intArrayOf(0x1F9D1, 0x1F3FD, 0x200D, 0x2708, 0xFE0F), 0, 5), emptyList<String>(), 50, 2, false),
        TwitterEmoji(String(intArrayOf(0x1F9D1, 0x1F3FE, 0x200D, 0x2708, 0xFE0F), 0, 5), emptyList<String>(), 50, 3, false),
        TwitterEmoji(String(intArrayOf(0x1F9D1, 0x1F3FF, 0x200D, 0x2708, 0xFE0F), 0, 5), emptyList<String>(), 50, 4, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F468, 0x200D, 0x2708, 0xFE0F), 0, 4), listOf("male-pilot"), 16, 16, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F468, 0x1F3FB, 0x200D, 0x2708, 0xFE0F), 0, 5), emptyList<String>(), 16, 17, false),
        TwitterEmoji(String(intArrayOf(0x1F468, 0x1F3FC, 0x200D, 0x2708, 0xFE0F), 0, 5), emptyList<String>(), 16, 18, false),
        TwitterEmoji(String(intArrayOf(0x1F468, 0x1F3FD, 0x200D, 0x2708, 0xFE0F), 0, 5), emptyList<String>(), 16, 19, false),
        TwitterEmoji(String(intArrayOf(0x1F468, 0x1F3FE, 0x200D, 0x2708, 0xFE0F), 0, 5), emptyList<String>(), 16, 20, false),
        TwitterEmoji(String(intArrayOf(0x1F468, 0x1F3FF, 0x200D, 0x2708, 0xFE0F), 0, 5), emptyList<String>(), 16, 21, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F469, 0x200D, 0x2708, 0xFE0F), 0, 4), listOf("female-pilot"), 19, 45, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FB, 0x200D, 0x2708, 0xFE0F), 0, 5), emptyList<String>(), 19, 46, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FC, 0x200D, 0x2708, 0xFE0F), 0, 5), emptyList<String>(), 19, 47, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FD, 0x200D, 0x2708, 0xFE0F), 0, 5), emptyList<String>(), 19, 48, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FE, 0x200D, 0x2708, 0xFE0F), 0, 5), emptyList<String>(), 19, 49, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FF, 0x200D, 0x2708, 0xFE0F), 0, 5), emptyList<String>(), 19, 50, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F9D1, 0x200D, 0x1F680), 0, 3), listOf("astronaut"), 48, 29, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F9D1, 0x1F3FB, 0x200D, 0x1F680), 0, 4), emptyList<String>(), 48, 30, false),
        TwitterEmoji(String(intArrayOf(0x1F9D1, 0x1F3FC, 0x200D, 0x1F680), 0, 4), emptyList<String>(), 48, 31, false),
        TwitterEmoji(String(intArrayOf(0x1F9D1, 0x1F3FD, 0x200D, 0x1F680), 0, 4), emptyList<String>(), 48, 32, false),
        TwitterEmoji(String(intArrayOf(0x1F9D1, 0x1F3FE, 0x200D, 0x1F680), 0, 4), emptyList<String>(), 48, 33, false),
        TwitterEmoji(String(intArrayOf(0x1F9D1, 0x1F3FF, 0x200D, 0x1F680), 0, 4), emptyList<String>(), 48, 34, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F468, 0x200D, 0x1F680), 0, 3), listOf("male-astronaut"), 15, 11, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F468, 0x1F3FB, 0x200D, 0x1F680), 0, 4), emptyList<String>(), 15, 12, false),
        TwitterEmoji(String(intArrayOf(0x1F468, 0x1F3FC, 0x200D, 0x1F680), 0, 4), emptyList<String>(), 15, 13, false),
        TwitterEmoji(String(intArrayOf(0x1F468, 0x1F3FD, 0x200D, 0x1F680), 0, 4), emptyList<String>(), 15, 14, false),
        TwitterEmoji(String(intArrayOf(0x1F468, 0x1F3FE, 0x200D, 0x1F680), 0, 4), emptyList<String>(), 15, 15, false),
        TwitterEmoji(String(intArrayOf(0x1F468, 0x1F3FF, 0x200D, 0x1F680), 0, 4), emptyList<String>(), 15, 16, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F469, 0x200D, 0x1F680), 0, 3), listOf("female-astronaut"), 18, 40, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FB, 0x200D, 0x1F680), 0, 4), emptyList<String>(), 18, 41, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FC, 0x200D, 0x1F680), 0, 4), emptyList<String>(), 18, 42, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FD, 0x200D, 0x1F680), 0, 4), emptyList<String>(), 18, 43, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FE, 0x200D, 0x1F680), 0, 4), emptyList<String>(), 18, 44, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FF, 0x200D, 0x1F680), 0, 4), emptyList<String>(), 18, 45, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F9D1, 0x200D, 0x1F692), 0, 3), listOf("firefighter"), 48, 35, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F9D1, 0x1F3FB, 0x200D, 0x1F692), 0, 4), emptyList<String>(), 48, 36, false),
        TwitterEmoji(String(intArrayOf(0x1F9D1, 0x1F3FC, 0x200D, 0x1F692), 0, 4), emptyList<String>(), 48, 37, false),
        TwitterEmoji(String(intArrayOf(0x1F9D1, 0x1F3FD, 0x200D, 0x1F692), 0, 4), emptyList<String>(), 48, 38, false),
        TwitterEmoji(String(intArrayOf(0x1F9D1, 0x1F3FE, 0x200D, 0x1F692), 0, 4), emptyList<String>(), 48, 39, false),
        TwitterEmoji(String(intArrayOf(0x1F9D1, 0x1F3FF, 0x200D, 0x1F692), 0, 4), emptyList<String>(), 48, 40, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F468, 0x200D, 0x1F692), 0, 3), listOf("male-firefighter"), 15, 17, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F468, 0x1F3FB, 0x200D, 0x1F692), 0, 4), emptyList<String>(), 15, 18, false),
        TwitterEmoji(String(intArrayOf(0x1F468, 0x1F3FC, 0x200D, 0x1F692), 0, 4), emptyList<String>(), 15, 19, false),
        TwitterEmoji(String(intArrayOf(0x1F468, 0x1F3FD, 0x200D, 0x1F692), 0, 4), emptyList<String>(), 15, 20, false),
        TwitterEmoji(String(intArrayOf(0x1F468, 0x1F3FE, 0x200D, 0x1F692), 0, 4), emptyList<String>(), 15, 21, false),
        TwitterEmoji(String(intArrayOf(0x1F468, 0x1F3FF, 0x200D, 0x1F692), 0, 4), emptyList<String>(), 15, 22, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F469, 0x200D, 0x1F692), 0, 3), listOf("female-firefighter"), 18, 46, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FB, 0x200D, 0x1F692), 0, 4), emptyList<String>(), 18, 47, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FC, 0x200D, 0x1F692), 0, 4), emptyList<String>(), 18, 48, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FD, 0x200D, 0x1F692), 0, 4), emptyList<String>(), 18, 49, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FE, 0x200D, 0x1F692), 0, 4), emptyList<String>(), 18, 50, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FF, 0x200D, 0x1F692), 0, 4), emptyList<String>(), 18, 51, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F46E), 0, 1), listOf("cop"), 23, 8, true,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F46E, 0x1F3FB), 0, 2), emptyList<String>(), 23, 9, false),
        TwitterEmoji(String(intArrayOf(0x1F46E, 0x1F3FC), 0, 2), emptyList<String>(), 23, 10, false),
        TwitterEmoji(String(intArrayOf(0x1F46E, 0x1F3FD), 0, 2), emptyList<String>(), 23, 11, false),
        TwitterEmoji(String(intArrayOf(0x1F46E, 0x1F3FE), 0, 2), emptyList<String>(), 23, 12, false),
        TwitterEmoji(String(intArrayOf(0x1F46E, 0x1F3FF), 0, 2), emptyList<String>(), 23, 13, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F46E, 0x200D, 0x2642, 0xFE0F), 0, 4), listOf("male-police-officer"), 23, 2, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F46E, 0x1F3FB, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 23, 3, false),
        TwitterEmoji(String(intArrayOf(0x1F46E, 0x1F3FC, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 23, 4, false),
        TwitterEmoji(String(intArrayOf(0x1F46E, 0x1F3FD, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 23, 5, false),
        TwitterEmoji(String(intArrayOf(0x1F46E, 0x1F3FE, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 23, 6, false),
        TwitterEmoji(String(intArrayOf(0x1F46E, 0x1F3FF, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 23, 7, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F46E, 0x200D, 0x2640, 0xFE0F), 0, 4), listOf("female-police-officer"), 22, 57, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F46E, 0x1F3FB, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 22, 58, false),
        TwitterEmoji(String(intArrayOf(0x1F46E, 0x1F3FC, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 22, 59, false),
        TwitterEmoji(String(intArrayOf(0x1F46E, 0x1F3FD, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 22, 60, false),
        TwitterEmoji(String(intArrayOf(0x1F46E, 0x1F3FE, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 23, 0, false),
        TwitterEmoji(String(intArrayOf(0x1F46E, 0x1F3FF, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 23, 1, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F575, 0xFE0F), 0, 2), listOf("sleuth_or_spy"), 31, 16, true,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F575, 0x1F3FB), 0, 2), emptyList<String>(), 31, 17, false),
        TwitterEmoji(String(intArrayOf(0x1F575, 0x1F3FC), 0, 2), emptyList<String>(), 31, 18, false),
        TwitterEmoji(String(intArrayOf(0x1F575, 0x1F3FD), 0, 2), emptyList<String>(), 31, 19, false),
        TwitterEmoji(String(intArrayOf(0x1F575, 0x1F3FE), 0, 2), emptyList<String>(), 31, 20, false),
        TwitterEmoji(String(intArrayOf(0x1F575, 0x1F3FF), 0, 2), emptyList<String>(), 31, 21, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F575, 0xFE0F, 0x200D, 0x2642, 0xFE0F), 0, 5), listOf("male-detective"), 31, 10, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F575, 0x1F3FB, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 31, 11, false),
        TwitterEmoji(String(intArrayOf(0x1F575, 0x1F3FC, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 31, 12, false),
        TwitterEmoji(String(intArrayOf(0x1F575, 0x1F3FD, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 31, 13, false),
        TwitterEmoji(String(intArrayOf(0x1F575, 0x1F3FE, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 31, 14, false),
        TwitterEmoji(String(intArrayOf(0x1F575, 0x1F3FF, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 31, 15, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F575, 0xFE0F, 0x200D, 0x2640, 0xFE0F), 0, 5), listOf("female-detective"), 31, 4, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F575, 0x1F3FB, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 31, 5, false),
        TwitterEmoji(String(intArrayOf(0x1F575, 0x1F3FC, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 31, 6, false),
        TwitterEmoji(String(intArrayOf(0x1F575, 0x1F3FD, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 31, 7, false),
        TwitterEmoji(String(intArrayOf(0x1F575, 0x1F3FE, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 31, 8, false),
        TwitterEmoji(String(intArrayOf(0x1F575, 0x1F3FF, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 31, 9, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F482), 0, 1), listOf("guardsman"), 25, 40, true,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F482, 0x1F3FB), 0, 2), emptyList<String>(), 25, 41, false),
        TwitterEmoji(String(intArrayOf(0x1F482, 0x1F3FC), 0, 2), emptyList<String>(), 25, 42, false),
        TwitterEmoji(String(intArrayOf(0x1F482, 0x1F3FD), 0, 2), emptyList<String>(), 25, 43, false),
        TwitterEmoji(String(intArrayOf(0x1F482, 0x1F3FE), 0, 2), emptyList<String>(), 25, 44, false),
        TwitterEmoji(String(intArrayOf(0x1F482, 0x1F3FF), 0, 2), emptyList<String>(), 25, 45, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F482, 0x200D, 0x2642, 0xFE0F), 0, 4), listOf("male-guard"), 25, 34, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F482, 0x1F3FB, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 25, 35, false),
        TwitterEmoji(String(intArrayOf(0x1F482, 0x1F3FC, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 25, 36, false),
        TwitterEmoji(String(intArrayOf(0x1F482, 0x1F3FD, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 25, 37, false),
        TwitterEmoji(String(intArrayOf(0x1F482, 0x1F3FE, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 25, 38, false),
        TwitterEmoji(String(intArrayOf(0x1F482, 0x1F3FF, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 25, 39, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F482, 0x200D, 0x2640, 0xFE0F), 0, 4), listOf("female-guard"), 25, 28, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F482, 0x1F3FB, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 25, 29, false),
        TwitterEmoji(String(intArrayOf(0x1F482, 0x1F3FC, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 25, 30, false),
        TwitterEmoji(String(intArrayOf(0x1F482, 0x1F3FD, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 25, 31, false),
        TwitterEmoji(String(intArrayOf(0x1F482, 0x1F3FE, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 25, 32, false),
        TwitterEmoji(String(intArrayOf(0x1F482, 0x1F3FF, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 25, 33, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F977), 0, 1), listOf("ninja"), 44, 4, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F977, 0x1F3FB), 0, 2), emptyList<String>(), 44, 5, false),
        TwitterEmoji(String(intArrayOf(0x1F977, 0x1F3FC), 0, 2), emptyList<String>(), 44, 6, false),
        TwitterEmoji(String(intArrayOf(0x1F977, 0x1F3FD), 0, 2), emptyList<String>(), 44, 7, false),
        TwitterEmoji(String(intArrayOf(0x1F977, 0x1F3FE), 0, 2), emptyList<String>(), 44, 8, false),
        TwitterEmoji(String(intArrayOf(0x1F977, 0x1F3FF), 0, 2), emptyList<String>(), 44, 9, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F477), 0, 1), listOf("construction_worker"), 24, 46, true,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F477, 0x1F3FB), 0, 2), emptyList<String>(), 24, 47, false),
        TwitterEmoji(String(intArrayOf(0x1F477, 0x1F3FC), 0, 2), emptyList<String>(), 24, 48, false),
        TwitterEmoji(String(intArrayOf(0x1F477, 0x1F3FD), 0, 2), emptyList<String>(), 24, 49, false),
        TwitterEmoji(String(intArrayOf(0x1F477, 0x1F3FE), 0, 2), emptyList<String>(), 24, 50, false),
        TwitterEmoji(String(intArrayOf(0x1F477, 0x1F3FF), 0, 2), emptyList<String>(), 24, 51, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F477, 0x200D, 0x2642, 0xFE0F), 0, 4), listOf("male-construction-worker"), 24, 40, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F477, 0x1F3FB, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 24, 41, false),
        TwitterEmoji(String(intArrayOf(0x1F477, 0x1F3FC, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 24, 42, false),
        TwitterEmoji(String(intArrayOf(0x1F477, 0x1F3FD, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 24, 43, false),
        TwitterEmoji(String(intArrayOf(0x1F477, 0x1F3FE, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 24, 44, false),
        TwitterEmoji(String(intArrayOf(0x1F477, 0x1F3FF, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 24, 45, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F477, 0x200D, 0x2640, 0xFE0F), 0, 4), listOf("female-construction-worker"), 24, 34, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F477, 0x1F3FB, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 24, 35, false),
        TwitterEmoji(String(intArrayOf(0x1F477, 0x1F3FC, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 24, 36, false),
        TwitterEmoji(String(intArrayOf(0x1F477, 0x1F3FD, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 24, 37, false),
        TwitterEmoji(String(intArrayOf(0x1F477, 0x1F3FE, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 24, 38, false),
        TwitterEmoji(String(intArrayOf(0x1F477, 0x1F3FF, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 24, 39, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1FAC5), 0, 1), listOf("person_with_crown"), 54, 57, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1FAC5, 0x1F3FB), 0, 2), emptyList<String>(), 54, 58, false),
        TwitterEmoji(String(intArrayOf(0x1FAC5, 0x1F3FC), 0, 2), emptyList<String>(), 54, 59, false),
        TwitterEmoji(String(intArrayOf(0x1FAC5, 0x1F3FD), 0, 2), emptyList<String>(), 54, 60, false),
        TwitterEmoji(String(intArrayOf(0x1FAC5, 0x1F3FE), 0, 2), emptyList<String>(), 55, 0, false),
        TwitterEmoji(String(intArrayOf(0x1FAC5, 0x1F3FF), 0, 2), emptyList<String>(), 55, 1, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F934), 0, 1), listOf("prince"), 41, 8, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F934, 0x1F3FB), 0, 2), emptyList<String>(), 41, 9, false),
        TwitterEmoji(String(intArrayOf(0x1F934, 0x1F3FC), 0, 2), emptyList<String>(), 41, 10, false),
        TwitterEmoji(String(intArrayOf(0x1F934, 0x1F3FD), 0, 2), emptyList<String>(), 41, 11, false),
        TwitterEmoji(String(intArrayOf(0x1F934, 0x1F3FE), 0, 2), emptyList<String>(), 41, 12, false),
        TwitterEmoji(String(intArrayOf(0x1F934, 0x1F3FF), 0, 2), emptyList<String>(), 41, 13, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F478), 0, 1), listOf("princess"), 24, 52, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F478, 0x1F3FB), 0, 2), emptyList<String>(), 24, 53, false),
        TwitterEmoji(String(intArrayOf(0x1F478, 0x1F3FC), 0, 2), emptyList<String>(), 24, 54, false),
        TwitterEmoji(String(intArrayOf(0x1F478, 0x1F3FD), 0, 2), emptyList<String>(), 24, 55, false),
        TwitterEmoji(String(intArrayOf(0x1F478, 0x1F3FE), 0, 2), emptyList<String>(), 24, 56, false),
        TwitterEmoji(String(intArrayOf(0x1F478, 0x1F3FF), 0, 2), emptyList<String>(), 24, 57, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F473), 0, 1), listOf("man_with_turban"), 24, 10, true,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F473, 0x1F3FB), 0, 2), emptyList<String>(), 24, 11, false),
        TwitterEmoji(String(intArrayOf(0x1F473, 0x1F3FC), 0, 2), emptyList<String>(), 24, 12, false),
        TwitterEmoji(String(intArrayOf(0x1F473, 0x1F3FD), 0, 2), emptyList<String>(), 24, 13, false),
        TwitterEmoji(String(intArrayOf(0x1F473, 0x1F3FE), 0, 2), emptyList<String>(), 24, 14, false),
        TwitterEmoji(String(intArrayOf(0x1F473, 0x1F3FF), 0, 2), emptyList<String>(), 24, 15, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F473, 0x200D, 0x2642, 0xFE0F), 0, 4), listOf("man-wearing-turban"), 24, 4, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F473, 0x1F3FB, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 24, 5, false),
        TwitterEmoji(String(intArrayOf(0x1F473, 0x1F3FC, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 24, 6, false),
        TwitterEmoji(String(intArrayOf(0x1F473, 0x1F3FD, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 24, 7, false),
        TwitterEmoji(String(intArrayOf(0x1F473, 0x1F3FE, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 24, 8, false),
        TwitterEmoji(String(intArrayOf(0x1F473, 0x1F3FF, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 24, 9, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F473, 0x200D, 0x2640, 0xFE0F), 0, 4), listOf("woman-wearing-turban"), 23, 59, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F473, 0x1F3FB, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 23, 60, false),
        TwitterEmoji(String(intArrayOf(0x1F473, 0x1F3FC, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 24, 0, false),
        TwitterEmoji(String(intArrayOf(0x1F473, 0x1F3FD, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 24, 1, false),
        TwitterEmoji(String(intArrayOf(0x1F473, 0x1F3FE, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 24, 2, false),
        TwitterEmoji(String(intArrayOf(0x1F473, 0x1F3FF, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 24, 3, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F472), 0, 1), listOf("man_with_gua_pi_mao"), 23, 53, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F472, 0x1F3FB), 0, 2), emptyList<String>(), 23, 54, false),
        TwitterEmoji(String(intArrayOf(0x1F472, 0x1F3FC), 0, 2), emptyList<String>(), 23, 55, false),
        TwitterEmoji(String(intArrayOf(0x1F472, 0x1F3FD), 0, 2), emptyList<String>(), 23, 56, false),
        TwitterEmoji(String(intArrayOf(0x1F472, 0x1F3FE), 0, 2), emptyList<String>(), 23, 57, false),
        TwitterEmoji(String(intArrayOf(0x1F472, 0x1F3FF), 0, 2), emptyList<String>(), 23, 58, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F9D5), 0, 1), listOf("person_with_headscarf"), 50, 41, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F9D5, 0x1F3FB), 0, 2), emptyList<String>(), 50, 42, false),
        TwitterEmoji(String(intArrayOf(0x1F9D5, 0x1F3FC), 0, 2), emptyList<String>(), 50, 43, false),
        TwitterEmoji(String(intArrayOf(0x1F9D5, 0x1F3FD), 0, 2), emptyList<String>(), 50, 44, false),
        TwitterEmoji(String(intArrayOf(0x1F9D5, 0x1F3FE), 0, 2), emptyList<String>(), 50, 45, false),
        TwitterEmoji(String(intArrayOf(0x1F9D5, 0x1F3FF), 0, 2), emptyList<String>(), 50, 46, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F935), 0, 1), listOf("person_in_tuxedo"), 41, 26, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F935, 0x1F3FB), 0, 2), emptyList<String>(), 41, 27, false),
        TwitterEmoji(String(intArrayOf(0x1F935, 0x1F3FC), 0, 2), emptyList<String>(), 41, 28, false),
        TwitterEmoji(String(intArrayOf(0x1F935, 0x1F3FD), 0, 2), emptyList<String>(), 41, 29, false),
        TwitterEmoji(String(intArrayOf(0x1F935, 0x1F3FE), 0, 2), emptyList<String>(), 41, 30, false),
        TwitterEmoji(String(intArrayOf(0x1F935, 0x1F3FF), 0, 2), emptyList<String>(), 41, 31, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F935, 0x200D, 0x2642, 0xFE0F), 0, 4), listOf("man_in_tuxedo"), 41, 20, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F935, 0x1F3FB, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 41, 21, false),
        TwitterEmoji(String(intArrayOf(0x1F935, 0x1F3FC, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 41, 22, false),
        TwitterEmoji(String(intArrayOf(0x1F935, 0x1F3FD, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 41, 23, false),
        TwitterEmoji(String(intArrayOf(0x1F935, 0x1F3FE, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 41, 24, false),
        TwitterEmoji(String(intArrayOf(0x1F935, 0x1F3FF, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 41, 25, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F935, 0x200D, 0x2640, 0xFE0F), 0, 4), listOf("woman_in_tuxedo"), 41, 14, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F935, 0x1F3FB, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 41, 15, false),
        TwitterEmoji(String(intArrayOf(0x1F935, 0x1F3FC, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 41, 16, false),
        TwitterEmoji(String(intArrayOf(0x1F935, 0x1F3FD, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 41, 17, false),
        TwitterEmoji(String(intArrayOf(0x1F935, 0x1F3FE, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 41, 18, false),
        TwitterEmoji(String(intArrayOf(0x1F935, 0x1F3FF, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 41, 19, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F470), 0, 1), listOf("bride_with_veil"), 23, 29, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F470, 0x1F3FB), 0, 2), emptyList<String>(), 23, 30, false),
        TwitterEmoji(String(intArrayOf(0x1F470, 0x1F3FC), 0, 2), emptyList<String>(), 23, 31, false),
        TwitterEmoji(String(intArrayOf(0x1F470, 0x1F3FD), 0, 2), emptyList<String>(), 23, 32, false),
        TwitterEmoji(String(intArrayOf(0x1F470, 0x1F3FE), 0, 2), emptyList<String>(), 23, 33, false),
        TwitterEmoji(String(intArrayOf(0x1F470, 0x1F3FF), 0, 2), emptyList<String>(), 23, 34, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F470, 0x200D, 0x2642, 0xFE0F), 0, 4), listOf("man_with_veil"), 23, 23, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F470, 0x1F3FB, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 23, 24, false),
        TwitterEmoji(String(intArrayOf(0x1F470, 0x1F3FC, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 23, 25, false),
        TwitterEmoji(String(intArrayOf(0x1F470, 0x1F3FD, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 23, 26, false),
        TwitterEmoji(String(intArrayOf(0x1F470, 0x1F3FE, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 23, 27, false),
        TwitterEmoji(String(intArrayOf(0x1F470, 0x1F3FF, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 23, 28, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F470, 0x200D, 0x2640, 0xFE0F), 0, 4), listOf("woman_with_veil"), 23, 17, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F470, 0x1F3FB, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 23, 18, false),
        TwitterEmoji(String(intArrayOf(0x1F470, 0x1F3FC, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 23, 19, false),
        TwitterEmoji(String(intArrayOf(0x1F470, 0x1F3FD, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 23, 20, false),
        TwitterEmoji(String(intArrayOf(0x1F470, 0x1F3FE, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 23, 21, false),
        TwitterEmoji(String(intArrayOf(0x1F470, 0x1F3FF, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 23, 22, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F930), 0, 1), listOf("pregnant_woman"), 40, 45, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F930, 0x1F3FB), 0, 2), emptyList<String>(), 40, 46, false),
        TwitterEmoji(String(intArrayOf(0x1F930, 0x1F3FC), 0, 2), emptyList<String>(), 40, 47, false),
        TwitterEmoji(String(intArrayOf(0x1F930, 0x1F3FD), 0, 2), emptyList<String>(), 40, 48, false),
        TwitterEmoji(String(intArrayOf(0x1F930, 0x1F3FE), 0, 2), emptyList<String>(), 40, 49, false),
        TwitterEmoji(String(intArrayOf(0x1F930, 0x1F3FF), 0, 2), emptyList<String>(), 40, 50, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1FAC3), 0, 1), listOf("pregnant_man"), 54, 45, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1FAC3, 0x1F3FB), 0, 2), emptyList<String>(), 54, 46, false),
        TwitterEmoji(String(intArrayOf(0x1FAC3, 0x1F3FC), 0, 2), emptyList<String>(), 54, 47, false),
        TwitterEmoji(String(intArrayOf(0x1FAC3, 0x1F3FD), 0, 2), emptyList<String>(), 54, 48, false),
        TwitterEmoji(String(intArrayOf(0x1FAC3, 0x1F3FE), 0, 2), emptyList<String>(), 54, 49, false),
        TwitterEmoji(String(intArrayOf(0x1FAC3, 0x1F3FF), 0, 2), emptyList<String>(), 54, 50, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1FAC4), 0, 1), listOf("pregnant_person"), 54, 51, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1FAC4, 0x1F3FB), 0, 2), emptyList<String>(), 54, 52, false),
        TwitterEmoji(String(intArrayOf(0x1FAC4, 0x1F3FC), 0, 2), emptyList<String>(), 54, 53, false),
        TwitterEmoji(String(intArrayOf(0x1FAC4, 0x1F3FD), 0, 2), emptyList<String>(), 54, 54, false),
        TwitterEmoji(String(intArrayOf(0x1FAC4, 0x1F3FE), 0, 2), emptyList<String>(), 54, 55, false),
        TwitterEmoji(String(intArrayOf(0x1FAC4, 0x1F3FF), 0, 2), emptyList<String>(), 54, 56, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F931), 0, 1), listOf("breast-feeding"), 40, 51, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F931, 0x1F3FB), 0, 2), emptyList<String>(), 40, 52, false),
        TwitterEmoji(String(intArrayOf(0x1F931, 0x1F3FC), 0, 2), emptyList<String>(), 40, 53, false),
        TwitterEmoji(String(intArrayOf(0x1F931, 0x1F3FD), 0, 2), emptyList<String>(), 40, 54, false),
        TwitterEmoji(String(intArrayOf(0x1F931, 0x1F3FE), 0, 2), emptyList<String>(), 40, 55, false),
        TwitterEmoji(String(intArrayOf(0x1F931, 0x1F3FF), 0, 2), emptyList<String>(), 40, 56, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F469, 0x200D, 0x1F37C), 0, 3), listOf("woman_feeding_baby"), 17, 31, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FB, 0x200D, 0x1F37C), 0, 4), emptyList<String>(), 17, 32, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FC, 0x200D, 0x1F37C), 0, 4), emptyList<String>(), 17, 33, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FD, 0x200D, 0x1F37C), 0, 4), emptyList<String>(), 17, 34, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FE, 0x200D, 0x1F37C), 0, 4), emptyList<String>(), 17, 35, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FF, 0x200D, 0x1F37C), 0, 4), emptyList<String>(), 17, 36, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F468, 0x200D, 0x1F37C), 0, 3), listOf("man_feeding_baby"), 13, 58, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F468, 0x1F3FB, 0x200D, 0x1F37C), 0, 4), emptyList<String>(), 13, 59, false),
        TwitterEmoji(String(intArrayOf(0x1F468, 0x1F3FC, 0x200D, 0x1F37C), 0, 4), emptyList<String>(), 13, 60, false),
        TwitterEmoji(String(intArrayOf(0x1F468, 0x1F3FD, 0x200D, 0x1F37C), 0, 4), emptyList<String>(), 14, 0, false),
        TwitterEmoji(String(intArrayOf(0x1F468, 0x1F3FE, 0x200D, 0x1F37C), 0, 4), emptyList<String>(), 14, 1, false),
        TwitterEmoji(String(intArrayOf(0x1F468, 0x1F3FF, 0x200D, 0x1F37C), 0, 4), emptyList<String>(), 14, 2, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F9D1, 0x200D, 0x1F37C), 0, 3), listOf("person_feeding_baby"), 47, 24, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F9D1, 0x1F3FB, 0x200D, 0x1F37C), 0, 4), emptyList<String>(), 47, 25, false),
        TwitterEmoji(String(intArrayOf(0x1F9D1, 0x1F3FC, 0x200D, 0x1F37C), 0, 4), emptyList<String>(), 47, 26, false),
        TwitterEmoji(String(intArrayOf(0x1F9D1, 0x1F3FD, 0x200D, 0x1F37C), 0, 4), emptyList<String>(), 47, 27, false),
        TwitterEmoji(String(intArrayOf(0x1F9D1, 0x1F3FE, 0x200D, 0x1F37C), 0, 4), emptyList<String>(), 47, 28, false),
        TwitterEmoji(String(intArrayOf(0x1F9D1, 0x1F3FF, 0x200D, 0x1F37C), 0, 4), emptyList<String>(), 47, 29, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F47C), 0, 1), listOf("angel"), 25, 0, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F47C, 0x1F3FB), 0, 2), emptyList<String>(), 25, 1, false),
        TwitterEmoji(String(intArrayOf(0x1F47C, 0x1F3FC), 0, 2), emptyList<String>(), 25, 2, false),
        TwitterEmoji(String(intArrayOf(0x1F47C, 0x1F3FD), 0, 2), emptyList<String>(), 25, 3, false),
        TwitterEmoji(String(intArrayOf(0x1F47C, 0x1F3FE), 0, 2), emptyList<String>(), 25, 4, false),
        TwitterEmoji(String(intArrayOf(0x1F47C, 0x1F3FF), 0, 2), emptyList<String>(), 25, 5, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F385), 0, 1), listOf("santa"), 7, 8, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F385, 0x1F3FB), 0, 2), emptyList<String>(), 7, 9, false),
        TwitterEmoji(String(intArrayOf(0x1F385, 0x1F3FC), 0, 2), emptyList<String>(), 7, 10, false),
        TwitterEmoji(String(intArrayOf(0x1F385, 0x1F3FD), 0, 2), emptyList<String>(), 7, 11, false),
        TwitterEmoji(String(intArrayOf(0x1F385, 0x1F3FE), 0, 2), emptyList<String>(), 7, 12, false),
        TwitterEmoji(String(intArrayOf(0x1F385, 0x1F3FF), 0, 2), emptyList<String>(), 7, 13, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F936), 0, 1), listOf("mrs_claus", "mother_christmas"), 41, 32, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F936, 0x1F3FB), 0, 2), emptyList<String>(), 41, 33, false),
        TwitterEmoji(String(intArrayOf(0x1F936, 0x1F3FC), 0, 2), emptyList<String>(), 41, 34, false),
        TwitterEmoji(String(intArrayOf(0x1F936, 0x1F3FD), 0, 2), emptyList<String>(), 41, 35, false),
        TwitterEmoji(String(intArrayOf(0x1F936, 0x1F3FE), 0, 2), emptyList<String>(), 41, 36, false),
        TwitterEmoji(String(intArrayOf(0x1F936, 0x1F3FF), 0, 2), emptyList<String>(), 41, 37, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F9D1, 0x200D, 0x1F384), 0, 3), listOf("mx_claus"), 47, 30, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F9D1, 0x1F3FB, 0x200D, 0x1F384), 0, 4), emptyList<String>(), 47, 31, false),
        TwitterEmoji(String(intArrayOf(0x1F9D1, 0x1F3FC, 0x200D, 0x1F384), 0, 4), emptyList<String>(), 47, 32, false),
        TwitterEmoji(String(intArrayOf(0x1F9D1, 0x1F3FD, 0x200D, 0x1F384), 0, 4), emptyList<String>(), 47, 33, false),
        TwitterEmoji(String(intArrayOf(0x1F9D1, 0x1F3FE, 0x200D, 0x1F384), 0, 4), emptyList<String>(), 47, 34, false),
        TwitterEmoji(String(intArrayOf(0x1F9D1, 0x1F3FF, 0x200D, 0x1F384), 0, 4), emptyList<String>(), 47, 35, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F9B8), 0, 1), listOf("superhero"), 45, 31, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F9B8, 0x1F3FB), 0, 2), emptyList<String>(), 45, 32, false),
        TwitterEmoji(String(intArrayOf(0x1F9B8, 0x1F3FC), 0, 2), emptyList<String>(), 45, 33, false),
        TwitterEmoji(String(intArrayOf(0x1F9B8, 0x1F3FD), 0, 2), emptyList<String>(), 45, 34, false),
        TwitterEmoji(String(intArrayOf(0x1F9B8, 0x1F3FE), 0, 2), emptyList<String>(), 45, 35, false),
        TwitterEmoji(String(intArrayOf(0x1F9B8, 0x1F3FF), 0, 2), emptyList<String>(), 45, 36, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F9B8, 0x200D, 0x2642, 0xFE0F), 0, 4), listOf("male_superhero"), 45, 25, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F9B8, 0x1F3FB, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 45, 26, false),
        TwitterEmoji(String(intArrayOf(0x1F9B8, 0x1F3FC, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 45, 27, false),
        TwitterEmoji(String(intArrayOf(0x1F9B8, 0x1F3FD, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 45, 28, false),
        TwitterEmoji(String(intArrayOf(0x1F9B8, 0x1F3FE, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 45, 29, false),
        TwitterEmoji(String(intArrayOf(0x1F9B8, 0x1F3FF, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 45, 30, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F9B8, 0x200D, 0x2640, 0xFE0F), 0, 4), listOf("female_superhero"), 45, 19, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F9B8, 0x1F3FB, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 45, 20, false),
        TwitterEmoji(String(intArrayOf(0x1F9B8, 0x1F3FC, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 45, 21, false),
        TwitterEmoji(String(intArrayOf(0x1F9B8, 0x1F3FD, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 45, 22, false),
        TwitterEmoji(String(intArrayOf(0x1F9B8, 0x1F3FE, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 45, 23, false),
        TwitterEmoji(String(intArrayOf(0x1F9B8, 0x1F3FF, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 45, 24, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F9B9), 0, 1), listOf("supervillain"), 45, 49, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F9B9, 0x1F3FB), 0, 2), emptyList<String>(), 45, 50, false),
        TwitterEmoji(String(intArrayOf(0x1F9B9, 0x1F3FC), 0, 2), emptyList<String>(), 45, 51, false),
        TwitterEmoji(String(intArrayOf(0x1F9B9, 0x1F3FD), 0, 2), emptyList<String>(), 45, 52, false),
        TwitterEmoji(String(intArrayOf(0x1F9B9, 0x1F3FE), 0, 2), emptyList<String>(), 45, 53, false),
        TwitterEmoji(String(intArrayOf(0x1F9B9, 0x1F3FF), 0, 2), emptyList<String>(), 45, 54, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F9B9, 0x200D, 0x2642, 0xFE0F), 0, 4), listOf("male_supervillain"), 45, 43, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F9B9, 0x1F3FB, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 45, 44, false),
        TwitterEmoji(String(intArrayOf(0x1F9B9, 0x1F3FC, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 45, 45, false),
        TwitterEmoji(String(intArrayOf(0x1F9B9, 0x1F3FD, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 45, 46, false),
        TwitterEmoji(String(intArrayOf(0x1F9B9, 0x1F3FE, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 45, 47, false),
        TwitterEmoji(String(intArrayOf(0x1F9B9, 0x1F3FF, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 45, 48, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F9B9, 0x200D, 0x2640, 0xFE0F), 0, 4), listOf("female_supervillain"), 45, 37, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F9B9, 0x1F3FB, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 45, 38, false),
        TwitterEmoji(String(intArrayOf(0x1F9B9, 0x1F3FC, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 45, 39, false),
        TwitterEmoji(String(intArrayOf(0x1F9B9, 0x1F3FD, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 45, 40, false),
        TwitterEmoji(String(intArrayOf(0x1F9B9, 0x1F3FE, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 45, 41, false),
        TwitterEmoji(String(intArrayOf(0x1F9B9, 0x1F3FF, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 45, 42, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F9D9), 0, 1), listOf("mage"), 51, 52, true,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F9D9, 0x1F3FB), 0, 2), emptyList<String>(), 51, 53, true),
        TwitterEmoji(String(intArrayOf(0x1F9D9, 0x1F3FC), 0, 2), emptyList<String>(), 51, 54, true),
        TwitterEmoji(String(intArrayOf(0x1F9D9, 0x1F3FD), 0, 2), emptyList<String>(), 51, 55, true),
        TwitterEmoji(String(intArrayOf(0x1F9D9, 0x1F3FE), 0, 2), emptyList<String>(), 51, 56, true),
        TwitterEmoji(String(intArrayOf(0x1F9D9, 0x1F3FF), 0, 2), emptyList<String>(), 51, 57, true),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F9D9, 0x200D, 0x2642, 0xFE0F), 0, 4), listOf("male_mage"), 51, 46, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F9D9, 0x1F3FB, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 51, 47, false),
        TwitterEmoji(String(intArrayOf(0x1F9D9, 0x1F3FC, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 51, 48, false),
        TwitterEmoji(String(intArrayOf(0x1F9D9, 0x1F3FD, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 51, 49, false),
        TwitterEmoji(String(intArrayOf(0x1F9D9, 0x1F3FE, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 51, 50, false),
        TwitterEmoji(String(intArrayOf(0x1F9D9, 0x1F3FF, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 51, 51, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F9D9, 0x200D, 0x2640, 0xFE0F), 0, 4), listOf("female_mage"), 51, 40, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F9D9, 0x1F3FB, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 51, 41, false),
        TwitterEmoji(String(intArrayOf(0x1F9D9, 0x1F3FC, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 51, 42, false),
        TwitterEmoji(String(intArrayOf(0x1F9D9, 0x1F3FD, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 51, 43, false),
        TwitterEmoji(String(intArrayOf(0x1F9D9, 0x1F3FE, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 51, 44, false),
        TwitterEmoji(String(intArrayOf(0x1F9D9, 0x1F3FF, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 51, 45, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F9DA), 0, 1), listOf("fairy"), 52, 9, true,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F9DA, 0x1F3FB), 0, 2), emptyList<String>(), 52, 10, true),
        TwitterEmoji(String(intArrayOf(0x1F9DA, 0x1F3FC), 0, 2), emptyList<String>(), 52, 11, true),
        TwitterEmoji(String(intArrayOf(0x1F9DA, 0x1F3FD), 0, 2), emptyList<String>(), 52, 12, true),
        TwitterEmoji(String(intArrayOf(0x1F9DA, 0x1F3FE), 0, 2), emptyList<String>(), 52, 13, true),
        TwitterEmoji(String(intArrayOf(0x1F9DA, 0x1F3FF), 0, 2), emptyList<String>(), 52, 14, true),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F9DA, 0x200D, 0x2642, 0xFE0F), 0, 4), listOf("male_fairy"), 52, 3, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F9DA, 0x1F3FB, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 52, 4, false),
        TwitterEmoji(String(intArrayOf(0x1F9DA, 0x1F3FC, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 52, 5, false),
        TwitterEmoji(String(intArrayOf(0x1F9DA, 0x1F3FD, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 52, 6, false),
        TwitterEmoji(String(intArrayOf(0x1F9DA, 0x1F3FE, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 52, 7, false),
        TwitterEmoji(String(intArrayOf(0x1F9DA, 0x1F3FF, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 52, 8, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F9DA, 0x200D, 0x2640, 0xFE0F), 0, 4), listOf("female_fairy"), 51, 58, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F9DA, 0x1F3FB, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 51, 59, false),
        TwitterEmoji(String(intArrayOf(0x1F9DA, 0x1F3FC, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 51, 60, false),
        TwitterEmoji(String(intArrayOf(0x1F9DA, 0x1F3FD, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 52, 0, false),
        TwitterEmoji(String(intArrayOf(0x1F9DA, 0x1F3FE, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 52, 1, false),
        TwitterEmoji(String(intArrayOf(0x1F9DA, 0x1F3FF, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 52, 2, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F9DB), 0, 1), listOf("vampire"), 52, 27, true,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F9DB, 0x1F3FB), 0, 2), emptyList<String>(), 52, 28, true),
        TwitterEmoji(String(intArrayOf(0x1F9DB, 0x1F3FC), 0, 2), emptyList<String>(), 52, 29, true),
        TwitterEmoji(String(intArrayOf(0x1F9DB, 0x1F3FD), 0, 2), emptyList<String>(), 52, 30, true),
        TwitterEmoji(String(intArrayOf(0x1F9DB, 0x1F3FE), 0, 2), emptyList<String>(), 52, 31, true),
        TwitterEmoji(String(intArrayOf(0x1F9DB, 0x1F3FF), 0, 2), emptyList<String>(), 52, 32, true),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F9DB, 0x200D, 0x2642, 0xFE0F), 0, 4), listOf("male_vampire"), 52, 21, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F9DB, 0x1F3FB, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 52, 22, false),
        TwitterEmoji(String(intArrayOf(0x1F9DB, 0x1F3FC, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 52, 23, false),
        TwitterEmoji(String(intArrayOf(0x1F9DB, 0x1F3FD, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 52, 24, false),
        TwitterEmoji(String(intArrayOf(0x1F9DB, 0x1F3FE, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 52, 25, false),
        TwitterEmoji(String(intArrayOf(0x1F9DB, 0x1F3FF, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 52, 26, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F9DB, 0x200D, 0x2640, 0xFE0F), 0, 4), listOf("female_vampire"), 52, 15, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F9DB, 0x1F3FB, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 52, 16, false),
        TwitterEmoji(String(intArrayOf(0x1F9DB, 0x1F3FC, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 52, 17, false),
        TwitterEmoji(String(intArrayOf(0x1F9DB, 0x1F3FD, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 52, 18, false),
        TwitterEmoji(String(intArrayOf(0x1F9DB, 0x1F3FE, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 52, 19, false),
        TwitterEmoji(String(intArrayOf(0x1F9DB, 0x1F3FF, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 52, 20, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F9DC), 0, 1), listOf("merperson"), 52, 45, true,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F9DC, 0x1F3FB), 0, 2), emptyList<String>(), 52, 46, true),
        TwitterEmoji(String(intArrayOf(0x1F9DC, 0x1F3FC), 0, 2), emptyList<String>(), 52, 47, true),
        TwitterEmoji(String(intArrayOf(0x1F9DC, 0x1F3FD), 0, 2), emptyList<String>(), 52, 48, true),
        TwitterEmoji(String(intArrayOf(0x1F9DC, 0x1F3FE), 0, 2), emptyList<String>(), 52, 49, true),
        TwitterEmoji(String(intArrayOf(0x1F9DC, 0x1F3FF), 0, 2), emptyList<String>(), 52, 50, true),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F9DC, 0x200D, 0x2642, 0xFE0F), 0, 4), listOf("merman"), 52, 39, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F9DC, 0x1F3FB, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 52, 40, false),
        TwitterEmoji(String(intArrayOf(0x1F9DC, 0x1F3FC, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 52, 41, false),
        TwitterEmoji(String(intArrayOf(0x1F9DC, 0x1F3FD, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 52, 42, false),
        TwitterEmoji(String(intArrayOf(0x1F9DC, 0x1F3FE, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 52, 43, false),
        TwitterEmoji(String(intArrayOf(0x1F9DC, 0x1F3FF, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 52, 44, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F9DC, 0x200D, 0x2640, 0xFE0F), 0, 4), listOf("mermaid"), 52, 33, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F9DC, 0x1F3FB, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 52, 34, false),
        TwitterEmoji(String(intArrayOf(0x1F9DC, 0x1F3FC, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 52, 35, false),
        TwitterEmoji(String(intArrayOf(0x1F9DC, 0x1F3FD, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 52, 36, false),
        TwitterEmoji(String(intArrayOf(0x1F9DC, 0x1F3FE, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 52, 37, false),
        TwitterEmoji(String(intArrayOf(0x1F9DC, 0x1F3FF, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 52, 38, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F9DD), 0, 1), listOf("elf"), 53, 2, true,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F9DD, 0x1F3FB), 0, 2), emptyList<String>(), 53, 3, true),
        TwitterEmoji(String(intArrayOf(0x1F9DD, 0x1F3FC), 0, 2), emptyList<String>(), 53, 4, true),
        TwitterEmoji(String(intArrayOf(0x1F9DD, 0x1F3FD), 0, 2), emptyList<String>(), 53, 5, true),
        TwitterEmoji(String(intArrayOf(0x1F9DD, 0x1F3FE), 0, 2), emptyList<String>(), 53, 6, true),
        TwitterEmoji(String(intArrayOf(0x1F9DD, 0x1F3FF), 0, 2), emptyList<String>(), 53, 7, true),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F9DD, 0x200D, 0x2642, 0xFE0F), 0, 4), listOf("male_elf"), 52, 57, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F9DD, 0x1F3FB, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 52, 58, false),
        TwitterEmoji(String(intArrayOf(0x1F9DD, 0x1F3FC, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 52, 59, false),
        TwitterEmoji(String(intArrayOf(0x1F9DD, 0x1F3FD, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 52, 60, false),
        TwitterEmoji(String(intArrayOf(0x1F9DD, 0x1F3FE, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 53, 0, false),
        TwitterEmoji(String(intArrayOf(0x1F9DD, 0x1F3FF, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 53, 1, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F9DD, 0x200D, 0x2640, 0xFE0F), 0, 4), listOf("female_elf"), 52, 51, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F9DD, 0x1F3FB, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 52, 52, false),
        TwitterEmoji(String(intArrayOf(0x1F9DD, 0x1F3FC, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 52, 53, false),
        TwitterEmoji(String(intArrayOf(0x1F9DD, 0x1F3FD, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 52, 54, false),
        TwitterEmoji(String(intArrayOf(0x1F9DD, 0x1F3FE, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 52, 55, false),
        TwitterEmoji(String(intArrayOf(0x1F9DD, 0x1F3FF, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 52, 56, false),
      )
    ),
    TwitterEmoji(String(intArrayOf(0x1F9DE), 0, 1), listOf("genie"), 53, 10, true),
    TwitterEmoji(String(intArrayOf(0x1F9DE, 0x200D, 0x2642, 0xFE0F), 0, 4), listOf("male_genie"), 53, 9, false),
    TwitterEmoji(String(intArrayOf(0x1F9DE, 0x200D, 0x2640, 0xFE0F), 0, 4), listOf("female_genie"), 53, 8, false),
    TwitterEmoji(String(intArrayOf(0x1F9DF), 0, 1), listOf("zombie"), 53, 13, true),
    TwitterEmoji(String(intArrayOf(0x1F9DF, 0x200D, 0x2642, 0xFE0F), 0, 4), listOf("male_zombie"), 53, 12, false),
    TwitterEmoji(String(intArrayOf(0x1F9DF, 0x200D, 0x2640, 0xFE0F), 0, 4), listOf("female_zombie"), 53, 11, false),
    TwitterEmoji(String(intArrayOf(0x1F9CC), 0, 1), listOf("troll"), 46, 17, false),
    TwitterEmoji(
      String(intArrayOf(0x1F486), 0, 1), listOf("massage"), 26, 10, true,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F486, 0x1F3FB), 0, 2), emptyList<String>(), 26, 11, false),
        TwitterEmoji(String(intArrayOf(0x1F486, 0x1F3FC), 0, 2), emptyList<String>(), 26, 12, false),
        TwitterEmoji(String(intArrayOf(0x1F486, 0x1F3FD), 0, 2), emptyList<String>(), 26, 13, false),
        TwitterEmoji(String(intArrayOf(0x1F486, 0x1F3FE), 0, 2), emptyList<String>(), 26, 14, false),
        TwitterEmoji(String(intArrayOf(0x1F486, 0x1F3FF), 0, 2), emptyList<String>(), 26, 15, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F486, 0x200D, 0x2642, 0xFE0F), 0, 4), listOf("man-getting-massage"), 26, 4, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F486, 0x1F3FB, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 26, 5, false),
        TwitterEmoji(String(intArrayOf(0x1F486, 0x1F3FC, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 26, 6, false),
        TwitterEmoji(String(intArrayOf(0x1F486, 0x1F3FD, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 26, 7, false),
        TwitterEmoji(String(intArrayOf(0x1F486, 0x1F3FE, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 26, 8, false),
        TwitterEmoji(String(intArrayOf(0x1F486, 0x1F3FF, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 26, 9, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F486, 0x200D, 0x2640, 0xFE0F), 0, 4), listOf("woman-getting-massage"), 25, 59, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F486, 0x1F3FB, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 25, 60, false),
        TwitterEmoji(String(intArrayOf(0x1F486, 0x1F3FC, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 26, 0, false),
        TwitterEmoji(String(intArrayOf(0x1F486, 0x1F3FD, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 26, 1, false),
        TwitterEmoji(String(intArrayOf(0x1F486, 0x1F3FE, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 26, 2, false),
        TwitterEmoji(String(intArrayOf(0x1F486, 0x1F3FF, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 26, 3, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F487), 0, 1), listOf("haircut"), 26, 28, true,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F487, 0x1F3FB), 0, 2), emptyList<String>(), 26, 29, false),
        TwitterEmoji(String(intArrayOf(0x1F487, 0x1F3FC), 0, 2), emptyList<String>(), 26, 30, false),
        TwitterEmoji(String(intArrayOf(0x1F487, 0x1F3FD), 0, 2), emptyList<String>(), 26, 31, false),
        TwitterEmoji(String(intArrayOf(0x1F487, 0x1F3FE), 0, 2), emptyList<String>(), 26, 32, false),
        TwitterEmoji(String(intArrayOf(0x1F487, 0x1F3FF), 0, 2), emptyList<String>(), 26, 33, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F487, 0x200D, 0x2642, 0xFE0F), 0, 4), listOf("man-getting-haircut"), 26, 22, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F487, 0x1F3FB, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 26, 23, false),
        TwitterEmoji(String(intArrayOf(0x1F487, 0x1F3FC, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 26, 24, false),
        TwitterEmoji(String(intArrayOf(0x1F487, 0x1F3FD, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 26, 25, false),
        TwitterEmoji(String(intArrayOf(0x1F487, 0x1F3FE, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 26, 26, false),
        TwitterEmoji(String(intArrayOf(0x1F487, 0x1F3FF, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 26, 27, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F487, 0x200D, 0x2640, 0xFE0F), 0, 4), listOf("woman-getting-haircut"), 26, 16, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F487, 0x1F3FB, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 26, 17, false),
        TwitterEmoji(String(intArrayOf(0x1F487, 0x1F3FC, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 26, 18, false),
        TwitterEmoji(String(intArrayOf(0x1F487, 0x1F3FD, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 26, 19, false),
        TwitterEmoji(String(intArrayOf(0x1F487, 0x1F3FE, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 26, 20, false),
        TwitterEmoji(String(intArrayOf(0x1F487, 0x1F3FF, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 26, 21, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F6B6), 0, 1), listOf("walking"), 37, 27, true,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F6B6, 0x1F3FB), 0, 2), emptyList<String>(), 37, 28, false),
        TwitterEmoji(String(intArrayOf(0x1F6B6, 0x1F3FC), 0, 2), emptyList<String>(), 37, 29, false),
        TwitterEmoji(String(intArrayOf(0x1F6B6, 0x1F3FD), 0, 2), emptyList<String>(), 37, 30, false),
        TwitterEmoji(String(intArrayOf(0x1F6B6, 0x1F3FE), 0, 2), emptyList<String>(), 37, 31, false),
        TwitterEmoji(String(intArrayOf(0x1F6B6, 0x1F3FF), 0, 2), emptyList<String>(), 37, 32, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F6B6, 0x200D, 0x2642, 0xFE0F), 0, 4), listOf("man-walking"), 37, 21, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F6B6, 0x1F3FB, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 37, 22, false),
        TwitterEmoji(String(intArrayOf(0x1F6B6, 0x1F3FC, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 37, 23, false),
        TwitterEmoji(String(intArrayOf(0x1F6B6, 0x1F3FD, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 37, 24, false),
        TwitterEmoji(String(intArrayOf(0x1F6B6, 0x1F3FE, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 37, 25, false),
        TwitterEmoji(String(intArrayOf(0x1F6B6, 0x1F3FF, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 37, 26, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F6B6, 0x200D, 0x2640, 0xFE0F), 0, 4), listOf("woman-walking"), 37, 15, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F6B6, 0x1F3FB, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 37, 16, false),
        TwitterEmoji(String(intArrayOf(0x1F6B6, 0x1F3FC, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 37, 17, false),
        TwitterEmoji(String(intArrayOf(0x1F6B6, 0x1F3FD, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 37, 18, false),
        TwitterEmoji(String(intArrayOf(0x1F6B6, 0x1F3FE, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 37, 19, false),
        TwitterEmoji(String(intArrayOf(0x1F6B6, 0x1F3FF, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 37, 20, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F9CD), 0, 1), listOf("standing_person"), 46, 30, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F9CD, 0x1F3FB), 0, 2), emptyList<String>(), 46, 31, false),
        TwitterEmoji(String(intArrayOf(0x1F9CD, 0x1F3FC), 0, 2), emptyList<String>(), 46, 32, false),
        TwitterEmoji(String(intArrayOf(0x1F9CD, 0x1F3FD), 0, 2), emptyList<String>(), 46, 33, false),
        TwitterEmoji(String(intArrayOf(0x1F9CD, 0x1F3FE), 0, 2), emptyList<String>(), 46, 34, false),
        TwitterEmoji(String(intArrayOf(0x1F9CD, 0x1F3FF), 0, 2), emptyList<String>(), 46, 35, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F9CD, 0x200D, 0x2642, 0xFE0F), 0, 4), listOf("man_standing"), 46, 24, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F9CD, 0x1F3FB, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 46, 25, false),
        TwitterEmoji(String(intArrayOf(0x1F9CD, 0x1F3FC, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 46, 26, false),
        TwitterEmoji(String(intArrayOf(0x1F9CD, 0x1F3FD, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 46, 27, false),
        TwitterEmoji(String(intArrayOf(0x1F9CD, 0x1F3FE, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 46, 28, false),
        TwitterEmoji(String(intArrayOf(0x1F9CD, 0x1F3FF, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 46, 29, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F9CD, 0x200D, 0x2640, 0xFE0F), 0, 4), listOf("woman_standing"), 46, 18, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F9CD, 0x1F3FB, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 46, 19, false),
        TwitterEmoji(String(intArrayOf(0x1F9CD, 0x1F3FC, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 46, 20, false),
        TwitterEmoji(String(intArrayOf(0x1F9CD, 0x1F3FD, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 46, 21, false),
        TwitterEmoji(String(intArrayOf(0x1F9CD, 0x1F3FE, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 46, 22, false),
        TwitterEmoji(String(intArrayOf(0x1F9CD, 0x1F3FF, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 46, 23, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F9CE), 0, 1), listOf("kneeling_person"), 46, 48, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F9CE, 0x1F3FB), 0, 2), emptyList<String>(), 46, 49, false),
        TwitterEmoji(String(intArrayOf(0x1F9CE, 0x1F3FC), 0, 2), emptyList<String>(), 46, 50, false),
        TwitterEmoji(String(intArrayOf(0x1F9CE, 0x1F3FD), 0, 2), emptyList<String>(), 46, 51, false),
        TwitterEmoji(String(intArrayOf(0x1F9CE, 0x1F3FE), 0, 2), emptyList<String>(), 46, 52, false),
        TwitterEmoji(String(intArrayOf(0x1F9CE, 0x1F3FF), 0, 2), emptyList<String>(), 46, 53, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F9CE, 0x200D, 0x2642, 0xFE0F), 0, 4), listOf("man_kneeling"), 46, 42, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F9CE, 0x1F3FB, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 46, 43, false),
        TwitterEmoji(String(intArrayOf(0x1F9CE, 0x1F3FC, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 46, 44, false),
        TwitterEmoji(String(intArrayOf(0x1F9CE, 0x1F3FD, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 46, 45, false),
        TwitterEmoji(String(intArrayOf(0x1F9CE, 0x1F3FE, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 46, 46, false),
        TwitterEmoji(String(intArrayOf(0x1F9CE, 0x1F3FF, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 46, 47, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F9CE, 0x200D, 0x2640, 0xFE0F), 0, 4), listOf("woman_kneeling"), 46, 36, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F9CE, 0x1F3FB, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 46, 37, false),
        TwitterEmoji(String(intArrayOf(0x1F9CE, 0x1F3FC, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 46, 38, false),
        TwitterEmoji(String(intArrayOf(0x1F9CE, 0x1F3FD, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 46, 39, false),
        TwitterEmoji(String(intArrayOf(0x1F9CE, 0x1F3FE, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 46, 40, false),
        TwitterEmoji(String(intArrayOf(0x1F9CE, 0x1F3FF, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 46, 41, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F9D1, 0x200D, 0x1F9AF), 0, 3), listOf("person_with_probing_cane"), 49, 6, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F9D1, 0x1F3FB, 0x200D, 0x1F9AF), 0, 4), emptyList<String>(), 49, 7, false),
        TwitterEmoji(String(intArrayOf(0x1F9D1, 0x1F3FC, 0x200D, 0x1F9AF), 0, 4), emptyList<String>(), 49, 8, false),
        TwitterEmoji(String(intArrayOf(0x1F9D1, 0x1F3FD, 0x200D, 0x1F9AF), 0, 4), emptyList<String>(), 49, 9, false),
        TwitterEmoji(String(intArrayOf(0x1F9D1, 0x1F3FE, 0x200D, 0x1F9AF), 0, 4), emptyList<String>(), 49, 10, false),
        TwitterEmoji(String(intArrayOf(0x1F9D1, 0x1F3FF, 0x200D, 0x1F9AF), 0, 4), emptyList<String>(), 49, 11, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F468, 0x200D, 0x1F9AF), 0, 3), listOf("man_with_probing_cane"), 15, 23, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F468, 0x1F3FB, 0x200D, 0x1F9AF), 0, 4), emptyList<String>(), 15, 24, false),
        TwitterEmoji(String(intArrayOf(0x1F468, 0x1F3FC, 0x200D, 0x1F9AF), 0, 4), emptyList<String>(), 15, 25, false),
        TwitterEmoji(String(intArrayOf(0x1F468, 0x1F3FD, 0x200D, 0x1F9AF), 0, 4), emptyList<String>(), 15, 26, false),
        TwitterEmoji(String(intArrayOf(0x1F468, 0x1F3FE, 0x200D, 0x1F9AF), 0, 4), emptyList<String>(), 15, 27, false),
        TwitterEmoji(String(intArrayOf(0x1F468, 0x1F3FF, 0x200D, 0x1F9AF), 0, 4), emptyList<String>(), 15, 28, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F469, 0x200D, 0x1F9AF), 0, 3), listOf("woman_with_probing_cane"), 18, 52, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FB, 0x200D, 0x1F9AF), 0, 4), emptyList<String>(), 18, 53, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FC, 0x200D, 0x1F9AF), 0, 4), emptyList<String>(), 18, 54, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FD, 0x200D, 0x1F9AF), 0, 4), emptyList<String>(), 18, 55, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FE, 0x200D, 0x1F9AF), 0, 4), emptyList<String>(), 18, 56, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FF, 0x200D, 0x1F9AF), 0, 4), emptyList<String>(), 18, 57, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F9D1, 0x200D, 0x1F9BC), 0, 3), listOf("person_in_motorized_wheelchair"), 49, 36, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F9D1, 0x1F3FB, 0x200D, 0x1F9BC), 0, 4), emptyList<String>(), 49, 37, false),
        TwitterEmoji(String(intArrayOf(0x1F9D1, 0x1F3FC, 0x200D, 0x1F9BC), 0, 4), emptyList<String>(), 49, 38, false),
        TwitterEmoji(String(intArrayOf(0x1F9D1, 0x1F3FD, 0x200D, 0x1F9BC), 0, 4), emptyList<String>(), 49, 39, false),
        TwitterEmoji(String(intArrayOf(0x1F9D1, 0x1F3FE, 0x200D, 0x1F9BC), 0, 4), emptyList<String>(), 49, 40, false),
        TwitterEmoji(String(intArrayOf(0x1F9D1, 0x1F3FF, 0x200D, 0x1F9BC), 0, 4), emptyList<String>(), 49, 41, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F468, 0x200D, 0x1F9BC), 0, 3), listOf("man_in_motorized_wheelchair"), 15, 53, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F468, 0x1F3FB, 0x200D, 0x1F9BC), 0, 4), emptyList<String>(), 15, 54, false),
        TwitterEmoji(String(intArrayOf(0x1F468, 0x1F3FC, 0x200D, 0x1F9BC), 0, 4), emptyList<String>(), 15, 55, false),
        TwitterEmoji(String(intArrayOf(0x1F468, 0x1F3FD, 0x200D, 0x1F9BC), 0, 4), emptyList<String>(), 15, 56, false),
        TwitterEmoji(String(intArrayOf(0x1F468, 0x1F3FE, 0x200D, 0x1F9BC), 0, 4), emptyList<String>(), 15, 57, false),
        TwitterEmoji(String(intArrayOf(0x1F468, 0x1F3FF, 0x200D, 0x1F9BC), 0, 4), emptyList<String>(), 15, 58, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F469, 0x200D, 0x1F9BC), 0, 3), listOf("woman_in_motorized_wheelchair"), 19, 21, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FB, 0x200D, 0x1F9BC), 0, 4), emptyList<String>(), 19, 22, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FC, 0x200D, 0x1F9BC), 0, 4), emptyList<String>(), 19, 23, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FD, 0x200D, 0x1F9BC), 0, 4), emptyList<String>(), 19, 24, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FE, 0x200D, 0x1F9BC), 0, 4), emptyList<String>(), 19, 25, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FF, 0x200D, 0x1F9BC), 0, 4), emptyList<String>(), 19, 26, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F9D1, 0x200D, 0x1F9BD), 0, 3), listOf("person_in_manual_wheelchair"), 49, 42, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F9D1, 0x1F3FB, 0x200D, 0x1F9BD), 0, 4), emptyList<String>(), 49, 43, false),
        TwitterEmoji(String(intArrayOf(0x1F9D1, 0x1F3FC, 0x200D, 0x1F9BD), 0, 4), emptyList<String>(), 49, 44, false),
        TwitterEmoji(String(intArrayOf(0x1F9D1, 0x1F3FD, 0x200D, 0x1F9BD), 0, 4), emptyList<String>(), 49, 45, false),
        TwitterEmoji(String(intArrayOf(0x1F9D1, 0x1F3FE, 0x200D, 0x1F9BD), 0, 4), emptyList<String>(), 49, 46, false),
        TwitterEmoji(String(intArrayOf(0x1F9D1, 0x1F3FF, 0x200D, 0x1F9BD), 0, 4), emptyList<String>(), 49, 47, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F468, 0x200D, 0x1F9BD), 0, 3), listOf("man_in_manual_wheelchair"), 15, 59, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F468, 0x1F3FB, 0x200D, 0x1F9BD), 0, 4), emptyList<String>(), 15, 60, false),
        TwitterEmoji(String(intArrayOf(0x1F468, 0x1F3FC, 0x200D, 0x1F9BD), 0, 4), emptyList<String>(), 16, 0, false),
        TwitterEmoji(String(intArrayOf(0x1F468, 0x1F3FD, 0x200D, 0x1F9BD), 0, 4), emptyList<String>(), 16, 1, false),
        TwitterEmoji(String(intArrayOf(0x1F468, 0x1F3FE, 0x200D, 0x1F9BD), 0, 4), emptyList<String>(), 16, 2, false),
        TwitterEmoji(String(intArrayOf(0x1F468, 0x1F3FF, 0x200D, 0x1F9BD), 0, 4), emptyList<String>(), 16, 3, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F469, 0x200D, 0x1F9BD), 0, 3), listOf("woman_in_manual_wheelchair"), 19, 27, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FB, 0x200D, 0x1F9BD), 0, 4), emptyList<String>(), 19, 28, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FC, 0x200D, 0x1F9BD), 0, 4), emptyList<String>(), 19, 29, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FD, 0x200D, 0x1F9BD), 0, 4), emptyList<String>(), 19, 30, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FE, 0x200D, 0x1F9BD), 0, 4), emptyList<String>(), 19, 31, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FF, 0x200D, 0x1F9BD), 0, 4), emptyList<String>(), 19, 32, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F3C3), 0, 1), listOf("runner", "running"), 8, 26, true,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F3C3, 0x1F3FB), 0, 2), emptyList<String>(), 8, 27, false),
        TwitterEmoji(String(intArrayOf(0x1F3C3, 0x1F3FC), 0, 2), emptyList<String>(), 8, 28, false),
        TwitterEmoji(String(intArrayOf(0x1F3C3, 0x1F3FD), 0, 2), emptyList<String>(), 8, 29, false),
        TwitterEmoji(String(intArrayOf(0x1F3C3, 0x1F3FE), 0, 2), emptyList<String>(), 8, 30, false),
        TwitterEmoji(String(intArrayOf(0x1F3C3, 0x1F3FF), 0, 2), emptyList<String>(), 8, 31, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F3C3, 0x200D, 0x2642, 0xFE0F), 0, 4), listOf("man-running"), 8, 20, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F3C3, 0x1F3FB, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 8, 21, false),
        TwitterEmoji(String(intArrayOf(0x1F3C3, 0x1F3FC, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 8, 22, false),
        TwitterEmoji(String(intArrayOf(0x1F3C3, 0x1F3FD, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 8, 23, false),
        TwitterEmoji(String(intArrayOf(0x1F3C3, 0x1F3FE, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 8, 24, false),
        TwitterEmoji(String(intArrayOf(0x1F3C3, 0x1F3FF, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 8, 25, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F3C3, 0x200D, 0x2640, 0xFE0F), 0, 4), listOf("woman-running"), 8, 14, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F3C3, 0x1F3FB, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 8, 15, false),
        TwitterEmoji(String(intArrayOf(0x1F3C3, 0x1F3FC, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 8, 16, false),
        TwitterEmoji(String(intArrayOf(0x1F3C3, 0x1F3FD, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 8, 17, false),
        TwitterEmoji(String(intArrayOf(0x1F3C3, 0x1F3FE, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 8, 18, false),
        TwitterEmoji(String(intArrayOf(0x1F3C3, 0x1F3FF, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 8, 19, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F483), 0, 1), listOf("dancer"), 25, 46, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F483, 0x1F3FB), 0, 2), emptyList<String>(), 25, 47, false),
        TwitterEmoji(String(intArrayOf(0x1F483, 0x1F3FC), 0, 2), emptyList<String>(), 25, 48, false),
        TwitterEmoji(String(intArrayOf(0x1F483, 0x1F3FD), 0, 2), emptyList<String>(), 25, 49, false),
        TwitterEmoji(String(intArrayOf(0x1F483, 0x1F3FE), 0, 2), emptyList<String>(), 25, 50, false),
        TwitterEmoji(String(intArrayOf(0x1F483, 0x1F3FF), 0, 2), emptyList<String>(), 25, 51, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F57A), 0, 1), listOf("man_dancing"), 31, 26, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F57A, 0x1F3FB), 0, 2), emptyList<String>(), 31, 27, false),
        TwitterEmoji(String(intArrayOf(0x1F57A, 0x1F3FC), 0, 2), emptyList<String>(), 31, 28, false),
        TwitterEmoji(String(intArrayOf(0x1F57A, 0x1F3FD), 0, 2), emptyList<String>(), 31, 29, false),
        TwitterEmoji(String(intArrayOf(0x1F57A, 0x1F3FE), 0, 2), emptyList<String>(), 31, 30, false),
        TwitterEmoji(String(intArrayOf(0x1F57A, 0x1F3FF), 0, 2), emptyList<String>(), 31, 31, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F574, 0xFE0F), 0, 2), listOf("man_in_business_suit_levitating"), 30, 59, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F574, 0x1F3FB), 0, 2), emptyList<String>(), 30, 60, false),
        TwitterEmoji(String(intArrayOf(0x1F574, 0x1F3FC), 0, 2), emptyList<String>(), 31, 0, false),
        TwitterEmoji(String(intArrayOf(0x1F574, 0x1F3FD), 0, 2), emptyList<String>(), 31, 1, false),
        TwitterEmoji(String(intArrayOf(0x1F574, 0x1F3FE), 0, 2), emptyList<String>(), 31, 2, false),
        TwitterEmoji(String(intArrayOf(0x1F574, 0x1F3FF), 0, 2), emptyList<String>(), 31, 3, false),
      )
    ),
    TwitterEmoji(String(intArrayOf(0x1F46F), 0, 1), listOf("dancers"), 23, 16, true),
    TwitterEmoji(String(intArrayOf(0x1F46F, 0x200D, 0x2642, 0xFE0F), 0, 4), listOf("men-with-bunny-ears-partying", "man-with-bunny-ears-partying"), 23, 15, false),
    TwitterEmoji(String(intArrayOf(0x1F46F, 0x200D, 0x2640, 0xFE0F), 0, 4), listOf("women-with-bunny-ears-partying", "woman-with-bunny-ears-partying"), 23, 14, false),
    TwitterEmoji(
      String(intArrayOf(0x1F9D6), 0, 1), listOf("person_in_steamy_room"), 50, 59, true,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F9D6, 0x1F3FB), 0, 2), emptyList<String>(), 50, 60, true),
        TwitterEmoji(String(intArrayOf(0x1F9D6, 0x1F3FC), 0, 2), emptyList<String>(), 51, 0, true),
        TwitterEmoji(String(intArrayOf(0x1F9D6, 0x1F3FD), 0, 2), emptyList<String>(), 51, 1, true),
        TwitterEmoji(String(intArrayOf(0x1F9D6, 0x1F3FE), 0, 2), emptyList<String>(), 51, 2, true),
        TwitterEmoji(String(intArrayOf(0x1F9D6, 0x1F3FF), 0, 2), emptyList<String>(), 51, 3, true),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F9D6, 0x200D, 0x2642, 0xFE0F), 0, 4), listOf("man_in_steamy_room"), 50, 53, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F9D6, 0x1F3FB, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 50, 54, false),
        TwitterEmoji(String(intArrayOf(0x1F9D6, 0x1F3FC, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 50, 55, false),
        TwitterEmoji(String(intArrayOf(0x1F9D6, 0x1F3FD, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 50, 56, false),
        TwitterEmoji(String(intArrayOf(0x1F9D6, 0x1F3FE, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 50, 57, false),
        TwitterEmoji(String(intArrayOf(0x1F9D6, 0x1F3FF, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 50, 58, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F9D6, 0x200D, 0x2640, 0xFE0F), 0, 4), listOf("woman_in_steamy_room"), 50, 47, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F9D6, 0x1F3FB, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 50, 48, false),
        TwitterEmoji(String(intArrayOf(0x1F9D6, 0x1F3FC, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 50, 49, false),
        TwitterEmoji(String(intArrayOf(0x1F9D6, 0x1F3FD, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 50, 50, false),
        TwitterEmoji(String(intArrayOf(0x1F9D6, 0x1F3FE, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 50, 51, false),
        TwitterEmoji(String(intArrayOf(0x1F9D6, 0x1F3FF, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 50, 52, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F9D7), 0, 1), listOf("person_climbing"), 51, 16, true,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F9D7, 0x1F3FB), 0, 2), emptyList<String>(), 51, 17, true),
        TwitterEmoji(String(intArrayOf(0x1F9D7, 0x1F3FC), 0, 2), emptyList<String>(), 51, 18, true),
        TwitterEmoji(String(intArrayOf(0x1F9D7, 0x1F3FD), 0, 2), emptyList<String>(), 51, 19, true),
        TwitterEmoji(String(intArrayOf(0x1F9D7, 0x1F3FE), 0, 2), emptyList<String>(), 51, 20, true),
        TwitterEmoji(String(intArrayOf(0x1F9D7, 0x1F3FF), 0, 2), emptyList<String>(), 51, 21, true),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F9D7, 0x200D, 0x2642, 0xFE0F), 0, 4), listOf("man_climbing"), 51, 10, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F9D7, 0x1F3FB, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 51, 11, false),
        TwitterEmoji(String(intArrayOf(0x1F9D7, 0x1F3FC, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 51, 12, false),
        TwitterEmoji(String(intArrayOf(0x1F9D7, 0x1F3FD, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 51, 13, false),
        TwitterEmoji(String(intArrayOf(0x1F9D7, 0x1F3FE, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 51, 14, false),
        TwitterEmoji(String(intArrayOf(0x1F9D7, 0x1F3FF, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 51, 15, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F9D7, 0x200D, 0x2640, 0xFE0F), 0, 4), listOf("woman_climbing"), 51, 4, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F9D7, 0x1F3FB, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 51, 5, false),
        TwitterEmoji(String(intArrayOf(0x1F9D7, 0x1F3FC, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 51, 6, false),
        TwitterEmoji(String(intArrayOf(0x1F9D7, 0x1F3FD, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 51, 7, false),
        TwitterEmoji(String(intArrayOf(0x1F9D7, 0x1F3FE, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 51, 8, false),
        TwitterEmoji(String(intArrayOf(0x1F9D7, 0x1F3FF, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 51, 9, false),
      )
    ),
    TwitterEmoji(String(intArrayOf(0x1F93A), 0, 1), listOf("fencer"), 42, 31, false),
    TwitterEmoji(
      String(intArrayOf(0x1F3C7), 0, 1), listOf("horse_racing"), 8, 52, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F3C7, 0x1F3FB), 0, 2), emptyList<String>(), 8, 53, false),
        TwitterEmoji(String(intArrayOf(0x1F3C7, 0x1F3FC), 0, 2), emptyList<String>(), 8, 54, false),
        TwitterEmoji(String(intArrayOf(0x1F3C7, 0x1F3FD), 0, 2), emptyList<String>(), 8, 55, false),
        TwitterEmoji(String(intArrayOf(0x1F3C7, 0x1F3FE), 0, 2), emptyList<String>(), 8, 56, false),
        TwitterEmoji(String(intArrayOf(0x1F3C7, 0x1F3FF), 0, 2), emptyList<String>(), 8, 57, false),
      )
    ),
    TwitterEmoji(String(intArrayOf(0x26F7, 0xFE0F), 0, 2), listOf("skier"), 58, 1, false),
    TwitterEmoji(
      String(intArrayOf(0x1F3C2), 0, 1), listOf("snowboarder"), 8, 8, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F3C2, 0x1F3FB), 0, 2), emptyList<String>(), 8, 9, false),
        TwitterEmoji(String(intArrayOf(0x1F3C2, 0x1F3FC), 0, 2), emptyList<String>(), 8, 10, false),
        TwitterEmoji(String(intArrayOf(0x1F3C2, 0x1F3FD), 0, 2), emptyList<String>(), 8, 11, false),
        TwitterEmoji(String(intArrayOf(0x1F3C2, 0x1F3FE), 0, 2), emptyList<String>(), 8, 12, false),
        TwitterEmoji(String(intArrayOf(0x1F3C2, 0x1F3FF), 0, 2), emptyList<String>(), 8, 13, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F3CC, 0xFE0F), 0, 2), listOf("golfer"), 9, 47, true,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F3CC, 0x1F3FB), 0, 2), emptyList<String>(), 9, 48, false),
        TwitterEmoji(String(intArrayOf(0x1F3CC, 0x1F3FC), 0, 2), emptyList<String>(), 9, 49, false),
        TwitterEmoji(String(intArrayOf(0x1F3CC, 0x1F3FD), 0, 2), emptyList<String>(), 9, 50, false),
        TwitterEmoji(String(intArrayOf(0x1F3CC, 0x1F3FE), 0, 2), emptyList<String>(), 9, 51, false),
        TwitterEmoji(String(intArrayOf(0x1F3CC, 0x1F3FF), 0, 2), emptyList<String>(), 9, 52, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F3CC, 0xFE0F, 0x200D, 0x2642, 0xFE0F), 0, 5), listOf("man-golfing"), 9, 41, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F3CC, 0x1F3FB, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 9, 42, false),
        TwitterEmoji(String(intArrayOf(0x1F3CC, 0x1F3FC, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 9, 43, false),
        TwitterEmoji(String(intArrayOf(0x1F3CC, 0x1F3FD, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 9, 44, false),
        TwitterEmoji(String(intArrayOf(0x1F3CC, 0x1F3FE, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 9, 45, false),
        TwitterEmoji(String(intArrayOf(0x1F3CC, 0x1F3FF, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 9, 46, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F3CC, 0xFE0F, 0x200D, 0x2640, 0xFE0F), 0, 5), listOf("woman-golfing"), 9, 35, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F3CC, 0x1F3FB, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 9, 36, false),
        TwitterEmoji(String(intArrayOf(0x1F3CC, 0x1F3FC, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 9, 37, false),
        TwitterEmoji(String(intArrayOf(0x1F3CC, 0x1F3FD, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 9, 38, false),
        TwitterEmoji(String(intArrayOf(0x1F3CC, 0x1F3FE, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 9, 39, false),
        TwitterEmoji(String(intArrayOf(0x1F3CC, 0x1F3FF, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 9, 40, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F3C4), 0, 1), listOf("surfer"), 8, 44, true,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F3C4, 0x1F3FB), 0, 2), emptyList<String>(), 8, 45, false),
        TwitterEmoji(String(intArrayOf(0x1F3C4, 0x1F3FC), 0, 2), emptyList<String>(), 8, 46, false),
        TwitterEmoji(String(intArrayOf(0x1F3C4, 0x1F3FD), 0, 2), emptyList<String>(), 8, 47, false),
        TwitterEmoji(String(intArrayOf(0x1F3C4, 0x1F3FE), 0, 2), emptyList<String>(), 8, 48, false),
        TwitterEmoji(String(intArrayOf(0x1F3C4, 0x1F3FF), 0, 2), emptyList<String>(), 8, 49, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F3C4, 0x200D, 0x2642, 0xFE0F), 0, 4), listOf("man-surfing"), 8, 38, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F3C4, 0x1F3FB, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 8, 39, false),
        TwitterEmoji(String(intArrayOf(0x1F3C4, 0x1F3FC, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 8, 40, false),
        TwitterEmoji(String(intArrayOf(0x1F3C4, 0x1F3FD, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 8, 41, false),
        TwitterEmoji(String(intArrayOf(0x1F3C4, 0x1F3FE, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 8, 42, false),
        TwitterEmoji(String(intArrayOf(0x1F3C4, 0x1F3FF, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 8, 43, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F3C4, 0x200D, 0x2640, 0xFE0F), 0, 4), listOf("woman-surfing"), 8, 32, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F3C4, 0x1F3FB, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 8, 33, false),
        TwitterEmoji(String(intArrayOf(0x1F3C4, 0x1F3FC, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 8, 34, false),
        TwitterEmoji(String(intArrayOf(0x1F3C4, 0x1F3FD, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 8, 35, false),
        TwitterEmoji(String(intArrayOf(0x1F3C4, 0x1F3FE, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 8, 36, false),
        TwitterEmoji(String(intArrayOf(0x1F3C4, 0x1F3FF, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 8, 37, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F6A3), 0, 1), listOf("rowboat"), 36, 18, true,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F6A3, 0x1F3FB), 0, 2), emptyList<String>(), 36, 19, false),
        TwitterEmoji(String(intArrayOf(0x1F6A3, 0x1F3FC), 0, 2), emptyList<String>(), 36, 20, false),
        TwitterEmoji(String(intArrayOf(0x1F6A3, 0x1F3FD), 0, 2), emptyList<String>(), 36, 21, false),
        TwitterEmoji(String(intArrayOf(0x1F6A3, 0x1F3FE), 0, 2), emptyList<String>(), 36, 22, false),
        TwitterEmoji(String(intArrayOf(0x1F6A3, 0x1F3FF), 0, 2), emptyList<String>(), 36, 23, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F6A3, 0x200D, 0x2642, 0xFE0F), 0, 4), listOf("man-rowing-boat"), 36, 12, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F6A3, 0x1F3FB, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 36, 13, false),
        TwitterEmoji(String(intArrayOf(0x1F6A3, 0x1F3FC, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 36, 14, false),
        TwitterEmoji(String(intArrayOf(0x1F6A3, 0x1F3FD, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 36, 15, false),
        TwitterEmoji(String(intArrayOf(0x1F6A3, 0x1F3FE, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 36, 16, false),
        TwitterEmoji(String(intArrayOf(0x1F6A3, 0x1F3FF, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 36, 17, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F6A3, 0x200D, 0x2640, 0xFE0F), 0, 4), listOf("woman-rowing-boat"), 36, 6, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F6A3, 0x1F3FB, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 36, 7, false),
        TwitterEmoji(String(intArrayOf(0x1F6A3, 0x1F3FC, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 36, 8, false),
        TwitterEmoji(String(intArrayOf(0x1F6A3, 0x1F3FD, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 36, 9, false),
        TwitterEmoji(String(intArrayOf(0x1F6A3, 0x1F3FE, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 36, 10, false),
        TwitterEmoji(String(intArrayOf(0x1F6A3, 0x1F3FF, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 36, 11, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F3CA), 0, 1), listOf("swimmer"), 9, 11, true,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F3CA, 0x1F3FB), 0, 2), emptyList<String>(), 9, 12, false),
        TwitterEmoji(String(intArrayOf(0x1F3CA, 0x1F3FC), 0, 2), emptyList<String>(), 9, 13, false),
        TwitterEmoji(String(intArrayOf(0x1F3CA, 0x1F3FD), 0, 2), emptyList<String>(), 9, 14, false),
        TwitterEmoji(String(intArrayOf(0x1F3CA, 0x1F3FE), 0, 2), emptyList<String>(), 9, 15, false),
        TwitterEmoji(String(intArrayOf(0x1F3CA, 0x1F3FF), 0, 2), emptyList<String>(), 9, 16, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F3CA, 0x200D, 0x2642, 0xFE0F), 0, 4), listOf("man-swimming"), 9, 5, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F3CA, 0x1F3FB, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 9, 6, false),
        TwitterEmoji(String(intArrayOf(0x1F3CA, 0x1F3FC, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 9, 7, false),
        TwitterEmoji(String(intArrayOf(0x1F3CA, 0x1F3FD, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 9, 8, false),
        TwitterEmoji(String(intArrayOf(0x1F3CA, 0x1F3FE, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 9, 9, false),
        TwitterEmoji(String(intArrayOf(0x1F3CA, 0x1F3FF, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 9, 10, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F3CA, 0x200D, 0x2640, 0xFE0F), 0, 4), listOf("woman-swimming"), 8, 60, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F3CA, 0x1F3FB, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 9, 0, false),
        TwitterEmoji(String(intArrayOf(0x1F3CA, 0x1F3FC, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 9, 1, false),
        TwitterEmoji(String(intArrayOf(0x1F3CA, 0x1F3FD, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 9, 2, false),
        TwitterEmoji(String(intArrayOf(0x1F3CA, 0x1F3FE, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 9, 3, false),
        TwitterEmoji(String(intArrayOf(0x1F3CA, 0x1F3FF, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 9, 4, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x26F9, 0xFE0F), 0, 2), listOf("person_with_ball"), 58, 15, true,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x26F9, 0x1F3FB), 0, 2), emptyList<String>(), 58, 16, false),
        TwitterEmoji(String(intArrayOf(0x26F9, 0x1F3FC), 0, 2), emptyList<String>(), 58, 17, false),
        TwitterEmoji(String(intArrayOf(0x26F9, 0x1F3FD), 0, 2), emptyList<String>(), 58, 18, false),
        TwitterEmoji(String(intArrayOf(0x26F9, 0x1F3FE), 0, 2), emptyList<String>(), 58, 19, false),
        TwitterEmoji(String(intArrayOf(0x26F9, 0x1F3FF), 0, 2), emptyList<String>(), 58, 20, false),
      )
    ),
  )
}
