/*
 * Copyright (C) 2016 - Niklas Baudy, Ruben Gees, Mario Đanić and contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.vanniktech.emoji.twitter.category

import com.vanniktech.emoji.twitter.TwitterEmoji

internal object SmileysAndPeopleCategoryChunk3 {
  internal val EMOJIS: List<TwitterEmoji> = listOf(
    TwitterEmoji(
      String(intArrayOf(0x26F9, 0xFE0F, 0x200D, 0x2642, 0xFE0F), 0, 5), listOf("man-bouncing-ball"), 58, 9, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x26F9, 0x1F3FB, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 58, 10, false),
        TwitterEmoji(String(intArrayOf(0x26F9, 0x1F3FC, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 58, 11, false),
        TwitterEmoji(String(intArrayOf(0x26F9, 0x1F3FD, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 58, 12, false),
        TwitterEmoji(String(intArrayOf(0x26F9, 0x1F3FE, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 58, 13, false),
        TwitterEmoji(String(intArrayOf(0x26F9, 0x1F3FF, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 58, 14, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x26F9, 0xFE0F, 0x200D, 0x2640, 0xFE0F), 0, 5), listOf("woman-bouncing-ball"), 58, 3, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x26F9, 0x1F3FB, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 58, 4, false),
        TwitterEmoji(String(intArrayOf(0x26F9, 0x1F3FC, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 58, 5, false),
        TwitterEmoji(String(intArrayOf(0x26F9, 0x1F3FD, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 58, 6, false),
        TwitterEmoji(String(intArrayOf(0x26F9, 0x1F3FE, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 58, 7, false),
        TwitterEmoji(String(intArrayOf(0x26F9, 0x1F3FF, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 58, 8, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F3CB, 0xFE0F), 0, 2), listOf("weight_lifter"), 9, 29, true,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F3CB, 0x1F3FB), 0, 2), emptyList<String>(), 9, 30, false),
        TwitterEmoji(String(intArrayOf(0x1F3CB, 0x1F3FC), 0, 2), emptyList<String>(), 9, 31, false),
        TwitterEmoji(String(intArrayOf(0x1F3CB, 0x1F3FD), 0, 2), emptyList<String>(), 9, 32, false),
        TwitterEmoji(String(intArrayOf(0x1F3CB, 0x1F3FE), 0, 2), emptyList<String>(), 9, 33, false),
        TwitterEmoji(String(intArrayOf(0x1F3CB, 0x1F3FF), 0, 2), emptyList<String>(), 9, 34, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F3CB, 0xFE0F, 0x200D, 0x2642, 0xFE0F), 0, 5), listOf("man-lifting-weights"), 9, 23, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F3CB, 0x1F3FB, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 9, 24, false),
        TwitterEmoji(String(intArrayOf(0x1F3CB, 0x1F3FC, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 9, 25, false),
        TwitterEmoji(String(intArrayOf(0x1F3CB, 0x1F3FD, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 9, 26, false),
        TwitterEmoji(String(intArrayOf(0x1F3CB, 0x1F3FE, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 9, 27, false),
        TwitterEmoji(String(intArrayOf(0x1F3CB, 0x1F3FF, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 9, 28, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F3CB, 0xFE0F, 0x200D, 0x2640, 0xFE0F), 0, 5), listOf("woman-lifting-weights"), 9, 17, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F3CB, 0x1F3FB, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 9, 18, false),
        TwitterEmoji(String(intArrayOf(0x1F3CB, 0x1F3FC, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 9, 19, false),
        TwitterEmoji(String(intArrayOf(0x1F3CB, 0x1F3FD, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 9, 20, false),
        TwitterEmoji(String(intArrayOf(0x1F3CB, 0x1F3FE, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 9, 21, false),
        TwitterEmoji(String(intArrayOf(0x1F3CB, 0x1F3FF, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 9, 22, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F6B4), 0, 1), listOf("bicyclist"), 36, 52, true,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F6B4, 0x1F3FB), 0, 2), emptyList<String>(), 36, 53, false),
        TwitterEmoji(String(intArrayOf(0x1F6B4, 0x1F3FC), 0, 2), emptyList<String>(), 36, 54, false),
        TwitterEmoji(String(intArrayOf(0x1F6B4, 0x1F3FD), 0, 2), emptyList<String>(), 36, 55, false),
        TwitterEmoji(String(intArrayOf(0x1F6B4, 0x1F3FE), 0, 2), emptyList<String>(), 36, 56, false),
        TwitterEmoji(String(intArrayOf(0x1F6B4, 0x1F3FF), 0, 2), emptyList<String>(), 36, 57, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F6B4, 0x200D, 0x2642, 0xFE0F), 0, 4), listOf("man-biking"), 36, 46, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F6B4, 0x1F3FB, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 36, 47, false),
        TwitterEmoji(String(intArrayOf(0x1F6B4, 0x1F3FC, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 36, 48, false),
        TwitterEmoji(String(intArrayOf(0x1F6B4, 0x1F3FD, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 36, 49, false),
        TwitterEmoji(String(intArrayOf(0x1F6B4, 0x1F3FE, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 36, 50, false),
        TwitterEmoji(String(intArrayOf(0x1F6B4, 0x1F3FF, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 36, 51, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F6B4, 0x200D, 0x2640, 0xFE0F), 0, 4), listOf("woman-biking"), 36, 40, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F6B4, 0x1F3FB, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 36, 41, false),
        TwitterEmoji(String(intArrayOf(0x1F6B4, 0x1F3FC, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 36, 42, false),
        TwitterEmoji(String(intArrayOf(0x1F6B4, 0x1F3FD, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 36, 43, false),
        TwitterEmoji(String(intArrayOf(0x1F6B4, 0x1F3FE, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 36, 44, false),
        TwitterEmoji(String(intArrayOf(0x1F6B4, 0x1F3FF, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 36, 45, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F6B5), 0, 1), listOf("mountain_bicyclist"), 37, 9, true,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F6B5, 0x1F3FB), 0, 2), emptyList<String>(), 37, 10, false),
        TwitterEmoji(String(intArrayOf(0x1F6B5, 0x1F3FC), 0, 2), emptyList<String>(), 37, 11, false),
        TwitterEmoji(String(intArrayOf(0x1F6B5, 0x1F3FD), 0, 2), emptyList<String>(), 37, 12, false),
        TwitterEmoji(String(intArrayOf(0x1F6B5, 0x1F3FE), 0, 2), emptyList<String>(), 37, 13, false),
        TwitterEmoji(String(intArrayOf(0x1F6B5, 0x1F3FF), 0, 2), emptyList<String>(), 37, 14, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F6B5, 0x200D, 0x2642, 0xFE0F), 0, 4), listOf("man-mountain-biking"), 37, 3, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F6B5, 0x1F3FB, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 37, 4, false),
        TwitterEmoji(String(intArrayOf(0x1F6B5, 0x1F3FC, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 37, 5, false),
        TwitterEmoji(String(intArrayOf(0x1F6B5, 0x1F3FD, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 37, 6, false),
        TwitterEmoji(String(intArrayOf(0x1F6B5, 0x1F3FE, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 37, 7, false),
        TwitterEmoji(String(intArrayOf(0x1F6B5, 0x1F3FF, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 37, 8, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F6B5, 0x200D, 0x2640, 0xFE0F), 0, 4), listOf("woman-mountain-biking"), 36, 58, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F6B5, 0x1F3FB, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 36, 59, false),
        TwitterEmoji(String(intArrayOf(0x1F6B5, 0x1F3FC, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 36, 60, false),
        TwitterEmoji(String(intArrayOf(0x1F6B5, 0x1F3FD, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 37, 0, false),
        TwitterEmoji(String(intArrayOf(0x1F6B5, 0x1F3FE, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 37, 1, false),
        TwitterEmoji(String(intArrayOf(0x1F6B5, 0x1F3FF, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 37, 2, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F938), 0, 1), listOf("person_doing_cartwheel"), 42, 7, true,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F938, 0x1F3FB), 0, 2), emptyList<String>(), 42, 8, false),
        TwitterEmoji(String(intArrayOf(0x1F938, 0x1F3FC), 0, 2), emptyList<String>(), 42, 9, false),
        TwitterEmoji(String(intArrayOf(0x1F938, 0x1F3FD), 0, 2), emptyList<String>(), 42, 10, false),
        TwitterEmoji(String(intArrayOf(0x1F938, 0x1F3FE), 0, 2), emptyList<String>(), 42, 11, false),
        TwitterEmoji(String(intArrayOf(0x1F938, 0x1F3FF), 0, 2), emptyList<String>(), 42, 12, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F938, 0x200D, 0x2642, 0xFE0F), 0, 4), listOf("man-cartwheeling"), 42, 1, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F938, 0x1F3FB, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 42, 2, false),
        TwitterEmoji(String(intArrayOf(0x1F938, 0x1F3FC, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 42, 3, false),
        TwitterEmoji(String(intArrayOf(0x1F938, 0x1F3FD, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 42, 4, false),
        TwitterEmoji(String(intArrayOf(0x1F938, 0x1F3FE, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 42, 5, false),
        TwitterEmoji(String(intArrayOf(0x1F938, 0x1F3FF, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 42, 6, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F938, 0x200D, 0x2640, 0xFE0F), 0, 4), listOf("woman-cartwheeling"), 41, 56, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F938, 0x1F3FB, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 41, 57, false),
        TwitterEmoji(String(intArrayOf(0x1F938, 0x1F3FC, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 41, 58, false),
        TwitterEmoji(String(intArrayOf(0x1F938, 0x1F3FD, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 41, 59, false),
        TwitterEmoji(String(intArrayOf(0x1F938, 0x1F3FE, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 41, 60, false),
        TwitterEmoji(String(intArrayOf(0x1F938, 0x1F3FF, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 42, 0, false),
      )
    ),
    TwitterEmoji(String(intArrayOf(0x1F93C), 0, 1), listOf("wrestlers"), 42, 34, true),
    TwitterEmoji(String(intArrayOf(0x1F93C, 0x200D, 0x2642, 0xFE0F), 0, 4), listOf("man-wrestling"), 42, 33, false),
    TwitterEmoji(String(intArrayOf(0x1F93C, 0x200D, 0x2640, 0xFE0F), 0, 4), listOf("woman-wrestling"), 42, 32, false),
    TwitterEmoji(
      String(intArrayOf(0x1F93D), 0, 1), listOf("water_polo"), 42, 47, true,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F93D, 0x1F3FB), 0, 2), emptyList<String>(), 42, 48, false),
        TwitterEmoji(String(intArrayOf(0x1F93D, 0x1F3FC), 0, 2), emptyList<String>(), 42, 49, false),
        TwitterEmoji(String(intArrayOf(0x1F93D, 0x1F3FD), 0, 2), emptyList<String>(), 42, 50, false),
        TwitterEmoji(String(intArrayOf(0x1F93D, 0x1F3FE), 0, 2), emptyList<String>(), 42, 51, false),
        TwitterEmoji(String(intArrayOf(0x1F93D, 0x1F3FF), 0, 2), emptyList<String>(), 42, 52, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F93D, 0x200D, 0x2642, 0xFE0F), 0, 4), listOf("man-playing-water-polo"), 42, 41, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F93D, 0x1F3FB, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 42, 42, false),
        TwitterEmoji(String(intArrayOf(0x1F93D, 0x1F3FC, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 42, 43, false),
        TwitterEmoji(String(intArrayOf(0x1F93D, 0x1F3FD, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 42, 44, false),
        TwitterEmoji(String(intArrayOf(0x1F93D, 0x1F3FE, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 42, 45, false),
        TwitterEmoji(String(intArrayOf(0x1F93D, 0x1F3FF, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 42, 46, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F93D, 0x200D, 0x2640, 0xFE0F), 0, 4), listOf("woman-playing-water-polo"), 42, 35, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F93D, 0x1F3FB, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 42, 36, false),
        TwitterEmoji(String(intArrayOf(0x1F93D, 0x1F3FC, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 42, 37, false),
        TwitterEmoji(String(intArrayOf(0x1F93D, 0x1F3FD, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 42, 38, false),
        TwitterEmoji(String(intArrayOf(0x1F93D, 0x1F3FE, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 42, 39, false),
        TwitterEmoji(String(intArrayOf(0x1F93D, 0x1F3FF, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 42, 40, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F93E), 0, 1), listOf("handball"), 43, 4, true,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F93E, 0x1F3FB), 0, 2), emptyList<String>(), 43, 5, false),
        TwitterEmoji(String(intArrayOf(0x1F93E, 0x1F3FC), 0, 2), emptyList<String>(), 43, 6, false),
        TwitterEmoji(String(intArrayOf(0x1F93E, 0x1F3FD), 0, 2), emptyList<String>(), 43, 7, false),
        TwitterEmoji(String(intArrayOf(0x1F93E, 0x1F3FE), 0, 2), emptyList<String>(), 43, 8, false),
        TwitterEmoji(String(intArrayOf(0x1F93E, 0x1F3FF), 0, 2), emptyList<String>(), 43, 9, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F93E, 0x200D, 0x2642, 0xFE0F), 0, 4), listOf("man-playing-handball"), 42, 59, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F93E, 0x1F3FB, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 42, 60, false),
        TwitterEmoji(String(intArrayOf(0x1F93E, 0x1F3FC, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 43, 0, false),
        TwitterEmoji(String(intArrayOf(0x1F93E, 0x1F3FD, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 43, 1, false),
        TwitterEmoji(String(intArrayOf(0x1F93E, 0x1F3FE, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 43, 2, false),
        TwitterEmoji(String(intArrayOf(0x1F93E, 0x1F3FF, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 43, 3, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F93E, 0x200D, 0x2640, 0xFE0F), 0, 4), listOf("woman-playing-handball"), 42, 53, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F93E, 0x1F3FB, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 42, 54, false),
        TwitterEmoji(String(intArrayOf(0x1F93E, 0x1F3FC, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 42, 55, false),
        TwitterEmoji(String(intArrayOf(0x1F93E, 0x1F3FD, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 42, 56, false),
        TwitterEmoji(String(intArrayOf(0x1F93E, 0x1F3FE, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 42, 57, false),
        TwitterEmoji(String(intArrayOf(0x1F93E, 0x1F3FF, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 42, 58, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F939), 0, 1), listOf("juggling"), 42, 25, true,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F939, 0x1F3FB), 0, 2), emptyList<String>(), 42, 26, false),
        TwitterEmoji(String(intArrayOf(0x1F939, 0x1F3FC), 0, 2), emptyList<String>(), 42, 27, false),
        TwitterEmoji(String(intArrayOf(0x1F939, 0x1F3FD), 0, 2), emptyList<String>(), 42, 28, false),
        TwitterEmoji(String(intArrayOf(0x1F939, 0x1F3FE), 0, 2), emptyList<String>(), 42, 29, false),
        TwitterEmoji(String(intArrayOf(0x1F939, 0x1F3FF), 0, 2), emptyList<String>(), 42, 30, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F939, 0x200D, 0x2642, 0xFE0F), 0, 4), listOf("man-juggling"), 42, 19, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F939, 0x1F3FB, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 42, 20, false),
        TwitterEmoji(String(intArrayOf(0x1F939, 0x1F3FC, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 42, 21, false),
        TwitterEmoji(String(intArrayOf(0x1F939, 0x1F3FD, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 42, 22, false),
        TwitterEmoji(String(intArrayOf(0x1F939, 0x1F3FE, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 42, 23, false),
        TwitterEmoji(String(intArrayOf(0x1F939, 0x1F3FF, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 42, 24, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F939, 0x200D, 0x2640, 0xFE0F), 0, 4), listOf("woman-juggling"), 42, 13, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F939, 0x1F3FB, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 42, 14, false),
        TwitterEmoji(String(intArrayOf(0x1F939, 0x1F3FC, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 42, 15, false),
        TwitterEmoji(String(intArrayOf(0x1F939, 0x1F3FD, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 42, 16, false),
        TwitterEmoji(String(intArrayOf(0x1F939, 0x1F3FE, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 42, 17, false),
        TwitterEmoji(String(intArrayOf(0x1F939, 0x1F3FF, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 42, 18, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F9D8), 0, 1), listOf("person_in_lotus_position"), 51, 34, true,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F9D8, 0x1F3FB), 0, 2), emptyList<String>(), 51, 35, true),
        TwitterEmoji(String(intArrayOf(0x1F9D8, 0x1F3FC), 0, 2), emptyList<String>(), 51, 36, true),
        TwitterEmoji(String(intArrayOf(0x1F9D8, 0x1F3FD), 0, 2), emptyList<String>(), 51, 37, true),
        TwitterEmoji(String(intArrayOf(0x1F9D8, 0x1F3FE), 0, 2), emptyList<String>(), 51, 38, true),
        TwitterEmoji(String(intArrayOf(0x1F9D8, 0x1F3FF), 0, 2), emptyList<String>(), 51, 39, true),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F9D8, 0x200D, 0x2642, 0xFE0F), 0, 4), listOf("man_in_lotus_position"), 51, 28, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F9D8, 0x1F3FB, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 51, 29, false),
        TwitterEmoji(String(intArrayOf(0x1F9D8, 0x1F3FC, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 51, 30, false),
        TwitterEmoji(String(intArrayOf(0x1F9D8, 0x1F3FD, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 51, 31, false),
        TwitterEmoji(String(intArrayOf(0x1F9D8, 0x1F3FE, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 51, 32, false),
        TwitterEmoji(String(intArrayOf(0x1F9D8, 0x1F3FF, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 51, 33, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F9D8, 0x200D, 0x2640, 0xFE0F), 0, 4), listOf("woman_in_lotus_position"), 51, 22, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F9D8, 0x1F3FB, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 51, 23, false),
        TwitterEmoji(String(intArrayOf(0x1F9D8, 0x1F3FC, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 51, 24, false),
        TwitterEmoji(String(intArrayOf(0x1F9D8, 0x1F3FD, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 51, 25, false),
        TwitterEmoji(String(intArrayOf(0x1F9D8, 0x1F3FE, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 51, 26, false),
        TwitterEmoji(String(intArrayOf(0x1F9D8, 0x1F3FF, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 51, 27, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F6C0), 0, 1), listOf("bath"), 37, 42, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F6C0, 0x1F3FB), 0, 2), emptyList<String>(), 37, 43, false),
        TwitterEmoji(String(intArrayOf(0x1F6C0, 0x1F3FC), 0, 2), emptyList<String>(), 37, 44, false),
        TwitterEmoji(String(intArrayOf(0x1F6C0, 0x1F3FD), 0, 2), emptyList<String>(), 37, 45, false),
        TwitterEmoji(String(intArrayOf(0x1F6C0, 0x1F3FE), 0, 2), emptyList<String>(), 37, 46, false),
        TwitterEmoji(String(intArrayOf(0x1F6C0, 0x1F3FF), 0, 2), emptyList<String>(), 37, 47, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F6CC), 0, 1), listOf("sleeping_accommodation"), 37, 54, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F6CC, 0x1F3FB), 0, 2), emptyList<String>(), 37, 55, false),
        TwitterEmoji(String(intArrayOf(0x1F6CC, 0x1F3FC), 0, 2), emptyList<String>(), 37, 56, false),
        TwitterEmoji(String(intArrayOf(0x1F6CC, 0x1F3FD), 0, 2), emptyList<String>(), 37, 57, false),
        TwitterEmoji(String(intArrayOf(0x1F6CC, 0x1F3FE), 0, 2), emptyList<String>(), 37, 58, false),
        TwitterEmoji(String(intArrayOf(0x1F6CC, 0x1F3FF), 0, 2), emptyList<String>(), 37, 59, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F9D1, 0x200D, 0x1F91D, 0x200D, 0x1F9D1), 0, 5), listOf("people_holding_hands"), 48, 41, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F9D1, 0x1F3FB, 0x200D, 0x1F91D, 0x200D, 0x1F9D1, 0x1F3FB), 0, 7), emptyList<String>(), 48, 42, false),
        TwitterEmoji(String(intArrayOf(0x1F9D1, 0x1F3FB, 0x200D, 0x1F91D, 0x200D, 0x1F9D1, 0x1F3FC), 0, 7), emptyList<String>(), 48, 43, false),
        TwitterEmoji(String(intArrayOf(0x1F9D1, 0x1F3FB, 0x200D, 0x1F91D, 0x200D, 0x1F9D1, 0x1F3FD), 0, 7), emptyList<String>(), 48, 44, false),
        TwitterEmoji(String(intArrayOf(0x1F9D1, 0x1F3FB, 0x200D, 0x1F91D, 0x200D, 0x1F9D1, 0x1F3FE), 0, 7), emptyList<String>(), 48, 45, false),
        TwitterEmoji(String(intArrayOf(0x1F9D1, 0x1F3FB, 0x200D, 0x1F91D, 0x200D, 0x1F9D1, 0x1F3FF), 0, 7), emptyList<String>(), 48, 46, false),
        TwitterEmoji(String(intArrayOf(0x1F9D1, 0x1F3FC, 0x200D, 0x1F91D, 0x200D, 0x1F9D1, 0x1F3FB), 0, 7), emptyList<String>(), 48, 47, false),
        TwitterEmoji(String(intArrayOf(0x1F9D1, 0x1F3FC, 0x200D, 0x1F91D, 0x200D, 0x1F9D1, 0x1F3FC), 0, 7), emptyList<String>(), 48, 48, false),
        TwitterEmoji(String(intArrayOf(0x1F9D1, 0x1F3FC, 0x200D, 0x1F91D, 0x200D, 0x1F9D1, 0x1F3FD), 0, 7), emptyList<String>(), 48, 49, false),
        TwitterEmoji(String(intArrayOf(0x1F9D1, 0x1F3FC, 0x200D, 0x1F91D, 0x200D, 0x1F9D1, 0x1F3FE), 0, 7), emptyList<String>(), 48, 50, false),
        TwitterEmoji(String(intArrayOf(0x1F9D1, 0x1F3FC, 0x200D, 0x1F91D, 0x200D, 0x1F9D1, 0x1F3FF), 0, 7), emptyList<String>(), 48, 51, false),
        TwitterEmoji(String(intArrayOf(0x1F9D1, 0x1F3FD, 0x200D, 0x1F91D, 0x200D, 0x1F9D1, 0x1F3FB), 0, 7), emptyList<String>(), 48, 52, false),
        TwitterEmoji(String(intArrayOf(0x1F9D1, 0x1F3FD, 0x200D, 0x1F91D, 0x200D, 0x1F9D1, 0x1F3FC), 0, 7), emptyList<String>(), 48, 53, false),
        TwitterEmoji(String(intArrayOf(0x1F9D1, 0x1F3FD, 0x200D, 0x1F91D, 0x200D, 0x1F9D1, 0x1F3FD), 0, 7), emptyList<String>(), 48, 54, false),
        TwitterEmoji(String(intArrayOf(0x1F9D1, 0x1F3FD, 0x200D, 0x1F91D, 0x200D, 0x1F9D1, 0x1F3FE), 0, 7), emptyList<String>(), 48, 55, false),
        TwitterEmoji(String(intArrayOf(0x1F9D1, 0x1F3FD, 0x200D, 0x1F91D, 0x200D, 0x1F9D1, 0x1F3FF), 0, 7), emptyList<String>(), 48, 56, false),
        TwitterEmoji(String(intArrayOf(0x1F9D1, 0x1F3FE, 0x200D, 0x1F91D, 0x200D, 0x1F9D1, 0x1F3FB), 0, 7), emptyList<String>(), 48, 57, false),
        TwitterEmoji(String(intArrayOf(0x1F9D1, 0x1F3FE, 0x200D, 0x1F91D, 0x200D, 0x1F9D1, 0x1F3FC), 0, 7), emptyList<String>(), 48, 58, false),
        TwitterEmoji(String(intArrayOf(0x1F9D1, 0x1F3FE, 0x200D, 0x1F91D, 0x200D, 0x1F9D1, 0x1F3FD), 0, 7), emptyList<String>(), 48, 59, false),
        TwitterEmoji(String(intArrayOf(0x1F9D1, 0x1F3FE, 0x200D, 0x1F91D, 0x200D, 0x1F9D1, 0x1F3FE), 0, 7), emptyList<String>(), 48, 60, false),
        TwitterEmoji(String(intArrayOf(0x1F9D1, 0x1F3FE, 0x200D, 0x1F91D, 0x200D, 0x1F9D1, 0x1F3FF), 0, 7), emptyList<String>(), 49, 0, false),
        TwitterEmoji(String(intArrayOf(0x1F9D1, 0x1F3FF, 0x200D, 0x1F91D, 0x200D, 0x1F9D1, 0x1F3FB), 0, 7), emptyList<String>(), 49, 1, false),
        TwitterEmoji(String(intArrayOf(0x1F9D1, 0x1F3FF, 0x200D, 0x1F91D, 0x200D, 0x1F9D1, 0x1F3FC), 0, 7), emptyList<String>(), 49, 2, false),
        TwitterEmoji(String(intArrayOf(0x1F9D1, 0x1F3FF, 0x200D, 0x1F91D, 0x200D, 0x1F9D1, 0x1F3FD), 0, 7), emptyList<String>(), 49, 3, false),
        TwitterEmoji(String(intArrayOf(0x1F9D1, 0x1F3FF, 0x200D, 0x1F91D, 0x200D, 0x1F9D1, 0x1F3FE), 0, 7), emptyList<String>(), 49, 4, false),
        TwitterEmoji(String(intArrayOf(0x1F9D1, 0x1F3FF, 0x200D, 0x1F91D, 0x200D, 0x1F9D1, 0x1F3FF), 0, 7), emptyList<String>(), 49, 5, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F46D), 0, 1), listOf("two_women_holding_hands", "women_holding_hands"), 22, 31, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F46D, 0x1F3FB), 0, 2), emptyList<String>(), 22, 32, false),
        TwitterEmoji(String(intArrayOf(0x1F46D, 0x1F3FC), 0, 2), emptyList<String>(), 22, 33, false),
        TwitterEmoji(String(intArrayOf(0x1F46D, 0x1F3FD), 0, 2), emptyList<String>(), 22, 34, false),
        TwitterEmoji(String(intArrayOf(0x1F46D, 0x1F3FE), 0, 2), emptyList<String>(), 22, 35, false),
        TwitterEmoji(String(intArrayOf(0x1F46D, 0x1F3FF), 0, 2), emptyList<String>(), 22, 36, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FB, 0x200D, 0x1F91D, 0x200D, 0x1F469, 0x1F3FC), 0, 7), emptyList<String>(), 22, 37, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FB, 0x200D, 0x1F91D, 0x200D, 0x1F469, 0x1F3FD), 0, 7), emptyList<String>(), 22, 38, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FB, 0x200D, 0x1F91D, 0x200D, 0x1F469, 0x1F3FE), 0, 7), emptyList<String>(), 22, 39, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FB, 0x200D, 0x1F91D, 0x200D, 0x1F469, 0x1F3FF), 0, 7), emptyList<String>(), 22, 40, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FC, 0x200D, 0x1F91D, 0x200D, 0x1F469, 0x1F3FB), 0, 7), emptyList<String>(), 22, 41, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FC, 0x200D, 0x1F91D, 0x200D, 0x1F469, 0x1F3FD), 0, 7), emptyList<String>(), 22, 42, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FC, 0x200D, 0x1F91D, 0x200D, 0x1F469, 0x1F3FE), 0, 7), emptyList<String>(), 22, 43, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FC, 0x200D, 0x1F91D, 0x200D, 0x1F469, 0x1F3FF), 0, 7), emptyList<String>(), 22, 44, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FD, 0x200D, 0x1F91D, 0x200D, 0x1F469, 0x1F3FB), 0, 7), emptyList<String>(), 22, 45, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FD, 0x200D, 0x1F91D, 0x200D, 0x1F469, 0x1F3FC), 0, 7), emptyList<String>(), 22, 46, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FD, 0x200D, 0x1F91D, 0x200D, 0x1F469, 0x1F3FE), 0, 7), emptyList<String>(), 22, 47, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FD, 0x200D, 0x1F91D, 0x200D, 0x1F469, 0x1F3FF), 0, 7), emptyList<String>(), 22, 48, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FE, 0x200D, 0x1F91D, 0x200D, 0x1F469, 0x1F3FB), 0, 7), emptyList<String>(), 22, 49, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FE, 0x200D, 0x1F91D, 0x200D, 0x1F469, 0x1F3FC), 0, 7), emptyList<String>(), 22, 50, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FE, 0x200D, 0x1F91D, 0x200D, 0x1F469, 0x1F3FD), 0, 7), emptyList<String>(), 22, 51, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FE, 0x200D, 0x1F91D, 0x200D, 0x1F469, 0x1F3FF), 0, 7), emptyList<String>(), 22, 52, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FF, 0x200D, 0x1F91D, 0x200D, 0x1F469, 0x1F3FB), 0, 7), emptyList<String>(), 22, 53, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FF, 0x200D, 0x1F91D, 0x200D, 0x1F469, 0x1F3FC), 0, 7), emptyList<String>(), 22, 54, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FF, 0x200D, 0x1F91D, 0x200D, 0x1F469, 0x1F3FD), 0, 7), emptyList<String>(), 22, 55, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FF, 0x200D, 0x1F91D, 0x200D, 0x1F469, 0x1F3FE), 0, 7), emptyList<String>(), 22, 56, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F46B), 0, 1), listOf("man_and_woman_holding_hands", "woman_and_man_holding_hands", "couple"), 21, 40, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F46B, 0x1F3FB), 0, 2), emptyList<String>(), 21, 41, false),
        TwitterEmoji(String(intArrayOf(0x1F46B, 0x1F3FC), 0, 2), emptyList<String>(), 21, 42, false),
        TwitterEmoji(String(intArrayOf(0x1F46B, 0x1F3FD), 0, 2), emptyList<String>(), 21, 43, false),
        TwitterEmoji(String(intArrayOf(0x1F46B, 0x1F3FE), 0, 2), emptyList<String>(), 21, 44, false),
        TwitterEmoji(String(intArrayOf(0x1F46B, 0x1F3FF), 0, 2), emptyList<String>(), 21, 45, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FB, 0x200D, 0x1F91D, 0x200D, 0x1F468, 0x1F3FC), 0, 7), emptyList<String>(), 21, 46, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FB, 0x200D, 0x1F91D, 0x200D, 0x1F468, 0x1F3FD), 0, 7), emptyList<String>(), 21, 47, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FB, 0x200D, 0x1F91D, 0x200D, 0x1F468, 0x1F3FE), 0, 7), emptyList<String>(), 21, 48, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FB, 0x200D, 0x1F91D, 0x200D, 0x1F468, 0x1F3FF), 0, 7), emptyList<String>(), 21, 49, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FC, 0x200D, 0x1F91D, 0x200D, 0x1F468, 0x1F3FB), 0, 7), emptyList<String>(), 21, 50, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FC, 0x200D, 0x1F91D, 0x200D, 0x1F468, 0x1F3FD), 0, 7), emptyList<String>(), 21, 51, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FC, 0x200D, 0x1F91D, 0x200D, 0x1F468, 0x1F3FE), 0, 7), emptyList<String>(), 21, 52, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FC, 0x200D, 0x1F91D, 0x200D, 0x1F468, 0x1F3FF), 0, 7), emptyList<String>(), 21, 53, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FD, 0x200D, 0x1F91D, 0x200D, 0x1F468, 0x1F3FB), 0, 7), emptyList<String>(), 21, 54, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FD, 0x200D, 0x1F91D, 0x200D, 0x1F468, 0x1F3FC), 0, 7), emptyList<String>(), 21, 55, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FD, 0x200D, 0x1F91D, 0x200D, 0x1F468, 0x1F3FE), 0, 7), emptyList<String>(), 21, 56, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FD, 0x200D, 0x1F91D, 0x200D, 0x1F468, 0x1F3FF), 0, 7), emptyList<String>(), 21, 57, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FE, 0x200D, 0x1F91D, 0x200D, 0x1F468, 0x1F3FB), 0, 7), emptyList<String>(), 21, 58, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FE, 0x200D, 0x1F91D, 0x200D, 0x1F468, 0x1F3FC), 0, 7), emptyList<String>(), 21, 59, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FE, 0x200D, 0x1F91D, 0x200D, 0x1F468, 0x1F3FD), 0, 7), emptyList<String>(), 21, 60, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FE, 0x200D, 0x1F91D, 0x200D, 0x1F468, 0x1F3FF), 0, 7), emptyList<String>(), 22, 0, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FF, 0x200D, 0x1F91D, 0x200D, 0x1F468, 0x1F3FB), 0, 7), emptyList<String>(), 22, 1, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FF, 0x200D, 0x1F91D, 0x200D, 0x1F468, 0x1F3FC), 0, 7), emptyList<String>(), 22, 2, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FF, 0x200D, 0x1F91D, 0x200D, 0x1F468, 0x1F3FD), 0, 7), emptyList<String>(), 22, 3, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FF, 0x200D, 0x1F91D, 0x200D, 0x1F468, 0x1F3FE), 0, 7), emptyList<String>(), 22, 4, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F46C), 0, 1), listOf("two_men_holding_hands", "men_holding_hands"), 22, 5, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F46C, 0x1F3FB), 0, 2), emptyList<String>(), 22, 6, false),
        TwitterEmoji(String(intArrayOf(0x1F46C, 0x1F3FC), 0, 2), emptyList<String>(), 22, 7, false),
        TwitterEmoji(String(intArrayOf(0x1F46C, 0x1F3FD), 0, 2), emptyList<String>(), 22, 8, false),
        TwitterEmoji(String(intArrayOf(0x1F46C, 0x1F3FE), 0, 2), emptyList<String>(), 22, 9, false),
        TwitterEmoji(String(intArrayOf(0x1F46C, 0x1F3FF), 0, 2), emptyList<String>(), 22, 10, false),
        TwitterEmoji(String(intArrayOf(0x1F468, 0x1F3FB, 0x200D, 0x1F91D, 0x200D, 0x1F468, 0x1F3FC), 0, 7), emptyList<String>(), 22, 11, false),
        TwitterEmoji(String(intArrayOf(0x1F468, 0x1F3FB, 0x200D, 0x1F91D, 0x200D, 0x1F468, 0x1F3FD), 0, 7), emptyList<String>(), 22, 12, false),
        TwitterEmoji(String(intArrayOf(0x1F468, 0x1F3FB, 0x200D, 0x1F91D, 0x200D, 0x1F468, 0x1F3FE), 0, 7), emptyList<String>(), 22, 13, false),
        TwitterEmoji(String(intArrayOf(0x1F468, 0x1F3FB, 0x200D, 0x1F91D, 0x200D, 0x1F468, 0x1F3FF), 0, 7), emptyList<String>(), 22, 14, false),
        TwitterEmoji(String(intArrayOf(0x1F468, 0x1F3FC, 0x200D, 0x1F91D, 0x200D, 0x1F468, 0x1F3FB), 0, 7), emptyList<String>(), 22, 15, false),
        TwitterEmoji(String(intArrayOf(0x1F468, 0x1F3FC, 0x200D, 0x1F91D, 0x200D, 0x1F468, 0x1F3FD), 0, 7), emptyList<String>(), 22, 16, false),
        TwitterEmoji(String(intArrayOf(0x1F468, 0x1F3FC, 0x200D, 0x1F91D, 0x200D, 0x1F468, 0x1F3FE), 0, 7), emptyList<String>(), 22, 17, false),
        TwitterEmoji(String(intArrayOf(0x1F468, 0x1F3FC, 0x200D, 0x1F91D, 0x200D, 0x1F468, 0x1F3FF), 0, 7), emptyList<String>(), 22, 18, false),
        TwitterEmoji(String(intArrayOf(0x1F468, 0x1F3FD, 0x200D, 0x1F91D, 0x200D, 0x1F468, 0x1F3FB), 0, 7), emptyList<String>(), 22, 19, false),
        TwitterEmoji(String(intArrayOf(0x1F468, 0x1F3FD, 0x200D, 0x1F91D, 0x200D, 0x1F468, 0x1F3FC), 0, 7), emptyList<String>(), 22, 20, false),
        TwitterEmoji(String(intArrayOf(0x1F468, 0x1F3FD, 0x200D, 0x1F91D, 0x200D, 0x1F468, 0x1F3FE), 0, 7), emptyList<String>(), 22, 21, false),
        TwitterEmoji(String(intArrayOf(0x1F468, 0x1F3FD, 0x200D, 0x1F91D, 0x200D, 0x1F468, 0x1F3FF), 0, 7), emptyList<String>(), 22, 22, false),
        TwitterEmoji(String(intArrayOf(0x1F468, 0x1F3FE, 0x200D, 0x1F91D, 0x200D, 0x1F468, 0x1F3FB), 0, 7), emptyList<String>(), 22, 23, false),
        TwitterEmoji(String(intArrayOf(0x1F468, 0x1F3FE, 0x200D, 0x1F91D, 0x200D, 0x1F468, 0x1F3FC), 0, 7), emptyList<String>(), 22, 24, false),
        TwitterEmoji(String(intArrayOf(0x1F468, 0x1F3FE, 0x200D, 0x1F91D, 0x200D, 0x1F468, 0x1F3FD), 0, 7), emptyList<String>(), 22, 25, false),
        TwitterEmoji(String(intArrayOf(0x1F468, 0x1F3FE, 0x200D, 0x1F91D, 0x200D, 0x1F468, 0x1F3FF), 0, 7), emptyList<String>(), 22, 26, false),
        TwitterEmoji(String(intArrayOf(0x1F468, 0x1F3FF, 0x200D, 0x1F91D, 0x200D, 0x1F468, 0x1F3FB), 0, 7), emptyList<String>(), 22, 27, false),
        TwitterEmoji(String(intArrayOf(0x1F468, 0x1F3FF, 0x200D, 0x1F91D, 0x200D, 0x1F468, 0x1F3FC), 0, 7), emptyList<String>(), 22, 28, false),
        TwitterEmoji(String(intArrayOf(0x1F468, 0x1F3FF, 0x200D, 0x1F91D, 0x200D, 0x1F468, 0x1F3FD), 0, 7), emptyList<String>(), 22, 29, false),
        TwitterEmoji(String(intArrayOf(0x1F468, 0x1F3FF, 0x200D, 0x1F91D, 0x200D, 0x1F468, 0x1F3FE), 0, 7), emptyList<String>(), 22, 30, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F48F), 0, 1), listOf("couplekiss"), 26, 41, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F48F, 0x1F3FB), 0, 2), emptyList<String>(), 26, 42, false),
        TwitterEmoji(String(intArrayOf(0x1F48F, 0x1F3FC), 0, 2), emptyList<String>(), 26, 43, false),
        TwitterEmoji(String(intArrayOf(0x1F48F, 0x1F3FD), 0, 2), emptyList<String>(), 26, 44, false),
        TwitterEmoji(String(intArrayOf(0x1F48F, 0x1F3FE), 0, 2), emptyList<String>(), 26, 45, false),
        TwitterEmoji(String(intArrayOf(0x1F48F, 0x1F3FF), 0, 2), emptyList<String>(), 26, 46, false),
        TwitterEmoji(String(intArrayOf(0x1F9D1, 0x1F3FB, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F9D1, 0x1F3FC), 0, 10), emptyList<String>(), 26, 47, false),
        TwitterEmoji(String(intArrayOf(0x1F9D1, 0x1F3FB, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F9D1, 0x1F3FD), 0, 10), emptyList<String>(), 26, 48, false),
        TwitterEmoji(String(intArrayOf(0x1F9D1, 0x1F3FB, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F9D1, 0x1F3FE), 0, 10), emptyList<String>(), 26, 49, false),
        TwitterEmoji(String(intArrayOf(0x1F9D1, 0x1F3FB, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F9D1, 0x1F3FF), 0, 10), emptyList<String>(), 26, 50, false),
        TwitterEmoji(String(intArrayOf(0x1F9D1, 0x1F3FC, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F9D1, 0x1F3FB), 0, 10), emptyList<String>(), 26, 51, false),
        TwitterEmoji(String(intArrayOf(0x1F9D1, 0x1F3FC, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F9D1, 0x1F3FD), 0, 10), emptyList<String>(), 26, 52, false),
        TwitterEmoji(String(intArrayOf(0x1F9D1, 0x1F3FC, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F9D1, 0x1F3FE), 0, 10), emptyList<String>(), 26, 53, false),
        TwitterEmoji(String(intArrayOf(0x1F9D1, 0x1F3FC, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F9D1, 0x1F3FF), 0, 10), emptyList<String>(), 26, 54, false),
        TwitterEmoji(String(intArrayOf(0x1F9D1, 0x1F3FD, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F9D1, 0x1F3FB), 0, 10), emptyList<String>(), 26, 55, false),
        TwitterEmoji(String(intArrayOf(0x1F9D1, 0x1F3FD, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F9D1, 0x1F3FC), 0, 10), emptyList<String>(), 26, 56, false),
        TwitterEmoji(String(intArrayOf(0x1F9D1, 0x1F3FD, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F9D1, 0x1F3FE), 0, 10), emptyList<String>(), 26, 57, false),
        TwitterEmoji(String(intArrayOf(0x1F9D1, 0x1F3FD, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F9D1, 0x1F3FF), 0, 10), emptyList<String>(), 26, 58, false),
        TwitterEmoji(String(intArrayOf(0x1F9D1, 0x1F3FE, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F9D1, 0x1F3FB), 0, 10), emptyList<String>(), 26, 59, false),
        TwitterEmoji(String(intArrayOf(0x1F9D1, 0x1F3FE, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F9D1, 0x1F3FC), 0, 10), emptyList<String>(), 26, 60, false),
        TwitterEmoji(String(intArrayOf(0x1F9D1, 0x1F3FE, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F9D1, 0x1F3FD), 0, 10), emptyList<String>(), 27, 0, false),
        TwitterEmoji(String(intArrayOf(0x1F9D1, 0x1F3FE, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F9D1, 0x1F3FF), 0, 10), emptyList<String>(), 27, 1, false),
        TwitterEmoji(String(intArrayOf(0x1F9D1, 0x1F3FF, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F9D1, 0x1F3FB), 0, 10), emptyList<String>(), 27, 2, false),
        TwitterEmoji(String(intArrayOf(0x1F9D1, 0x1F3FF, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F9D1, 0x1F3FC), 0, 10), emptyList<String>(), 27, 3, false),
        TwitterEmoji(String(intArrayOf(0x1F9D1, 0x1F3FF, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F9D1, 0x1F3FD), 0, 10), emptyList<String>(), 27, 4, false),
        TwitterEmoji(String(intArrayOf(0x1F9D1, 0x1F3FF, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F9D1, 0x1F3FE), 0, 10), emptyList<String>(), 27, 5, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F469, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F468), 0, 8), listOf("woman-kiss-man"), 20, 42, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FB, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F468, 0x1F3FB), 0, 10), emptyList<String>(), 20, 43, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FB, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F468, 0x1F3FC), 0, 10), emptyList<String>(), 20, 44, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FB, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F468, 0x1F3FD), 0, 10), emptyList<String>(), 20, 45, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FB, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F468, 0x1F3FE), 0, 10), emptyList<String>(), 20, 46, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FB, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F468, 0x1F3FF), 0, 10), emptyList<String>(), 20, 47, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FC, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F468, 0x1F3FB), 0, 10), emptyList<String>(), 20, 48, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FC, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F468, 0x1F3FC), 0, 10), emptyList<String>(), 20, 49, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FC, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F468, 0x1F3FD), 0, 10), emptyList<String>(), 20, 50, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FC, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F468, 0x1F3FE), 0, 10), emptyList<String>(), 20, 51, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FC, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F468, 0x1F3FF), 0, 10), emptyList<String>(), 20, 52, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FD, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F468, 0x1F3FB), 0, 10), emptyList<String>(), 20, 53, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FD, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F468, 0x1F3FC), 0, 10), emptyList<String>(), 20, 54, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FD, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F468, 0x1F3FD), 0, 10), emptyList<String>(), 20, 55, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FD, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F468, 0x1F3FE), 0, 10), emptyList<String>(), 20, 56, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FD, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F468, 0x1F3FF), 0, 10), emptyList<String>(), 20, 57, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FE, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F468, 0x1F3FB), 0, 10), emptyList<String>(), 20, 58, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FE, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F468, 0x1F3FC), 0, 10), emptyList<String>(), 20, 59, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FE, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F468, 0x1F3FD), 0, 10), emptyList<String>(), 20, 60, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FE, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F468, 0x1F3FE), 0, 10), emptyList<String>(), 21, 0, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FE, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F468, 0x1F3FF), 0, 10), emptyList<String>(), 21, 1, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FF, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F468, 0x1F3FB), 0, 10), emptyList<String>(), 21, 2, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FF, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F468, 0x1F3FC), 0, 10), emptyList<String>(), 21, 3, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FF, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F468, 0x1F3FD), 0, 10), emptyList<String>(), 21, 4, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FF, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F468, 0x1F3FE), 0, 10), emptyList<String>(), 21, 5, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FF, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F468, 0x1F3FF), 0, 10), emptyList<String>(), 21, 6, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F468, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F468), 0, 8), listOf("man-kiss-man"), 16, 48, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F468, 0x1F3FB, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F468, 0x1F3FB), 0, 10), emptyList<String>(), 16, 49, false),
        TwitterEmoji(String(intArrayOf(0x1F468, 0x1F3FB, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F468, 0x1F3FC), 0, 10), emptyList<String>(), 16, 50, false),
        TwitterEmoji(String(intArrayOf(0x1F468, 0x1F3FB, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F468, 0x1F3FD), 0, 10), emptyList<String>(), 16, 51, false),
        TwitterEmoji(String(intArrayOf(0x1F468, 0x1F3FB, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F468, 0x1F3FE), 0, 10), emptyList<String>(), 16, 52, false),
        TwitterEmoji(String(intArrayOf(0x1F468, 0x1F3FB, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F468, 0x1F3FF), 0, 10), emptyList<String>(), 16, 53, false),
        TwitterEmoji(String(intArrayOf(0x1F468, 0x1F3FC, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F468, 0x1F3FB), 0, 10), emptyList<String>(), 16, 54, false),
        TwitterEmoji(String(intArrayOf(0x1F468, 0x1F3FC, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F468, 0x1F3FC), 0, 10), emptyList<String>(), 16, 55, false),
        TwitterEmoji(String(intArrayOf(0x1F468, 0x1F3FC, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F468, 0x1F3FD), 0, 10), emptyList<String>(), 16, 56, false),
        TwitterEmoji(String(intArrayOf(0x1F468, 0x1F3FC, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F468, 0x1F3FE), 0, 10), emptyList<String>(), 16, 57, false),
        TwitterEmoji(String(intArrayOf(0x1F468, 0x1F3FC, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F468, 0x1F3FF), 0, 10), emptyList<String>(), 16, 58, false),
        TwitterEmoji(String(intArrayOf(0x1F468, 0x1F3FD, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F468, 0x1F3FB), 0, 10), emptyList<String>(), 16, 59, false),
        TwitterEmoji(String(intArrayOf(0x1F468, 0x1F3FD, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F468, 0x1F3FC), 0, 10), emptyList<String>(), 16, 60, false),
        TwitterEmoji(String(intArrayOf(0x1F468, 0x1F3FD, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F468, 0x1F3FD), 0, 10), emptyList<String>(), 17, 0, false),
        TwitterEmoji(String(intArrayOf(0x1F468, 0x1F3FD, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F468, 0x1F3FE), 0, 10), emptyList<String>(), 17, 1, false),
        TwitterEmoji(String(intArrayOf(0x1F468, 0x1F3FD, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F468, 0x1F3FF), 0, 10), emptyList<String>(), 17, 2, false),
        TwitterEmoji(String(intArrayOf(0x1F468, 0x1F3FE, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F468, 0x1F3FB), 0, 10), emptyList<String>(), 17, 3, false),
        TwitterEmoji(String(intArrayOf(0x1F468, 0x1F3FE, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F468, 0x1F3FC), 0, 10), emptyList<String>(), 17, 4, false),
        TwitterEmoji(String(intArrayOf(0x1F468, 0x1F3FE, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F468, 0x1F3FD), 0, 10), emptyList<String>(), 17, 5, false),
        TwitterEmoji(String(intArrayOf(0x1F468, 0x1F3FE, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F468, 0x1F3FE), 0, 10), emptyList<String>(), 17, 6, false),
        TwitterEmoji(String(intArrayOf(0x1F468, 0x1F3FE, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F468, 0x1F3FF), 0, 10), emptyList<String>(), 17, 7, false),
        TwitterEmoji(String(intArrayOf(0x1F468, 0x1F3FF, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F468, 0x1F3FB), 0, 10), emptyList<String>(), 17, 8, false),
        TwitterEmoji(String(intArrayOf(0x1F468, 0x1F3FF, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F468, 0x1F3FC), 0, 10), emptyList<String>(), 17, 9, false),
        TwitterEmoji(String(intArrayOf(0x1F468, 0x1F3FF, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F468, 0x1F3FD), 0, 10), emptyList<String>(), 17, 10, false),
        TwitterEmoji(String(intArrayOf(0x1F468, 0x1F3FF, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F468, 0x1F3FE), 0, 10), emptyList<String>(), 17, 11, false),
        TwitterEmoji(String(intArrayOf(0x1F468, 0x1F3FF, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F468, 0x1F3FF), 0, 10), emptyList<String>(), 17, 12, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F469, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F469), 0, 8), listOf("woman-kiss-woman"), 21, 7, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FB, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F469, 0x1F3FB), 0, 10), emptyList<String>(), 21, 8, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FB, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F469, 0x1F3FC), 0, 10), emptyList<String>(), 21, 9, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FB, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F469, 0x1F3FD), 0, 10), emptyList<String>(), 21, 10, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FB, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F469, 0x1F3FE), 0, 10), emptyList<String>(), 21, 11, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FB, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F469, 0x1F3FF), 0, 10), emptyList<String>(), 21, 12, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FC, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F469, 0x1F3FB), 0, 10), emptyList<String>(), 21, 13, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FC, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F469, 0x1F3FC), 0, 10), emptyList<String>(), 21, 14, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FC, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F469, 0x1F3FD), 0, 10), emptyList<String>(), 21, 15, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FC, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F469, 0x1F3FE), 0, 10), emptyList<String>(), 21, 16, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FC, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F469, 0x1F3FF), 0, 10), emptyList<String>(), 21, 17, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FD, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F469, 0x1F3FB), 0, 10), emptyList<String>(), 21, 18, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FD, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F469, 0x1F3FC), 0, 10), emptyList<String>(), 21, 19, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FD, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F469, 0x1F3FD), 0, 10), emptyList<String>(), 21, 20, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FD, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F469, 0x1F3FE), 0, 10), emptyList<String>(), 21, 21, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FD, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F469, 0x1F3FF), 0, 10), emptyList<String>(), 21, 22, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FE, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F469, 0x1F3FB), 0, 10), emptyList<String>(), 21, 23, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FE, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F469, 0x1F3FC), 0, 10), emptyList<String>(), 21, 24, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FE, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F469, 0x1F3FD), 0, 10), emptyList<String>(), 21, 25, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FE, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F469, 0x1F3FE), 0, 10), emptyList<String>(), 21, 26, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FE, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F469, 0x1F3FF), 0, 10), emptyList<String>(), 21, 27, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FF, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F469, 0x1F3FB), 0, 10), emptyList<String>(), 21, 28, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FF, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F469, 0x1F3FC), 0, 10), emptyList<String>(), 21, 29, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FF, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F469, 0x1F3FD), 0, 10), emptyList<String>(), 21, 30, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FF, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F469, 0x1F3FE), 0, 10), emptyList<String>(), 21, 31, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FF, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F469, 0x1F3FF), 0, 10), emptyList<String>(), 21, 32, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F491), 0, 1), listOf("couple_with_heart"), 27, 7, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F491, 0x1F3FB), 0, 2), emptyList<String>(), 27, 8, false),
        TwitterEmoji(String(intArrayOf(0x1F491, 0x1F3FC), 0, 2), emptyList<String>(), 27, 9, false),
        TwitterEmoji(String(intArrayOf(0x1F491, 0x1F3FD), 0, 2), emptyList<String>(), 27, 10, false),
        TwitterEmoji(String(intArrayOf(0x1F491, 0x1F3FE), 0, 2), emptyList<String>(), 27, 11, false),
        TwitterEmoji(String(intArrayOf(0x1F491, 0x1F3FF), 0, 2), emptyList<String>(), 27, 12, false),
        TwitterEmoji(String(intArrayOf(0x1F9D1, 0x1F3FB, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F9D1, 0x1F3FC), 0, 8), emptyList<String>(), 27, 13, false),
        TwitterEmoji(String(intArrayOf(0x1F9D1, 0x1F3FB, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F9D1, 0x1F3FD), 0, 8), emptyList<String>(), 27, 14, false),
        TwitterEmoji(String(intArrayOf(0x1F9D1, 0x1F3FB, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F9D1, 0x1F3FE), 0, 8), emptyList<String>(), 27, 15, false),
        TwitterEmoji(String(intArrayOf(0x1F9D1, 0x1F3FB, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F9D1, 0x1F3FF), 0, 8), emptyList<String>(), 27, 16, false),
        TwitterEmoji(String(intArrayOf(0x1F9D1, 0x1F3FC, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F9D1, 0x1F3FB), 0, 8), emptyList<String>(), 27, 17, false),
        TwitterEmoji(String(intArrayOf(0x1F9D1, 0x1F3FC, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F9D1, 0x1F3FD), 0, 8), emptyList<String>(), 27, 18, false),
        TwitterEmoji(String(intArrayOf(0x1F9D1, 0x1F3FC, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F9D1, 0x1F3FE), 0, 8), emptyList<String>(), 27, 19, false),
        TwitterEmoji(String(intArrayOf(0x1F9D1, 0x1F3FC, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F9D1, 0x1F3FF), 0, 8), emptyList<String>(), 27, 20, false),
        TwitterEmoji(String(intArrayOf(0x1F9D1, 0x1F3FD, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F9D1, 0x1F3FB), 0, 8), emptyList<String>(), 27, 21, false),
        TwitterEmoji(String(intArrayOf(0x1F9D1, 0x1F3FD, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F9D1, 0x1F3FC), 0, 8), emptyList<String>(), 27, 22, false),
        TwitterEmoji(String(intArrayOf(0x1F9D1, 0x1F3FD, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F9D1, 0x1F3FE), 0, 8), emptyList<String>(), 27, 23, false),
        TwitterEmoji(String(intArrayOf(0x1F9D1, 0x1F3FD, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F9D1, 0x1F3FF), 0, 8), emptyList<String>(), 27, 24, false),
        TwitterEmoji(String(intArrayOf(0x1F9D1, 0x1F3FE, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F9D1, 0x1F3FB), 0, 8), emptyList<String>(), 27, 25, false),
        TwitterEmoji(String(intArrayOf(0x1F9D1, 0x1F3FE, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F9D1, 0x1F3FC), 0, 8), emptyList<String>(), 27, 26, false),
        TwitterEmoji(String(intArrayOf(0x1F9D1, 0x1F3FE, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F9D1, 0x1F3FD), 0, 8), emptyList<String>(), 27, 27, false),
        TwitterEmoji(String(intArrayOf(0x1F9D1, 0x1F3FE, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F9D1, 0x1F3FF), 0, 8), emptyList<String>(), 27, 28, false),
        TwitterEmoji(String(intArrayOf(0x1F9D1, 0x1F3FF, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F9D1, 0x1F3FB), 0, 8), emptyList<String>(), 27, 29, false),
        TwitterEmoji(String(intArrayOf(0x1F9D1, 0x1F3FF, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F9D1, 0x1F3FC), 0, 8), emptyList<String>(), 27, 30, false),
        TwitterEmoji(String(intArrayOf(0x1F9D1, 0x1F3FF, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F9D1, 0x1F3FD), 0, 8), emptyList<String>(), 27, 31, false),
        TwitterEmoji(String(intArrayOf(0x1F9D1, 0x1F3FF, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F9D1, 0x1F3FE), 0, 8), emptyList<String>(), 27, 32, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F469, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F468), 0, 6), listOf("woman-heart-man"), 19, 51, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FB, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F468, 0x1F3FB), 0, 8), emptyList<String>(), 19, 52, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FB, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F468, 0x1F3FC), 0, 8), emptyList<String>(), 19, 53, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FB, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F468, 0x1F3FD), 0, 8), emptyList<String>(), 19, 54, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FB, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F468, 0x1F3FE), 0, 8), emptyList<String>(), 19, 55, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FB, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F468, 0x1F3FF), 0, 8), emptyList<String>(), 19, 56, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FC, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F468, 0x1F3FB), 0, 8), emptyList<String>(), 19, 57, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FC, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F468, 0x1F3FC), 0, 8), emptyList<String>(), 19, 58, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FC, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F468, 0x1F3FD), 0, 8), emptyList<String>(), 19, 59, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FC, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F468, 0x1F3FE), 0, 8), emptyList<String>(), 19, 60, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FC, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F468, 0x1F3FF), 0, 8), emptyList<String>(), 20, 0, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FD, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F468, 0x1F3FB), 0, 8), emptyList<String>(), 20, 1, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FD, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F468, 0x1F3FC), 0, 8), emptyList<String>(), 20, 2, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FD, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F468, 0x1F3FD), 0, 8), emptyList<String>(), 20, 3, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FD, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F468, 0x1F3FE), 0, 8), emptyList<String>(), 20, 4, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FD, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F468, 0x1F3FF), 0, 8), emptyList<String>(), 20, 5, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FE, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F468, 0x1F3FB), 0, 8), emptyList<String>(), 20, 6, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FE, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F468, 0x1F3FC), 0, 8), emptyList<String>(), 20, 7, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FE, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F468, 0x1F3FD), 0, 8), emptyList<String>(), 20, 8, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FE, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F468, 0x1F3FE), 0, 8), emptyList<String>(), 20, 9, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FE, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F468, 0x1F3FF), 0, 8), emptyList<String>(), 20, 10, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FF, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F468, 0x1F3FB), 0, 8), emptyList<String>(), 20, 11, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FF, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F468, 0x1F3FC), 0, 8), emptyList<String>(), 20, 12, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FF, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F468, 0x1F3FD), 0, 8), emptyList<String>(), 20, 13, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FF, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F468, 0x1F3FE), 0, 8), emptyList<String>(), 20, 14, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FF, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F468, 0x1F3FF), 0, 8), emptyList<String>(), 20, 15, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F468, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F468), 0, 6), listOf("man-heart-man"), 16, 22, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F468, 0x1F3FB, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F468, 0x1F3FB), 0, 8), emptyList<String>(), 16, 23, false),
        TwitterEmoji(String(intArrayOf(0x1F468, 0x1F3FB, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F468, 0x1F3FC), 0, 8), emptyList<String>(), 16, 24, false),
        TwitterEmoji(String(intArrayOf(0x1F468, 0x1F3FB, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F468, 0x1F3FD), 0, 8), emptyList<String>(), 16, 25, false),
        TwitterEmoji(String(intArrayOf(0x1F468, 0x1F3FB, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F468, 0x1F3FE), 0, 8), emptyList<String>(), 16, 26, false),
        TwitterEmoji(String(intArrayOf(0x1F468, 0x1F3FB, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F468, 0x1F3FF), 0, 8), emptyList<String>(), 16, 27, false),
        TwitterEmoji(String(intArrayOf(0x1F468, 0x1F3FC, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F468, 0x1F3FB), 0, 8), emptyList<String>(), 16, 28, false),
        TwitterEmoji(String(intArrayOf(0x1F468, 0x1F3FC, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F468, 0x1F3FC), 0, 8), emptyList<String>(), 16, 29, false),
        TwitterEmoji(String(intArrayOf(0x1F468, 0x1F3FC, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F468, 0x1F3FD), 0, 8), emptyList<String>(), 16, 30, false),
        TwitterEmoji(String(intArrayOf(0x1F468, 0x1F3FC, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F468, 0x1F3FE), 0, 8), emptyList<String>(), 16, 31, false),
        TwitterEmoji(String(intArrayOf(0x1F468, 0x1F3FC, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F468, 0x1F3FF), 0, 8), emptyList<String>(), 16, 32, false),
        TwitterEmoji(String(intArrayOf(0x1F468, 0x1F3FD, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F468, 0x1F3FB), 0, 8), emptyList<String>(), 16, 33, false),
        TwitterEmoji(String(intArrayOf(0x1F468, 0x1F3FD, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F468, 0x1F3FC), 0, 8), emptyList<String>(), 16, 34, false),
        TwitterEmoji(String(intArrayOf(0x1F468, 0x1F3FD, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F468, 0x1F3FD), 0, 8), emptyList<String>(), 16, 35, false),
        TwitterEmoji(String(intArrayOf(0x1F468, 0x1F3FD, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F468, 0x1F3FE), 0, 8), emptyList<String>(), 16, 36, false),
        TwitterEmoji(String(intArrayOf(0x1F468, 0x1F3FD, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F468, 0x1F3FF), 0, 8), emptyList<String>(), 16, 37, false),
        TwitterEmoji(String(intArrayOf(0x1F468, 0x1F3FE, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F468, 0x1F3FB), 0, 8), emptyList<String>(), 16, 38, false),
        TwitterEmoji(String(intArrayOf(0x1F468, 0x1F3FE, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F468, 0x1F3FC), 0, 8), emptyList<String>(), 16, 39, false),
        TwitterEmoji(String(intArrayOf(0x1F468, 0x1F3FE, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F468, 0x1F3FD), 0, 8), emptyList<String>(), 16, 40, false),
        TwitterEmoji(String(intArrayOf(0x1F468, 0x1F3FE, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F468, 0x1F3FE), 0, 8), emptyList<String>(), 16, 41, false),
        TwitterEmoji(String(intArrayOf(0x1F468, 0x1F3FE, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F468, 0x1F3FF), 0, 8), emptyList<String>(), 16, 42, false),
        TwitterEmoji(String(intArrayOf(0x1F468, 0x1F3FF, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F468, 0x1F3FB), 0, 8), emptyList<String>(), 16, 43, false),
        TwitterEmoji(String(intArrayOf(0x1F468, 0x1F3FF, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F468, 0x1F3FC), 0, 8), emptyList<String>(), 16, 44, false),
        TwitterEmoji(String(intArrayOf(0x1F468, 0x1F3FF, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F468, 0x1F3FD), 0, 8), emptyList<String>(), 16, 45, false),
        TwitterEmoji(String(intArrayOf(0x1F468, 0x1F3FF, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F468, 0x1F3FE), 0, 8), emptyList<String>(), 16, 46, false),
        TwitterEmoji(String(intArrayOf(0x1F468, 0x1F3FF, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F468, 0x1F3FF), 0, 8), emptyList<String>(), 16, 47, false),
      )
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F469, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F469), 0, 6), listOf("woman-heart-woman"), 20, 16, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FB, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F469, 0x1F3FB), 0, 8), emptyList<String>(), 20, 17, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FB, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F469, 0x1F3FC), 0, 8), emptyList<String>(), 20, 18, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FB, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F469, 0x1F3FD), 0, 8), emptyList<String>(), 20, 19, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FB, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F469, 0x1F3FE), 0, 8), emptyList<String>(), 20, 20, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FB, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F469, 0x1F3FF), 0, 8), emptyList<String>(), 20, 21, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FC, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F469, 0x1F3FB), 0, 8), emptyList<String>(), 20, 22, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FC, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F469, 0x1F3FC), 0, 8), emptyList<String>(), 20, 23, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FC, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F469, 0x1F3FD), 0, 8), emptyList<String>(), 20, 24, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FC, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F469, 0x1F3FE), 0, 8), emptyList<String>(), 20, 25, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FC, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F469, 0x1F3FF), 0, 8), emptyList<String>(), 20, 26, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FD, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F469, 0x1F3FB), 0, 8), emptyList<String>(), 20, 27, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FD, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F469, 0x1F3FC), 0, 8), emptyList<String>(), 20, 28, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FD, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F469, 0x1F3FD), 0, 8), emptyList<String>(), 20, 29, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FD, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F469, 0x1F3FE), 0, 8), emptyList<String>(), 20, 30, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FD, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F469, 0x1F3FF), 0, 8), emptyList<String>(), 20, 31, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FE, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F469, 0x1F3FB), 0, 8), emptyList<String>(), 20, 32, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FE, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F469, 0x1F3FC), 0, 8), emptyList<String>(), 20, 33, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FE, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F469, 0x1F3FD), 0, 8), emptyList<String>(), 20, 34, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FE, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F469, 0x1F3FE), 0, 8), emptyList<String>(), 20, 35, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FE, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F469, 0x1F3FF), 0, 8), emptyList<String>(), 20, 36, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FF, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F469, 0x1F3FB), 0, 8), emptyList<String>(), 20, 37, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FF, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F469, 0x1F3FC), 0, 8), emptyList<String>(), 20, 38, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FF, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F469, 0x1F3FD), 0, 8), emptyList<String>(), 20, 39, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FF, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F469, 0x1F3FE), 0, 8), emptyList<String>(), 20, 40, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FF, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F469, 0x1F3FF), 0, 8), emptyList<String>(), 20, 41, false),
      )
    ),
    TwitterEmoji(String(intArrayOf(0x1F46A), 0, 1), listOf("family"), 21, 39, true),
    TwitterEmoji(String(intArrayOf(0x1F468, 0x200D, 0x1F469, 0x200D, 0x1F466), 0, 5), listOf("man-woman-boy"), 14, 43, false),
    TwitterEmoji(String(intArrayOf(0x1F468, 0x200D, 0x1F469, 0x200D, 0x1F467), 0, 5), listOf("man-woman-girl"), 14, 45, false),
    TwitterEmoji(String(intArrayOf(0x1F468, 0x200D, 0x1F469, 0x200D, 0x1F467, 0x200D, 0x1F466), 0, 7), listOf("man-woman-girl-boy"), 14, 46, false),
    TwitterEmoji(String(intArrayOf(0x1F468, 0x200D, 0x1F469, 0x200D, 0x1F466, 0x200D, 0x1F466), 0, 7), listOf("man-woman-boy-boy"), 14, 44, false),
    TwitterEmoji(String(intArrayOf(0x1F468, 0x200D, 0x1F469, 0x200D, 0x1F467, 0x200D, 0x1F467), 0, 7), listOf("man-woman-girl-girl"), 14, 47, false),
    TwitterEmoji(String(intArrayOf(0x1F468, 0x200D, 0x1F468, 0x200D, 0x1F466), 0, 5), listOf("man-man-boy"), 14, 38, false),
    TwitterEmoji(String(intArrayOf(0x1F468, 0x200D, 0x1F468, 0x200D, 0x1F467), 0, 5), listOf("man-man-girl"), 14, 40, false),
    TwitterEmoji(String(intArrayOf(0x1F468, 0x200D, 0x1F468, 0x200D, 0x1F467, 0x200D, 0x1F466), 0, 7), listOf("man-man-girl-boy"), 14, 41, false),
    TwitterEmoji(String(intArrayOf(0x1F468, 0x200D, 0x1F468, 0x200D, 0x1F466, 0x200D, 0x1F466), 0, 7), listOf("man-man-boy-boy"), 14, 39, false),
    TwitterEmoji(String(intArrayOf(0x1F468, 0x200D, 0x1F468, 0x200D, 0x1F467, 0x200D, 0x1F467), 0, 7), listOf("man-man-girl-girl"), 14, 42, false),
    TwitterEmoji(String(intArrayOf(0x1F469, 0x200D, 0x1F469, 0x200D, 0x1F466), 0, 5), listOf("woman-woman-boy"), 18, 11, false),
    TwitterEmoji(String(intArrayOf(0x1F469, 0x200D, 0x1F469, 0x200D, 0x1F467), 0, 5), listOf("woman-woman-girl"), 18, 13, false),
    TwitterEmoji(String(intArrayOf(0x1F469, 0x200D, 0x1F469, 0x200D, 0x1F467, 0x200D, 0x1F466), 0, 7), listOf("woman-woman-girl-boy"), 18, 14, false),
    TwitterEmoji(String(intArrayOf(0x1F469, 0x200D, 0x1F469, 0x200D, 0x1F466, 0x200D, 0x1F466), 0, 7), listOf("woman-woman-boy-boy"), 18, 12, false),
    TwitterEmoji(String(intArrayOf(0x1F469, 0x200D, 0x1F469, 0x200D, 0x1F467, 0x200D, 0x1F467), 0, 7), listOf("woman-woman-girl-girl"), 18, 15, false),
    TwitterEmoji(String(intArrayOf(0x1F468, 0x200D, 0x1F466), 0, 3), listOf("man-boy"), 14, 34, false),
    TwitterEmoji(String(intArrayOf(0x1F468, 0x200D, 0x1F466, 0x200D, 0x1F466), 0, 5), listOf("man-boy-boy"), 14, 33, false),
    TwitterEmoji(String(intArrayOf(0x1F468, 0x200D, 0x1F467), 0, 3), listOf("man-girl"), 14, 37, false),
    TwitterEmoji(String(intArrayOf(0x1F468, 0x200D, 0x1F467, 0x200D, 0x1F466), 0, 5), listOf("man-girl-boy"), 14, 35, false),
    TwitterEmoji(String(intArrayOf(0x1F468, 0x200D, 0x1F467, 0x200D, 0x1F467), 0, 5), listOf("man-girl-girl"), 14, 36, false),
    TwitterEmoji(String(intArrayOf(0x1F469, 0x200D, 0x1F466), 0, 3), listOf("woman-boy"), 18, 7, false),
    TwitterEmoji(String(intArrayOf(0x1F469, 0x200D, 0x1F466, 0x200D, 0x1F466), 0, 5), listOf("woman-boy-boy"), 18, 6, false),
    TwitterEmoji(String(intArrayOf(0x1F469, 0x200D, 0x1F467), 0, 3), listOf("woman-girl"), 18, 10, false),
    TwitterEmoji(String(intArrayOf(0x1F469, 0x200D, 0x1F467, 0x200D, 0x1F466), 0, 5), listOf("woman-girl-boy"), 18, 8, false),
    TwitterEmoji(String(intArrayOf(0x1F469, 0x200D, 0x1F467, 0x200D, 0x1F467), 0, 5), listOf("woman-girl-girl"), 18, 9, false),
    TwitterEmoji(String(intArrayOf(0x1F5E3, 0xFE0F), 0, 2), listOf("speaking_head_in_silhouette"), 32, 10, false),
    TwitterEmoji(String(intArrayOf(0x1F464), 0, 1), listOf("bust_in_silhouette"), 13, 32, false),
    TwitterEmoji(String(intArrayOf(0x1F465), 0, 1), listOf("busts_in_silhouette"), 13, 33, false),
    TwitterEmoji(String(intArrayOf(0x1FAC2), 0, 1), listOf("people_hugging"), 54, 44, false),
    TwitterEmoji(String(intArrayOf(0x1F463), 0, 1), listOf("footprints"), 13, 31, false),
  )
}
