/*
 * Decompiled with CFR 0.152.
 */
package com.vanniktech.emoji.twitter;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Point;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.LruCache;
import com.vanniktech.emoji.Emoji;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.parcelize.Parcelize;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0012\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0001\u0018\u0000 .2\u00020\u00012\u00020\u0002:\u0001.BQ\b\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u000e\b\u0002\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00000\u0006\u0012\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u0000\u00a2\u0006\u0002\u0010\u000eJ\t\u0010\u001c\u001a\u00020\bH\u00d6\u0001J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\u0013\u0010\u001f\u001a\u00020\u000b2\b\u0010 \u001a\u0004\u0018\u00010!H\u0096\u0002J\u0010\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0016J\b\u0010&\u001a\u00020\bH\u0016J\u0014\u0010'\u001a\u0004\u0018\u00010(2\b\u0010$\u001a\u0004\u0018\u00010%H\u0002J\b\u0010)\u001a\u00020\u0004H\u0016J\u0019\u0010*\u001a\u00020\u001e2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020\bH\u00d6\u0001R!\u0010\u000f\u001a\u00020\u00008VX\u0096\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u0014\u0010\u0015\u0012\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0016R\u0010\u0010\r\u001a\u0004\u0018\u00010\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00000\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0018R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lcom/vanniktech/emoji/twitter/TwitterEmoji;", "Lcom/vanniktech/emoji/Emoji;", "Landroid/os/Parcelable;", "unicode", "", "shortcodes", "", "x", "", "y", "isDuplicate", "", "variants", "parent", "(Ljava/lang/String;Ljava/util/List;IIZLjava/util/List;Lcom/vanniktech/emoji/twitter/TwitterEmoji;)V", "base", "getBase$annotations", "()V", "getBase", "()Lcom/vanniktech/emoji/twitter/TwitterEmoji;", "base$delegate", "Lkotlin/Lazy;", "()Z", "getShortcodes", "()Ljava/util/List;", "getUnicode", "()Ljava/lang/String;", "getVariants", "describeContents", "destroy", "", "equals", "other", "", "getDrawable", "Landroid/graphics/drawable/Drawable;", "context", "Landroid/content/Context;", "hashCode", "loadStrip", "Landroid/graphics/Bitmap;", "toString", "writeToParcel", "parcel", "Landroid/os/Parcel;", "flags", "Companion", "emoji-twitter_release"})
@Parcelize
public final class TwitterEmoji
implements Emoji,
Parcelable {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final String unicode;
    @NotNull
    private final List<String> shortcodes;
    private final int x;
    private final int y;
    private final boolean isDuplicate;
    @NotNull
    private final List<TwitterEmoji> variants;
    @Nullable
    private TwitterEmoji parent;
    @NotNull
    private final Lazy base$delegate;
    @NotNull
    public static final Parcelable.Creator<TwitterEmoji> CREATOR;
    @Deprecated
    private static final int CACHE_SIZE = 100;
    @Deprecated
    private static final int SPRITE_SIZE = 64;
    @Deprecated
    private static final int SPRITE_SIZE_INC_BORDER = 66;
    @Deprecated
    private static final int NUM_STRIPS = 60;
    @Deprecated
    @NotNull
    private static final Object LOCK;
    @Deprecated
    @NotNull
    private static final SoftReference<?>[] STRIP_REFS;
    @Deprecated
    @NotNull
    private static final LruCache<Point, Bitmap> BITMAP_CACHE;

    public TwitterEmoji(@NotNull String unicode, @NotNull List<String> shortcodes, int x, int y, boolean isDuplicate, @NotNull List<TwitterEmoji> variants, @Nullable TwitterEmoji parent) {
        Intrinsics.checkNotNullParameter((Object)unicode, (String)"unicode");
        Intrinsics.checkNotNullParameter(shortcodes, (String)"shortcodes");
        Intrinsics.checkNotNullParameter(variants, (String)"variants");
        this.unicode = unicode;
        this.shortcodes = shortcodes;
        this.x = x;
        this.y = y;
        this.isDuplicate = isDuplicate;
        this.variants = variants;
        this.parent = parent;
        this.base$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)((Function0)new Function0<TwitterEmoji>(this){
            final /* synthetic */ TwitterEmoji this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final TwitterEmoji invoke() {
                TwitterEmoji result = this.this$0;
                while (TwitterEmoji.access$getParent$p(result) != null) {
                    Intrinsics.checkNotNull((Object)TwitterEmoji.access$getParent$p(result));
                }
                return result;
            }
        }));
        for (TwitterEmoji variant : this.getVariants()) {
            variant.parent = this;
        }
    }

    public /* synthetic */ TwitterEmoji(String string, List list, int n, int n2, boolean bl, List list2, TwitterEmoji twitterEmoji, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 0x20) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        if ((n3 & 0x40) != 0) {
            twitterEmoji = null;
        }
        this(string, list, n, n2, bl, list2, twitterEmoji);
    }

    @NotNull
    public String getUnicode() {
        return this.unicode;
    }

    @NotNull
    public List<String> getShortcodes() {
        return this.shortcodes;
    }

    public boolean isDuplicate() {
        return this.isDuplicate;
    }

    @NotNull
    public List<TwitterEmoji> getVariants() {
        return this.variants;
    }

    @NotNull
    public TwitterEmoji getBase() {
        Lazy lazy = this.base$delegate;
        return (TwitterEmoji)lazy.getValue();
    }

    public static /* synthetic */ void getBase$annotations() {
    }

    @NotNull
    public Drawable getDrawable(@NotNull Context context) {
        Bitmap strip;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Point key = new Point(this.x, this.y);
        Bitmap bitmap = (Bitmap)BITMAP_CACHE.get((Object)key);
        if (bitmap != null) {
            return (Drawable)new BitmapDrawable(context.getResources(), bitmap);
        }
        Bitmap bitmap2 = strip = this.loadStrip(context);
        Intrinsics.checkNotNull((Object)bitmap2);
        Bitmap cut = Bitmap.createBitmap((Bitmap)bitmap2, (int)1, (int)(this.y * 66 + 1), (int)64, (int)64);
        BITMAP_CACHE.put((Object)key, (Object)cut);
        return (Drawable)new BitmapDrawable(context.getResources(), cut);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Bitmap loadStrip(Context context) {
        Bitmap strip = null;
        SoftReference<?> softReference = STRIP_REFS[this.x];
        strip = (Bitmap)(softReference != null ? softReference.get() : null);
        if (strip == null) {
            Object object = LOCK;
            synchronized (object) {
                boolean bl = false;
                SoftReference<?> softReference2 = STRIP_REFS[this.x];
                strip = (Bitmap)(softReference2 != null ? softReference2.get() : null);
                if (strip == null) {
                    Context context2 = context;
                    Intrinsics.checkNotNull((Object)context2);
                    Resources resources = context2.getResources();
                    int resId = resources.getIdentifier("emoji_twitter_sheet_" + this.x, "drawable", context.getPackageName());
                    strip = BitmapFactory.decodeResource((Resources)resources, (int)resId);
                    TwitterEmoji.STRIP_REFS[this.x] = new SoftReference<Bitmap>(strip);
                }
                Unit unit = Unit.INSTANCE;
            }
        }
        return strip;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        Object object = LOCK;
        synchronized (object) {
            boolean bl = false;
            BITMAP_CACHE.evictAll();
            for (int i = 0; i < 60; ++i) {
                SoftReference<?> softReference;
                SoftReference<?> softReference2 = softReference = STRIP_REFS[i];
                Bitmap bitmap = (Bitmap)(softReference2 != null ? softReference2.get() : null);
                if (bitmap != null) {
                    bitmap.recycle();
                }
                SoftReference<?> softReference3 = softReference;
                if (softReference3 == null) continue;
                softReference3.clear();
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Object object2 = other;
        if (object2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.vanniktech.emoji.twitter.TwitterEmoji");
        }
        TwitterEmoji cfr_ignored_0 = (TwitterEmoji)object2;
        if (!Intrinsics.areEqual((Object)this.getUnicode(), (Object)((TwitterEmoji)other).getUnicode())) {
            return false;
        }
        if (!Intrinsics.areEqual(this.getShortcodes(), ((TwitterEmoji)other).getShortcodes())) {
            return false;
        }
        if (this.x != ((TwitterEmoji)other).x) {
            return false;
        }
        if (this.y != ((TwitterEmoji)other).y) {
            return false;
        }
        if (this.isDuplicate() != ((TwitterEmoji)other).isDuplicate()) {
            return false;
        }
        return Intrinsics.areEqual(this.getVariants(), ((TwitterEmoji)other).getVariants());
    }

    public int hashCode() {
        int result = this.getUnicode().hashCode();
        result = 31 * result + ((Object)this.getShortcodes()).hashCode();
        result = 31 * result + this.x;
        result = 31 * result + this.y;
        result = 31 * result + Boolean.hashCode(this.isDuplicate());
        result = 31 * result + ((Object)this.getVariants()).hashCode();
        return result;
    }

    @NotNull
    public String toString() {
        return "TwitterEmoji(unicode='" + this.getUnicode() + "', shortcodes=" + this.getShortcodes() + ", x=" + this.x + ", y=" + this.y + ", isDuplicate=" + this.isDuplicate() + ", variants=" + this.getVariants() + ')';
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(@NotNull Parcel out, int flags) {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        out.writeString(this.unicode);
        out.writeStringList(this.shortcodes);
        out.writeInt(this.x);
        out.writeInt(this.y);
        out.writeInt(this.isDuplicate ? 1 : 0);
        Object object = this.variants;
        out.writeInt(object.size());
        Iterator<TwitterEmoji> iterator = object.iterator();
        while (iterator.hasNext()) {
            iterator.next().writeToParcel(out, flags);
        }
        object = this.parent;
        if (object == null) {
            out.writeInt(0);
        } else {
            out.writeInt(1);
            ((TwitterEmoji)object).writeToParcel(out, flags);
        }
    }

    public static final /* synthetic */ TwitterEmoji access$getParent$p(TwitterEmoji $this) {
        return $this.parent;
    }

    static {
        @Metadata(mv={1, 6, 0}, k=3, xi=48)
        public final class Creator
        implements Parcelable.Creator<TwitterEmoji> {
            @NotNull
            public final TwitterEmoji[] newArray(int size) {
                return new TwitterEmoji[size];
            }

            @NotNull
            public final TwitterEmoji createFromParcel(@NotNull Parcel parcel) {
                Intrinsics.checkNotNullParameter((Object)parcel, (String)"parcel");
                int n = parcel.readInt();
                ArrayList<Object> arrayList = new ArrayList<Object>(n);
                boolean bl = parcel.readInt() != 0;
                int n2 = parcel.readInt();
                int n3 = parcel.readInt();
                List list = parcel.createStringArrayList();
                String string = parcel.readString();
                for (int i = 0; i != n; ++i) {
                    arrayList.add(CREATOR.createFromParcel(parcel));
                }
                TwitterEmoji twitterEmoji = (TwitterEmoji)(parcel.readInt() == 0 ? null : CREATOR.createFromParcel(parcel));
                List list2 = arrayList;
                boolean bl2 = bl;
                int n4 = n2;
                int n5 = n3;
                List list3 = list;
                String string2 = string;
                return new TwitterEmoji(string2, list3, n5, n4, bl2, list2, twitterEmoji);
            }
        }
        CREATOR = new Creator();
        LOCK = new Object();
        STRIP_REFS = new SoftReference[60];
        BITMAP_CACHE = new LruCache(100);
        for (int i = 0; i < 60; ++i) {
            TwitterEmoji.STRIP_REFS[i] = new SoftReference<Object>(null);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u001c\u0010\r\u001a\u000e\u0012\n\u0012\b\u0012\u0002\b\u0003\u0018\u00010\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lcom/vanniktech/emoji/twitter/TwitterEmoji$Companion;", "", "()V", "BITMAP_CACHE", "Landroid/util/LruCache;", "Landroid/graphics/Point;", "Landroid/graphics/Bitmap;", "CACHE_SIZE", "", "LOCK", "NUM_STRIPS", "SPRITE_SIZE", "SPRITE_SIZE_INC_BORDER", "STRIP_REFS", "", "Ljava/lang/ref/SoftReference;", "[Ljava/lang/ref/SoftReference;", "emoji-twitter_release"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

