/*
 * Copyright (C) 2016 - Niklas Baudy, Ruben Gees, Mario Đanić and contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.vanniktech.emoji.twitter.category

import com.vanniktech.emoji.twitter.TwitterEmoji

internal object SmileysAndPeopleCategoryChunk1 {
  internal val EMOJIS: List<TwitterEmoji> = listOf(
    TwitterEmoji(String(intArrayOf(0x1F640), 0, 1), listOf("scream_cat"), 33, 27, false),
    TwitterEmoji(String(intArrayOf(0x1F63F), 0, 1), listOf("crying_cat_face"), 33, 26, false),
    TwitterEmoji(String(intArrayOf(0x1F63E), 0, 1), listOf("pouting_cat"), 33, 25, false),
    TwitterEmoji(String(intArrayOf(0x1F648), 0, 1), listOf("see_no_evil"), 34, 25, false),
    TwitterEmoji(String(intArrayOf(0x1F649), 0, 1), listOf("hear_no_evil"), 34, 26, false),
    TwitterEmoji(String(intArrayOf(0x1F64A), 0, 1), listOf("speak_no_evil"), 34, 27, false),
    TwitterEmoji(String(intArrayOf(0x1F48C), 0, 1), listOf("love_letter"), 26, 39, false),
    TwitterEmoji(String(intArrayOf(0x1F498), 0, 1), listOf("cupid"), 27, 40, false),
    TwitterEmoji(String(intArrayOf(0x1F49D), 0, 1), listOf("gift_heart"), 27, 45, false),
    TwitterEmoji(String(intArrayOf(0x1F496), 0, 1), listOf("sparkling_heart"), 27, 38, false),
    TwitterEmoji(String(intArrayOf(0x1F497), 0, 1), listOf("heartpulse"), 27, 39, false),
    TwitterEmoji(String(intArrayOf(0x1F493), 0, 1), listOf("heartbeat"), 27, 35, false),
    TwitterEmoji(String(intArrayOf(0x1F49E), 0, 1), listOf("revolving_hearts"), 27, 46, false),
    TwitterEmoji(String(intArrayOf(0x1F495), 0, 1), listOf("two_hearts"), 27, 37, false),
    TwitterEmoji(String(intArrayOf(0x1F49F), 0, 1), listOf("heart_decoration"), 27, 47, false),
    TwitterEmoji(String(intArrayOf(0x2763, 0xFE0F), 0, 2), listOf("heavy_heart_exclamation_mark_ornament"), 59, 38, false),
    TwitterEmoji(String(intArrayOf(0x1F494), 0, 1), listOf("broken_heart"), 27, 36, false),
    TwitterEmoji(String(intArrayOf(0x2764, 0xFE0F, 0x200D, 0x1F525), 0, 4), listOf("heart_on_fire"), 59, 39, false),
    TwitterEmoji(String(intArrayOf(0x2764, 0xFE0F, 0x200D, 0x1FA79), 0, 4), listOf("mending_heart"), 59, 40, false),
    TwitterEmoji(String(intArrayOf(0x2764, 0xFE0F), 0, 2), listOf("heart"), 59, 41, false),
    TwitterEmoji(String(intArrayOf(0x1F9E1), 0, 1), listOf("orange_heart"), 53, 17, false),
    TwitterEmoji(String(intArrayOf(0x1F49B), 0, 1), listOf("yellow_heart"), 27, 43, false),
    TwitterEmoji(String(intArrayOf(0x1F49A), 0, 1), listOf("green_heart"), 27, 42, false),
    TwitterEmoji(String(intArrayOf(0x1F499), 0, 1), listOf("blue_heart"), 27, 41, false),
    TwitterEmoji(String(intArrayOf(0x1F49C), 0, 1), listOf("purple_heart"), 27, 44, false),
    TwitterEmoji(String(intArrayOf(0x1F90E), 0, 1), listOf("brown_heart"), 38, 53, false),
    TwitterEmoji(String(intArrayOf(0x1F5A4), 0, 1), listOf("black_heart"), 31, 56, false),
    TwitterEmoji(String(intArrayOf(0x1F90D), 0, 1), listOf("white_heart"), 38, 52, false),
    TwitterEmoji(String(intArrayOf(0x1F48B), 0, 1), listOf("kiss"), 26, 38, false),
    TwitterEmoji(String(intArrayOf(0x1F4AF), 0, 1), listOf("100"), 28, 7, false),
    TwitterEmoji(String(intArrayOf(0x1F4A2), 0, 1), listOf("anger"), 27, 50, false),
    TwitterEmoji(String(intArrayOf(0x1F4A5), 0, 1), listOf("boom", "collision"), 27, 53, false),
    TwitterEmoji(String(intArrayOf(0x1F4AB), 0, 1), listOf("dizzy"), 28, 3, false),
    TwitterEmoji(String(intArrayOf(0x1F4A6), 0, 1), listOf("sweat_drops"), 27, 54, false),
    TwitterEmoji(String(intArrayOf(0x1F4A8), 0, 1), listOf("dash"), 27, 56, false),
    TwitterEmoji(String(intArrayOf(0x1F573, 0xFE0F), 0, 2), listOf("hole"), 30, 59, false),
    TwitterEmoji(String(intArrayOf(0x1F4AC), 0, 1), listOf("speech_balloon"), 28, 4, false),
    TwitterEmoji(String(intArrayOf(0x1F441, 0xFE0F, 0x200D, 0x1F5E8, 0xFE0F), 0, 5), listOf("eye-in-speech-bubble"), 11, 54, false),
    TwitterEmoji(String(intArrayOf(0x1F5E8, 0xFE0F), 0, 2), listOf("left_speech_bubble"), 32, 12, false),
    TwitterEmoji(String(intArrayOf(0x1F5EF, 0xFE0F), 0, 2), listOf("right_anger_bubble"), 32, 13, false),
    TwitterEmoji(String(intArrayOf(0x1F4AD), 0, 1), listOf("thought_balloon"), 28, 5, false),
    TwitterEmoji(String(intArrayOf(0x1F4A4), 0, 1), listOf("zzz"), 27, 52, false),
    TwitterEmoji(
      String(intArrayOf(0x1F44B), 0, 1), listOf("wave"), 12, 39, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F44B, 0x1F3FB), 0, 2), emptyList<String>(), 12, 40, false),
        TwitterEmoji(String(intArrayOf(0x1F44B, 0x1F3FC), 0, 2), emptyList<String>(), 12, 41, false),
        TwitterEmoji(String(intArrayOf(0x1F44B, 0x1F3FD), 0, 2), emptyList<String>(), 12, 42, false),
        TwitterEmoji(String(intArrayOf(0x1F44B, 0x1F3FE), 0, 2), emptyList<String>(), 12, 43, false),
        TwitterEmoji(String(intArrayOf(0x1F44B, 0x1F3FF), 0, 2), emptyList<String>(), 12, 44, false),
      ),
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F91A), 0, 1), listOf("raised_back_of_hand"), 39, 19, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F91A, 0x1F3FB), 0, 2), emptyList<String>(), 39, 20, false),
        TwitterEmoji(String(intArrayOf(0x1F91A, 0x1F3FC), 0, 2), emptyList<String>(), 39, 21, false),
        TwitterEmoji(String(intArrayOf(0x1F91A, 0x1F3FD), 0, 2), emptyList<String>(), 39, 22, false),
        TwitterEmoji(String(intArrayOf(0x1F91A, 0x1F3FE), 0, 2), emptyList<String>(), 39, 23, false),
        TwitterEmoji(String(intArrayOf(0x1F91A, 0x1F3FF), 0, 2), emptyList<String>(), 39, 24, false),
      ),
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F590, 0xFE0F), 0, 2), listOf("raised_hand_with_fingers_splayed"), 31, 38, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F590, 0x1F3FB), 0, 2), emptyList<String>(), 31, 39, false),
        TwitterEmoji(String(intArrayOf(0x1F590, 0x1F3FC), 0, 2), emptyList<String>(), 31, 40, false),
        TwitterEmoji(String(intArrayOf(0x1F590, 0x1F3FD), 0, 2), emptyList<String>(), 31, 41, false),
        TwitterEmoji(String(intArrayOf(0x1F590, 0x1F3FE), 0, 2), emptyList<String>(), 31, 42, false),
        TwitterEmoji(String(intArrayOf(0x1F590, 0x1F3FF), 0, 2), emptyList<String>(), 31, 43, false),
      ),
    ),
    TwitterEmoji(
      String(intArrayOf(0x270B), 0, 1), listOf("hand", "raised_hand"), 59, 3, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x270B, 0x1F3FB), 0, 2), emptyList<String>(), 59, 4, false),
        TwitterEmoji(String(intArrayOf(0x270B, 0x1F3FC), 0, 2), emptyList<String>(), 59, 5, false),
        TwitterEmoji(String(intArrayOf(0x270B, 0x1F3FD), 0, 2), emptyList<String>(), 59, 6, false),
        TwitterEmoji(String(intArrayOf(0x270B, 0x1F3FE), 0, 2), emptyList<String>(), 59, 7, false),
        TwitterEmoji(String(intArrayOf(0x270B, 0x1F3FF), 0, 2), emptyList<String>(), 59, 8, false),
      ),
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F596), 0, 1), listOf("spock-hand"), 31, 50, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F596, 0x1F3FB), 0, 2), emptyList<String>(), 31, 51, false),
        TwitterEmoji(String(intArrayOf(0x1F596, 0x1F3FC), 0, 2), emptyList<String>(), 31, 52, false),
        TwitterEmoji(String(intArrayOf(0x1F596, 0x1F3FD), 0, 2), emptyList<String>(), 31, 53, false),
        TwitterEmoji(String(intArrayOf(0x1F596, 0x1F3FE), 0, 2), emptyList<String>(), 31, 54, false),
        TwitterEmoji(String(intArrayOf(0x1F596, 0x1F3FF), 0, 2), emptyList<String>(), 31, 55, false),
      ),
    ),
    TwitterEmoji(
      String(intArrayOf(0x1FAF1), 0, 1), listOf("rightwards_hand"), 55, 45, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1FAF1, 0x1F3FB), 0, 2), emptyList<String>(), 55, 46, false),
        TwitterEmoji(String(intArrayOf(0x1FAF1, 0x1F3FC), 0, 2), emptyList<String>(), 55, 47, false),
        TwitterEmoji(String(intArrayOf(0x1FAF1, 0x1F3FD), 0, 2), emptyList<String>(), 55, 48, false),
        TwitterEmoji(String(intArrayOf(0x1FAF1, 0x1F3FE), 0, 2), emptyList<String>(), 55, 49, false),
        TwitterEmoji(String(intArrayOf(0x1FAF1, 0x1F3FF), 0, 2), emptyList<String>(), 55, 50, false),
      ),
    ),
    TwitterEmoji(
      String(intArrayOf(0x1FAF2), 0, 1), listOf("leftwards_hand"), 55, 51, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1FAF2, 0x1F3FB), 0, 2), emptyList<String>(), 55, 52, false),
        TwitterEmoji(String(intArrayOf(0x1FAF2, 0x1F3FC), 0, 2), emptyList<String>(), 55, 53, false),
        TwitterEmoji(String(intArrayOf(0x1FAF2, 0x1F3FD), 0, 2), emptyList<String>(), 55, 54, false),
        TwitterEmoji(String(intArrayOf(0x1FAF2, 0x1F3FE), 0, 2), emptyList<String>(), 55, 55, false),
        TwitterEmoji(String(intArrayOf(0x1FAF2, 0x1F3FF), 0, 2), emptyList<String>(), 55, 56, false),
      ),
    ),
    TwitterEmoji(
      String(intArrayOf(0x1FAF3), 0, 1), listOf("palm_down_hand"), 55, 57, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1FAF3, 0x1F3FB), 0, 2), emptyList<String>(), 55, 58, false),
        TwitterEmoji(String(intArrayOf(0x1FAF3, 0x1F3FC), 0, 2), emptyList<String>(), 55, 59, false),
        TwitterEmoji(String(intArrayOf(0x1FAF3, 0x1F3FD), 0, 2), emptyList<String>(), 55, 60, false),
        TwitterEmoji(String(intArrayOf(0x1FAF3, 0x1F3FE), 0, 2), emptyList<String>(), 56, 0, false),
        TwitterEmoji(String(intArrayOf(0x1FAF3, 0x1F3FF), 0, 2), emptyList<String>(), 56, 1, false),
      ),
    ),
    TwitterEmoji(
      String(intArrayOf(0x1FAF4), 0, 1), listOf("palm_up_hand"), 56, 2, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1FAF4, 0x1F3FB), 0, 2), emptyList<String>(), 56, 3, false),
        TwitterEmoji(String(intArrayOf(0x1FAF4, 0x1F3FC), 0, 2), emptyList<String>(), 56, 4, false),
        TwitterEmoji(String(intArrayOf(0x1FAF4, 0x1F3FD), 0, 2), emptyList<String>(), 56, 5, false),
        TwitterEmoji(String(intArrayOf(0x1FAF4, 0x1F3FE), 0, 2), emptyList<String>(), 56, 6, false),
        TwitterEmoji(String(intArrayOf(0x1FAF4, 0x1F3FF), 0, 2), emptyList<String>(), 56, 7, false),
      ),
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F44C), 0, 1), listOf("ok_hand"), 12, 45, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F44C, 0x1F3FB), 0, 2), emptyList<String>(), 12, 46, false),
        TwitterEmoji(String(intArrayOf(0x1F44C, 0x1F3FC), 0, 2), emptyList<String>(), 12, 47, false),
        TwitterEmoji(String(intArrayOf(0x1F44C, 0x1F3FD), 0, 2), emptyList<String>(), 12, 48, false),
        TwitterEmoji(String(intArrayOf(0x1F44C, 0x1F3FE), 0, 2), emptyList<String>(), 12, 49, false),
        TwitterEmoji(String(intArrayOf(0x1F44C, 0x1F3FF), 0, 2), emptyList<String>(), 12, 50, false),
      ),
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F90C), 0, 1), listOf("pinched_fingers"), 38, 46, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F90C, 0x1F3FB), 0, 2), emptyList<String>(), 38, 47, false),
        TwitterEmoji(String(intArrayOf(0x1F90C, 0x1F3FC), 0, 2), emptyList<String>(), 38, 48, false),
        TwitterEmoji(String(intArrayOf(0x1F90C, 0x1F3FD), 0, 2), emptyList<String>(), 38, 49, false),
        TwitterEmoji(String(intArrayOf(0x1F90C, 0x1F3FE), 0, 2), emptyList<String>(), 38, 50, false),
        TwitterEmoji(String(intArrayOf(0x1F90C, 0x1F3FF), 0, 2), emptyList<String>(), 38, 51, false),
      ),
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F90F), 0, 1), listOf("pinching_hand"), 38, 54, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F90F, 0x1F3FB), 0, 2), emptyList<String>(), 38, 55, false),
        TwitterEmoji(String(intArrayOf(0x1F90F, 0x1F3FC), 0, 2), emptyList<String>(), 38, 56, false),
        TwitterEmoji(String(intArrayOf(0x1F90F, 0x1F3FD), 0, 2), emptyList<String>(), 38, 57, false),
        TwitterEmoji(String(intArrayOf(0x1F90F, 0x1F3FE), 0, 2), emptyList<String>(), 38, 58, false),
        TwitterEmoji(String(intArrayOf(0x1F90F, 0x1F3FF), 0, 2), emptyList<String>(), 38, 59, false),
      ),
    ),
    TwitterEmoji(
      String(intArrayOf(0x270C, 0xFE0F), 0, 2), listOf("v"), 59, 9, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x270C, 0x1F3FB), 0, 2), emptyList<String>(), 59, 10, false),
        TwitterEmoji(String(intArrayOf(0x270C, 0x1F3FC), 0, 2), emptyList<String>(), 59, 11, false),
        TwitterEmoji(String(intArrayOf(0x270C, 0x1F3FD), 0, 2), emptyList<String>(), 59, 12, false),
        TwitterEmoji(String(intArrayOf(0x270C, 0x1F3FE), 0, 2), emptyList<String>(), 59, 13, false),
        TwitterEmoji(String(intArrayOf(0x270C, 0x1F3FF), 0, 2), emptyList<String>(), 59, 14, false),
      ),
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F91E), 0, 1), listOf("crossed_fingers", "hand_with_index_and_middle_fingers_crossed"), 40, 2, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F91E, 0x1F3FB), 0, 2), emptyList<String>(), 40, 3, false),
        TwitterEmoji(String(intArrayOf(0x1F91E, 0x1F3FC), 0, 2), emptyList<String>(), 40, 4, false),
        TwitterEmoji(String(intArrayOf(0x1F91E, 0x1F3FD), 0, 2), emptyList<String>(), 40, 5, false),
        TwitterEmoji(String(intArrayOf(0x1F91E, 0x1F3FE), 0, 2), emptyList<String>(), 40, 6, false),
        TwitterEmoji(String(intArrayOf(0x1F91E, 0x1F3FF), 0, 2), emptyList<String>(), 40, 7, false),
      ),
    ),
    TwitterEmoji(
      String(intArrayOf(0x1FAF0), 0, 1), listOf("hand_with_index_finger_and_thumb_crossed"), 55, 39, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1FAF0, 0x1F3FB), 0, 2), emptyList<String>(), 55, 40, false),
        TwitterEmoji(String(intArrayOf(0x1FAF0, 0x1F3FC), 0, 2), emptyList<String>(), 55, 41, false),
        TwitterEmoji(String(intArrayOf(0x1FAF0, 0x1F3FD), 0, 2), emptyList<String>(), 55, 42, false),
        TwitterEmoji(String(intArrayOf(0x1FAF0, 0x1F3FE), 0, 2), emptyList<String>(), 55, 43, false),
        TwitterEmoji(String(intArrayOf(0x1FAF0, 0x1F3FF), 0, 2), emptyList<String>(), 55, 44, false),
      ),
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F91F), 0, 1), listOf("i_love_you_hand_sign"), 40, 8, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F91F, 0x1F3FB), 0, 2), emptyList<String>(), 40, 9, false),
        TwitterEmoji(String(intArrayOf(0x1F91F, 0x1F3FC), 0, 2), emptyList<String>(), 40, 10, false),
        TwitterEmoji(String(intArrayOf(0x1F91F, 0x1F3FD), 0, 2), emptyList<String>(), 40, 11, false),
        TwitterEmoji(String(intArrayOf(0x1F91F, 0x1F3FE), 0, 2), emptyList<String>(), 40, 12, false),
        TwitterEmoji(String(intArrayOf(0x1F91F, 0x1F3FF), 0, 2), emptyList<String>(), 40, 13, false),
      ),
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F918), 0, 1), listOf("the_horns", "sign_of_the_horns"), 39, 7, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F918, 0x1F3FB), 0, 2), emptyList<String>(), 39, 8, false),
        TwitterEmoji(String(intArrayOf(0x1F918, 0x1F3FC), 0, 2), emptyList<String>(), 39, 9, false),
        TwitterEmoji(String(intArrayOf(0x1F918, 0x1F3FD), 0, 2), emptyList<String>(), 39, 10, false),
        TwitterEmoji(String(intArrayOf(0x1F918, 0x1F3FE), 0, 2), emptyList<String>(), 39, 11, false),
        TwitterEmoji(String(intArrayOf(0x1F918, 0x1F3FF), 0, 2), emptyList<String>(), 39, 12, false),
      ),
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F919), 0, 1), listOf("call_me_hand"), 39, 13, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F919, 0x1F3FB), 0, 2), emptyList<String>(), 39, 14, false),
        TwitterEmoji(String(intArrayOf(0x1F919, 0x1F3FC), 0, 2), emptyList<String>(), 39, 15, false),
        TwitterEmoji(String(intArrayOf(0x1F919, 0x1F3FD), 0, 2), emptyList<String>(), 39, 16, false),
        TwitterEmoji(String(intArrayOf(0x1F919, 0x1F3FE), 0, 2), emptyList<String>(), 39, 17, false),
        TwitterEmoji(String(intArrayOf(0x1F919, 0x1F3FF), 0, 2), emptyList<String>(), 39, 18, false),
      ),
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F448), 0, 1), listOf("point_left"), 12, 21, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F448, 0x1F3FB), 0, 2), emptyList<String>(), 12, 22, false),
        TwitterEmoji(String(intArrayOf(0x1F448, 0x1F3FC), 0, 2), emptyList<String>(), 12, 23, false),
        TwitterEmoji(String(intArrayOf(0x1F448, 0x1F3FD), 0, 2), emptyList<String>(), 12, 24, false),
        TwitterEmoji(String(intArrayOf(0x1F448, 0x1F3FE), 0, 2), emptyList<String>(), 12, 25, false),
        TwitterEmoji(String(intArrayOf(0x1F448, 0x1F3FF), 0, 2), emptyList<String>(), 12, 26, false),
      ),
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F449), 0, 1), listOf("point_right"), 12, 27, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F449, 0x1F3FB), 0, 2), emptyList<String>(), 12, 28, false),
        TwitterEmoji(String(intArrayOf(0x1F449, 0x1F3FC), 0, 2), emptyList<String>(), 12, 29, false),
        TwitterEmoji(String(intArrayOf(0x1F449, 0x1F3FD), 0, 2), emptyList<String>(), 12, 30, false),
        TwitterEmoji(String(intArrayOf(0x1F449, 0x1F3FE), 0, 2), emptyList<String>(), 12, 31, false),
        TwitterEmoji(String(intArrayOf(0x1F449, 0x1F3FF), 0, 2), emptyList<String>(), 12, 32, false),
      ),
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F446), 0, 1), listOf("point_up_2"), 12, 9, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F446, 0x1F3FB), 0, 2), emptyList<String>(), 12, 10, false),
        TwitterEmoji(String(intArrayOf(0x1F446, 0x1F3FC), 0, 2), emptyList<String>(), 12, 11, false),
        TwitterEmoji(String(intArrayOf(0x1F446, 0x1F3FD), 0, 2), emptyList<String>(), 12, 12, false),
        TwitterEmoji(String(intArrayOf(0x1F446, 0x1F3FE), 0, 2), emptyList<String>(), 12, 13, false),
        TwitterEmoji(String(intArrayOf(0x1F446, 0x1F3FF), 0, 2), emptyList<String>(), 12, 14, false),
      ),
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F595), 0, 1), listOf("middle_finger", "reversed_hand_with_middle_finger_extended"), 31, 44, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F595, 0x1F3FB), 0, 2), emptyList<String>(), 31, 45, false),
        TwitterEmoji(String(intArrayOf(0x1F595, 0x1F3FC), 0, 2), emptyList<String>(), 31, 46, false),
        TwitterEmoji(String(intArrayOf(0x1F595, 0x1F3FD), 0, 2), emptyList<String>(), 31, 47, false),
        TwitterEmoji(String(intArrayOf(0x1F595, 0x1F3FE), 0, 2), emptyList<String>(), 31, 48, false),
        TwitterEmoji(String(intArrayOf(0x1F595, 0x1F3FF), 0, 2), emptyList<String>(), 31, 49, false),
      ),
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F447), 0, 1), listOf("point_down"), 12, 15, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F447, 0x1F3FB), 0, 2), emptyList<String>(), 12, 16, false),
        TwitterEmoji(String(intArrayOf(0x1F447, 0x1F3FC), 0, 2), emptyList<String>(), 12, 17, false),
        TwitterEmoji(String(intArrayOf(0x1F447, 0x1F3FD), 0, 2), emptyList<String>(), 12, 18, false),
        TwitterEmoji(String(intArrayOf(0x1F447, 0x1F3FE), 0, 2), emptyList<String>(), 12, 19, false),
        TwitterEmoji(String(intArrayOf(0x1F447, 0x1F3FF), 0, 2), emptyList<String>(), 12, 20, false),
      ),
    ),
    TwitterEmoji(
      String(intArrayOf(0x261D, 0xFE0F), 0, 2), listOf("point_up"), 57, 20, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x261D, 0x1F3FB), 0, 2), emptyList<String>(), 57, 21, false),
        TwitterEmoji(String(intArrayOf(0x261D, 0x1F3FC), 0, 2), emptyList<String>(), 57, 22, false),
        TwitterEmoji(String(intArrayOf(0x261D, 0x1F3FD), 0, 2), emptyList<String>(), 57, 23, false),
        TwitterEmoji(String(intArrayOf(0x261D, 0x1F3FE), 0, 2), emptyList<String>(), 57, 24, false),
        TwitterEmoji(String(intArrayOf(0x261D, 0x1F3FF), 0, 2), emptyList<String>(), 57, 25, false),
      ),
    ),
    TwitterEmoji(
      String(intArrayOf(0x1FAF5), 0, 1), listOf("index_pointing_at_the_viewer"), 56, 8, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1FAF5, 0x1F3FB), 0, 2), emptyList<String>(), 56, 9, false),
        TwitterEmoji(String(intArrayOf(0x1FAF5, 0x1F3FC), 0, 2), emptyList<String>(), 56, 10, false),
        TwitterEmoji(String(intArrayOf(0x1FAF5, 0x1F3FD), 0, 2), emptyList<String>(), 56, 11, false),
        TwitterEmoji(String(intArrayOf(0x1FAF5, 0x1F3FE), 0, 2), emptyList<String>(), 56, 12, false),
        TwitterEmoji(String(intArrayOf(0x1FAF5, 0x1F3FF), 0, 2), emptyList<String>(), 56, 13, false),
      ),
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F44D), 0, 1), listOf("+1", "thumbsup"), 12, 51, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F44D, 0x1F3FB), 0, 2), emptyList<String>(), 12, 52, false),
        TwitterEmoji(String(intArrayOf(0x1F44D, 0x1F3FC), 0, 2), emptyList<String>(), 12, 53, false),
        TwitterEmoji(String(intArrayOf(0x1F44D, 0x1F3FD), 0, 2), emptyList<String>(), 12, 54, false),
        TwitterEmoji(String(intArrayOf(0x1F44D, 0x1F3FE), 0, 2), emptyList<String>(), 12, 55, false),
        TwitterEmoji(String(intArrayOf(0x1F44D, 0x1F3FF), 0, 2), emptyList<String>(), 12, 56, false),
      ),
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F44E), 0, 1), listOf("-1", "thumbsdown"), 12, 57, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F44E, 0x1F3FB), 0, 2), emptyList<String>(), 12, 58, false),
        TwitterEmoji(String(intArrayOf(0x1F44E, 0x1F3FC), 0, 2), emptyList<String>(), 12, 59, false),
        TwitterEmoji(String(intArrayOf(0x1F44E, 0x1F3FD), 0, 2), emptyList<String>(), 12, 60, false),
        TwitterEmoji(String(intArrayOf(0x1F44E, 0x1F3FE), 0, 2), emptyList<String>(), 13, 0, false),
        TwitterEmoji(String(intArrayOf(0x1F44E, 0x1F3FF), 0, 2), emptyList<String>(), 13, 1, false),
      ),
    ),
    TwitterEmoji(
      String(intArrayOf(0x270A), 0, 1), listOf("fist"), 58, 58, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x270A, 0x1F3FB), 0, 2), emptyList<String>(), 58, 59, false),
        TwitterEmoji(String(intArrayOf(0x270A, 0x1F3FC), 0, 2), emptyList<String>(), 58, 60, false),
        TwitterEmoji(String(intArrayOf(0x270A, 0x1F3FD), 0, 2), emptyList<String>(), 59, 0, false),
        TwitterEmoji(String(intArrayOf(0x270A, 0x1F3FE), 0, 2), emptyList<String>(), 59, 1, false),
        TwitterEmoji(String(intArrayOf(0x270A, 0x1F3FF), 0, 2), emptyList<String>(), 59, 2, false),
      ),
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F44A), 0, 1), listOf("facepunch", "punch"), 12, 33, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F44A, 0x1F3FB), 0, 2), emptyList<String>(), 12, 34, false),
        TwitterEmoji(String(intArrayOf(0x1F44A, 0x1F3FC), 0, 2), emptyList<String>(), 12, 35, false),
        TwitterEmoji(String(intArrayOf(0x1F44A, 0x1F3FD), 0, 2), emptyList<String>(), 12, 36, false),
        TwitterEmoji(String(intArrayOf(0x1F44A, 0x1F3FE), 0, 2), emptyList<String>(), 12, 37, false),
        TwitterEmoji(String(intArrayOf(0x1F44A, 0x1F3FF), 0, 2), emptyList<String>(), 12, 38, false),
      ),
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F91B), 0, 1), listOf("left-facing_fist"), 39, 25, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F91B, 0x1F3FB), 0, 2), emptyList<String>(), 39, 26, false),
        TwitterEmoji(String(intArrayOf(0x1F91B, 0x1F3FC), 0, 2), emptyList<String>(), 39, 27, false),
        TwitterEmoji(String(intArrayOf(0x1F91B, 0x1F3FD), 0, 2), emptyList<String>(), 39, 28, false),
        TwitterEmoji(String(intArrayOf(0x1F91B, 0x1F3FE), 0, 2), emptyList<String>(), 39, 29, false),
        TwitterEmoji(String(intArrayOf(0x1F91B, 0x1F3FF), 0, 2), emptyList<String>(), 39, 30, false),
      ),
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F91C), 0, 1), listOf("right-facing_fist"), 39, 31, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F91C, 0x1F3FB), 0, 2), emptyList<String>(), 39, 32, false),
        TwitterEmoji(String(intArrayOf(0x1F91C, 0x1F3FC), 0, 2), emptyList<String>(), 39, 33, false),
        TwitterEmoji(String(intArrayOf(0x1F91C, 0x1F3FD), 0, 2), emptyList<String>(), 39, 34, false),
        TwitterEmoji(String(intArrayOf(0x1F91C, 0x1F3FE), 0, 2), emptyList<String>(), 39, 35, false),
        TwitterEmoji(String(intArrayOf(0x1F91C, 0x1F3FF), 0, 2), emptyList<String>(), 39, 36, false),
      ),
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F44F), 0, 1), listOf("clap"), 13, 2, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F44F, 0x1F3FB), 0, 2), emptyList<String>(), 13, 3, false),
        TwitterEmoji(String(intArrayOf(0x1F44F, 0x1F3FC), 0, 2), emptyList<String>(), 13, 4, false),
        TwitterEmoji(String(intArrayOf(0x1F44F, 0x1F3FD), 0, 2), emptyList<String>(), 13, 5, false),
        TwitterEmoji(String(intArrayOf(0x1F44F, 0x1F3FE), 0, 2), emptyList<String>(), 13, 6, false),
        TwitterEmoji(String(intArrayOf(0x1F44F, 0x1F3FF), 0, 2), emptyList<String>(), 13, 7, false),
      ),
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F64C), 0, 1), listOf("raised_hands"), 34, 46, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F64C, 0x1F3FB), 0, 2), emptyList<String>(), 34, 47, false),
        TwitterEmoji(String(intArrayOf(0x1F64C, 0x1F3FC), 0, 2), emptyList<String>(), 34, 48, false),
        TwitterEmoji(String(intArrayOf(0x1F64C, 0x1F3FD), 0, 2), emptyList<String>(), 34, 49, false),
        TwitterEmoji(String(intArrayOf(0x1F64C, 0x1F3FE), 0, 2), emptyList<String>(), 34, 50, false),
        TwitterEmoji(String(intArrayOf(0x1F64C, 0x1F3FF), 0, 2), emptyList<String>(), 34, 51, false),
      ),
    ),
    TwitterEmoji(
      String(intArrayOf(0x1FAF6), 0, 1), listOf("heart_hands"), 56, 14, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1FAF6, 0x1F3FB), 0, 2), emptyList<String>(), 56, 15, false),
        TwitterEmoji(String(intArrayOf(0x1FAF6, 0x1F3FC), 0, 2), emptyList<String>(), 56, 16, false),
        TwitterEmoji(String(intArrayOf(0x1FAF6, 0x1F3FD), 0, 2), emptyList<String>(), 56, 17, false),
        TwitterEmoji(String(intArrayOf(0x1FAF6, 0x1F3FE), 0, 2), emptyList<String>(), 56, 18, false),
        TwitterEmoji(String(intArrayOf(0x1FAF6, 0x1F3FF), 0, 2), emptyList<String>(), 56, 19, false),
      ),
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F450), 0, 1), listOf("open_hands"), 13, 8, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F450, 0x1F3FB), 0, 2), emptyList<String>(), 13, 9, false),
        TwitterEmoji(String(intArrayOf(0x1F450, 0x1F3FC), 0, 2), emptyList<String>(), 13, 10, false),
        TwitterEmoji(String(intArrayOf(0x1F450, 0x1F3FD), 0, 2), emptyList<String>(), 13, 11, false),
        TwitterEmoji(String(intArrayOf(0x1F450, 0x1F3FE), 0, 2), emptyList<String>(), 13, 12, false),
        TwitterEmoji(String(intArrayOf(0x1F450, 0x1F3FF), 0, 2), emptyList<String>(), 13, 13, false),
      ),
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F932), 0, 1), listOf("palms_up_together"), 40, 59, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F932, 0x1F3FB), 0, 2), emptyList<String>(), 40, 60, false),
        TwitterEmoji(String(intArrayOf(0x1F932, 0x1F3FC), 0, 2), emptyList<String>(), 41, 0, false),
        TwitterEmoji(String(intArrayOf(0x1F932, 0x1F3FD), 0, 2), emptyList<String>(), 41, 1, false),
        TwitterEmoji(String(intArrayOf(0x1F932, 0x1F3FE), 0, 2), emptyList<String>(), 41, 2, false),
        TwitterEmoji(String(intArrayOf(0x1F932, 0x1F3FF), 0, 2), emptyList<String>(), 41, 3, false),
      ),
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F91D), 0, 1), listOf("handshake"), 39, 37, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F91D, 0x1F3FB), 0, 2), emptyList<String>(), 39, 38, false),
        TwitterEmoji(String(intArrayOf(0x1F91D, 0x1F3FC), 0, 2), emptyList<String>(), 39, 39, false),
        TwitterEmoji(String(intArrayOf(0x1F91D, 0x1F3FD), 0, 2), emptyList<String>(), 39, 40, false),
        TwitterEmoji(String(intArrayOf(0x1F91D, 0x1F3FE), 0, 2), emptyList<String>(), 39, 41, false),
        TwitterEmoji(String(intArrayOf(0x1F91D, 0x1F3FF), 0, 2), emptyList<String>(), 39, 42, false),
        TwitterEmoji(String(intArrayOf(0x1FAF1, 0x1F3FB, 0x200D, 0x1FAF2, 0x1F3FC), 0, 5), emptyList<String>(), 39, 43, false),
        TwitterEmoji(String(intArrayOf(0x1FAF1, 0x1F3FB, 0x200D, 0x1FAF2, 0x1F3FD), 0, 5), emptyList<String>(), 39, 44, false),
        TwitterEmoji(String(intArrayOf(0x1FAF1, 0x1F3FB, 0x200D, 0x1FAF2, 0x1F3FE), 0, 5), emptyList<String>(), 39, 45, false),
        TwitterEmoji(String(intArrayOf(0x1FAF1, 0x1F3FB, 0x200D, 0x1FAF2, 0x1F3FF), 0, 5), emptyList<String>(), 39, 46, false),
        TwitterEmoji(String(intArrayOf(0x1FAF1, 0x1F3FC, 0x200D, 0x1FAF2, 0x1F3FB), 0, 5), emptyList<String>(), 39, 47, false),
        TwitterEmoji(String(intArrayOf(0x1FAF1, 0x1F3FC, 0x200D, 0x1FAF2, 0x1F3FD), 0, 5), emptyList<String>(), 39, 48, false),
        TwitterEmoji(String(intArrayOf(0x1FAF1, 0x1F3FC, 0x200D, 0x1FAF2, 0x1F3FE), 0, 5), emptyList<String>(), 39, 49, false),
        TwitterEmoji(String(intArrayOf(0x1FAF1, 0x1F3FC, 0x200D, 0x1FAF2, 0x1F3FF), 0, 5), emptyList<String>(), 39, 50, false),
        TwitterEmoji(String(intArrayOf(0x1FAF1, 0x1F3FD, 0x200D, 0x1FAF2, 0x1F3FB), 0, 5), emptyList<String>(), 39, 51, false),
        TwitterEmoji(String(intArrayOf(0x1FAF1, 0x1F3FD, 0x200D, 0x1FAF2, 0x1F3FC), 0, 5), emptyList<String>(), 39, 52, false),
        TwitterEmoji(String(intArrayOf(0x1FAF1, 0x1F3FD, 0x200D, 0x1FAF2, 0x1F3FE), 0, 5), emptyList<String>(), 39, 53, false),
        TwitterEmoji(String(intArrayOf(0x1FAF1, 0x1F3FD, 0x200D, 0x1FAF2, 0x1F3FF), 0, 5), emptyList<String>(), 39, 54, false),
        TwitterEmoji(String(intArrayOf(0x1FAF1, 0x1F3FE, 0x200D, 0x1FAF2, 0x1F3FB), 0, 5), emptyList<String>(), 39, 55, false),
        TwitterEmoji(String(intArrayOf(0x1FAF1, 0x1F3FE, 0x200D, 0x1FAF2, 0x1F3FC), 0, 5), emptyList<String>(), 39, 56, false),
        TwitterEmoji(String(intArrayOf(0x1FAF1, 0x1F3FE, 0x200D, 0x1FAF2, 0x1F3FD), 0, 5), emptyList<String>(), 39, 57, false),
        TwitterEmoji(String(intArrayOf(0x1FAF1, 0x1F3FE, 0x200D, 0x1FAF2, 0x1F3FF), 0, 5), emptyList<String>(), 39, 58, false),
        TwitterEmoji(String(intArrayOf(0x1FAF1, 0x1F3FF, 0x200D, 0x1FAF2, 0x1F3FB), 0, 5), emptyList<String>(), 39, 59, false),
        TwitterEmoji(String(intArrayOf(0x1FAF1, 0x1F3FF, 0x200D, 0x1FAF2, 0x1F3FC), 0, 5), emptyList<String>(), 39, 60, false),
        TwitterEmoji(String(intArrayOf(0x1FAF1, 0x1F3FF, 0x200D, 0x1FAF2, 0x1F3FD), 0, 5), emptyList<String>(), 40, 0, false),
        TwitterEmoji(String(intArrayOf(0x1FAF1, 0x1F3FF, 0x200D, 0x1FAF2, 0x1F3FE), 0, 5), emptyList<String>(), 40, 1, false),
      ),
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F64F), 0, 1), listOf("pray"), 35, 27, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F64F, 0x1F3FB), 0, 2), emptyList<String>(), 35, 28, false),
        TwitterEmoji(String(intArrayOf(0x1F64F, 0x1F3FC), 0, 2), emptyList<String>(), 35, 29, false),
        TwitterEmoji(String(intArrayOf(0x1F64F, 0x1F3FD), 0, 2), emptyList<String>(), 35, 30, false),
        TwitterEmoji(String(intArrayOf(0x1F64F, 0x1F3FE), 0, 2), emptyList<String>(), 35, 31, false),
        TwitterEmoji(String(intArrayOf(0x1F64F, 0x1F3FF), 0, 2), emptyList<String>(), 35, 32, false),
      ),
    ),
    TwitterEmoji(
      String(intArrayOf(0x270D, 0xFE0F), 0, 2), listOf("writing_hand"), 59, 15, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x270D, 0x1F3FB), 0, 2), emptyList<String>(), 59, 16, false),
        TwitterEmoji(String(intArrayOf(0x270D, 0x1F3FC), 0, 2), emptyList<String>(), 59, 17, false),
        TwitterEmoji(String(intArrayOf(0x270D, 0x1F3FD), 0, 2), emptyList<String>(), 59, 18, false),
        TwitterEmoji(String(intArrayOf(0x270D, 0x1F3FE), 0, 2), emptyList<String>(), 59, 19, false),
        TwitterEmoji(String(intArrayOf(0x270D, 0x1F3FF), 0, 2), emptyList<String>(), 59, 20, false),
      ),
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F485), 0, 1), listOf("nail_care"), 25, 54, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F485, 0x1F3FB), 0, 2), emptyList<String>(), 25, 55, false),
        TwitterEmoji(String(intArrayOf(0x1F485, 0x1F3FC), 0, 2), emptyList<String>(), 25, 56, false),
        TwitterEmoji(String(intArrayOf(0x1F485, 0x1F3FD), 0, 2), emptyList<String>(), 25, 57, false),
        TwitterEmoji(String(intArrayOf(0x1F485, 0x1F3FE), 0, 2), emptyList<String>(), 25, 58, false),
        TwitterEmoji(String(intArrayOf(0x1F485, 0x1F3FF), 0, 2), emptyList<String>(), 25, 59, false),
      ),
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F933), 0, 1), listOf("selfie"), 41, 4, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F933, 0x1F3FB), 0, 2), emptyList<String>(), 41, 5, false),
        TwitterEmoji(String(intArrayOf(0x1F933, 0x1F3FC), 0, 2), emptyList<String>(), 41, 6, false),
        TwitterEmoji(String(intArrayOf(0x1F933, 0x1F3FD), 0, 2), emptyList<String>(), 41, 7, false),
        TwitterEmoji(String(intArrayOf(0x1F933, 0x1F3FE), 0, 2), emptyList<String>(), 41, 8, false),
        TwitterEmoji(String(intArrayOf(0x1F933, 0x1F3FF), 0, 2), emptyList<String>(), 41, 9, false),
      ),
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F4AA), 0, 1), listOf("muscle"), 27, 58, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F4AA, 0x1F3FB), 0, 2), emptyList<String>(), 27, 59, false),
        TwitterEmoji(String(intArrayOf(0x1F4AA, 0x1F3FC), 0, 2), emptyList<String>(), 27, 60, false),
        TwitterEmoji(String(intArrayOf(0x1F4AA, 0x1F3FD), 0, 2), emptyList<String>(), 28, 0, false),
        TwitterEmoji(String(intArrayOf(0x1F4AA, 0x1F3FE), 0, 2), emptyList<String>(), 28, 1, false),
        TwitterEmoji(String(intArrayOf(0x1F4AA, 0x1F3FF), 0, 2), emptyList<String>(), 28, 2, false),
      ),
    ),
    TwitterEmoji(String(intArrayOf(0x1F9BE), 0, 1), listOf("mechanical_arm"), 46, 5, false),
    TwitterEmoji(String(intArrayOf(0x1F9BF), 0, 1), listOf("mechanical_leg"), 46, 6, false),
    TwitterEmoji(
      String(intArrayOf(0x1F9B5), 0, 1), listOf("leg"), 45, 8, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F9B5, 0x1F3FB), 0, 2), emptyList<String>(), 45, 9, false),
        TwitterEmoji(String(intArrayOf(0x1F9B5, 0x1F3FC), 0, 2), emptyList<String>(), 45, 10, false),
        TwitterEmoji(String(intArrayOf(0x1F9B5, 0x1F3FD), 0, 2), emptyList<String>(), 45, 11, false),
        TwitterEmoji(String(intArrayOf(0x1F9B5, 0x1F3FE), 0, 2), emptyList<String>(), 45, 12, false),
        TwitterEmoji(String(intArrayOf(0x1F9B5, 0x1F3FF), 0, 2), emptyList<String>(), 45, 13, false),
      ),
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F9B6), 0, 1), listOf("foot"), 45, 14, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F9B6, 0x1F3FB), 0, 2), emptyList<String>(), 45, 15, false),
        TwitterEmoji(String(intArrayOf(0x1F9B6, 0x1F3FC), 0, 2), emptyList<String>(), 45, 16, false),
        TwitterEmoji(String(intArrayOf(0x1F9B6, 0x1F3FD), 0, 2), emptyList<String>(), 45, 17, false),
        TwitterEmoji(String(intArrayOf(0x1F9B6, 0x1F3FE), 0, 2), emptyList<String>(), 45, 18, false),
        TwitterEmoji(String(intArrayOf(0x1F9B6, 0x1F3FF), 0, 2), emptyList<String>(), 45, 19, false),
      ),
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F442), 0, 1), listOf("ear"), 11, 56, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F442, 0x1F3FB), 0, 2), emptyList<String>(), 11, 57, false),
        TwitterEmoji(String(intArrayOf(0x1F442, 0x1F3FC), 0, 2), emptyList<String>(), 11, 58, false),
        TwitterEmoji(String(intArrayOf(0x1F442, 0x1F3FD), 0, 2), emptyList<String>(), 11, 59, false),
        TwitterEmoji(String(intArrayOf(0x1F442, 0x1F3FE), 0, 2), emptyList<String>(), 11, 60, false),
        TwitterEmoji(String(intArrayOf(0x1F442, 0x1F3FF), 0, 2), emptyList<String>(), 12, 0, false),
      ),
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F9BB), 0, 1), listOf("ear_with_hearing_aid"), 45, 58, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F9BB, 0x1F3FB), 0, 2), emptyList<String>(), 45, 59, false),
        TwitterEmoji(String(intArrayOf(0x1F9BB, 0x1F3FC), 0, 2), emptyList<String>(), 45, 60, false),
        TwitterEmoji(String(intArrayOf(0x1F9BB, 0x1F3FD), 0, 2), emptyList<String>(), 46, 0, false),
        TwitterEmoji(String(intArrayOf(0x1F9BB, 0x1F3FE), 0, 2), emptyList<String>(), 46, 1, false),
        TwitterEmoji(String(intArrayOf(0x1F9BB, 0x1F3FF), 0, 2), emptyList<String>(), 46, 2, false),
      ),
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F443), 0, 1), listOf("nose"), 12, 1, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F443, 0x1F3FB), 0, 2), emptyList<String>(), 12, 2, false),
        TwitterEmoji(String(intArrayOf(0x1F443, 0x1F3FC), 0, 2), emptyList<String>(), 12, 3, false),
        TwitterEmoji(String(intArrayOf(0x1F443, 0x1F3FD), 0, 2), emptyList<String>(), 12, 4, false),
        TwitterEmoji(String(intArrayOf(0x1F443, 0x1F3FE), 0, 2), emptyList<String>(), 12, 5, false),
        TwitterEmoji(String(intArrayOf(0x1F443, 0x1F3FF), 0, 2), emptyList<String>(), 12, 6, false),
      ),
    ),
    TwitterEmoji(String(intArrayOf(0x1F9E0), 0, 1), listOf("brain"), 53, 16, false),
    TwitterEmoji(String(intArrayOf(0x1FAC0), 0, 1), listOf("anatomical_heart"), 54, 56, false),
    TwitterEmoji(String(intArrayOf(0x1FAC1), 0, 1), listOf("lungs"), 54, 57, false),
    TwitterEmoji(String(intArrayOf(0x1F9B7), 0, 1), listOf("tooth"), 45, 20, false),
    TwitterEmoji(String(intArrayOf(0x1F9B4), 0, 1), listOf("bone"), 45, 7, false),
    TwitterEmoji(String(intArrayOf(0x1F440), 0, 1), listOf("eyes"), 11, 53, false),
    TwitterEmoji(String(intArrayOf(0x1F441, 0xFE0F), 0, 2), listOf("eye"), 11, 55, false),
    TwitterEmoji(String(intArrayOf(0x1F445), 0, 1), listOf("tongue"), 12, 8, false),
    TwitterEmoji(String(intArrayOf(0x1F444), 0, 1), listOf("lips"), 12, 7, false),
    TwitterEmoji(String(intArrayOf(0x1FAE6), 0, 1), listOf("biting_lip"), 55, 36, false),
    TwitterEmoji(
      String(intArrayOf(0x1F476), 0, 1), listOf("baby"), 24, 29, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F476, 0x1F3FB), 0, 2), emptyList<String>(), 24, 30, false),
        TwitterEmoji(String(intArrayOf(0x1F476, 0x1F3FC), 0, 2), emptyList<String>(), 24, 31, false),
        TwitterEmoji(String(intArrayOf(0x1F476, 0x1F3FD), 0, 2), emptyList<String>(), 24, 32, false),
        TwitterEmoji(String(intArrayOf(0x1F476, 0x1F3FE), 0, 2), emptyList<String>(), 24, 33, false),
        TwitterEmoji(String(intArrayOf(0x1F476, 0x1F3FF), 0, 2), emptyList<String>(), 24, 34, false),
      ),
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F9D2), 0, 1), listOf("child"), 50, 13, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F9D2, 0x1F3FB), 0, 2), emptyList<String>(), 50, 14, false),
        TwitterEmoji(String(intArrayOf(0x1F9D2, 0x1F3FC), 0, 2), emptyList<String>(), 50, 15, false),
        TwitterEmoji(String(intArrayOf(0x1F9D2, 0x1F3FD), 0, 2), emptyList<String>(), 50, 16, false),
        TwitterEmoji(String(intArrayOf(0x1F9D2, 0x1F3FE), 0, 2), emptyList<String>(), 50, 17, false),
        TwitterEmoji(String(intArrayOf(0x1F9D2, 0x1F3FF), 0, 2), emptyList<String>(), 50, 18, false),
      ),
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F466), 0, 1), listOf("boy"), 13, 35, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F466, 0x1F3FB), 0, 2), emptyList<String>(), 13, 36, false),
        TwitterEmoji(String(intArrayOf(0x1F466, 0x1F3FC), 0, 2), emptyList<String>(), 13, 37, false),
        TwitterEmoji(String(intArrayOf(0x1F466, 0x1F3FD), 0, 2), emptyList<String>(), 13, 38, false),
        TwitterEmoji(String(intArrayOf(0x1F466, 0x1F3FE), 0, 2), emptyList<String>(), 13, 39, false),
        TwitterEmoji(String(intArrayOf(0x1F466, 0x1F3FF), 0, 2), emptyList<String>(), 13, 40, false),
      ),
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F467), 0, 1), listOf("girl"), 13, 41, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F467, 0x1F3FB), 0, 2), emptyList<String>(), 13, 42, false),
        TwitterEmoji(String(intArrayOf(0x1F467, 0x1F3FC), 0, 2), emptyList<String>(), 13, 43, false),
        TwitterEmoji(String(intArrayOf(0x1F467, 0x1F3FD), 0, 2), emptyList<String>(), 13, 44, false),
        TwitterEmoji(String(intArrayOf(0x1F467, 0x1F3FE), 0, 2), emptyList<String>(), 13, 45, false),
        TwitterEmoji(String(intArrayOf(0x1F467, 0x1F3FF), 0, 2), emptyList<String>(), 13, 46, false),
      ),
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F9D1), 0, 1), listOf("adult"), 50, 7, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F9D1, 0x1F3FB), 0, 2), emptyList<String>(), 50, 8, false),
        TwitterEmoji(String(intArrayOf(0x1F9D1, 0x1F3FC), 0, 2), emptyList<String>(), 50, 9, false),
        TwitterEmoji(String(intArrayOf(0x1F9D1, 0x1F3FD), 0, 2), emptyList<String>(), 50, 10, false),
        TwitterEmoji(String(intArrayOf(0x1F9D1, 0x1F3FE), 0, 2), emptyList<String>(), 50, 11, false),
        TwitterEmoji(String(intArrayOf(0x1F9D1, 0x1F3FF), 0, 2), emptyList<String>(), 50, 12, false),
      ),
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F471), 0, 1), listOf("person_with_blond_hair"), 23, 48, true,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F471, 0x1F3FB), 0, 2), emptyList<String>(), 23, 49, false),
        TwitterEmoji(String(intArrayOf(0x1F471, 0x1F3FC), 0, 2), emptyList<String>(), 23, 50, false),
        TwitterEmoji(String(intArrayOf(0x1F471, 0x1F3FD), 0, 2), emptyList<String>(), 23, 51, false),
        TwitterEmoji(String(intArrayOf(0x1F471, 0x1F3FE), 0, 2), emptyList<String>(), 23, 52, false),
        TwitterEmoji(String(intArrayOf(0x1F471, 0x1F3FF), 0, 2), emptyList<String>(), 23, 53, false),
      ),
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F468), 0, 1), listOf("man"), 17, 14, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F468, 0x1F3FB), 0, 2), emptyList<String>(), 17, 15, false),
        TwitterEmoji(String(intArrayOf(0x1F468, 0x1F3FC), 0, 2), emptyList<String>(), 17, 16, false),
        TwitterEmoji(String(intArrayOf(0x1F468, 0x1F3FD), 0, 2), emptyList<String>(), 17, 17, false),
        TwitterEmoji(String(intArrayOf(0x1F468, 0x1F3FE), 0, 2), emptyList<String>(), 17, 18, false),
        TwitterEmoji(String(intArrayOf(0x1F468, 0x1F3FF), 0, 2), emptyList<String>(), 17, 19, false),
      ),
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F9D4), 0, 1), listOf("bearded_person"), 50, 37, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F9D4, 0x1F3FB), 0, 2), emptyList<String>(), 50, 38, false),
        TwitterEmoji(String(intArrayOf(0x1F9D4, 0x1F3FC), 0, 2), emptyList<String>(), 50, 39, false),
        TwitterEmoji(String(intArrayOf(0x1F9D4, 0x1F3FD), 0, 2), emptyList<String>(), 50, 40, false),
        TwitterEmoji(String(intArrayOf(0x1F9D4, 0x1F3FE), 0, 2), emptyList<String>(), 50, 41, false),
        TwitterEmoji(String(intArrayOf(0x1F9D4, 0x1F3FF), 0, 2), emptyList<String>(), 50, 42, false),
      ),
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F9D4, 0x200D, 0x2642, 0xFE0F), 0, 4), listOf("man_with_beard"), 50, 31, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F9D4, 0x1F3FB, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 50, 32, false),
        TwitterEmoji(String(intArrayOf(0x1F9D4, 0x1F3FC, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 50, 33, false),
        TwitterEmoji(String(intArrayOf(0x1F9D4, 0x1F3FD, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 50, 34, false),
        TwitterEmoji(String(intArrayOf(0x1F9D4, 0x1F3FE, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 50, 35, false),
        TwitterEmoji(String(intArrayOf(0x1F9D4, 0x1F3FF, 0x200D, 0x2642, 0xFE0F), 0, 5), emptyList<String>(), 50, 36, false),
      ),
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F9D4, 0x200D, 0x2640, 0xFE0F), 0, 4), listOf("woman_with_beard"), 50, 25, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F9D4, 0x1F3FB, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 50, 26, false),
        TwitterEmoji(String(intArrayOf(0x1F9D4, 0x1F3FC, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 50, 27, false),
        TwitterEmoji(String(intArrayOf(0x1F9D4, 0x1F3FD, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 50, 28, false),
        TwitterEmoji(String(intArrayOf(0x1F9D4, 0x1F3FE, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 50, 29, false),
        TwitterEmoji(String(intArrayOf(0x1F9D4, 0x1F3FF, 0x200D, 0x2640, 0xFE0F), 0, 5), emptyList<String>(), 50, 30, false),
      ),
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F468, 0x200D, 0x1F9B0), 0, 3), listOf("red_haired_man"), 15, 30, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F468, 0x1F3FB, 0x200D, 0x1F9B0), 0, 4), emptyList<String>(), 15, 31, false),
        TwitterEmoji(String(intArrayOf(0x1F468, 0x1F3FC, 0x200D, 0x1F9B0), 0, 4), emptyList<String>(), 15, 32, false),
        TwitterEmoji(String(intArrayOf(0x1F468, 0x1F3FD, 0x200D, 0x1F9B0), 0, 4), emptyList<String>(), 15, 33, false),
        TwitterEmoji(String(intArrayOf(0x1F468, 0x1F3FE, 0x200D, 0x1F9B0), 0, 4), emptyList<String>(), 15, 34, false),
        TwitterEmoji(String(intArrayOf(0x1F468, 0x1F3FF, 0x200D, 0x1F9B0), 0, 4), emptyList<String>(), 15, 35, false),
      ),
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F468, 0x200D, 0x1F9B1), 0, 3), listOf("curly_haired_man"), 15, 36, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F468, 0x1F3FB, 0x200D, 0x1F9B1), 0, 4), emptyList<String>(), 15, 37, false),
        TwitterEmoji(String(intArrayOf(0x1F468, 0x1F3FC, 0x200D, 0x1F9B1), 0, 4), emptyList<String>(), 15, 38, false),
        TwitterEmoji(String(intArrayOf(0x1F468, 0x1F3FD, 0x200D, 0x1F9B1), 0, 4), emptyList<String>(), 15, 39, false),
        TwitterEmoji(String(intArrayOf(0x1F468, 0x1F3FE, 0x200D, 0x1F9B1), 0, 4), emptyList<String>(), 15, 40, false),
        TwitterEmoji(String(intArrayOf(0x1F468, 0x1F3FF, 0x200D, 0x1F9B1), 0, 4), emptyList<String>(), 15, 41, false),
      ),
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F468, 0x200D, 0x1F9B3), 0, 3), listOf("white_haired_man"), 15, 48, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F468, 0x1F3FB, 0x200D, 0x1F9B3), 0, 4), emptyList<String>(), 15, 49, false),
        TwitterEmoji(String(intArrayOf(0x1F468, 0x1F3FC, 0x200D, 0x1F9B3), 0, 4), emptyList<String>(), 15, 50, false),
        TwitterEmoji(String(intArrayOf(0x1F468, 0x1F3FD, 0x200D, 0x1F9B3), 0, 4), emptyList<String>(), 15, 51, false),
        TwitterEmoji(String(intArrayOf(0x1F468, 0x1F3FE, 0x200D, 0x1F9B3), 0, 4), emptyList<String>(), 15, 52, false),
        TwitterEmoji(String(intArrayOf(0x1F468, 0x1F3FF, 0x200D, 0x1F9B3), 0, 4), emptyList<String>(), 15, 53, false),
      ),
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F468, 0x200D, 0x1F9B2), 0, 3), listOf("bald_man"), 15, 42, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F468, 0x1F3FB, 0x200D, 0x1F9B2), 0, 4), emptyList<String>(), 15, 43, false),
        TwitterEmoji(String(intArrayOf(0x1F468, 0x1F3FC, 0x200D, 0x1F9B2), 0, 4), emptyList<String>(), 15, 44, false),
        TwitterEmoji(String(intArrayOf(0x1F468, 0x1F3FD, 0x200D, 0x1F9B2), 0, 4), emptyList<String>(), 15, 45, false),
        TwitterEmoji(String(intArrayOf(0x1F468, 0x1F3FE, 0x200D, 0x1F9B2), 0, 4), emptyList<String>(), 15, 46, false),
        TwitterEmoji(String(intArrayOf(0x1F468, 0x1F3FF, 0x200D, 0x1F9B2), 0, 4), emptyList<String>(), 15, 47, false),
      ),
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F469), 0, 1), listOf("woman"), 21, 34, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FB), 0, 2), emptyList<String>(), 21, 35, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FC), 0, 2), emptyList<String>(), 21, 36, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FD), 0, 2), emptyList<String>(), 21, 37, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FE), 0, 2), emptyList<String>(), 21, 38, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FF), 0, 2), emptyList<String>(), 21, 39, false),
      ),
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F469, 0x200D, 0x1F9B0), 0, 3), listOf("red_haired_woman"), 18, 59, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FB, 0x200D, 0x1F9B0), 0, 4), emptyList<String>(), 18, 60, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FC, 0x200D, 0x1F9B0), 0, 4), emptyList<String>(), 19, 0, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FD, 0x200D, 0x1F9B0), 0, 4), emptyList<String>(), 19, 1, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FE, 0x200D, 0x1F9B0), 0, 4), emptyList<String>(), 19, 2, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FF, 0x200D, 0x1F9B0), 0, 4), emptyList<String>(), 19, 3, false),
      ),
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F9D1, 0x200D, 0x1F9B0), 0, 3), listOf("red_haired_person"), 49, 14, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F9D1, 0x1F3FB, 0x200D, 0x1F9B0), 0, 4), emptyList<String>(), 49, 15, false),
        TwitterEmoji(String(intArrayOf(0x1F9D1, 0x1F3FC, 0x200D, 0x1F9B0), 0, 4), emptyList<String>(), 49, 16, false),
        TwitterEmoji(String(intArrayOf(0x1F9D1, 0x1F3FD, 0x200D, 0x1F9B0), 0, 4), emptyList<String>(), 49, 17, false),
        TwitterEmoji(String(intArrayOf(0x1F9D1, 0x1F3FE, 0x200D, 0x1F9B0), 0, 4), emptyList<String>(), 49, 18, false),
        TwitterEmoji(String(intArrayOf(0x1F9D1, 0x1F3FF, 0x200D, 0x1F9B0), 0, 4), emptyList<String>(), 49, 19, false),
      ),
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F469, 0x200D, 0x1F9B1), 0, 3), listOf("curly_haired_woman"), 19, 4, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FB, 0x200D, 0x1F9B1), 0, 4), emptyList<String>(), 19, 5, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FC, 0x200D, 0x1F9B1), 0, 4), emptyList<String>(), 19, 6, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FD, 0x200D, 0x1F9B1), 0, 4), emptyList<String>(), 19, 7, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FE, 0x200D, 0x1F9B1), 0, 4), emptyList<String>(), 19, 8, false),
        TwitterEmoji(String(intArrayOf(0x1F469, 0x1F3FF, 0x200D, 0x1F9B1), 0, 4), emptyList<String>(), 19, 9, false),
      ),
    ),
    TwitterEmoji(
      String(intArrayOf(0x1F9D1, 0x200D, 0x1F9B1), 0, 3), listOf("curly_haired_person"), 49, 20, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x1F9D1, 0x1F3FB, 0x200D, 0x1F9B1), 0, 4), emptyList<String>(), 49, 21, false),
        TwitterEmoji(String(intArrayOf(0x1F9D1, 0x1F3FC, 0x200D, 0x1F9B1), 0, 4), emptyList<String>(), 49, 22, false),
        TwitterEmoji(String(intArrayOf(0x1F9D1, 0x1F3FD, 0x200D, 0x1F9B1), 0, 4), emptyList<String>(), 49, 23, false),
        TwitterEmoji(String(intArrayOf(0x1F9D1, 0x1F3FE, 0x200D, 0x1F9B1), 0, 4), emptyList<String>(), 49, 24, false),
        TwitterEmoji(String(intArrayOf(0x1F9D1, 0x1F3FF, 0x200D, 0x1F9B1), 0, 4), emptyList<String>(), 49, 25, false),
      ),
    ),
  )
}
